"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from .checks import Checks
from .evaluations import Evaluations
from .prompts import Prompts
from .sdkconfiguration import SDKConfiguration
from .tests import Tests
from ivycheck import models, utils
from typing import Callable, Dict, Optional, Union

class Ivycheck:
    prompts: Prompts
    r"""Operations related to prompt versions."""
    tests: Tests
    r"""Operations related to prompt tests."""
    evaluations: Evaluations
    r"""Operations related to prompt evaluation."""
    checks: Checks
    r"""Operations related to IvyCheck's checks."""

    sdk_configuration: SDKConfiguration

    def __init__(self,
                 api_key: Union[Optional[str], Callable[[], Optional[str]]] = None,
                 server: str = None,
                 server_url: str = None,
                 url_params: Dict[str, str] = None,
                 client: requests_http.Session = None,
                 retry_config: utils.RetryConfig = None
                 ) -> None:
        """Instantiates the SDK configuring it with the provided parameters.
        
        :param api_key: The api_key required for authentication
        :type api_key: Union[Optional[str], Callable[[], Optional[str]]]
        :param server: The server by name to use for all operations
        :type server: str
        :param server_url: The server URL to use for all operations
        :type server_url: str
        :param url_params: Parameters to optionally template the server URL with
        :type url_params: Dict[str, str]
        :param client: The requests.Session HTTP client to use for all operations
        :type client: requests_http.Session
        :param retry_config: The utils.RetryConfig to use globally
        :type retry_config: utils.RetryConfig
        """
        if client is None:
            client = requests_http.Session()
        
        if callable(api_key):
            def security():
                return models.Security(api_key = api_key())
        else:
            security = models.Security(api_key = api_key)
        
        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        self.sdk_configuration = SDKConfiguration(client, security, server_url, server, retry_config=retry_config)
       
        self._init_sdks()
    
    def _init_sdks(self):
        self.prompts = Prompts(self.sdk_configuration)
        self.tests = Tests(self.sdk_configuration)
        self.evaluations = Evaluations(self.sdk_configuration)
        self.checks = Checks(self.sdk_configuration)
    