"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class BaseDistribution extends core_1.Construct {
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        const removalPolicy = (_d = props.removalPolicy) !== null && _d !== void 0 ? _d : core_1.RemovalPolicy.DESTROY;
        const origin = (_e = props.origin) !== null && _e !== void 0 ? _e : this.defaultOrigin(removalPolicy === core_1.RemovalPolicy.DESTROY);
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            enabled: (_f = props.enabled) !== null && _f !== void 0 ? _f : true,
            enableIpv6: (_g = props.enableIpv6) !== null && _g !== void 0 ? _g : true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: (_h = props.priceClass) !== null && _h !== void 0 ? _h : aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: (_j = props.httpVersion) !== null && _j !== void 0 ? _j : aws_cloudfront_1.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            minimumProtocolVersion: props.minimumProtocolVersion,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: this.renderDefaultBehaviour(origin, props.authorization),
            additionalBehaviors: this.renderAdditionalBehaviors(origin, props.authorization),
            defaultRootObject: (_k = props.defaultRootObject) !== null && _k !== void 0 ? _k : 'index.html',
        });
        const callbackUrls = (_m = (_l = props.domainNames) === null || _l === void 0 ? void 0 : _l.map((name) => `https://${name}${props.authorization.redirectPaths.signIn}`)) !== null && _m !== void 0 ? _m : [];
        const logoutUrls = (_p = (_o = props.domainNames) === null || _o === void 0 ? void 0 : _o.map((name) => `https://${name}${props.authorization.redirectPaths.signOut}`)) !== null && _p !== void 0 ? _p : [];
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`, ...callbackUrls],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`, ...logoutUrls],
        });
        this.domainName = distribution.domainName;
        this.distributionDomainName = distribution.distributionDomainName;
        this.distributionId = distribution.distributionId;
        this.stack = core_1.Stack.of(this);
        this.env = {
            account: this.stack.account,
            region: this.stack.region,
        };
    }
    renderDefaultBehaviour(origin, authorization) {
        return authorization.createDefaultBehavior(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_DISABLED,
        });
    }
    renderAdditionalBehaviors(origin, authorization) {
        return authorization.createAdditionalBehaviors(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_DISABLED,
        });
    }
    defaultOrigin(forceDelete) {
        const bucket = new cdk_deletable_bucket_1.DeletableBucket(this, 'DeletableBucket', {
            forceDelete,
        });
        return new aws_cloudfront_origins_1.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
_a = JSII_RTTI_SYMBOL_1;
BaseDistribution[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.BaseDistribution", version: "1.24.0" };
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
_b = JSII_RTTI_SYMBOL_1;
StaticSiteDistribution[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteDistribution", version: "1.24.0" };
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        var _d;
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: (_d = props.ttl) !== null && _d !== void 0 ? _d : core_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
_c = JSII_RTTI_SYMBOL_1;
SpaDistribution[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaDistribution", version: "1.24.0" };
//# sourceMappingURL=data:application/json;base64,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