from __future__ import print_function
import numpy as np
import matplotlib.pyplot as plt
from astropy import units as u
from astropy import cosmology
from astropy.coordinates import Distance
from flarestack.shared import plot_output_dir

dist_mpc = np.array([
    16.923825229338462, 32.97316137457628, 35.443873873822106,
    51.44937544096303, 53.80572948117582, 53.888323479517865, 66.23342142256487,
    69.9197043735904, 74.06754396710411, 81.3478157935718, 97.54610659055105,
    108.74746875813437, 118.83083908718149, 131.18342061998388,
    143.97907581452046, 161.24962678364008, 178.377703942223,
    201.0834139865358, 219.68400818563615, 244.54961910081758,
    273.7426110901313, 306.4701455195948, 341.4583711087404,
    377.1570538736583, 417.6388575317782, 464.5998464173732
])
e_per_source = [
    6.927367458689707e+49, 4.339768017557287e+49, 3.167879207389398e+49,
    2.7087786440651e+49, 2.38660086466942e+49, 2.145228184643312e+49,
    1.9556478236997226e+49, 1.5576837378149184e+49, 1.4111278719180155e+49,
    1.248036023460357e+49, 1.0588467615743175e+49, 9.238099772561746e+48,
    8.213439466933067e+48, 2.568183182618944e+49, 2.4482922082464026e+49,
    2.083519196979608e+49, 2.118242916106504e+49, 2.0482369868831354e+49,
    2.319910748260956e+49, 2.1491755658640934e+49, 2.2437151717465864e+49,
    2.0639431899176516e+49, 2.0344270956535665e+49, 2.089541046502109e+49,
    2.25853751340615e+49, 2.030314563238197e+49
]

n = [
    1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 11.0, 13.0, 16.0, 22.0, 29.0, 40.0,
    58.0, 79.0, 104.0, 145.0, 202.0, 281.0, 392.0, 530.0, 722.0, 986.0,
    1340.0, 1842.0, 2570.0
]

disc = [
    6.3859852129837405e+44, 7.815868649313232e+42, 3.6134023859374993e+43,
    3.113371620728157e+43, 1.3362016711943853e+34, 2.0391507422076078e+44,
    np.nan, 1.5297311429456913e+50, 1.2405910280432744e+50, np.nan,
    6.997817458802234e+49, np.nan, 1.0892622349494232e+50,
    9.083837244328854e+49, -1.6681279919378288e+51, 8.478839258207428e+49,
    8.105037392489653e+49, 8.337753034670461e+49, 8.149846392365348e+49,
    8.225600142986851e+49, 7.780114890394365e+49, 7.786759130127634e+49,
    7.787456191656473e+49, 7.811685713236478e+49, 7.692888704265783e+49,
    7.592978045804951e+49
]

mask = dist_mpc < 120.


zs = [Distance(Distance(dl * u.Mpc)).compute_z() for dl in dist_mpc[mask]]

print(zs)

x = np.log(zs)
y = np.log(np.array(e_per_source)[mask])


[m, c] = np.polyfit(x, y, 1)

def f(x):
    return np.exp(m * np.log(x) + c)

name_root = "analyses/ztf/depth/"
save_dir = plot_output_dir(name_root)
print(save_dir)

plt.figure()
# plt.scatter(zs, np.array(e_per_source)[mask])
# plt.scatter(zs, np.array(e_per_source)[mask])
# plt.plot([0.001, 0.1], f([0.001, 0.1]))

x = np.linspace(0.001, 0.1, 1e3)

plt.plot(x, f(x), color="orange")
plt.yscale("log")
# plt.xscale("log")
plt.xlabel("Redshift")
plt.ylabel(r"$E_{\nu}$ per source")
# plt.plot(np.array(dist_mpc)[mask], np.array(disc)[mask])
plt.savefig(save_dir + "plot.pdf")
plt.close()
