from enum import Enum


class UserMatch(Enum):
    MATCH_TYPE_BEGINSWITH = 1
    MATCH_TYPE_CONTAINS = 2
    MATCH_TYPE_EQUALS = 0
    MATCH_WITH_CA = 5
    MATCH_WITH_CERTIFICATEPROFILE = 4
    MATCH_WITH_COMMONNAME = 101
    MATCH_WITH_COUNTRY = 112
    MATCH_WITH_DN = 7
    MATCH_WITH_DNSERIALNUMBER = 102
    MATCH_WITH_DOMAINCOMPONENT = 111
    MATCH_WITH_EMAIL = 1
    MATCH_WITH_ENDENTITYPROFILE = 3
    MATCH_WITH_GIVENNAME = 103
    MATCH_WITH_INITIALS = 104
    MATCH_WITH_LOCALE = 109
    MATCH_WITH_ORGANIZATION = 108
    MATCH_WITH_ORGANIZATIONUNIT = 107
    MATCH_WITH_STATE = 110
    MATCH_WITH_STATUS = 2
    MATCH_WITH_SURNAME = 105
    MATCH_WITH_TITLE = 106
    MATCH_WITH_TOKEN = 6
    MATCH_WITH_UID = 100
    MATCH_WITH_USERNAME = 0


class UserDataVOWS:
    STATUS_FAILED = 11
    STATUS_GENERATED = 40
    STATUS_HISTORICAL = 60
    STATUS_INITIALIZED = 20
    STATUS_INPROCESS = 30
    STATUS_KEYRECOVERY = 70
    STATUS_NEW = 10
    STATUS_REVOKED = 50
    TOKEN_TYPE_JKS = "JKS"
    TOKEN_TYPE_P12 = "P12"
    TOKEN_TYPE_PEM = "PEM"
    TOKEN_TYPE_USERGENERATED = "USERGENERATED"


class AlgorithmConstants:
    KEYALGORITHM_DSA = "DSA"
    KEYALGORITHM_DSTU4145 = "DSTU4145"
    KEYALGORITHM_EC = "EC"
    KEYALGORITHM_ECDSA = "ECDSA"
    KEYALGORITHM_ECGOST3410 = "ECGOST3410"
    KEYALGORITHM_RSA = "RSA"
    KEYSPECPREFIX_ECGOST3410 = "GostR3410-"
    SIGALG_GOST3411_WITH_DSTU4145 = "GOST3411withDSTU4145"
    SIGALG_GOST3411_WITH_ECGOST3410 = "GOST3411withECGOST3410"
    SIGALG_MD5_WITH_RSA = "MD5WithRSA"
    SIGALG_SHA1_WITH_DSA = "SHA1WithDSA"
    SIGALG_SHA1_WITH_ECDSA = "SHA1withECDSA"
    SIGALG_SHA1_WITH_RSA = "SHA1WithRSA"
    SIGALG_SHA1_WITH_RSA_AND_MGF1 = "SHA1withRSAandMGF1"
    SIGALG_SHA224_WITH_ECDSA = "SHA224withECDSA"
    SIGALG_SHA256_WITH_ECDSA = "SHA256withECDSA"
    SIGALG_SHA256_WITH_RSA = "SHA256WithRSA"
    SIGALG_SHA256_WITH_RSA_AND_MGF1 = "SHA256withRSAandMGF1"
    SIGALG_SHA3_256_WITH_ECDSA = "SHA3-256withECDSA"
    SIGALG_SHA3_256_WITH_RSA = "SHA3-256withRSA"
    SIGALG_SHA3_384_WITH_ECDSA = "SHA3-384withECDSA"
    SIGALG_SHA3_384_WITH_RSA = "SHA3-384withRSA"
    SIGALG_SHA3_512_WITH_ECDSA = "SHA3-512withECDSA"
    SIGALG_SHA3_512_WITH_RSA = "SHA3-512withRSA"
    SIGALG_SHA384_WITH_ECDSA = "SHA384withECDSA"
    SIGALG_SHA384_WITH_RSA = "SHA384WithRSA"
    SIGALG_SHA384_WITH_RSA_AND_MGF1 = "SHA384withRSAandMGF1"
    SIGALG_SHA512_WITH_ECDSA = "SHA512withECDSA"
    SIGALG_SHA512_WITH_RSA = "SHA512WithRSA"
    SIGALG_SHA512_WITH_RSA_AND_MGF1 = "SHA512withRSAandMGF1"


class CertificateHelper:
    CERT_REQ_TYPE_CRMF = 1
    CERT_REQ_TYPE_PKCS10 = 0
    CERT_REQ_TYPE_PUBLICKEY = 3
    CERT_REQ_TYPE_SPKAC = 2
    RESPONSETYPE_CERTIFICATE = "CERTIFICATE"
    RESPONSETYPE_PKCS7 = "PKCS7"
    RESPONSETYPE_PKCS7WITHCHAIN = "PKCS7WITHCHAIN"
