"""
This type stub file was generated by pyright.
"""

from inspect import Parameter, Signature, _ParameterKind
from typing import Any, Callable, Collection, Dict, Generator, List, NamedTuple, Optional, Protocol, Sequence, Tuple, Type, TypeVar, Union
from jdv_funcutils.utils import Null
from jdv_funcutils.utils.repr_utils import ReprMixin

"""
This type stub file was generated by pyright.
"""
_T = TypeVar("_T")
_Type = TypeVar("_Type", bound=Type[object])
SignatureLike = Union[Callable[..., Any], Signature, List[Parameter]]
class SignatureException(Exception):
    ...


class SignatureMissingParameterException(Exception):
    ...


class ParameterKind:
    POSITIONAL_OR_KEYWORD = ...
    POSITIONAL_ONLY = ...
    KEYWORD_ONLY = ...
    VAR_POSITIONAL = ...
    VAR_KEYWORD = ...


class ParameterLike(Protocol):
    name: str
    default: Any
    annotation: Any
    kind: _ParameterKind
    ...


def tuple_type_constructor(annotations_list: List[Any], tuple_cls=...) -> Type:
    ...

def named_tuple_type_constructor(annotations_list: Sequence[Any], names: List[str]) -> Type[NamedTuple]:
    ...

class ParameterLocation(NamedTuple):
    param_index: int
    relative_index_to_kind: int
    param: MutableParameter
    ...


class MutableParameter(ParameterLike):
    __slots__ = ...
    POSITIONAL_OR_KEYWORD = ...
    POSITIONAL_ONLY = ...
    KEYWORD_ONLY = ...
    VAR_POSITIONAL = ...
    VAR_KEYWORD = ...
    def __init__(self, name: str, default: Any, annotation: Any, kind: _ParameterKind) -> None:
        ...
    
    @classmethod
    def from_parameter(cls, param: Parameter) -> MutableParameter:
        ...
    
    def to_parameter(self) -> Parameter:
        ...
    
    def is_positional(self):
        ...
    
    def is_positional_only(self):
        ...
    
    def is_keyword(self):
        ...
    
    def is_keyword_only(self):
        ...
    
    def __eq__(self, other: object) -> bool:
        ...
    
    def __str__(self) -> str:
        ...
    
    def __repr__(self):
        ...
    


_Param = Union[Parameter, MutableParameter]
class MutableSignature(Sequence[MutableParameter]):
    ParameterKind = ...
    KEYWORD_ONLY = ...
    POSITIONAL_OR_KEYWORD = ...
    POSITIONAL_ONLY = ...
    VAR_POSITIONAL = ...
    VAR_KEYWORD = ...
    def __init__(self, obj: Optional[Union[Callable[..., Any], Signature, List[Parameter]]] = ..., return_annotation: Any = ...) -> None:
        ...
    
    def partition(self, fn: Callable[[MutableParameter], bool]) -> Tuple[MutableSignature, MutableSignature]:
        """Partition the signature using a partition function.

        :param fn: The partition function taking a MutableParameter and returning a boolean.
        :return: Tuple of MutableSignature either passing the function (first in the tuple) or not passing the
            function (second in the tuple)
        """
        ...
    
    @property
    def params(self) -> Tuple[MutableParameter, ...]:
        ...
    
    def fix_signature(self):
        ...
    
    def is_valid(self) -> bool:
        """Returns if parameters for a valid signature.

        If not, see `fix_signature` to fix and invalid signature.
        :return:
        """
        ...
    
    def clear_and_add_all(self, params: Sequence[_Param]):
        ...
    
    def get_signature_parameters(self) -> Tuple[Parameter]:
        ...
    
    def to_signature(self):
        ...
    
    def get_pos_and_param(self, key: Union[int, str, _Param], strict: bool = ...) -> ParameterLocation:
        ...
    
    def get_param(self, key: Union[int, str, _Param], strict: bool = ...) -> MutableParameter:
        ...
    
    def get_params(self, fn: Optional[Callable[[_Param], bool]] = ...) -> Tuple[MutableParameter, ...]:
        ...
    
    def get_pos_params(self) -> Tuple[MutableParameter, ...]:
        ...
    
    def get_pos_only_params(self) -> Tuple[MutableParameter, ...]:
        ...
    
    def get_kw_params(self) -> Tuple[MutableParameter, ...]:
        ...
    
    def get_kw_only_params(self) -> Tuple[MutableParameter, ...]:
        ...
    
    def __len__(self):
        ...
    
    def __getitem__(self, key: Union[str, int, _Param]):
        ...
    
    def __contains__(self, item: Union[int, str]):
        ...
    
    def __delitem__(self, key: Union[str, int, _Param]):
        ...
    
    def add(self, param: Union[str, MutableParameter, Parameter], annotation: Any = ..., *, default: Any = ..., kind: Union[Null, ParameterKind] = ..., index: int = ...):
        ...
    
    def insert(self, index: int, param: Union[str, MutableParameter, Parameter], annotation: Any = ..., *, default: Any = ..., kind: Union[Null, ParameterKind] = ...):
        ...
    
    def remove(self, param: Union[str, int, MutableParameter, Parameter]):
        ...
    
    def __str__(self) -> str:
        ...
    
    def __repr__(self):
        ...
    
    def __iter__(self):
        ...
    
    def pack(self, from_params: Sequence[Union[int, str]], name: Optional[str] = ..., position: int = ..., kind: _ParameterKind = ...):
        """Pack a set of parameters into a single parameter.

        Examples:

        .. testsetup:: *

           import funcutils

        .. testcode::
            def fn1(a: int, b: float, c: str, d: list):
                return a, b, c, d

            s = MutableSignature(fn1)
            s.pack(('a', 'c', 'd'), position=1)
            str(s.to_signature())

        .. testoutput::

            (b: float, a__c__d: Tuple[int, str, list])

        :param from_params: Parameters to pack
        :param name: Optional name to give the new packed parameter.
            If not provided, parameter names will be joined with '__' (e.g. a, b, c => 'a__b__c')
        :param position: Position to insert the new packed parameter. Note that the position is
            relative to the parameter kind. PositionalOnly, PositionalOrKeyword, PositionalVar,
            KeywordOnly, KeywordVar
        :param kind: Parameter kind to give the new packed parameter.
        :return:
        """
        ...
    
    def bind(self, *args: Any, **kwargs: Any) -> BoundSignature:
        ...
    
    def reorder(self, *params: Union[int, str, Parameter, MutableParameter]):
        """Attempt to reorder the signature. Note that parameters of different
        kinds cannot be re-ordered.

        :param params:
        :return:
        """
        ...
    
    def transform(self, f: Callable[..., _T], name: Optional[str] = ...):
        ...
    


class MutableParameterTuple(MutableParameter):
    def __init__(self, parameters: List[MutableParameter], annotation: Any = ..., name: Optional[str] = ..., default: Any = ..., kind: _ParameterKind = ...) -> None:
        ...
    


class ParameterValue(ReprMixin):
    __slots__ = ...
    def __init__(self, key: Union[str, int], value: Any = ..., mutable_parameter: Union[MutableParameter, Null] = ...) -> None:
        ...
    
    @property
    def name(self) -> Union[None, str]:
        ...
    
    def is_bound(self) -> bool:
        """Returns true if Parameter has value and parameter defined.

        :return:
        """
        ...
    
    def is_missing_parameter(self) -> bool:
        """Returns True if ParameterValue has a value defined but no parameter
        associated.

        :return:
        """
        ...
    
    def is_missing_value(self) -> bool:
        """Returns True if ParameterValue has a parameter associated but no
        value.

        :return:
        """
        ...
    
    def __eq__(self, other: object) -> bool:
        ...
    


class BoundParamValue(ParameterValue):
    key: Union[str, int]
    value: Any
    mutable_parameter: MutableParameter
    ...


class ParamValueMissingParam(ParameterValue):
    key: Union[str, int]
    value: Any
    mutable_parameter: Null
    ...


class ParamValueMissingValue(ParameterValue):
    key: Union[str, int]
    value: Null
    mutable_parameter: MutableParameter
    ...


class BoundSignature(Collection[ParameterValue]):
    def __init__(self, signature: Union[MutableSignature, SignatureLike], *args: Any, **kwargs: Any) -> None:
        ...
    
    def partition(self, fn: Callable[[ParameterValue], bool]) -> Tuple[BoundSignature, BoundSignature]:
        """Partition the signature using a partition function.

        :param fn: The partition function taking a ParameterValue and returning a boolean.
        :return: Tuple of BoundSignatures either passing the function (first in the tuple) or not passing the
            function (second in the tuple)
        """
        ...
    
    def bind(self, *args: Any, **kwargs: Any) -> BoundSignature:
        ...
    
    def get_args(self, bound: bool = ...) -> Tuple[Any, ...]:
        ...
    
    def get_kwargs(self, bound: bool = ...) -> Dict[str, Any]:
        ...
    
    @property
    def args(self) -> Tuple[Any, ...]:
        """Return the bound arguments as a tuple of values.

        :return:
        """
        ...
    
    @property
    def kwargs(self) -> Dict[str, Any]:
        """
        Return the bound keyword args as a dict of values
        :return:
        """
        ...
    
    @property
    def bound(self) -> Tuple[BoundParamValue, ...]:
        ...
    
    @property
    def params_missing_values(self) -> Tuple[ParamValueMissingValue, ...]:
        ...
    
    @property
    def values_missing_params(self) -> Tuple[ParamValueMissingParam, ...]:
        ...
    
    @property
    def args_missing_params(self) -> Tuple[Any, ...]:
        """Return the unbound args as a tuple of values.

        :return:
        """
        ...
    
    @property
    def kwargs_missing_params(self) -> Dict[str, Any]:
        """
        Return the unbound keyword args as a dict of values
        :return:
        """
        ...
    
    def get(self, item: Union[int, str]) -> Optional[ParameterValue]:
        ...
    
    def has_extra_args(self) -> bool:
        """Returns True if there are any unbound values.

        :return: bool
        """
        ...
    
    def has_missing_values(self) -> bool:
        """Return True if there are any unbound parameters.

        :return: bool
        """
        ...
    
    def has_valid_signature(self) -> bool:
        """Return True if there are no unbound parameters.

        :return: bool
        """
        ...
    
    def is_valid(self):
        """Returns True if there are no unbound parameters and no unbound
        values.

        :return: bool
        """
        ...
    
    def bound_signature(self, return_annotation: Any = ...) -> MutableSignature:
        ...
    
    def unbound_signature(self, return_annotation: Any = ...) -> MutableSignature:
        ...
    
    def __getitem__(self, item: Union[str, int]) -> Union[None, ParameterValue]:
        ...
    
    def __len__(self) -> int:
        ...
    
    def __contains__(self, item: object) -> bool:
        ...
    
    def __iter__(self) -> Generator[ParameterValue, None, None]:
        ...
    


