# nonebot_plugin_blive_danmaku
- 基于[nonebot2](https://v2.nonebot.dev/)开发的B站直播间弹幕监听Bot，参考了Haruka和blivechat的部分代码。  
- 起源于[哈鹿hallu](https://space.bilibili.com/3493118494116797)的一条动态，苦于做视频时没有人做路灯，翻录播的时候头都大了，说要花钱请个全职路灯，我寻思与其把钱送给别人，不如交给Bot去做路灯。

## 功能

- 用弹幕的形式记录直播高能点
- 弹幕指令为`#路灯`加上记录的内容
- 仅在开播时弹幕指令才会生效

## 安装
- 使用`nb-cli`安装插件  
```
nb plugin install nonebot_plugin_blive_danmaku
```

## 指令

|指令|说明|
|------|------|
|/添加订阅 UID|UID为B站用户的uid，不是直播间id，以下同理|
|/取消订阅 UID|删除订阅|
|/开启路灯 UID|开启直播间弹幕监听|
|/关闭路灯 UID|关闭直播间弹幕监听|
|/订阅列表|| 

## 效果预览 

![picture][base64str]

## 更新日志  
- v0.1.2
    - fix局部变量无法正常更新的bug
- v0.1.0
    - 基于nonebot2，实现同步路灯弹幕到qq群  

## 感谢
- [HarukaBot](https://github.com/SK-415/HarukaBot)
- [blivechat](https://github.com/xfgryujk/blivechat)
- [nonebot2](https://v2.nonebot.dev/)


[base64str]:data:image/png;base64,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