# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDatasetsResult',
    'AwaitableGetDatasetsResult',
    'get_datasets',
    'get_datasets_output',
]

@pulumi.output_type
class GetDatasetsResult:
    """
    A collection of values returned by GetDatasets.
    """
    def __init__(__self__, id=None, names=None, slugs=None, starts_with=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if slugs and not isinstance(slugs, list):
            raise TypeError("Expected argument 'slugs' to be a list")
        pulumi.set(__self__, "slugs", slugs)
        if starts_with and not isinstance(starts_with, str):
            raise TypeError("Expected argument 'starts_with' to be a str")
        pulumi.set(__self__, "starts_with", starts_with)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        a list of all the dataset names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def slugs(self) -> Sequence[str]:
        """
        a list of all the dataset slugs.
        """
        return pulumi.get(self, "slugs")

    @property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> Optional[str]:
        return pulumi.get(self, "starts_with")


class AwaitableGetDatasetsResult(GetDatasetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetsResult(
            id=self.id,
            names=self.names,
            slugs=self.slugs,
            starts_with=self.starts_with)


def get_datasets(starts_with: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetsResult:
    """
    ## # Data Source: _get_datasets

    The datasets data source allows the datasets of an account to be retrieved.


    :param str starts_with: Only return datasets starting with the given value.
    """
    __args__ = dict()
    __args__['startsWith'] = starts_with
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('honeycomb:index/getDatasets:GetDatasets', __args__, opts=opts, typ=GetDatasetsResult).value

    return AwaitableGetDatasetsResult(
        id=__ret__.id,
        names=__ret__.names,
        slugs=__ret__.slugs,
        starts_with=__ret__.starts_with)


@_utilities.lift_output_func(get_datasets)
def get_datasets_output(starts_with: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatasetsResult]:
    """
    ## # Data Source: _get_datasets

    The datasets data source allows the datasets of an account to be retrieved.


    :param str starts_with: Only return datasets starting with the given value.
    """
    ...
