"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        const conditions = [];
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        const conditions = [];
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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