# coding: utf-8

"""
    Pure Storage FlashBlade REST 1.10 Python SDK

    Pure Storage FlashBlade REST 1.10 Python SDK. Compatible with REST API versions 1.0 - 1.10. Developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

    OpenAPI spec version: 1.10
    Contact: info@purestorage.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class CertificatesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_certificate_certificate_groups(self, **kwargs):
        """
        Add certificates to certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_certificate_certificate_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :return: MemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_certificate_certificate_groups_with_http_info(**kwargs)
        else:
            (data) = self.add_certificate_certificate_groups_with_http_info(**kwargs)
            return data

    def add_certificate_certificate_groups_with_http_info(self, **kwargs):
        """
        Add certificates to certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_certificate_certificate_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :return: MemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_group_ids', 'certificate_group_names', 'certificate_ids', 'certificate_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_certificate_certificate_groups" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'certificate_group_ids' in params:
            query_params.append(('certificate_group_ids', params['certificate_group_ids']))
            collection_formats['certificate_group_ids'] = 'csv'
        if 'certificate_group_names' in params:
            query_params.append(('certificate_group_names', params['certificate_group_names']))
            collection_formats['certificate_group_names'] = 'csv'
        if 'certificate_ids' in params:
            query_params.append(('certificate_ids', params['certificate_ids']))
            collection_formats['certificate_ids'] = 'csv'
        if 'certificate_names' in params:
            query_params.append(('certificate_names', params['certificate_names']))
            collection_formats['certificate_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/1.10/certificates/certificate-groups', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_certificates(self, certificate, **kwargs):
        """
        Create certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_certificates(certificate, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificatePost certificate: (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_certificates_with_http_info(certificate, **kwargs)
        else:
            (data) = self.create_certificates_with_http_info(certificate, **kwargs)
            return data

    def create_certificates_with_http_info(self, certificate, **kwargs):
        """
        Create certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_certificates_with_http_info(certificate, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificatePost certificate: (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate', 'names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificate' is set
        if ('certificate' not in params) or (params['certificate'] is None):
            raise ValueError("Missing the required parameter `certificate` when calling `create_certificates`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificate' in params:
            body_params = params['certificate']
        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.10/certificates', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_certificates(self, **kwargs):
        """
        Delete certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_certificates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_certificates_with_http_info(**kwargs)
        else:
            (data) = self.delete_certificates_with_http_info(**kwargs)
            return data

    def delete_certificates_with_http_info(self, **kwargs):
        """
        Delete certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_certificates_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificates" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.10/certificates', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_certificate_certificate_groups(self, **kwargs):
        """
        List certificates' certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificate_certificate_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :param str filter: The filter to be used for query.
        :param int limit: limit, should be >= 0
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: MemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_certificate_certificate_groups_with_http_info(**kwargs)
        else:
            (data) = self.list_certificate_certificate_groups_with_http_info(**kwargs)
            return data

    def list_certificate_certificate_groups_with_http_info(self, **kwargs):
        """
        List certificates' certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificate_certificate_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :param str filter: The filter to be used for query.
        :param int limit: limit, should be >= 0
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: MemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_group_ids', 'certificate_group_names', 'certificate_ids', 'certificate_names', 'filter', 'limit', 'sort', 'start', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificate_certificate_groups" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'certificate_group_ids' in params:
            query_params.append(('certificate_group_ids', params['certificate_group_ids']))
            collection_formats['certificate_group_ids'] = 'csv'
        if 'certificate_group_names' in params:
            query_params.append(('certificate_group_names', params['certificate_group_names']))
            collection_formats['certificate_group_names'] = 'csv'
        if 'certificate_ids' in params:
            query_params.append(('certificate_ids', params['certificate_ids']))
            collection_formats['certificate_ids'] = 'csv'
        if 'certificate_names' in params:
            query_params.append(('certificate_names', params['certificate_names']))
            collection_formats['certificate_names'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/1.10/certificates/certificate-groups', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_certificate_uses(self, **kwargs):
        """
        List certificate uses.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificate_uses(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param int limit: limit, should be >= 0
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: CertificateUseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_certificate_uses_with_http_info(**kwargs)
        else:
            (data) = self.list_certificate_uses_with_http_info(**kwargs)
            return data

    def list_certificate_uses_with_http_info(self, **kwargs):
        """
        List certificate uses.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificate_uses_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param int limit: limit, should be >= 0
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: CertificateUseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'ids', 'names', 'limit', 'sort', 'start', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificate_uses" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.10/certificates/uses', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateUseResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_certificates(self, **kwargs):
        """
        List certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param int limit: limit, should be >= 0
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_certificates_with_http_info(**kwargs)
        else:
            (data) = self.list_certificates_with_http_info(**kwargs)
            return data

    def list_certificates_with_http_info(self, **kwargs):
        """
        List certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_certificates_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param int limit: limit, should be >= 0
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'ids', 'limit', 'names', 'sort', 'start', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificates" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.10/certificates', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_certificate_certificate_groups(self, **kwargs):
        """
        Remove certificates from certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_certificate_certificate_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_certificate_certificate_groups_with_http_info(**kwargs)
        else:
            (data) = self.remove_certificate_certificate_groups_with_http_info(**kwargs)
            return data

    def remove_certificate_certificate_groups_with_http_info(self, **kwargs):
        """
        Remove certificates from certificate groups.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_certificate_certificate_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] certificate_group_ids: A comma-separated list of certificate group ids. This cannot be provided together with the certificate group names query parameters.
        :param list[str] certificate_group_names: A comma-separated list of certificate group names. This cannot be provided together with the certificate group ids query parameters.
        :param list[str] certificate_ids: A comma-separated list of certificate ids. This cannot be provided together with the certificate names query parameters.
        :param list[str] certificate_names: A comma-separated list of certificate names. This cannot be provided together with the certificate ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_group_ids', 'certificate_group_names', 'certificate_ids', 'certificate_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_certificate_certificate_groups" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'certificate_group_ids' in params:
            query_params.append(('certificate_group_ids', params['certificate_group_ids']))
            collection_formats['certificate_group_ids'] = 'csv'
        if 'certificate_group_names' in params:
            query_params.append(('certificate_group_names', params['certificate_group_names']))
            collection_formats['certificate_group_names'] = 'csv'
        if 'certificate_ids' in params:
            query_params.append(('certificate_ids', params['certificate_ids']))
            collection_formats['certificate_ids'] = 'csv'
        if 'certificate_names' in params:
            query_params.append(('certificate_names', params['certificate_names']))
            collection_formats['certificate_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/1.10/certificates/certificate-groups', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_certificates(self, certificate, **kwargs):
        """
        Update certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_certificates(certificate, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Certificate certificate: (required)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_certificates_with_http_info(certificate, **kwargs)
        else:
            (data) = self.update_certificates_with_http_info(certificate, **kwargs)
            return data

    def update_certificates_with_http_info(self, certificate, **kwargs):
        """
        Update certificates.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_certificates_with_http_info(certificate, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Certificate certificate: (required)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate', 'ids', 'names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificate' is set
        if ('certificate' not in params) or (params['certificate'] is None):
            raise ValueError("Missing the required parameter `certificate` when calling `update_certificates`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificate' in params:
            body_params = params['certificate']
        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.10/certificates', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
