# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.20.118
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from velo_payments.configuration import Configuration


class FundingAudit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amount': 'float',
        'date_time': 'datetime',
        'status': 'str',
        'currency': 'str',
        'source_account_name': 'str',
        'funding_account_name': 'str',
        'funding_type': 'str',
        'events': 'list[FundingEvent]',
        'topup_type': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'date_time': 'dateTime',
        'status': 'status',
        'currency': 'currency',
        'source_account_name': 'sourceAccountName',
        'funding_account_name': 'fundingAccountName',
        'funding_type': 'fundingType',
        'events': 'events',
        'topup_type': 'topupType'
    }

    def __init__(self, amount=None, date_time=None, status=None, currency=None, source_account_name=None, funding_account_name=None, funding_type=None, events=None, topup_type=None, local_vars_configuration=None):  # noqa: E501
        """FundingAudit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amount = None
        self._date_time = None
        self._status = None
        self._currency = None
        self._source_account_name = None
        self._funding_account_name = None
        self._funding_type = None
        self._events = None
        self._topup_type = None
        self.discriminator = None

        if amount is not None:
            self.amount = amount
        if date_time is not None:
            self.date_time = date_time
        if status is not None:
            self.status = status
        if currency is not None:
            self.currency = currency
        if source_account_name is not None:
            self.source_account_name = source_account_name
        if funding_account_name is not None:
            self.funding_account_name = funding_account_name
        if funding_type is not None:
            self.funding_type = funding_type
        if events is not None:
            self.events = events
        if topup_type is not None:
            self.topup_type = topup_type

    @property
    def amount(self):
        """Gets the amount of this FundingAudit.  # noqa: E501


        :return: The amount of this FundingAudit.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this FundingAudit.


        :param amount: The amount of this FundingAudit.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def date_time(self):
        """Gets the date_time of this FundingAudit.  # noqa: E501


        :return: The date_time of this FundingAudit.  # noqa: E501
        :rtype: datetime
        """
        return self._date_time

    @date_time.setter
    def date_time(self, date_time):
        """Sets the date_time of this FundingAudit.


        :param date_time: The date_time of this FundingAudit.  # noqa: E501
        :type: datetime
        """

        self._date_time = date_time

    @property
    def status(self):
        """Gets the status of this FundingAudit.  # noqa: E501


        :return: The status of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this FundingAudit.


        :param status: The status of this FundingAudit.  # noqa: E501
        :type: str
        """
        allowed_values = ["PENDING", "FAILED", "CREDIT", "DEBIT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def currency(self):
        """Gets the currency of this FundingAudit.  # noqa: E501


        :return: The currency of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this FundingAudit.


        :param currency: The currency of this FundingAudit.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def source_account_name(self):
        """Gets the source_account_name of this FundingAudit.  # noqa: E501


        :return: The source_account_name of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._source_account_name

    @source_account_name.setter
    def source_account_name(self, source_account_name):
        """Sets the source_account_name of this FundingAudit.


        :param source_account_name: The source_account_name of this FundingAudit.  # noqa: E501
        :type: str
        """

        self._source_account_name = source_account_name

    @property
    def funding_account_name(self):
        """Gets the funding_account_name of this FundingAudit.  # noqa: E501


        :return: The funding_account_name of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._funding_account_name

    @funding_account_name.setter
    def funding_account_name(self, funding_account_name):
        """Sets the funding_account_name of this FundingAudit.


        :param funding_account_name: The funding_account_name of this FundingAudit.  # noqa: E501
        :type: str
        """

        self._funding_account_name = funding_account_name

    @property
    def funding_type(self):
        """Gets the funding_type of this FundingAudit.  # noqa: E501


        :return: The funding_type of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._funding_type

    @funding_type.setter
    def funding_type(self, funding_type):
        """Sets the funding_type of this FundingAudit.


        :param funding_type: The funding_type of this FundingAudit.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACH", "WIRE", "EMBEDDED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and funding_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `funding_type` ({0}), must be one of {1}"  # noqa: E501
                .format(funding_type, allowed_values)
            )

        self._funding_type = funding_type

    @property
    def events(self):
        """Gets the events of this FundingAudit.  # noqa: E501


        :return: The events of this FundingAudit.  # noqa: E501
        :rtype: list[FundingEvent]
        """
        return self._events

    @events.setter
    def events(self, events):
        """Sets the events of this FundingAudit.


        :param events: The events of this FundingAudit.  # noqa: E501
        :type: list[FundingEvent]
        """

        self._events = events

    @property
    def topup_type(self):
        """Gets the topup_type of this FundingAudit.  # noqa: E501


        :return: The topup_type of this FundingAudit.  # noqa: E501
        :rtype: str
        """
        return self._topup_type

    @topup_type.setter
    def topup_type(self, topup_type):
        """Sets the topup_type of this FundingAudit.


        :param topup_type: The topup_type of this FundingAudit.  # noqa: E501
        :type: str
        """
        allowed_values = ["AUTOMATIC", "MANUAL"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and topup_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `topup_type` ({0}), must be one of {1}"  # noqa: E501
                .format(topup_type, allowed_values)
            )

        self._topup_type = topup_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FundingAudit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FundingAudit):
            return True

        return self.to_dict() != other.to_dict()
