#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['weasyprint',
 'weasyprint.css',
 'weasyprint.css.validation',
 'weasyprint.layout',
 'weasyprint.svg']

package_data = \
{'': ['*'], 'weasyprint': ['formatting_structure/*', 'text/*', 'tools/*']}

install_requires = \
['pydyf >=0.0.1',
 'cffi >=0.6',
 'html5lib >=1.0.1',
 'tinycss2 >=1.0.0',
 'cssselect2 >=0.1',
 'Pyphen >=0.9.1',
 'Pillow >=4.0.0',
 'fonttools[woff] >=4.0.0']

extras_require = \
{'doc': ['sphinx', 'sphinx_rtd_theme'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-isort',
          'coverage[toml]']}

entry_points = \
{'console_scripts': ['weasyprint = weasyprint.__main__:main']}

setup(name='weasyprint',
      version='53.0b1',
      description='The Awesome Document Factory',
      author=None,
      author_email='Simon Sapin <simon.sapin@exyr.org>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
