#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Sun Nov  8 13:00:27 2020 by generateDS.py version 2.36.2.
# Python 3.8.5 (default, Jul 28 2020, 12:59:40)  [GCC 9.3.0]
#
# Command line options:
#   ('-o', 'emllib.py')
#   ('--member-specs', 'list')
#
# Command line arguments:
#   ../xsd/eml.xsd
#
# Command line:
#   /home/ju/Projets/pndb/metasnake/.py38/bin/generateDS -o "emllib.py" --member-specs="list" ../xsd/eml.xsd
#
# Current working directory (os.getcwd()):
#   emllib220
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class Action(str, Enum):
    INSTALL='install'
    ASSERT='assert'


class CardinalityChildOccurancesType(str, Enum):
    MANY='many'


class CellGeometryType(str, Enum):
    PIXEL='pixel'
    MATRIX='matrix'


class CellValueType(str, Enum):
    VALUES='Values'
    CODED='Coded'
    RGB='RGB'
    CODES='Codes'
    HIS='HIS'
    HLS='HLS'
    TEK_HVC='tekHVC'


class DescriptorType(str, Enum):
    CLIMATE='climate'
    HYDROLOGY='hydrology'
    SOILS='soils'
    GEOLOGY='geology'
    DISTURBANCE='disturbance'
    BAILEY='bailey'
    BIOME='biome'


class FunctionType(str, Enum):
    DOWNLOAD='download'
    INFORMATION='information'


class GeometryType(str, Enum):
    POINT='Point'
    LINE_STRING='LineString'
    LINEAR_RING='LinearRing'
    POLYGON='Polygon'
    MULTI_POINT='MultiPoint'
    MULTI_LINE_STRING='MultiLineString'
    MULTI_POLYGON='MultiPolygon'
    MULTI_GEOMETRY='MultiGeometry'


class ImagingConditionCode(str, Enum):
    BLURREDIMAGE='blurredimage'
    CLOUD='cloud'
    DEGRADING_OBLIQUITY='degradingObliquity'
    FOG='fog'
    HEAVY_SMOKEOR_DUST='heavySmokeorDust'
    NIGHT='night'
    RAIN='rain'
    SEMI_DARKNESS='semiDarkness'
    SHADOW='shadow'
    SNOW='snow'
    TERRAIN_MASKING='terrainMasking'


class KeyTypeCode(str, Enum):
    PLACE='place'
    STRATUM='stratum'
    TEMPORAL='temporal'
    THEME='theme'
    TAXONOMIC='taxonomic'


class LengthUnitType(str, Enum):
    METER='meter'
    NANOMETER='nanometer'
    MICROMETER='micrometer'
    MICRON='micron'
    MILLIMETER='millimeter'
    CENTIMETER='centimeter'
    DECIMETER='decimeter'
    DEKAMETER='dekameter'
    HECTOMETER='hectometer'
    KILOMETER='kilometer'
    MEGAMETER='megameter'
    ANGSTROM='angstrom'
    INCH='inch'
    FOOT_US='Foot_US'
    FOOT='foot'
    FOOT__GOLD__COAST='Foot_Gold_Coast'
    FATHOM='fathom'
    NAUTICAL_MILE='nauticalMile'
    YARD='yard'
    YARD__INDIAN='Yard_Indian'
    LINK__CLARKE='Link_Clarke'
    YARD__SEARS='Yard_Sears'
    MILE='mile'


class MaintUpFreqType(str, Enum):
    ANNUALLY='annually'
    AS_NEEDED='asNeeded'
    BIANNUALLY='biannually'
    CONTINUALLY='continually'
    DAILY='daily'
    IRREGULAR='irregular'
    MONTHLY='monthly'
    NOT_PLANNED='notPlanned'
    WEEKLY='weekly'
    UNKNOWN='unknown'
    UNKOWN='unkown'
    OTHER_MAINTENANCE_PERIOD='otherMaintenancePeriod'


class MassUnitType(str, Enum):
    KILOGRAM='kilogram'
    NANOGRAM='nanogram'
    MICROGRAM='microgram'
    MILLIGRAM='milligram'
    CENTIGRAM='centigram'
    DECIGRAM='decigram'
    GRAM='gram'
    DEKAGRAM='dekagram'
    HECTOGRAM='hectogram'
    MEGAGRAM='megagram'
    TONNE='tonne'
    POUND='pound'
    TON='ton'


class NumberType(str, Enum):
    NATURAL='natural'
    WHOLE='whole'
    INTEGER='integer'
    REAL='real'


class RoleType(str, Enum):
    CONTENT_PROVIDER='contentProvider'
    CUSTODIAN_STEWARD='custodianSteward'
    OWNER='owner'
    USER='user'
    DISTRIBUTOR='distributor'
    METADATA_PROVIDER='metadataProvider'
    ORIGINATOR='originator'
    POINT_OF_CONTACT='pointOfContact'
    PRINCIPAL_INVESTIGATOR='principalInvestigator'
    PROCESSOR='processor'
    PUBLISHER='publisher'
    AUTHOR='author'
    EDITOR='editor'


class ScopeType(str, Enum):
    SYSTEM='system'
    DOCUMENT='document'


class TopologyLevel(str, Enum):
    GEOMETRY_ONLY='geometryOnly'
    NON_PLANAR_GRAPH='nonPlanarGraph'
    PLANAR_LINE_GRAPH='planarLineGraph'
    FULL_PLANAR_GRAPH='fullPlanarGraph'
    SURFACE_GRAPH='surfaceGraph'
    FULL_TOPOLOGY_3_D='fullTopology3D'


class angleUnitType(str, Enum):
    RADIAN='radian'
    DEGREE='degree'
    GRAD='grad'
    STERADIAN='steradian'


class angleUnits(str, Enum):
    RADIAN='radian'
    DEGREE='degree'
    GRAD='grad'
    DEGREE_1='degree'
    GRAD_1='grad'


class attributeOrientationType(str, Enum):
    COLUMN='column'
    ROW='row'


class caseSensitiveType(str, Enum):
    YES='yes'
    NO='no'


class collapseDelimitersType(str, Enum):
    YES='yes'
    NO='no'


class collapseDelimitersType26(str, Enum):
    YES='yes'
    NO='no'


class enforcedType(str, Enum):
    YES='yes'
    NO='no'


class horizCoordSysNameType(str, Enum):
    GCS__ABIDJAN__1987='GCS_Abidjan_1987'
    GCS__ACCRA='GCS_Accra'
    GCS__ADINDAN='GCS_Adindan'
    GCS__AFGOOYE='GCS_Afgooye'
    GCS__AGADEZ='GCS_Agadez'
    GCS__AIN_EL__ABD__1970='GCS_Ain_el_Abd_1970'
    GCS__ARC__1950='GCS_Arc_1950'
    GCS__ARC__1960='GCS_Arc_1960'
    GCS__AYABELLE='GCS_Ayabelle'
    GCS__BEDUARAM='GCS_Beduaram'
    GCS__BISSAU='GCS_Bissau'
    GCS__CAMACUPA='GCS_Camacupa'
    GCS__CAPE='GCS_Cape'
    GCS__CARTHAGE__DEGREE='GCS_Carthage_Degree'
    GCS__CARTHAGE__PARIS='GCS_Carthage_Paris'
    GCS__CARTHAGE='GCS_Carthage'
    GCS__CONAKRY__1905='GCS_Conakry_1905'
    GCS__COTE_D__IVOIRE='GCS_Cote_d_Ivoire'
    GCS__DABOLA='GCS_Dabola'
    GCS__DOUALA='GCS_Douala'
    GCS__EGYPT__1907='GCS_Egypt_1907'
    GCS__EUROPEAN__1950='GCS_European_1950'
    GCS__EUROPEAN__LIBYAN__DATUM__1979='GCS_European_Libyan_Datum_1979'
    GCS__GAROUA='GCS_Garoua'
    GCS__HARTEBEESTHOEK__1994='GCS_Hartebeesthoek_1994'
    GCS__KUWAIT__OIL__COMPANY='GCS_Kuwait_Oil_Company'
    GCS_KUDAMS='GCS_KUDAMS'
    GCS__LEIGON='GCS_Leigon'
    GCS__LIBERIA__1964='GCS_Liberia_1964'
    GCS__LOCODJO__1965='GCS_Locodjo_1965'
    GCS__LOME='GCS_Lome'
    GCS__MPORALOKO='GCS_Mporaloko'
    GCS__MADZANSUA='GCS_Madzansua'
    GCS__MAHE__1971='GCS_Mahe_1971'
    GCS__MALONGO__1987='GCS_Malongo_1987'
    GCS__MANOCA='GCS_Manoca'
    GCS__MASSAWA='GCS_Massawa'
    GCS__MERCHICH__DEGREE='GCS_Merchich_Degree'
    GCS__MERCHICH='GCS_Merchich'
    GCS__MHAST='GCS_Mhast'
    GCS__MINNA='GCS_Minna'
    GCS__MOZNET='GCS_Moznet'
    GCS__NAHRWAN__1967='GCS_Nahrwan_1967'
    GCS_NGN='GCS_NGN'
    GCS__NORD__SAHARA__1959='GCS_Nord_Sahara_1959'
    GCS__OBSERVATARIO='GCS_Observatario'
    GCS__OMAN='GCS_Oman'
    GCS__PALESTINE__1923='GCS_Palestine_1923'
    GCS_PDO__1993='GCS_PDO_1993'
    GCS__POINT__58='GCS_Point_58'
    GCS__POINTE__NOIRE='GCS_Pointe_Noire'
    GCS__QATAR__1948='GCS_Qatar_1948'
    GCS__QATAR='GCS_Qatar'
    GCS__SCHWARZECK='GCS_Schwarzeck'
    GCS__SIERRA__LEONE__1924='GCS_Sierra_Leone_1924'
    GCS__SIERRA__LEONE__1960='GCS_Sierra_Leone_1960'
    GCS__SIERRA__LEONE__1968='GCS_Sierra_Leone_1968'
    GCS__SOUTH__YEMEN='GCS_South_Yemen'
    GCS__SUDAN='GCS_Sudan'
    GCS__TANANARIVE__1925__PARIS='GCS_Tananarive_1925_Paris'
    GCS__TANANARIVE__1925='GCS_Tananarive_1925'
    GCS__TETE='GCS_Tete'
    GCS__TRUCIAL__COAST__1948='GCS_Trucial_Coast_1948'
    GCS__VOIROL__1875__DEGREE='GCS_Voirol_1875_Degree'
    GCS__VOIROL__1875__PARIS='GCS_Voirol_1875_Paris'
    GCS__VOIROL__1875='GCS_Voirol_1875'
    GCS__VOIROL__UNIFIE__1960__DEGREE='GCS_Voirol_Unifie_1960_Degree'
    GCS__VOIROL__UNIFIE__1960__PARIS='GCS_Voirol_Unifie_1960_Paris'
    GCS__VOIROL__UNIFIE__1960='GCS_Voirol_Unifie_1960'
    GCS__YEMEN_NGN__1996='GCS_Yemen_NGN_1996'
    GCS__YOFF='GCS_Yoff'
    GCS__CAMP__AREA='GCS_Camp_Area'
    GCS__DECEPTION__ISLAND='GCS_Deception_Island'
    GCS__AIN_EL__ABD__1970_1='GCS_Ain_el_Abd_1970'
    GCS__BATAVIA__JAKARTA='GCS_Batavia_Jakarta'
    GCS__BATAVIA='GCS_Batavia'
    GCS__BEIJING__1954='GCS_Beijing_1954'
    GCS__BUKIT__RIMPAH='GCS_Bukit_Rimpah'
    GCS__DEIR_EZ__ZOR='GCS_Deir_ez_Zor'
    GCS__EUROPEAN__1950_ED_77='GCS_European_1950_ED77'
    GCS__EUROPEAN__1950_1='GCS_European_1950'
    GCS__EVEREST_DEF__1962='GCS_Everest_def_1962'
    GCS__EVEREST_DEF__1967='GCS_Everest_def_1967'
    GCS__EVEREST_DEF__1975='GCS_Everest_def_1975'
    GCS__EVEREST__BANGLADESH='GCS_Everest_Bangladesh'
    GCS__EVEREST__INDIA__NEPAL='GCS_Everest_India_Nepal'
    GCS__EVEREST__1830='GCS_Everest_1830'
    GCS__EVEREST__MODIFIED='GCS_Everest_Modified'
    GCS__FAHUD='GCS_Fahud'
    GCS_FD__1958='GCS_FD_1958'
    GCS__GANDAJIKA__1970='GCS_Gandajika_1970'
    GCS__GUNUNG__SEGARA='GCS_Gunung_Segara'
    GCS__HANOI__1972='GCS_Hanoi_1972'
    GCS__HERAT__NORTH='GCS_Herat_North'
    GCS__HONG__KONG__1963='GCS_Hong_Kong_1963'
    GCS__HONG__KONG__1980='GCS_Hong_Kong_1980'
    GCS__HU__TZU__SHAN='GCS_Hu_Tzu_Shan'
    GCS__INDIAN__1954='GCS_Indian_1954'
    GCS__INDIAN__1960='GCS_Indian_1960'
    GCS__INDIAN__1975='GCS_Indian_1975'
    GCS__INDONESIAN__1974='GCS_Indonesian_1974'
    GCS__ISRAEL='GCS_Israel'
    GCS_JGD__2000='GCS_JGD_2000'
    GCS__KALIANPUR__1880='GCS_Kalianpur_1880'
    GCS__KALIANPUR__1937='GCS_Kalianpur_1937'
    GCS__KALIANPUR__1962='GCS_Kalianpur_1962'
    GCS__KALIANPUR__1975='GCS_Kalianpur_1975'
    GCS__KANDAWALA='GCS_Kandawala'
    GCS__KERTAU='GCS_Kertau'
    GCS__KOREAN__DATUM__1985='GCS_Korean_Datum_1985'
    GCS__KOREAN__DATUM__1995='GCS_Korean_Datum_1995'
    GCS__KUWAIT__OIL__COMPANY_1='GCS_Kuwait_Oil_Company'
    GCS_KUDAMS_1='GCS_KUDAMS'
    GCS__LUZON__1911='GCS_Luzon_1911'
    GCS__MAKASSAR__JAKARTA='GCS_Makassar_Jakarta'
    GCS__MAKASSAR='GCS_Makassar'
    GCS__NAHRWAN__1967_1='GCS_Nahrwan_1967'
    GCS_NGN_1='GCS_NGN'
    GCS__OMAN_1='GCS_Oman'
    GCS__PADANG__1884__JAKARTA='GCS_Padang_1884_Jakarta'
    GCS__PADANG__1884='GCS_Padang_1884'
    GCS__PALESTINE__1923_1='GCS_Palestine_1923'
    GCS__PULKOVO__1942='GCS_Pulkovo_1942'
    GCS__PULKOVO__1995='GCS_Pulkovo_1995'
    GCS__QATAR__1948_1='GCS_Qatar_1948'
    GCS__QATAR_1='GCS_Qatar'
    GCS__RASSADIRAN='GCS_Rassadiran'
    GCS__SAMBOJA='GCS_Samboja'
    GCS__SEGORA='GCS_Segora'
    GCS__SERINDUNG='GCS_Serindung'
    GCS__SOUTH__ASIA__SINGAPORE='GCS_South_Asia_Singapore'
    GCS__TIMBALAI__1948='GCS_Timbalai_1948'
    GCS__TOKYO='GCS_Tokyo'
    GCS__TRUCIAL__COAST__1948_1='GCS_Trucial_Coast_1948'
    GCS__AUSTRALIAN__1966='GCS_Australian_1966'
    GCS__AUSTRALIAN__1984='GCS_Australian_1984'
    GCS_GDA__1994='GCS_GDA_1994'
    GCS__NEW__ZEALAND__1949='GCS_New_Zealand_1949'
    GCS_NZGD__2000='GCS_NZGD_2000'
    GCS__AMERSFOORT='GCS_Amersfoort'
    GCS_ATF__PARIS='GCS_ATF_Paris'
    GCS__BELGE__1950__BRUSSELS='GCS_Belge_1950_Brussels'
    GCS__BELGE__1972='GCS_Belge_1972'
    GCS__BERN__1898__BERN='GCS_Bern_1898_Bern'
    GCS__BERN__1898='GCS_Bern_1898'
    GCS__BERN__1938='GCS_Bern_1938'
    GCS_CH_1903='GCS_CH1903+'
    GCS_CH_1903_1='GCS_CH1903'
    GCS__DATUM__73='GCS_Datum_73'
    GCS__DATUM__LISBOA__BESSEL='GCS_Datum_Lisboa_Bessel'
    GCS__DATUM__LISBOA__BESSEL_1='GCS_Datum_Lisboa_Bessel'
    GCS__DEALUL__PISCULUI__1933='GCS_Dealul_Piscului_1933'
    GCS__DEALUL__PISCULUI__1970='GCS_Dealul_Piscului_1970'
    GCS__DEUTSCHE__HAUPTDREIECKSNETZ='GCS_Deutsche_Hauptdreiecksnetz'
    GCS__ESTONIA__1937='GCS_Estonia_1937'
    GCS__ESTONIA__1992='GCS_Estonia_1992'
    GCS_ETRF__1989='GCS_ETRF_1989'
    GCS__EUROPEAN__1979='GCS_European_1979'
    GCS__EUROPEAN__1950_2='GCS_European_1950'
    GCS__EUROPEAN__1987='GCS_European_1987'
    GCS__GREEK__ATHENS='GCS_Greek_Athens'
    GCS__GREEK='GCS_Greek'
    GCS__HERMANNSKOGEL='GCS_Hermannskogel'
    GCS__HJORSEY__1955='GCS_Hjorsey_1955'
    GCS__HUNGARIAN__1972='GCS_Hungarian_1972'
    GCS_IRENET_95='GCS_IRENET95'
    GCS_KKJ='GCS_KKJ'
    GCS__LISBON__LISBON='GCS_Lisbon_Lisbon'
    GCS__LISBON='GCS_Lisbon'
    GCS_LKS__1994='GCS_LKS_1994'
    GCS__MADRID__1870__MADRID='GCS_Madrid_1870_Madrid'
    GCS_MGI__FERRO='GCS_MGI_Ferro'
    GCS_MGI='GCS_MGI'
    GCS__MONTE__MARIO__ROME='GCS_Monte_Mario_Rome'
    GCS__MONTE__MARIO='GCS_Monte_Mario'
    GCS_NGO__1948__OSLO='GCS_NGO_1948_Oslo'
    GCS_NGO__1948='GCS_NGO_1948'
    GCS__NORD_DE__GUERRE__PARIS='GCS_Nord_de_Guerre_Paris'
    GCS_NTF='GCS_NTF'
    GCS_NTF__PARIS='GCS_NTF_Paris'
    GCS_OS_SN__1980='GCS_OS_SN_1980'
    GCS_OSGB__1936='GCS_OSGB_1936'
    GCS_OSGB__1970_SN='GCS_OSGB_1970_SN'
    GCS__PULKOVO__1942_1='GCS_Pulkovo_1942'
    GCS__PULKOVO__1995_1='GCS_Pulkovo_1995'
    GCS__QORNOQ='GCS_Qornoq'
    GCS__BELGE__1950='GCS_Belge_1950'
    GCS__BELGE__1972_1='GCS_Belge_1972'
    GCS_RGF__1993='GCS_RGF_1993'
    GCS_RT__1990='GCS_RT_1990'
    GCS_RT_38__STOCKHOLM='GCS_RT38_Stockholm'
    GCS_RT_38='GCS_RT38'
    GCS_S_42__HUNGARY='GCS_S42_Hungary'
    GCS_S_JTSK='GCS_S_JTSK'
    GCS__SWISS_TRF__1995='GCS_Swiss_TRF_1995'
    GCS_TM_65='GCS_TM65'
    GCS_TM_75='GCS_TM75'
    GCS__ALASKAN__ISLANDS='GCS_Alaskan_Islands'
    GCS__AMERICAN__SAMOA__1962='GCS_American_Samoa_1962'
    GCS_ATS__1977='GCS_ATS_1977'
    GCS__BARBADOS='GCS_Barbados'
    GCS__BERMUDA__1957='GCS_Bermuda_1957'
    GCS__CAPE__CANAVERAL='GCS_Cape_Canaveral'
    GCS__GUAM__1963='GCS_Guam_1963'
    GCS__JAMAICA__1875='GCS_Jamaica_1875'
    GCS__JAMAICA__1969='GCS_Jamaica_1969'
    GCS_NAD__1927_CGQ_77='GCS_NAD_1927_CGQ77'
    GCS_NAD__1927__DEFINITION__1976='GCS_NAD_1927_Definition_1976'
    GCS__NORTH__AMERICAN__MICHIGAN='GCS_North_American_Michigan'
    GCS__NORTH__AMERICAN__1983_CSRS_98='GCS_North_American_1983_CSRS98'
    GCS__NORTH__AMERICAN__1983_HARN='GCS_North_American_1983_HARN'
    GCS__NORTH__AMERICAN__1927='GCS_North_American_1927'
    GCS__NORTH__AMERICAN__1983='GCS_North_American_1983'
    GCS__OLD__HAWAIIAN='GCS_Old_Hawaiian'
    GCS__PUERTO__RICO='GCS_Puerto_Rico'
    GCS__QORNOQ_1='GCS_Qornoq'
    GCS__ST__GEORGE__ISLAND='GCS_St_George_Island'
    GCS__ST__LAWRENCE__ISLAND='GCS_St_Lawrence_Island'
    GCS__ST__PAUL__ISLAND='GCS_St_Paul_Island'
    GCS__ALASKAN__ISLANDS_1='GCS_Alaskan_Islands'
    GCS__AMERICAN__SAMOA__1962_1='GCS_American_Samoa_1962'
    GCS__ANGUILLA__1957='GCS_Anguilla_1957'
    GCS__ANNA__1__1965='GCS_Anna_1_1965'
    GCS__ANTIGUA__1943='GCS_Antigua_1943'
    GCS__ASCENSION__ISLAND__1958='GCS_Ascension_Island_1958'
    GCS__BEACON_E__1945='GCS_Beacon_E_1945'
    GCS_DOS__71__4='GCS_DOS_71_4'
    GCS__ASTRO__1952='GCS_Astro_1952'
    GCS__BAB__SOUTH='GCS_Bab_South'
    GCS__BARBADOS__1938='GCS_Barbados_1938'
    GCS__BARBADOS_1='GCS_Barbados'
    GCS__BELLEVUE_IGN='GCS_Bellevue_IGN'
    GCS__BERMUDA__1957_1='GCS_Bermuda_1957'
    GCS__CANTON__1966='GCS_Canton_1966'
    GCS__CHATHAM__ISLAND__1971='GCS_Chatham_Island_1971'
    GCS__DOMINICA__1945='GCS_Dominica_1945'
    GCS_DOS__1968='GCS_DOS_1968'
    GCS__EASTER__ISLAND__1967='GCS_Easter_Island_1967'
    GCS__FORT__THOMAS__1955='GCS_Fort_Thomas_1955'
    GCS__GAN__1970='GCS_Gan_1970'
    GCS__GRACIOSA__BASE_SW__1948='GCS_Graciosa_Base_SW_1948'
    GCS__GRENADA__1953='GCS_Grenada_1953'
    GCS__GUAM__1963_1='GCS_Guam_1963'
    GCS_GUX__1='GCS_GUX_1'
    GCS__HJORSEY__1955_1='GCS_Hjorsey_1955'
    GCS_ISTS__061__1968='GCS_ISTS_061_1968'
    GCS_ISTS__073__1969='GCS_ISTS_073_1969'
    GCS__JAMAICA__1875_1='GCS_Jamaica_1875'
    GCS__JAMAICA__1969_1='GCS_Jamaica_1969'
    GCS__JOHNSTON__ISLAND__1961='GCS_Johnston_Island_1961'
    GCS__KERGUELEN__ISLAND__1949='GCS_Kerguelen_Island_1949'
    GCS__KUSAIE__1951='GCS_Kusaie_1951'
    GCS_LC_5__1961='GCS_LC5_1961'
    GCS__MAHE__1971_1='GCS_Mahe_1971'
    GCS__MAJURO='GCS_Majuro'
    GCS__MIDWAY__1961='GCS_Midway_1961'
    GCS__MONTSERRAT__1958='GCS_Montserrat_1958'
    GCS__OBSERV__METEOROLOGICO__1939='GCS_Observ_Meteorologico_1939'
    GCS__OLD__HAWAIIAN_1='GCS_Old_Hawaiian'
    GCS__PICO_DE__LAS__NIEVES='GCS_Pico_de_Las_Nieves'
    GCS__PITCAIRN__1967='GCS_Pitcairn_1967'
    GCS__POHNPEI='GCS_Pohnpei'
    GCS__PORTO__SANTO__1936='GCS_Porto_Santo_1936'
    GCS__PUERTO__RICO_1='GCS_Puerto_Rico'
    GCS__REUNION='GCS_Reunion'
    GCS__SANTO_DOS__1965='GCS_Santo_DOS_1965'
    GCS__SAO__BRAZ='GCS_Sao_Braz'
    GCS__SAPPER__HILL__1943='GCS_Sapper_Hill_1943'
    GCS__SELVAGEM__GRANDE__1938='GCS_Selvagem_Grande_1938'
    GCS__ST__KITTS__1955='GCS_St_Kitts_1955'
    GCS__ST__LUCIA__1955='GCS_St_Lucia_1955'
    GCS__ST__VINCENT__1945='GCS_St_Vincent_1945'
    GCS__TERN__ISLAND__1961='GCS_Tern_Island_1961'
    GCS__TRISTAN__1968='GCS_Tristan_1968'
    GCS__VITI__LEVU__1916='GCS_Viti_Levu_1916'
    GCS__WAKE__ISLAND__1952='GCS_Wake_Island_1952'
    GCS__WAKE__ENIWETOK__1960='GCS_Wake_Eniwetok_1960'
    GCS__ARATU='GCS_Aratu'
    GCS__BOGOTA__BOGOTA='GCS_Bogota_Bogota'
    GCS__BOGOTA='GCS_Bogota'
    GCS__CAMPO__INCHAUSPE='GCS_Campo_Inchauspe'
    GCS__CHOS__MALAL__1914='GCS_Chos_Malal_1914'
    GCS__CHUA='GCS_Chua'
    GCS__CORREGO__ALEGRE='GCS_Corrego_Alegre'
    GCS__GUYANE__FRANCAISE='GCS_Guyane_Francaise'
    GCS__HITO_XVIII__1963='GCS_Hito_XVIII_1963'
    GCS__LA__CANOA='GCS_La_Canoa'
    GCS__LAKE='GCS_Lake'
    GCS__LOMA__QUINTANA='GCS_Loma_Quintana'
    GCS__MOUNT__DILLON='GCS_Mount_Dillon'
    GCS__NAPARIMA__1955='GCS_Naparima_1955'
    GCS__NAPARIMA__1972='GCS_Naparima_1972'
    GCS__PAMPA_DEL__CASTILLO='GCS_Pampa_del_Castillo'
    GCS_POSGAR='GCS_POSGAR'
    GCS_REGVEN='GCS_REGVEN'
    GCS__SAPPER__HILL__1943_1='GCS_Sapper_Hill_1943'
    GCS_SIRGAS='GCS_SIRGAS'
    GCS__SOUTH__AMERICAN__1969='GCS_South_American_1969'
    GCS__TRINIDAD__1903='GCS_Trinidad_1903'
    GCS__YACARE='GCS_Yacare'
    GCS__ZANDERIJ='GCS_Zanderij'
    GCS__AIRY__1830='GCS_Airy_1830'
    GCS__AIRY__MODIFIED='GCS_Airy_Modified'
    GCS__AUSTRALIAN='GCS_Australian'
    GCS__SPHERE_ARC_INFO='GCS_Sphere_ARC_INFO'
    GCS__SPHERE='GCS_Sphere'
    GCS_ATS__1977_1='GCS_ATS_1977'
    GCS__BESSEL__1841='GCS_Bessel_1841'
    GCS__BESSEL__MODIFIED='GCS_Bessel_Modified'
    GCS__BESSEL__NAMIBIA='GCS_Bessel_Namibia'
    GCS__CLARKE__1858='GCS_Clarke_1858'
    GCS__CLARKE__1866__MICHIGAN='GCS_Clarke_1866_Michigan'
    GCS__CLARKE__1866='GCS_Clarke_1866'
    GCS__CLARKE__1880__ARC='GCS_Clarke_1880_Arc'
    GCS__CLARKE__1880__BENOIT='GCS_Clarke_1880_Benoit'
    GCS__CLARKE__1880_IGN='GCS_Clarke_1880_IGN'
    GCS__CLARKE__1880_RGS='GCS_Clarke_1880_RGS'
    GCS__CLARKE__1880_SGA='GCS_Clarke_1880_SGA'
    GCS__CLARKE__1880='GCS_Clarke_1880'
    GCS__EVEREST_DEF__1967_1='GCS_Everest_def_1967'
    GCS__EVEREST_DEF__1975_1='GCS_Everest_def_1975'
    GCS__EVEREST__1830_1='GCS_Everest_1830'
    GCS__EVEREST__MODIFIED__1969='GCS_Everest_Modified_1969'
    GCS__EVEREST__MODIFIED_1='GCS_Everest_Modified'
    GCS__FISCHER__1960='GCS_Fischer_1960'
    GCS__FISCHER__1968='GCS_Fischer_1968'
    GCS__FISCHER__MODIFIED='GCS_Fischer_Modified'
    GCS_GEM__10_C='GCS_GEM_10C'
    GCS_GRS__1967='GCS_GRS_1967'
    GCS_GRS__1980='GCS_GRS_1980'
    GCS__HELMERT__1906='GCS_Helmert_1906'
    GCS__HOUGH__1960='GCS_Hough_1960'
    GCS__INDONESIAN='GCS_Indonesian'
    GCS__INTERNATIONAL__1924='GCS_International_1924'
    GCS__INTERNATIONAL__1967='GCS_International_1967'
    GCS__KRASOVSKY__1940='GCS_Krasovsky_1940'
    GCS_OSU__86_F='GCS_OSU_86F'
    GCS_OSU__91_A='GCS_OSU_91A'
    GCS__PLESSIS__1817='GCS_Plessis_1817'
    GCS__STRUVE__1860='GCS_Struve_1860'
    GCS_NWL__9_D='GCS_NWL_9D'
    GCS__WALBECK='GCS_Walbeck'
    GCS__WAR__OFFICE='GCS_War_Office'
    GCS_WGS__1966='GCS_WGS_1966'
    GCS_NSWC__9_Z__2='GCS_NSWC_9Z_2'
    GCS_WGS__1966_1='GCS_WGS_1966'
    GCS_WGS__1972_BE='GCS_WGS_1972_BE'
    GCS_WGS__1972='GCS_WGS_1972'
    GCS_WGS__1984='GCS_WGS_1984'
    AFRICA__ALBERS__EQUAL__AREA__CONIC='Africa_Albers_Equal_Area_Conic'
    AFRICA__EQUIDISTANT__CONIC='Africa_Equidistant_Conic'
    AFRICA__LAMBERT__CONFORMAL__CONIC='Africa_Lambert_Conformal_Conic'
    AFRICA__SINUSOIDAL='Africa_Sinusoidal'
    ASIA__LAMBERT__CONFORMAL__CONIC='Asia_Lambert_Conformal_Conic'
    ASIA__NORTH__ALBERS__EQUAL__AREA__CONIC='Asia_North_Albers_Equal_Area_Conic'
    ASIA__NORTH__EQUIDISTANT__CONIC='Asia_North_Equidistant_Conic'
    ASIA__NORTH__LAMBERT__CONFORMAL__CONIC='Asia_North_Lambert_Conformal_Conic'
    ASIA__SOUTH__ALBERS__EQUAL__AREA__CONIC='Asia_South_Albers_Equal_Area_Conic'
    ASIA__SOUTH__EQUIDISTANT__CONIC='Asia_South_Equidistant_Conic'
    ASIA__SOUTH__LAMBERT__CONFORMAL__CONIC='Asia_South_Lambert_Conformal_Conic'
    EUROPE__ALBERS__EQUAL__AREA__CONIC='Europe_Albers_Equal_Area_Conic'
    EUROPE__EQUIDISTANT__CONIC='Europe_Equidistant_Conic'
    EUROPE__LAMBERT__CONFORMAL__CONIC='Europe_Lambert_Conformal_Conic'
    ALASKA__ALBERS__EQUAL__AREA__CONIC='Alaska_Albers_Equal_Area_Conic'
    CANADA__ALBERS__EQUAL__AREA__CONIC='Canada_Albers_Equal_Area_Conic'
    CANADA__LAMBERT__CONFORMAL__CONIC='Canada_Lambert_Conformal_Conic'
    HAWAII__ALBERS__EQUAL__AREA__CONIC='Hawaii_Albers_Equal_Area_Conic'
    NORTH__AMERICA__ALBERS__EQUAL__AREA__CONIC='North_America_Albers_Equal_Area_Conic'
    NORTH__AMERICA__EQUIDISTANT__CONIC='North_America_Equidistant_Conic'
    NORTH__AMERICA__LAMBERT__CONFORMAL__CONIC='North_America_Lambert_Conformal_Conic'
    USA__CONTIGUOUS__ALBERS__EQUAL__AREA__CONIC_USGS_VERSION='USA_Contiguous_Albers_Equal_Area_Conic_USGS_version'
    USA__CONTIGUOUS__ALBERS__EQUAL__AREA__CONIC='USA_Contiguous_Albers_Equal_Area_Conic'
    USA__CONTIGUOUS__EQUIDISTANT__CONIC='USA_Contiguous_Equidistant_Conic'
    USA__CONTIGUOUS__LAMBERT__CONFORMAL__CONIC='USA_Contiguous_Lambert_Conformal_Conic'
    SOUTH__AMERICA__ALBERS__EQUAL__AREA__CONIC='South_America_Albers_Equal_Area_Conic'
    SOUTH__AMERICA__EQUIDISTANT__CONIC='South_America_Equidistant_Conic'
    SOUTH__AMERICA__LAMBERT__CONFORMAL__CONIC='South_America_Lambert_Conformal_Conic'
    BEIJING__1954_GK__ZONE__13='Beijing_1954_GK_Zone_13'
    BEIJING__1954_GK__ZONE__13_N='Beijing_1954_GK_Zone_13N'
    BEIJING__1954_GK__ZONE__14='Beijing_1954_GK_Zone_14'
    BEIJING__1954_GK__ZONE__14_N='Beijing_1954_GK_Zone_14N'
    BEIJING__1954_GK__ZONE__15='Beijing_1954_GK_Zone_15'
    BEIJING__1954_GK__ZONE__15_N='Beijing_1954_GK_Zone_15N'
    BEIJING__1954_GK__ZONE__16='Beijing_1954_GK_Zone_16'
    BEIJING__1954_GK__ZONE__16_N='Beijing_1954_GK_Zone_16N'
    BEIJING__1954_GK__ZONE__17='Beijing_1954_GK_Zone_17'
    BEIJING__1954_GK__ZONE__17_N='Beijing_1954_GK_Zone_17N'
    BEIJING__1954_GK__ZONE__18='Beijing_1954_GK_Zone_18'
    BEIJING__1954_GK__ZONE__18_N='Beijing_1954_GK_Zone_18N'
    BEIJING__1954_GK__ZONE__19='Beijing_1954_GK_Zone_19'
    BEIJING__1954_GK__ZONE__19_N='Beijing_1954_GK_Zone_19N'
    BEIJING__1954_GK__ZONE__20='Beijing_1954_GK_Zone_20'
    BEIJING__1954_GK__ZONE__20_N='Beijing_1954_GK_Zone_20N'
    BEIJING__1954_GK__ZONE__21='Beijing_1954_GK_Zone_21'
    BEIJING__1954_GK__ZONE__21_N='Beijing_1954_GK_Zone_21N'
    BEIJING__1954_GK__ZONE__22='Beijing_1954_GK_Zone_22'
    BEIJING__1954_GK__ZONE__22_N='Beijing_1954_GK_Zone_22N'
    BEIJING__1954_GK__ZONE__23='Beijing_1954_GK_Zone_23'
    BEIJING__1954_GK__ZONE__23_N='Beijing_1954_GK_Zone_23N'
    HANOI__1972_GK__ZONE__18='Hanoi_1972_GK_Zone_18'
    HANOI__1972_GK__ZONE__19='Hanoi_1972_GK_Zone_19'
    SOUTH__YEMEN_GK__ZONE__8='South_Yemen_GK_Zone_8'
    SOUTH__YEMEN_GK__ZONE__9='South_Yemen_GK_Zone_9'
    PULKOVO__1942_GK__ZONE__10='Pulkovo_1942_GK_Zone_10'
    PULKOVO__1942_GK__ZONE__10_N='Pulkovo_1942_GK_Zone_10N'
    PULKOVO__1942_GK__ZONE__11='Pulkovo_1942_GK_Zone_11'
    PULKOVO__1942_GK__ZONE__11_N='Pulkovo_1942_GK_Zone_11N'
    PULKOVO__1942_GK__ZONE__12='Pulkovo_1942_GK_Zone_12'
    PULKOVO__1942_GK__ZONE__12_N='Pulkovo_1942_GK_Zone_12N'
    PULKOVO__1942_GK__ZONE__13='Pulkovo_1942_GK_Zone_13'
    PULKOVO__1942_GK__ZONE__13_N='Pulkovo_1942_GK_Zone_13N'
    PULKOVO__1942_GK__ZONE__14='Pulkovo_1942_GK_Zone_14'
    PULKOVO__1942_GK__ZONE__14_N='Pulkovo_1942_GK_Zone_14N'
    PULKOVO__1942_GK__ZONE__15='Pulkovo_1942_GK_Zone_15'
    PULKOVO__1942_GK__ZONE__15_N='Pulkovo_1942_GK_Zone_15N'
    PULKOVO__1942_GK__ZONE__16='Pulkovo_1942_GK_Zone_16'
    PULKOVO__1942_GK__ZONE__16_N='Pulkovo_1942_GK_Zone_16N'
    PULKOVO__1942_GK__ZONE__17='Pulkovo_1942_GK_Zone_17'
    PULKOVO__1942_GK__ZONE__17_N='Pulkovo_1942_GK_Zone_17N'
    PULKOVO__1942_GK__ZONE__18='Pulkovo_1942_GK_Zone_18'
    PULKOVO__1942_GK__ZONE__18_N='Pulkovo_1942_GK_Zone_18N'
    PULKOVO__1942_GK__ZONE__19='Pulkovo_1942_GK_Zone_19'
    PULKOVO__1942_GK__ZONE__19_N='Pulkovo_1942_GK_Zone_19N'
    PULKOVO__1942_GK__ZONE__2='Pulkovo_1942_GK_Zone_2'
    PULKOVO__1942_GK__ZONE__20='Pulkovo_1942_GK_Zone_20'
    PULKOVO__1942_GK__ZONE__20_N='Pulkovo_1942_GK_Zone_20N'
    PULKOVO__1942_GK__ZONE__21='Pulkovo_1942_GK_Zone_21'
    PULKOVO__1942_GK__ZONE__21_N='Pulkovo_1942_GK_Zone_21N'
    PULKOVO__1942_GK__ZONE__22='Pulkovo_1942_GK_Zone_22'
    PULKOVO__1942_GK__ZONE__22_N='Pulkovo_1942_GK_Zone_22N'
    PULKOVO__1942_GK__ZONE__23='Pulkovo_1942_GK_Zone_23'
    PULKOVO__1942_GK__ZONE__23_N='Pulkovo_1942_GK_Zone_23N'
    PULKOVO__1942_GK__ZONE__24='Pulkovo_1942_GK_Zone_24'
    PULKOVO__1942_GK__ZONE__24_N='Pulkovo_1942_GK_Zone_24N'
    PULKOVO__1942_GK__ZONE__25='Pulkovo_1942_GK_Zone_25'
    PULKOVO__1942_GK__ZONE__25_N='Pulkovo_1942_GK_Zone_25N'
    PULKOVO__1942_GK__ZONE__26='Pulkovo_1942_GK_Zone_26'
    PULKOVO__1942_GK__ZONE__26_N='Pulkovo_1942_GK_Zone_26N'
    PULKOVO__1942_GK__ZONE__27='Pulkovo_1942_GK_Zone_27'
    PULKOVO__1942_GK__ZONE__27_N='Pulkovo_1942_GK_Zone_27N'
    PULKOVO__1942_GK__ZONE__28='Pulkovo_1942_GK_Zone_28'
    PULKOVO__1942_GK__ZONE__28_N='Pulkovo_1942_GK_Zone_28N'
    PULKOVO__1942_GK__ZONE__29='Pulkovo_1942_GK_Zone_29'
    PULKOVO__1942_GK__ZONE__29_N='Pulkovo_1942_GK_Zone_29N'
    PULKOVO__1942_GK__ZONE__2_N='Pulkovo_1942_GK_Zone_2N'
    PULKOVO__1942_GK__ZONE__3='Pulkovo_1942_GK_Zone_3'
    PULKOVO__1942_GK__ZONE__30='Pulkovo_1942_GK_Zone_30'
    PULKOVO__1942_GK__ZONE__30_N='Pulkovo_1942_GK_Zone_30N'
    PULKOVO__1942_GK__ZONE__31='Pulkovo_1942_GK_Zone_31'
    PULKOVO__1942_GK__ZONE__31_N='Pulkovo_1942_GK_Zone_31N'
    PULKOVO__1942_GK__ZONE__32='Pulkovo_1942_GK_Zone_32'
    PULKOVO__1942_GK__ZONE__32_N='Pulkovo_1942_GK_Zone_32N'
    PULKOVO__1942_GK__ZONE__3_N='Pulkovo_1942_GK_Zone_3N'
    PULKOVO__1942_GK__ZONE__4='Pulkovo_1942_GK_Zone_4'
    PULKOVO__1942_GK__ZONE__4_N='Pulkovo_1942_GK_Zone_4N'
    PULKOVO__1942_GK__ZONE__5='Pulkovo_1942_GK_Zone_5'
    PULKOVO__1942_GK__ZONE__5_N='Pulkovo_1942_GK_Zone_5N'
    PULKOVO__1942_GK__ZONE__6='Pulkovo_1942_GK_Zone_6'
    PULKOVO__1942_GK__ZONE__6_N='Pulkovo_1942_GK_Zone_6N'
    PULKOVO__1942_GK__ZONE__7='Pulkovo_1942_GK_Zone_7'
    PULKOVO__1942_GK__ZONE__7_N='Pulkovo_1942_GK_Zone_7N'
    PULKOVO__1942_GK__ZONE__8='Pulkovo_1942_GK_Zone_8'
    PULKOVO__1942_GK__ZONE__8_N='Pulkovo_1942_GK_Zone_8N'
    PULKOVO__1942_GK__ZONE__9='Pulkovo_1942_GK_Zone_9'
    PULKOVO__1942_GK__ZONE__9_N='Pulkovo_1942_GK_Zone_9N'
    PULKOVO__1995_GK__ZONE__10='Pulkovo_1995_GK_Zone_10'
    PULKOVO__1995_GK__ZONE__10_N='Pulkovo_1995_GK_Zone_10N'
    PULKOVO__1995_GK__ZONE__11='Pulkovo_1995_GK_Zone_11'
    PULKOVO__1995_GK__ZONE__11_N='Pulkovo_1995_GK_Zone_11N'
    PULKOVO__1995_GK__ZONE__12='Pulkovo_1995_GK_Zone_12'
    PULKOVO__1995_GK__ZONE__12_N='Pulkovo_1995_GK_Zone_12N'
    PULKOVO__1995_GK__ZONE__13='Pulkovo_1995_GK_Zone_13'
    PULKOVO__1995_GK__ZONE__13_N='Pulkovo_1995_GK_Zone_13N'
    PULKOVO__1995_GK__ZONE__14='Pulkovo_1995_GK_Zone_14'
    PULKOVO__1995_GK__ZONE__14_N='Pulkovo_1995_GK_Zone_14N'
    PULKOVO__1995_GK__ZONE__15='Pulkovo_1995_GK_Zone_15'
    PULKOVO__1995_GK__ZONE__15_N='Pulkovo_1995_GK_Zone_15N'
    PULKOVO__1995_GK__ZONE__16='Pulkovo_1995_GK_Zone_16'
    PULKOVO__1995_GK__ZONE__16_N='Pulkovo_1995_GK_Zone_16N'
    PULKOVO__1995_GK__ZONE__17='Pulkovo_1995_GK_Zone_17'
    PULKOVO__1995_GK__ZONE__17_N='Pulkovo_1995_GK_Zone_17N'
    PULKOVO__1995_GK__ZONE__18='Pulkovo_1995_GK_Zone_18'
    PULKOVO__1995_GK__ZONE__18_N='Pulkovo_1995_GK_Zone_18N'
    PULKOVO__1995_GK__ZONE__19='Pulkovo_1995_GK_Zone_19'
    PULKOVO__1995_GK__ZONE__19_N='Pulkovo_1995_GK_Zone_19N'
    PULKOVO__1995_GK__ZONE__2='Pulkovo_1995_GK_Zone_2'
    PULKOVO__1995_GK__ZONE__20='Pulkovo_1995_GK_Zone_20'
    PULKOVO__1995_GK__ZONE__20_N='Pulkovo_1995_GK_Zone_20N'
    PULKOVO__1995_GK__ZONE__21='Pulkovo_1995_GK_Zone_21'
    PULKOVO__1995_GK__ZONE__21_N='Pulkovo_1995_GK_Zone_21N'
    PULKOVO__1995_GK__ZONE__22='Pulkovo_1995_GK_Zone_22'
    PULKOVO__1995_GK__ZONE__22_N='Pulkovo_1995_GK_Zone_22N'
    PULKOVO__1995_GK__ZONE__23='Pulkovo_1995_GK_Zone_23'
    PULKOVO__1995_GK__ZONE__23_N='Pulkovo_1995_GK_Zone_23N'
    PULKOVO__1995_GK__ZONE__24='Pulkovo_1995_GK_Zone_24'
    PULKOVO__1995_GK__ZONE__24_N='Pulkovo_1995_GK_Zone_24N'
    PULKOVO__1995_GK__ZONE__25='Pulkovo_1995_GK_Zone_25'
    PULKOVO__1995_GK__ZONE__25_N='Pulkovo_1995_GK_Zone_25N'
    PULKOVO__1995_GK__ZONE__26='Pulkovo_1995_GK_Zone_26'
    PULKOVO__1995_GK__ZONE__26_N='Pulkovo_1995_GK_Zone_26N'
    PULKOVO__1995_GK__ZONE__27='Pulkovo_1995_GK_Zone_27'
    PULKOVO__1995_GK__ZONE__27_N='Pulkovo_1995_GK_Zone_27N'
    PULKOVO__1995_GK__ZONE__28='Pulkovo_1995_GK_Zone_28'
    PULKOVO__1995_GK__ZONE__28_N='Pulkovo_1995_GK_Zone_28N'
    PULKOVO__1995_GK__ZONE__29='Pulkovo_1995_GK_Zone_29'
    PULKOVO__1995_GK__ZONE__29_N='Pulkovo_1995_GK_Zone_29N'
    PULKOVO__1995_GK__ZONE__2_N='Pulkovo_1995_GK_Zone_2N'
    PULKOVO__1995_GK__ZONE__3='Pulkovo_1995_GK_Zone_3'
    PULKOVO__1995_GK__ZONE__30='Pulkovo_1995_GK_Zone_30'
    PULKOVO__1995_GK__ZONE__30_N='Pulkovo_1995_GK_Zone_30N'
    PULKOVO__1995_GK__ZONE__31='Pulkovo_1995_GK_Zone_31'
    PULKOVO__1995_GK__ZONE__31_N='Pulkovo_1995_GK_Zone_31N'
    PULKOVO__1995_GK__ZONE__32='Pulkovo_1995_GK_Zone_32'
    PULKOVO__1995_GK__ZONE__32_N='Pulkovo_1995_GK_Zone_32N'
    PULKOVO__1995_GK__ZONE__3_N='Pulkovo_1995_GK_Zone_3N'
    PULKOVO__1995_GK__ZONE__4='Pulkovo_1995_GK_Zone_4'
    PULKOVO__1995_GK__ZONE__4_N='Pulkovo_1995_GK_Zone_4N'
    PULKOVO__1995_GK__ZONE__5='Pulkovo_1995_GK_Zone_5'
    PULKOVO__1995_GK__ZONE__5_N='Pulkovo_1995_GK_Zone_5N'
    PULKOVO__1995_GK__ZONE__6='Pulkovo_1995_GK_Zone_6'
    PULKOVO__1995_GK__ZONE__6_N='Pulkovo_1995_GK_Zone_6N'
    PULKOVO__1995_GK__ZONE__7='Pulkovo_1995_GK_Zone_7'
    PULKOVO__1995_GK__ZONE__7_N='Pulkovo_1995_GK_Zone_7N'
    PULKOVO__1995_GK__ZONE__8='Pulkovo_1995_GK_Zone_8'
    PULKOVO__1995_GK__ZONE__8_N='Pulkovo_1995_GK_Zone_8N'
    PULKOVO__1995_GK__ZONE__9='Pulkovo_1995_GK_Zone_9'
    PULKOVO__1995_GK__ZONE__9_N='Pulkovo_1995_GK_Zone_9N'
    ABIDJAN__1987_TM__5_NW='Abidjan_1987_TM_5_NW'
    ACCRA__GHANA__GRID='Accra_Ghana_Grid'
    ACCRA_TM__1_NW='Accra_TM_1_NW'
    SAMOA__1962__SAMOA__LAMBERT='Samoa_1962_Samoa_Lambert'
    ANGUILLA__1957__BRITISH__WEST__INDIES__GRID='Anguilla_1957_British_West_Indies_Grid'
    ANTIGUA__1943__BRITISH__WEST__INDIES__GRID='Antigua_1943_British_West_Indies_Grid'
    ARGENTINA__ZONE__1='Argentina_Zone_1'
    ARGENTINA__ZONE__2='Argentina_Zone_2'
    ARGENTINA__ZONE__3='Argentina_Zone_3'
    ARGENTINA__ZONE__4='Argentina_Zone_4'
    ARGENTINA__ZONE__5='Argentina_Zone_5'
    ARGENTINA__ZONE__6='Argentina_Zone_6'
    ARGENTINA__ZONE__7='Argentina_Zone_7'
    AGD__1966_AMG__ZONE__48='AGD_1966_AMG_Zone_48'
    AGD__1966_AMG__ZONE__49='AGD_1966_AMG_Zone_49'
    AGD__1966_AMG__ZONE__50='AGD_1966_AMG_Zone_50'
    AGD__1966_AMG__ZONE__51='AGD_1966_AMG_Zone_51'
    AGD__1966_AMG__ZONE__52='AGD_1966_AMG_Zone_52'
    AGD__1966_AMG__ZONE__53='AGD_1966_AMG_Zone_53'
    AGD__1966_AMG__ZONE__54='AGD_1966_AMG_Zone_54'
    AGD__1966_AMG__ZONE__55='AGD_1966_AMG_Zone_55'
    AGD__1966_AMG__ZONE__56='AGD_1966_AMG_Zone_56'
    AGD__1966_AMG__ZONE__57='AGD_1966_AMG_Zone_57'
    AGD__1966_AMG__ZONE__58='AGD_1966_AMG_Zone_58'
    AGD__1966_VICGRID='AGD_1966_VICGRID'
    AGD__1984_AMG__ZONE__48='AGD_1984_AMG_Zone_48'
    AGD__1984_AMG__ZONE__49='AGD_1984_AMG_Zone_49'
    AGD__1984_AMG__ZONE__50='AGD_1984_AMG_Zone_50'
    AGD__1984_AMG__ZONE__51='AGD_1984_AMG_Zone_51'
    AGD__1984_AMG__ZONE__52='AGD_1984_AMG_Zone_52'
    AGD__1984_AMG__ZONE__53='AGD_1984_AMG_Zone_53'
    AGD__1984_AMG__ZONE__54='AGD_1984_AMG_Zone_54'
    AGD__1984_AMG__ZONE__55='AGD_1984_AMG_Zone_55'
    AGD__1984_AMG__ZONE__56='AGD_1984_AMG_Zone_56'
    AGD__1984_AMG__ZONE__57='AGD_1984_AMG_Zone_57'
    AGD__1984_AMG__ZONE__58='AGD_1984_AMG_Zone_58'
    GDA__1994_MGA__ZONE__48='GDA_1994_MGA_Zone_48'
    GDA__1994_MGA__ZONE__49='GDA_1994_MGA_Zone_49'
    GDA__1994_MGA__ZONE__50='GDA_1994_MGA_Zone_50'
    GDA__1994_MGA__ZONE__51='GDA_1994_MGA_Zone_51'
    GDA__1994_MGA__ZONE__52='GDA_1994_MGA_Zone_52'
    GDA__1994_MGA__ZONE__53='GDA_1994_MGA_Zone_53'
    GDA__1994_MGA__ZONE__54='GDA_1994_MGA_Zone_54'
    GDA__1994_MGA__ZONE__55='GDA_1994_MGA_Zone_55'
    GDA__1994_MGA__ZONE__56='GDA_1994_MGA_Zone_56'
    GDA__1994_MGA__ZONE__57='GDA_1994_MGA_Zone_57'
    GDA__1994_MGA__ZONE__58='GDA_1994_MGA_Zone_58'
    GDA__1994__SOUTH__AUSTRALIA__LAMBERT='GDA_1994_South_Australia_Lambert'
    GDA__1994_VICGRID_94='GDA_1994_VICGRID94'
    AUSTRIA__CENTRAL__ZONE='Austria_Central_Zone'
    AUSTRIA__EAST__ZONE='Austria_East_Zone'
    AUSTRIA__WEST__ZONE='Austria_West_Zone'
    BAHRAIN__STATE__GRID='Bahrain_State_Grid'
    BARBADOS__1938__BARBADOS__GRID='Barbados_1938_Barbados_Grid'
    BARBADOS__1938__BRITISH__WEST__INDIES__GRID='Barbados_1938_British_West_Indies_Grid'
    BELGE__LAMBERT__1950='Belge_Lambert_1950'
    BELGE__LAMBERT__1972='Belge_Lambert_1972'
    BERN__1898__BERN_LV_03_C='Bern_1898_Bern_LV03C'
    BRITISH__NATIONAL__GRID='British_National_Grid'
    CAMACUPA_TM__11__30_SE='Camacupa_TM_11_30_SE'
    CAMACUPA_TM__12_SE='Camacupa_TM_12_SE'
    ATS__1977_MTM__4__NOVA__SCOTIA='ATS_1977_MTM_4_Nova_Scotia'
    ATS__1977_MTM__5__NOVA__SCOTIA='ATS_1977_MTM_5_Nova_Scotia'
    ATS__1977__NEW__BRUNSWICK__STEREOGRAPHIC='ATS_1977_New_Brunswick_Stereographic'
    NAD__1927__10_TM_AEP__FOREST='NAD_1927_10TM_AEP_Forest'
    NAD__1927__10_TM_AEP__RESOURCE='NAD_1927_10TM_AEP_Resource'
    NAD__1927__3_TM__111='NAD_1927_3TM_111'
    NAD__1927__3_TM__114='NAD_1927_3TM_114'
    NAD__1927__3_TM__117='NAD_1927_3TM_117'
    NAD__1927__3_TM__120='NAD_1927_3TM_120'
    NAD__1927_CGQ_77_MTM__10_S_CO_PQ='NAD_1927_CGQ77_MTM_10_SCoPQ'
    NAD__1927_CGQ_77_MTM__2_S_CO_PQ='NAD_1927_CGQ77_MTM_2_SCoPQ'
    NAD__1927_CGQ_77_MTM__3_S_CO_PQ='NAD_1927_CGQ77_MTM_3_SCoPQ'
    NAD__1927_CGQ_77_MTM__4_S_CO_PQ='NAD_1927_CGQ77_MTM_4_SCoPQ'
    NAD__1927_CGQ_77_MTM__5_S_CO_PQ='NAD_1927_CGQ77_MTM_5_SCoPQ'
    NAD__1927_CGQ_77_MTM__6_S_CO_PQ='NAD_1927_CGQ77_MTM_6_SCoPQ'
    NAD__1927_CGQ_77_MTM__7_S_CO_PQ='NAD_1927_CGQ77_MTM_7_SCoPQ'
    NAD__1927_CGQ_77_MTM__8_S_CO_PQ='NAD_1927_CGQ77_MTM_8_SCoPQ'
    NAD__1927_CGQ_77_MTM__9_S_CO_PQ='NAD_1927_CGQ77_MTM_9_SCoPQ'
    NAD__1927_CGQ_77__QUEBEC__LAMBERT='NAD_1927_CGQ77_Quebec_Lambert'
    NAD__1927_CGQ_77_UTM__ZONE__17_N='NAD_1927_CGQ77_UTM_Zone_17N'
    NAD__1927_CGQ_77_UTM__ZONE__18_N='NAD_1927_CGQ77_UTM_Zone_18N'
    NAD__1927_CGQ_77_UTM__ZONE__19_N='NAD_1927_CGQ77_UTM_Zone_19N'
    NAD__1927_CGQ_77_UTM__ZONE__20_N='NAD_1927_CGQ77_UTM_Zone_20N'
    NAD__1927_CGQ_77_UTM__ZONE__21_N='NAD_1927_CGQ77_UTM_Zone_21N'
    NAD__1927_DEF__1976_MTM__10='NAD_1927_DEF_1976_MTM_10'
    NAD__1927_DEF__1976_MTM__11='NAD_1927_DEF_1976_MTM_11'
    NAD__1927_DEF__1976_MTM__12='NAD_1927_DEF_1976_MTM_12'
    NAD__1927_DEF__1976_MTM__13='NAD_1927_DEF_1976_MTM_13'
    NAD__1927_DEF__1976_MTM__14='NAD_1927_DEF_1976_MTM_14'
    NAD__1927_DEF__1976_MTM__15='NAD_1927_DEF_1976_MTM_15'
    NAD__1927_DEF__1976_MTM__16='NAD_1927_DEF_1976_MTM_16'
    NAD__1927_DEF__1976_MTM__17='NAD_1927_DEF_1976_MTM_17'
    NAD__1927_DEF__1976_MTM__8='NAD_1927_DEF_1976_MTM_8'
    NAD__1927_DEF__1976_MTM__9='NAD_1927_DEF_1976_MTM_9'
    NAD__1927_DEF__1976_UTM__ZONE__15_N='NAD_1927_DEF_1976_UTM_Zone_15N'
    NAD__1927_DEF__1976_UTM__ZONE__16_N='NAD_1927_DEF_1976_UTM_Zone_16N'
    NAD__1927_DEF__1976_UTM__ZONE__17_N='NAD_1927_DEF_1976_UTM_Zone_17N'
    NAD__1927_DEF__1976_UTM__ZONE__18_N='NAD_1927_DEF_1976_UTM_Zone_18N'
    NAD__1927_MTM__1='NAD_1927_MTM_1'
    NAD__1927_MTM__2='NAD_1927_MTM_2'
    NAD__1927_MTM__3='NAD_1927_MTM_3'
    NAD__1927_MTM__4='NAD_1927_MTM_4'
    NAD__1927_MTM__5='NAD_1927_MTM_5'
    NAD__1927_MTM__6='NAD_1927_MTM_6'
    NAD__1927__QUEBEC__LAMBERT='NAD_1927_Quebec_Lambert'
    NAD__1983__10_TM_AEP__FOREST='NAD_1983_10TM_AEP_Forest'
    NAD__1983__10_TM_AEP__RESOURCE='NAD_1983_10TM_AEP_Resource'
    NAD__1983__3_TM__111='NAD_1983_3TM_111'
    NAD__1983__3_TM__114='NAD_1983_3TM_114'
    NAD__1983__3_TM__117='NAD_1983_3TM_117'
    NAD__1983__3_TM__120='NAD_1983_3TM_120'
    NAD__1983_BC__ENVIRONMENT__ALBERS='NAD_1983_BC_Environment_Albers'
    NAD__1983_CRS_98_MTM__10='NAD_1983_CRS98_MTM_10'
    NAD__1983_CSRS_98_MTM__2_S_CO_PQ='NAD_1983_CSRS98_MTM_2_SCoPQ'
    NAD__1983_CRS_98_MTM__3='NAD_1983_CRS98_MTM_3'
    NAD__1983_CRS_98_MTM__4='NAD_1983_CRS98_MTM_4'
    NAD__1983_CRS_98_MTM__5='NAD_1983_CRS98_MTM_5'
    NAD__1983_CRS_98_MTM__6='NAD_1983_CRS98_MTM_6'
    NAD__1983_CRS_98_MTM__7='NAD_1983_CRS98_MTM_7'
    NAD__1983_CRS_98_MTM__8='NAD_1983_CRS98_MTM_8'
    NAD__1983_CRS_98_MTM__9='NAD_1983_CRS98_MTM_9'
    NAD__1983_CSRS_98__NEW__BRUNSWICK__STEREOGRAPHIC='NAD_1983_CSRS98_New_Brunswick_Stereographic'
    NAD__1983_CSRS_98__PRINCE__EDWARD__ISLAND='NAD_1983_CSRS98_Prince_Edward_Island'
    NAD__1983_CSRS_98_UTM__ZONE__21_N='NAD_1983_CSRS98_UTM_Zone_21N'
    NAD__1983_CSRS_98_UTM__ZONE__11_N='NAD_1983_CSRS98_UTM_Zone_11N'
    NAD__1983_CSRS_98_UTM__ZONE__12_N='NAD_1983_CSRS98_UTM_Zone_12N'
    NAD__1983_CSRS_98_UTM__ZONE__13_N='NAD_1983_CSRS98_UTM_Zone_13N'
    NAD__1983_CSRS_98_UTM__ZONE__17_N='NAD_1983_CSRS98_UTM_Zone_17N'
    NAD__1983_CSRS_98_UTM__ZONE__18_N='NAD_1983_CSRS98_UTM_Zone_18N'
    NAD__1983_CSRS_98_UTM__ZONE__19_N='NAD_1983_CSRS98_UTM_Zone_19N'
    NAD__1983_CSRS_98_UTM__ZONE__20_N='NAD_1983_CSRS98_UTM_Zone_20N'
    NAD__1983_MTM__1='NAD_1983_MTM_1'
    NAD__1983_MTM__10='NAD_1983_MTM_10'
    NAD__1983_MTM__11='NAD_1983_MTM_11'
    NAD__1983_MTM__12='NAD_1983_MTM_12'
    NAD__1983_MTM__13='NAD_1983_MTM_13'
    NAD__1983_MTM__14='NAD_1983_MTM_14'
    NAD__1983_MTM__15='NAD_1983_MTM_15'
    NAD__1983_MTM__16='NAD_1983_MTM_16'
    NAD__1983_MTM__17='NAD_1983_MTM_17'
    NAD__1983_MTM__2_S_CO_PQ='NAD_1983_MTM_2_SCoPQ'
    NAD__1983_MTM__2='NAD_1983_MTM_2'
    NAD__1983_MTM__3='NAD_1983_MTM_3'
    NAD__1983_MTM__4='NAD_1983_MTM_4'
    NAD__1983_MTM__5='NAD_1983_MTM_5'
    NAD__1983_MTM__6='NAD_1983_MTM_6'
    NAD__1983_MTM__7='NAD_1983_MTM_7'
    NAD__1983_MTM__8='NAD_1983_MTM_8'
    NAD__1983_MTM__9='NAD_1983_MTM_9'
    NAD__1983__QUEBEC__LAMBERT='NAD_1983_Quebec_Lambert'
    PRINCE__EDWARD__ISLAND__STEREOGRAPHIC='Prince_Edward_Island_Stereographic'
    CARTHAGE_TM__11_NE='Carthage_TM_11_NE'
    CENTRE__FRANCE='Centre_France'
    CH_1903_LV_03='CH1903_LV03'
    CH_1903_LV_95='CH1903+_LV95'
    CHOS__MALAL__1914__ARGENTINA__2='Chos_Malal_1914_Argentina_2'
    COLOMBIA__BOGOTA__ZONE='Colombia_Bogota_Zone'
    COLOMBIA__EAST__CENTRAL__ZONE='Colombia_East_Central_Zone'
    COLOMBIA__EAST__ZONE='Colombia_East_Zone'
    COLOMBIA__WEST__ZONE='Colombia_West_Zone'
    CORSE='Corse'
    DATUM__73__HAYFORD__GAUSS_I_GEO_E='Datum_73_Hayford_Gauss_IGeoE'
    DATUM__73__HAYFORD__GAUSS_IPCC='Datum_73_Hayford_Gauss_IPCC'
    DEIR_EZ__ZOR__LEVANT__STEREOGRAPHIC='Deir_ez_Zor_Levant_Stereographic'
    DEIR_EZ__ZOR__LEVANT__ZONE='Deir_ez_Zor_Levant_Zone'
    DEIR_EZ__ZOR__SYRIA__LAMBERT='Deir_ez_Zor_Syria_Lambert'
    DHDN__3__DEGREE__GAUSS__ZONE__1='DHDN_3_Degree_Gauss_Zone_1'
    DHDN__3__DEGREE__GAUSS__ZONE__2='DHDN_3_Degree_Gauss_Zone_2'
    DHDN__3__DEGREE__GAUSS__ZONE__3='DHDN_3_Degree_Gauss_Zone_3'
    DHDN__3__DEGREE__GAUSS__ZONE__4='DHDN_3_Degree_Gauss_Zone_4'
    DHDN__3__DEGREE__GAUSS__ZONE__5='DHDN_3_Degree_Gauss_Zone_5'
    DOMINICA__1945__BRITISH__WEST__INDIES__GRID='Dominica_1945_British_West_Indies_Grid'
    ED__1950_TM__0_N='ED_1950_TM_0_N'
    ED__1950_TM__5_NE='ED_1950_TM_5_NE'
    EGYPT__BLUE__BELT='Egypt_Blue_Belt'
    EGYPT__EXTENDED__PURPLE__BELT='Egypt_Extended_Purple_Belt'
    EGYPT__PURPLE__BELT='Egypt_Purple_Belt'
    EGYPT__RED__BELT='Egypt_Red_Belt'
    ELD__1979__LIBYA__10='ELD_1979_Libya_10'
    ELD__1979__LIBYA__11='ELD_1979_Libya_11'
    ELD__1979__LIBYA__12='ELD_1979_Libya_12'
    ELD__1979__LIBYA__13='ELD_1979_Libya_13'
    ELD__1979__LIBYA__5='ELD_1979_Libya_5'
    ELD__1979__LIBYA__6='ELD_1979_Libya_6'
    ELD__1979__LIBYA__7='ELD_1979_Libya_7'
    ELD__1979__LIBYA__8='ELD_1979_Libya_8'
    ELD__1979__LIBYA__9='ELD_1979_Libya_9'
    ELD__1979_TM__12_NE='ELD_1979_TM_12_NE'
    ESTONIAN__COORDINATE__SYSTEM_OF__1992='Estonian_Coordinate_System_of_1992'
    ETRF__1989_TM__BALTIC__1993='ETRF_1989_TM_Baltic_1993'
    FD__1958__IRAQ='FD_1958_Iraq'
    FINLAND__ZONE__1='Finland_Zone_1'
    FINLAND__ZONE__2='Finland_Zone_2'
    FINLAND__ZONE__3='Finland_Zone_3'
    FINLAND__ZONE__4='Finland_Zone_4'
    FRANCE_I='France_I'
    FRANCE_II='France_II'
    FRANCE_III='France_III'
    FRANCE_IV='France_IV'
    GERMANY__ZONE__1='Germany_Zone_1'
    GERMANY__ZONE__2='Germany_Zone_2'
    GERMANY__ZONE__3='Germany_Zone_3'
    GERMANY__ZONE__4='Germany_Zone_4'
    GERMANY__ZONE__5='Germany_Zone_5'
    GHANA__METRE__GRID='Ghana_Metre_Grid'
    GREEK__GRID='Greek_Grid'
    GRENADA__1953__BRITISH__WEST__INDIES__GRID='Grenada_1953_British_West_Indies_Grid'
    HANOI__1972_GK__106_NE='Hanoi_1972_GK_106_NE'
    HD__1972__EGYSEGES__ORSZAGOS__VETULETI='HD_1972_Egyseges_Orszagos_Vetuleti'
    HITO_XVIII__1963__ARGENTINA__2='Hito_XVIII_1963_Argentina_2'
    HONG__KONG__1980__GRID='Hong_Kong_1980_Grid'
    INDIAN__1960_TM__106_NE='Indian_1960_TM_106NE'
    KALIANPUR__1880__INDIA__ZONE__0='Kalianpur_1880_India_Zone_0'
    KALIANPUR__1880__INDIA__ZONE_I='Kalianpur_1880_India_Zone_I'
    KALIANPUR__1880__INDIA__ZONE_I_IA='Kalianpur_1880_India_Zone_IIa'
    KALIANPUR__1880__INDIA__ZONE_I_IB='Kalianpur_1880_India_Zone_IIb'
    KALIANPUR__1880__INDIA__ZONE_III='Kalianpur_1880_India_Zone_III'
    KALIANPUR__1880__INDIA__ZONE_IV='Kalianpur_1880_India_Zone_IV'
    KALIANPUR__1937__INDIA__ZONE_I_IB='Kalianpur_1937_India_Zone_IIb'
    KALIANPUR__1937_UTM__ZONE__45_N='Kalianpur_1937_UTM_Zone_45N'
    KALIANPUR__1937_UTM__ZONE__46_N='Kalianpur_1937_UTM_Zone_46N'
    KALIANPUR__1962__INDIA__ZONE_I='Kalianpur_1962_India_Zone_I'
    KALIANPUR__1962__INDIA__ZONE_I_IA='Kalianpur_1962_India_Zone_IIa'
    KALIANPUR__1962_UTM__ZONE__41_N='Kalianpur_1962_UTM_Zone_41N'
    KALIANPUR__1962_UTM__ZONE__42_N='Kalianpur_1962_UTM_Zone_42N'
    KALIANPUR__1962_UTM__ZONE__43_N='Kalianpur_1962_UTM_Zone_43N'
    KALIANPUR__1975__INDIA__ZONE_I='Kalianpur_1975_India_Zone_I'
    KALIANPUR__1975__INDIA__ZONE_I_IA='Kalianpur_1975_India_Zone_IIa'
    KALIANPUR__1975__INDIA__ZONE_I_IB='Kalianpur_1975_India_Zone_IIb'
    KALIANPUR__1975__INDIA__ZONE_III='Kalianpur_1975_India_Zone_III'
    KALIANPUR__1975__INDIA__ZONE_IV='Kalianpur_1975_India_Zone_IV'
    KALIANPUR__1975_UTM__ZONE__42_N='Kalianpur_1975_UTM_Zone_42N'
    KALIANPUR__1975_UTM__ZONE__43_N='Kalianpur_1975_UTM_Zone_43N'
    KALIANPUR__1975_UTM__ZONE__44_N='Kalianpur_1975_UTM_Zone_44N'
    KALIANPUR__1975_UTM__ZONE__45_N='Kalianpur_1975_UTM_Zone_45N'
    KALIANPUR__1975_UTM__ZONE__46_N='Kalianpur_1975_UTM_Zone_46N'
    KALIANPUR__1975_UTM__ZONE__47_N='Kalianpur_1975_UTM_Zone_47N'
    IRENET_95_IRISH__TRANSVERSE__MERCATOR='IRENET95_IRISH_Transverse_Mercator'
    IRISH__NATIONAL__GRID='Irish_National_Grid'
    ISRAEL_TM__GRID='Israel_TM_Grid'
    JAMAICA__1875__OLD__GRID='Jamaica_1875_Old_Grid'
    JAMAICA__GRID='Jamaica_Grid'
    JAPAN__ZONE__1='Japan_Zone_1'
    JAPAN__ZONE__10='Japan_Zone_10'
    JAPAN__ZONE__11='Japan_Zone_11'
    JAPAN__ZONE__12='Japan_Zone_12'
    JAPAN__ZONE__13='Japan_Zone_13'
    JAPAN__ZONE__14='Japan_Zone_14'
    JAPAN__ZONE__15='Japan_Zone_15'
    JAPAN__ZONE__16='Japan_Zone_16'
    JAPAN__ZONE__17='Japan_Zone_17'
    JAPAN__ZONE__18='Japan_Zone_18'
    JAPAN__ZONE__19='Japan_Zone_19'
    JAPAN__ZONE__2='Japan_Zone_2'
    JAPAN__ZONE__3='Japan_Zone_3'
    JAPAN__ZONE__4='Japan_Zone_4'
    JAPAN__ZONE__5='Japan_Zone_5'
    JAPAN__ZONE__6='Japan_Zone_6'
    JAPAN__ZONE__7='Japan_Zone_7'
    JAPAN__ZONE__8='Japan_Zone_8'
    JAPAN__ZONE__9='Japan_Zone_9'
    KERTAU__SINGAPORE__GRID='Kertau_Singapore_Grid'
    KOC__LAMBERT='KOC_Lambert'
    KOREAN__1985__KOREA__CENTRAL__BELT='Korean_1985_Korea_Central_Belt'
    KOREAN__1985__KOREA__EAST__BELT='Korean_1985_Korea_East_Belt'
    KOREAN__1985__KOREA__WEST__BELT='Korean_1985_Korea_West_Belt'
    KUDAMS_KTM='KUDAMS_KTM'
    KOC__LAMBERT_1='KOC_Lambert'
    KUDAMS_KTM_1='KUDAMS_KTM'
    LAKE__MARACAIBO__GRID_M_1='Lake_Maracaibo_Grid_M1'
    LAKE__MARACAIBO__GRID_M_3='Lake_Maracaibo_Grid_M3'
    LAKE__MARACAIBO__GRID='Lake_Maracaibo_Grid'
    LAKE__MARACAIBO__LA__ROSA__GRID='Lake_Maracaibo_La_Rosa_Grid'
    LIETUVOS__KOORDINACIU__SISTEMA='Lietuvos_Koordinaciu_Sistema'
    LISBOA__BESSEL__BONNE='Lisboa_Bessel_Bonne'
    LISBOA__HAYFORD__GAUSS_I_GEO_E='Lisboa_Hayford_Gauss_IGeoE'
    LISBOA__HAYFORD__GAUSS_IPCC='Lisboa_Hayford_Gauss_IPCC'
    LOCODJO__1965_TM__5_NW='Locodjo_1965_TM_5_NW'
    MADRID__1870__MADRID__SPAIN='Madrid_1870_Madrid_Spain'
    MGI__3__DEGREE__GAUSS__ZONE__5='MGI_3_Degree_Gauss_Zone_5'
    MGI__3__DEGREE__GAUSS__ZONE__6='MGI_3_Degree_Gauss_Zone_6'
    MGI__3__DEGREE__GAUSS__ZONE__7='MGI_3_Degree_Gauss_Zone_7'
    MGI__3__DEGREE__GAUSS__ZONE__8='MGI_3_Degree_Gauss_Zone_8'
    MGI__AUSTRIA__LAMBERT='MGI_Austria_Lambert'
    MGI__BALKANS__5='MGI_Balkans_5'
    MGI__BALKANS__6='MGI_Balkans_6'
    MGI__BALKANS__8='MGI_Balkans_8'
    MGI__BALKANS__8_1='MGI_Balkans_8'
    MGI_M_28='MGI_M28'
    MGI_M_31='MGI_M31'
    MGI_M_34='MGI_M34'
    MONTE__MARIO__ROME__ITALY__1='Monte_Mario_Rome_Italy_1'
    MONTE__MARIO__ROME__ITALY__2='Monte_Mario_Rome_Italy_2'
    MONTE__MARIO__ITALY__1='Monte_Mario_Italy_1'
    MONTE__MARIO__ITALY__2='Monte_Mario_Italy_2'
    MONTSERRAT__1958__BRITISH__WEST__INDIES__GRID='Montserrat_1958_British_West_Indies_Grid'
    MOUNT__DILLON__TOBAGO__GRID='Mount_Dillon_Tobago_Grid'
    NAD__1927__CUBA__NORTE='NAD_1927_Cuba_Norte'
    NAD__1927__CUBA__SUR='NAD_1927_Cuba_Sur'
    NAD__1927__GUATEMALA__NORTE='NAD_1927_Guatemala_Norte'
    NAD__1927__GUATEMALA__SUR='NAD_1927_Guatemala_Sur'
    NAD__1927__MICHIGAN__GEO_REF__METERS='NAD_1927_Michigan_GeoRef_Meters'
    NAD__1927__MICHIGAN__GEO_REF__FEET_US='NAD_1927_Michigan_GeoRef_Feet_US'
    NAD__1983_HARN__GUAM__MAP__GRID='NAD_1983_HARN_Guam_Map_Grid'
    NAD__1983__MICHIGAN__GEO_REF__METERS='NAD_1983_Michigan_GeoRef_Meters'
    NAD__1983__MICHIGAN__GEO_REF__FEET_US='NAD_1983_Michigan_GeoRef_Feet_US'
    GD__1949__NEW__ZEALAND__MAP__GRID='GD_1949_New_Zealand_Map_Grid'
    NEW__ZEALAND__NORTH__ISLAND='New_Zealand_North_Island'
    NEW__ZEALAND__SOUTH__ISLAND='New_Zealand_South_Island'
    NZGD__1949__AMURI__CIRCUIT='NZGD_1949_Amuri_Circuit'
    NZGD__1949__BAY_OF__PLENTY__CIRCUIT='NZGD_1949_Bay_of_Plenty_Circuit'
    NZGD__1949__BLUFF__CIRCUIT='NZGD_1949_Bluff_Circuit'
    NZGD__1949__BULLER__CIRCUIT='NZGD_1949_Buller_Circuit'
    NZGD__1949__COLLINGWOOD__CIRCUIT='NZGD_1949_Collingwood_Circuit'
    NZGD__1949__GAWLER__CIRCUIT='NZGD_1949_Gawler_Circuit'
    NZGD__1949__GREY__CIRCUIT='NZGD_1949_Grey_Circuit'
    NZGD__1949__HAWKES__BAY__CIRCUIT='NZGD_1949_Hawkes_Bay_Circuit'
    NZGD__1949__HOKITIKA__CIRCUIT='NZGD_1949_Hokitika_Circuit'
    NZGD__1949__JACKSONS__BAY__CIRCUIT='NZGD_1949_Jacksons_Bay_Circuit'
    NZGD__1949__KARAMEA__CIRCUIT='NZGD_1949_Karamea_Circuit'
    NZGD__1949__LINDIS__PEAK__CIRCUIT='NZGD_1949_Lindis_Peak_Circuit'
    NZGD__1949__MARLBOROUGH__CIRCUIT='NZGD_1949_Marlborough_Circuit'
    NZGD__1949__MOUNT__EDEN__CIRCUIT='NZGD_1949_Mount_Eden_Circuit'
    NZGD__1949__MOUNT__NICHOLAS__CIRCUIT='NZGD_1949_Mount_Nicholas_Circuit'
    NZGD__1949__MOUNT__PLEASANT__CIRCUIT='NZGD_1949_Mount_Pleasant_Circuit'
    NZGD__1949__MOUNT__YORK__CIRCUIT='NZGD_1949_Mount_York_Circuit'
    NZGD__1949__NELSON__CIRCUIT='NZGD_1949_Nelson_Circuit'
    NZGD__1949__NORTH__TAIERI__CIRCUIT='NZGD_1949_North_Taieri_Circuit'
    NZGD__1949__OBSERVATION__POINT__CIRCUIT='NZGD_1949_Observation_Point_Circuit'
    NZGD__1949__OKARITO__CIRCUIT='NZGD_1949_Okarito_Circuit'
    NZGD__1949__POVERTY__BAY__CIRCUIT='NZGD_1949_Poverty_Bay_Circuit'
    NZGD__1949__TARANAKI__CIRCUIT='NZGD_1949_Taranaki_Circuit'
    NZGD__1949__TIMARU__CIRCUIT='NZGD_1949_Timaru_Circuit'
    NZGD__1949__TUHIRANGI__CIRCUIT='NZGD_1949_Tuhirangi_Circuit'
    NZGD__1949_UTM__ZONE__58_S='NZGD_1949_UTM_Zone_58S'
    NZGD__1949_UTM__ZONE__59_S='NZGD_1949_UTM_Zone_59S'
    NZGD__1949_UTM__ZONE__60_S='NZGD_1949_UTM_Zone_60S'
    NZGD__1949__WAIRARAPA__CIRCUIT='NZGD_1949_Wairarapa_Circuit'
    NZGD__1949__WANGANUI__CIRCUIT='NZGD_1949_Wanganui_Circuit'
    NZGD__1949__WELLINGTON__CIRCUIT='NZGD_1949_Wellington_Circuit'
    NZGD__2000__AMURI__CIRCUIT='NZGD_2000_Amuri_Circuit'
    NZGD__2000__BAY_OF__PLENTY__CIRCUIT='NZGD_2000_Bay_of_Plenty_Circuit'
    NZGD__2000__BLUFF__CIRCUIT='NZGD_2000_Bluff_Circuit'
    NZGD__2000__BULLER__CIRCUIT='NZGD_2000_Buller_Circuit'
    NZGD__2000__COLLINGWOOD__CIRCUIT='NZGD_2000_Collingwood_Circuit'
    NZGD__2000__GAWLER__CIRCUIT='NZGD_2000_Gawler_Circuit'
    NZGD__2000__GREY__CIRCUIT='NZGD_2000_Grey_Circuit'
    NZGD__2000__HAWKES__BAY__CIRCUIT='NZGD_2000_Hawkes_Bay_Circuit'
    NZGD__2000__HOKITIKA__CIRCUIT='NZGD_2000_Hokitika_Circuit'
    NZGD__2000__JACKSONS__BAY__CIRCUIT='NZGD_2000_Jacksons_Bay_Circuit'
    NZGD__2000__KARAMEA__CIRCUIT='NZGD_2000_Karamea_Circuit'
    NZGD__2000__LINDIS__PEAK__CIRCUIT='NZGD_2000_Lindis_Peak_Circuit'
    NZGD__2000__MARLBOROUGH__CIRCUIT='NZGD_2000_Marlborough_Circuit'
    NZGD__2000__MOUNT__EDEN__CIRCUIT='NZGD_2000_Mount_Eden_Circuit'
    NZGD__2000__MOUNT__NICHOLAS__CIRCUIT='NZGD_2000_Mount_Nicholas_Circuit'
    NZGD__2000__MOUNT__PLEASANT__CIRCUIT='NZGD_2000_Mount_Pleasant_Circuit'
    NZGD__2000__MOUNT__YORK__CIRCUIT='NZGD_2000_Mount_York_Circuit'
    NZGD__2000__NELSON__CIRCUIT='NZGD_2000_Nelson_Circuit'
    NZGD__2000__NORTH__TAIERI__CIRCUIT='NZGD_2000_North_Taieri_Circuit'
    NZGD__2000__OBSERVATION__POINT__CIRCUIT='NZGD_2000_Observation_Point_Circuit'
    NZGD__2000__OKARITO__CIRCUIT='NZGD_2000_Okarito_Circuit'
    NZGD__2000__POVERTY__BAY__CIRCUIT='NZGD_2000_Poverty_Bay_Circuit'
    NZGD__2000__TARANAKI__CIRCUIT='NZGD_2000_Taranaki_Circuit'
    NZGD__2000__TIMARU__CIRCUIT='NZGD_2000_Timaru_Circuit'
    NZGD__2000__TUHIRANGI__CIRCUIT='NZGD_2000_Tuhirangi_Circuit'
    NZGD__2000_UTM__ZONE__58_S='NZGD_2000_UTM_Zone_58S'
    NZGD__2000_UTM__ZONE__59_S='NZGD_2000_UTM_Zone_59S'
    NZGD__2000_UTM__ZONE__60_S='NZGD_2000_UTM_Zone_60S'
    NZGD__2000__WAIRARAPA__CIRCUIT='NZGD_2000_Wairarapa_Circuit'
    NZGD__2000__WANGANUI__CIRCUIT='NZGD_2000_Wanganui_Circuit'
    NZGD__2000__WELLINGTON__CIRCUIT='NZGD_2000_Wellington_Circuit'
    GD__1949__NEW__ZEALAND__MAP__GRID_1='GD_1949_New_Zealand_Map_Grid'
    NEW__ZEALAND__NORTH__ISLAND_1='New_Zealand_North_Island'
    NEW__ZEALAND__SOUTH__ISLAND_1='New_Zealand_South_Island'
    NIGERIA__EAST__BELT='Nigeria_East_Belt'
    NIGERIA__MID__BELT='Nigeria_Mid_Belt'
    NIGERIA__WEST__BELT='Nigeria_West_Belt'
    NORD__ALGERIE__DEGREE='Nord_Algerie_Degree'
    NORD__ALGERIE__ANCIENNE__DEGREE='Nord_Algerie_Ancienne_Degree'
    SUD__ALGERIE__ANCIENNE='Sud_Algerie_Ancienne'
    NORD__ALGERIE='Nord_Algerie'
    NORD_DE__GUERRE='Nord_de_Guerre'
    NORD__FRANCE='Nord_France'
    NORD__MAROC__DEGREE='Nord_Maroc_Degree'
    NORD__MAROC='Nord_Maroc'
    NORD__TUNISIE='Nord_Tunisie'
    NGO__1948__BAERUM__KOMMUNE='NGO_1948_Baerum_Kommune'
    NGO__1948__BERGENHALVOEN='NGO_1948_Bergenhalvoen'
    NGO__1948__NORWAY__ZONE__1='NGO_1948_Norway_Zone_1'
    NGO__1948__NORWAY__ZONE__2='NGO_1948_Norway_Zone_2'
    NGO__1948__NORWAY__ZONE__3='NGO_1948_Norway_Zone_3'
    NGO__1948__NORWAY__ZONE__4='NGO_1948_Norway_Zone_4'
    NGO__1948__NORWAY__ZONE__5='NGO_1948_Norway_Zone_5'
    NGO__1948__NORWAY__ZONE__6='NGO_1948_Norway_Zone_6'
    NGO__1948__NORWAY__ZONE__7='NGO_1948_Norway_Zone_7'
    NGO__1948__NORWAY__ZONE__8='NGO_1948_Norway_Zone_8'
    NGO__1948__OSLO__KOMMUNE='NGO_1948_Oslo_Kommune'
    NGO__1948__OSLO__NORWAY__ZONE__1='NGO_1948_Oslo_Norway_Zone_1'
    NGO__1948__OSLO__NORWAY__ZONE__2='NGO_1948_Oslo_Norway_Zone_2'
    NGO__1948__OSLO__NORWAY__ZONE__3='NGO_1948_Oslo_Norway_Zone_3'
    NGO__1948__OSLO__NORWAY__ZONE__4='NGO_1948_Oslo_Norway_Zone_4'
    NGO__1948__OSLO__NORWAY__ZONE__5='NGO_1948_Oslo_Norway_Zone_5'
    NGO__1948__OSLO__NORWAY__ZONE__6='NGO_1948_Oslo_Norway_Zone_6'
    NGO__1948__OSLO__NORWAY__ZONE__7='NGO_1948_Oslo_Norway_Zone_7'
    NGO__1948__OSLO__NORWAY__ZONE__8='NGO_1948_Oslo_Norway_Zone_8'
    NTF__FRANCE_I_DEGREES='NTF_France_I_degrees'
    NTF__FRANCE_II_DEGREES='NTF_France_II_degrees'
    NTF__FRANCE_III_DEGREES='NTF_France_III_degrees'
    NTF__FRANCE_IV_DEGREES='NTF_France_IV_degrees'
    PALESTINE__1923__ISRAEL_CS__GRID='Palestine_1923_Israel_CS_Grid'
    PALESTINE__1923__PALESTINE__BELT='Palestine_1923_Palestine_Belt'
    PALESTINE__1923__PALESTINE__GRID='Palestine_1923_Palestine_Grid'
    PAMPA_DEL__CASTILLO__ARGENTINA__2='Pampa_del_Castillo_Argentina_2'
    PERU__CENTRAL__ZONE='Peru_Central_Zone'
    PERU__EAST__ZONE='Peru_East_Zone'
    PERU__WEST__ZONE='Peru_West_Zone'
    PHILIPPINES__ZONE_I='Philippines_Zone_I'
    PHILIPPINES__ZONE_II='Philippines_Zone_II'
    PHILIPPINES__ZONE_III='Philippines_Zone_III'
    PHILIPPINES__ZONE_IV='Philippines_Zone_IV'
    PHILIPPINES__ZONE_V='Philippines_Zone_V'
    PORTUGUESE__NATIONAL__GRID='Portuguese_National_Grid'
    QATAR__1948__QATAR__GRID='Qatar_1948_Qatar_Grid'
    QATAR__NATIONAL__GRID='Qatar_National_Grid'
    RD__OLD='RD_Old'
    RGF__1993__LAMBERT__93='RGF_1993_Lambert_93'
    RIJKSDRIEHOEKSTELSEL__NEW='Rijksdriehoekstelsel_New'
    RT_90__25_GON_W='RT90_25_gon_W'
    SJTSK__FERRO__KROVAK__EAST__NORTH='S-JTSK_Ferro_Krovak_East_North'
    SJTSK__FERRO__KROVAK='S-JTSK_Ferro_Krovak'
    SJTSK__KROVAK__EAST__NORTH='S-JTSK_Krovak_East_North'
    SJTSK__KROVAK='S-JTSK_Krovak'
    SAD__1969__BRAZIL__POLYCONIC='SAD_1969_Brazil_Polyconic'
    SAHARA__DEGREE='Sahara_Degree'
    SAHARA='Sahara'
    SIERRA__LEONE__1924__NEW__COLONY__GRID='Sierra_Leone_1924_New_Colony_Grid'
    SIERRA__LEONE__1924__NEW__WAR__OFFICE__GRID='Sierra_Leone_1924_New_War_Office_Grid'
    ST__KITTS__1955__BRITISH__WEST__INDIES__GRID='St_Kitts_1955_British_West_Indies_Grid'
    ST__LUCIA__1955__BRITISH__WEST__INDIES__GRID='St_Lucia_1955_British_West_Indies_Grid'
    ST__VINCENT__1945__BRITISH__WEST__INDIES__GRID='St_Vincent_1945_British_West_Indies_Grid'
    STEREO__33='Stereo_33'
    STEREO__70='Stereo_70'
    SUD__ALGERIE__DEGREE='Sud_Algerie_Degree'
    SUD__ALGERIE__ANCIENNE__DEGREE='Sud_Algerie_Ancienne_Degree'
    SUD__ALGERIE='Sud_Algerie'
    SUD__FRANCE='Sud_France'
    SUD__MAROC__DEGREE='Sud_Maroc_Degree'
    SUD__MAROC='Sud_Maroc'
    SUD__TUNISIE='Sud_Tunisie'
    SWEDISH__NATIONAL__GRID='Swedish_National_Grid'
    TRINIDAD__1903__TRINIDAD__GRID='Trinidad_1903_Trinidad_Grid'
    UWPP__1992='UWPP_1992'
    UWPP__2000_PAS__5='UWPP_2000_pas_5'
    UWPP__2000_PAS__6='UWPP_2000_pas_6'
    UWPP__2000_PAS__7='UWPP_2000_pas_7'
    UWPP__2000_PAS__8='UWPP_2000_pas_8'
    WGS__1972_BE_TM__106_NE='WGS_1972_BE_TM_106_NE'
    WGS__1984_TM__36_SE='WGS_1984_TM_36_SE'
    ZANDERIJ__SURINAME__OLD_TM='Zanderij_Suriname_Old_TM'
    ZANDERIJ__SURINAME_TM='Zanderij_Suriname_TM'
    ZANDERIJ_TM__54_NW='Zanderij_TM_54_NW'
    NORTH__POLE__AZIMUTHAL__EQUIDISTANT='North_Pole_Azimuthal_Equidistant'
    NORTH__POLE__GNOMONIC='North_Pole_Gnomonic'
    NORTH__POLE__LAMBERT__AZIMUTHAL__EQUAL__AREA='North_Pole_Lambert_Azimuthal_Equal_Area'
    NORTH__POLE__ORTHOGRAPHIC='North_Pole_Orthographic'
    NORTH__POLE__STEREOGRAPHIC='North_Pole_Stereographic'
    SOUTH__POLE__AZIMUTHAL__EQUIDISTANT='South_Pole_Azimuthal_Equidistant'
    SOUTH__POLE__GNOMONIC='South_Pole_Gnomonic'
    SOUTH__POLE__LAMBERT__AZIMUTHAL__EQUAL__AREA='South_Pole_Lambert_Azimuthal_Equal_Area'
    SOUTH__POLE__ORTHOGRAPHIC='South_Pole_Orthographic'
    SOUTH__POLE__STEREOGRAPHIC='South_Pole_Stereographic'
    UPS__NORTH='UPS_North'
    UPS__SOUTH='UPS_South'
    NAD__1927__STATE_PLANE__ALABAMA__EAST_FIPS__0101='NAD_1927_StatePlane_Alabama_East_FIPS_0101'
    NAD__1927__STATE_PLANE__ALABAMA__WEST_FIPS__0102='NAD_1927_StatePlane_Alabama_West_FIPS_0102'
    NAD__1927__STATE_PLANE__ALASKA__1_FIPS__5001='NAD_1927_StatePlane_Alaska_1_FIPS_5001'
    NAD__1927__STATE_PLANE__ALASKA__10_FIPS__5010='NAD_1927_StatePlane_Alaska_10_FIPS_5010'
    NAD__1927__STATE_PLANE__ALASKA__2_FIPS__5002='NAD_1927_StatePlane_Alaska_2_FIPS_5002'
    NAD__1927__STATE_PLANE__ALASKA__3_FIPS__5003='NAD_1927_StatePlane_Alaska_3_FIPS_5003'
    NAD__1927__STATE_PLANE__ALASKA__4_FIPS__5004='NAD_1927_StatePlane_Alaska_4_FIPS_5004'
    NAD__1927__STATE_PLANE__ALASKA__5_FIPS__5005='NAD_1927_StatePlane_Alaska_5_FIPS_5005'
    NAD__1927__STATE_PLANE__ALASKA__6_FIPS__5006='NAD_1927_StatePlane_Alaska_6_FIPS_5006'
    NAD__1927__STATE_PLANE__ALASKA__7_FIPS__5007='NAD_1927_StatePlane_Alaska_7_FIPS_5007'
    NAD__1927__STATE_PLANE__ALASKA__8_FIPS__5008='NAD_1927_StatePlane_Alaska_8_FIPS_5008'
    NAD__1927__STATE_PLANE__ALASKA__9_FIPS__5009='NAD_1927_StatePlane_Alaska_9_FIPS_5009'
    NAD__1927__STATE_PLANE__ARIZONA__CENTRAL_FIPS__0202='NAD_1927_StatePlane_Arizona_Central_FIPS_0202'
    NAD__1927__STATE_PLANE__ARIZONA__EAST_FIPS__0201='NAD_1927_StatePlane_Arizona_East_FIPS_0201'
    NAD__1927__STATE_PLANE__ARIZONA__WEST_FIPS__0203='NAD_1927_StatePlane_Arizona_West_FIPS_0203'
    NAD__1927__STATE_PLANE__ARKANSAS__NORTH_FIPS__0301='NAD_1927_StatePlane_Arkansas_North_FIPS_0301'
    NAD__1927__STATE_PLANE__ARKANSAS__SOUTH_FIPS__0302='NAD_1927_StatePlane_Arkansas_South_FIPS_0302'
    NAD__1927__STATE_PLANE__CALIFORNIA_I_FIPS__0401='NAD_1927_StatePlane_California_I_FIPS_0401'
    NAD__1927__STATE_PLANE__CALIFORNIA_II_FIPS__0402='NAD_1927_StatePlane_California_II_FIPS_0402'
    NAD__1927__STATE_PLANE__CALIFORNIA_III_FIPS__0403='NAD_1927_StatePlane_California_III_FIPS_0403'
    NAD__1927__STATE_PLANE__CALIFORNIA_IV_FIPS__0404='NAD_1927_StatePlane_California_IV_FIPS_0404'
    NAD__1927__STATE_PLANE__CALIFORNIA_V_FIPS__0405='NAD_1927_StatePlane_California_V_FIPS_0405'
    NAD__1927__STATE_PLANE__CALIFORNIA_VI_FIPS__0406='NAD_1927_StatePlane_California_VI_FIPS_0406'
    NAD__1927__STATE_PLANE__CALIFORNIA_VII_FIPS__0407='NAD_1927_StatePlane_California_VII_FIPS_0407'
    NAD__1927__STATE_PLANE__COLORADO__CENTRAL_FIPS__0502='NAD_1927_StatePlane_Colorado_Central_FIPS_0502'
    NAD__1927__STATE_PLANE__COLORADO__NORTH_FIPS__0501='NAD_1927_StatePlane_Colorado_North_FIPS_0501'
    NAD__1927__STATE_PLANE__COLORADO__SOUTH_FIPS__0503='NAD_1927_StatePlane_Colorado_South_FIPS_0503'
    NAD__1927__STATE_PLANE__CONNECTICUT_FIPS__0600='NAD_1927_StatePlane_Connecticut_FIPS_0600'
    NAD__1927__STATE_PLANE__DELAWARE_FIPS__0700='NAD_1927_StatePlane_Delaware_FIPS_0700'
    NAD__1927__STATE_PLANE__FLORIDA__EAST_FIPS__0901='NAD_1927_StatePlane_Florida_East_FIPS_0901'
    NAD__1927__STATE_PLANE__FLORIDA__NORTH_FIPS__0903='NAD_1927_StatePlane_Florida_North_FIPS_0903'
    NAD__1927__STATE_PLANE__FLORIDA__WEST_FIPS__0902='NAD_1927_StatePlane_Florida_West_FIPS_0902'
    NAD__1927__STATE_PLANE__GEORGIA__EAST_FIPS__1001='NAD_1927_StatePlane_Georgia_East_FIPS_1001'
    NAD__1927__STATE_PLANE__GEORGIA__WEST_FIPS__1002='NAD_1927_StatePlane_Georgia_West_FIPS_1002'
    NAD__1927__STATE_PLANE__GUAM_FIPS__5400='NAD_1927_StatePlane_Guam_FIPS_5400'
    NAD__1927__STATE_PLANE__IDAHO__CENTRAL_FIPS__1102='NAD_1927_StatePlane_Idaho_Central_FIPS_1102'
    NAD__1927__STATE_PLANE__IDAHO__EAST_FIPS__1101='NAD_1927_StatePlane_Idaho_East_FIPS_1101'
    NAD__1927__STATE_PLANE__IDAHO__WEST_FIPS__1103='NAD_1927_StatePlane_Idaho_West_FIPS_1103'
    NAD__1927__STATE_PLANE__ILLINOIS__EAST_FIPS__1201='NAD_1927_StatePlane_Illinois_East_FIPS_1201'
    NAD__1927__STATE_PLANE__ILLINOIS__WEST_FIPS__1202='NAD_1927_StatePlane_Illinois_West_FIPS_1202'
    NAD__1927__STATE_PLANE__INDIANA__EAST_FIPS__1301='NAD_1927_StatePlane_Indiana_East_FIPS_1301'
    NAD__1927__STATE_PLANE__INDIANA__WEST_FIPS__1302='NAD_1927_StatePlane_Indiana_West_FIPS_1302'
    NAD__1927__STATE_PLANE__IOWA__NORTH_FIPS__1401='NAD_1927_StatePlane_Iowa_North_FIPS_1401'
    NAD__1927__STATE_PLANE__IOWA__SOUTH_FIPS__1402='NAD_1927_StatePlane_Iowa_South_FIPS_1402'
    NAD__1927__STATE_PLANE__KANSAS__NORTH_FIPS__1501='NAD_1927_StatePlane_Kansas_North_FIPS_1501'
    NAD__1927__STATE_PLANE__KANSAS__SOUTH_FIPS__1502='NAD_1927_StatePlane_Kansas_South_FIPS_1502'
    NAD__1927__STATE_PLANE__KENTUCKY__NORTH_FIPS__1601='NAD_1927_StatePlane_Kentucky_North_FIPS_1601'
    NAD__1927__STATE_PLANE__KENTUCKY__SOUTH_FIPS__1602='NAD_1927_StatePlane_Kentucky_South_FIPS_1602'
    NAD__1927__STATE_PLANE__LOUISIANA__NORTH_FIPS__1701='NAD_1927_StatePlane_Louisiana_North_FIPS_1701'
    NAD__1927__STATE_PLANE__LOUISIANA__SOUTH_FIPS__1702='NAD_1927_StatePlane_Louisiana_South_FIPS_1702'
    NAD__1927__STATE_PLANE__MAINE__EAST_FIPS__1801='NAD_1927_StatePlane_Maine_East_FIPS_1801'
    NAD__1927__STATE_PLANE__MAINE__WEST_FIPS__1802='NAD_1927_StatePlane_Maine_West_FIPS_1802'
    NAD__1927__STATE_PLANE__MARYLAND_FIPS__1900='NAD_1927_StatePlane_Maryland_FIPS_1900'
    NAD__1927__STATE_PLANE__MASSACHUSETTS__ISLAND_FIPS__2002='NAD_1927_StatePlane_Massachusetts_Island_FIPS_2002'
    NAD__1927__STATE_PLANE__MASSACHUSETTS__MAINLAND_FIPS__2001='NAD_1927_StatePlane_Massachusetts_Mainland_FIPS_2001'
    NAD__1927__STATE_PLANE__MICHIGAN__CENTRAL_FIPS__2112='NAD_1927_StatePlane_Michigan_Central_FIPS_2112'
    NAD__1927__STATE_PLANE__MICHIGAN__NORTH_FIPS__2111='NAD_1927_StatePlane_Michigan_North_FIPS_2111'
    NAD__1927__STATE_PLANE__MICHIGAN__SOUTH_FIPS__2113='NAD_1927_StatePlane_Michigan_South_FIPS_2113'
    NAD__1927__STATE_PLANE__MINNESOTA__CENTRAL_FIPS__2202='NAD_1927_StatePlane_Minnesota_Central_FIPS_2202'
    NAD__1927__STATE_PLANE__MINNESOTA__NORTH_FIPS__2201='NAD_1927_StatePlane_Minnesota_North_FIPS_2201'
    NAD__1927__STATE_PLANE__MINNESOTA__SOUTH_FIPS__2203='NAD_1927_StatePlane_Minnesota_South_FIPS_2203'
    NAD__1927__STATE_PLANE__MISSISSIPPI__EAST_FIPS__2301='NAD_1927_StatePlane_Mississippi_East_FIPS_2301'
    NAD__1927__STATE_PLANE__MISSISSIPPI__WEST_FIPS__2302='NAD_1927_StatePlane_Mississippi_West_FIPS_2302'
    NAD__1927__STATE_PLANE__MISSOURI__CENTRAL_FIPS__2402='NAD_1927_StatePlane_Missouri_Central_FIPS_2402'
    NAD__1927__STATE_PLANE__MISSOURI__EAST_FIPS__2401='NAD_1927_StatePlane_Missouri_East_FIPS_2401'
    NAD__1927__STATE_PLANE__MISSOURI__WEST_FIPS__2403='NAD_1927_StatePlane_Missouri_West_FIPS_2403'
    NAD__1927__STATE_PLANE__MONTANA__CENTRAL_FIPS__2502='NAD_1927_StatePlane_Montana_Central_FIPS_2502'
    NAD__1927__STATE_PLANE__MONTANA__NORTH_FIPS__2501='NAD_1927_StatePlane_Montana_North_FIPS_2501'
    NAD__1927__STATE_PLANE__MONTANA__SOUTH_FIPS__2503='NAD_1927_StatePlane_Montana_South_FIPS_2503'
    NAD__1927__STATE_PLANE__NEBRASKA__NORTH_FIPS__2601='NAD_1927_StatePlane_Nebraska_North_FIPS_2601'
    NAD__1927__STATE_PLANE__NEBRASKA__SOUTH_FIPS__2602='NAD_1927_StatePlane_Nebraska_South_FIPS_2602'
    NAD__1927__STATE_PLANE__NEVADA__CENTRAL_FIPS__2702='NAD_1927_StatePlane_Nevada_Central_FIPS_2702'
    NAD__1927__STATE_PLANE__NEVADA__EAST_FIPS__2701='NAD_1927_StatePlane_Nevada_East_FIPS_2701'
    NAD__1927__STATE_PLANE__NEVADA__WEST_FIPS__2703='NAD_1927_StatePlane_Nevada_West_FIPS_2703'
    NAD__1927__STATE_PLANE__NEW__HAMPSHIRE_FIPS__2800='NAD_1927_StatePlane_New_Hampshire_FIPS_2800'
    NAD__1927__STATE_PLANE__NEW__JERSEY_FIPS__2900='NAD_1927_StatePlane_New_Jersey_FIPS_2900'
    NAD__1927__STATE_PLANE__NEW__MEXICO__CENTRAL_FIPS__3002='NAD_1927_StatePlane_New_Mexico_Central_FIPS_3002'
    NAD__1927__STATE_PLANE__NEW__MEXICO__EAST_FIPS__3001='NAD_1927_StatePlane_New_Mexico_East_FIPS_3001'
    NAD__1927__STATE_PLANE__NEW__MEXICO__WEST_FIPS__3003='NAD_1927_StatePlane_New_Mexico_West_FIPS_3003'
    NAD__1927__STATE_PLANE__NEW__YORK__CENTRAL_FIPS__3102='NAD_1927_StatePlane_New_York_Central_FIPS_3102'
    NAD__1927__STATE_PLANE__NEW__YORK__EAST_FIPS__3101='NAD_1927_StatePlane_New_York_East_FIPS_3101'
    NAD__1927__STATE_PLANE__NEW__YORK__LONG__ISLAND_FIPS__3104='NAD_1927_StatePlane_New_York_Long_Island_FIPS_3104'
    NAD__1927__STATE_PLANE__NEW__YORK__WEST_FIPS__3103='NAD_1927_StatePlane_New_York_West_FIPS_3103'
    NAD__1927__STATE_PLANE__NORTH__CAROLINA_FIPS__3200='NAD_1927_StatePlane_North_Carolina_FIPS_3200'
    NAD__1927__STATE_PLANE__NORTH__DAKOTA__NORTH_FIPS__3301='NAD_1927_StatePlane_North_Dakota_North_FIPS_3301'
    NAD__1927__STATE_PLANE__NORTH__DAKOTA__SOUTH_FIPS__3302='NAD_1927_StatePlane_North_Dakota_South_FIPS_3302'
    NAD__1927__STATE_PLANE__OHIO__NORTH_FIPS__3401='NAD_1927_StatePlane_Ohio_North_FIPS_3401'
    NAD__1927__STATE_PLANE__OHIO__SOUTH_FIPS__3402='NAD_1927_StatePlane_Ohio_South_FIPS_3402'
    NAD__1927__STATE_PLANE__OKLAHOMA__NORTH_FIPS__3501='NAD_1927_StatePlane_Oklahoma_North_FIPS_3501'
    NAD__1927__STATE_PLANE__OKLAHOMA__SOUTH_FIPS__3502='NAD_1927_StatePlane_Oklahoma_South_FIPS_3502'
    NAD__1927__STATE_PLANE__OREGON__NORTH_FIPS__3601='NAD_1927_StatePlane_Oregon_North_FIPS_3601'
    NAD__1927__STATE_PLANE__OREGON__SOUTH_FIPS__3602='NAD_1927_StatePlane_Oregon_South_FIPS_3602'
    NAD__1927__STATE_PLANE__PENNSYLVANIA__NORTH_FIPS__3701='NAD_1927_StatePlane_Pennsylvania_North_FIPS_3701'
    NAD__1927__STATE_PLANE__PENNSYLVANIA__SOUTH_FIPS__3702='NAD_1927_StatePlane_Pennsylvania_South_FIPS_3702'
    NAD__1927__STATE_PLANE__PUERTO__RICO_FIPS__5201='NAD_1927_StatePlane_Puerto_Rico_FIPS_5201'
    NAD__1927__STATE_PLANE__RHODE__ISLAND_FIPS__3800='NAD_1927_StatePlane_Rhode_Island_FIPS_3800'
    NAD__1927__STATE_PLANE__SOUTH__CAROLINA__NORTH_FIPS__3901='NAD_1927_StatePlane_South_Carolina_North_FIPS_3901'
    NAD__1927__STATE_PLANE__SOUTH__CAROLINA__SOUTH_FIPS__3902='NAD_1927_StatePlane_South_Carolina_South_FIPS_3902'
    NAD__1927__STATE_PLANE__SOUTH__DAKOTA__NORTH_FIPS__4001='NAD_1927_StatePlane_South_Dakota_North_FIPS_4001'
    NAD__1927__STATE_PLANE__SOUTH__DAKOTA__SOUTH_FIPS__4002='NAD_1927_StatePlane_South_Dakota_South_FIPS_4002'
    NAD__1927__STATE_PLANE__TENNESSEE_FIPS__4100='NAD_1927_StatePlane_Tennessee_FIPS_4100'
    NAD__1927__STATE_PLANE__TEXAS__CENTRAL_FIPS__4203='NAD_1927_StatePlane_Texas_Central_FIPS_4203'
    NAD__1927__STATE_PLANE__TEXAS__NORTH__CENTRAL_FIPS__4202='NAD_1927_StatePlane_Texas_North_Central_FIPS_4202'
    NAD__1927__STATE_PLANE__TEXAS__NORTH_FIPS__4201='NAD_1927_StatePlane_Texas_North_FIPS_4201'
    NAD__1927__STATE_PLANE__TEXAS__SOUTH__CENTRAL_FIPS__4204='NAD_1927_StatePlane_Texas_South_Central_FIPS_4204'
    NAD__1927__STATE_PLANE__TEXAS__SOUTH_FIPS__4205='NAD_1927_StatePlane_Texas_South_FIPS_4205'
    NAD__1927__STATE_PLANE__UTAH__CENTRAL_FIPS__4302='NAD_1927_StatePlane_Utah_Central_FIPS_4302'
    NAD__1927__STATE_PLANE__UTAH__NORTH_FIPS__4301='NAD_1927_StatePlane_Utah_North_FIPS_4301'
    NAD__1927__STATE_PLANE__UTAH__SOUTH_FIPS__4303='NAD_1927_StatePlane_Utah_South_FIPS_4303'
    NAD__1927__STATE_PLANE__VERMONT_FIPS__3400='NAD_1927_StatePlane_Vermont_FIPS_3400'
    NAD__1927__STATE_PLANE__VIRGINIA__NORTH_FIPS__4501='NAD_1927_StatePlane_Virginia_North_FIPS_4501'
    NAD__1927__STATE_PLANE__VIRGINIA__SOUTH_FIPS__4502='NAD_1927_StatePlane_Virginia_South_FIPS_4502'
    NAD__1927__STATE_PLANE__WASHINGTON__NORTH_FIPS__4601='NAD_1927_StatePlane_Washington_North_FIPS_4601'
    NAD__1927__STATE_PLANE__WASHINGTON__SOUTH_FIPS__4602='NAD_1927_StatePlane_Washington_South_FIPS_4602'
    NAD__1927__STATE_PLANE__WEST__VIRGINIA__NORTH_FIPS__4701='NAD_1927_StatePlane_West_Virginia_North_FIPS_4701'
    NAD__1927__STATE_PLANE__WEST__VIRGINIA__SOUTH_FIPS__4702='NAD_1927_StatePlane_West_Virginia_South_FIPS_4702'
    NAD__1927__STATE_PLANE__WISCONSIN__CENTRAL_FIPS__4802='NAD_1927_StatePlane_Wisconsin_Central_FIPS_4802'
    NAD__1927__STATE_PLANE__WISCONSIN__NORTH_FIPS__4801='NAD_1927_StatePlane_Wisconsin_North_FIPS_4801'
    NAD__1927__STATE_PLANE__WISCONSIN__SOUTH_FIPS__4803='NAD_1927_StatePlane_Wisconsin_South_FIPS_4803'
    NAD__1927__STATE_PLANE__WYOMING__EAST__CENTRAL_FIPS__4902='NAD_1927_StatePlane_Wyoming_East_Central_FIPS_4902'
    NAD__1927__STATE_PLANE__WYOMING__EAST_FIPS__4901='NAD_1927_StatePlane_Wyoming_East_FIPS_4901'
    NAD__1927__STATE_PLANE__WYOMING__WEST__CENTRAL_FIPS__4903='NAD_1927_StatePlane_Wyoming_West_Central_FIPS_4903'
    NAD__1927__STATE_PLANE__WYOMING__WEST_FIPS__4904='NAD_1927_StatePlane_Wyoming_West_FIPS_4904'
    NAD__1983__STATE_PLANE__ALABAMA__EAST_FIPS__0101='NAD_1983_StatePlane_Alabama_East_FIPS_0101'
    NAD__1983__STATE_PLANE__ALABAMA__WEST_FIPS__0102='NAD_1983_StatePlane_Alabama_West_FIPS_0102'
    NAD__1983__STATE_PLANE__ALASKA__1_FIPS__5001='NAD_1983_StatePlane_Alaska_1_FIPS_5001'
    NAD__1983__STATE_PLANE__ALASKA__10_FIPS__5010='NAD_1983_StatePlane_Alaska_10_FIPS_5010'
    NAD__1983__STATE_PLANE__ALASKA__2_FIPS__5002='NAD_1983_StatePlane_Alaska_2_FIPS_5002'
    NAD__1983__STATE_PLANE__ALASKA__3_FIPS__5003='NAD_1983_StatePlane_Alaska_3_FIPS_5003'
    NAD__1983__STATE_PLANE__ALASKA__4_FIPS__5004='NAD_1983_StatePlane_Alaska_4_FIPS_5004'
    NAD__1983__STATE_PLANE__ALASKA__5_FIPS__5005='NAD_1983_StatePlane_Alaska_5_FIPS_5005'
    NAD__1983__STATE_PLANE__ALASKA__6_FIPS__5006='NAD_1983_StatePlane_Alaska_6_FIPS_5006'
    NAD__1983__STATE_PLANE__ALASKA__7_FIPS__5007='NAD_1983_StatePlane_Alaska_7_FIPS_5007'
    NAD__1983__STATE_PLANE__ALASKA__8_FIPS__5008='NAD_1983_StatePlane_Alaska_8_FIPS_5008'
    NAD__1983__STATE_PLANE__ALASKA__9_FIPS__5009='NAD_1983_StatePlane_Alaska_9_FIPS_5009'
    NAD__1983__STATE_PLANE__ARIZONA__CENTRAL_FIPS__0202='NAD_1983_StatePlane_Arizona_Central_FIPS_0202'
    NAD__1983__STATE_PLANE__ARIZONA__EAST_FIPS__0201='NAD_1983_StatePlane_Arizona_East_FIPS_0201'
    NAD__1983__STATE_PLANE__ARIZONA__WEST_FIPS__0203='NAD_1983_StatePlane_Arizona_West_FIPS_0203'
    NAD__1983__STATE_PLANE__ARKANSAS__NORTH_FIPS__0301='NAD_1983_StatePlane_Arkansas_North_FIPS_0301'
    NAD__1983__STATE_PLANE__ARKANSAS__SOUTH_FIPS__0302='NAD_1983_StatePlane_Arkansas_South_FIPS_0302'
    NAD__1983__STATE_PLANE__CALIFORNIA_I_FIPS__0401='NAD_1983_StatePlane_California_I_FIPS_0401'
    NAD__1983__STATE_PLANE__CALIFORNIA_II_FIPS__0402='NAD_1983_StatePlane_California_II_FIPS_0402'
    NAD__1983__STATE_PLANE__CALIFORNIA_III_FIPS__0403='NAD_1983_StatePlane_California_III_FIPS_0403'
    NAD__1983__STATE_PLANE__CALIFORNIA_IV_FIPS__0404='NAD_1983_StatePlane_California_IV_FIPS_0404'
    NAD__1983__STATE_PLANE__CALIFORNIA_V_FIPS__0405='NAD_1983_StatePlane_California_V_FIPS_0405'
    NAD__1983__STATE_PLANE__CALIFORNIA_VI_FIPS__0406='NAD_1983_StatePlane_California_VI_FIPS_0406'
    NAD__1983__STATE_PLANE__COLORADO__CENTRAL_FIPS__0502='NAD_1983_StatePlane_Colorado_Central_FIPS_0502'
    NAD__1983__STATE_PLANE__COLORADO__NORTH_FIPS__0501='NAD_1983_StatePlane_Colorado_North_FIPS_0501'
    NAD__1983__STATE_PLANE__COLORADO__SOUTH_FIPS__0503='NAD_1983_StatePlane_Colorado_South_FIPS_0503'
    NAD__1983__STATE_PLANE__CONNECTICUT_FIPS__0600='NAD_1983_StatePlane_Connecticut_FIPS_0600'
    NAD__1983__STATE_PLANE__DELAWARE_FIPS__0700='NAD_1983_StatePlane_Delaware_FIPS_0700'
    NAD__1983__STATE_PLANE__FLORIDA__EAST_FIPS__0901='NAD_1983_StatePlane_Florida_East_FIPS_0901'
    NAD__1983__STATE_PLANE__FLORIDA__NORTH_FIPS__0903='NAD_1983_StatePlane_Florida_North_FIPS_0903'
    NAD__1983__STATE_PLANE__FLORIDA__WEST_FIPS__0902='NAD_1983_StatePlane_Florida_West_FIPS_0902'
    NAD__1983__STATE_PLANE__GEORGIA__EAST_FIPS__1001='NAD_1983_StatePlane_Georgia_East_FIPS_1001'
    NAD__1983__STATE_PLANE__GEORGIA__WEST_FIPS__1002='NAD_1983_StatePlane_Georgia_West_FIPS_1002'
    NAD__1983__STATE_PLANE__GUAM_FIPS__5400='NAD_1983_StatePlane_Guam_FIPS_5400'
    NAD__1983__STATE_PLANE__HAWAII__1_FIPS__5101='NAD_1983_StatePlane_Hawaii_1_FIPS_5101'
    NAD__1983__STATE_PLANE__HAWAII__2_FIPS__5102='NAD_1983_StatePlane_Hawaii_2_FIPS_5102'
    NAD__1983__STATE_PLANE__HAWAII__3_FIPS__5103='NAD_1983_StatePlane_Hawaii_3_FIPS_5103'
    NAD__1983__STATE_PLANE__HAWAII__4_FIPS__5104='NAD_1983_StatePlane_Hawaii_4_FIPS_5104'
    NAD__1983__STATE_PLANE__HAWAII__5_FIPS__5105='NAD_1983_StatePlane_Hawaii_5_FIPS_5105'
    NAD__1983__STATE_PLANE__IDAHO__CENTRAL_FIPS__1102='NAD_1983_StatePlane_Idaho_Central_FIPS_1102'
    NAD__1983__STATE_PLANE__IDAHO__EAST_FIPS__1101='NAD_1983_StatePlane_Idaho_East_FIPS_1101'
    NAD__1983__STATE_PLANE__IDAHO__WEST_FIPS__1103='NAD_1983_StatePlane_Idaho_West_FIPS_1103'
    NAD__1983__STATE_PLANE__ILLINOIS__EAST_FIPS__1201='NAD_1983_StatePlane_Illinois_East_FIPS_1201'
    NAD__1983__STATE_PLANE__ILLINOIS__WEST_FIPS__1202='NAD_1983_StatePlane_Illinois_West_FIPS_1202'
    NAD__1983__STATE_PLANE__INDIANA__EAST_FIPS__1301='NAD_1983_StatePlane_Indiana_East_FIPS_1301'
    NAD__1983__STATE_PLANE__INDIANA__WEST_FIPS__1302='NAD_1983_StatePlane_Indiana_West_FIPS_1302'
    NAD__1983__STATE_PLANE__IOWA__NORTH_FIPS__1401='NAD_1983_StatePlane_Iowa_North_FIPS_1401'
    NAD__1983__STATE_PLANE__IOWA__SOUTH_FIPS__1402='NAD_1983_StatePlane_Iowa_South_FIPS_1402'
    NAD__1983__STATE_PLANE__KANSAS__NORTH_FIPS__1501='NAD_1983_StatePlane_Kansas_North_FIPS_1501'
    NAD__1983__STATE_PLANE__KANSAS__SOUTH_FIPS__1502='NAD_1983_StatePlane_Kansas_South_FIPS_1502'
    NAD__1983__STATE_PLANE__KENTUCKY_FIPS__1600='NAD_1983_StatePlane_Kentucky_FIPS_1600'
    NAD__1983__STATE_PLANE__KENTUCKY__NORTH_FIPS__1601='NAD_1983_StatePlane_Kentucky_North_FIPS_1601'
    NAD__1983__STATE_PLANE__KENTUCKY__SOUTH_FIPS__1602='NAD_1983_StatePlane_Kentucky_South_FIPS_1602'
    NAD__1983__STATE_PLANE__LOUISIANA__NORTH_FIPS__1701='NAD_1983_StatePlane_Louisiana_North_FIPS_1701'
    NAD__1983__STATE_PLANE__LOUISIANA__SOUTH_FIPS__1702='NAD_1983_StatePlane_Louisiana_South_FIPS_1702'
    NAD__1983__STATE_PLANE__MAINE__EAST_FIPS__1801='NAD_1983_StatePlane_Maine_East_FIPS_1801'
    NAD__1983__STATE_PLANE__MAINE__WEST_FIPS__1802='NAD_1983_StatePlane_Maine_West_FIPS_1802'
    NAD__1983__STATE_PLANE__MARYLAND_FIPS__1900='NAD_1983_StatePlane_Maryland_FIPS_1900'
    NAD__1983__STATE_PLANE__MASSACHUSETTS__ISLAND_FIPS__2002='NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002'
    NAD__1983__STATE_PLANE__MASSACHUSETTS__MAINLAND_FIPS__2001='NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001'
    NAD__1983__STATE_PLANE__MICHIGAN__CENTRAL_FIPS__2202='NAD_1983_StatePlane_Michigan_Central_FIPS_2202'
    NAD__1983__STATE_PLANE__MICHIGAN__NORTH_FIPS__2111='NAD_1983_StatePlane_Michigan_North_FIPS_2111'
    NAD__1983__STATE_PLANE__MICHIGAN__SOUTH_FIPS__2113='NAD_1983_StatePlane_Michigan_South_FIPS_2113'
    NAD__1983__STATE_PLANE__MINNESOTA__CENTRAL_FIPS__2202='NAD_1983_StatePlane_Minnesota_Central_FIPS_2202'
    NAD__1983__STATE_PLANE__MINNESOTA__NORTH_FIPS__2201='NAD_1983_StatePlane_Minnesota_North_FIPS_2201'
    NAD__1983__STATE_PLANE__MINNESOTA__SOUTH_FIPS__2203='NAD_1983_StatePlane_Minnesota_South_FIPS_2203'
    NAD__1983__STATE_PLANE__MISSISSIPPI__EAST_FIPS__2301='NAD_1983_StatePlane_Mississippi_East_FIPS_2301'
    NAD__1983__STATE_PLANE__MISSISSIPPI__WEST_FIPS__2302='NAD_1983_StatePlane_Mississippi_West_FIPS_2302'
    NAD__1983__STATE_PLANE__MISSOURI__CENTRAL_FIPS__2402='NAD_1983_StatePlane_Missouri_Central_FIPS_2402'
    NAD__1983__STATE_PLANE__MISSOURI__EAST_FIPS__2401='NAD_1983_StatePlane_Missouri_East_FIPS_2401'
    NAD__1983__STATE_PLANE__MISSOURI__WEST_FIPS__2403='NAD_1983_StatePlane_Missouri_West_FIPS_2403'
    NAD__1983__STATE_PLANE__MONTANA_FIPS__2500='NAD_1983_StatePlane_Montana_FIPS_2500'
    NAD__1983__STATE_PLANE__NEBRASKA_FIPS__2600='NAD_1983_StatePlane_Nebraska_FIPS_2600'
    NAD__1983__STATE_PLANE__NEVADA__CENTRAL_FIPS__2702='NAD_1983_StatePlane_Nevada_Central_FIPS_2702'
    NAD__1983__STATE_PLANE__NEVADA__EAST_FIPS__2701='NAD_1983_StatePlane_Nevada_East_FIPS_2701'
    NAD__1983__STATE_PLANE__NEVADA__WEST_FIPS__2703='NAD_1983_StatePlane_Nevada_West_FIPS_2703'
    NAD__1983__STATE_PLANE__NEW__HAMPSHIRE_FIPS__2800='NAD_1983_StatePlane_New_Hampshire_FIPS_2800'
    NAD__1983__STATE_PLANE__NEW__JERSEY_FIPS__2900='NAD_1983_StatePlane_New_Jersey_FIPS_2900'
    NAD__1983__STATE_PLANE__NEW__MEXICO__CENTRAL_FIPS__3002='NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002'
    NAD__1983__STATE_PLANE__NEW__MEXICO__EAST_FIPS__3001='NAD_1983_StatePlane_New_Mexico_East_FIPS_3001'
    NAD__1983__STATE_PLANE__NEW__MEXICO__WEST_FIPS__3003='NAD_1983_StatePlane_New_Mexico_West_FIPS_3003'
    NAD__1983__STATE_PLANE__NEW__YORK__CENTRAL_FIPS__3102='NAD_1983_StatePlane_New_York_Central_FIPS_3102'
    NAD__1983__STATE_PLANE__NEW__YORK__EAST_FIPS__3101='NAD_1983_StatePlane_New_York_East_FIPS_3101'
    NAD__1983__STATE_PLANE__NEW__YORK__LONG__ISLAND_FIPS__3104='NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104'
    NAD__1983__STATE_PLANE__NEW__YORK__WEST_FIPS__3103='NAD_1983_StatePlane_New_York_West_FIPS_3103'
    NAD__1983__STATE_PLANE__NORTH__CAROLINA_FIPS__3200='NAD_1983_StatePlane_North_Carolina_FIPS_3200'
    NAD__1983__STATE_PLANE__NORTH__DAKOTA__NORTH_FIPS__3301='NAD_1983_StatePlane_North_Dakota_North_FIPS_3301'
    NAD__1983__STATE_PLANE__NORTH__DAKOTA__SOUTH_FIPS__3302='NAD_1983_StatePlane_North_Dakota_South_FIPS_3302'
    NAD__1983__STATE_PLANE__OHIO__NORTH_FIPS__3401='NAD_1983_StatePlane_Ohio_North_FIPS_3401'
    NAD__1983__STATE_PLANE__OHIO__SOUTH_FIPS__3402='NAD_1983_StatePlane_Ohio_South_FIPS_3402'
    NAD__1983__STATE_PLANE__OKLAHOMA__NORTH_FIPS__3501='NAD_1983_StatePlane_Oklahoma_North_FIPS_3501'
    NAD__1983__STATE_PLANE__OKLAHOMA__SOUTH_FIPS__3502='NAD_1983_StatePlane_Oklahoma_South_FIPS_3502'
    NAD__1983__STATE_PLANE__OREGON__NORTH_FIPS__3601='NAD_1983_StatePlane_Oregon_North_FIPS_3601'
    NAD__1983__STATE_PLANE__OREGON__SOUTH_FIPS__3602='NAD_1983_StatePlane_Oregon_South_FIPS_3602'
    NAD__1983__STATE_PLANE__PENNSYLVANIA__NORTH_FIPS__3701='NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701'
    NAD__1983__STATE_PLANE__PENNSYLVANIA__SOUTH_FIPS__3702='NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702'
    NAD__1983__STATE_PLANE__PUERTO__RICO__VIRGIN__ISLANDS_FIPS__5200='NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200'
    NAD__1983__STATE_PLANE__RHODE__ISLAND_FIPS__3800='NAD_1983_StatePlane_Rhode_Island_FIPS_3800'
    NAD__1983__STATE_PLANE__SOUTH__CAROLINA_FIPS__3900='NAD_1983_StatePlane_South_Carolina_FIPS_3900'
    NAD__1983__STATE_PLANE__SOUTH__DAKOTA__NORTH_FIPS__4001='NAD_1983_StatePlane_South_Dakota_North_FIPS_4001'
    NAD__1983__STATE_PLANE__SOUTH__DAKOTA__SOUTH_FIPS__4002='NAD_1983_StatePlane_South_Dakota_South_FIPS_4002'
    NAD__1983__STATE_PLANE__TENNESSEE_FIPS__4100='NAD_1983_StatePlane_Tennessee_FIPS_4100'
    NAD__1983__STATE_PLANE__TEXAS__CENTRAL_FIPS__4203='NAD_1983_StatePlane_Texas_Central_FIPS_4203'
    NAD__1983__STATE_PLANE__TEXAS__NORTH__CENTRAL_FIPS__4202='NAD_1983_StatePlane_Texas_North_Central_FIPS_4202'
    NAD__1983__STATE_PLANE__TEXAS__NORTH_FIPS__4201='NAD_1983_StatePlane_Texas_North_FIPS_4201'
    NAD__1983__STATE_PLANE__TEXAS__SOUTH__CENTRAL_FIPS__4204='NAD_1983_StatePlane_Texas_South_Central_FIPS_4204'
    NAD__1983__STATE_PLANE__TEXAS__SOUTH_FIPS__4205='NAD_1983_StatePlane_Texas_South_FIPS_4205'
    NAD__1983__STATE_PLANE__UTAH__CENTRAL_FIPS__4302='NAD_1983_StatePlane_Utah_Central_FIPS_4302'
    NAD__1983__STATE_PLANE__UTAH__NORTH_FIPS__4301='NAD_1983_StatePlane_Utah_North_FIPS_4301'
    NAD__1983__STATE_PLANE__UTAH__SOUTH_FIPS__4303='NAD_1983_StatePlane_Utah_South_FIPS_4303'
    NAD__1983__STATE_PLANE__VERMONT_FIPS__4400='NAD_1983_StatePlane_Vermont_FIPS_4400'
    NAD__1983__STATE_PLANE__VIRGINIA__NORTH_FIPS__4501='NAD_1983_StatePlane_Virginia_North_FIPS_4501'
    NAD__1983__STATE_PLANE__VIRGINIA__SOUTH_FIPS__4502='NAD_1983_StatePlane_Virginia_South_FIPS_4502'
    NAD__1983__STATE_PLANE__WASHINGTON__NORTH_FIPS__4601='NAD_1983_StatePlane_Washington_North_FIPS_4601'
    NAD__1983__STATE_PLANE__WASHINGTON__SOUTH_FIPS__4602='NAD_1983_StatePlane_Washington_South_FIPS_4602'
    NAD__1983__STATE_PLANE__WEST__VIRGINIA__NORTH_FIPS__4701='NAD_1983_StatePlane_West_Virginia_North_FIPS_4701'
    NAD__1983__STATE_PLANE__WEST__VIRGINIA__SOUTH_FIPS__4702='NAD_1983_StatePlane_West_Virginia_South_FIPS_4702'
    NAD__1983__STATE_PLANE__WISCONSIN__CENTRAL_FIPS__4802='NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802'
    NAD__1983__STATE_PLANE__WISCONSIN__NORTH_FIPS__4801='NAD_1983_StatePlane_Wisconsin_North_FIPS_4801'
    NAD__1983__STATE_PLANE__WISCONSIN__SOUTH_FIPS__4803='NAD_1983_StatePlane_Wisconsin_South_FIPS_4803'
    NAD__1983__STATE_PLANE__WYOMING__EAST__CENTRAL_FIPS__4902='NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902'
    NAD__1983__STATE_PLANE__WYOMING__EAST_FIPS__4901='NAD_1983_StatePlane_Wyoming_East_FIPS_4901'
    NAD__1983__STATE_PLANE__WYOMING__WEST__CENTRAL_FIPS__4903='NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903'
    NAD__1983__STATE_PLANE__WYOMING__WEST_FIPS__4904='NAD_1983_StatePlane_Wyoming_West_FIPS_4904'
    NAD__1983__STATE_PLANE__ALABAMA__EAST_FIPS__0101__FEET='NAD_1983_StatePlane_Alabama_East_FIPS_0101_Feet'
    NAD__1983__STATE_PLANE__ALABAMA__WEST_FIPS__0102__FEET='NAD_1983_StatePlane_Alabama_West_FIPS_0102_Feet'
    NAD__1983__STATE_PLANE__ALASKA__1_FIPS__5001__FEET='NAD_1983_StatePlane_Alaska_1_FIPS_5001_Feet'
    NAD__1983__STATE_PLANE__ALASKA__10_FIPS__5010__FEET='NAD_1983_StatePlane_Alaska_10_FIPS_5010_Feet'
    NAD__1983__STATE_PLANE__ALASKA__2_FIPS__5002__FEET='NAD_1983_StatePlane_Alaska_2_FIPS_5002_Feet'
    NAD__1983__STATE_PLANE__ALASKA__3_FIPS__5003__FEET='NAD_1983_StatePlane_Alaska_3_FIPS_5003_Feet'
    NAD__1983__STATE_PLANE__ALASKA__4_FIPS__5004__FEET='NAD_1983_StatePlane_Alaska_4_FIPS_5004_Feet'
    NAD__1983__STATE_PLANE__ALASKA__5_FIPS__5005__FEET='NAD_1983_StatePlane_Alaska_5_FIPS_5005_Feet'
    NAD__1983__STATE_PLANE__ALASKA__6_FIPS__5006__FEET='NAD_1983_StatePlane_Alaska_6_FIPS_5006_Feet'
    NAD__1983__STATE_PLANE__ALASKA__7_FIPS__5007__FEET='NAD_1983_StatePlane_Alaska_7_FIPS_5007_Feet'
    NAD__1983__STATE_PLANE__ALASKA__8_FIPS__5008__FEET='NAD_1983_StatePlane_Alaska_8_FIPS_5008_Feet'
    NAD__1983__STATE_PLANE__ALASKA__9_FIPS__5009__FEET='NAD_1983_StatePlane_Alaska_9_FIPS_5009_Feet'
    NAD__1983__STATE_PLANE__ARIZONA__CENTRAL_FIPS__0202__FEET='NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet'
    NAD__1983__STATE_PLANE__ARIZONA__EAST_FIPS__0201__FEET='NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet'
    NAD__1983__STATE_PLANE__ARIZONA__WEST_FIPS__0203__FEET='NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet'
    NAD__1983__STATE_PLANE__ARKANSAS__NORTH_FIPS__0301__FEET='NAD_1983_StatePlane_Arkansas_North_FIPS_0301_Feet'
    NAD__1983__STATE_PLANE__ARKANSAS__SOUTH_FIPS__0302__FEET='NAD_1983_StatePlane_Arkansas_South_FIPS_0302_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_I_FIPS__0401__FEET='NAD_1983_StatePlane_California_I_FIPS_0401_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_II_FIPS__0402__FEET='NAD_1983_StatePlane_California_II_FIPS_0402_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_III_FIPS__0403__FEET='NAD_1983_StatePlane_California_III_FIPS_0403_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_IV_FIPS__0404__FEET='NAD_1983_StatePlane_California_IV_FIPS_0404_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_V_FIPS__0405__FEET='NAD_1983_StatePlane_California_V_FIPS_0405_Feet'
    NAD__1983__STATE_PLANE__CALIFORNIA_VI_FIPS__0406__FEET='NAD_1983_StatePlane_California_VI_FIPS_0406_Feet'
    NAD__1983__STATE_PLANE__COLORADO__CENTRAL_FIPS__0502__FEET='NAD_1983_StatePlane_Colorado_Central_FIPS_0502_Feet'
    NAD__1983__STATE_PLANE__COLORADO__NORTH_FIPS__0501__FEET='NAD_1983_StatePlane_Colorado_North_FIPS_0501_Feet'
    NAD__1983__STATE_PLANE__COLORADO__SOUTH_FIPS__0503__FEET='NAD_1983_StatePlane_Colorado_South_FIPS_0503_Feet'
    NAD__1983__STATE_PLANE__CONNECTICUT_FIPS__0600__FEET='NAD_1983_StatePlane_Connecticut_FIPS_0600_Feet'
    NAD__1983__STATE_PLANE__DELAWARE_FIPS__0700__FEET='NAD_1983_StatePlane_Delaware_FIPS_0700_Feet'
    NAD__1983__STATE_PLANE__FLORIDA__EAST_FIPS__0901__FEET='NAD_1983_StatePlane_Florida_East_FIPS_0901_Feet'
    NAD__1983__STATE_PLANE__FLORIDA__NORTH_FIPS__0903__FEET='NAD_1983_StatePlane_Florida_North_FIPS_0903_Feet'
    NAD__1983__STATE_PLANE__FLORIDA__WEST_FIPS__0902__FEET='NAD_1983_StatePlane_Florida_West_FIPS_0902_Feet'
    NAD__1983__STATE_PLANE__GEORGIA__EAST_FIPS__1001__FEET='NAD_1983_StatePlane_Georgia_East_FIPS_1001_Feet'
    NAD__1983__STATE_PLANE__GEORGIA__WEST_FIPS__1002__FEET='NAD_1983_StatePlane_Georgia_West_FIPS_1002_Feet'
    NAD__1983__STATE_PLANE__GUAM_FIPS__5400__FEET='NAD_1983_StatePlane_Guam_FIPS_5400_Feet'
    NAD__1983__STATE_PLANE__HAWAII__1_FIPS__5101__FEET='NAD_1983_StatePlane_Hawaii_1_FIPS_5101_Feet'
    NAD__1983__STATE_PLANE__HAWAII__2_FIPS__5102__FEET='NAD_1983_StatePlane_Hawaii_2_FIPS_5102_Feet'
    NAD__1983__STATE_PLANE__HAWAII__3_FIPS__5103__FEET='NAD_1983_StatePlane_Hawaii_3_FIPS_5103_Feet'
    NAD__1983__STATE_PLANE__HAWAII__4_FIPS__5104__FEET='NAD_1983_StatePlane_Hawaii_4_FIPS_5104_Feet'
    NAD__1983__STATE_PLANE__HAWAII__5_FIPS__5105__FEET='NAD_1983_StatePlane_Hawaii_5_FIPS_5105_Feet'
    NAD__1983__STATE_PLANE__IDAHO__CENTRAL_FIPS__1102__FEET='NAD_1983_StatePlane_Idaho_Central_FIPS_1102_Feet'
    NAD__1983__STATE_PLANE__IDAHO__EAST_FIPS__1101__FEET='NAD_1983_StatePlane_Idaho_East_FIPS_1101_Feet'
    NAD__1983__STATE_PLANE__IDAHO__WEST_FIPS__1103__FEET='NAD_1983_StatePlane_Idaho_West_FIPS_1103_Feet'
    NAD__1983__STATE_PLANE__ILLINOIS__EAST_FIPS__1201__FEET='NAD_1983_StatePlane_Illinois_East_FIPS_1201_Feet'
    NAD__1983__STATE_PLANE__ILLINOIS__WEST_FIPS__1202__FEET='NAD_1983_StatePlane_Illinois_West_FIPS_1202_Feet'
    NAD__1983__STATE_PLANE__INDIANA__EAST_FIPS__1301__FEET='NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet'
    NAD__1983__STATE_PLANE__INDIANA__WEST_FIPS__1302__FEET='NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet'
    NAD__1983__STATE_PLANE__IOWA__NORTH_FIPS__1401__FEET='NAD_1983_StatePlane_Iowa_North_FIPS_1401_Feet'
    NAD__1983__STATE_PLANE__IOWA__SOUTH_FIPS__1402__FEET='NAD_1983_StatePlane_Iowa_South_FIPS_1402_Feet'
    NAD__1983__STATE_PLANE__KANSAS__NORTH_FIPS__1501__FEET='NAD_1983_StatePlane_Kansas_North_FIPS_1501_Feet'
    NAD__1983__STATE_PLANE__KANSAS__SOUTH_FIPS__1502__FEET='NAD_1983_StatePlane_Kansas_South_FIPS_1502_Feet'
    NAD__1983__STATE_PLANE__KENTUCKY_FIPS__1600__FEET='NAD_1983_StatePlane_Kentucky_FIPS_1600_Feet'
    NAD__1983__STATE_PLANE__KENTUCKY__NORTH_FIPS__1601__FEET='NAD_1983_StatePlane_Kentucky_North_FIPS_1601_Feet'
    NAD__1983__STATE_PLANE__KENTUCKY__SOUTH_FIPS__1602__FEET='NAD_1983_StatePlane_Kentucky_South_FIPS_1602_Feet'
    NAD__1983__STATE_PLANE__LOUISIANA__NORTH_FIPS__1701__FEET='NAD_1983_StatePlane_Louisiana_North_FIPS_1701_Feet'
    NAD__1983__STATE_PLANE__LOUISIANA__SOUTH_FIPS__1702__FEET='NAD_1983_StatePlane_Louisiana_South_FIPS_1702_Feet'
    NAD__1983__STATE_PLANE__MAINE__EAST_FIPS__1801__FEET='NAD_1983_StatePlane_Maine_East_FIPS_1801_Feet'
    NAD__1983__STATE_PLANE__MAINE__WEST_FIPS__1802__FEET='NAD_1983_StatePlane_Maine_West_FIPS_1802_Feet'
    NAD__1983__STATE_PLANE__MARYLAND_FIPS__1900__FEET='NAD_1983_StatePlane_Maryland_FIPS_1900_Feet'
    NAD__1983__STATE_PLANE__MASSACHUSETTS__ISLAND_FIPS__2002__FEET='NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002_Feet'
    NAD__1983__STATE_PLANE__MASSACHUSETTS__MAINLAND_FIPS__2001__FEET='NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet'
    NAD__1983__STATE_PLANE__MICHIGAN__CENTRAL_FIPS__2202__FEET='NAD_1983_StatePlane_Michigan_Central_FIPS_2202_Feet'
    NAD__1983__STATE_PLANE__MICHIGAN__NORTH_FIPS__2111__FEET='NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet'
    NAD__1983__STATE_PLANE__MICHIGAN__SOUTH_FIPS__2113__FEET='NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet'
    NAD__1983__STATE_PLANE__MINNESOTA__CENTRAL_FIPS__2202__FEET='NAD_1983_StatePlane_Minnesota_Central_FIPS_2202_Feet'
    NAD__1983__STATE_PLANE__MINNESOTA__NORTH_FIPS__2201__FEET='NAD_1983_StatePlane_Minnesota_North_FIPS_2201_Feet'
    NAD__1983__STATE_PLANE__MINNESOTA__SOUTH_FIPS__2203__FEET='NAD_1983_StatePlane_Minnesota_South_FIPS_2203_Feet'
    NAD__1983__STATE_PLANE__MISSISSIPPI__EAST_FIPS__2301__FEET='NAD_1983_StatePlane_Mississippi_East_FIPS_2301_Feet'
    NAD__1983__STATE_PLANE__MISSISSIPPI__WEST_FIPS__2302__FEET='NAD_1983_StatePlane_Mississippi_West_FIPS_2302_Feet'
    NAD__1983__STATE_PLANE__MISSOURI__CENTRAL_FIPS__2402__FEET='NAD_1983_StatePlane_Missouri_Central_FIPS_2402_Feet'
    NAD__1983__STATE_PLANE__MISSOURI__EAST_FIPS__2401__FEET='NAD_1983_StatePlane_Missouri_East_FIPS_2401_Feet'
    NAD__1983__STATE_PLANE__MISSOURI__WEST_FIPS__2403__FEET='NAD_1983_StatePlane_Missouri_West_FIPS_2403_Feet'
    NAD__1983__STATE_PLANE__MONTANA_FIPS__2500__FEET='NAD_1983_StatePlane_Montana_FIPS_2500_Feet'
    NAD__1983__STATE_PLANE__NEBRASKA_FIPS__2600__FEET='NAD_1983_StatePlane_Nebraska_FIPS_2600_Feet'
    NAD__1983__STATE_PLANE__NEVADA__CENTRAL_FIPS__2702__FEET='NAD_1983_StatePlane_Nevada_Central_FIPS_2702_Feet'
    NAD__1983__STATE_PLANE__NEVADA__EAST_FIPS__2701__FEET='NAD_1983_StatePlane_Nevada_East_FIPS_2701_Feet'
    NAD__1983__STATE_PLANE__NEVADA__WEST_FIPS__2703__FEET='NAD_1983_StatePlane_Nevada_West_FIPS_2703_Feet'
    NAD__1983__STATE_PLANE__NEW__HAMPSHIRE_FIPS__2800__FEET='NAD_1983_StatePlane_New_Hampshire_FIPS_2800_Feet'
    NAD__1983__STATE_PLANE__NEW__JERSEY_FIPS__2900__FEET='NAD_1983_StatePlane_New_Jersey_FIPS_2900_Feet'
    NAD__1983__STATE_PLANE__NEW__MEXICO__CENTRAL_FIPS__3002__FEET='NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002_Feet'
    NAD__1983__STATE_PLANE__NEW__MEXICO__EAST_FIPS__3001__FEET='NAD_1983_StatePlane_New_Mexico_East_FIPS_3001_Feet'
    NAD__1983__STATE_PLANE__NEW__MEXICO__WEST_FIPS__3003__FEET='NAD_1983_StatePlane_New_Mexico_West_FIPS_3003_Feet'
    NAD__1983__STATE_PLANE__NEW__YORK__CENTRAL_FIPS__3102__FEET='NAD_1983_StatePlane_New_York_Central_FIPS_3102_Feet'
    NAD__1983__STATE_PLANE__NEW__YORK__EAST_FIPS__3101__FEET='NAD_1983_StatePlane_New_York_East_FIPS_3101_Feet'
    NAD__1983__STATE_PLANE__NEW__YORK__LONG__ISLAND_FIPS__3104__FEET='NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104_Feet'
    NAD__1983__STATE_PLANE__NEW__YORK__WEST_FIPS__3103__FEET='NAD_1983_StatePlane_New_York_West_FIPS_3103_Feet'
    NAD__1983__STATE_PLANE__NORTH__CAROLINA_FIPS__3200__FEET='NAD_1983_StatePlane_North_Carolina_FIPS_3200_Feet'
    NAD__1983__STATE_PLANE__NORTH__DAKOTA__NORTH_FIPS__3301__FEET='NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet'
    NAD__1983__STATE_PLANE__NORTH__DAKOTA__SOUTH_FIPS__3302__FEET='NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet'
    NAD__1983__STATE_PLANE__OHIO__NORTH_FIPS__3401__FEET='NAD_1983_StatePlane_Ohio_North_FIPS_3401_Feet'
    NAD__1983__STATE_PLANE__OHIO__SOUTH_FIPS__3402__FEET='NAD_1983_StatePlane_Ohio_South_FIPS_3402_Feet'
    NAD__1983__STATE_PLANE__OKLAHOMA__NORTH_FIPS__3501__FEET='NAD_1983_StatePlane_Oklahoma_North_FIPS_3501_Feet'
    NAD__1983__STATE_PLANE__OKLAHOMA__SOUTH_FIPS__3502__FEET='NAD_1983_StatePlane_Oklahoma_South_FIPS_3502_Feet'
    NAD__1983__STATE_PLANE__OREGON__NORTH_FIPS__3601__FEET='NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet'
    NAD__1983__STATE_PLANE__OREGON__SOUTH_FIPS__3602__FEET='NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet'
    NAD__1983__STATE_PLANE__PENNSYLVANIA__NORTH_FIPS__3701__FEET='NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701_Feet'
    NAD__1983__STATE_PLANE__PENNSYLVANIA__SOUTH_FIPS__3702__FEET='NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702_Feet'
    NAD__1983__STATE_PLANE__PUERTO__RICO__VIRGIN__ISLANDS_FIPS__5200__FEET='NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200_Feet'
    NAD__1983__STATE_PLANE__RHODE__ISLAND_FIPS__3800__FEET='NAD_1983_StatePlane_Rhode_Island_FIPS_3800_Feet'
    NAD__1983__STATE_PLANE__SOUTH__CAROLINA_FIPS__3900__FEET='NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet'
    NAD__1983__STATE_PLANE__SOUTH__DAKOTA__NORTH_FIPS__4001__FEET='NAD_1983_StatePlane_South_Dakota_North_FIPS_4001_Feet'
    NAD__1983__STATE_PLANE__SOUTH__DAKOTA__SOUTH_FIPS__4002__FEET='NAD_1983_StatePlane_South_Dakota_South_FIPS_4002_Feet'
    NAD__1983__STATE_PLANE__TENNESSEE_FIPS__4100__FEET='NAD_1983_StatePlane_Tennessee_FIPS_4100_Feet'
    NAD__1983__STATE_PLANE__TEXAS__CENTRAL_FIPS__4203__FEET='NAD_1983_StatePlane_Texas_Central_FIPS_4203_Feet'
    NAD__1983__STATE_PLANE__TEXAS__NORTH__CENTRAL_FIPS__4202__FEET='NAD_1983_StatePlane_Texas_North_Central_FIPS_4202_Feet'
    NAD__1983__STATE_PLANE__TEXAS__NORTH_FIPS__4201__FEET='NAD_1983_StatePlane_Texas_North_FIPS_4201_Feet'
    NAD__1983__STATE_PLANE__TEXAS__SOUTH__CENTRAL_FIPS__4204__FEET='NAD_1983_StatePlane_Texas_South_Central_FIPS_4204_Feet'
    NAD__1983__STATE_PLANE__TEXAS__SOUTH_FIPS__4205__FEET='NAD_1983_StatePlane_Texas_South_FIPS_4205_Feet'
    NAD__1983__STATE_PLANE__UTAH__CENTRAL_FIPS__4302__FEET='NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet'
    NAD__1983__STATE_PLANE__UTAH__NORTH_FIPS__4301__FEET='NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet'
    NAD__1983__STATE_PLANE__UTAH__SOUTH_FIPS__4303__FEET='NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet'
    NAD__1983__STATE_PLANE__VERMONT_FIPS__4400__FEET='NAD_1983_StatePlane_Vermont_FIPS_4400_Feet'
    NAD__1983__STATE_PLANE__VIRGINIA__NORTH_FIPS__4501__FEET='NAD_1983_StatePlane_Virginia_North_FIPS_4501_Feet'
    NAD__1983__STATE_PLANE__VIRGINIA__SOUTH_FIPS__4502__FEET='NAD_1983_StatePlane_Virginia_South_FIPS_4502_Feet'
    NAD__1983__STATE_PLANE__WASHINGTON__NORTH_FIPS__4601__FEET='NAD_1983_StatePlane_Washington_North_FIPS_4601_Feet'
    NAD__1983__STATE_PLANE__WASHINGTON__SOUTH_FIPS__4602__FEET='NAD_1983_StatePlane_Washington_South_FIPS_4602_Feet'
    NAD__1983__STATE_PLANE__WEST__VIRGINIA__NORTH_FIPS__4701__FEET='NAD_1983_StatePlane_West_Virginia_North_FIPS_4701_Feet'
    NAD__1983__STATE_PLANE__WEST__VIRGINIA__SOUTH_FIPS__4702__FEET='NAD_1983_StatePlane_West_Virginia_South_FIPS_4702_Feet'
    NAD__1983__STATE_PLANE__WISCONSIN__CENTRAL_FIPS__4802__FEET='NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802_Feet'
    NAD__1983__STATE_PLANE__WISCONSIN__NORTH_FIPS__4801__FEET='NAD_1983_StatePlane_Wisconsin_North_FIPS_4801_Feet'
    NAD__1983__STATE_PLANE__WISCONSIN__SOUTH_FIPS__4803__FEET='NAD_1983_StatePlane_Wisconsin_South_FIPS_4803_Feet'
    NAD__1983__STATE_PLANE__WYOMING__EAST__CENTRAL_FIPS__4902__FEET='NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902_Feet'
    NAD__1983__STATE_PLANE__WYOMING__EAST_FIPS__4901__FEET='NAD_1983_StatePlane_Wyoming_East_FIPS_4901_Feet'
    NAD__1983__STATE_PLANE__WYOMING__WEST__CENTRAL_FIPS__4903__FEET='NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903_Feet'
    NAD__1983__STATE_PLANE__WYOMING__WEST_FIPS__4904__FEET='NAD_1983_StatePlane_Wyoming_West_FIPS_4904_Feet'
    NAD__1983_HARN__STATE_PLANE__ALABAMA__EAST_FIPS__0101='NAD_1983_HARN_StatePlane_Alabama_East_FIPS_0101'
    NAD__1983_HARN__STATE_PLANE__ALABAMA__WEST_FIPS__0102='NAD_1983_HARN_StatePlane_Alabama_West_FIPS_0102'
    NAD__1983_HARN__STATE_PLANE__ARIZONA__CENTRAL_FIPS__0202='NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202'
    NAD__1983_HARN__STATE_PLANE__ARIZONA__EAST_FIPS__0201='NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201'
    NAD__1983_HARN__STATE_PLANE__ARIZONA__WEST_FIPS__0203='NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_I_FIPS__0401='NAD_1983_HARN_StatePlane_California_I_FIPS_0401'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_II_FIPS__0402='NAD_1983_HARN_StatePlane_California_II_FIPS_0402'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_III_FIPS__0403='NAD_1983_HARN_StatePlane_California_III_FIPS_0403'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_IV_FIPS__0404='NAD_1983_HARN_StatePlane_California_IV_FIPS_0404'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_V_FIPS__0405='NAD_1983_HARN_StatePlane_California_V_FIPS_0405'
    NAD__1983_HARN__STATE_PLANE__CALIFORNIA_VI_FIPS__0406='NAD_1983_HARN_StatePlane_California_VI_FIPS_0406'
    NAD__1983_HARN__STATE_PLANE__COLORADO__CENTRAL_FIPS__0502='NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502'
    NAD__1983_HARN__STATE_PLANE__COLORADO__NORTH_FIPS__0501='NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501'
    NAD__1983_HARN__STATE_PLANE__COLORADO__SOUTH_FIPS__0503='NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503'
    NAD__1983_HARN__STATE_PLANE__CONNECTICUT_FIPS__0600='NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600'
    NAD__1983_HARN__STATE_PLANE__DELAWARE_FIPS__0700='NAD_1983_HARN_StatePlane_Delaware_FIPS_0700'
    NAD__1983_HARN__STATE_PLANE__FLORIDA__EAST_FIPS__0901='NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901'
    NAD__1983_HARN__STATE_PLANE__FLORIDA__NORTH_FIPS__0903='NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903'
    NAD__1983_HARN__STATE_PLANE__FLORIDA__WEST_FIPS__0902='NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902'
    NAD__1983_HARN__STATE_PLANE__GEORGIA__EAST_FIPS__1001='NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001'
    NAD__1983_HARN__STATE_PLANE__GEORGIA__WEST_FIPS__1002='NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002'
    NAD__1983_HARN__STATE_PLANE__HAWAII__1_FIPS__5101='NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101'
    NAD__1983_HARN__STATE_PLANE__HAWAII__2_FIPS__5102='NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102'
    NAD__1983_HARN__STATE_PLANE__HAWAII__3_FIPS__5103='NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103'
    NAD__1983_HARN__STATE_PLANE__HAWAII__4_FIPS__5104='NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104'
    NAD__1983_HARN__STATE_PLANE__HAWAII__5_FIPS__5105='NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105'
    NAD__1983_HARN__STATE_PLANE__IDAHO__CENTRAL_FIPS__1102='NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102'
    NAD__1983_HARN__STATE_PLANE__IDAHO__EAST_FIPS__1101='NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101'
    NAD__1983_HARN__STATE_PLANE__IDAHO__WEST_FIPS__1103='NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103'
    NAD__1983_HARN__STATE_PLANE__ILLINOIS__EAST_FIPS__1201='NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201'
    NAD__1983_HARN__STATE_PLANE__ILLINOIS__WEST_FIPS__1202='NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202'
    NAD__1983_HARN__STATE_PLANE__INDIANA__EAST_FIPS__1301='NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301'
    NAD__1983_HARN__STATE_PLANE__INDIANA__WEST_FIPS__1302='NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302'
    NAD__1983_HARN__STATE_PLANE__KANSAS__NORTH_FIPS__1501='NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501'
    NAD__1983_HARN__STATE_PLANE__KANSAS__SOUTH_FIPS__1502='NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502'
    NAD__1983_HARN__STATE_PLANE__KENTUCKY__NORTH_FIPS__1601='NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601'
    NAD__1983_HARN__STATE_PLANE__KENTUCKY__SOUTH_FIPS__1602='NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602'
    NAD__1983_HARN__STATE_PLANE__LOUISIANA__NORTH_FIPS__1701='NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701'
    NAD__1983_HARN__STATE_PLANE__LOUISIANA__SOUTH_FIPS__1702='NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702'
    NAD__1983_HARN__STATE_PLANE__MAINE__EAST_FIPS__1801='NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801'
    NAD__1983_HARN__STATE_PLANE__MAINE__WEST_FIPS__1802='NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802'
    NAD__1983_HARN__STATE_PLANE__MARYLAND_FIPS__1900='NAD_1983_HARN_StatePlane_Maryland_FIPS_1900'
    NAD__1983_HARN__STATE_PLANE__MASSACHUSETTS__ISLAND_FIPS__2002='NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002'
    NAD__1983_HARN__STATE_PLANE__MASSACHUSETTS__MAINLAND_FIPS__2001='NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001'
    NAD__1983_HARN__STATE_PLANE__MICHIGAN__CENTRAL_FIPS__2202='NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2202'
    NAD__1983_HARN__STATE_PLANE__MICHIGAN__NORTH_FIPS__2111='NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111'
    NAD__1983_HARN__STATE_PLANE__MICHIGAN__SOUTH_FIPS__2113='NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113'
    NAD__1983_HARN__STATE_PLANE__MISSISSIPPI__EAST_FIPS__2301='NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301'
    NAD__1983_HARN__STATE_PLANE__MISSISSIPPI__WEST_FIPS__2302='NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302'
    NAD__1983_HARN__STATE_PLANE__MONTANA_FIPS__2500='NAD_1983_HARN_StatePlane_Montana_FIPS_2500'
    NAD__1983_HARN__STATE_PLANE__NEBRASKA_FIPS__2600='NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600'
    NAD__1983_HARN__STATE_PLANE__NEVADA__CENTRAL_FIPS__2702='NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702'
    NAD__1983_HARN__STATE_PLANE__NEVADA__EAST_FIPS__2701='NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701'
    NAD__1983_HARN__STATE_PLANE__NEVADA__WEST_FIPS__2703='NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703'
    NAD__1983_HARN__STATE_PLANE__NEW__HAMPSHIRE_FIPS__2800='NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800'
    NAD__1983_HARN__STATE_PLANE__NEW__JERSEY_FIPS__2900='NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900'
    NAD__1983_HARN__STATE_PLANE__NEW__MEXICO__CENTRAL_FIPS__3002='NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002'
    NAD__1983_HARN__STATE_PLANE__NEW__MEXICO__EAST_FIPS__3001='NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001'
    NAD__1983_HARN__STATE_PLANE__NEW__MEXICO__WEST_FIPS__3003='NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003'
    NAD__1983_HARN__STATE_PLANE__NEW__YORK__CENTRAL_FIPS__3102='NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102'
    NAD__1983_HARN__STATE_PLANE__NEW__YORK__EAST_FIPS__3101='NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101'
    NAD__1983_HARN__STATE_PLANE__NEW__YORK__LONG__ISLAND_FIPS__3104='NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104'
    NAD__1983_HARN__STATE_PLANE__NEW__YORK__WEST_FIPS__3103='NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103'
    NAD__1983_HARN__STATE_PLANE__NORTH__DAKOTA__NORTH_FIPS__3301='NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301'
    NAD__1983_HARN__STATE_PLANE__NORTH__DAKOTA__SOUTH_FIPS__3302='NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302'
    NAD__1983_HARN__STATE_PLANE__OHIO__NORTH_FIPS__3401='NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401'
    NAD__1983_HARN__STATE_PLANE__OHIO__SOUTH_FIPS__3402='NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402'
    NAD__1983_HARN__STATE_PLANE__OKLAHOMA__NORTH_FIPS__3501='NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501'
    NAD__1983_HARN__STATE_PLANE__OKLAHOMA__SOUTH_FIPS__3502='NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502'
    NAD__1983_HARN__STATE_PLANE__OREGON__NORTH_FIPS__3601='NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601'
    NAD__1983_HARN__STATE_PLANE__OREGON__SOUTH_FIPS__3602='NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602'
    NAD__1983_HARN__STATE_PLANE__PUERTO__RICO__VIRGIN__ISLANDS_FIPS__5200='NAD_1983_HARN_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200'
    NAD__1983_HARN__STATE_PLANE__RHODE__ISLAND_FIPS__3800='NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800'
    NAD__1983_HARN__STATE_PLANE__SOUTH__DAKOTA__NORTH_FIPS__4001='NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001'
    NAD__1983_HARN__STATE_PLANE__SOUTH__DAKOTA__SOUTH_FIPS__4002='NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002'
    NAD__1983_HARN__STATE_PLANE__TENNESSEE_FIPS__4100='NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100'
    NAD__1983_HARN__STATE_PLANE__TEXAS__CENTRAL_FIPS__4203='NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203'
    NAD__1983_HARN__STATE_PLANE__TEXAS__NORTH__CENTRAL_FIPS__4202='NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202'
    NAD__1983_HARN__STATE_PLANE__TEXAS__NORTH_FIPS__4201='NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201'
    NAD__1983_HARN__STATE_PLANE__TEXAS__SOUTH__CENTRAL_FIPS__4204='NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204'
    NAD__1983_HARN__STATE_PLANE__TEXAS__SOUTH_FIPS__4205='NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205'
    NAD__1983_HARN__STATE_PLANE__UTAH__CENTRAL_FIPS__4302='NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302'
    NAD__1983_HARN__STATE_PLANE__UTAH__NORTH_FIPS__4301='NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301'
    NAD__1983_HARN__STATE_PLANE__UTAH__SOUTH_FIPS__4303='NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303'
    NAD__1983_HARN__STATE_PLANE__VERMONT_FIPS__4400='NAD_1983_HARN_StatePlane_Vermont_FIPS_4400'
    NAD__1983_HARN__STATE_PLANE__VIRGINIA__NORTH_FIPS__4501='NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501'
    NAD__1983_HARN__STATE_PLANE__VIRGINIA__SOUTH_FIPS__4502='NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502'
    NAD__1983_HARN__STATE_PLANE__WASHINGTON__NORTH_FIPS__4601='NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601'
    NAD__1983_HARN__STATE_PLANE__WASHINGTON__SOUTH_FIPS__4602='NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602'
    NAD__1983_HARN__STATE_PLANE__WEST__VIRGINIA__NORTH_FIPS__4701='NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701'
    NAD__1983_HARN__STATE_PLANE__WEST__VIRGINIA__SOUTH_FIPS__4702='NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702'
    NAD__1983_HARN__STATE_PLANE__WISCONSIN__CENTRAL_FIPS__4802='NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802'
    NAD__1983_HARN__STATE_PLANE__WISCONSIN__NORTH_FIPS__4801='NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801'
    NAD__1983_HARN__STATE_PLANE__WISCONSIN__SOUTH_FIPS__4803='NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803'
    NAD__1983_HARN__STATE_PLANE__WYOMING__EAST_FIPS__4901='NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901'
    NAD__1983_HARN__STATE_PLANE__WYOMING__EAST__CENTRAL_FIPS__4902='NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902'
    NAD__1983_HARN__STATE_PLANE__WYOMING__WEST__CENTRAL_FIPS__4903='NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903'
    NAD__1983_HARN__STATE_PLANE__WYOMING__WEST_FIPS__4904='NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904'
    AMERICAN__SAMOA__1962__STATE_PLANE__AMERICAN__SAMOA_FIPS__5300='American_Samoa_1962_StatePlane_American_Samoa_FIPS_5300'
    NAD__1983_HARN__GUAM__MAP__GRID_1='NAD_1983_HARN_Guam_Map_Grid'
    NAD__1983_HARN_UTM__ZONE__2_S='NAD_1983_HARN_UTM_Zone_2S'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__CENTRAL_FIPS__2112='NAD_Michigan_StatePlane_Michigan_Central_FIPS_2112'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__CENTRAL__OLD_FIPS__2102='NAD_Michigan_StatePlane_Michigan_Central_Old_FIPS_2102'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__EAST__OLD_FIPS__2101='NAD_Michigan_StatePlane_Michigan_East_Old_FIPS_2101'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__NORTH_FIPS__2111='NAD_Michigan_StatePlane_Michigan_North_FIPS_2111'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__SOUTH_FIPS__2113='NAD_Michigan_StatePlane_Michigan_South_FIPS_2113'
    NAD__MICHIGAN__STATE_PLANE__MICHIGAN__WEST__OLD_FIPS__2103='NAD_Michigan_StatePlane_Michigan_West_Old_FIPS_2103'
    OLD__HAWAIIAN__STATE_PLANE__HAWAII__1_FIPS__5101='Old_Hawaiian_StatePlane_Hawaii_1_FIPS_5101'
    OLD__HAWAIIAN__STATE_PLANE__HAWAII__2_FIPS__5102='Old_Hawaiian_StatePlane_Hawaii_2_FIPS_5102'
    OLD__HAWAIIAN__STATE_PLANE__HAWAII__3_FIPS__5103='Old_Hawaiian_StatePlane_Hawaii_3_FIPS_5103'
    OLD__HAWAIIAN__STATE_PLANE__HAWAII__4_FIPS__5104='Old_Hawaiian_StatePlane_Hawaii_4_FIPS_5104'
    OLD__HAWAIIAN__STATE_PLANE__HAWAII__5_FIPS__5105='Old_Hawaiian_StatePlane_Hawaii_5_FIPS_5105'
    PUERTO__RICO__STATE_PLANE__PUERTO__RICO_FIPS__5201='Puerto_Rico_StatePlane_Puerto_Rico_FIPS_5201'
    PUERTO__RICO__STATE_PLANE__VIRGIN__ISLANDS__ST__CROIX_FIPS__5202='Puerto_Rico_StatePlane_Virgin_Islands_St_Croix_FIPS_5202'
    NAD__1927_UTM__ZONE__10_N='NAD_1927_UTM_Zone_10N'
    NAD__1927_UTM__ZONE__11_N='NAD_1927_UTM_Zone_11N'
    NAD__1927_UTM__ZONE__12_N='NAD_1927_UTM_Zone_12N'
    NAD__1927_UTM__ZONE__13_N='NAD_1927_UTM_Zone_13N'
    NAD__1927_UTM__ZONE__14_N='NAD_1927_UTM_Zone_14N'
    NAD__1927_UTM__ZONE__15_N='NAD_1927_UTM_Zone_15N'
    NAD__1927_UTM__ZONE__16_N='NAD_1927_UTM_Zone_16N'
    NAD__1927_UTM__ZONE__17_N='NAD_1927_UTM_Zone_17N'
    NAD__1927_UTM__ZONE__18_N='NAD_1927_UTM_Zone_18N'
    NAD__1927_UTM__ZONE__19_N='NAD_1927_UTM_Zone_19N'
    NAD__1927_UTM__ZONE__20_N='NAD_1927_UTM_Zone_20N'
    NAD__1927_UTM__ZONE__21_N='NAD_1927_UTM_Zone_21N'
    NAD__1927_UTM__ZONE__22_N='NAD_1927_UTM_Zone_22N'
    NAD__1927_UTM__ZONE__3_N='NAD_1927_UTM_Zone_3N'
    NAD__1927_UTM__ZONE__4_N='NAD_1927_UTM_Zone_4N'
    NAD__1927_UTM__ZONE__5_N='NAD_1927_UTM_Zone_5N'
    NAD__1927_UTM__ZONE__6_N='NAD_1927_UTM_Zone_6N'
    NAD__1927_UTM__ZONE__7_N='NAD_1927_UTM_Zone_7N'
    NAD__1927_UTM__ZONE__8_N='NAD_1927_UTM_Zone_8N'
    NAD__1927_UTM__ZONE__9_N='NAD_1927_UTM_Zone_9N'
    NAD__1983_UTM__ZONE__10_N='NAD_1983_UTM_Zone_10N'
    NAD__1983_UTM__ZONE__11_N='NAD_1983_UTM_Zone_11N'
    NAD__1983_UTM__ZONE__12_N='NAD_1983_UTM_Zone_12N'
    NAD__1983_UTM__ZONE__13_N='NAD_1983_UTM_Zone_13N'
    NAD__1983_UTM__ZONE__14_N='NAD_1983_UTM_Zone_14N'
    NAD__1983_UTM__ZONE__15_N='NAD_1983_UTM_Zone_15N'
    NAD__1983_UTM__ZONE__16_N='NAD_1983_UTM_Zone_16N'
    NAD__1983_UTM__ZONE__17_N='NAD_1983_UTM_Zone_17N'
    NAD__1983_UTM__ZONE__18_N='NAD_1983_UTM_Zone_18N'
    NAD__1983_UTM__ZONE__19_N='NAD_1983_UTM_Zone_19N'
    NAD__1983_UTM__ZONE__20_N='NAD_1983_UTM_Zone_20N'
    NAD__1983_UTM__ZONE__21_N='NAD_1983_UTM_Zone_21N'
    NAD__1983_UTM__ZONE__22_N='NAD_1983_UTM_Zone_22N'
    NAD__1983_UTM__ZONE__23_N='NAD_1983_UTM_Zone_23N'
    NAD__1983_UTM__ZONE__3_N='NAD_1983_UTM_Zone_3N'
    NAD__1983_UTM__ZONE__4_N='NAD_1983_UTM_Zone_4N'
    NAD__1983_UTM__ZONE__5_N='NAD_1983_UTM_Zone_5N'
    NAD__1983_UTM__ZONE__6_N='NAD_1983_UTM_Zone_6N'
    NAD__1983_UTM__ZONE__7_N='NAD_1983_UTM_Zone_7N'
    NAD__1983_UTM__ZONE__8_N='NAD_1983_UTM_Zone_8N'
    NAD__1983_UTM__ZONE__9_N='NAD_1983_UTM_Zone_9N'
    ABIDJAN__1987_UTM__ZONE__29_N='Abidjan_1987_UTM_Zone_29N'
    ABIDJAN__1987_UTM__ZONE__30_N='Abidjan_1987_UTM_Zone_30N'
    ADINDAN_UTM__ZONE__37_N='Adindan_UTM_Zone_37N'
    ADINDAN_UTM__ZONE__38_N='Adindan_UTM_Zone_38N'
    AFGOOYE_UTM__ZONE__38_N='Afgooye_UTM_Zone_38N'
    AFGOOYE_UTM__ZONE__39_N='Afgooye_UTM_Zone_39N'
    AIN_EL__ABD_UTM__ZONE__37_N='Ain_el_Abd_UTM_Zone_37N'
    AIN_EL__ABD_UTM__ZONE__38_N='Ain_el_Abd_UTM_Zone_38N'
    AIN_EL__ABD_UTM__ZONE__39_N='Ain_el_Abd_UTM_Zone_39N'
    ARATU_UTM__ZONE__22_S='Aratu_UTM_Zone_22S'
    ARATU_UTM__ZONE__23_S='Aratu_UTM_Zone_23S'
    ARATU_UTM__ZONE__24_S='Aratu_UTM_Zone_24S'
    ARC__1950_UTM__ZONE__34_S='Arc_1950_UTM_Zone_34S'
    ARC__1950_UTM__ZONE__35_S='Arc_1950_UTM_Zone_35S'
    ARC__1950_UTM__ZONE__36_S='Arc_1950_UTM_Zone_36S'
    ARC__1960_UTM__ZONE__35_N='Arc_1960_UTM_Zone_35N'
    ARC__1960_UTM__ZONE__35_S='Arc_1960_UTM_Zone_35S'
    ARC__1960_UTM__ZONE__36_N='Arc_1960_UTM_Zone_36N'
    ARC__1960_UTM__ZONE__36_S='Arc_1960_UTM_Zone_36S'
    ARC__1960_UTM__ZONE__37_N='Arc_1960_UTM_Zone_37N'
    ARC__1960_UTM__ZONE__37_S='Arc_1960_UTM_Zone_37S'
    ATS__1977_UTM__ZONE__19_N='ATS_1977_UTM_Zone_19N'
    ATS__1977_UTM__ZONE__20_N='ATS_1977_UTM_Zone_20N'
    BATAVIA_UTM__ZONE__48_S='Batavia_UTM_Zone_48S'
    BATAVIA_UTM__ZONE__49_S='Batavia_UTM_Zone_49S'
    BATAVIA_UTM__ZONE__50_S='Batavia_UTM_Zone_50S'
    BISSAU_UTM__ZONE__28_N='Bissau_UTM_Zone_28N'
    BOGOTA_UTM__ZONE__17_N='Bogota_UTM_Zone_17N'
    BOGOTA_UTM__ZONE__18_N='Bogota_UTM_Zone_18N'
    CAMACUPA_UTM__ZONE__32_S='Camacupa_UTM_Zone_32S'
    CAMACUPA_UTM__ZONE__33_S='Camacupa_UTM_Zone_33S'
    CAPE_UTM__ZONE__34_S='Cape_UTM_Zone_34S'
    CAPE_UTM__ZONE__35_S='Cape_UTM_Zone_35S'
    CAPE_UTM__ZONE__36_S='Cape_UTM_Zone_36S'
    CARTHAGE_UTM__ZONE__32_N='Carthage_UTM_Zone_32N'
    CONAKRY__1905_UTM__ZONE__28_N='Conakry_1905_UTM_Zone_28N'
    CONAKRY__1905_UTM__ZONE__29_N='Conakry_1905_UTM_Zone_29N'
    CORREGO__ALEGRE_UTM__ZONE__23_S='Corrego_Alegre_UTM_Zone_23S'
    CORREGO__ALEGRE_UTM__ZONE__24_S='Corrego_Alegre_UTM_Zone_24S'
    DABOLA_UTM__ZONE__28_N='Dabola_UTM_Zone_28N'
    DABOLA_UTM__ZONE__29_N='Dabola_UTM_Zone_29N'
    DATUM__73_UTM__ZONE__29_N='Datum_73_UTM_Zone_29N'
    DOUALA_UTM__ZONE__32_N='Douala_UTM_Zone_32N'
    ED__1950_ED_77_UTM__ZONE__38_N='ED_1950_ED77_UTM_Zone_38N'
    ED__1950_ED_77_UTM__ZONE__39_N='ED_1950_ED77_UTM_Zone_39N'
    ED__1950_ED_77_UTM__ZONE__40_N='ED_1950_ED77_UTM_Zone_40N'
    ED__1950_ED_77_UTM__ZONE__41_N='ED_1950_ED77_UTM_Zone_41N'
    ELD__1979_UTM__ZONE__32_N='ELD_1979_UTM_Zone_32N'
    ELD__1979_UTM__ZONE__33_N='ELD_1979_UTM_Zone_33N'
    ELD__1979_UTM__ZONE__34_N='ELD_1979_UTM_Zone_34N'
    ELD__1979_UTM__ZONE__35_N='ELD_1979_UTM_Zone_35N'
    ETRF__1989_UTM__ZONE__28_N='ETRF_1989_UTM_Zone_28N'
    ETRF__1989_UTM__ZONE__29_N='ETRF_1989_UTM_Zone_29N'
    ETRF__1989_UTM__ZONE__30_N='ETRF_1989_UTM_Zone_30N'
    ETRF__1989_UTM__ZONE__31_N='ETRF_1989_UTM_Zone_31N'
    ETRF__1989_UTM__ZONE__32_N='ETRF_1989_UTM_Zone_32N'
    ETRF__1989_UTM__ZONE__33_N='ETRF_1989_UTM_Zone_33N'
    ETRF__1989_UTM__ZONE__34_N='ETRF_1989_UTM_Zone_34N'
    ETRF__1989_UTM__ZONE__35_N='ETRF_1989_UTM_Zone_35N'
    ETRF__1989_UTM__ZONE__36_N='ETRF_1989_UTM_Zone_36N'
    ETRF__1989_UTM__ZONE__37_N='ETRF_1989_UTM_Zone_37N'
    ETRF__1989_UTM__ZONE__38_N='ETRF_1989_UTM_Zone_38N'
    ED__1950_UTM__ZONE__28_N='ED_1950_UTM_Zone_28N'
    ED__1950_UTM__ZONE__29_N='ED_1950_UTM_Zone_29N'
    ED__1950_UTM__ZONE__30_N='ED_1950_UTM_Zone_30N'
    ED__1950_UTM__ZONE__31_N='ED_1950_UTM_Zone_31N'
    ED__1950_UTM__ZONE__32_N='ED_1950_UTM_Zone_32N'
    ED__1950_UTM__ZONE__33_N='ED_1950_UTM_Zone_33N'
    ED__1950_UTM__ZONE__34_N='ED_1950_UTM_Zone_34N'
    ED__1950_UTM__ZONE__35_N='ED_1950_UTM_Zone_35N'
    ED__1950_UTM__ZONE__36_N='ED_1950_UTM_Zone_36N'
    ED__1950_UTM__ZONE__37_N='ED_1950_UTM_Zone_37N'
    ED__1950_UTM__ZONE__38_N='ED_1950_UTM_Zone_38N'
    FAHUD_UTM__ZONE__39_N='Fahud_UTM_Zone_39N'
    FAHUD_UTM__ZONE__40_N='Fahud_UTM_Zone_40N'
    GAROUA_UTM__ZONE__33_N='Garoua_UTM_Zone_33N'
    GRACIOSA__BASE_SW__1948_UTM__ZONE__26_N='Graciosa_Base_SW_1948_UTM_Zone_26N'
    HITO_XVIII__1963_UTM__19_S='Hito_XVIII_1963_UTM_19S'
    HONG__KONG__1980_UTM__ZONE__49_N='Hong_Kong_1980_UTM_Zone_49N'
    HONG__KONG__1980_UTM__ZONE__50_N='Hong_Kong_1980_UTM_Zone_50N'
    INDIAN__1954_UTM__ZONE__46_N='Indian_1954_UTM_Zone_46N'
    INDIAN__1954_UTM__ZONE__47_N='Indian_1954_UTM_Zone_47N'
    INDIAN__1954_UTM__ZONE__48_N='Indian_1954_UTM_Zone_48N'
    INDIAN__1960_UTM__ZONE__48_N='Indian_1960_UTM_Zone_48N'
    INDIAN__1960_UTM__ZONE__49_N='Indian_1960_UTM_Zone_49N'
    INDIAN__1975_UTM__ZONE__47_N='Indian_1975_UTM_Zone_47N'
    INDIAN__1975_UTM__ZONE__48_N='Indian_1975_UTM_Zone_48N'
    INDONESIAN__1974_UTM__ZONE__46_N='Indonesian_1974_UTM_Zone_46N'
    INDONESIAN__1974_UTM__ZONE__46_S='Indonesian_1974_UTM_Zone_46S'
    INDONESIAN__1974_UTM__ZONE__47_N='Indonesian_1974_UTM_Zone_47N'
    INDONESIAN__1974_UTM__ZONE__47_S='Indonesian_1974_UTM_Zone_47S'
    INDONESIAN__1974_UTM__ZONE__48_N='Indonesian_1974_UTM_Zone_48N'
    INDONESIAN__1974_UTM__ZONE__48_S='Indonesian_1974_UTM_Zone_48S'
    INDONESIAN__1974_UTM__ZONE__49_N='Indonesian_1974_UTM_Zone_49N'
    INDONESIAN__1974_UTM__ZONE__49_S='Indonesian_1974_UTM_Zone_49S'
    INDONESIAN__1974_UTM__ZONE__50_N='Indonesian_1974_UTM_Zone_50N'
    INDONESIAN__1974_UTM__ZONE__50_S='Indonesian_1974_UTM_Zone_50S'
    INDONESIAN__1974_UTM__ZONE__51_N='Indonesian_1974_UTM_Zone_51N'
    INDONESIAN__1974_UTM__ZONE__51_S='Indonesian_1974_UTM_Zone_51S'
    INDONESIAN__1974_UTM__ZONE__52_N='Indonesian_1974_UTM_Zone_52N'
    INDONESIAN__1974_UTM__ZONE__52_S='Indonesian_1974_UTM_Zone_52S'
    INDONESIAN__1974_UTM__ZONE__53_N='Indonesian_1974_UTM_Zone_53N'
    INDONESIAN__1974_UTM__ZONE__53_S='Indonesian_1974_UTM_Zone_53S'
    INDONESIAN__1974_UTM__ZONE__54_S='Indonesian_1974_UTM_Zone_54S'
    IRENET_95_UTM__ZONE__29_N='IRENET95_UTM_Zone_29N'
    KERTAU_UTM__ZONE__47_N='Kertau_UTM_Zone_47N'
    KERTAU_UTM__ZONE__48_N='Kertau_UTM_Zone_48N'
    LA__CANOA_UTM__ZONE__18_N='La_Canoa_UTM_Zone_18N'
    LA__CANOA_UTM__ZONE__19_N='La_Canoa_UTM_Zone_19N'
    LA__CANOA_UTM__ZONE__20_N='La_Canoa_UTM_Zone_20N'
    LA__CANOA_UTM__ZONE__21_N='La_Canoa_UTM_Zone_21N'
    LOCODJO__1965_UTM__ZONE__29_N='Locodjo_1965_UTM_Zone_29N'
    LOCODJO__1965_UTM__ZONE__30_N='Locodjo_1965_UTM_Zone_30N'
    LOME_UTM__ZONE__31_N='Lome_UTM_Zone_31N'
    MPORALOKO_UTM__ZONE__32_N='Mporaloko_UTM_Zone_32N'
    MPORALOKO_UTM__ZONE__32_S='Mporaloko_UTM_Zone_32S'
    MALONGO__1987_UTM__ZONE__32_S='Malongo_1987_UTM_Zone_32S'
    MASSAWA_UTM__ZONE__37_N='Massawa_UTM_Zone_37N'
    MHAST_UTM__ZONE__32_S='Mhast_UTM_Zone_32S'
    MINNA_UTM__ZONE__31_N='Minna_UTM_Zone_31N'
    MINNA_UTM__ZONE__32_N='Minna_UTM_Zone_32N'
    MOZNET_UTM__ZONE__36_S='Moznet_UTM_Zone_36S'
    MOZNET_UTM__ZONE__37_S='Moznet_UTM_Zone_37S'
    NAD__1927_BLM__ZONE__14_N='NAD_1927_BLM_Zone_14N'
    NAD__1927_BLM__ZONE__15_N='NAD_1927_BLM_Zone_15N'
    NAD__1927_BLM__ZONE__16_N='NAD_1927_BLM_Zone_16N'
    NAD__1927_BLM__ZONE__17_N='NAD_1927_BLM_Zone_17N'
    NAD__1983_HARN_UTM__ZONE__2_S_1='NAD_1983_HARN_UTM_Zone_2S'
    NAHRWAN__1967_UTM__ZONE__38_N='Nahrwan_1967_UTM_Zone_38N'
    NAHRWAN__1967_UTM__ZONE__39_N='Nahrwan_1967_UTM_Zone_39N'
    NAHRWAN__1967_UTM__ZONE__40_N='Nahrwan_1967_UTM_Zone_40N'
    NAPARIMA__1955_UTM__ZONE__20_N='Naparima_1955_UTM_Zone_20N'
    NAPARIMA__1972_UTM__ZONE__20_N='Naparima_1972_UTM_Zone_20N'
    NGN_UTM__ZONE__38_N='NGN_UTM_Zone_38N'
    NGN_UTM__ZONE__39_N='NGN_UTM_Zone_39N'
    NGO__1948_UTM__ZONE__32_N='NGO_1948_UTM_Zone_32N'
    NGO__1948_UTM__ZONE__33_N='NGO_1948_UTM_Zone_33N'
    NGO__1948_UTM__ZONE__34_N='NGO_1948_UTM_Zone_34N'
    NGO__1948_UTM__ZONE__35_N='NGO_1948_UTM_Zone_35N'
    NORD__SAHARA__1959_UTM__ZONE__29_N='Nord_Sahara_1959_UTM_Zone_29N'
    NORD__SAHARA__1959_UTM__ZONE__30_N='Nord_Sahara_1959_UTM_Zone_30N'
    NORD__SAHARA__1959_UTM__ZONE__31_N='Nord_Sahara_1959_UTM_Zone_31N'
    NORD__SAHARA__1959_UTM__ZONE__32_N='Nord_Sahara_1959_UTM_Zone_32N'
    NZGD__1949_UTM__ZONE__58_S_1='NZGD_1949_UTM_Zone_58S'
    NZGD__1949_UTM__ZONE__59_S_1='NZGD_1949_UTM_Zone_59S'
    NZGD__1949_UTM__ZONE__60_S_1='NZGD_1949_UTM_Zone_60S'
    NZGD__2000_UTM__ZONE__58_S_1='NZGD_2000_UTM_Zone_58S'
    NZGD__2000_UTM__ZONE__59_S_1='NZGD_2000_UTM_Zone_59S'
    NZGD__2000_UTM__ZONE__60_S_1='NZGD_2000_UTM_Zone_60S'
    OBSERV__METEOROLOGICO__1939_UTM__ZONE__25_N='Observ_Meteorologico_1939_UTM_Zone_25N'
    OLD__HAWAIIAN_UTM__ZONE__4_N='Old_Hawaiian_UTM_Zone_4N'
    OLD__HAWAIIAN_UTM__ZONE__5_N='Old_Hawaiian_UTM_Zone_5N'
    PDO__1993_UTM__ZONE__39_N='PDO_1993_UTM_Zone_39N'
    PDO__1993_UTM__ZONE__40_N='PDO_1993_UTM_Zone_40N'
    POINTE__NOIRE_UTM__ZONE__32_S='Pointe_Noire_UTM_Zone_32S'
    PORTO__SANTO__1936_UTM__ZONE__28_N='Porto_Santo_1936_UTM_Zone_28N'
    PSAD__1956_UTM__ZONE__17_S='PSAD_1956_UTM_Zone_17S'
    PSAD__1956_UTM__ZONE__18_N='PSAD_1956_UTM_Zone_18N'
    PSAD__1956_UTM__ZONE__18_S='PSAD_1956_UTM_Zone_18S'
    PSAD__1956_UTM__ZONE__19_N='PSAD_1956_UTM_Zone_19N'
    PSAD__1956_UTM__ZONE__19_S='PSAD_1956_UTM_Zone_19S'
    PSAD__1956_UTM__ZONE__20_N='PSAD_1956_UTM_Zone_20N'
    PSAD__1956_UTM__ZONE__20_S='PSAD_1956_UTM_Zone_20S'
    PSAD__1956_UTM__ZONE__21_N='PSAD_1956_UTM_Zone_21N'
    PSAD__1956_UTM__ZONE__22_S='PSAD_1956_UTM_Zone_22S'
    PUERTO__RICO_UTM__ZONE__20_N='Puerto_Rico_UTM_Zone_20N'
    SAMBOJA_UTM__ZONE__50_S='Samboja_UTM_Zone_50S'
    SAO__BRAZ_UTM__ZONE__26_N='Sao_Braz_UTM_Zone_26N'
    SAPPER__HILL__1943_UTM__ZONE__20_S='Sapper_Hill_1943_UTM_Zone_20S'
    SAPPER__HILL__1943_UTM__ZONE__21_S='Sapper_Hill_1943_UTM_Zone_21S'
    SCHWARZECK_UTM__ZONE__33_S='Schwarzeck_UTM_Zone_33S'
    SELVAGEM__GRANDE__1938_UTM__ZONE__28_N='Selvagem_Grande_1938_UTM_Zone_28N'
    SIERRA__LEONE__1968_UTM__ZONE__28_N='Sierra_Leone_1968_UTM_Zone_28N'
    SIERRA__LEONE__1968_UTM__ZONE__29_N='Sierra_Leone_1968_UTM_Zone_29N'
    SIRGAS_UTM__ZONE__17_N='SIRGAS_UTM_Zone_17N'
    SIRGAS_UTM__ZONE__17_S='SIRGAS_UTM_Zone_17S'
    SIRGAS_UTM__ZONE__18_N='SIRGAS_UTM_Zone_18N'
    SIRGAS_UTM__ZONE__18_S='SIRGAS_UTM_Zone_18S'
    SIRGAS_UTM__ZONE__19_N='SIRGAS_UTM_Zone_19N'
    SIRGAS_UTM__ZONE__19_S='SIRGAS_UTM_Zone_19S'
    SIRGAS_UTM__ZONE__20_N='SIRGAS_UTM_Zone_20N'
    SIRGAS_UTM__ZONE__20_S='SIRGAS_UTM_Zone_20S'
    SIRGAS_UTM__ZONE__21_N='SIRGAS_UTM_Zone_21N'
    SIRGAS_UTM__ZONE__21_S='SIRGAS_UTM_Zone_21S'
    SIRGAS_UTM__ZONE__22_N='SIRGAS_UTM_Zone_22N'
    SIRGAS_UTM__ZONE__22_S='SIRGAS_UTM_Zone_22S'
    SIRGAS_UTM__ZONE__23_S='SIRGAS_UTM_Zone_23S'
    SIRGAS_UTM__ZONE__24_S='SIRGAS_UTM_Zone_24S'
    SIRGAS_UTM__ZONE__25_S='SIRGAS_UTM_Zone_25S'
    SAD__1969_UTM__ZONE__17_S='SAD_1969_UTM_Zone_17S'
    SAD__1969_UTM__ZONE__18_N='SAD_1969_UTM_Zone_18N'
    SAD__1969_UTM__ZONE__18_S='SAD_1969_UTM_Zone_18S'
    SAD__1969_UTM__ZONE__19_N='SAD_1969_UTM_Zone_19N'
    SAD__1969_UTM__ZONE__19_S='SAD_1969_UTM_Zone_19S'
    SAD__1969_UTM__ZONE__20_N='SAD_1969_UTM_Zone_20N'
    SAD__1969_UTM__ZONE__20_S='SAD_1969_UTM_Zone_20S'
    SAD__1969_UTM__ZONE__21_N='SAD_1969_UTM_Zone_21N'
    SAD__1969_UTM__ZONE__21_S='SAD_1969_UTM_Zone_21S'
    SAD__1969_UTM__ZONE__22_N='SAD_1969_UTM_Zone_22N'
    SAD__1969_UTM__ZONE__22_S='SAD_1969_UTM_Zone_22S'
    SAD__1969_UTM__ZONE__23_S='SAD_1969_UTM_Zone_23S'
    SAD__1969_UTM__ZONE__24_S='SAD_1969_UTM_Zone_24S'
    SAD__1969_UTM__ZONE__25_S='SAD_1969_UTM_Zone_25S'
    SUDAN_UTM__ZONE__35_N='Sudan_UTM_Zone_35N'
    SUDAN_UTM__ZONE__36_N='Sudan_UTM_Zone_36N'
    TANANARIVE__1925_UTM__ZONE__38_S='Tananarive_1925_UTM_Zone_38S'
    TANANARIVE__1925_UTM__ZONE__39_S='Tananarive_1925_UTM_Zone_39S'
    TETE_UTM__ZONE__36_S='Tete_UTM_Zone_36S'
    TETE_UTM__ZONE__37_S='Tete_UTM_Zone_37S'
    TIMBALAI__1948_UTM__ZONE__49_N='Timbalai_1948_UTM_Zone_49N'
    TIMBALAI__1948_UTM__ZONE__50_N='Timbalai_1948_UTM_Zone_50N'
    TOKYO_UTM__ZONE__51_N='Tokyo_UTM_Zone_51N'
    TOKYO_UTM__ZONE__52_N='Tokyo_UTM_Zone_52N'
    TOKYO_UTM__ZONE__53_N='Tokyo_UTM_Zone_53N'
    TOKYO_UTM__ZONE__54_N='Tokyo_UTM_Zone_54N'
    TOKYO_UTM__ZONE__55_N='Tokyo_UTM_Zone_55N'
    TOKYO_UTM__ZONE__56_N='Tokyo_UTM_Zone_56N'
    TC__1948_UTM__ZONE__39_N='TC_1948_UTM_Zone_39N'
    TC__1948_UTM__ZONE__40_N='TC_1948_UTM_Zone_40N'
    YEMEN_NGN__1996_UTM__ZONE__38_N='Yemen_NGN_1996_UTM_Zone_38N'
    YEMEN_NGN__1996_UTM__ZONE__39_N='Yemen_NGN_1996_UTM_Zone_39N'
    YOFF__1972_UTM__ZONE__28_N='Yoff_1972_UTM_Zone_28N'
    ZANDERIJ__1972_UTM__ZONE__21_N='Zanderij_1972_UTM_Zone_21N'
    WGS__1972_UTM__ZONE__10_N='WGS_1972_UTM_Zone_10N'
    WGS__1972_UTM__ZONE__10_S='WGS_1972_UTM_Zone_10S'
    WGS__1972_UTM__ZONE__11_N='WGS_1972_UTM_Zone_11N'
    WGS__1972_UTM__ZONE__11_S='WGS_1972_UTM_Zone_11S'
    WGS__1972_UTM__ZONE__12_N='WGS_1972_UTM_Zone_12N'
    WGS__1972_UTM__ZONE__12_S='WGS_1972_UTM_Zone_12S'
    WGS__1972_UTM__ZONE__13_N='WGS_1972_UTM_Zone_13N'
    WGS__1972_UTM__ZONE__13_S='WGS_1972_UTM_Zone_13S'
    WGS__1972_UTM__ZONE__14_N='WGS_1972_UTM_Zone_14N'
    WGS__1972_UTM__ZONE__14_S='WGS_1972_UTM_Zone_14S'
    WGS__1972_UTM__ZONE__15_N='WGS_1972_UTM_Zone_15N'
    WGS__1972_UTM__ZONE__15_S='WGS_1972_UTM_Zone_15S'
    WGS__1972_UTM__ZONE__16_N='WGS_1972_UTM_Zone_16N'
    WGS__1972_UTM__ZONE__16_S='WGS_1972_UTM_Zone_16S'
    WGS__1972_UTM__ZONE__17_N='WGS_1972_UTM_Zone_17N'
    WGS__1972_UTM__ZONE__17_S='WGS_1972_UTM_Zone_17S'
    WGS__1972_UTM__ZONE__18_N='WGS_1972_UTM_Zone_18N'
    WGS__1972_UTM__ZONE__18_S='WGS_1972_UTM_Zone_18S'
    WGS__1972_UTM__ZONE__19_N='WGS_1972_UTM_Zone_19N'
    WGS__1972_UTM__ZONE__19_S='WGS_1972_UTM_Zone_19S'
    WGS__1972_UTM__ZONE__1_N='WGS_1972_UTM_Zone_1N'
    WGS__1972_UTM__ZONE__1_S='WGS_1972_UTM_Zone_1S'
    WGS__1972_UTM__ZONE__20_N='WGS_1972_UTM_Zone_20N'
    WGS__1972_UTM__ZONE__20_S='WGS_1972_UTM_Zone_20S'
    WGS__1972_UTM__ZONE__21_N='WGS_1972_UTM_Zone_21N'
    WGS__1972_UTM__ZONE__21_S='WGS_1972_UTM_Zone_21S'
    WGS__1972_UTM__ZONE__22_N='WGS_1972_UTM_Zone_22N'
    WGS__1972_UTM__ZONE__22_S='WGS_1972_UTM_Zone_22S'
    WGS__1972_UTM__ZONE__23_N='WGS_1972_UTM_Zone_23N'
    WGS__1972_UTM__ZONE__23_S='WGS_1972_UTM_Zone_23S'
    WGS__1972_UTM__ZONE__24_N='WGS_1972_UTM_Zone_24N'
    WGS__1972_UTM__ZONE__24_S='WGS_1972_UTM_Zone_24S'
    WGS__1972_UTM__ZONE__25_N='WGS_1972_UTM_Zone_25N'
    WGS__1972_UTM__ZONE__25_S='WGS_1972_UTM_Zone_25S'
    WGS__1972_UTM__ZONE__26_N='WGS_1972_UTM_Zone_26N'
    WGS__1972_UTM__ZONE__26_S='WGS_1972_UTM_Zone_26S'
    WGS__1972_UTM__ZONE__27_N='WGS_1972_UTM_Zone_27N'
    WGS__1972_UTM__ZONE__27_S='WGS_1972_UTM_Zone_27S'
    WGS__1972_UTM__ZONE__28_N='WGS_1972_UTM_Zone_28N'
    WGS__1972_UTM__ZONE__28_S='WGS_1972_UTM_Zone_28S'
    WGS__1972_UTM__ZONE__29_N='WGS_1972_UTM_Zone_29N'
    WGS__1972_UTM__ZONE__29_S='WGS_1972_UTM_Zone_29S'
    WGS__1972_UTM__ZONE__2_N='WGS_1972_UTM_Zone_2N'
    WGS__1972_UTM__ZONE__2_S='WGS_1972_UTM_Zone_2S'
    WGS__1972_UTM__ZONE__30_N='WGS_1972_UTM_Zone_30N'
    WGS__1972_UTM__ZONE__30_S='WGS_1972_UTM_Zone_30S'
    WGS__1972_UTM__ZONE__31_N='WGS_1972_UTM_Zone_31N'
    WGS__1972_UTM__ZONE__31_S='WGS_1972_UTM_Zone_31S'
    WGS__1972_UTM__ZONE__32_N='WGS_1972_UTM_Zone_32N'
    WGS__1972_UTM__ZONE__32_S='WGS_1972_UTM_Zone_32S'
    WGS__1972_UTM__ZONE__33_N='WGS_1972_UTM_Zone_33N'
    WGS__1972_UTM__ZONE__33_S='WGS_1972_UTM_Zone_33S'
    WGS__1972_UTM__ZONE__34_N='WGS_1972_UTM_Zone_34N'
    WGS__1972_UTM__ZONE__34_S='WGS_1972_UTM_Zone_34S'
    WGS__1972_UTM__ZONE__35_N='WGS_1972_UTM_Zone_35N'
    WGS__1972_UTM__ZONE__35_S='WGS_1972_UTM_Zone_35S'
    WGS__1972_UTM__ZONE__36_N='WGS_1972_UTM_Zone_36N'
    WGS__1972_UTM__ZONE__36_S='WGS_1972_UTM_Zone_36S'
    WGS__1972_UTM__ZONE__37_N='WGS_1972_UTM_Zone_37N'
    WGS__1972_UTM__ZONE__37_S='WGS_1972_UTM_Zone_37S'
    WGS__1972_UTM__ZONE__38_N='WGS_1972_UTM_Zone_38N'
    WGS__1972_UTM__ZONE__38_S='WGS_1972_UTM_Zone_38S'
    WGS__1972_UTM__ZONE__39_N='WGS_1972_UTM_Zone_39N'
    WGS__1972_UTM__ZONE__39_S='WGS_1972_UTM_Zone_39S'
    WGS__1972_UTM__ZONE__3_N='WGS_1972_UTM_Zone_3N'
    WGS__1972_UTM__ZONE__3_S='WGS_1972_UTM_Zone_3S'
    WGS__1972_UTM__ZONE__40_N='WGS_1972_UTM_Zone_40N'
    WGS__1972_UTM__ZONE__40_S='WGS_1972_UTM_Zone_40S'
    WGS__1972_UTM__ZONE__41_N='WGS_1972_UTM_Zone_41N'
    WGS__1972_UTM__ZONE__41_S='WGS_1972_UTM_Zone_41S'
    WGS__1972_UTM__ZONE__42_N='WGS_1972_UTM_Zone_42N'
    WGS__1972_UTM__ZONE__42_S='WGS_1972_UTM_Zone_42S'
    WGS__1972_UTM__ZONE__43_N='WGS_1972_UTM_Zone_43N'
    WGS__1972_UTM__ZONE__43_S='WGS_1972_UTM_Zone_43S'
    WGS__1972_UTM__ZONE__44_N='WGS_1972_UTM_Zone_44N'
    WGS__1972_UTM__ZONE__44_S='WGS_1972_UTM_Zone_44S'
    WGS__1972_UTM__ZONE__45_N='WGS_1972_UTM_Zone_45N'
    WGS__1972_UTM__ZONE__45_S='WGS_1972_UTM_Zone_45S'
    WGS__1972_UTM__ZONE__46_N='WGS_1972_UTM_Zone_46N'
    WGS__1972_UTM__ZONE__46_S='WGS_1972_UTM_Zone_46S'
    WGS__1972_UTM__ZONE__47_N='WGS_1972_UTM_Zone_47N'
    WGS__1972_UTM__ZONE__47_S='WGS_1972_UTM_Zone_47S'
    WGS__1972_UTM__ZONE__48_N='WGS_1972_UTM_Zone_48N'
    WGS__1972_UTM__ZONE__48_S='WGS_1972_UTM_Zone_48S'
    WGS__1972_UTM__ZONE__49_N='WGS_1972_UTM_Zone_49N'
    WGS__1972_UTM__ZONE__49_S='WGS_1972_UTM_Zone_49S'
    WGS__1972_UTM__ZONE__4_N='WGS_1972_UTM_Zone_4N'
    WGS__1972_UTM__ZONE__4_S='WGS_1972_UTM_Zone_4S'
    WGS__1972_UTM__ZONE__50_N='WGS_1972_UTM_Zone_50N'
    WGS__1972_UTM__ZONE__50_S='WGS_1972_UTM_Zone_50S'
    WGS__1972_UTM__ZONE__51_N='WGS_1972_UTM_Zone_51N'
    WGS__1972_UTM__ZONE__51_S='WGS_1972_UTM_Zone_51S'
    WGS__1972_UTM__ZONE__52_N='WGS_1972_UTM_Zone_52N'
    WGS__1972_UTM__ZONE__52_S='WGS_1972_UTM_Zone_52S'
    WGS__1972_UTM__ZONE__53_N='WGS_1972_UTM_Zone_53N'
    WGS__1972_UTM__ZONE__53_S='WGS_1972_UTM_Zone_53S'
    WGS__1972_UTM__ZONE__54_N='WGS_1972_UTM_Zone_54N'
    WGS__1972_UTM__ZONE__54_S='WGS_1972_UTM_Zone_54S'
    WGS__1972_UTM__ZONE__55_N='WGS_1972_UTM_Zone_55N'
    WGS__1972_UTM__ZONE__55_S='WGS_1972_UTM_Zone_55S'
    WGS__1972_UTM__ZONE__56_N='WGS_1972_UTM_Zone_56N'
    WGS__1972_UTM__ZONE__56_S='WGS_1972_UTM_Zone_56S'
    WGS__1972_UTM__ZONE__57_N='WGS_1972_UTM_Zone_57N'
    WGS__1972_UTM__ZONE__57_S='WGS_1972_UTM_Zone_57S'
    WGS__1972_UTM__ZONE__58_N='WGS_1972_UTM_Zone_58N'
    WGS__1972_UTM__ZONE__58_S='WGS_1972_UTM_Zone_58S'
    WGS__1972_UTM__ZONE__59_N='WGS_1972_UTM_Zone_59N'
    WGS__1972_UTM__ZONE__59_S='WGS_1972_UTM_Zone_59S'
    WGS__1972_UTM__ZONE__5_N='WGS_1972_UTM_Zone_5N'
    WGS__1972_UTM__ZONE__5_S='WGS_1972_UTM_Zone_5S'
    WGS__1972_UTM__ZONE__60_N='WGS_1972_UTM_Zone_60N'
    WGS__1972_UTM__ZONE__60_S='WGS_1972_UTM_Zone_60S'
    WGS__1972_UTM__ZONE__6_N='WGS_1972_UTM_Zone_6N'
    WGS__1972_UTM__ZONE__6_S='WGS_1972_UTM_Zone_6S'
    WGS__1972_UTM__ZONE__7_N='WGS_1972_UTM_Zone_7N'
    WGS__1972_UTM__ZONE__7_S='WGS_1972_UTM_Zone_7S'
    WGS__1972_UTM__ZONE__8_N='WGS_1972_UTM_Zone_8N'
    WGS__1972_UTM__ZONE__8_S='WGS_1972_UTM_Zone_8S'
    WGS__1972_UTM__ZONE__9_N='WGS_1972_UTM_Zone_9N'
    WGS__1972_UTM__ZONE__9_S='WGS_1972_UTM_Zone_9S'
    WGS__1984_UTM__ZONE__10_N='WGS_1984_UTM_Zone_10N'
    WGS__1984_UTM__ZONE__10_S='WGS_1984_UTM_Zone_10S'
    WGS__1984_UTM__ZONE__11_N='WGS_1984_UTM_Zone_11N'
    WGS__1984_UTM__ZONE__11_S='WGS_1984_UTM_Zone_11S'
    WGS__1984_UTM__ZONE__12_N='WGS_1984_UTM_Zone_12N'
    WGS__1984_UTM__ZONE__12_S='WGS_1984_UTM_Zone_12S'
    WGS__1984_UTM__ZONE__13_N='WGS_1984_UTM_Zone_13N'
    WGS__1984_UTM__ZONE__13_S='WGS_1984_UTM_Zone_13S'
    WGS__1984_UTM__ZONE__14_N='WGS_1984_UTM_Zone_14N'
    WGS__1984_UTM__ZONE__14_S='WGS_1984_UTM_Zone_14S'
    WGS__1984_UTM__ZONE__15_N='WGS_1984_UTM_Zone_15N'
    WGS__1984_UTM__ZONE__15_S='WGS_1984_UTM_Zone_15S'
    WGS__1984_UTM__ZONE__16_N='WGS_1984_UTM_Zone_16N'
    WGS__1984_UTM__ZONE__16_S='WGS_1984_UTM_Zone_16S'
    WGS__1984_UTM__ZONE__17_N='WGS_1984_UTM_Zone_17N'
    WGS__1984_UTM__ZONE__17_S='WGS_1984_UTM_Zone_17S'
    WGS__1984_UTM__ZONE__18_N='WGS_1984_UTM_Zone_18N'
    WGS__1984_UTM__ZONE__18_S='WGS_1984_UTM_Zone_18S'
    WGS__1984_UTM__ZONE__19_N='WGS_1984_UTM_Zone_19N'
    WGS__1984_UTM__ZONE__19_S='WGS_1984_UTM_Zone_19S'
    WGS__1984_UTM__ZONE__1_N='WGS_1984_UTM_Zone_1N'
    WGS__1984_UTM__ZONE__1_S='WGS_1984_UTM_Zone_1S'
    WGS__1984_UTM__ZONE__20_N='WGS_1984_UTM_Zone_20N'
    WGS__1984_UTM__ZONE__20_S='WGS_1984_UTM_Zone_20S'
    WGS__1984_UTM__ZONE__21_N='WGS_1984_UTM_Zone_21N'
    WGS__1984_UTM__ZONE__21_S='WGS_1984_UTM_Zone_21S'
    WGS__1984_UTM__ZONE__22_N='WGS_1984_UTM_Zone_22N'
    WGS__1984_UTM__ZONE__22_S='WGS_1984_UTM_Zone_22S'
    WGS__1984_UTM__ZONE__23_N='WGS_1984_UTM_Zone_23N'
    WGS__1984_UTM__ZONE__23_S='WGS_1984_UTM_Zone_23S'
    WGS__1984_UTM__ZONE__24_N='WGS_1984_UTM_Zone_24N'
    WGS__1984_UTM__ZONE__24_S='WGS_1984_UTM_Zone_24S'
    WGS__1984_UTM__ZONE__25_N='WGS_1984_UTM_Zone_25N'
    WGS__1984_UTM__ZONE__25_S='WGS_1984_UTM_Zone_25S'
    WGS__1984_UTM__ZONE__26_N='WGS_1984_UTM_Zone_26N'
    WGS__1984_UTM__ZONE__26_S='WGS_1984_UTM_Zone_26S'
    WGS__1984_UTM__ZONE__27_N='WGS_1984_UTM_Zone_27N'
    WGS__1984_UTM__ZONE__27_S='WGS_1984_UTM_Zone_27S'
    WGS__1984_UTM__ZONE__28_N='WGS_1984_UTM_Zone_28N'
    WGS__1984_UTM__ZONE__28_S='WGS_1984_UTM_Zone_28S'
    WGS__1984_UTM__ZONE__29_N='WGS_1984_UTM_Zone_29N'
    WGS__1984_UTM__ZONE__29_S='WGS_1984_UTM_Zone_29S'
    WGS__1984_UTM__ZONE__2_N='WGS_1984_UTM_Zone_2N'
    WGS__1984_UTM__ZONE__2_S='WGS_1984_UTM_Zone_2S'
    WGS__1984_UTM__ZONE__30_N='WGS_1984_UTM_Zone_30N'
    WGS__1984_UTM__ZONE__30_S='WGS_1984_UTM_Zone_30S'
    WGS__1984_UTM__ZONE__31_N='WGS_1984_UTM_Zone_31N'
    WGS__1984_UTM__ZONE__31_S='WGS_1984_UTM_Zone_31S'
    WGS__1984_UTM__ZONE__32_N='WGS_1984_UTM_Zone_32N'
    WGS__1984_UTM__ZONE__32_S='WGS_1984_UTM_Zone_32S'
    WGS__1984_UTM__ZONE__33_N='WGS_1984_UTM_Zone_33N'
    WGS__1984_UTM__ZONE__33_S='WGS_1984_UTM_Zone_33S'
    WGS__1984_UTM__ZONE__34_N='WGS_1984_UTM_Zone_34N'
    WGS__1984_UTM__ZONE__34_S='WGS_1984_UTM_Zone_34S'
    WGS__1984_UTM__ZONE__35_N='WGS_1984_UTM_Zone_35N'
    WGS__1984_UTM__ZONE__35_S='WGS_1984_UTM_Zone_35S'
    WGS__1984_UTM__ZONE__36_N='WGS_1984_UTM_Zone_36N'
    WGS__1984_UTM__ZONE__36_S='WGS_1984_UTM_Zone_36S'
    WGS__1984_UTM__ZONE__37_N='WGS_1984_UTM_Zone_37N'
    WGS__1984_UTM__ZONE__37_S='WGS_1984_UTM_Zone_37S'
    WGS__1984_UTM__ZONE__38_N='WGS_1984_UTM_Zone_38N'
    WGS__1984_UTM__ZONE__38_S='WGS_1984_UTM_Zone_38S'
    WGS__1984_UTM__ZONE__39_N='WGS_1984_UTM_Zone_39N'
    WGS__1984_UTM__ZONE__39_S='WGS_1984_UTM_Zone_39S'
    WGS__1984_UTM__ZONE__3_N='WGS_1984_UTM_Zone_3N'
    WGS__1984_UTM__ZONE__3_S='WGS_1984_UTM_Zone_3S'
    WGS__1984_UTM__ZONE__40_N='WGS_1984_UTM_Zone_40N'
    WGS__1984_UTM__ZONE__40_S='WGS_1984_UTM_Zone_40S'
    WGS__1984_UTM__ZONE__41_N='WGS_1984_UTM_Zone_41N'
    WGS__1984_UTM__ZONE__41_S='WGS_1984_UTM_Zone_41S'
    WGS__1984_UTM__ZONE__42_N='WGS_1984_UTM_Zone_42N'
    WGS__1984_UTM__ZONE__42_S='WGS_1984_UTM_Zone_42S'
    WGS__1984_UTM__ZONE__43_N='WGS_1984_UTM_Zone_43N'
    WGS__1984_UTM__ZONE__43_S='WGS_1984_UTM_Zone_43S'
    WGS__1984_UTM__ZONE__44_N='WGS_1984_UTM_Zone_44N'
    WGS__1984_UTM__ZONE__44_S='WGS_1984_UTM_Zone_44S'
    WGS__1984_UTM__ZONE__45_N='WGS_1984_UTM_Zone_45N'
    WGS__1984_UTM__ZONE__45_S='WGS_1984_UTM_Zone_45S'
    WGS__1984_UTM__ZONE__46_N='WGS_1984_UTM_Zone_46N'
    WGS__1984_UTM__ZONE__46_S='WGS_1984_UTM_Zone_46S'
    WGS__1984_UTM__ZONE__47_N='WGS_1984_UTM_Zone_47N'
    WGS__1984_UTM__ZONE__47_S='WGS_1984_UTM_Zone_47S'
    WGS__1984_UTM__ZONE__48_N='WGS_1984_UTM_Zone_48N'
    WGS__1984_UTM__ZONE__48_S='WGS_1984_UTM_Zone_48S'
    WGS__1984_UTM__ZONE__49_N='WGS_1984_UTM_Zone_49N'
    WGS__1984_UTM__ZONE__49_S='WGS_1984_UTM_Zone_49S'
    WGS__1984_UTM__ZONE__4_N='WGS_1984_UTM_Zone_4N'
    WGS__1984_UTM__ZONE__4_S='WGS_1984_UTM_Zone_4S'
    WGS__1984_UTM__ZONE__50_N='WGS_1984_UTM_Zone_50N'
    WGS__1984_UTM__ZONE__50_S='WGS_1984_UTM_Zone_50S'
    WGS__1984_UTM__ZONE__51_N='WGS_1984_UTM_Zone_51N'
    WGS__1984_UTM__ZONE__51_S='WGS_1984_UTM_Zone_51S'
    WGS__1984_UTM__ZONE__52_N='WGS_1984_UTM_Zone_52N'
    WGS__1984_UTM__ZONE__52_S='WGS_1984_UTM_Zone_52S'
    WGS__1984_UTM__ZONE__53_N='WGS_1984_UTM_Zone_53N'
    WGS__1984_UTM__ZONE__53_S='WGS_1984_UTM_Zone_53S'
    WGS__1984_UTM__ZONE__54_N='WGS_1984_UTM_Zone_54N'
    WGS__1984_UTM__ZONE__54_S='WGS_1984_UTM_Zone_54S'
    WGS__1984_UTM__ZONE__55_N='WGS_1984_UTM_Zone_55N'
    WGS__1984_UTM__ZONE__55_S='WGS_1984_UTM_Zone_55S'
    WGS__1984_UTM__ZONE__56_N='WGS_1984_UTM_Zone_56N'
    WGS__1984_UTM__ZONE__56_S='WGS_1984_UTM_Zone_56S'
    WGS__1984_UTM__ZONE__57_N='WGS_1984_UTM_Zone_57N'
    WGS__1984_UTM__ZONE__57_S='WGS_1984_UTM_Zone_57S'
    WGS__1984_UTM__ZONE__58_N='WGS_1984_UTM_Zone_58N'
    WGS__1984_UTM__ZONE__58_S='WGS_1984_UTM_Zone_58S'
    WGS__1984_UTM__ZONE__59_N='WGS_1984_UTM_Zone_59N'
    WGS__1984_UTM__ZONE__59_S='WGS_1984_UTM_Zone_59S'
    WGS__1984_UTM__ZONE__5_N='WGS_1984_UTM_Zone_5N'
    WGS__1984_UTM__ZONE__5_S='WGS_1984_UTM_Zone_5S'
    WGS__1984_UTM__ZONE__60_N='WGS_1984_UTM_Zone_60N'
    WGS__1984_UTM__ZONE__60_S='WGS_1984_UTM_Zone_60S'
    WGS__1984_UTM__ZONE__6_N='WGS_1984_UTM_Zone_6N'
    WGS__1984_UTM__ZONE__6_S='WGS_1984_UTM_Zone_6S'
    WGS__1984_UTM__ZONE__7_N='WGS_1984_UTM_Zone_7N'
    WGS__1984_UTM__ZONE__7_S='WGS_1984_UTM_Zone_7S'
    WGS__1984_UTM__ZONE__8_N='WGS_1984_UTM_Zone_8N'
    WGS__1984_UTM__ZONE__8_S='WGS_1984_UTM_Zone_8S'
    WGS__1984_UTM__ZONE__9_N='WGS_1984_UTM_Zone_9N'
    WGS__1984_UTM__ZONE__9_S='WGS_1984_UTM_Zone_9S'
    WORLD__AITOFF='World_Aitoff'
    WORLD__BEHRMANN='World_Behrmann'
    WORLD__BONNE='World_Bonne'
    WORLD__CRASTER__PARABOLIC='World_Craster_Parabolic'
    WORLD__CYLINDRICAL__EQUAL__AREA='World_Cylindrical_Equal_Area'
    WORLD__ECKERT_I='World_Eckert_I'
    WORLD__ECKERT_II='World_Eckert_II'
    WORLD__ECKERT_III='World_Eckert_III'
    WORLD__ECKERT_IV='World_Eckert_IV'
    WORLD__ECKERT_V='World_Eckert_V'
    WORLD__ECKERT_VI='World_Eckert_VI'
    WORLD__EQUIDISTANT__CONIC='World_Equidistant_Conic'
    WORLD__EQUIDISTANT__CYLINDRICAL='World_Equidistant_Cylindrical'
    WORLD__FLAT__POLAR__QUARTIC='World_Flat_Polar_Quartic'
    WORLD__GALL__STEREOGRAPHIC='World_Gall_Stereographic'
    WORLD__HAMMER__AITOFF='World_Hammer_Aitoff'
    WORLD__LOXIMUTHAL='World_Loximuthal'
    WORLD__MERCATOR='World_Mercator'
    WORLD__MILLER__CYLINDRICAL='World_Miller_Cylindrical'
    WORLD__MOLLWEIDE='World_Mollweide'
    WORLD__PLATE__CARREE='World_Plate_Carree'
    WORLD__POLYCONIC='World_Polyconic'
    WORLD__QUARTIC__AUTHALIC='World_Quartic_Authalic'
    WORLD__ROBINSON='World_Robinson'
    WORLD__SINUSOIDAL='World_Sinusoidal'
    SPHERE__AITOFF='Sphere_Aitoff'
    SPHERE__BEHRMANN='Sphere_Behrmann'
    SPHERE__BONNE='Sphere_Bonne'
    SPHERE__CRASTER__PARABOLIC='Sphere_Craster_Parabolic'
    SPHERE__CYLINDRICAL__EQUAL__AREA='Sphere_Cylindrical_Equal_Area'
    SPHERE__ECKERT_I='Sphere_Eckert_I'
    SPHERE__ECKERT_II='Sphere_Eckert_II'
    SPHERE__ECKERT_III='Sphere_Eckert_III'
    SPHERE__ECKERT_IV='Sphere_Eckert_IV'
    SPHERE__ECKERT_V='Sphere_Eckert_V'
    SPHERE__ECKERT_VI='Sphere_Eckert_VI'
    SPHERE__EQUIDISTANT__CONIC='Sphere_Equidistant_Conic'
    SPHERE__EQUIDISTANT__CYLINDRICAL='Sphere_Equidistant_Cylindrical'
    SPHERE__FLAT__POLAR__QUARTIC='Sphere_Flat_Polar_Quartic'
    SPHERE__GALL__STEREOGRAPHIC='Sphere_Gall_Stereographic'
    SPHERE__HAMMER__AITOFF='Sphere_Hammer_Aitoff'
    SPHERE__LOXIMUTHAL='Sphere_Loximuthal'
    SPHERE__MERCATOR='Sphere_Mercator'
    SPHERE__MILLER__CYLINDRICAL='Sphere_Miller_Cylindrical'
    SPHERE__MOLLWEIDE='Sphere_Mollweide'
    SPHERE__PLATE__CARREE='Sphere_Plate_Carree'
    SPHERE__POLYCONIC='Sphere_Polyconic'
    SPHERE__QUARTIC__AUTHALIC='Sphere_Quartic_Authalic'
    SPHERE__ROBINSON='Sphere_Robinson'
    SPHERE__SINUSOIDAL='Sphere_Sinusoidal'
    SPHERE__TIMES='Sphere_Times'
    SPHERE__VAN_DER__GRINTEN_I='Sphere_Van_der_Grinten_I'
    SPHERE__VERTICAL__PERSPECTIVE='Sphere_Vertical_Perspective'
    SPHERE__WINKEL_I='Sphere_Winkel_I'
    SPHERE__WINKEL_II='Sphere_Winkel_II'
    SPHERE__WINKEL__TRIPEL_NGS='Sphere_Winkel_Tripel_NGS'
    THE__WORLD__FROM__SPACE='The_World_From_Space'
    WORLD__TIMES='World_Times'
    WORLD__VAN_DER__GRINTEN_I='World_Van_der_Grinten_I'
    WORLD__VERTICAL__PERSPECTIVE='World_Vertical_Perspective'
    WORLD__WINKEL_I='World_Winkel_I'
    WORLD__WINKEL_II='World_Winkel_II'
    WORLD__WINKEL__TRIPEL_NGS='World_Winkel_Tripel_NGS'


class lengthUnits(str, Enum):
    METER='meter'
    NANOMETER='nanometer'
    MICROMETER='micrometer'
    MICRON='micron'
    MILLIMETER='millimeter'
    CENTIMETER='centimeter'
    DECIMETER='decimeter'
    DEKAMETER='dekameter'
    HECTOMETER='hectometer'
    KILOMETER='kilometer'
    MEGAMETER='megameter'
    ANGSTROM='angstrom'
    INCH='inch'
    FOOT_US='Foot_US'
    FOOT='foot'
    FOOT__GOLD__COAST='Foot_Gold_Coast'
    FATHOM='fathom'
    NAUTICAL_MILE='nauticalMile'
    YARD='yard'
    YARD__INDIAN='Yard_Indian'
    LINK__CLARKE='Link_Clarke'
    YARD__SEARS='Yard_Sears'
    MILE='mile'


class orderType(str, Enum):
    ALLOW_FIRST='allowFirst'
    DENY_FIRST='denyFirst'


class otherUnitType(str, Enum):
    ACRE='acre'
    AMPERE='ampere'
    AMPERE_PER_METER='amperePerMeter'
    AMPERE_PER_METER_SQUARED='amperePerMeterSquared'
    AMPERE_PER_SQUARE_METER='amperePerSquareMeter'
    ARE='are'
    ATMOSPHERE='atmosphere'
    BAR='bar'
    BECQUEREL='becquerel'
    BRITISH_THERMAL_UNIT='britishThermalUnit'
    BUSHEL='bushel'
    BUSHEL_PER_ACRE='bushelPerAcre'
    BUSHELS_PER_ACRE='bushelsPerAcre'
    CALORIE='calorie'
    CANDELA='candela'
    CANDELA_PER_METER_SQUARED='candelaPerMeterSquared'
    CANDELA_PER_SQUARE_METER='candelaPerSquareMeter'
    CELSIUS='celsius'
    CENTIMETER_CUBED='centimeterCubed'
    CENTIMETER_PER_SECOND='centimeterPerSecond'
    CENTIMETER_PER_YEAR='centimeterPerYear'
    CENTIMETER_SQUARED='centimeterSquared'
    CENTIMETERS_PER_SECOND='centimetersPerSecond'
    CENTISECOND='centisecond'
    COULOMB='coulomb'
    CUBIC_CENTIMETERS_PER_CUBIC_CENTIMETERS='cubicCentimetersPerCubicCentimeters'
    CUBIC_FEET_PER_SECOND='cubicFeetPerSecond'
    CUBIC_INCH='cubicInch'
    CUBIC_METER='cubicMeter'
    CUBIC_METER_PER_KILOGRAM='cubicMeterPerKilogram'
    CUBIC_METERS_PER_SECOND='cubicMetersPerSecond'
    CUBIC_MICROMETERS_PER_GRAM='cubicMicrometersPerGram'
    DECIBAR='decibar'
    DECISECOND='decisecond'
    DEKASECOND='dekasecond'
    DIMENSIONLESS='dimensionless'
    EQUIVALENT_PER_LITER='equivalentPerLiter'
    FAHRENHEIT='fahrenheit'
    FARAD='farad'
    FEET_PER_DAY='feetPerDay'
    FEET_PER_HOUR='feetPerHour'
    FEET_PER_SECOND='feetPerSecond'
    FEET_SQUARED_PER_DAY='feetSquaredPerDay'
    FOOT_CUBED_PER_SECOND='footCubedPerSecond'
    FOOT_PER_DAY='footPerDay'
    FOOT_PER_HOUR='footPerHour'
    FOOT_PER_SECOND='footPerSecond'
    FOOT_POUND='footPound'
    FOOT_SQUARED='footSquared'
    FOOT_SQUARED_PER_DAY='footSquaredPerDay'
    GALLON='gallon'
    GRAM_PER_CENTIMETER_CUBED='gramPerCentimeterCubed'
    GRAM_PER_CENTIMETER_SQUARED_PER_SECOND='gramPerCentimeterSquaredPerSecond'
    GRAM_PER_DAY_PER_HECTARE='gramPerDayPerHectare'
    GRAM_PER_DAY_PER_LITER='gramPerDayPerLiter'
    GRAM_PER_GRAM='gramPerGram'
    GRAM_PER_LITER='gramPerLiter'
    GRAM_PER_METER_SQUARED='gramPerMeterSquared'
    GRAM_PER_METER_SQUARED_PER_DAY='gramPerMeterSquaredPerDay'
    GRAM_PER_METER_SQUARED_PER_YEAR='gramPerMeterSquaredPerYear'
    GRAM_PER_MILLILITER='gramPerMilliliter'
    GRAM_PER_YEAR='gramPerYear'
    GRAM_PERCENTIMETER_SQUARED='gramPercentimeterSquared'
    GRAMS_PER_CENTIMETER_SQUARED_PER_SECOND='gramsPerCentimeterSquaredPerSecond'
    GRAMS_PER_CUBIC_CENTIMETER='gramsPerCubicCentimeter'
    GRAMS_PER_GRAM='gramsPerGram'
    GRAMS_PER_HECTARE_PER_DAY='gramsPerHectarePerDay'
    GRAMS_PER_LITER='gramsPerLiter'
    GRAMS_PER_LITER_PER_DAY='gramsPerLiterPerDay'
    GRAMS_PER_METER_SQUARED_PER_YEAR='gramsPerMeterSquaredPerYear'
    GRAMS_PER_MILLILITER='gramsPerMilliliter'
    GRAMS_PER_SQUARE_METER='gramsPerSquareMeter'
    GRAMS_PER_YEAR='gramsPerYear'
    GRAY='gray'
    HECTARE='hectare'
    HECTOPASCAL='hectopascal'
    HECTOSECOND='hectosecond'
    HENRY='henry'
    HERTZ='hertz'
    HOUR='hour'
    INCH_CUBED='inchCubed'
    INCH_PER_HOUR='inchPerHour'
    INVERSE_CENTIMETER='inverseCentimeter'
    INVERSE_METER='inverseMeter'
    JOULE='joule'
    KATAL='katal'
    KELVIN='kelvin'
    KILOGRAM_PER_CUBIC_METER='kilogramPerCubicMeter'
    KILOGRAM_PER_HECTARE='kilogramPerHectare'
    KILOGRAM_PER_HECTARE_PER_YEAR='kilogramPerHectarePerYear'
    KILOGRAM_PER_METER_CUBED='kilogramPerMeterCubed'
    KILOGRAM_PER_METER_SQUARED='kilogramPerMeterSquared'
    KILOGRAM_PER_METER_SQUARED_PER_DAY='kilogramPerMeterSquaredPerDay'
    KILOGRAM_PER_METER_SQUARED_PER_SECOND='kilogramPerMeterSquaredPerSecond'
    KILOGRAM_PER_METER_SQUARED_PER_YEAR='kilogramPerMeterSquaredPerYear'
    KILOGRAM_PER_SECOND='kilogramPerSecond'
    KILOGRAMS_PER_HECTARE='kilogramsPerHectare'
    KILOGRAMS_PER_HECTARE_PER_YEAR='kilogramsPerHectarePerYear'
    KILOGRAMS_PER_METER_SQUARED_PER_SECOND='kilogramsPerMeterSquaredPerSecond'
    KILOGRAMS_PER_METER_SQUARED_PER_YEAR='kilogramsPerMeterSquaredPerYear'
    KILOGRAMS_PER_SECOND='kilogramsPerSecond'
    KILOGRAMS_PER_SQUARE_METER='kilogramsPerSquareMeter'
    KILOHERTZ='kilohertz'
    KILOLITER='kiloliter'
    KILOMETER_PER_HOUR='kilometerPerHour'
    KILOMETER_SQUARED='kilometerSquared'
    KILOMETERS_PER_HOUR='kilometersPerHour'
    KILOPASCAL='kilopascal'
    KILOSECOND='kilosecond'
    KILOVOLT='kilovolt'
    KILOWATT='kilowatt'
    KILOWATT_PER_METER_SQUARED='kilowattPerMeterSquared'
    KNOT='knot'
    KNOTS='knots'
    LANGLEY='langley'
    LANGLEY_PER_DAY='langleyPerDay'
    LITER='liter'
    LITER_PER_HECTARE='literPerHectare'
    LITER_PER_LITER='literPerLiter'
    LITER_PER_METER_SQUARED='literPerMeterSquared'
    LITER_PER_SECOND='literPerSecond'
    LITERS_PER_HECTARE='litersPerHectare'
    LITERS_PER_SECOND='litersPerSecond'
    LITERS_PER_SQUARE_METER='litersPerSquareMeter'
    LUMEN='lumen'
    LUX='lux'
    MEGAGRAM_PER_METER_CUBED='megagramPerMeterCubed'
    MEGAHERTZ='megahertz'
    MEGAJOULE_PER_METER_SQUARED_PER_DAY='megajoulePerMeterSquaredPerDay'
    MEGAPASCAL='megapascal'
    MEGASECOND='megasecond'
    MEGAVOLT='megavolt'
    MEGAWATT='megawatt'
    METER_CUBED='meterCubed'
    METER_CUBED_PER_HECTARE='meterCubedPerHectare'
    METER_CUBED_PER_KILOGRAM='meterCubedPerKilogram'
    METER_CUBED_PER_METER_CUBED='meterCubedPerMeterCubed'
    METER_CUBED_PER_METER_SQUARED='meterCubedPerMeterSquared'
    METER_CUBED_PER_SECOND='meterCubedPerSecond'
    METER_PER_DAY='meterPerDay'
    METER_PER_GRAM='meterPerGram'
    METER_PER_SECOND='meterPerSecond'
    METER_PER_SECOND_SQUARED='meterPerSecondSquared'
    METER_SQUARED='meterSquared'
    METER_SQUARED_PER_DAY='meterSquaredPerDay'
    METER_SQUARED_PER_HECTARE='meterSquaredPerHectare'
    METER_SQUARED_PER_KILOGRAM='meterSquaredPerKilogram'
    METER_SQUARED_PER_SECOND='meterSquaredPerSecond'
    METERS_PER_DAY='metersPerDay'
    METERS_PER_GRAM='metersPerGram'
    METERS_PER_SECOND='metersPerSecond'
    METERS_PER_SECOND_SQUARED='metersPerSecondSquared'
    METERS_SQUARED_PER_DAY='metersSquaredPerDay'
    METERS_SQUARED_PER_SECOND='metersSquaredPerSecond'
    MICROEQUIVALENT_PER_LITER='microequivalentPerLiter'
    MICROGRAM_PER_GRAM='microgramPerGram'
    MICROGRAM_PER_GRAM_PER_DAY='microgramPerGramPerDay'
    MICROGRAM_PER_GRAM_PER_HOUR='microgramPerGramPerHour'
    MICROGRAM_PER_GRAM_PER_WEEK='microgramPerGramPerWeek'
    MICROGRAM_PER_LITER='microgramPerLiter'
    MICROGRAMS_PER_GRAM='microgramsPerGram'
    MICROGRAMS_PER_LITER='microgramsPerLiter'
    MICROLITER='microliter'
    MICROLITER_PER_LITER='microliterPerLiter'
    MICROMETER_CUBED_PER_GRAM='micrometerCubedPerGram'
    MICROMOLE_PER_CENTIMETER_SQUARED_PER_SECOND='micromolePerCentimeterSquaredPerSecond'
    MICROMOLE_PER_GRAM='micromolePerGram'
    MICROMOLE_PER_GRAM_PER_DAY='micromolePerGramPerDay'
    MICROMOLE_PER_GRAM_PER_HOUR='micromolePerGramPerHour'
    MICROMOLE_PER_GRAM_PER_SECOND='micromolePerGramPerSecond'
    MICROMOLE_PER_KILOGRAM='micromolePerKilogram'
    MICROMOLE_PER_LITER='micromolePerLiter'
    MICROMOLE_PER_METER_SQUARED_PER_SECOND='micromolePerMeterSquaredPerSecond'
    MICROMOLE_PER_MOLE='micromolePerMole'
    MICROSECOND='microsecond'
    MICROWATT_PER_CENTIMETER_SQUARED_PER_NANOMETER='microwattPerCentimeterSquaredPerNanometer'
    MICROWATT_PER_CENTIMETER_SQUARED_PER_NANOMETER_PER_STERADIAN='microwattPerCentimeterSquaredPerNanometerPerSteradian'
    MICROWATT_PER_CENTIMETER_SQUARED_PER_STERADIAN='microwattPerCentimeterSquaredPerSteradian'
    MILE_PER_HOUR='milePerHour'
    MILE_PER_MINUTE='milePerMinute'
    MILE_PER_SECOND='milePerSecond'
    MILE_SQUARED='mileSquared'
    MILES_PER_HOUR='milesPerHour'
    MILES_PER_MINUTE='milesPerMinute'
    MILES_PER_SECOND='milesPerSecond'
    MILLI_GRAMS_PER_MILLI_LITER='milliGramsPerMilliLiter'
    MILLIBAR='millibar'
    MILLIEQUIVALENT_PER_LITER='milliequivalentPerLiter'
    MILLIGRAM_PER_KILOGRAM='milligramPerKilogram'
    MILLIGRAM_PER_LITER='milligramPerLiter'
    MILLIGRAM_PER_METER_CUBED='milligramPerMeterCubed'
    MILLIGRAM_PER_METER_CUBED_PER_DAY='milligramPerMeterCubedPerDay'
    MILLIGRAM_PER_METER_SQUARED='milligramPerMeterSquared'
    MILLIGRAM_PER_METER_SQUARED_PER_DAY='milligramPerMeterSquaredPerDay'
    MILLIGRAM_PER_MILLILITER='milligramPerMilliliter'
    MILLIGRAMS_PER_CUBIC_METER='milligramsPerCubicMeter'
    MILLIGRAMS_PER_LITER='milligramsPerLiter'
    MILLIGRAMS_PER_SQUARE_METER='milligramsPerSquareMeter'
    MILLIHERTZ='millihertz'
    MILLILITER='milliliter'
    MILLILITER_PER_LITER='milliliterPerLiter'
    MILLIMETER_PER_DAY='millimeterPerDay'
    MILLIMETER_PER_SECOND='millimeterPerSecond'
    MILLIMETER_SQUARED='millimeterSquared'
    MILLIMETERS_PER_SECOND='millimetersPerSecond'
    MILLIMOLE_PER_GRAM='millimolePerGram'
    MILLIMOLE_PER_KILOGRAM='millimolePerKilogram'
    MILLIMOLE_PER_LITER='millimolePerLiter'
    MILLIMOLE_PER_METER_CUBED='millimolePerMeterCubed'
    MILLIMOLE_PER_MOLE='millimolePerMole'
    MILLIMOLES_PER_GRAM='millimolesPerGram'
    MILLISECOND='millisecond'
    MILLIVOLT='millivolt'
    MILLIWATT='milliwatt'
    MINUTE='minute'
    MOLALITY='molality'
    MOLARITY='molarity'
    MOLE='mole'
    MOLE_PER_CUBIC_METER='molePerCubicMeter'
    MOLE_PER_GRAM='molePerGram'
    MOLE_PER_KILOGRAM='molePerKilogram'
    MOLE_PER_KILOGRAM_1='molePerKilogram'
    MOLE_PER_KILOGRAM_PER_SECOND='molePerKilogramPerSecond'
    MOLE_PER_LITER='molePerLiter'
    MOLE_PER_METER_CUBED='molePerMeterCubed'
    MOLE_PER_METER_SQUARED_PER_SECOND='molePerMeterSquaredPerSecond'
    MOLE_PER_MOLE='molePerMole'
    MOLES_PER_GRAM='molesPerGram'
    MOLES_PER_KILOGRAM='molesPerKilogram'
    MOLES_PER_KILOGRAM_PER_SECOND='molesPerKilogramPerSecond'
    NANOGRAM_PER_GRAM='nanogramPerGram'
    NANOGRAM_PER_GRAM_PER_HOUR='nanogramPerGramPerHour'
    NANOLITER_PER_LITER='nanoliterPerLiter'
    NANOMOLE_PER_GRAM_PER_DAY='nanomolePerGramPerDay'
    NANOMOLE_PER_GRAM_PER_HOUR='nanomolePerGramPerHour'
    NANOMOLE_PER_GRAM_PER_SECOND='nanomolePerGramPerSecond'
    NANOMOLE_PER_KILOGRAM='nanomolePerKilogram'
    NANOMOLE_PER_LITER='nanomolePerLiter'
    NANOMOLE_PER_MOLE='nanomolePerMole'
    NANOMOLES_PER_GRAM_PER_SECOND='nanomolesPerGramPerSecond'
    NANOSECOND='nanosecond'
    NEWTON='newton'
    NOMINAL_DAY='nominalDay'
    NOMINAL_HOUR='nominalHour'
    NOMINAL_LEAP_YEAR='nominalLeapYear'
    NOMINAL_MINUTE='nominalMinute'
    NOMINAL_WEEK='nominalWeek'
    NOMINAL_YEAR='nominalYear'
    NUMBER='number'
    NUMBER_PER_GRAM='numberPerGram'
    NUMBER_PER_HECTARE='numberPerHectare'
    NUMBER_PER_KILOMETER_SQUARED='numberPerKilometerSquared'
    NUMBER_PER_LITER='numberPerLiter'
    NUMBER_PER_METER_CUBED='numberPerMeterCubed'
    NUMBER_PER_METER_SQUARED='numberPerMeterSquared'
    NUMBER_PER_MILLILITER='numberPerMilliliter'
    OHM='ohm'
    OHM_METER='ohmMeter'
    PASCAL='pascal'
    PERCENT='percent'
    PERMIL='permil'
    PINT='pint'
    POUND_PER_ACRE='poundPerAcre'
    POUND_PER_INCH_SQUARED='poundPerInchSquared'
    POUNDS_PER_SQUARE_INCH='poundsPerSquareInch'
    QUART='quart'
    SECOND='second'
    SIEMEN='siemen'
    SIEMENS='siemens'
    SIEMENS_PER_CENTIMETER='siemensPerCentimeter'
    SIEMENS_PER_METER='siemensPerMeter'
    SIEVERT='sievert'
    SQUARE_CENTIMETERS='squareCentimeters'
    SQUARE_FOOT='squareFoot'
    SQUARE_KILOMETERS='squareKilometers'
    SQUARE_METER='squareMeter'
    SQUARE_METER_PER_KILOGRAM='squareMeterPerKilogram'
    SQUARE_MILE='squareMile'
    SQUARE_MILLIMETERS='squareMillimeters'
    SQUARE_YARD='squareYard'
    TESLA='tesla'
    TONNE_PER_HECTARE='tonnePerHectare'
    TONNE_PER_YEAR='tonnePerYear'
    TONNES_PER_YEAR='tonnesPerYear'
    VOLT='volt'
    WATT='watt'
    WATT_PER_METER_SQUARED='wattPerMeterSquared'
    WATT_PER_METER_SQUARED_PER_NANOMETER='wattPerMeterSquaredPerNanometer'
    WATT_PER_METER_SQUARED_PER_NANOMETER_PER_STERADIAN='wattPerMeterSquaredPerNanometerPerSteradian'
    WATT_PER_METER_SQUARED_PER_STERADIAN='wattPerMeterSquaredPerSteradian'
    WAVE_NUMBER='waveNumber'
    WEBER='weber'
    YARD_PER_SECOND='yardPerSecond'
    YARD_SQUARED='yardSquared'
    YARDS_PER_SECOND='yardsPerSecond'


class parentOccurencesType(str, Enum):
    _0='0'
    _1='1'


class parentOccurencesType58(str, Enum):
    _0='0'
    _1='1'


class parentOccurencesType63(str, Enum):
    _0='0'
    _1='1'


class permissionType(str, Enum):
    READ='read'
    WRITE='write'
    CHANGE_PERMISSION='changePermission'
    ALL='all'


class pointInPixelType(str, Enum):
    UPPER_LEFT='upperLeft'
    UPPER_RIGHT='upperRight'
    LOWER_RIGHT='lowerRight'
    LOWER_LEFT='lowerLeft'
    CENTER='center'


class pointInPixelType67(str, Enum):
    UPPER_LEFT='upperLeft'
    UPPER_RIGHT='upperRight'
    LOWER_RIGHT='lowerRight'
    LOWER_LEFT='lowerLeft'
    CENTER='center'


class rasterOriginType(str, Enum):
    UPPER_LEFT='Upper Left'
    LOWER_LEFT='Lower Left'
    UPPER_RIGHT='Upper Right'
    LOWER_RIGHT='Lower Right'


class relationshipTypeType(str, Enum):
    IDENTIFYING='identifying'
    NONIDENTIFYING='non-identifying'


class relationshipTypeType56(str, Enum):
    IDENTIFYING='identifying'
    NONIDENTIFYING='non-identifying'


class relationshipTypeType61(str, Enum):
    IDENTIFYING='identifying'
    NONIDENTIFYING='non-identifying'


class rowColumnOrientationType(str, Enum):
    COLUMN='column'
    ROW='row'


class eml(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('packageId', 'xs:string', 0, 0, {'use': 'required'}),
        MemberSpec_('system', 'res:SystemType', 0, 0, {'use': 'required'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('access', 'AccessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'type': 'AccessType'}, None),
        MemberSpec_('dataset', 'DatasetType', 0, 0, {'name': 'dataset', 'type': 'DatasetType'}, 1),
        MemberSpec_('citation', 'CitationType', 0, 0, {'name': 'citation', 'type': 'CitationType'}, 1),
        MemberSpec_('software', 'SoftwareType', 0, 0, {'name': 'software', 'type': 'SoftwareType'}, 1),
        MemberSpec_('protocol', 'ProtocolType', 0, 0, {'name': 'protocol', 'type': 'ProtocolType'}, 1),
        MemberSpec_('annotations', 'annotationsType', 0, 1, {'maxOccurs': '1', 'minOccurs': '0', 'name': 'annotations', 'type': 'annotationsType'}, None),
        MemberSpec_('additionalMetadata', 'additionalMetadataType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalMetadata', 'type': 'additionalMetadataType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, packageId=None, system=None, scope='system', lang=None, access=None, dataset=None, citation=None, software=None, protocol=None, annotations=None, additionalMetadata=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.packageId = _cast(None, packageId)
        self.packageId_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.access = access
        self.access_nsprefix_ = None
        self.dataset = dataset
        self.dataset_nsprefix_ = None
        self.citation = citation
        self.citation_nsprefix_ = None
        self.software = software
        self.software_nsprefix_ = None
        self.protocol = protocol
        self.protocol_nsprefix_ = None
        self.annotations = annotations
        self.annotations_nsprefix_ = None
        if additionalMetadata is None:
            self.additionalMetadata = []
        else:
            self.additionalMetadata = additionalMetadata
        self.additionalMetadata_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eml)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eml.subclass:
            return eml.subclass(*args_, **kwargs_)
        else:
            return eml(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_dataset(self):
        return self.dataset
    def set_dataset(self, dataset):
        self.dataset = dataset
    def get_citation(self):
        return self.citation
    def set_citation(self, citation):
        self.citation = citation
    def get_software(self):
        return self.software
    def set_software(self, software):
        self.software = software
    def get_protocol(self):
        return self.protocol
    def set_protocol(self, protocol):
        self.protocol = protocol
    def get_annotations(self):
        return self.annotations
    def set_annotations(self, annotations):
        self.annotations = annotations
    def get_additionalMetadata(self):
        return self.additionalMetadata
    def set_additionalMetadata(self, additionalMetadata):
        self.additionalMetadata = additionalMetadata
    def add_additionalMetadata(self, value):
        self.additionalMetadata.append(value)
    def insert_additionalMetadata_at(self, index, value):
        self.additionalMetadata.insert(index, value)
    def replace_additionalMetadata_at(self, index, value):
        self.additionalMetadata[index] = value
    def get_packageId(self):
        return self.packageId
    def set_packageId(self, packageId):
        self.packageId = packageId
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.access is not None or
            self.dataset is not None or
            self.citation is not None or
            self.software is not None or
            self.protocol is not None or
            self.annotations is not None or
            self.additionalMetadata
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:acc="https://eml.ecoinformatics.org/access-2.2.0"  xmlns:ds="https://eml.ecoinformatics.org/dataset-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0"  xmlns:sw="https://eml.ecoinformatics.org/software-2.2.0"  xmlns:pro="https://eml.ecoinformatics.org/protocol-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='eml', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('eml')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'eml':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='eml')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='eml', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='eml'):
        if self.packageId is not None and 'packageId' not in already_processed:
            already_processed.add('packageId')
            outfile.write(' packageId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.packageId), input_name='packageId')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "system" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:acc="https://eml.ecoinformatics.org/access-2.2.0"  xmlns:ds="https://eml.ecoinformatics.org/dataset-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0"  xmlns:sw="https://eml.ecoinformatics.org/software-2.2.0"  xmlns:pro="https://eml.ecoinformatics.org/protocol-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='eml', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_, namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.dataset is not None:
            namespaceprefix_ = self.dataset_nsprefix_ + ':' if (UseCapturedNS_ and self.dataset_nsprefix_) else ''
            self.dataset.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dataset', pretty_print=pretty_print)
        if self.citation is not None:
            namespaceprefix_ = self.citation_nsprefix_ + ':' if (UseCapturedNS_ and self.citation_nsprefix_) else ''
            self.citation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='citation', pretty_print=pretty_print)
        if self.software is not None:
            namespaceprefix_ = self.software_nsprefix_ + ':' if (UseCapturedNS_ and self.software_nsprefix_) else ''
            self.software.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software', pretty_print=pretty_print)
        if self.protocol is not None:
            namespaceprefix_ = self.protocol_nsprefix_ + ':' if (UseCapturedNS_ and self.protocol_nsprefix_) else ''
            self.protocol.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protocol', pretty_print=pretty_print)
        if self.annotations is not None:
            namespaceprefix_ = self.annotations_nsprefix_ + ':' if (UseCapturedNS_ and self.annotations_nsprefix_) else ''
            self.annotations.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotations', pretty_print=pretty_print)
        for additionalMetadata_ in self.additionalMetadata:
            namespaceprefix_ = self.additionalMetadata_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalMetadata_nsprefix_) else ''
            additionalMetadata_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalMetadata', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('packageId', node)
        if value is not None and 'packageId' not in already_processed:
            already_processed.add('packageId')
            self.packageId = value
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'access':
            obj_ = AccessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'dataset':
            obj_ = DatasetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dataset = obj_
            obj_.original_tagname_ = 'dataset'
        elif nodeName_ == 'citation':
            obj_ = CitationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.citation = obj_
            obj_.original_tagname_ = 'citation'
        elif nodeName_ == 'software':
            obj_ = SoftwareType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software = obj_
            obj_.original_tagname_ = 'software'
        elif nodeName_ == 'protocol':
            obj_ = ProtocolType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protocol = obj_
            obj_.original_tagname_ = 'protocol'
        elif nodeName_ == 'annotations':
            obj_ = annotationsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotations = obj_
            obj_.original_tagname_ = 'annotations'
        elif nodeName_ == 'additionalMetadata':
            obj_ = additionalMetadataType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalMetadata.append(obj_)
            obj_.original_tagname_ = 'additionalMetadata'
# end class eml


class moduleDocs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('moduleName', 'xs:string', 0, 0, {'form': 'qualified', 'name': 'moduleName', 'type': 'xs:string'}, None),
        MemberSpec_('moduleDescription', 'TextType', 0, 0, {'form': 'qualified', 'name': 'moduleDescription', 'type': 'TextType'}, None),
        MemberSpec_('recommendedUsage', 'xs:string', 0, 0, {'form': 'qualified', 'name': 'recommendedUsage', 'type': 'xs:string'}, None),
        MemberSpec_('standAlone', 'xs:string', 0, 0, {'form': 'qualified', 'name': 'standAlone', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, moduleName=None, moduleDescription=None, recommendedUsage=None, standAlone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.moduleName = moduleName
        self.moduleName_nsprefix_ = None
        self.moduleDescription = moduleDescription
        self.moduleDescription_nsprefix_ = None
        self.recommendedUsage = recommendedUsage
        self.recommendedUsage_nsprefix_ = None
        self.standAlone = standAlone
        self.standAlone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, moduleDocs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if moduleDocs.subclass:
            return moduleDocs.subclass(*args_, **kwargs_)
        else:
            return moduleDocs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_moduleName(self):
        return self.moduleName
    def set_moduleName(self, moduleName):
        self.moduleName = moduleName
    def get_moduleDescription(self):
        return self.moduleDescription
    def set_moduleDescription(self, moduleDescription):
        self.moduleDescription = moduleDescription
    def get_recommendedUsage(self):
        return self.recommendedUsage
    def set_recommendedUsage(self, recommendedUsage):
        self.recommendedUsage = recommendedUsage
    def get_standAlone(self):
        return self.standAlone
    def set_standAlone(self, standAlone):
        self.standAlone = standAlone
    def hasContent_(self):
        if (
            self.moduleName is not None or
            self.moduleDescription is not None or
            self.recommendedUsage is not None or
            self.standAlone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='moduleDocs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('moduleDocs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'moduleDocs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='moduleDocs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='moduleDocs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='moduleDocs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='moduleDocs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.moduleName is not None:
            namespaceprefix_ = self.moduleName_nsprefix_ + ':' if (UseCapturedNS_ and self.moduleName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smoduleName>%s</%smoduleName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.moduleName), input_name='moduleName')), namespaceprefix_ , eol_))
        if self.moduleDescription is not None:
            namespaceprefix_ = self.moduleDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.moduleDescription_nsprefix_) else ''
            self.moduleDescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='moduleDescription', pretty_print=pretty_print)
        if self.recommendedUsage is not None:
            namespaceprefix_ = self.recommendedUsage_nsprefix_ + ':' if (UseCapturedNS_ and self.recommendedUsage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecommendedUsage>%s</%srecommendedUsage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.recommendedUsage), input_name='recommendedUsage')), namespaceprefix_ , eol_))
        if self.standAlone is not None:
            namespaceprefix_ = self.standAlone_nsprefix_ + ':' if (UseCapturedNS_ and self.standAlone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstandAlone>%s</%sstandAlone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.standAlone), input_name='standAlone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'moduleName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'moduleName')
            value_ = self.gds_validate_string(value_, node, 'moduleName')
            self.moduleName = value_
            self.moduleName_nsprefix_ = child_.prefix
        elif nodeName_ == 'moduleDescription':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.moduleDescription = obj_
            obj_.original_tagname_ = 'moduleDescription'
        elif nodeName_ == 'recommendedUsage':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'recommendedUsage')
            value_ = self.gds_validate_string(value_, node, 'recommendedUsage')
            self.recommendedUsage = value_
            self.recommendedUsage_nsprefix_ = child_.prefix
        elif nodeName_ == 'standAlone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'standAlone')
            value_ = self.gds_validate_string(value_, node, 'standAlone')
            self.standAlone = value_
            self.standAlone_nsprefix_ = child_.prefix
# end class moduleDocs


class TextType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('section', 'SectionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'section', 'type': 'SectionType'}, 2),
        MemberSpec_('para', 'ParagraphType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'para', 'type': 'ParagraphType'}, 2),
        MemberSpec_('markdown', 'markdownType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'markdown', 'type': 'markdownType'}, 2),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, section=None, para=None, markdown=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        if section is None:
            self.section = []
        else:
            self.section = section
        self.section_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if markdown is None:
            self.markdown = []
        else:
            self.markdown = markdown
        self.markdown_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TextType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TextType.subclass:
            return TextType.subclass(*args_, **kwargs_)
        else:
            return TextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def add_section(self, value):
        self.section.append(value)
    def insert_section_at(self, index, value):
        self.section.insert(index, value)
    def replace_section_at(self, index, value):
        self.section[index] = value
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_markdown(self):
        return self.markdown
    def set_markdown(self, markdown):
        self.markdown = markdown
    def add_markdown(self, value):
        self.markdown.append(value)
    def insert_markdown_at(self, index, value):
        self.markdown.insert(index, value)
    def replace_markdown_at(self, index, value):
        self.markdown[index] = value
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.section or
            self.para or
            self.markdown or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TextType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TextType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TextType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TextType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            # self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TextType', pretty_print=pretty_print)
            # ajout fromsubclass_=True pour eviter la redondance de la balise !!! je ne sais trop pourquoi ???
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TextType', fromsubclass_=True, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TextType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TextType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for section_ in self.section:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            section_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for markdown_ in self.markdown:
            namespaceprefix_ = self.markdown_nsprefix_ + ':' if (UseCapturedNS_ and self.markdown_nsprefix_) else ''
            markdown_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='markdown', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'section':
            obj_ = SectionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'section', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_section'):
              self.add_section(obj_.value)
            elif hasattr(self, 'set_section'):
              self.set_section(obj_.value)
        elif nodeName_ == 'para':
            obj_ = ParagraphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'markdown':
            obj_ = markdownType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'markdown', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_markdown'):
              self.add_markdown(obj_.value)
            elif hasattr(self, 'set_markdown'):
              self.set_markdown(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class TextType


class ParagraphType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('value', 'i18nString', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'value', 'type': 'i18nString'}, 3),
        MemberSpec_('itemizedlist', 'ListType', 1, 1, {'name': 'itemizedlist', 'type': 'ListType'}, 3),
        MemberSpec_('orderedlist', 'ListType', 1, 1, {'name': 'orderedlist', 'type': 'ListType'}, 3),
        MemberSpec_('emphasis', 'emphasisType', 1, 1, {'name': 'emphasis', 'type': 'emphasisType'}, 3),
        MemberSpec_('subscript', 'SubSuperScriptType', 1, 1, {'name': 'subscript', 'type': 'SubSuperScriptType'}, 3),
        MemberSpec_('superscript', 'SubSuperScriptType', 1, 1, {'name': 'superscript', 'type': 'SubSuperScriptType'}, 3),
        MemberSpec_('literalLayout', 'literalLayoutType', 1, 1, {'name': 'literalLayout', 'type': 'literalLayoutType'}, 3),
        MemberSpec_('ulink', 'ulinkType', 1, 1, {'minOccurs': '0', 'name': 'ulink', 'type': 'ulinkType'}, 3),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, value=None, itemizedlist=None, orderedlist=None, emphasis=None, subscript=None, superscript=None, literalLayout=None, ulink=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.value_nsprefix_ = None
        if itemizedlist is None:
            self.itemizedlist = []
        else:
            self.itemizedlist = itemizedlist
        self.itemizedlist_nsprefix_ = None
        if orderedlist is None:
            self.orderedlist = []
        else:
            self.orderedlist = orderedlist
        self.orderedlist_nsprefix_ = None
        if emphasis is None:
            self.emphasis = []
        else:
            self.emphasis = emphasis
        self.emphasis_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        if literalLayout is None:
            self.literalLayout = []
        else:
            self.literalLayout = literalLayout
        self.literalLayout_nsprefix_ = None
        if ulink is None:
            self.ulink = []
        else:
            self.ulink = ulink
        self.ulink_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParagraphType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParagraphType.subclass:
            return ParagraphType.subclass(*args_, **kwargs_)
        else:
            return ParagraphType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def add_value(self, value):
        self.value.append(value)
    def insert_value_at(self, index, value):
        self.value.insert(index, value)
    def replace_value_at(self, index, value):
        self.value[index] = value
    def get_itemizedlist(self):
        return self.itemizedlist
    def set_itemizedlist(self, itemizedlist):
        self.itemizedlist = itemizedlist
    def add_itemizedlist(self, value):
        self.itemizedlist.append(value)
    def insert_itemizedlist_at(self, index, value):
        self.itemizedlist.insert(index, value)
    def replace_itemizedlist_at(self, index, value):
        self.itemizedlist[index] = value
    def get_orderedlist(self):
        return self.orderedlist
    def set_orderedlist(self, orderedlist):
        self.orderedlist = orderedlist
    def add_orderedlist(self, value):
        self.orderedlist.append(value)
    def insert_orderedlist_at(self, index, value):
        self.orderedlist.insert(index, value)
    def replace_orderedlist_at(self, index, value):
        self.orderedlist[index] = value
    def get_emphasis(self):
        return self.emphasis
    def set_emphasis(self, emphasis):
        self.emphasis = emphasis
    def add_emphasis(self, value):
        self.emphasis.append(value)
    def insert_emphasis_at(self, index, value):
        self.emphasis.insert(index, value)
    def replace_emphasis_at(self, index, value):
        self.emphasis[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_literalLayout(self):
        return self.literalLayout
    def set_literalLayout(self, literalLayout):
        self.literalLayout = literalLayout
    def add_literalLayout(self, value):
        self.literalLayout.append(value)
    def insert_literalLayout_at(self, index, value):
        self.literalLayout.insert(index, value)
    def replace_literalLayout_at(self, index, value):
        self.literalLayout[index] = value
    def get_ulink(self):
        return self.ulink
    def set_ulink(self, ulink):
        self.ulink = ulink
    def add_ulink(self, value):
        self.ulink.append(value)
    def insert_ulink_at(self, index, value):
        self.ulink.insert(index, value)
    def replace_ulink_at(self, index, value):
        self.ulink[index] = value
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.value or
            self.itemizedlist or
            self.orderedlist or
            self.emphasis or
            self.subscript or
            self.superscript or
            self.literalLayout or
            self.ulink or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ParagraphType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParagraphType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParagraphType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParagraphType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParagraphType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParagraphType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ParagraphType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            value_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        for itemizedlist_ in self.itemizedlist:
            namespaceprefix_ = self.itemizedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.itemizedlist_nsprefix_) else ''
            itemizedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='itemizedlist', pretty_print=pretty_print)
        for orderedlist_ in self.orderedlist:
            namespaceprefix_ = self.orderedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.orderedlist_nsprefix_) else ''
            orderedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='orderedlist', pretty_print=pretty_print)
        for emphasis_ in self.emphasis:
            namespaceprefix_ = self.emphasis_nsprefix_ + ':' if (UseCapturedNS_ and self.emphasis_nsprefix_) else ''
            emphasis_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emphasis', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
        for literalLayout_ in self.literalLayout:
            namespaceprefix_ = self.literalLayout_nsprefix_ + ':' if (UseCapturedNS_ and self.literalLayout_nsprefix_) else ''
            literalLayout_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='literalLayout', pretty_print=pretty_print)
        for ulink_ in self.ulink:
            namespaceprefix_ = self.ulink_nsprefix_ + ':' if (UseCapturedNS_ and self.ulink_nsprefix_) else ''
            ulink_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ulink', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'value':
            obj_ = i18nString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'value', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_value'):
              self.add_value(obj_.value)
            elif hasattr(self, 'set_value'):
              self.set_value(obj_.value)
        elif nodeName_ == 'itemizedlist':
            obj_ = ListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'itemizedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_itemizedlist'):
              self.add_itemizedlist(obj_.value)
            elif hasattr(self, 'set_itemizedlist'):
              self.set_itemizedlist(obj_.value)
        elif nodeName_ == 'orderedlist':
            obj_ = ListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'orderedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_orderedlist'):
              self.add_orderedlist(obj_.value)
            elif hasattr(self, 'set_orderedlist'):
              self.set_orderedlist(obj_.value)
        elif nodeName_ == 'emphasis':
            obj_ = emphasisType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'emphasis', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_emphasis'):
              self.add_emphasis(obj_.value)
            elif hasattr(self, 'set_emphasis'):
              self.set_emphasis(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = SubSuperScriptType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = SubSuperScriptType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        elif nodeName_ == 'literalLayout':
            obj_ = literalLayoutType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'literalLayout', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_literalLayout'):
              self.add_literalLayout(obj_.value)
            elif hasattr(self, 'set_literalLayout'):
              self.set_literalLayout(obj_.value)
        elif nodeName_ == 'ulink':
            obj_ = ulinkType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ulink', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ulink'):
              self.add_ulink(obj_.value)
            elif hasattr(self, 'set_ulink'):
              self.set_ulink(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class ParagraphType


class SectionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('title', 'i18nString', 0, 1, {'minOccurs': '0', 'name': 'title', 'type': 'i18nString'}, None),
        MemberSpec_('para', 'ParagraphType', 1, 0, {'name': 'para', 'type': 'ParagraphType'}, 4),
        MemberSpec_('section', 'SectionType', 1, 0, {'name': 'section', 'type': 'SectionType'}, 4),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, title=None, para=None, section=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if section is None:
            self.section = []
        else:
            self.section = section
        self.section_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SectionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SectionType.subclass:
            return SectionType.subclass(*args_, **kwargs_)
        else:
            return SectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def add_section(self, value):
        self.section.append(value)
    def insert_section_at(self, index, value):
        self.section.insert(index, value)
    def replace_section_at(self, index, value):
        self.section[index] = value
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.section
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SectionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SectionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SectionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SectionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SectionType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SectionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for section_ in self.section:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            section_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            obj_ = i18nString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'para':
            obj_ = ParagraphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.para.append(obj_)
            obj_.original_tagname_ = 'para'
        elif nodeName_ == 'section':
            obj_ = SectionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.section.append(obj_)
            obj_.original_tagname_ = 'section'
# end class SectionType


class ListType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('listitem', 'listitemType', 1, 0, {'maxOccurs': 'unbounded', 'minOccurs': '1', 'name': 'listitem', 'type': 'listitemType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, listitem=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if listitem is None:
            self.listitem = []
        else:
            self.listitem = listitem
        self.listitem_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListType.subclass:
            return ListType.subclass(*args_, **kwargs_)
        else:
            return ListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_listitem(self):
        return self.listitem
    def set_listitem(self, listitem):
        self.listitem = listitem
    def add_listitem(self, value):
        self.listitem.append(value)
    def insert_listitem_at(self, index, value):
        self.listitem.insert(index, value)
    def replace_listitem_at(self, index, value):
        self.listitem[index] = value
    def hasContent_(self):
        if (
            self.listitem
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ListType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for listitem_ in self.listitem:
            namespaceprefix_ = self.listitem_nsprefix_ + ':' if (UseCapturedNS_ and self.listitem_nsprefix_) else ''
            listitem_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='listitem', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'listitem':
            obj_ = listitemType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.listitem.append(obj_)
            obj_.original_tagname_ = 'listitem'
# end class ListType


class SubSuperScriptType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('value', 'i18nString', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'value', 'type': 'i18nString'}, 5),
        MemberSpec_('subscript', 'SubSuperScriptType', 1, 1, {'name': 'subscript', 'type': 'SubSuperScriptType'}, 5),
        MemberSpec_('superscript', 'SubSuperScriptType', 1, 1, {'name': 'superscript', 'type': 'SubSuperScriptType'}, 5),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, value=None, subscript=None, superscript=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.value_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SubSuperScriptType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SubSuperScriptType.subclass:
            return SubSuperScriptType.subclass(*args_, **kwargs_)
        else:
            return SubSuperScriptType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def add_value(self, value):
        self.value.append(value)
    def insert_value_at(self, index, value):
        self.value.insert(index, value)
    def replace_value_at(self, index, value):
        self.value[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.value or
            self.subscript or
            self.superscript or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SubSuperScriptType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SubSuperScriptType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SubSuperScriptType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SubSuperScriptType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SubSuperScriptType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SubSuperScriptType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SubSuperScriptType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            value_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'value':
            obj_ = i18nString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'value', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_value'):
              self.add_value(obj_.value)
            elif hasattr(self, 'set_value'):
              self.set_value(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = SubSuperScriptType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = SubSuperScriptType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class SubSuperScriptType


class i18nString(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, i18nString)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if i18nString.subclass:
            return i18nString.subclass(*args_, **kwargs_)
        else:
            return i18nString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='i18nString', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('i18nString')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'i18nString':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='i18nString')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='i18nString', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='i18nString'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='i18nString', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class i18nString


class DistributionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('online', 'OnlineType', 0, 0, {'name': 'online', 'type': 'OnlineType'}, 7),
        MemberSpec_('offline', 'OfflineType', 0, 0, {'name': 'offline', 'type': 'OfflineType'}, 7),
        MemberSpec_('inline', 'InlineType', 0, 0, {'name': 'inline', 'type': 'InlineType'}, 7),
        MemberSpec_('references', 'referencesType2', 0, 0, {'name': 'references', 'type': 'referencesType2'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', online=None, offline=None, inline=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.online = online
        self.online_nsprefix_ = None
        self.offline = offline
        self.offline_nsprefix_ = None
        self.inline = inline
        self.inline_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DistributionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistributionType.subclass:
            return DistributionType.subclass(*args_, **kwargs_)
        else:
            return DistributionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_online(self):
        return self.online
    def set_online(self, online):
        self.online = online
    def get_offline(self):
        return self.offline
    def set_offline(self, offline):
        self.offline = offline
    def get_inline(self):
        return self.inline
    def set_inline(self, inline):
        self.inline = inline
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.online is not None or
            self.offline is not None or
            self.inline is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='DistributionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DistributionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DistributionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DistributionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DistributionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DistributionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='DistributionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.online is not None:
            namespaceprefix_ = self.online_nsprefix_ + ':' if (UseCapturedNS_ and self.online_nsprefix_) else ''
            self.online.export(outfile, level, namespaceprefix_, namespacedef_='', name_='online', pretty_print=pretty_print)
        if self.offline is not None:
            namespaceprefix_ = self.offline_nsprefix_ + ':' if (UseCapturedNS_ and self.offline_nsprefix_) else ''
            self.offline.export(outfile, level, namespaceprefix_, namespacedef_='', name_='offline', pretty_print=pretty_print)
        if self.inline is not None:
            namespaceprefix_ = self.inline_nsprefix_ + ':' if (UseCapturedNS_ and self.inline_nsprefix_) else ''
            self.inline.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inline', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'online':
            obj_ = OnlineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.online = obj_
            obj_.original_tagname_ = 'online'
        elif nodeName_ == 'offline':
            obj_ = OfflineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.offline = obj_
            obj_.original_tagname_ = 'offline'
        elif nodeName_ == 'inline':
            obj_ = InlineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inline = obj_
            obj_.original_tagname_ = 'inline'
        elif nodeName_ == 'references':
            obj_ = referencesType2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class DistributionType


class ConnectionDefinitionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('schemeName', 'schemeNameType', 0, 0, {'name': 'schemeName', 'type': 'schemeNameType'}, 8),
        MemberSpec_('description', 'TextType', 0, 0, {'name': 'description', 'type': 'TextType'}, 8),
        MemberSpec_('parameterDefinition', 'parameterDefinitionType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'parameterDefinition', 'type': 'parameterDefinitionType'}, 8),
        MemberSpec_('references', 'referencesType3', 0, 0, {'name': 'references', 'type': 'referencesType3'}, 8),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', schemeName=None, description=None, parameterDefinition=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.schemeName = schemeName
        self.schemeName_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        if parameterDefinition is None:
            self.parameterDefinition = []
        else:
            self.parameterDefinition = parameterDefinition
        self.parameterDefinition_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConnectionDefinitionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConnectionDefinitionType.subclass:
            return ConnectionDefinitionType.subclass(*args_, **kwargs_)
        else:
            return ConnectionDefinitionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_schemeName(self):
        return self.schemeName
    def set_schemeName(self, schemeName):
        self.schemeName = schemeName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_parameterDefinition(self):
        return self.parameterDefinition
    def set_parameterDefinition(self, parameterDefinition):
        self.parameterDefinition = parameterDefinition
    def add_parameterDefinition(self, value):
        self.parameterDefinition.append(value)
    def insert_parameterDefinition_at(self, index, value):
        self.parameterDefinition.insert(index, value)
    def replace_parameterDefinition_at(self, index, value):
        self.parameterDefinition[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.schemeName is not None or
            self.description is not None or
            self.parameterDefinition or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='ConnectionDefinitionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConnectionDefinitionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ConnectionDefinitionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConnectionDefinitionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ConnectionDefinitionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ConnectionDefinitionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='ConnectionDefinitionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.schemeName is not None:
            namespaceprefix_ = self.schemeName_nsprefix_ + ':' if (UseCapturedNS_ and self.schemeName_nsprefix_) else ''
            self.schemeName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='schemeName', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            self.description.export(outfile, level, namespaceprefix_, namespacedef_='', name_='description', pretty_print=pretty_print)
        for parameterDefinition_ in self.parameterDefinition:
            namespaceprefix_ = self.parameterDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.parameterDefinition_nsprefix_) else ''
            parameterDefinition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parameterDefinition', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'schemeName':
            obj_ = schemeNameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.schemeName = obj_
            obj_.original_tagname_ = 'schemeName'
        elif nodeName_ == 'description':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.description = obj_
            obj_.original_tagname_ = 'description'
        elif nodeName_ == 'parameterDefinition':
            obj_ = parameterDefinitionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameterDefinition.append(obj_)
            obj_.original_tagname_ = 'parameterDefinition'
        elif nodeName_ == 'references':
            obj_ = referencesType3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class ConnectionDefinitionType


class InlineType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('__ANY__', '__ANY__', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'processContents': 'lax'}, None),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InlineType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InlineType.subclass:
            return InlineType.subclass(*args_, **kwargs_)
        else:
            return InlineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='InlineType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InlineType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InlineType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InlineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InlineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InlineType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='InlineType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(obj_)
                outfile.write('\n')
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == '':
            obj_ = __ANY__.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, '', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_'):
              self.add_(obj_.value)
            elif hasattr(self, 'set_'):
              self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class InlineType


class OfflineType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('mediumName', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'mediumName', 'type': 'xs:string'}, None),
        MemberSpec_('mediumDensity', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'mediumDensity', 'type': 'xs:string'}, None),
        MemberSpec_('mediumDensityUnits', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'mediumDensityUnits', 'type': 'xs:string'}, None),
        MemberSpec_('mediumVolume', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'mediumVolume', 'type': 'xs:string'}, None),
        MemberSpec_('mediumFormat', ['NonEmptyStringType', 'xs:string'], 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'mediumFormat', 'type': 'xs:string'}, None),
        MemberSpec_('mediumNote', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'mediumNote', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, mediumName=None, mediumDensity=None, mediumDensityUnits=None, mediumVolume=None, mediumFormat=None, mediumNote=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.mediumName = mediumName
        self.validate_NonEmptyStringType(self.mediumName)
        self.mediumName_nsprefix_ = None
        self.mediumDensity = mediumDensity
        self.validate_NonEmptyStringType(self.mediumDensity)
        self.mediumDensity_nsprefix_ = None
        self.mediumDensityUnits = mediumDensityUnits
        self.validate_NonEmptyStringType(self.mediumDensityUnits)
        self.mediumDensityUnits_nsprefix_ = None
        self.mediumVolume = mediumVolume
        self.validate_NonEmptyStringType(self.mediumVolume)
        self.mediumVolume_nsprefix_ = None
        if mediumFormat is None:
            self.mediumFormat = []
        else:
            self.mediumFormat = mediumFormat
        self.mediumFormat_nsprefix_ = None
        self.mediumNote = mediumNote
        self.validate_NonEmptyStringType(self.mediumNote)
        self.mediumNote_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OfflineType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OfflineType.subclass:
            return OfflineType.subclass(*args_, **kwargs_)
        else:
            return OfflineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_mediumName(self):
        return self.mediumName
    def set_mediumName(self, mediumName):
        self.mediumName = mediumName
    def get_mediumDensity(self):
        return self.mediumDensity
    def set_mediumDensity(self, mediumDensity):
        self.mediumDensity = mediumDensity
    def get_mediumDensityUnits(self):
        return self.mediumDensityUnits
    def set_mediumDensityUnits(self, mediumDensityUnits):
        self.mediumDensityUnits = mediumDensityUnits
    def get_mediumVolume(self):
        return self.mediumVolume
    def set_mediumVolume(self, mediumVolume):
        self.mediumVolume = mediumVolume
    def get_mediumFormat(self):
        return self.mediumFormat
    def set_mediumFormat(self, mediumFormat):
        self.mediumFormat = mediumFormat
    def add_mediumFormat(self, value):
        self.mediumFormat.append(value)
    def insert_mediumFormat_at(self, index, value):
        self.mediumFormat.insert(index, value)
    def replace_mediumFormat_at(self, index, value):
        self.mediumFormat[index] = value
    def get_mediumNote(self):
        return self.mediumNote
    def set_mediumNote(self, mediumNote):
        self.mediumNote = mediumNote
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.mediumName is not None or
            self.mediumDensity is not None or
            self.mediumDensityUnits is not None or
            self.mediumVolume is not None or
            self.mediumFormat or
            self.mediumNote is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='OfflineType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OfflineType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OfflineType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OfflineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OfflineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OfflineType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='OfflineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mediumName is not None:
            namespaceprefix_ = self.mediumName_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumName>%s</%smediumName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mediumName), input_name='mediumName')), namespaceprefix_ , eol_))
        if self.mediumDensity is not None:
            namespaceprefix_ = self.mediumDensity_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumDensity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumDensity>%s</%smediumDensity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mediumDensity), input_name='mediumDensity')), namespaceprefix_ , eol_))
        if self.mediumDensityUnits is not None:
            namespaceprefix_ = self.mediumDensityUnits_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumDensityUnits_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumDensityUnits>%s</%smediumDensityUnits>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mediumDensityUnits), input_name='mediumDensityUnits')), namespaceprefix_ , eol_))
        if self.mediumVolume is not None:
            namespaceprefix_ = self.mediumVolume_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumVolume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumVolume>%s</%smediumVolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mediumVolume), input_name='mediumVolume')), namespaceprefix_ , eol_))
        for mediumFormat_ in self.mediumFormat:
            namespaceprefix_ = self.mediumFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumFormat>%s</%smediumFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(mediumFormat_), input_name='mediumFormat')), namespaceprefix_ , eol_))
        if self.mediumNote is not None:
            namespaceprefix_ = self.mediumNote_nsprefix_ + ':' if (UseCapturedNS_ and self.mediumNote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smediumNote>%s</%smediumNote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mediumNote), input_name='mediumNote')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'mediumName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumName')
            value_ = self.gds_validate_string(value_, node, 'mediumName')
            self.mediumName = value_
            self.mediumName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumName)
        elif nodeName_ == 'mediumDensity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumDensity')
            value_ = self.gds_validate_string(value_, node, 'mediumDensity')
            self.mediumDensity = value_
            self.mediumDensity_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumDensity)
        elif nodeName_ == 'mediumDensityUnits':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumDensityUnits')
            value_ = self.gds_validate_string(value_, node, 'mediumDensityUnits')
            self.mediumDensityUnits = value_
            self.mediumDensityUnits_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumDensityUnits)
        elif nodeName_ == 'mediumVolume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumVolume')
            value_ = self.gds_validate_string(value_, node, 'mediumVolume')
            self.mediumVolume = value_
            self.mediumVolume_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumVolume)
        elif nodeName_ == 'mediumFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumFormat')
            value_ = self.gds_validate_string(value_, node, 'mediumFormat')
            self.mediumFormat.append(value_)
            self.mediumFormat_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumFormat[-1])
        elif nodeName_ == 'mediumNote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mediumNote')
            value_ = self.gds_validate_string(value_, node, 'mediumNote')
            self.mediumNote = value_
            self.mediumNote_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.mediumNote)
# end class OfflineType


class OnlineType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('onlineDescription', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'onlineDescription', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('url', 'UrlType', 0, 0, {'name': 'url', 'type': 'UrlType'}, 9),
        MemberSpec_('connection', 'ConnectionType', 0, 0, {'name': 'connection', 'type': 'ConnectionType'}, 9),
        MemberSpec_('connectionDefinition', 'ConnectionDefinitionType', 0, 0, {'name': 'connectionDefinition', 'type': 'ConnectionDefinitionType'}, 9),
    ]
    subclass = None
    superclass = None
    def __init__(self, onlineDescription=None, url=None, connection=None, connectionDefinition=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.onlineDescription = onlineDescription
        self.onlineDescription_nsprefix_ = None
        self.url = url
        self.url_nsprefix_ = None
        self.connection = connection
        self.connection_nsprefix_ = None
        self.connectionDefinition = connectionDefinition
        self.connectionDefinition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnlineType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnlineType.subclass:
            return OnlineType.subclass(*args_, **kwargs_)
        else:
            return OnlineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_onlineDescription(self):
        return self.onlineDescription
    def set_onlineDescription(self, onlineDescription):
        self.onlineDescription = onlineDescription
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_connection(self):
        return self.connection
    def set_connection(self, connection):
        self.connection = connection
    def get_connectionDefinition(self):
        return self.connectionDefinition
    def set_connectionDefinition(self, connectionDefinition):
        self.connectionDefinition = connectionDefinition
    def hasContent_(self):
        if (
            self.onlineDescription is not None or
            self.url is not None or
            self.connection is not None or
            self.connectionDefinition is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='OnlineType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OnlineType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OnlineType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OnlineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OnlineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OnlineType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='OnlineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.onlineDescription is not None:
            namespaceprefix_ = self.onlineDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.onlineDescription_nsprefix_) else ''
            self.onlineDescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='onlineDescription', pretty_print=pretty_print)
        if self.url is not None:
            namespaceprefix_ = self.url_nsprefix_ + ':' if (UseCapturedNS_ and self.url_nsprefix_) else ''
            self.url.export(outfile, level, namespaceprefix_, namespacedef_='', name_='url', pretty_print=pretty_print)
        if self.connection is not None:
            namespaceprefix_ = self.connection_nsprefix_ + ':' if (UseCapturedNS_ and self.connection_nsprefix_) else ''
            self.connection.export(outfile, level, namespaceprefix_, namespacedef_='', name_='connection', pretty_print=pretty_print)
        if self.connectionDefinition is not None:
            namespaceprefix_ = self.connectionDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.connectionDefinition_nsprefix_) else ''
            self.connectionDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='connectionDefinition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'onlineDescription':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.onlineDescription = obj_
            obj_.original_tagname_ = 'onlineDescription'
        elif nodeName_ == 'url':
            obj_ = UrlType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.url = obj_
            obj_.original_tagname_ = 'url'
        elif nodeName_ == 'connection':
            obj_ = ConnectionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.connection = obj_
            obj_.original_tagname_ = 'connection'
        elif nodeName_ == 'connectionDefinition':
            obj_ = ConnectionDefinitionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.connectionDefinition = obj_
            obj_.original_tagname_ = 'connectionDefinition'
# end class OnlineType


class UrlType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('function', 'FunctionType', 0, 1, {'use': 'optional'}),
        MemberSpec_('valueOf_', 'xs:anyURI', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, function='download', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.function = _cast(None, function)
        self.function_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UrlType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UrlType.subclass:
            return UrlType.subclass(*args_, **kwargs_)
        else:
            return UrlType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_function(self):
        return self.function
    def set_function(self, function):
        self.function = function
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_FunctionType(self, value):
        # Validate type FunctionType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['download', 'information']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FunctionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='UrlType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UrlType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UrlType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UrlType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UrlType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UrlType'):
        if self.function != "download" and 'function' not in already_processed:
            already_processed.add('function')
            outfile.write(' function=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.function), input_name='function')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='UrlType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('function', node)
        if value is not None and 'function' not in already_processed:
            already_processed.add('function')
            self.function = value
            self.validate_FunctionType(self.function)    # validate type FunctionType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class UrlType


class ConnectionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('connectionDefinition', 'ConnectionDefinitionType', 0, 0, {'name': 'connectionDefinition', 'type': 'ConnectionDefinitionType'}, 10),
        MemberSpec_('parameter', 'parameterType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'parameter', 'type': 'parameterType'}, 10),
        MemberSpec_('references', 'referencesType4', 0, 0, {'name': 'references', 'type': 'referencesType4'}, 10),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', connectionDefinition=None, parameter=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.connectionDefinition = connectionDefinition
        self.connectionDefinition_nsprefix_ = None
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
        self.parameter_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConnectionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConnectionType.subclass:
            return ConnectionType.subclass(*args_, **kwargs_)
        else:
            return ConnectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_connectionDefinition(self):
        return self.connectionDefinition
    def set_connectionDefinition(self, connectionDefinition):
        self.connectionDefinition = connectionDefinition
    def get_parameter(self):
        return self.parameter
    def set_parameter(self, parameter):
        self.parameter = parameter
    def add_parameter(self, value):
        self.parameter.append(value)
    def insert_parameter_at(self, index, value):
        self.parameter.insert(index, value)
    def replace_parameter_at(self, index, value):
        self.parameter[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.connectionDefinition is not None or
            self.parameter or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ConnectionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConnectionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ConnectionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConnectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ConnectionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ConnectionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ConnectionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.connectionDefinition is not None:
            namespaceprefix_ = self.connectionDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.connectionDefinition_nsprefix_) else ''
            self.connectionDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='connectionDefinition', pretty_print=pretty_print)
        for parameter_ in self.parameter:
            namespaceprefix_ = self.parameter_nsprefix_ + ':' if (UseCapturedNS_ and self.parameter_nsprefix_) else ''
            parameter_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parameter', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'connectionDefinition':
            obj_ = ConnectionDefinitionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.connectionDefinition = obj_
            obj_.original_tagname_ = 'connectionDefinition'
        elif nodeName_ == 'parameter':
            obj_ = parameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameter.append(obj_)
            obj_.original_tagname_ = 'parameter'
        elif nodeName_ == 'references':
            obj_ = referencesType4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class ConnectionType


class i18nNonEmptyStringType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('lang', 'xs:string', 0, 1, {'use': 'optional'}),
        MemberSpec_('value', 'valueType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'value', 'type': 'valueType'}, None),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lang=None, value=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.value_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, i18nNonEmptyStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if i18nNonEmptyStringType.subclass:
            return i18nNonEmptyStringType.subclass(*args_, **kwargs_)
        else:
            return i18nNonEmptyStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def add_value(self, value):
        self.value.append(value)
    def insert_value_at(self, index, value):
        self.value.insert(index, value)
    def replace_value_at(self, index, value):
        self.value[index] = value
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.value or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='i18nNonEmptyStringType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('i18nNonEmptyStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'i18nNonEmptyStringType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='i18nNonEmptyStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='i18nNonEmptyStringType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='i18nNonEmptyStringType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='i18nNonEmptyStringType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            value_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'value':
            obj_ = valueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'value', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_value'):
              self.add_value(obj_.value)
            elif hasattr(self, 'set_value'):
              self.set_value(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class i18nNonEmptyStringType


class LicenseType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('licenseName', ['NonEmptyStringType', 'xs:string'], 0, 0, {'minOccurs': '1', 'name': 'licenseName', 'type': 'xs:string'}, None),
        MemberSpec_('url', 'xs:anyURI', 0, 1, {'minOccurs': '0', 'name': 'url', 'type': 'xs:anyURI'}, None),
        MemberSpec_('identifier', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'identifier', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, licenseName=None, url=None, identifier=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.licenseName = licenseName
        self.validate_NonEmptyStringType(self.licenseName)
        self.licenseName_nsprefix_ = None
        self.url = url
        self.url_nsprefix_ = None
        self.identifier = identifier
        self.validate_NonEmptyStringType(self.identifier)
        self.identifier_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LicenseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LicenseType.subclass:
            return LicenseType.subclass(*args_, **kwargs_)
        else:
            return LicenseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_licenseName(self):
        return self.licenseName
    def set_licenseName(self, licenseName):
        self.licenseName = licenseName
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_identifier(self):
        return self.identifier
    def set_identifier(self, identifier):
        self.identifier = identifier
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.licenseName is not None or
            self.url is not None or
            self.identifier is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='LicenseType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LicenseType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LicenseType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LicenseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LicenseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LicenseType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='LicenseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.licenseName is not None:
            namespaceprefix_ = self.licenseName_nsprefix_ + ':' if (UseCapturedNS_ and self.licenseName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseName>%s</%slicenseName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.licenseName), input_name='licenseName')), namespaceprefix_ , eol_))
        if self.url is not None:
            namespaceprefix_ = self.url_nsprefix_ + ':' if (UseCapturedNS_ and self.url_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%surl>%s</%surl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.url), input_name='url')), namespaceprefix_ , eol_))
        if self.identifier is not None:
            namespaceprefix_ = self.identifier_nsprefix_ + ':' if (UseCapturedNS_ and self.identifier_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidentifier>%s</%sidentifier>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.identifier), input_name='identifier')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'licenseName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'licenseName')
            value_ = self.gds_validate_string(value_, node, 'licenseName')
            self.licenseName = value_
            self.licenseName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.licenseName)
        elif nodeName_ == 'url':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'url')
            value_ = self.gds_validate_string(value_, node, 'url')
            self.url = value_
            self.url_nsprefix_ = child_.prefix
        elif nodeName_ == 'identifier':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'identifier')
            value_ = self.gds_validate_string(value_, node, 'identifier')
            self.identifier = value_
            self.identifier_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.identifier)
# end class LicenseType


class ResponsibleParty(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('individualName', 'Person', 1, 0, {'name': 'individualName', 'type': 'Person'}, 12),
        MemberSpec_('organizationName', 'i18nNonEmptyStringType', 1, 0, {'name': 'organizationName', 'type': 'i18nNonEmptyStringType'}, 12),
        MemberSpec_('positionName', 'i18nNonEmptyStringType', 1, 0, {'name': 'positionName', 'type': 'i18nNonEmptyStringType'}, 12),
        MemberSpec_('address', 'Address', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'address', 'type': 'Address'}, None),
        MemberSpec_('phone', 'phoneType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'phone', 'type': 'phoneType'}, None),
        MemberSpec_('electronicMailAddress', 'i18nNonEmptyStringType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'electronicMailAddress', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('onlineUrl', 'xs:anyURI', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'onlineUrl', 'type': 'xs:anyURI'}, None),
        MemberSpec_('userId', 'userIdType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'userId', 'type': 'userIdType'}, None),
        MemberSpec_('references', 'referencesType5', 0, 0, {'name': 'references', 'type': 'referencesType5'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', individualName=None, organizationName=None, positionName=None, address=None, phone=None, electronicMailAddress=None, onlineUrl=None, userId=None, references=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if individualName is None:
            self.individualName = []
        else:
            self.individualName = individualName
        self.individualName_nsprefix_ = None
        if organizationName is None:
            self.organizationName = []
        else:
            self.organizationName = organizationName
        self.organizationName_nsprefix_ = None
        if positionName is None:
            self.positionName = []
        else:
            self.positionName = positionName
        self.positionName_nsprefix_ = None
        if address is None:
            self.address = []
        else:
            self.address = address
        self.address_nsprefix_ = None
        if phone is None:
            self.phone = []
        else:
            self.phone = phone
        self.phone_nsprefix_ = None
        if electronicMailAddress is None:
            self.electronicMailAddress = []
        else:
            self.electronicMailAddress = electronicMailAddress
        self.electronicMailAddress_nsprefix_ = None
        if onlineUrl is None:
            self.onlineUrl = []
        else:
            self.onlineUrl = onlineUrl
        self.onlineUrl_nsprefix_ = None
        if userId is None:
            self.userId = []
        else:
            self.userId = userId
        self.userId_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponsibleParty)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponsibleParty.subclass:
            return ResponsibleParty.subclass(*args_, **kwargs_)
        else:
            return ResponsibleParty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_individualName(self):
        return self.individualName
    def set_individualName(self, individualName):
        self.individualName = individualName
    def add_individualName(self, value):
        self.individualName.append(value)
    def insert_individualName_at(self, index, value):
        self.individualName.insert(index, value)
    def replace_individualName_at(self, index, value):
        self.individualName[index] = value
    def get_organizationName(self):
        return self.organizationName
    def set_organizationName(self, organizationName):
        self.organizationName = organizationName
    def add_organizationName(self, value):
        self.organizationName.append(value)
    def insert_organizationName_at(self, index, value):
        self.organizationName.insert(index, value)
    def replace_organizationName_at(self, index, value):
        self.organizationName[index] = value
    def get_positionName(self):
        return self.positionName
    def set_positionName(self, positionName):
        self.positionName = positionName
    def add_positionName(self, value):
        self.positionName.append(value)
    def insert_positionName_at(self, index, value):
        self.positionName.insert(index, value)
    def replace_positionName_at(self, index, value):
        self.positionName[index] = value
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def add_address(self, value):
        self.address.append(value)
    def insert_address_at(self, index, value):
        self.address.insert(index, value)
    def replace_address_at(self, index, value):
        self.address[index] = value
    def get_phone(self):
        return self.phone
    def set_phone(self, phone):
        self.phone = phone
    def add_phone(self, value):
        self.phone.append(value)
    def insert_phone_at(self, index, value):
        self.phone.insert(index, value)
    def replace_phone_at(self, index, value):
        self.phone[index] = value
    def get_electronicMailAddress(self):
        return self.electronicMailAddress
    def set_electronicMailAddress(self, electronicMailAddress):
        self.electronicMailAddress = electronicMailAddress
    def add_electronicMailAddress(self, value):
        self.electronicMailAddress.append(value)
    def insert_electronicMailAddress_at(self, index, value):
        self.electronicMailAddress.insert(index, value)
    def replace_electronicMailAddress_at(self, index, value):
        self.electronicMailAddress[index] = value
    def get_onlineUrl(self):
        return self.onlineUrl
    def set_onlineUrl(self, onlineUrl):
        self.onlineUrl = onlineUrl
    def add_onlineUrl(self, value):
        self.onlineUrl.append(value)
    def insert_onlineUrl_at(self, index, value):
        self.onlineUrl.insert(index, value)
    def replace_onlineUrl_at(self, index, value):
        self.onlineUrl[index] = value
    def get_userId(self):
        return self.userId
    def set_userId(self, userId):
        self.userId = userId
    def add_userId(self, value):
        self.userId.append(value)
    def insert_userId_at(self, index, value):
        self.userId.insert(index, value)
    def replace_userId_at(self, index, value):
        self.userId[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.individualName or
            self.organizationName or
            self.positionName or
            self.address or
            self.phone or
            self.electronicMailAddress or
            self.onlineUrl or
            self.userId or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='ResponsibleParty', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponsibleParty')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponsibleParty':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponsibleParty')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponsibleParty', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponsibleParty'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='ResponsibleParty', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for individualName_ in self.individualName:
            namespaceprefix_ = self.individualName_nsprefix_ + ':' if (UseCapturedNS_ and self.individualName_nsprefix_) else ''
            individualName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='individualName', pretty_print=pretty_print)
        for organizationName_ in self.organizationName:
            namespaceprefix_ = self.organizationName_nsprefix_ + ':' if (UseCapturedNS_ and self.organizationName_nsprefix_) else ''
            organizationName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizationName', pretty_print=pretty_print)
        for positionName_ in self.positionName:
            namespaceprefix_ = self.positionName_nsprefix_ + ':' if (UseCapturedNS_ and self.positionName_nsprefix_) else ''
            positionName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='positionName', pretty_print=pretty_print)
        for address_ in self.address:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            address_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        for phone_ in self.phone:
            namespaceprefix_ = self.phone_nsprefix_ + ':' if (UseCapturedNS_ and self.phone_nsprefix_) else ''
            phone_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phone', pretty_print=pretty_print)
        for electronicMailAddress_ in self.electronicMailAddress:
            namespaceprefix_ = self.electronicMailAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.electronicMailAddress_nsprefix_) else ''
            electronicMailAddress_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='electronicMailAddress', pretty_print=pretty_print)
        for onlineUrl_ in self.onlineUrl:
            namespaceprefix_ = self.onlineUrl_nsprefix_ + ':' if (UseCapturedNS_ and self.onlineUrl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sonlineUrl>%s</%sonlineUrl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(onlineUrl_), input_name='onlineUrl')), namespaceprefix_ , eol_))
        for userId_ in self.userId:
            namespaceprefix_ = self.userId_nsprefix_ + ':' if (UseCapturedNS_ and self.userId_nsprefix_) else ''
            userId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='userId', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'individualName':
            obj_ = Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.individualName.append(obj_)
            obj_.original_tagname_ = 'individualName'
        elif nodeName_ == 'organizationName':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizationName.append(obj_)
            obj_.original_tagname_ = 'organizationName'
        elif nodeName_ == 'positionName':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.positionName.append(obj_)
            obj_.original_tagname_ = 'positionName'
        elif nodeName_ == 'address':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address.append(obj_)
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'phone':
            obj_ = phoneType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.phone.append(obj_)
            obj_.original_tagname_ = 'phone'
        elif nodeName_ == 'electronicMailAddress':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.electronicMailAddress.append(obj_)
            obj_.original_tagname_ = 'electronicMailAddress'
        elif nodeName_ == 'onlineUrl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'onlineUrl')
            value_ = self.gds_validate_string(value_, node, 'onlineUrl')
            self.onlineUrl.append(value_)
            self.onlineUrl_nsprefix_ = child_.prefix
        elif nodeName_ == 'userId':
            obj_ = userIdType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.userId.append(obj_)
            obj_.original_tagname_ = 'userId'
        elif nodeName_ == 'references':
            obj_ = referencesType5.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class ResponsibleParty


class Person(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('salutation', 'i18nNonEmptyStringType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'salutation', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('givenName', 'i18nNonEmptyStringType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'givenName', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('surName', 'i18nNonEmptyStringType', 0, 0, {'name': 'surName', 'type': 'i18nNonEmptyStringType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, salutation=None, givenName=None, surName=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if salutation is None:
            self.salutation = []
        else:
            self.salutation = salutation
        self.salutation_nsprefix_ = None
        if givenName is None:
            self.givenName = []
        else:
            self.givenName = givenName
        self.givenName_nsprefix_ = None
        self.surName = surName
        self.surName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Person)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Person.subclass:
            return Person.subclass(*args_, **kwargs_)
        else:
            return Person(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_salutation(self):
        return self.salutation
    def set_salutation(self, salutation):
        self.salutation = salutation
    def add_salutation(self, value):
        self.salutation.append(value)
    def insert_salutation_at(self, index, value):
        self.salutation.insert(index, value)
    def replace_salutation_at(self, index, value):
        self.salutation[index] = value
    def get_givenName(self):
        return self.givenName
    def set_givenName(self, givenName):
        self.givenName = givenName
    def add_givenName(self, value):
        self.givenName.append(value)
    def insert_givenName_at(self, index, value):
        self.givenName.insert(index, value)
    def replace_givenName_at(self, index, value):
        self.givenName[index] = value
    def get_surName(self):
        return self.surName
    def set_surName(self, surName):
        self.surName = surName
    def hasContent_(self):
        if (
            self.salutation or
            self.givenName or
            self.surName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Person', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Person')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Person':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Person')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Person', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Person'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Person', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for salutation_ in self.salutation:
            namespaceprefix_ = self.salutation_nsprefix_ + ':' if (UseCapturedNS_ and self.salutation_nsprefix_) else ''
            salutation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='salutation', pretty_print=pretty_print)
        for givenName_ in self.givenName:
            namespaceprefix_ = self.givenName_nsprefix_ + ':' if (UseCapturedNS_ and self.givenName_nsprefix_) else ''
            givenName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='givenName', pretty_print=pretty_print)
        if self.surName is not None:
            namespaceprefix_ = self.surName_nsprefix_ + ':' if (UseCapturedNS_ and self.surName_nsprefix_) else ''
            self.surName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='surName', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'salutation':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.salutation.append(obj_)
            obj_.original_tagname_ = 'salutation'
        elif nodeName_ == 'givenName':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.givenName.append(obj_)
            obj_.original_tagname_ = 'givenName'
        elif nodeName_ == 'surName':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.surName = obj_
            obj_.original_tagname_ = 'surName'
# end class Person


class Address(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('deliveryPoint', 'i18nNonEmptyStringType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'deliveryPoint', 'type': 'i18nNonEmptyStringType'}, 13),
        MemberSpec_('city', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'city', 'type': 'i18nNonEmptyStringType'}, 13),
        MemberSpec_('administrativeArea', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'administrativeArea', 'type': 'i18nNonEmptyStringType'}, 13),
        MemberSpec_('postalCode', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'postalCode', 'type': 'i18nNonEmptyStringType'}, 13),
        MemberSpec_('country', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'country', 'type': 'i18nNonEmptyStringType'}, 13),
        MemberSpec_('references', 'referencesType6', 0, 0, {'name': 'references', 'type': 'referencesType6'}, 13),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', deliveryPoint=None, city=None, administrativeArea=None, postalCode=None, country=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if deliveryPoint is None:
            self.deliveryPoint = []
        else:
            self.deliveryPoint = deliveryPoint
        self.deliveryPoint_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.administrativeArea = administrativeArea
        self.administrativeArea_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Address)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_deliveryPoint(self):
        return self.deliveryPoint
    def set_deliveryPoint(self, deliveryPoint):
        self.deliveryPoint = deliveryPoint
    def add_deliveryPoint(self, value):
        self.deliveryPoint.append(value)
    def insert_deliveryPoint_at(self, index, value):
        self.deliveryPoint.insert(index, value)
    def replace_deliveryPoint_at(self, index, value):
        self.deliveryPoint[index] = value
    def get_city(self):
        return self.city
    def set_city(self, city):
        self.city = city
    def get_administrativeArea(self):
        return self.administrativeArea
    def set_administrativeArea(self, administrativeArea):
        self.administrativeArea = administrativeArea
    def get_postalCode(self):
        return self.postalCode
    def set_postalCode(self, postalCode):
        self.postalCode = postalCode
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.deliveryPoint or
            self.city is not None or
            self.administrativeArea is not None or
            self.postalCode is not None or
            self.country is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Address', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Address')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Address':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Address')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Address', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Address'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Address', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for deliveryPoint_ in self.deliveryPoint:
            namespaceprefix_ = self.deliveryPoint_nsprefix_ + ':' if (UseCapturedNS_ and self.deliveryPoint_nsprefix_) else ''
            deliveryPoint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deliveryPoint', pretty_print=pretty_print)
        if self.city is not None:
            namespaceprefix_ = self.city_nsprefix_ + ':' if (UseCapturedNS_ and self.city_nsprefix_) else ''
            self.city.export(outfile, level, namespaceprefix_, namespacedef_='', name_='city', pretty_print=pretty_print)
        if self.administrativeArea is not None:
            namespaceprefix_ = self.administrativeArea_nsprefix_ + ':' if (UseCapturedNS_ and self.administrativeArea_nsprefix_) else ''
            self.administrativeArea.export(outfile, level, namespaceprefix_, namespacedef_='', name_='administrativeArea', pretty_print=pretty_print)
        if self.postalCode is not None:
            namespaceprefix_ = self.postalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.postalCode_nsprefix_) else ''
            self.postalCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='postalCode', pretty_print=pretty_print)
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            self.country.export(outfile, level, namespaceprefix_, namespacedef_='', name_='country', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'deliveryPoint':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.deliveryPoint.append(obj_)
            obj_.original_tagname_ = 'deliveryPoint'
        elif nodeName_ == 'city':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.city = obj_
            obj_.original_tagname_ = 'city'
        elif nodeName_ == 'administrativeArea':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.administrativeArea = obj_
            obj_.original_tagname_ = 'administrativeArea'
        elif nodeName_ == 'postalCode':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.postalCode = obj_
            obj_.original_tagname_ = 'postalCode'
        elif nodeName_ == 'country':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.country = obj_
            obj_.original_tagname_ = 'country'
        elif nodeName_ == 'references':
            obj_ = referencesType6.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class Address


class Coverage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('geographicCoverage', 'GeographicCoverage', 1, 0, {'name': 'geographicCoverage', 'type': 'GeographicCoverage'}, 15),
        MemberSpec_('temporalCoverage', 'temporalCoverageType', 1, 0, {'name': 'temporalCoverage', 'type': 'temporalCoverageType'}, 15),
        MemberSpec_('taxonomicCoverage', 'taxonomicCoverageType', 1, 0, {'name': 'taxonomicCoverage', 'type': 'taxonomicCoverageType'}, 15),
        MemberSpec_('references', 'referencesType7', 0, 0, {'name': 'references', 'type': 'referencesType7'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', geographicCoverage=None, temporalCoverage=None, taxonomicCoverage=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if geographicCoverage is None:
            self.geographicCoverage = []
        else:
            self.geographicCoverage = geographicCoverage
        self.geographicCoverage_nsprefix_ = None
        if temporalCoverage is None:
            self.temporalCoverage = []
        else:
            self.temporalCoverage = temporalCoverage
        self.temporalCoverage_nsprefix_ = None
        if taxonomicCoverage is None:
            self.taxonomicCoverage = []
        else:
            self.taxonomicCoverage = taxonomicCoverage
        self.taxonomicCoverage_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Coverage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Coverage.subclass:
            return Coverage.subclass(*args_, **kwargs_)
        else:
            return Coverage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_geographicCoverage(self):
        return self.geographicCoverage
    def set_geographicCoverage(self, geographicCoverage):
        self.geographicCoverage = geographicCoverage
    def add_geographicCoverage(self, value):
        self.geographicCoverage.append(value)
    def insert_geographicCoverage_at(self, index, value):
        self.geographicCoverage.insert(index, value)
    def replace_geographicCoverage_at(self, index, value):
        self.geographicCoverage[index] = value
    def get_temporalCoverage(self):
        return self.temporalCoverage
    def set_temporalCoverage(self, temporalCoverage):
        self.temporalCoverage = temporalCoverage
    def add_temporalCoverage(self, value):
        self.temporalCoverage.append(value)
    def insert_temporalCoverage_at(self, index, value):
        self.temporalCoverage.insert(index, value)
    def replace_temporalCoverage_at(self, index, value):
        self.temporalCoverage[index] = value
    def get_taxonomicCoverage(self):
        return self.taxonomicCoverage
    def set_taxonomicCoverage(self, taxonomicCoverage):
        self.taxonomicCoverage = taxonomicCoverage
    def add_taxonomicCoverage(self, value):
        self.taxonomicCoverage.append(value)
    def insert_taxonomicCoverage_at(self, index, value):
        self.taxonomicCoverage.insert(index, value)
    def replace_taxonomicCoverage_at(self, index, value):
        self.taxonomicCoverage[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.geographicCoverage or
            self.temporalCoverage or
            self.taxonomicCoverage or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Coverage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Coverage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Coverage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Coverage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Coverage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Coverage'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Coverage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for geographicCoverage_ in self.geographicCoverage:
            namespaceprefix_ = self.geographicCoverage_nsprefix_ + ':' if (UseCapturedNS_ and self.geographicCoverage_nsprefix_) else ''
            geographicCoverage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='geographicCoverage', pretty_print=pretty_print)
        for temporalCoverage_ in self.temporalCoverage:
            namespaceprefix_ = self.temporalCoverage_nsprefix_ + ':' if (UseCapturedNS_ and self.temporalCoverage_nsprefix_) else ''
            temporalCoverage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='temporalCoverage', pretty_print=pretty_print)
        for taxonomicCoverage_ in self.taxonomicCoverage:
            namespaceprefix_ = self.taxonomicCoverage_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonomicCoverage_nsprefix_) else ''
            taxonomicCoverage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='taxonomicCoverage', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'geographicCoverage':
            obj_ = GeographicCoverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.geographicCoverage.append(obj_)
            obj_.original_tagname_ = 'geographicCoverage'
        elif nodeName_ == 'temporalCoverage':
            obj_ = temporalCoverageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.temporalCoverage.append(obj_)
            obj_.original_tagname_ = 'temporalCoverage'
        elif nodeName_ == 'taxonomicCoverage':
            obj_ = taxonomicCoverageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.taxonomicCoverage.append(obj_)
            obj_.original_tagname_ = 'taxonomicCoverage'
        elif nodeName_ == 'references':
            obj_ = referencesType7.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class Coverage


class TemporalCoverage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('singleDateTime', 'SingleDateTimeType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'singleDateTime', 'type': 'SingleDateTimeType'}, 17),
        MemberSpec_('rangeOfDates', 'rangeOfDatesType', 0, 0, {'name': 'rangeOfDates', 'type': 'rangeOfDatesType'}, 17),
        MemberSpec_('references', 'referencesType8', 0, 0, {'name': 'references', 'type': 'referencesType8'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, singleDateTime=None, rangeOfDates=None, references=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if singleDateTime is None:
            self.singleDateTime = []
        else:
            self.singleDateTime = singleDateTime
        self.singleDateTime_nsprefix_ = None
        self.rangeOfDates = rangeOfDates
        self.rangeOfDates_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TemporalCoverage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TemporalCoverage.subclass:
            return TemporalCoverage.subclass(*args_, **kwargs_)
        else:
            return TemporalCoverage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_singleDateTime(self):
        return self.singleDateTime
    def set_singleDateTime(self, singleDateTime):
        self.singleDateTime = singleDateTime
    def add_singleDateTime(self, value):
        self.singleDateTime.append(value)
    def insert_singleDateTime_at(self, index, value):
        self.singleDateTime.insert(index, value)
    def replace_singleDateTime_at(self, index, value):
        self.singleDateTime[index] = value
    def get_rangeOfDates(self):
        return self.rangeOfDates
    def set_rangeOfDates(self, rangeOfDates):
        self.rangeOfDates = rangeOfDates
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.singleDateTime or
            self.rangeOfDates is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TemporalCoverage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TemporalCoverage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TemporalCoverage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TemporalCoverage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TemporalCoverage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TemporalCoverage'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TemporalCoverage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for singleDateTime_ in self.singleDateTime:
            namespaceprefix_ = self.singleDateTime_nsprefix_ + ':' if (UseCapturedNS_ and self.singleDateTime_nsprefix_) else ''
            singleDateTime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='singleDateTime', pretty_print=pretty_print)
        if self.rangeOfDates is not None:
            namespaceprefix_ = self.rangeOfDates_nsprefix_ + ':' if (UseCapturedNS_ and self.rangeOfDates_nsprefix_) else ''
            self.rangeOfDates.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rangeOfDates', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'singleDateTime':
            obj_ = SingleDateTimeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.singleDateTime.append(obj_)
            obj_.original_tagname_ = 'singleDateTime'
        elif nodeName_ == 'rangeOfDates':
            obj_ = rangeOfDatesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.rangeOfDates = obj_
            obj_.original_tagname_ = 'rangeOfDates'
        elif nodeName_ == 'references':
            obj_ = referencesType8.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class TemporalCoverage


class SingleDateTimeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('calendarDate', 'yearDate', 0, 0, {'name': 'calendarDate', 'type': 'xs:string'}, 18),
        MemberSpec_('time', 'xs:time', 0, 1, {'minOccurs': '0', 'name': 'time', 'type': 'xs:time'}, 18),
        MemberSpec_('alternativeTimeScale', 'alternativeTimeScaleType', 0, 0, {'name': 'alternativeTimeScale', 'type': 'alternativeTimeScaleType'}, 18),
    ]
    subclass = None
    superclass = None
    def __init__(self, calendarDate=None, time=None, alternativeTimeScale=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.calendarDate = calendarDate
        self.validate_yearDate(self.calendarDate)
        self.calendarDate_nsprefix_ = None
        if isinstance(time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(time, '%H:%M:%S').time()
        else:
            initvalue_ = time
        self.time = initvalue_
        self.time_nsprefix_ = None
        self.alternativeTimeScale = alternativeTimeScale
        self.alternativeTimeScale_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SingleDateTimeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SingleDateTimeType.subclass:
            return SingleDateTimeType.subclass(*args_, **kwargs_)
        else:
            return SingleDateTimeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_calendarDate(self):
        return self.calendarDate
    def set_calendarDate(self, calendarDate):
        self.calendarDate = calendarDate
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_alternativeTimeScale(self):
        return self.alternativeTimeScale
    def set_alternativeTimeScale(self, alternativeTimeScale):
        self.alternativeTimeScale = alternativeTimeScale
    def validate_yearDate(self, value):
        result = True
        # Validate type yearDate, a restriction on None.
        pass
        return result
    def hasContent_(self):
        if (
            self.calendarDate is not None or
            self.time is not None or
            self.alternativeTimeScale is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SingleDateTimeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SingleDateTimeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SingleDateTimeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SingleDateTimeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SingleDateTimeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SingleDateTimeType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SingleDateTimeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.calendarDate is not None:
            namespaceprefix_ = self.calendarDate_nsprefix_ + ':' if (UseCapturedNS_ and self.calendarDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scalendarDate>%s</%scalendarDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.calendarDate), input_name='calendarDate')), namespaceprefix_ , eol_))
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stime>%s</%stime>%s' % (namespaceprefix_ , self.gds_format_time(self.time, input_name='time'), namespaceprefix_ , eol_))
        if self.alternativeTimeScale is not None:
            namespaceprefix_ = self.alternativeTimeScale_nsprefix_ + ':' if (UseCapturedNS_ and self.alternativeTimeScale_nsprefix_) else ''
            self.alternativeTimeScale.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternativeTimeScale', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'calendarDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'calendarDate')
            value_ = self.gds_validate_string(value_, node, 'calendarDate')
            self.calendarDate = value_
            self.calendarDate_nsprefix_ = child_.prefix
            # validate type yearDate
            self.validate_yearDate(self.calendarDate)
        elif nodeName_ == 'time':
            sval_ = child_.text
            dval_ = self.gds_parse_time(sval_)
            self.time = dval_
            self.time_nsprefix_ = child_.prefix
        elif nodeName_ == 'alternativeTimeScale':
            obj_ = alternativeTimeScaleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternativeTimeScale = obj_
            obj_.original_tagname_ = 'alternativeTimeScale'
# end class SingleDateTimeType


class GeographicCoverage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('geographicDescription', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'geographicDescription', 'type': 'xs:string'}, 19),
        MemberSpec_('boundingCoordinates', 'boundingCoordinatesType', 0, 0, {'name': 'boundingCoordinates', 'type': 'boundingCoordinatesType'}, 19),
        MemberSpec_('datasetGPolygon', 'datasetGPolygonType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'datasetGPolygon', 'type': 'datasetGPolygonType'}, 19),
        MemberSpec_('references', 'referencesType9', 0, 0, {'name': 'references', 'type': 'referencesType9'}, 19),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', geographicDescription=None, boundingCoordinates=None, datasetGPolygon=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.geographicDescription = geographicDescription
        self.validate_NonEmptyStringType(self.geographicDescription)
        self.geographicDescription_nsprefix_ = None
        self.boundingCoordinates = boundingCoordinates
        self.boundingCoordinates_nsprefix_ = None
        if datasetGPolygon is None:
            self.datasetGPolygon = []
        else:
            self.datasetGPolygon = datasetGPolygon
        self.datasetGPolygon_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GeographicCoverage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GeographicCoverage.subclass:
            return GeographicCoverage.subclass(*args_, **kwargs_)
        else:
            return GeographicCoverage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_geographicDescription(self):
        return self.geographicDescription
    def set_geographicDescription(self, geographicDescription):
        self.geographicDescription = geographicDescription
    def get_boundingCoordinates(self):
        return self.boundingCoordinates
    def set_boundingCoordinates(self, boundingCoordinates):
        self.boundingCoordinates = boundingCoordinates
    def get_datasetGPolygon(self):
        return self.datasetGPolygon
    def set_datasetGPolygon(self, datasetGPolygon):
        self.datasetGPolygon = datasetGPolygon
    def add_datasetGPolygon(self, value):
        self.datasetGPolygon.append(value)
    def insert_datasetGPolygon_at(self, index, value):
        self.datasetGPolygon.insert(index, value)
    def replace_datasetGPolygon_at(self, index, value):
        self.datasetGPolygon[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.geographicDescription is not None or
            self.boundingCoordinates is not None or
            self.datasetGPolygon or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='GeographicCoverage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GeographicCoverage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GeographicCoverage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GeographicCoverage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GeographicCoverage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GeographicCoverage'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='GeographicCoverage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.geographicDescription is not None:
            namespaceprefix_ = self.geographicDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.geographicDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeographicDescription>%s</%sgeographicDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.geographicDescription), input_name='geographicDescription')), namespaceprefix_ , eol_))
        if self.boundingCoordinates is not None:
            namespaceprefix_ = self.boundingCoordinates_nsprefix_ + ':' if (UseCapturedNS_ and self.boundingCoordinates_nsprefix_) else ''
            self.boundingCoordinates.export(outfile, level, namespaceprefix_, namespacedef_='', name_='boundingCoordinates', pretty_print=pretty_print)
        for datasetGPolygon_ in self.datasetGPolygon:
            namespaceprefix_ = self.datasetGPolygon_nsprefix_ + ':' if (UseCapturedNS_ and self.datasetGPolygon_nsprefix_) else ''
            datasetGPolygon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='datasetGPolygon', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'geographicDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'geographicDescription')
            value_ = self.gds_validate_string(value_, node, 'geographicDescription')
            self.geographicDescription = value_
            self.geographicDescription_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.geographicDescription)
        elif nodeName_ == 'boundingCoordinates':
            obj_ = boundingCoordinatesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.boundingCoordinates = obj_
            obj_.original_tagname_ = 'boundingCoordinates'
        elif nodeName_ == 'datasetGPolygon':
            obj_ = datasetGPolygonType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.datasetGPolygon.append(obj_)
            obj_.original_tagname_ = 'datasetGPolygon'
        elif nodeName_ == 'references':
            obj_ = referencesType9.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class GeographicCoverage


class GRingPointType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('gRingLatitude', ['gRingLatitudeType', 'xs:decimal'], 0, 0, {'name': 'gRingLatitude', 'type': 'xs:decimal'}, None),
        MemberSpec_('gRingLongitude', ['gRingLongitudeType', 'xs:decimal'], 0, 0, {'name': 'gRingLongitude', 'type': 'xs:decimal'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, gRingLatitude=None, gRingLongitude=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.gRingLatitude = gRingLatitude
        self.validate_gRingLatitudeType(self.gRingLatitude)
        self.gRingLatitude_nsprefix_ = None
        self.gRingLongitude = gRingLongitude
        self.validate_gRingLongitudeType(self.gRingLongitude)
        self.gRingLongitude_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GRingPointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GRingPointType.subclass:
            return GRingPointType.subclass(*args_, **kwargs_)
        else:
            return GRingPointType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_gRingLatitude(self):
        return self.gRingLatitude
    def set_gRingLatitude(self, gRingLatitude):
        self.gRingLatitude = gRingLatitude
    def get_gRingLongitude(self):
        return self.gRingLongitude
    def set_gRingLongitude(self, gRingLongitude):
        self.gRingLongitude = gRingLongitude
    def validate_gRingLatitudeType(self, value):
        result = True
        # Validate type gRingLatitudeType, a restriction on xs:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < -90.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on gRingLatitudeType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 90.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on gRingLatitudeType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_gRingLongitudeType(self, value):
        result = True
        # Validate type gRingLongitudeType, a restriction on xs:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < -180.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on gRingLongitudeType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 180.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on gRingLongitudeType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.gRingLatitude is not None or
            self.gRingLongitude is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='GRingPointType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GRingPointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GRingPointType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GRingPointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GRingPointType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GRingPointType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='GRingPointType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.gRingLatitude is not None:
            namespaceprefix_ = self.gRingLatitude_nsprefix_ + ':' if (UseCapturedNS_ and self.gRingLatitude_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgRingLatitude>%s</%sgRingLatitude>%s' % (namespaceprefix_ , self.gds_format_decimal(self.gRingLatitude, input_name='gRingLatitude'), namespaceprefix_ , eol_))
        if self.gRingLongitude is not None:
            namespaceprefix_ = self.gRingLongitude_nsprefix_ + ':' if (UseCapturedNS_ and self.gRingLongitude_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgRingLongitude>%s</%sgRingLongitude>%s' % (namespaceprefix_ , self.gds_format_decimal(self.gRingLongitude, input_name='gRingLongitude'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'gRingLatitude' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'gRingLatitude')
            fval_ = self.gds_validate_decimal(fval_, node, 'gRingLatitude')
            self.gRingLatitude = fval_
            self.gRingLatitude_nsprefix_ = child_.prefix
            # validate type gRingLatitudeType
            self.validate_gRingLatitudeType(self.gRingLatitude)
        elif nodeName_ == 'gRingLongitude' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'gRingLongitude')
            fval_ = self.gds_validate_decimal(fval_, node, 'gRingLongitude')
            self.gRingLongitude = fval_
            self.gRingLongitude_nsprefix_ = child_.prefix
            # validate type gRingLongitudeType
            self.validate_gRingLongitudeType(self.gRingLongitude)
# end class GRingPointType


class TaxonomicCoverage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('taxonomicSystem', 'taxonomicSystemType', 0, 1, {'minOccurs': '0', 'name': 'taxonomicSystem', 'type': 'taxonomicSystemType'}, 20),
        MemberSpec_('generalTaxonomicCoverage', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'generalTaxonomicCoverage', 'type': 'xs:string'}, 20),
        MemberSpec_('taxonomicClassification', 'TaxonomicClassificationType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'taxonomicClassification', 'type': 'TaxonomicClassificationType'}, 20),
        MemberSpec_('references', 'referencesType10', 0, 0, {'name': 'references', 'type': 'referencesType10'}, 20),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, taxonomicSystem=None, generalTaxonomicCoverage=None, taxonomicClassification=None, references=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.taxonomicSystem = taxonomicSystem
        self.taxonomicSystem_nsprefix_ = None
        self.generalTaxonomicCoverage = generalTaxonomicCoverage
        self.validate_NonEmptyStringType(self.generalTaxonomicCoverage)
        self.generalTaxonomicCoverage_nsprefix_ = None
        if taxonomicClassification is None:
            self.taxonomicClassification = []
        else:
            self.taxonomicClassification = taxonomicClassification
        self.taxonomicClassification_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TaxonomicCoverage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TaxonomicCoverage.subclass:
            return TaxonomicCoverage.subclass(*args_, **kwargs_)
        else:
            return TaxonomicCoverage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_taxonomicSystem(self):
        return self.taxonomicSystem
    def set_taxonomicSystem(self, taxonomicSystem):
        self.taxonomicSystem = taxonomicSystem
    def get_generalTaxonomicCoverage(self):
        return self.generalTaxonomicCoverage
    def set_generalTaxonomicCoverage(self, generalTaxonomicCoverage):
        self.generalTaxonomicCoverage = generalTaxonomicCoverage
    def get_taxonomicClassification(self):
        return self.taxonomicClassification
    def set_taxonomicClassification(self, taxonomicClassification):
        self.taxonomicClassification = taxonomicClassification
    def add_taxonomicClassification(self, value):
        self.taxonomicClassification.append(value)
    def insert_taxonomicClassification_at(self, index, value):
        self.taxonomicClassification.insert(index, value)
    def replace_taxonomicClassification_at(self, index, value):
        self.taxonomicClassification[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.taxonomicSystem is not None or
            self.generalTaxonomicCoverage is not None or
            self.taxonomicClassification or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='TaxonomicCoverage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TaxonomicCoverage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TaxonomicCoverage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TaxonomicCoverage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TaxonomicCoverage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TaxonomicCoverage'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='TaxonomicCoverage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.taxonomicSystem is not None:
            namespaceprefix_ = self.taxonomicSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonomicSystem_nsprefix_) else ''
            self.taxonomicSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='taxonomicSystem', pretty_print=pretty_print)
        if self.generalTaxonomicCoverage is not None:
            namespaceprefix_ = self.generalTaxonomicCoverage_nsprefix_ + ':' if (UseCapturedNS_ and self.generalTaxonomicCoverage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeneralTaxonomicCoverage>%s</%sgeneralTaxonomicCoverage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.generalTaxonomicCoverage), input_name='generalTaxonomicCoverage')), namespaceprefix_ , eol_))
        for taxonomicClassification_ in self.taxonomicClassification:
            namespaceprefix_ = self.taxonomicClassification_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonomicClassification_nsprefix_) else ''
            taxonomicClassification_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='taxonomicClassification', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'taxonomicSystem':
            obj_ = taxonomicSystemType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.taxonomicSystem = obj_
            obj_.original_tagname_ = 'taxonomicSystem'
        elif nodeName_ == 'generalTaxonomicCoverage':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'generalTaxonomicCoverage')
            value_ = self.gds_validate_string(value_, node, 'generalTaxonomicCoverage')
            self.generalTaxonomicCoverage = value_
            self.generalTaxonomicCoverage_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.generalTaxonomicCoverage)
        elif nodeName_ == 'taxonomicClassification':
            obj_ = TaxonomicClassificationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.taxonomicClassification.append(obj_)
            obj_.original_tagname_ = 'taxonomicClassification'
        elif nodeName_ == 'references':
            obj_ = referencesType10.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class TaxonomicCoverage


class TaxonomicClassificationType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('taxonRankName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'taxonRankName', 'type': 'xs:string'}, None),
        MemberSpec_('taxonRankValue', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'taxonRankValue', 'type': 'xs:string'}, None),
        MemberSpec_('commonName', ['NonEmptyStringType', 'xs:string'], 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'commonName', 'type': 'xs:string'}, None),
        MemberSpec_('taxonId', 'taxonIdType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'taxonId', 'type': 'taxonIdType'}, None),
        MemberSpec_('taxonomicClassification', 'TaxonomicClassificationType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'taxonomicClassification', 'type': 'TaxonomicClassificationType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, taxonRankName=None, taxonRankValue=None, commonName=None, taxonId=None, taxonomicClassification=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.taxonRankName = taxonRankName
        self.validate_NonEmptyStringType(self.taxonRankName)
        self.taxonRankName_nsprefix_ = None
        self.taxonRankValue = taxonRankValue
        self.validate_NonEmptyStringType(self.taxonRankValue)
        self.taxonRankValue_nsprefix_ = None
        if commonName is None:
            self.commonName = []
        else:
            self.commonName = commonName
        self.commonName_nsprefix_ = None
        if taxonId is None:
            self.taxonId = []
        else:
            self.taxonId = taxonId
        self.taxonId_nsprefix_ = None
        if taxonomicClassification is None:
            self.taxonomicClassification = []
        else:
            self.taxonomicClassification = taxonomicClassification
        self.taxonomicClassification_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TaxonomicClassificationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TaxonomicClassificationType.subclass:
            return TaxonomicClassificationType.subclass(*args_, **kwargs_)
        else:
            return TaxonomicClassificationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_taxonRankName(self):
        return self.taxonRankName
    def set_taxonRankName(self, taxonRankName):
        self.taxonRankName = taxonRankName
    def get_taxonRankValue(self):
        return self.taxonRankValue
    def set_taxonRankValue(self, taxonRankValue):
        self.taxonRankValue = taxonRankValue
    def get_commonName(self):
        return self.commonName
    def set_commonName(self, commonName):
        self.commonName = commonName
    def add_commonName(self, value):
        self.commonName.append(value)
    def insert_commonName_at(self, index, value):
        self.commonName.insert(index, value)
    def replace_commonName_at(self, index, value):
        self.commonName[index] = value
    def get_taxonId(self):
        return self.taxonId
    def set_taxonId(self, taxonId):
        self.taxonId = taxonId
    def add_taxonId(self, value):
        self.taxonId.append(value)
    def insert_taxonId_at(self, index, value):
        self.taxonId.insert(index, value)
    def replace_taxonId_at(self, index, value):
        self.taxonId[index] = value
    def get_taxonomicClassification(self):
        return self.taxonomicClassification
    def set_taxonomicClassification(self, taxonomicClassification):
        self.taxonomicClassification = taxonomicClassification
    def add_taxonomicClassification(self, value):
        self.taxonomicClassification.append(value)
    def insert_taxonomicClassification_at(self, index, value):
        self.taxonomicClassification.insert(index, value)
    def replace_taxonomicClassification_at(self, index, value):
        self.taxonomicClassification[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.taxonRankName is not None or
            self.taxonRankValue is not None or
            self.commonName or
            self.taxonId or
            self.taxonomicClassification
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TaxonomicClassificationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TaxonomicClassificationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TaxonomicClassificationType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TaxonomicClassificationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TaxonomicClassificationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TaxonomicClassificationType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='TaxonomicClassificationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.taxonRankName is not None:
            namespaceprefix_ = self.taxonRankName_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonRankName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%staxonRankName>%s</%staxonRankName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.taxonRankName), input_name='taxonRankName')), namespaceprefix_ , eol_))
        if self.taxonRankValue is not None:
            namespaceprefix_ = self.taxonRankValue_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonRankValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%staxonRankValue>%s</%staxonRankValue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.taxonRankValue), input_name='taxonRankValue')), namespaceprefix_ , eol_))
        for commonName_ in self.commonName:
            namespaceprefix_ = self.commonName_nsprefix_ + ':' if (UseCapturedNS_ and self.commonName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scommonName>%s</%scommonName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(commonName_), input_name='commonName')), namespaceprefix_ , eol_))
        for taxonId_ in self.taxonId:
            namespaceprefix_ = self.taxonId_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonId_nsprefix_) else ''
            taxonId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='taxonId', pretty_print=pretty_print)
        for taxonomicClassification_ in self.taxonomicClassification:
            namespaceprefix_ = self.taxonomicClassification_nsprefix_ + ':' if (UseCapturedNS_ and self.taxonomicClassification_nsprefix_) else ''
            taxonomicClassification_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='taxonomicClassification', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'taxonRankName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'taxonRankName')
            value_ = self.gds_validate_string(value_, node, 'taxonRankName')
            self.taxonRankName = value_
            self.taxonRankName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.taxonRankName)
        elif nodeName_ == 'taxonRankValue':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'taxonRankValue')
            value_ = self.gds_validate_string(value_, node, 'taxonRankValue')
            self.taxonRankValue = value_
            self.taxonRankValue_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.taxonRankValue)
        elif nodeName_ == 'commonName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'commonName')
            value_ = self.gds_validate_string(value_, node, 'commonName')
            self.commonName.append(value_)
            self.commonName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.commonName[-1])
        elif nodeName_ == 'taxonId':
            obj_ = taxonIdType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.taxonId.append(obj_)
            obj_.original_tagname_ = 'taxonId'
        elif nodeName_ == 'taxonomicClassification':
            obj_ = TaxonomicClassificationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.taxonomicClassification.append(obj_)
            obj_.original_tagname_ = 'taxonomicClassification'
# end class TaxonomicClassificationType


class CitationType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('alternateIdentifier', 'alternateIdentifierType11', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'alternateIdentifier', 'type': 'alternateIdentifierType11'}, 21),
        MemberSpec_('shortName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'shortName', 'type': 'xs:string'}, 21),
        MemberSpec_('title', 'i18nNonEmptyStringType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'title', 'type': 'i18nNonEmptyStringType'}, 21),
        MemberSpec_('creator', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'creator', 'type': 'ResponsibleParty'}, 21),
        MemberSpec_('metadataProvider', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'metadataProvider', 'type': 'ResponsibleParty'}, 21),
        MemberSpec_('associatedParty', 'associatedPartyType12', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'associatedParty', 'type': 'associatedPartyType12'}, 21),
        MemberSpec_('pubDate', 'yearDate', 0, 1, {'minOccurs': '0', 'name': 'pubDate', 'type': 'xs:string'}, 21),
        MemberSpec_('language', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'language', 'type': 'i18nNonEmptyStringType'}, 21),
        MemberSpec_('series', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'series', 'type': 'xs:string'}, 21),
        MemberSpec_('abstract', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'abstract', 'type': 'TextType'}, 21),
        MemberSpec_('keywordSet', 'keywordSetType13', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'keywordSet', 'type': 'keywordSetType13'}, 21),
        MemberSpec_('additionalInfo', 'TextType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalInfo', 'type': 'TextType'}, 21),
        MemberSpec_('intellectualRights', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'intellectualRights', 'type': 'TextType'}, 21),
        MemberSpec_('licensed', 'LicenseType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'licensed', 'type': 'LicenseType'}, 21),
        MemberSpec_('distribution', 'DistributionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'distribution', 'type': 'DistributionType'}, 21),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 21),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 21),
        MemberSpec_('contact', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'contact', 'type': 'ResponsibleParty'}, 21),
        MemberSpec_('article', 'Article', 0, 0, {'name': 'article', 'type': 'Article'}, 22),
        MemberSpec_('book', 'Book', 0, 0, {'name': 'book', 'type': 'Book'}, 22),
        MemberSpec_('chapter', 'Chapter', 0, 0, {'name': 'chapter', 'type': 'Chapter'}, 22),
        MemberSpec_('editedBook', 'Book', 0, 0, {'name': 'editedBook', 'type': 'Book'}, 22),
        MemberSpec_('manuscript', 'Manuscript', 0, 0, {'name': 'manuscript', 'type': 'Manuscript'}, 22),
        MemberSpec_('report', 'Report', 0, 0, {'name': 'report', 'type': 'Report'}, 22),
        MemberSpec_('thesis', 'Thesis', 0, 0, {'name': 'thesis', 'type': 'Thesis'}, 22),
        MemberSpec_('conferenceProceedings', 'ConferenceProceedings', 0, 0, {'name': 'conferenceProceedings', 'type': 'ConferenceProceedings'}, 22),
        MemberSpec_('personalCommunication', 'PersonalCommunication', 0, 0, {'name': 'personalCommunication', 'type': 'PersonalCommunication'}, 22),
        MemberSpec_('map', 'Map', 0, 0, {'name': 'map', 'type': 'Map'}, 22),
        MemberSpec_('generic', 'Generic', 0, 0, {'name': 'generic', 'type': 'Generic'}, 22),
        MemberSpec_('audioVisual', 'AudioVisual', 0, 0, {'name': 'audioVisual', 'type': 'AudioVisual'}, 22),
        MemberSpec_('presentation', 'Presentation', 0, 0, {'name': 'presentation', 'type': 'Presentation'}, 22),
        MemberSpec_('bibtex', 'xs:string', 0, 0, {'name': 'bibtex', 'type': 'xs:string'}, None),
        MemberSpec_('references', 'referencesType15', 0, 0, {'name': 'references', 'type': 'referencesType15'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', alternateIdentifier=None, shortName=None, title=None, creator=None, metadataProvider=None, associatedParty=None, pubDate=None, language=None, series=None, abstract=None, keywordSet=None, additionalInfo=None, intellectualRights=None, licensed=None, distribution=None, coverage=None, annotation=None, contact=None, article=None, book=None, chapter=None, editedBook=None, manuscript=None, report=None, thesis=None, conferenceProceedings=None, personalCommunication=None, map=None, generic=None, audioVisual=None, presentation=None, bibtex=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if alternateIdentifier is None:
            self.alternateIdentifier = []
        else:
            self.alternateIdentifier = alternateIdentifier
        self.alternateIdentifier_nsprefix_ = None
        self.shortName = shortName
        self.validate_NonEmptyStringType(self.shortName)
        self.shortName_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if creator is None:
            self.creator = []
        else:
            self.creator = creator
        self.creator_nsprefix_ = None
        if metadataProvider is None:
            self.metadataProvider = []
        else:
            self.metadataProvider = metadataProvider
        self.metadataProvider_nsprefix_ = None
        if associatedParty is None:
            self.associatedParty = []
        else:
            self.associatedParty = associatedParty
        self.associatedParty_nsprefix_ = None
        self.pubDate = pubDate
        self.validate_yearDate(self.pubDate)
        self.pubDate_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.series = series
        self.validate_NonEmptyStringType(self.series)
        self.series_nsprefix_ = None
        self.abstract = abstract
        self.abstract_nsprefix_ = None
        if keywordSet is None:
            self.keywordSet = []
        else:
            self.keywordSet = keywordSet
        self.keywordSet_nsprefix_ = None
        if additionalInfo is None:
            self.additionalInfo = []
        else:
            self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.intellectualRights = intellectualRights
        self.intellectualRights_nsprefix_ = None
        if licensed is None:
            self.licensed = []
        else:
            self.licensed = licensed
        self.licensed_nsprefix_ = None
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.distribution_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        if contact is None:
            self.contact = []
        else:
            self.contact = contact
        self.contact_nsprefix_ = None
        self.article = article
        self.article_nsprefix_ = None
        self.book = book
        self.book_nsprefix_ = None
        self.chapter = chapter
        self.chapter_nsprefix_ = None
        self.editedBook = editedBook
        self.editedBook_nsprefix_ = None
        self.manuscript = manuscript
        self.manuscript_nsprefix_ = None
        self.report = report
        self.report_nsprefix_ = None
        self.thesis = thesis
        self.thesis_nsprefix_ = None
        self.conferenceProceedings = conferenceProceedings
        self.conferenceProceedings_nsprefix_ = None
        self.personalCommunication = personalCommunication
        self.personalCommunication_nsprefix_ = None
        self.map = map
        self.map_nsprefix_ = None
        self.generic = generic
        self.generic_nsprefix_ = None
        self.audioVisual = audioVisual
        self.audioVisual_nsprefix_ = None
        self.presentation = presentation
        self.presentation_nsprefix_ = None
        self.bibtex = bibtex
        self.bibtex_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CitationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CitationType.subclass:
            return CitationType.subclass(*args_, **kwargs_)
        else:
            return CitationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternateIdentifier(self):
        return self.alternateIdentifier
    def set_alternateIdentifier(self, alternateIdentifier):
        self.alternateIdentifier = alternateIdentifier
    def add_alternateIdentifier(self, value):
        self.alternateIdentifier.append(value)
    def insert_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier.insert(index, value)
    def replace_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier[index] = value
    def get_shortName(self):
        return self.shortName
    def set_shortName(self, shortName):
        self.shortName = shortName
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_creator(self):
        return self.creator
    def set_creator(self, creator):
        self.creator = creator
    def add_creator(self, value):
        self.creator.append(value)
    def insert_creator_at(self, index, value):
        self.creator.insert(index, value)
    def replace_creator_at(self, index, value):
        self.creator[index] = value
    def get_metadataProvider(self):
        return self.metadataProvider
    def set_metadataProvider(self, metadataProvider):
        self.metadataProvider = metadataProvider
    def add_metadataProvider(self, value):
        self.metadataProvider.append(value)
    def insert_metadataProvider_at(self, index, value):
        self.metadataProvider.insert(index, value)
    def replace_metadataProvider_at(self, index, value):
        self.metadataProvider[index] = value
    def get_associatedParty(self):
        return self.associatedParty
    def set_associatedParty(self, associatedParty):
        self.associatedParty = associatedParty
    def add_associatedParty(self, value):
        self.associatedParty.append(value)
    def insert_associatedParty_at(self, index, value):
        self.associatedParty.insert(index, value)
    def replace_associatedParty_at(self, index, value):
        self.associatedParty[index] = value
    def get_pubDate(self):
        return self.pubDate
    def set_pubDate(self, pubDate):
        self.pubDate = pubDate
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_series(self):
        return self.series
    def set_series(self, series):
        self.series = series
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def get_keywordSet(self):
        return self.keywordSet
    def set_keywordSet(self, keywordSet):
        self.keywordSet = keywordSet
    def add_keywordSet(self, value):
        self.keywordSet.append(value)
    def insert_keywordSet_at(self, index, value):
        self.keywordSet.insert(index, value)
    def replace_keywordSet_at(self, index, value):
        self.keywordSet[index] = value
    def get_additionalInfo(self):
        return self.additionalInfo
    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo
    def add_additionalInfo(self, value):
        self.additionalInfo.append(value)
    def insert_additionalInfo_at(self, index, value):
        self.additionalInfo.insert(index, value)
    def replace_additionalInfo_at(self, index, value):
        self.additionalInfo[index] = value
    def get_intellectualRights(self):
        return self.intellectualRights
    def set_intellectualRights(self, intellectualRights):
        self.intellectualRights = intellectualRights
    def get_licensed(self):
        return self.licensed
    def set_licensed(self, licensed):
        self.licensed = licensed
    def add_licensed(self, value):
        self.licensed.append(value)
    def insert_licensed_at(self, index, value):
        self.licensed.insert(index, value)
    def replace_licensed_at(self, index, value):
        self.licensed[index] = value
    def get_distribution(self):
        return self.distribution
    def set_distribution(self, distribution):
        self.distribution = distribution
    def add_distribution(self, value):
        self.distribution.append(value)
    def insert_distribution_at(self, index, value):
        self.distribution.insert(index, value)
    def replace_distribution_at(self, index, value):
        self.distribution[index] = value
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_contact(self):
        return self.contact
    def set_contact(self, contact):
        self.contact = contact
    def add_contact(self, value):
        self.contact.append(value)
    def insert_contact_at(self, index, value):
        self.contact.insert(index, value)
    def replace_contact_at(self, index, value):
        self.contact[index] = value
    def get_article(self):
        return self.article
    def set_article(self, article):
        self.article = article
    def get_book(self):
        return self.book
    def set_book(self, book):
        self.book = book
    def get_chapter(self):
        return self.chapter
    def set_chapter(self, chapter):
        self.chapter = chapter
    def get_editedBook(self):
        return self.editedBook
    def set_editedBook(self, editedBook):
        self.editedBook = editedBook
    def get_manuscript(self):
        return self.manuscript
    def set_manuscript(self, manuscript):
        self.manuscript = manuscript
    def get_report(self):
        return self.report
    def set_report(self, report):
        self.report = report
    def get_thesis(self):
        return self.thesis
    def set_thesis(self, thesis):
        self.thesis = thesis
    def get_conferenceProceedings(self):
        return self.conferenceProceedings
    def set_conferenceProceedings(self, conferenceProceedings):
        self.conferenceProceedings = conferenceProceedings
    def get_personalCommunication(self):
        return self.personalCommunication
    def set_personalCommunication(self, personalCommunication):
        self.personalCommunication = personalCommunication
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def get_generic(self):
        return self.generic
    def set_generic(self, generic):
        self.generic = generic
    def get_audioVisual(self):
        return self.audioVisual
    def set_audioVisual(self, audioVisual):
        self.audioVisual = audioVisual
    def get_presentation(self):
        return self.presentation
    def set_presentation(self, presentation):
        self.presentation = presentation
    def get_bibtex(self):
        return self.bibtex
    def set_bibtex(self, bibtex):
        self.bibtex = bibtex
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_yearDate(self, value):
        result = True
        # Validate type yearDate, a restriction on None.
        pass
        return result
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.alternateIdentifier or
            self.shortName is not None or
            self.title or
            self.creator or
            self.metadataProvider or
            self.associatedParty or
            self.pubDate is not None or
            self.language is not None or
            self.series is not None or
            self.abstract is not None or
            self.keywordSet or
            self.additionalInfo or
            self.intellectualRights is not None or
            self.licensed or
            self.distribution or
            self.coverage is not None or
            self.annotation or
            self.contact or
            self.article is not None or
            self.book is not None or
            self.chapter is not None or
            self.editedBook is not None or
            self.manuscript is not None or
            self.report is not None or
            self.thesis is not None or
            self.conferenceProceedings is not None or
            self.personalCommunication is not None or
            self.map is not None or
            self.generic is not None or
            self.audioVisual is not None or
            self.presentation is not None or
            self.bibtex is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0" ', name_='CitationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CitationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CitationType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CitationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CitationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CitationType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0" ', name_='CitationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for alternateIdentifier_ in self.alternateIdentifier:
            namespaceprefix_ = self.alternateIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.alternateIdentifier_nsprefix_) else ''
            alternateIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternateIdentifier', pretty_print=pretty_print)
        if self.shortName is not None:
            namespaceprefix_ = self.shortName_nsprefix_ + ':' if (UseCapturedNS_ and self.shortName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshortName>%s</%sshortName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shortName), input_name='shortName')), namespaceprefix_ , eol_))
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for creator_ in self.creator:
            namespaceprefix_ = self.creator_nsprefix_ + ':' if (UseCapturedNS_ and self.creator_nsprefix_) else ''
            creator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='creator', pretty_print=pretty_print)
        for metadataProvider_ in self.metadataProvider:
            namespaceprefix_ = self.metadataProvider_nsprefix_ + ':' if (UseCapturedNS_ and self.metadataProvider_nsprefix_) else ''
            metadataProvider_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='metadataProvider', pretty_print=pretty_print)
        for associatedParty_ in self.associatedParty:
            namespaceprefix_ = self.associatedParty_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedParty_nsprefix_) else ''
            associatedParty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedParty', pretty_print=pretty_print)
        if self.pubDate is not None:
            namespaceprefix_ = self.pubDate_nsprefix_ + ':' if (UseCapturedNS_ and self.pubDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spubDate>%s</%spubDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pubDate), input_name='pubDate')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.series is not None:
            namespaceprefix_ = self.series_nsprefix_ + ':' if (UseCapturedNS_ and self.series_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseries>%s</%sseries>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.series), input_name='series')), namespaceprefix_ , eol_))
        if self.abstract is not None:
            namespaceprefix_ = self.abstract_nsprefix_ + ':' if (UseCapturedNS_ and self.abstract_nsprefix_) else ''
            self.abstract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstract', pretty_print=pretty_print)
        for keywordSet_ in self.keywordSet:
            namespaceprefix_ = self.keywordSet_nsprefix_ + ':' if (UseCapturedNS_ and self.keywordSet_nsprefix_) else ''
            keywordSet_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='keywordSet', pretty_print=pretty_print)
        for additionalInfo_ in self.additionalInfo:
            namespaceprefix_ = self.additionalInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalInfo_nsprefix_) else ''
            additionalInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalInfo', pretty_print=pretty_print)
        if self.intellectualRights is not None:
            namespaceprefix_ = self.intellectualRights_nsprefix_ + ':' if (UseCapturedNS_ and self.intellectualRights_nsprefix_) else ''
            self.intellectualRights.export(outfile, level, namespaceprefix_, namespacedef_='', name_='intellectualRights', pretty_print=pretty_print)
        for licensed_ in self.licensed:
            namespaceprefix_ = self.licensed_nsprefix_ + ':' if (UseCapturedNS_ and self.licensed_nsprefix_) else ''
            licensed_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='licensed', pretty_print=pretty_print)
        for distribution_ in self.distribution:
            namespaceprefix_ = self.distribution_nsprefix_ + ':' if (UseCapturedNS_ and self.distribution_nsprefix_) else ''
            distribution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='distribution', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        for contact_ in self.contact:
            namespaceprefix_ = self.contact_nsprefix_ + ':' if (UseCapturedNS_ and self.contact_nsprefix_) else ''
            contact_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contact', pretty_print=pretty_print)
        if self.article is not None:
            namespaceprefix_ = self.article_nsprefix_ + ':' if (UseCapturedNS_ and self.article_nsprefix_) else ''
            self.article.export(outfile, level, namespaceprefix_, namespacedef_='', name_='article', pretty_print=pretty_print)
        if self.book is not None:
            namespaceprefix_ = self.book_nsprefix_ + ':' if (UseCapturedNS_ and self.book_nsprefix_) else ''
            self.book.export(outfile, level, namespaceprefix_, namespacedef_='', name_='book', pretty_print=pretty_print)
        if self.chapter is not None:
            namespaceprefix_ = self.chapter_nsprefix_ + ':' if (UseCapturedNS_ and self.chapter_nsprefix_) else ''
            self.chapter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chapter', pretty_print=pretty_print)
        if self.editedBook is not None:
            namespaceprefix_ = self.editedBook_nsprefix_ + ':' if (UseCapturedNS_ and self.editedBook_nsprefix_) else ''
            self.editedBook.export(outfile, level, namespaceprefix_, namespacedef_='', name_='editedBook', pretty_print=pretty_print)
        if self.manuscript is not None:
            namespaceprefix_ = self.manuscript_nsprefix_ + ':' if (UseCapturedNS_ and self.manuscript_nsprefix_) else ''
            self.manuscript.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manuscript', pretty_print=pretty_print)
        if self.report is not None:
            namespaceprefix_ = self.report_nsprefix_ + ':' if (UseCapturedNS_ and self.report_nsprefix_) else ''
            self.report.export(outfile, level, namespaceprefix_, namespacedef_='', name_='report', pretty_print=pretty_print)
        if self.thesis is not None:
            namespaceprefix_ = self.thesis_nsprefix_ + ':' if (UseCapturedNS_ and self.thesis_nsprefix_) else ''
            self.thesis.export(outfile, level, namespaceprefix_, namespacedef_='', name_='thesis', pretty_print=pretty_print)
        if self.conferenceProceedings is not None:
            namespaceprefix_ = self.conferenceProceedings_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceProceedings_nsprefix_) else ''
            self.conferenceProceedings.export(outfile, level, namespaceprefix_, namespacedef_='', name_='conferenceProceedings', pretty_print=pretty_print)
        if self.personalCommunication is not None:
            namespaceprefix_ = self.personalCommunication_nsprefix_ + ':' if (UseCapturedNS_ and self.personalCommunication_nsprefix_) else ''
            self.personalCommunication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='personalCommunication', pretty_print=pretty_print)
        if self.map is not None:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            self.map.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
        if self.generic is not None:
            namespaceprefix_ = self.generic_nsprefix_ + ':' if (UseCapturedNS_ and self.generic_nsprefix_) else ''
            self.generic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='generic', pretty_print=pretty_print)
        if self.audioVisual is not None:
            namespaceprefix_ = self.audioVisual_nsprefix_ + ':' if (UseCapturedNS_ and self.audioVisual_nsprefix_) else ''
            self.audioVisual.export(outfile, level, namespaceprefix_, namespacedef_='', name_='audioVisual', pretty_print=pretty_print)
        if self.presentation is not None:
            namespaceprefix_ = self.presentation_nsprefix_ + ':' if (UseCapturedNS_ and self.presentation_nsprefix_) else ''
            self.presentation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='presentation', pretty_print=pretty_print)
        if self.bibtex is not None:
            namespaceprefix_ = self.bibtex_nsprefix_ + ':' if (UseCapturedNS_ and self.bibtex_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbibtex>%s</%sbibtex>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.bibtex), input_name='bibtex')), namespaceprefix_ , eol_))
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternateIdentifier':
            obj_ = alternateIdentifierType11.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternateIdentifier.append(obj_)
            obj_.original_tagname_ = 'alternateIdentifier'
        elif nodeName_ == 'shortName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shortName')
            value_ = self.gds_validate_string(value_, node, 'shortName')
            self.shortName = value_
            self.shortName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.shortName)
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'creator':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.creator.append(obj_)
            obj_.original_tagname_ = 'creator'
        elif nodeName_ == 'metadataProvider':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.metadataProvider.append(obj_)
            obj_.original_tagname_ = 'metadataProvider'
        elif nodeName_ == 'associatedParty':
            obj_ = associatedPartyType12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedParty.append(obj_)
            obj_.original_tagname_ = 'associatedParty'
        elif nodeName_ == 'pubDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pubDate')
            value_ = self.gds_validate_string(value_, node, 'pubDate')
            self.pubDate = value_
            self.pubDate_nsprefix_ = child_.prefix
            # validate type yearDate
            self.validate_yearDate(self.pubDate)
        elif nodeName_ == 'language':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'series':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'series')
            value_ = self.gds_validate_string(value_, node, 'series')
            self.series = value_
            self.series_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.series)
        elif nodeName_ == 'abstract':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstract = obj_
            obj_.original_tagname_ = 'abstract'
        elif nodeName_ == 'keywordSet':
            obj_ = keywordSetType13.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.keywordSet.append(obj_)
            obj_.original_tagname_ = 'keywordSet'
        elif nodeName_ == 'additionalInfo':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalInfo.append(obj_)
            obj_.original_tagname_ = 'additionalInfo'
        elif nodeName_ == 'intellectualRights':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intellectualRights = obj_
            obj_.original_tagname_ = 'intellectualRights'
        elif nodeName_ == 'licensed':
            obj_ = LicenseType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.licensed.append(obj_)
            obj_.original_tagname_ = 'licensed'
        elif nodeName_ == 'distribution':
            obj_ = DistributionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distribution.append(obj_)
            obj_.original_tagname_ = 'distribution'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'contact':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact.append(obj_)
            obj_.original_tagname_ = 'contact'
        elif nodeName_ == 'article':
            obj_ = Article.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.article = obj_
            obj_.original_tagname_ = 'article'
        elif nodeName_ == 'book':
            class_obj_ = self.get_class_obj_(child_, Book)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.book = obj_
            obj_.original_tagname_ = 'book'
        elif nodeName_ == 'chapter':
            class_obj_ = self.get_class_obj_(child_, Chapter)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.chapter = obj_
            obj_.original_tagname_ = 'chapter'
        elif nodeName_ == 'editedBook':
            class_obj_ = self.get_class_obj_(child_, Book)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.editedBook = obj_
            obj_.original_tagname_ = 'editedBook'
        elif nodeName_ == 'manuscript':
            obj_ = Manuscript.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manuscript = obj_
            obj_.original_tagname_ = 'manuscript'
        elif nodeName_ == 'report':
            obj_ = Report.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.report = obj_
            obj_.original_tagname_ = 'report'
        elif nodeName_ == 'thesis':
            obj_ = Thesis.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.thesis = obj_
            obj_.original_tagname_ = 'thesis'
        elif nodeName_ == 'conferenceProceedings':
            obj_ = ConferenceProceedings.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.conferenceProceedings = obj_
            obj_.original_tagname_ = 'conferenceProceedings'
        elif nodeName_ == 'personalCommunication':
            obj_ = PersonalCommunication.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.personalCommunication = obj_
            obj_.original_tagname_ = 'personalCommunication'
        elif nodeName_ == 'map':
            obj_ = Map.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.map = obj_
            obj_.original_tagname_ = 'map'
        elif nodeName_ == 'generic':
            obj_ = Generic.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.generic = obj_
            obj_.original_tagname_ = 'generic'
        elif nodeName_ == 'audioVisual':
            obj_ = AudioVisual.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.audioVisual = obj_
            obj_.original_tagname_ = 'audioVisual'
        elif nodeName_ == 'presentation':
            obj_ = Presentation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.presentation = obj_
            obj_.original_tagname_ = 'presentation'
        elif nodeName_ == 'bibtex':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'bibtex')
            value_ = self.gds_validate_string(value_, node, 'bibtex')
            self.bibtex = value_
            self.bibtex_nsprefix_ = child_.prefix
        elif nodeName_ == 'references':
            obj_ = referencesType15.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class CitationType


class Article(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('journal', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'journal', 'type': 'xs:string'}, None),
        MemberSpec_('volume', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'volume', 'type': 'xs:string'}, None),
        MemberSpec_('issue', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'issue', 'type': 'xs:string'}, None),
        MemberSpec_('pageRange', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pageRange', 'type': 'xs:string'}, None),
        MemberSpec_('publisher', 'ResponsibleParty', 0, 1, {'minOccurs': '0', 'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('ISSN', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'ISSN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, journal=None, volume=None, issue=None, pageRange=None, publisher=None, publicationPlace=None, ISSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.journal = journal
        self.validate_NonEmptyStringType(self.journal)
        self.journal_nsprefix_ = None
        self.volume = volume
        self.validate_NonEmptyStringType(self.volume)
        self.volume_nsprefix_ = None
        self.issue = issue
        self.validate_NonEmptyStringType(self.issue)
        self.issue_nsprefix_ = None
        self.pageRange = pageRange
        self.validate_NonEmptyStringType(self.pageRange)
        self.pageRange_nsprefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publicationPlace = publicationPlace
        self.validate_NonEmptyStringType(self.publicationPlace)
        self.publicationPlace_nsprefix_ = None
        self.ISSN = ISSN
        self.validate_NonEmptyStringType(self.ISSN)
        self.ISSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Article)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Article.subclass:
            return Article.subclass(*args_, **kwargs_)
        else:
            return Article(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_journal(self):
        return self.journal
    def set_journal(self, journal):
        self.journal = journal
    def get_volume(self):
        return self.volume
    def set_volume(self, volume):
        self.volume = volume
    def get_issue(self):
        return self.issue
    def set_issue(self, issue):
        self.issue = issue
    def get_pageRange(self):
        return self.pageRange
    def set_pageRange(self, pageRange):
        self.pageRange = pageRange
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def get_ISSN(self):
        return self.ISSN
    def set_ISSN(self, ISSN):
        self.ISSN = ISSN
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.journal is not None or
            self.volume is not None or
            self.issue is not None or
            self.pageRange is not None or
            self.publisher is not None or
            self.publicationPlace is not None or
            self.ISSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Article', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Article')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Article':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Article')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Article', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Article'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Article', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.journal is not None:
            namespaceprefix_ = self.journal_nsprefix_ + ':' if (UseCapturedNS_ and self.journal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjournal>%s</%sjournal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.journal), input_name='journal')), namespaceprefix_ , eol_))
        if self.volume is not None:
            namespaceprefix_ = self.volume_nsprefix_ + ':' if (UseCapturedNS_ and self.volume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), namespaceprefix_ , eol_))
        if self.issue is not None:
            namespaceprefix_ = self.issue_nsprefix_ + ':' if (UseCapturedNS_ and self.issue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sissue>%s</%sissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.issue), input_name='issue')), namespaceprefix_ , eol_))
        if self.pageRange is not None:
            namespaceprefix_ = self.pageRange_nsprefix_ + ':' if (UseCapturedNS_ and self.pageRange_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spageRange>%s</%spageRange>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pageRange), input_name='pageRange')), namespaceprefix_ , eol_))
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.publicationPlace is not None:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publicationPlace), input_name='publicationPlace')), namespaceprefix_ , eol_))
        if self.ISSN is not None:
            namespaceprefix_ = self.ISSN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISSN>%s</%sISSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISSN), input_name='ISSN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'journal':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'journal')
            value_ = self.gds_validate_string(value_, node, 'journal')
            self.journal = value_
            self.journal_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.journal)
        elif nodeName_ == 'volume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'volume')
            value_ = self.gds_validate_string(value_, node, 'volume')
            self.volume = value_
            self.volume_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.volume)
        elif nodeName_ == 'issue':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'issue')
            value_ = self.gds_validate_string(value_, node, 'issue')
            self.issue = value_
            self.issue_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.issue)
        elif nodeName_ == 'pageRange':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pageRange')
            value_ = self.gds_validate_string(value_, node, 'pageRange')
            self.pageRange = value_
            self.pageRange_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.pageRange)
        elif nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace = value_
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace)
        elif nodeName_ == 'ISSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISSN')
            value_ = self.gds_validate_string(value_, node, 'ISSN')
            self.ISSN = value_
            self.ISSN_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.ISSN)
# end class Article


class Book(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('publisher', 'ResponsibleParty', 0, 0, {'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('edition', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'edition', 'type': 'xs:string'}, None),
        MemberSpec_('volume', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'volume', 'type': 'xs:string'}, None),
        MemberSpec_('numberOfVolumes', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'numberOfVolumes', 'type': 'xs:string'}, None),
        MemberSpec_('totalPages', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalPages', 'type': 'xs:string'}, None),
        MemberSpec_('totalFigures', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalFigures', 'type': 'xs:string'}, None),
        MemberSpec_('totalTables', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalTables', 'type': 'xs:string'}, None),
        MemberSpec_('ISBN', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'ISBN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, publisher=None, publicationPlace=None, edition=None, volume=None, numberOfVolumes=None, totalPages=None, totalFigures=None, totalTables=None, ISBN=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publicationPlace = publicationPlace
        self.validate_NonEmptyStringType(self.publicationPlace)
        self.publicationPlace_nsprefix_ = None
        self.edition = edition
        self.validate_NonEmptyStringType(self.edition)
        self.edition_nsprefix_ = None
        self.volume = volume
        self.validate_NonEmptyStringType(self.volume)
        self.volume_nsprefix_ = None
        self.numberOfVolumes = numberOfVolumes
        self.validate_NonEmptyStringType(self.numberOfVolumes)
        self.numberOfVolumes_nsprefix_ = None
        self.totalPages = totalPages
        self.validate_NonEmptyStringType(self.totalPages)
        self.totalPages_nsprefix_ = None
        self.totalFigures = totalFigures
        self.validate_NonEmptyStringType(self.totalFigures)
        self.totalFigures_nsprefix_ = None
        self.totalTables = totalTables
        self.validate_NonEmptyStringType(self.totalTables)
        self.totalTables_nsprefix_ = None
        self.ISBN = ISBN
        self.validate_NonEmptyStringType(self.ISBN)
        self.ISBN_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Book)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Book.subclass:
            return Book.subclass(*args_, **kwargs_)
        else:
            return Book(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def get_edition(self):
        return self.edition
    def set_edition(self, edition):
        self.edition = edition
    def get_volume(self):
        return self.volume
    def set_volume(self, volume):
        self.volume = volume
    def get_numberOfVolumes(self):
        return self.numberOfVolumes
    def set_numberOfVolumes(self, numberOfVolumes):
        self.numberOfVolumes = numberOfVolumes
    def get_totalPages(self):
        return self.totalPages
    def set_totalPages(self, totalPages):
        self.totalPages = totalPages
    def get_totalFigures(self):
        return self.totalFigures
    def set_totalFigures(self, totalFigures):
        self.totalFigures = totalFigures
    def get_totalTables(self):
        return self.totalTables
    def set_totalTables(self, totalTables):
        self.totalTables = totalTables
    def get_ISBN(self):
        return self.ISBN
    def set_ISBN(self, ISBN):
        self.ISBN = ISBN
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.publisher is not None or
            self.publicationPlace is not None or
            self.edition is not None or
            self.volume is not None or
            self.numberOfVolumes is not None or
            self.totalPages is not None or
            self.totalFigures is not None or
            self.totalTables is not None or
            self.ISBN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Book', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Book')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Book':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Book')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Book', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Book'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Book', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.publicationPlace is not None:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publicationPlace), input_name='publicationPlace')), namespaceprefix_ , eol_))
        if self.edition is not None:
            namespaceprefix_ = self.edition_nsprefix_ + ':' if (UseCapturedNS_ and self.edition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sedition>%s</%sedition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.edition), input_name='edition')), namespaceprefix_ , eol_))
        if self.volume is not None:
            namespaceprefix_ = self.volume_nsprefix_ + ':' if (UseCapturedNS_ and self.volume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), namespaceprefix_ , eol_))
        if self.numberOfVolumes is not None:
            namespaceprefix_ = self.numberOfVolumes_nsprefix_ + ':' if (UseCapturedNS_ and self.numberOfVolumes_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumberOfVolumes>%s</%snumberOfVolumes>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.numberOfVolumes), input_name='numberOfVolumes')), namespaceprefix_ , eol_))
        if self.totalPages is not None:
            namespaceprefix_ = self.totalPages_nsprefix_ + ':' if (UseCapturedNS_ and self.totalPages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPages>%s</%stotalPages>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalPages), input_name='totalPages')), namespaceprefix_ , eol_))
        if self.totalFigures is not None:
            namespaceprefix_ = self.totalFigures_nsprefix_ + ':' if (UseCapturedNS_ and self.totalFigures_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalFigures>%s</%stotalFigures>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalFigures), input_name='totalFigures')), namespaceprefix_ , eol_))
        if self.totalTables is not None:
            namespaceprefix_ = self.totalTables_nsprefix_ + ':' if (UseCapturedNS_ and self.totalTables_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalTables>%s</%stotalTables>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalTables), input_name='totalTables')), namespaceprefix_ , eol_))
        if self.ISBN is not None:
            namespaceprefix_ = self.ISBN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISBN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISBN>%s</%sISBN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISBN), input_name='ISBN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace = value_
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace)
        elif nodeName_ == 'edition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'edition')
            value_ = self.gds_validate_string(value_, node, 'edition')
            self.edition = value_
            self.edition_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.edition)
        elif nodeName_ == 'volume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'volume')
            value_ = self.gds_validate_string(value_, node, 'volume')
            self.volume = value_
            self.volume_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.volume)
        elif nodeName_ == 'numberOfVolumes':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'numberOfVolumes')
            value_ = self.gds_validate_string(value_, node, 'numberOfVolumes')
            self.numberOfVolumes = value_
            self.numberOfVolumes_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.numberOfVolumes)
        elif nodeName_ == 'totalPages':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalPages')
            value_ = self.gds_validate_string(value_, node, 'totalPages')
            self.totalPages = value_
            self.totalPages_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalPages)
        elif nodeName_ == 'totalFigures':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalFigures')
            value_ = self.gds_validate_string(value_, node, 'totalFigures')
            self.totalFigures = value_
            self.totalFigures_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalFigures)
        elif nodeName_ == 'totalTables':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalTables')
            value_ = self.gds_validate_string(value_, node, 'totalTables')
            self.totalTables = value_
            self.totalTables_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalTables)
        elif nodeName_ == 'ISBN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISBN')
            value_ = self.gds_validate_string(value_, node, 'ISBN')
            self.ISBN = value_
            self.ISBN_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.ISBN)
# end class Book


class Chapter(Book):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('chapterNumber', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'chapterNumber', 'type': 'xs:string'}, None),
        MemberSpec_('editor', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'editor', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('bookTitle', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'bookTitle', 'type': 'xs:string'}, None),
        MemberSpec_('pageRange', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pageRange', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = Book
    def __init__(self, publisher=None, publicationPlace=None, edition=None, volume=None, numberOfVolumes=None, totalPages=None, totalFigures=None, totalTables=None, ISBN=None, chapterNumber=None, editor=None, bookTitle=None, pageRange=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(Chapter, self).__init__(publisher, publicationPlace, edition, volume, numberOfVolumes, totalPages, totalFigures, totalTables, ISBN, extensiontype_,  **kwargs_)
        self.chapterNumber = chapterNumber
        self.validate_NonEmptyStringType(self.chapterNumber)
        self.chapterNumber_nsprefix_ = None
        if editor is None:
            self.editor = []
        else:
            self.editor = editor
        self.editor_nsprefix_ = None
        self.bookTitle = bookTitle
        self.validate_NonEmptyStringType(self.bookTitle)
        self.bookTitle_nsprefix_ = None
        self.pageRange = pageRange
        self.validate_NonEmptyStringType(self.pageRange)
        self.pageRange_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Chapter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Chapter.subclass:
            return Chapter.subclass(*args_, **kwargs_)
        else:
            return Chapter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_chapterNumber(self):
        return self.chapterNumber
    def set_chapterNumber(self, chapterNumber):
        self.chapterNumber = chapterNumber
    def get_editor(self):
        return self.editor
    def set_editor(self, editor):
        self.editor = editor
    def add_editor(self, value):
        self.editor.append(value)
    def insert_editor_at(self, index, value):
        self.editor.insert(index, value)
    def replace_editor_at(self, index, value):
        self.editor[index] = value
    def get_bookTitle(self):
        return self.bookTitle
    def set_bookTitle(self, bookTitle):
        self.bookTitle = bookTitle
    def get_pageRange(self):
        return self.pageRange
    def set_pageRange(self, pageRange):
        self.pageRange = pageRange
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.chapterNumber is not None or
            self.editor or
            self.bookTitle is not None or
            self.pageRange is not None or
            super(Chapter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Chapter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Chapter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Chapter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Chapter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Chapter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Chapter'):
        super(Chapter, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Chapter')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Chapter', fromsubclass_=False, pretty_print=True):
        super(Chapter, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.chapterNumber is not None:
            namespaceprefix_ = self.chapterNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.chapterNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schapterNumber>%s</%schapterNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chapterNumber), input_name='chapterNumber')), namespaceprefix_ , eol_))
        for editor_ in self.editor:
            namespaceprefix_ = self.editor_nsprefix_ + ':' if (UseCapturedNS_ and self.editor_nsprefix_) else ''
            editor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='editor', pretty_print=pretty_print)
        if self.bookTitle is not None:
            namespaceprefix_ = self.bookTitle_nsprefix_ + ':' if (UseCapturedNS_ and self.bookTitle_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbookTitle>%s</%sbookTitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.bookTitle), input_name='bookTitle')), namespaceprefix_ , eol_))
        if self.pageRange is not None:
            namespaceprefix_ = self.pageRange_nsprefix_ + ':' if (UseCapturedNS_ and self.pageRange_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spageRange>%s</%spageRange>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pageRange), input_name='pageRange')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Chapter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'chapterNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'chapterNumber')
            value_ = self.gds_validate_string(value_, node, 'chapterNumber')
            self.chapterNumber = value_
            self.chapterNumber_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.chapterNumber)
        elif nodeName_ == 'editor':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.editor.append(obj_)
            obj_.original_tagname_ = 'editor'
        elif nodeName_ == 'bookTitle':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'bookTitle')
            value_ = self.gds_validate_string(value_, node, 'bookTitle')
            self.bookTitle = value_
            self.bookTitle_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.bookTitle)
        elif nodeName_ == 'pageRange':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pageRange')
            value_ = self.gds_validate_string(value_, node, 'pageRange')
            self.pageRange = value_
            self.pageRange_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.pageRange)
        super(Chapter, self).buildChildren(child_, node, nodeName_, True)
# end class Chapter


class ConferenceProceedings(Chapter):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('conferenceName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'conferenceName', 'type': 'xs:string'}, None),
        MemberSpec_('conferenceDate', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'conferenceDate', 'type': 'xs:string'}, None),
        MemberSpec_('conferenceLocation', 'Address', 0, 1, {'minOccurs': '0', 'name': 'conferenceLocation', 'type': 'Address'}, None),
    ]
    subclass = None
    superclass = Chapter
    def __init__(self, publisher=None, publicationPlace=None, edition=None, volume=None, numberOfVolumes=None, totalPages=None, totalFigures=None, totalTables=None, ISBN=None, chapterNumber=None, editor=None, bookTitle=None, pageRange=None, conferenceName=None, conferenceDate=None, conferenceLocation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(ConferenceProceedings, self).__init__(publisher, publicationPlace, edition, volume, numberOfVolumes, totalPages, totalFigures, totalTables, ISBN, chapterNumber, editor, bookTitle, pageRange,  **kwargs_)
        self.conferenceName = conferenceName
        self.validate_NonEmptyStringType(self.conferenceName)
        self.conferenceName_nsprefix_ = None
        self.conferenceDate = conferenceDate
        self.validate_NonEmptyStringType(self.conferenceDate)
        self.conferenceDate_nsprefix_ = None
        self.conferenceLocation = conferenceLocation
        self.conferenceLocation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConferenceProceedings)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConferenceProceedings.subclass:
            return ConferenceProceedings.subclass(*args_, **kwargs_)
        else:
            return ConferenceProceedings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_conferenceName(self):
        return self.conferenceName
    def set_conferenceName(self, conferenceName):
        self.conferenceName = conferenceName
    def get_conferenceDate(self):
        return self.conferenceDate
    def set_conferenceDate(self, conferenceDate):
        self.conferenceDate = conferenceDate
    def get_conferenceLocation(self):
        return self.conferenceLocation
    def set_conferenceLocation(self, conferenceLocation):
        self.conferenceLocation = conferenceLocation
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.conferenceName is not None or
            self.conferenceDate is not None or
            self.conferenceLocation is not None or
            super(ConferenceProceedings, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='ConferenceProceedings', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConferenceProceedings')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ConferenceProceedings':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConferenceProceedings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ConferenceProceedings', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ConferenceProceedings'):
        super(ConferenceProceedings, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConferenceProceedings')
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='ConferenceProceedings', fromsubclass_=False, pretty_print=True):
        super(ConferenceProceedings, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.conferenceName is not None:
            namespaceprefix_ = self.conferenceName_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconferenceName>%s</%sconferenceName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.conferenceName), input_name='conferenceName')), namespaceprefix_ , eol_))
        if self.conferenceDate is not None:
            namespaceprefix_ = self.conferenceDate_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconferenceDate>%s</%sconferenceDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.conferenceDate), input_name='conferenceDate')), namespaceprefix_ , eol_))
        if self.conferenceLocation is not None:
            namespaceprefix_ = self.conferenceLocation_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceLocation_nsprefix_) else ''
            self.conferenceLocation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='conferenceLocation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ConferenceProceedings, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'conferenceName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'conferenceName')
            value_ = self.gds_validate_string(value_, node, 'conferenceName')
            self.conferenceName = value_
            self.conferenceName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.conferenceName)
        elif nodeName_ == 'conferenceDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'conferenceDate')
            value_ = self.gds_validate_string(value_, node, 'conferenceDate')
            self.conferenceDate = value_
            self.conferenceDate_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.conferenceDate)
        elif nodeName_ == 'conferenceLocation':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.conferenceLocation = obj_
            obj_.original_tagname_ = 'conferenceLocation'
        super(ConferenceProceedings, self).buildChildren(child_, node, nodeName_, True)
# end class ConferenceProceedings


class Manuscript(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('institution', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'institution', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('totalPages', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalPages', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, institution=None, totalPages=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if institution is None:
            self.institution = []
        else:
            self.institution = institution
        self.institution_nsprefix_ = None
        self.totalPages = totalPages
        self.validate_NonEmptyStringType(self.totalPages)
        self.totalPages_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Manuscript)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Manuscript.subclass:
            return Manuscript.subclass(*args_, **kwargs_)
        else:
            return Manuscript(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_institution(self):
        return self.institution
    def set_institution(self, institution):
        self.institution = institution
    def add_institution(self, value):
        self.institution.append(value)
    def insert_institution_at(self, index, value):
        self.institution.insert(index, value)
    def replace_institution_at(self, index, value):
        self.institution[index] = value
    def get_totalPages(self):
        return self.totalPages
    def set_totalPages(self, totalPages):
        self.totalPages = totalPages
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.institution or
            self.totalPages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Manuscript', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Manuscript')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Manuscript':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Manuscript')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Manuscript', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Manuscript'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='Manuscript', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for institution_ in self.institution:
            namespaceprefix_ = self.institution_nsprefix_ + ':' if (UseCapturedNS_ and self.institution_nsprefix_) else ''
            institution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='institution', pretty_print=pretty_print)
        if self.totalPages is not None:
            namespaceprefix_ = self.totalPages_nsprefix_ + ':' if (UseCapturedNS_ and self.totalPages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPages>%s</%stotalPages>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalPages), input_name='totalPages')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'institution':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.institution.append(obj_)
            obj_.original_tagname_ = 'institution'
        elif nodeName_ == 'totalPages':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalPages')
            value_ = self.gds_validate_string(value_, node, 'totalPages')
            self.totalPages = value_
            self.totalPages_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalPages)
# end class Manuscript


class Report(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('reportNumber', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'reportNumber', 'type': 'xs:string'}, None),
        MemberSpec_('publisher', 'ResponsibleParty', 0, 1, {'minOccurs': '0', 'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('totalPages', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalPages', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, reportNumber=None, publisher=None, publicationPlace=None, totalPages=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.reportNumber = reportNumber
        self.validate_NonEmptyStringType(self.reportNumber)
        self.reportNumber_nsprefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publicationPlace = publicationPlace
        self.validate_NonEmptyStringType(self.publicationPlace)
        self.publicationPlace_nsprefix_ = None
        self.totalPages = totalPages
        self.validate_NonEmptyStringType(self.totalPages)
        self.totalPages_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Report)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Report.subclass:
            return Report.subclass(*args_, **kwargs_)
        else:
            return Report(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_reportNumber(self):
        return self.reportNumber
    def set_reportNumber(self, reportNumber):
        self.reportNumber = reportNumber
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def get_totalPages(self):
        return self.totalPages
    def set_totalPages(self, totalPages):
        self.totalPages = totalPages
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.reportNumber is not None or
            self.publisher is not None or
            self.publicationPlace is not None or
            self.totalPages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Report', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Report')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Report':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Report')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Report', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Report'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Report', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.reportNumber is not None:
            namespaceprefix_ = self.reportNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.reportNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreportNumber>%s</%sreportNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reportNumber), input_name='reportNumber')), namespaceprefix_ , eol_))
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.publicationPlace is not None:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publicationPlace), input_name='publicationPlace')), namespaceprefix_ , eol_))
        if self.totalPages is not None:
            namespaceprefix_ = self.totalPages_nsprefix_ + ':' if (UseCapturedNS_ and self.totalPages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPages>%s</%stotalPages>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalPages), input_name='totalPages')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'reportNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reportNumber')
            value_ = self.gds_validate_string(value_, node, 'reportNumber')
            self.reportNumber = value_
            self.reportNumber_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.reportNumber)
        elif nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace = value_
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace)
        elif nodeName_ == 'totalPages':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalPages')
            value_ = self.gds_validate_string(value_, node, 'totalPages')
            self.totalPages = value_
            self.totalPages_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalPages)
# end class Report


class PersonalCommunication(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('publisher', 'ResponsibleParty', 0, 1, {'minOccurs': '0', 'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('communicationType', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'communicationType', 'type': 'xs:string'}, None),
        MemberSpec_('recipient', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'recipient', 'type': 'ResponsibleParty'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, publisher=None, publicationPlace=None, communicationType=None, recipient=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publicationPlace = publicationPlace
        self.validate_NonEmptyStringType(self.publicationPlace)
        self.publicationPlace_nsprefix_ = None
        self.communicationType = communicationType
        self.validate_NonEmptyStringType(self.communicationType)
        self.communicationType_nsprefix_ = None
        if recipient is None:
            self.recipient = []
        else:
            self.recipient = recipient
        self.recipient_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PersonalCommunication)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PersonalCommunication.subclass:
            return PersonalCommunication.subclass(*args_, **kwargs_)
        else:
            return PersonalCommunication(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def get_communicationType(self):
        return self.communicationType
    def set_communicationType(self, communicationType):
        self.communicationType = communicationType
    def get_recipient(self):
        return self.recipient
    def set_recipient(self, recipient):
        self.recipient = recipient
    def add_recipient(self, value):
        self.recipient.append(value)
    def insert_recipient_at(self, index, value):
        self.recipient.insert(index, value)
    def replace_recipient_at(self, index, value):
        self.recipient[index] = value
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.publisher is not None or
            self.publicationPlace is not None or
            self.communicationType is not None or
            self.recipient
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='PersonalCommunication', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PersonalCommunication')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PersonalCommunication':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PersonalCommunication')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PersonalCommunication', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PersonalCommunication'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='PersonalCommunication', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.publicationPlace is not None:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publicationPlace), input_name='publicationPlace')), namespaceprefix_ , eol_))
        if self.communicationType is not None:
            namespaceprefix_ = self.communicationType_nsprefix_ + ':' if (UseCapturedNS_ and self.communicationType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scommunicationType>%s</%scommunicationType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.communicationType), input_name='communicationType')), namespaceprefix_ , eol_))
        for recipient_ in self.recipient:
            namespaceprefix_ = self.recipient_nsprefix_ + ':' if (UseCapturedNS_ and self.recipient_nsprefix_) else ''
            recipient_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recipient', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace = value_
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace)
        elif nodeName_ == 'communicationType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'communicationType')
            value_ = self.gds_validate_string(value_, node, 'communicationType')
            self.communicationType = value_
            self.communicationType_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.communicationType)
        elif nodeName_ == 'recipient':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recipient.append(obj_)
            obj_.original_tagname_ = 'recipient'
# end class PersonalCommunication


class Map(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('publisher', 'ResponsibleParty', 0, 1, {'minOccurs': '0', 'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('edition', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'edition', 'type': 'xs:string'}, None),
        MemberSpec_('geographicCoverage', 'GeographicCoverage', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'geographicCoverage', 'type': 'GeographicCoverage'}, None),
        MemberSpec_('scale', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'scale', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, publisher=None, edition=None, geographicCoverage=None, scale=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.edition = edition
        self.validate_NonEmptyStringType(self.edition)
        self.edition_nsprefix_ = None
        if geographicCoverage is None:
            self.geographicCoverage = []
        else:
            self.geographicCoverage = geographicCoverage
        self.geographicCoverage_nsprefix_ = None
        self.scale = scale
        self.validate_NonEmptyStringType(self.scale)
        self.scale_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Map)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Map.subclass:
            return Map.subclass(*args_, **kwargs_)
        else:
            return Map(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_edition(self):
        return self.edition
    def set_edition(self, edition):
        self.edition = edition
    def get_geographicCoverage(self):
        return self.geographicCoverage
    def set_geographicCoverage(self, geographicCoverage):
        self.geographicCoverage = geographicCoverage
    def add_geographicCoverage(self, value):
        self.geographicCoverage.append(value)
    def insert_geographicCoverage_at(self, index, value):
        self.geographicCoverage.insert(index, value)
    def replace_geographicCoverage_at(self, index, value):
        self.geographicCoverage[index] = value
    def get_scale(self):
        return self.scale
    def set_scale(self, scale):
        self.scale = scale
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.publisher is not None or
            self.edition is not None or
            self.geographicCoverage or
            self.scale is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0" ', name_='Map', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Map')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Map':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Map')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Map', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Map'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0" ', name_='Map', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.edition is not None:
            namespaceprefix_ = self.edition_nsprefix_ + ':' if (UseCapturedNS_ and self.edition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sedition>%s</%sedition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.edition), input_name='edition')), namespaceprefix_ , eol_))
        for geographicCoverage_ in self.geographicCoverage:
            namespaceprefix_ = self.geographicCoverage_nsprefix_ + ':' if (UseCapturedNS_ and self.geographicCoverage_nsprefix_) else ''
            geographicCoverage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='geographicCoverage', pretty_print=pretty_print)
        if self.scale is not None:
            namespaceprefix_ = self.scale_nsprefix_ + ':' if (UseCapturedNS_ and self.scale_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscale>%s</%sscale>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.scale), input_name='scale')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'edition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'edition')
            value_ = self.gds_validate_string(value_, node, 'edition')
            self.edition = value_
            self.edition_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.edition)
        elif nodeName_ == 'geographicCoverage':
            obj_ = GeographicCoverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.geographicCoverage.append(obj_)
            obj_.original_tagname_ = 'geographicCoverage'
        elif nodeName_ == 'scale':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'scale')
            value_ = self.gds_validate_string(value_, node, 'scale')
            self.scale = value_
            self.scale_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.scale)
# end class Map


class AudioVisual(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('publisher', 'ResponsibleParty', 0, 0, {'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('performer', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'performer', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('ISBN', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'ISBN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, publisher=None, publicationPlace=None, performer=None, ISBN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        if publicationPlace is None:
            self.publicationPlace = []
        else:
            self.publicationPlace = publicationPlace
        self.publicationPlace_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        self.ISBN = ISBN
        self.validate_NonEmptyStringType(self.ISBN)
        self.ISBN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AudioVisual)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AudioVisual.subclass:
            return AudioVisual.subclass(*args_, **kwargs_)
        else:
            return AudioVisual(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def add_publicationPlace(self, value):
        self.publicationPlace.append(value)
    def insert_publicationPlace_at(self, index, value):
        self.publicationPlace.insert(index, value)
    def replace_publicationPlace_at(self, index, value):
        self.publicationPlace[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_ISBN(self):
        return self.ISBN
    def set_ISBN(self, ISBN):
        self.ISBN = ISBN
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.publisher is not None or
            self.publicationPlace or
            self.performer or
            self.ISBN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='AudioVisual', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AudioVisual')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AudioVisual':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AudioVisual')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AudioVisual', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AudioVisual'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='AudioVisual', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        for publicationPlace_ in self.publicationPlace:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(publicationPlace_), input_name='publicationPlace')), namespaceprefix_ , eol_))
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        if self.ISBN is not None:
            namespaceprefix_ = self.ISBN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISBN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISBN>%s</%sISBN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISBN), input_name='ISBN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace.append(value_)
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace[-1])
        elif nodeName_ == 'performer':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'ISBN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISBN')
            value_ = self.gds_validate_string(value_, node, 'ISBN')
            self.ISBN = value_
            self.ISBN_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.ISBN)
# end class AudioVisual


class Generic(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('publisher', 'ResponsibleParty', 0, 0, {'name': 'publisher', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('publicationPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'publicationPlace', 'type': 'xs:string'}, None),
        MemberSpec_('referenceType', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'referenceType', 'type': 'xs:string'}, None),
        MemberSpec_('volume', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'volume', 'type': 'xs:string'}, None),
        MemberSpec_('numberOfVolumes', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'numberOfVolumes', 'type': 'xs:string'}, None),
        MemberSpec_('totalPages', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalPages', 'type': 'xs:string'}, None),
        MemberSpec_('totalFigures', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalFigures', 'type': 'xs:string'}, None),
        MemberSpec_('totalTables', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalTables', 'type': 'xs:string'}, None),
        MemberSpec_('edition', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'edition', 'type': 'xs:string'}, None),
        MemberSpec_('originalPublication', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'originalPublication', 'type': 'xs:string'}, None),
        MemberSpec_('reprintEdition', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'reprintEdition', 'type': 'xs:string'}, None),
        MemberSpec_('reviewedItem', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'reviewedItem', 'type': 'xs:string'}, None),
        MemberSpec_('ISBN', ['NonEmptyStringType', 'xs:string'], 0, 1, {'name': 'ISBN', 'type': 'xs:string'}, 23),
        MemberSpec_('ISSN', ['NonEmptyStringType', 'xs:string'], 0, 1, {'name': 'ISSN', 'type': 'xs:string'}, 23),
    ]
    subclass = None
    superclass = None
    def __init__(self, publisher=None, publicationPlace=None, referenceType=None, volume=None, numberOfVolumes=None, totalPages=None, totalFigures=None, totalTables=None, edition=None, originalPublication=None, reprintEdition=None, reviewedItem=None, ISBN=None, ISSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publicationPlace = publicationPlace
        self.validate_NonEmptyStringType(self.publicationPlace)
        self.publicationPlace_nsprefix_ = None
        self.referenceType = referenceType
        self.referenceType_nsprefix_ = None
        self.volume = volume
        self.validate_NonEmptyStringType(self.volume)
        self.volume_nsprefix_ = None
        self.numberOfVolumes = numberOfVolumes
        self.validate_NonEmptyStringType(self.numberOfVolumes)
        self.numberOfVolumes_nsprefix_ = None
        self.totalPages = totalPages
        self.validate_NonEmptyStringType(self.totalPages)
        self.totalPages_nsprefix_ = None
        self.totalFigures = totalFigures
        self.validate_NonEmptyStringType(self.totalFigures)
        self.totalFigures_nsprefix_ = None
        self.totalTables = totalTables
        self.validate_NonEmptyStringType(self.totalTables)
        self.totalTables_nsprefix_ = None
        self.edition = edition
        self.validate_NonEmptyStringType(self.edition)
        self.edition_nsprefix_ = None
        self.originalPublication = originalPublication
        self.validate_NonEmptyStringType(self.originalPublication)
        self.originalPublication_nsprefix_ = None
        self.reprintEdition = reprintEdition
        self.validate_NonEmptyStringType(self.reprintEdition)
        self.reprintEdition_nsprefix_ = None
        self.reviewedItem = reviewedItem
        self.validate_NonEmptyStringType(self.reviewedItem)
        self.reviewedItem_nsprefix_ = None
        self.ISBN = ISBN
        self.validate_NonEmptyStringType(self.ISBN)
        self.ISBN_nsprefix_ = None
        self.ISSN = ISSN
        self.validate_NonEmptyStringType(self.ISSN)
        self.ISSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Generic)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Generic.subclass:
            return Generic.subclass(*args_, **kwargs_)
        else:
            return Generic(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publicationPlace(self):
        return self.publicationPlace
    def set_publicationPlace(self, publicationPlace):
        self.publicationPlace = publicationPlace
    def get_referenceType(self):
        return self.referenceType
    def set_referenceType(self, referenceType):
        self.referenceType = referenceType
    def get_volume(self):
        return self.volume
    def set_volume(self, volume):
        self.volume = volume
    def get_numberOfVolumes(self):
        return self.numberOfVolumes
    def set_numberOfVolumes(self, numberOfVolumes):
        self.numberOfVolumes = numberOfVolumes
    def get_totalPages(self):
        return self.totalPages
    def set_totalPages(self, totalPages):
        self.totalPages = totalPages
    def get_totalFigures(self):
        return self.totalFigures
    def set_totalFigures(self, totalFigures):
        self.totalFigures = totalFigures
    def get_totalTables(self):
        return self.totalTables
    def set_totalTables(self, totalTables):
        self.totalTables = totalTables
    def get_edition(self):
        return self.edition
    def set_edition(self, edition):
        self.edition = edition
    def get_originalPublication(self):
        return self.originalPublication
    def set_originalPublication(self, originalPublication):
        self.originalPublication = originalPublication
    def get_reprintEdition(self):
        return self.reprintEdition
    def set_reprintEdition(self, reprintEdition):
        self.reprintEdition = reprintEdition
    def get_reviewedItem(self):
        return self.reviewedItem
    def set_reviewedItem(self, reviewedItem):
        self.reviewedItem = reviewedItem
    def get_ISBN(self):
        return self.ISBN
    def set_ISBN(self, ISBN):
        self.ISBN = ISBN
    def get_ISSN(self):
        return self.ISSN
    def set_ISSN(self, ISSN):
        self.ISSN = ISSN
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.publisher is not None or
            self.publicationPlace is not None or
            self.referenceType is not None or
            self.volume is not None or
            self.numberOfVolumes is not None or
            self.totalPages is not None or
            self.totalFigures is not None or
            self.totalTables is not None or
            self.edition is not None or
            self.originalPublication is not None or
            self.reprintEdition is not None or
            self.reviewedItem is not None or
            self.ISBN is not None or
            self.ISSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Generic', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Generic')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Generic':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Generic')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Generic', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Generic'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Generic', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.publicationPlace is not None:
            namespaceprefix_ = self.publicationPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.publicationPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicationPlace>%s</%spublicationPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publicationPlace), input_name='publicationPlace')), namespaceprefix_ , eol_))
        if self.referenceType is not None:
            namespaceprefix_ = self.referenceType_nsprefix_ + ':' if (UseCapturedNS_ and self.referenceType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreferenceType>%s</%sreferenceType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.referenceType), input_name='referenceType')), namespaceprefix_ , eol_))
        if self.volume is not None:
            namespaceprefix_ = self.volume_nsprefix_ + ':' if (UseCapturedNS_ and self.volume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), namespaceprefix_ , eol_))
        if self.numberOfVolumes is not None:
            namespaceprefix_ = self.numberOfVolumes_nsprefix_ + ':' if (UseCapturedNS_ and self.numberOfVolumes_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumberOfVolumes>%s</%snumberOfVolumes>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.numberOfVolumes), input_name='numberOfVolumes')), namespaceprefix_ , eol_))
        if self.totalPages is not None:
            namespaceprefix_ = self.totalPages_nsprefix_ + ':' if (UseCapturedNS_ and self.totalPages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPages>%s</%stotalPages>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalPages), input_name='totalPages')), namespaceprefix_ , eol_))
        if self.totalFigures is not None:
            namespaceprefix_ = self.totalFigures_nsprefix_ + ':' if (UseCapturedNS_ and self.totalFigures_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalFigures>%s</%stotalFigures>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalFigures), input_name='totalFigures')), namespaceprefix_ , eol_))
        if self.totalTables is not None:
            namespaceprefix_ = self.totalTables_nsprefix_ + ':' if (UseCapturedNS_ and self.totalTables_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalTables>%s</%stotalTables>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalTables), input_name='totalTables')), namespaceprefix_ , eol_))
        if self.edition is not None:
            namespaceprefix_ = self.edition_nsprefix_ + ':' if (UseCapturedNS_ and self.edition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sedition>%s</%sedition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.edition), input_name='edition')), namespaceprefix_ , eol_))
        if self.originalPublication is not None:
            namespaceprefix_ = self.originalPublication_nsprefix_ + ':' if (UseCapturedNS_ and self.originalPublication_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soriginalPublication>%s</%soriginalPublication>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.originalPublication), input_name='originalPublication')), namespaceprefix_ , eol_))
        if self.reprintEdition is not None:
            namespaceprefix_ = self.reprintEdition_nsprefix_ + ':' if (UseCapturedNS_ and self.reprintEdition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreprintEdition>%s</%sreprintEdition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reprintEdition), input_name='reprintEdition')), namespaceprefix_ , eol_))
        if self.reviewedItem is not None:
            namespaceprefix_ = self.reviewedItem_nsprefix_ + ':' if (UseCapturedNS_ and self.reviewedItem_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreviewedItem>%s</%sreviewedItem>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.reviewedItem), input_name='reviewedItem')), namespaceprefix_ , eol_))
        if self.ISBN is not None:
            namespaceprefix_ = self.ISBN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISBN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISBN>%s</%sISBN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISBN), input_name='ISBN')), namespaceprefix_ , eol_))
        if self.ISSN is not None:
            namespaceprefix_ = self.ISSN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISSN>%s</%sISSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISSN), input_name='ISSN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'publicationPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'publicationPlace')
            value_ = self.gds_validate_string(value_, node, 'publicationPlace')
            self.publicationPlace = value_
            self.publicationPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.publicationPlace)
        elif nodeName_ == 'referenceType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'referenceType')
            value_ = self.gds_validate_string(value_, node, 'referenceType')
            self.referenceType = value_
            self.referenceType_nsprefix_ = child_.prefix
        elif nodeName_ == 'volume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'volume')
            value_ = self.gds_validate_string(value_, node, 'volume')
            self.volume = value_
            self.volume_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.volume)
        elif nodeName_ == 'numberOfVolumes':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'numberOfVolumes')
            value_ = self.gds_validate_string(value_, node, 'numberOfVolumes')
            self.numberOfVolumes = value_
            self.numberOfVolumes_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.numberOfVolumes)
        elif nodeName_ == 'totalPages':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalPages')
            value_ = self.gds_validate_string(value_, node, 'totalPages')
            self.totalPages = value_
            self.totalPages_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalPages)
        elif nodeName_ == 'totalFigures':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalFigures')
            value_ = self.gds_validate_string(value_, node, 'totalFigures')
            self.totalFigures = value_
            self.totalFigures_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalFigures)
        elif nodeName_ == 'totalTables':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalTables')
            value_ = self.gds_validate_string(value_, node, 'totalTables')
            self.totalTables = value_
            self.totalTables_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalTables)
        elif nodeName_ == 'edition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'edition')
            value_ = self.gds_validate_string(value_, node, 'edition')
            self.edition = value_
            self.edition_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.edition)
        elif nodeName_ == 'originalPublication':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'originalPublication')
            value_ = self.gds_validate_string(value_, node, 'originalPublication')
            self.originalPublication = value_
            self.originalPublication_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.originalPublication)
        elif nodeName_ == 'reprintEdition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reprintEdition')
            value_ = self.gds_validate_string(value_, node, 'reprintEdition')
            self.reprintEdition = value_
            self.reprintEdition_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.reprintEdition)
        elif nodeName_ == 'reviewedItem':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'reviewedItem')
            value_ = self.gds_validate_string(value_, node, 'reviewedItem')
            self.reviewedItem = value_
            self.reviewedItem_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.reviewedItem)
        elif nodeName_ == 'ISBN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISBN')
            value_ = self.gds_validate_string(value_, node, 'ISBN')
            self.ISBN = value_
            self.ISBN_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.ISBN)
        elif nodeName_ == 'ISSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISSN')
            value_ = self.gds_validate_string(value_, node, 'ISSN')
            self.ISSN = value_
            self.ISSN_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.ISSN)
# end class Generic


class referenceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, referenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if referenceType.subclass:
            return referenceType.subclass(*args_, **kwargs_)
        else:
            return referenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='referenceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('referenceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'referenceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='referenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='referenceType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='referenceType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0"', name_='referenceType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class referenceType


class Thesis(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('degree', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'degree', 'type': 'xs:string'}, None),
        MemberSpec_('institution', 'ResponsibleParty', 0, 0, {'name': 'institution', 'type': 'ResponsibleParty'}, None),
        MemberSpec_('totalPages', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'totalPages', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, degree=None, institution=None, totalPages=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.degree = degree
        self.validate_NonEmptyStringType(self.degree)
        self.degree_nsprefix_ = None
        self.institution = institution
        self.institution_nsprefix_ = None
        self.totalPages = totalPages
        self.validate_NonEmptyStringType(self.totalPages)
        self.totalPages_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Thesis)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Thesis.subclass:
            return Thesis.subclass(*args_, **kwargs_)
        else:
            return Thesis(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_degree(self):
        return self.degree
    def set_degree(self, degree):
        self.degree = degree
    def get_institution(self):
        return self.institution
    def set_institution(self, institution):
        self.institution = institution
    def get_totalPages(self):
        return self.totalPages
    def set_totalPages(self, totalPages):
        self.totalPages = totalPages
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.degree is not None or
            self.institution is not None or
            self.totalPages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Thesis', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Thesis')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Thesis':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Thesis')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Thesis', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Thesis'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Thesis', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.degree is not None:
            namespaceprefix_ = self.degree_nsprefix_ + ':' if (UseCapturedNS_ and self.degree_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdegree>%s</%sdegree>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.degree), input_name='degree')), namespaceprefix_ , eol_))
        if self.institution is not None:
            namespaceprefix_ = self.institution_nsprefix_ + ':' if (UseCapturedNS_ and self.institution_nsprefix_) else ''
            self.institution.export(outfile, level, namespaceprefix_, namespacedef_='', name_='institution', pretty_print=pretty_print)
        if self.totalPages is not None:
            namespaceprefix_ = self.totalPages_nsprefix_ + ':' if (UseCapturedNS_ and self.totalPages_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPages>%s</%stotalPages>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.totalPages), input_name='totalPages')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'degree':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'degree')
            value_ = self.gds_validate_string(value_, node, 'degree')
            self.degree = value_
            self.degree_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.degree)
        elif nodeName_ == 'institution':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.institution = obj_
            obj_.original_tagname_ = 'institution'
        elif nodeName_ == 'totalPages':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'totalPages')
            value_ = self.gds_validate_string(value_, node, 'totalPages')
            self.totalPages = value_
            self.totalPages_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.totalPages)
# end class Thesis


class Presentation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('conferenceName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'conferenceName', 'type': 'xs:string'}, None),
        MemberSpec_('conferenceDate', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'conferenceDate', 'type': 'xs:string'}, None),
        MemberSpec_('conferenceLocation', 'Address', 0, 1, {'minOccurs': '0', 'name': 'conferenceLocation', 'type': 'Address'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, conferenceName=None, conferenceDate=None, conferenceLocation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.conferenceName = conferenceName
        self.validate_NonEmptyStringType(self.conferenceName)
        self.conferenceName_nsprefix_ = None
        self.conferenceDate = conferenceDate
        self.validate_NonEmptyStringType(self.conferenceDate)
        self.conferenceDate_nsprefix_ = None
        self.conferenceLocation = conferenceLocation
        self.conferenceLocation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Presentation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Presentation.subclass:
            return Presentation.subclass(*args_, **kwargs_)
        else:
            return Presentation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_conferenceName(self):
        return self.conferenceName
    def set_conferenceName(self, conferenceName):
        self.conferenceName = conferenceName
    def get_conferenceDate(self):
        return self.conferenceDate
    def set_conferenceDate(self, conferenceDate):
        self.conferenceDate = conferenceDate
    def get_conferenceLocation(self):
        return self.conferenceLocation
    def set_conferenceLocation(self, conferenceLocation):
        self.conferenceLocation = conferenceLocation
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.conferenceName is not None or
            self.conferenceDate is not None or
            self.conferenceLocation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Presentation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Presentation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Presentation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Presentation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Presentation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Presentation'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0" ', name_='Presentation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.conferenceName is not None:
            namespaceprefix_ = self.conferenceName_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconferenceName>%s</%sconferenceName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.conferenceName), input_name='conferenceName')), namespaceprefix_ , eol_))
        if self.conferenceDate is not None:
            namespaceprefix_ = self.conferenceDate_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconferenceDate>%s</%sconferenceDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.conferenceDate), input_name='conferenceDate')), namespaceprefix_ , eol_))
        if self.conferenceLocation is not None:
            namespaceprefix_ = self.conferenceLocation_nsprefix_ + ':' if (UseCapturedNS_ and self.conferenceLocation_nsprefix_) else ''
            self.conferenceLocation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='conferenceLocation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'conferenceName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'conferenceName')
            value_ = self.gds_validate_string(value_, node, 'conferenceName')
            self.conferenceName = value_
            self.conferenceName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.conferenceName)
        elif nodeName_ == 'conferenceDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'conferenceDate')
            value_ = self.gds_validate_string(value_, node, 'conferenceDate')
            self.conferenceDate = value_
            self.conferenceDate_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.conferenceDate)
        elif nodeName_ == 'conferenceLocation':
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.conferenceLocation = obj_
            obj_.original_tagname_ = 'conferenceLocation'
# end class Presentation


class CitationListType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('citation', 'CitationType', 1, 0, {'name': 'citation', 'type': 'CitationType'}, 24),
        MemberSpec_('bibtex', 'xs:string', 1, 0, {'name': 'bibtex', 'type': 'xs:string'}, 24),
    ]
    subclass = None
    superclass = None
    def __init__(self, citation=None, bibtex=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if citation is None:
            self.citation = []
        else:
            self.citation = citation
        self.citation_nsprefix_ = None
        if bibtex is None:
            self.bibtex = []
        else:
            self.bibtex = bibtex
        self.bibtex_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CitationListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CitationListType.subclass:
            return CitationListType.subclass(*args_, **kwargs_)
        else:
            return CitationListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_citation(self):
        return self.citation
    def set_citation(self, citation):
        self.citation = citation
    def add_citation(self, value):
        self.citation.append(value)
    def insert_citation_at(self, index, value):
        self.citation.insert(index, value)
    def replace_citation_at(self, index, value):
        self.citation[index] = value
    def get_bibtex(self):
        return self.bibtex
    def set_bibtex(self, bibtex):
        self.bibtex = bibtex
    def add_bibtex(self, value):
        self.bibtex.append(value)
    def insert_bibtex_at(self, index, value):
        self.bibtex.insert(index, value)
    def replace_bibtex_at(self, index, value):
        self.bibtex[index] = value
    def hasContent_(self):
        if (
            self.citation or
            self.bibtex
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='CitationListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CitationListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CitationListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CitationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CitationListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CitationListType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='CitationListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for citation_ in self.citation:
            namespaceprefix_ = self.citation_nsprefix_ + ':' if (UseCapturedNS_ and self.citation_nsprefix_) else ''
            citation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='citation', pretty_print=pretty_print)
        for bibtex_ in self.bibtex:
            namespaceprefix_ = self.bibtex_nsprefix_ + ':' if (UseCapturedNS_ and self.bibtex_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbibtex>%s</%sbibtex>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(bibtex_), input_name='bibtex')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'citation':
            obj_ = CitationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.citation.append(obj_)
            obj_.original_tagname_ = 'citation'
        elif nodeName_ == 'bibtex':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'bibtex')
            value_ = self.gds_validate_string(value_, node, 'bibtex')
            self.bibtex.append(value_)
            self.bibtex_nsprefix_ = child_.prefix
# end class CitationListType


class AccessType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('order', 'orderType', 0, 1, {'use': 'optional'}),
        MemberSpec_('authSystem', 'xs:string', 0, 0, {'use': 'required'}),
        MemberSpec_('allow', 'AccessRule', 1, 0, {'name': 'allow', 'type': 'AccessRule'}, 26),
        MemberSpec_('deny', 'AccessRule', 1, 0, {'name': 'deny', 'type': 'AccessRule'}, 26),
        MemberSpec_('references', 'referencesType16', 0, 0, {'name': 'references', 'type': 'referencesType16'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', order='allowFirst', authSystem=None, allow=None, deny=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.order = _cast(None, order)
        self.order_nsprefix_ = None
        self.authSystem = _cast(None, authSystem)
        self.authSystem_nsprefix_ = None
        if allow is None:
            self.allow = []
        else:
            self.allow = allow
        self.allow_nsprefix_ = None
        if deny is None:
            self.deny = []
        else:
            self.deny = deny
        self.deny_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessType.subclass:
            return AccessType.subclass(*args_, **kwargs_)
        else:
            return AccessType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_allow(self):
        return self.allow
    def set_allow(self, allow):
        self.allow = allow
    def add_allow(self, value):
        self.allow.append(value)
    def insert_allow_at(self, index, value):
        self.allow.insert(index, value)
    def replace_allow_at(self, index, value):
        self.allow[index] = value
    def get_deny(self):
        return self.deny
    def set_deny(self, deny):
        self.deny = deny
    def add_deny(self, value):
        self.deny.append(value)
    def insert_deny_at(self, index, value):
        self.deny.insert(index, value)
    def replace_deny_at(self, index, value):
        self.deny[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def get_order(self):
        return self.order
    def set_order(self, order):
        self.order = order
    def get_authSystem(self):
        return self.authSystem
    def set_authSystem(self, authSystem):
        self.authSystem = authSystem
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_orderType(self, value):
        # Validate type orderType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['allowFirst', 'denyFirst']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on orderType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.allow or
            self.deny or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AccessType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AccessType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AccessType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AccessType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AccessType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AccessType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.order != "allowFirst" and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.order), input_name='order')), ))
        if self.authSystem is not None and 'authSystem' not in already_processed:
            already_processed.add('authSystem')
            outfile.write(' authSystem=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.authSystem), input_name='authSystem')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AccessType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for allow_ in self.allow:
            namespaceprefix_ = self.allow_nsprefix_ + ':' if (UseCapturedNS_ and self.allow_nsprefix_) else ''
            allow_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='allow', pretty_print=pretty_print)
        for deny_ in self.deny:
            namespaceprefix_ = self.deny_nsprefix_ + ':' if (UseCapturedNS_ and self.deny_nsprefix_) else ''
            deny_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deny', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = value
            self.validate_orderType(self.order)    # validate type orderType
        value = find_attr_value_('authSystem', node)
        if value is not None and 'authSystem' not in already_processed:
            already_processed.add('authSystem')
            self.authSystem = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'allow':
            obj_ = AccessRule.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.allow.append(obj_)
            obj_.original_tagname_ = 'allow'
        elif nodeName_ == 'deny':
            obj_ = AccessRule.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.deny.append(obj_)
            obj_.original_tagname_ = 'deny'
        elif nodeName_ == 'references':
            obj_ = referencesType16.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class AccessType


class AccessRule(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('principal', ['NonEmptyStringType', 'xs:string'], 1, 0, {'maxOccurs': 'unbounded', 'name': 'principal', 'type': 'xs:string'}, None),
        MemberSpec_('permission', ['permissionType', 'xs:string'], 1, 0, {'maxOccurs': 'unbounded', 'name': 'permission', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, principal=None, permission=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if principal is None:
            self.principal = []
        else:
            self.principal = principal
        self.principal_nsprefix_ = None
        if permission is None:
            self.permission = []
        else:
            self.permission = permission
        self.permission_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessRule)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessRule.subclass:
            return AccessRule.subclass(*args_, **kwargs_)
        else:
            return AccessRule(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_principal(self):
        return self.principal
    def set_principal(self, principal):
        self.principal = principal
    def add_principal(self, value):
        self.principal.append(value)
    def insert_principal_at(self, index, value):
        self.principal.insert(index, value)
    def replace_principal_at(self, index, value):
        self.principal[index] = value
    def get_permission(self):
        return self.permission
    def set_permission(self, permission):
        self.permission = permission
    def add_permission(self, value):
        self.permission.append(value)
    def insert_permission_at(self, index, value):
        self.permission.insert(index, value)
    def replace_permission_at(self, index, value):
        self.permission[index] = value
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_permissionType(self, value):
        result = True
        # Validate type permissionType, a restriction on xs:string.
        pass
        return result
    def hasContent_(self):
        if (
            self.principal or
            self.permission
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AccessRule', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AccessRule')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AccessRule':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AccessRule')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AccessRule', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AccessRule'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AccessRule', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for principal_ in self.principal:
            namespaceprefix_ = self.principal_nsprefix_ + ':' if (UseCapturedNS_ and self.principal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprincipal>%s</%sprincipal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(principal_), input_name='principal')), namespaceprefix_ , eol_))
        for permission_ in self.permission:
            namespaceprefix_ = self.permission_nsprefix_ + ':' if (UseCapturedNS_ and self.permission_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spermission>%s</%spermission>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(permission_), input_name='permission')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'principal':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'principal')
            value_ = self.gds_validate_string(value_, node, 'principal')
            self.principal.append(value_)
            self.principal_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.principal[-1])
        elif nodeName_ == 'permission':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'permission')
            value_ = self.gds_validate_string(value_, node, 'permission')
            self.permission.append(value_)
            self.permission_nsprefix_ = child_.prefix
            # validate type permissionType
            self.validate_permissionType(self.permission[-1])
# end class AccessRule


class ResearchProjectType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('title', ['NonEmptyStringType', 'xs:string'], 1, 0, {'maxOccurs': 'unbounded', 'name': 'title', 'type': 'xs:string'}, 27),
        MemberSpec_('personnel', 'personnelType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'personnel', 'type': 'personnelType'}, 27),
        MemberSpec_('abstract', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'abstract', 'type': 'TextType'}, 27),
        MemberSpec_('funding', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'funding', 'type': 'TextType'}, 27),
        MemberSpec_('award', 'AwardType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'award', 'type': 'AwardType'}, 27),
        MemberSpec_('studyAreaDescription', 'studyAreaDescriptionType', 0, 1, {'minOccurs': '0', 'name': 'studyAreaDescription', 'type': 'studyAreaDescriptionType'}, 27),
        MemberSpec_('designDescription', 'designDescriptionType', 0, 1, {'minOccurs': '0', 'name': 'designDescription', 'type': 'designDescriptionType'}, 27),
        MemberSpec_('relatedProject', 'ResearchProjectType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'relatedProject', 'type': 'ResearchProjectType'}, 27),
        MemberSpec_('references', 'referencesType17', 0, 0, {'name': 'references', 'type': 'referencesType17'}, 27),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', title=None, personnel=None, abstract=None, funding=None, award=None, studyAreaDescription=None, designDescription=None, relatedProject=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if personnel is None:
            self.personnel = []
        else:
            self.personnel = personnel
        self.personnel_nsprefix_ = None
        self.abstract = abstract
        self.abstract_nsprefix_ = None
        self.funding = funding
        self.funding_nsprefix_ = None
        if award is None:
            self.award = []
        else:
            self.award = award
        self.award_nsprefix_ = None
        self.studyAreaDescription = studyAreaDescription
        self.studyAreaDescription_nsprefix_ = None
        self.designDescription = designDescription
        self.designDescription_nsprefix_ = None
        if relatedProject is None:
            self.relatedProject = []
        else:
            self.relatedProject = relatedProject
        self.relatedProject_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResearchProjectType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResearchProjectType.subclass:
            return ResearchProjectType.subclass(*args_, **kwargs_)
        else:
            return ResearchProjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_personnel(self):
        return self.personnel
    def set_personnel(self, personnel):
        self.personnel = personnel
    def add_personnel(self, value):
        self.personnel.append(value)
    def insert_personnel_at(self, index, value):
        self.personnel.insert(index, value)
    def replace_personnel_at(self, index, value):
        self.personnel[index] = value
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def get_funding(self):
        return self.funding
    def set_funding(self, funding):
        self.funding = funding
    def get_award(self):
        return self.award
    def set_award(self, award):
        self.award = award
    def add_award(self, value):
        self.award.append(value)
    def insert_award_at(self, index, value):
        self.award.insert(index, value)
    def replace_award_at(self, index, value):
        self.award[index] = value
    def get_studyAreaDescription(self):
        return self.studyAreaDescription
    def set_studyAreaDescription(self, studyAreaDescription):
        self.studyAreaDescription = studyAreaDescription
    def get_designDescription(self):
        return self.designDescription
    def set_designDescription(self, designDescription):
        self.designDescription = designDescription
    def get_relatedProject(self):
        return self.relatedProject
    def set_relatedProject(self, relatedProject):
        self.relatedProject = relatedProject
    def add_relatedProject(self, value):
        self.relatedProject.append(value)
    def insert_relatedProject_at(self, index, value):
        self.relatedProject.insert(index, value)
    def replace_relatedProject_at(self, index, value):
        self.relatedProject[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.title or
            self.personnel or
            self.abstract is not None or
            self.funding is not None or
            self.award or
            self.studyAreaDescription is not None or
            self.designDescription is not None or
            self.relatedProject or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='ResearchProjectType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResearchProjectType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResearchProjectType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResearchProjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResearchProjectType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResearchProjectType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0" ', name_='ResearchProjectType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(title_), input_name='title')), namespaceprefix_ , eol_))
        for personnel_ in self.personnel:
            namespaceprefix_ = self.personnel_nsprefix_ + ':' if (UseCapturedNS_ and self.personnel_nsprefix_) else ''
            personnel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='personnel', pretty_print=pretty_print)
        if self.abstract is not None:
            namespaceprefix_ = self.abstract_nsprefix_ + ':' if (UseCapturedNS_ and self.abstract_nsprefix_) else ''
            self.abstract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstract', pretty_print=pretty_print)
        if self.funding is not None:
            namespaceprefix_ = self.funding_nsprefix_ + ':' if (UseCapturedNS_ and self.funding_nsprefix_) else ''
            self.funding.export(outfile, level, namespaceprefix_, namespacedef_='', name_='funding', pretty_print=pretty_print)
        for award_ in self.award:
            namespaceprefix_ = self.award_nsprefix_ + ':' if (UseCapturedNS_ and self.award_nsprefix_) else ''
            award_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='award', pretty_print=pretty_print)
        if self.studyAreaDescription is not None:
            namespaceprefix_ = self.studyAreaDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.studyAreaDescription_nsprefix_) else ''
            self.studyAreaDescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='studyAreaDescription', pretty_print=pretty_print)
        if self.designDescription is not None:
            namespaceprefix_ = self.designDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.designDescription_nsprefix_) else ''
            self.designDescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='designDescription', pretty_print=pretty_print)
        for relatedProject_ in self.relatedProject:
            namespaceprefix_ = self.relatedProject_nsprefix_ + ':' if (UseCapturedNS_ and self.relatedProject_nsprefix_) else ''
            relatedProject_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relatedProject', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title.append(value_)
            self.title_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.title[-1])
        elif nodeName_ == 'personnel':
            obj_ = personnelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.personnel.append(obj_)
            obj_.original_tagname_ = 'personnel'
        elif nodeName_ == 'abstract':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstract = obj_
            obj_.original_tagname_ = 'abstract'
        elif nodeName_ == 'funding':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.funding = obj_
            obj_.original_tagname_ = 'funding'
        elif nodeName_ == 'award':
            obj_ = AwardType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.award.append(obj_)
            obj_.original_tagname_ = 'award'
        elif nodeName_ == 'studyAreaDescription':
            obj_ = studyAreaDescriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.studyAreaDescription = obj_
            obj_.original_tagname_ = 'studyAreaDescription'
        elif nodeName_ == 'designDescription':
            obj_ = designDescriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.designDescription = obj_
            obj_.original_tagname_ = 'designDescription'
        elif nodeName_ == 'relatedProject':
            obj_ = ResearchProjectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relatedProject.append(obj_)
            obj_.original_tagname_ = 'relatedProject'
        elif nodeName_ == 'references':
            obj_ = referencesType17.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class ResearchProjectType


class AwardType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('funderName', 'i18nNonEmptyStringType', 0, 0, {'maxOccurs': '1', 'minOccurs': '1', 'name': 'funderName', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('funderIdentifier', 'i18nNonEmptyStringType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'funderIdentifier', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('awardNumber', 'i18nNonEmptyStringType', 0, 1, {'maxOccurs': '1', 'minOccurs': '0', 'name': 'awardNumber', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('title', 'i18nNonEmptyStringType', 0, 0, {'maxOccurs': '1', 'minOccurs': '1', 'name': 'title', 'type': 'i18nNonEmptyStringType'}, None),
        MemberSpec_('awardUrl', 'i18nNonEmptyStringType', 0, 1, {'maxOccurs': '1', 'minOccurs': '0', 'name': 'awardUrl', 'type': 'i18nNonEmptyStringType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, funderName=None, funderIdentifier=None, awardNumber=None, title=None, awardUrl=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.funderName = funderName
        self.funderName_nsprefix_ = None
        if funderIdentifier is None:
            self.funderIdentifier = []
        else:
            self.funderIdentifier = funderIdentifier
        self.funderIdentifier_nsprefix_ = None
        self.awardNumber = awardNumber
        self.awardNumber_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.awardUrl = awardUrl
        self.awardUrl_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AwardType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AwardType.subclass:
            return AwardType.subclass(*args_, **kwargs_)
        else:
            return AwardType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_funderName(self):
        return self.funderName
    def set_funderName(self, funderName):
        self.funderName = funderName
    def get_funderIdentifier(self):
        return self.funderIdentifier
    def set_funderIdentifier(self, funderIdentifier):
        self.funderIdentifier = funderIdentifier
    def add_funderIdentifier(self, value):
        self.funderIdentifier.append(value)
    def insert_funderIdentifier_at(self, index, value):
        self.funderIdentifier.insert(index, value)
    def replace_funderIdentifier_at(self, index, value):
        self.funderIdentifier[index] = value
    def get_awardNumber(self):
        return self.awardNumber
    def set_awardNumber(self, awardNumber):
        self.awardNumber = awardNumber
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_awardUrl(self):
        return self.awardUrl
    def set_awardUrl(self, awardUrl):
        self.awardUrl = awardUrl
    def hasContent_(self):
        if (
            self.funderName is not None or
            self.funderIdentifier or
            self.awardNumber is not None or
            self.title is not None or
            self.awardUrl is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='AwardType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AwardType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AwardType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AwardType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AwardType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AwardType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='AwardType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.funderName is not None:
            namespaceprefix_ = self.funderName_nsprefix_ + ':' if (UseCapturedNS_ and self.funderName_nsprefix_) else ''
            self.funderName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='funderName', pretty_print=pretty_print)
        for funderIdentifier_ in self.funderIdentifier:
            namespaceprefix_ = self.funderIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.funderIdentifier_nsprefix_) else ''
            funderIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='funderIdentifier', pretty_print=pretty_print)
        if self.awardNumber is not None:
            namespaceprefix_ = self.awardNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.awardNumber_nsprefix_) else ''
            self.awardNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='awardNumber', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        if self.awardUrl is not None:
            namespaceprefix_ = self.awardUrl_nsprefix_ + ':' if (UseCapturedNS_ and self.awardUrl_nsprefix_) else ''
            self.awardUrl.export(outfile, level, namespaceprefix_, namespacedef_='', name_='awardUrl', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'funderName':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.funderName = obj_
            obj_.original_tagname_ = 'funderName'
        elif nodeName_ == 'funderIdentifier':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.funderIdentifier.append(obj_)
            obj_.original_tagname_ = 'funderIdentifier'
        elif nodeName_ == 'awardNumber':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.awardNumber = obj_
            obj_.original_tagname_ = 'awardNumber'
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'awardUrl':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.awardUrl = obj_
            obj_.original_tagname_ = 'awardUrl'
# end class AwardType


class SemanticAnnotation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('propertyURI', 'propertyURIType', 0, 0, {'maxOccurs': '1', 'minOccurs': '1', 'name': 'propertyURI', 'type': 'propertyURIType'}, None),
        MemberSpec_('valueURI', 'valueURIType', 0, 0, {'maxOccurs': '1', 'minOccurs': '1', 'name': 'valueURI', 'type': 'valueURIType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', propertyURI=None, valueURI=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.propertyURI = propertyURI
        self.propertyURI_nsprefix_ = None
        self.valueURI = valueURI
        self.valueURI_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SemanticAnnotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SemanticAnnotation.subclass:
            return SemanticAnnotation.subclass(*args_, **kwargs_)
        else:
            return SemanticAnnotation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_propertyURI(self):
        return self.propertyURI
    def set_propertyURI(self, propertyURI):
        self.propertyURI = propertyURI
    def get_valueURI(self):
        return self.valueURI
    def set_valueURI(self, valueURI):
        self.valueURI = valueURI
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.propertyURI is not None or
            self.valueURI is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SemanticAnnotation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SemanticAnnotation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SemanticAnnotation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SemanticAnnotation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SemanticAnnotation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SemanticAnnotation'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='SemanticAnnotation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.propertyURI is not None:
            namespaceprefix_ = self.propertyURI_nsprefix_ + ':' if (UseCapturedNS_ and self.propertyURI_nsprefix_) else ''
            self.propertyURI.export(outfile, level, namespaceprefix_, namespacedef_='', name_='propertyURI', pretty_print=pretty_print)
        if self.valueURI is not None:
            namespaceprefix_ = self.valueURI_nsprefix_ + ':' if (UseCapturedNS_ and self.valueURI_nsprefix_) else ''
            self.valueURI.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueURI', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'propertyURI':
            obj_ = propertyURIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.propertyURI = obj_
            obj_.original_tagname_ = 'propertyURI'
        elif nodeName_ == 'valueURI':
            obj_ = valueURIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueURI = obj_
            obj_.original_tagname_ = 'valueURI'
# end class SemanticAnnotation


class DatasetType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('alternateIdentifier', 'alternateIdentifierType18', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'alternateIdentifier', 'type': 'alternateIdentifierType18'}, 28),
        MemberSpec_('shortName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'shortName', 'type': 'xs:string'}, 28),
        MemberSpec_('title', 'i18nNonEmptyStringType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'title', 'type': 'i18nNonEmptyStringType'}, 28),
        MemberSpec_('creator', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'creator', 'type': 'ResponsibleParty'}, 28),
        MemberSpec_('metadataProvider', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'metadataProvider', 'type': 'ResponsibleParty'}, 28),
        MemberSpec_('associatedParty', 'associatedPartyType19', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'associatedParty', 'type': 'associatedPartyType19'}, 28),
        MemberSpec_('pubDate', 'yearDate', 0, 1, {'minOccurs': '0', 'name': 'pubDate', 'type': 'xs:string'}, 28),
        MemberSpec_('language', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'language', 'type': 'i18nNonEmptyStringType'}, 28),
        MemberSpec_('series', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'series', 'type': 'xs:string'}, 28),
        MemberSpec_('abstract', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'abstract', 'type': 'TextType'}, 28),
        MemberSpec_('keywordSet', 'keywordSetType20', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'keywordSet', 'type': 'keywordSetType20'}, 28),
        MemberSpec_('additionalInfo', 'TextType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalInfo', 'type': 'TextType'}, 28),
        MemberSpec_('intellectualRights', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'intellectualRights', 'type': 'TextType'}, 28),
        MemberSpec_('licensed', 'LicenseType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'licensed', 'type': 'LicenseType'}, 28),
        MemberSpec_('distribution', 'DistributionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'distribution', 'type': 'DistributionType'}, 28),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 28),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 28),
        MemberSpec_('purpose', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'purpose', 'type': 'TextType'}, 28),
        MemberSpec_('introduction', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'introduction', 'type': 'TextType'}, 28),
        MemberSpec_('gettingStarted', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'gettingStarted', 'type': 'TextType'}, 28),
        MemberSpec_('acknowledgements', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'acknowledgements', 'type': 'TextType'}, 28),
        MemberSpec_('maintenance', 'MaintenanceType', 0, 1, {'minOccurs': '0', 'name': 'maintenance', 'type': 'MaintenanceType'}, 28),
        MemberSpec_('contact', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'contact', 'type': 'ResponsibleParty'}, 28),
        MemberSpec_('publisher', 'ResponsibleParty', 0, 1, {'minOccurs': '0', 'name': 'publisher', 'type': 'ResponsibleParty'}, 28),
        MemberSpec_('pubPlace', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pubPlace', 'type': 'xs:string'}, 28),
        MemberSpec_('methods', 'MethodsType', 0, 1, {'minOccurs': '0', 'name': 'methods', 'type': 'MethodsType'}, 28),
        MemberSpec_('project', 'ResearchProjectType', 0, 1, {'minOccurs': '0', 'name': 'project', 'type': 'ResearchProjectType'}, 28),
        MemberSpec_('dataTable', 'DataTableType', 1, 1, {'name': 'dataTable', 'type': 'DataTableType'}, 29),
        MemberSpec_('spatialRaster', 'SpatialRasterType', 1, 1, {'name': 'spatialRaster', 'type': 'SpatialRasterType'}, 29),
        MemberSpec_('spatialVector', 'SpatialVectorType', 1, 1, {'name': 'spatialVector', 'type': 'SpatialVectorType'}, 29),
        MemberSpec_('storedProcedure', 'StoredProcedureType', 1, 1, {'name': 'storedProcedure', 'type': 'StoredProcedureType'}, 29),
        MemberSpec_('view', 'ViewType', 1, 1, {'name': 'view', 'type': 'ViewType'}, 29),
        MemberSpec_('otherEntity', 'OtherEntityType', 1, 1, {'name': 'otherEntity', 'type': 'OtherEntityType'}, 29),
        MemberSpec_('referencePublication', 'CitationType', 0, 1, {'maxOccurs': '1', 'minOccurs': '0', 'name': 'referencePublication', 'type': 'CitationType'}, None),
        MemberSpec_('usageCitation', 'CitationType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'usageCitation', 'type': 'CitationType'}, None),
        MemberSpec_('literatureCited', 'CitationListType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'literatureCited', 'type': 'CitationListType'}, None),
        MemberSpec_('references', 'referencesType22', 0, 0, {'name': 'references', 'type': 'referencesType22'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', alternateIdentifier=None, shortName=None, title=None, creator=None, metadataProvider=None, associatedParty=None, pubDate=None, language=None, series=None, abstract=None, keywordSet=None, additionalInfo=None, intellectualRights=None, licensed=None, distribution=None, coverage=None, annotation=None, purpose=None, introduction=None, gettingStarted=None, acknowledgements=None, maintenance=None, contact=None, publisher=None, pubPlace=None, methods=None, project=None, dataTable=None, spatialRaster=None, spatialVector=None, storedProcedure=None, view=None, otherEntity=None, referencePublication=None, usageCitation=None, literatureCited=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if alternateIdentifier is None:
            self.alternateIdentifier = []
        else:
            self.alternateIdentifier = alternateIdentifier
        self.alternateIdentifier_nsprefix_ = None
        self.shortName = shortName
        self.validate_NonEmptyStringType(self.shortName)
        self.shortName_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if creator is None:
            self.creator = []
        else:
            self.creator = creator
        self.creator_nsprefix_ = None
        if metadataProvider is None:
            self.metadataProvider = []
        else:
            self.metadataProvider = metadataProvider
        self.metadataProvider_nsprefix_ = None
        if associatedParty is None:
            self.associatedParty = []
        else:
            self.associatedParty = associatedParty
        self.associatedParty_nsprefix_ = None
        self.pubDate = pubDate
        self.validate_yearDate(self.pubDate)
        self.pubDate_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.series = series
        self.validate_NonEmptyStringType(self.series)
        self.series_nsprefix_ = None
        self.abstract = abstract
        self.abstract_nsprefix_ = None
        if keywordSet is None:
            self.keywordSet = []
        else:
            self.keywordSet = keywordSet
        self.keywordSet_nsprefix_ = None
        if additionalInfo is None:
            self.additionalInfo = []
        else:
            self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.intellectualRights = intellectualRights
        self.intellectualRights_nsprefix_ = None
        if licensed is None:
            self.licensed = []
        else:
            self.licensed = licensed
        self.licensed_nsprefix_ = None
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.distribution_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        self.purpose = purpose
        self.purpose_nsprefix_ = None
        self.introduction = introduction
        self.introduction_nsprefix_ = None
        self.gettingStarted = gettingStarted
        self.gettingStarted_nsprefix_ = None
        self.acknowledgements = acknowledgements
        self.acknowledgements_nsprefix_ = None
        self.maintenance = maintenance
        self.maintenance_nsprefix_ = None
        if contact is None:
            self.contact = []
        else:
            self.contact = contact
        self.contact_nsprefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.pubPlace = pubPlace
        self.validate_NonEmptyStringType(self.pubPlace)
        self.pubPlace_nsprefix_ = None
        self.methods = methods
        self.methods_nsprefix_ = None
        self.project = project
        self.project_nsprefix_ = None
        if dataTable is None:
            self.dataTable = []
        else:
            self.dataTable = dataTable
        self.dataTable_nsprefix_ = None
        if spatialRaster is None:
            self.spatialRaster = []
        else:
            self.spatialRaster = spatialRaster
        self.spatialRaster_nsprefix_ = None
        if spatialVector is None:
            self.spatialVector = []
        else:
            self.spatialVector = spatialVector
        self.spatialVector_nsprefix_ = None
        if storedProcedure is None:
            self.storedProcedure = []
        else:
            self.storedProcedure = storedProcedure
        self.storedProcedure_nsprefix_ = None
        if view is None:
            self.view = []
        else:
            self.view = view
        self.view_nsprefix_ = None
        if otherEntity is None:
            self.otherEntity = []
        else:
            self.otherEntity = otherEntity
        self.otherEntity_nsprefix_ = None
        self.referencePublication = referencePublication
        self.referencePublication_nsprefix_ = None
        if usageCitation is None:
            self.usageCitation = []
        else:
            self.usageCitation = usageCitation
        self.usageCitation_nsprefix_ = None
        if literatureCited is None:
            self.literatureCited = []
        else:
            self.literatureCited = literatureCited
        self.literatureCited_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DatasetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DatasetType.subclass:
            return DatasetType.subclass(*args_, **kwargs_)
        else:
            return DatasetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternateIdentifier(self):
        return self.alternateIdentifier
    def set_alternateIdentifier(self, alternateIdentifier):
        self.alternateIdentifier = alternateIdentifier
    def add_alternateIdentifier(self, value):
        self.alternateIdentifier.append(value)
    def insert_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier.insert(index, value)
    def replace_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier[index] = value
    def get_shortName(self):
        return self.shortName
    def set_shortName(self, shortName):
        self.shortName = shortName
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_creator(self):
        return self.creator
    def set_creator(self, creator):
        self.creator = creator
    def add_creator(self, value):
        self.creator.append(value)
    def insert_creator_at(self, index, value):
        self.creator.insert(index, value)
    def replace_creator_at(self, index, value):
        self.creator[index] = value
    def get_metadataProvider(self):
        return self.metadataProvider
    def set_metadataProvider(self, metadataProvider):
        self.metadataProvider = metadataProvider
    def add_metadataProvider(self, value):
        self.metadataProvider.append(value)
    def insert_metadataProvider_at(self, index, value):
        self.metadataProvider.insert(index, value)
    def replace_metadataProvider_at(self, index, value):
        self.metadataProvider[index] = value
    def get_associatedParty(self):
        return self.associatedParty
    def set_associatedParty(self, associatedParty):
        self.associatedParty = associatedParty
    def add_associatedParty(self, value):
        self.associatedParty.append(value)
    def insert_associatedParty_at(self, index, value):
        self.associatedParty.insert(index, value)
    def replace_associatedParty_at(self, index, value):
        self.associatedParty[index] = value
    def get_pubDate(self):
        return self.pubDate
    def set_pubDate(self, pubDate):
        self.pubDate = pubDate
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_series(self):
        return self.series
    def set_series(self, series):
        self.series = series
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def get_keywordSet(self):
        return self.keywordSet
    def set_keywordSet(self, keywordSet):
        self.keywordSet = keywordSet
    def add_keywordSet(self, value):
        self.keywordSet.append(value)
    def insert_keywordSet_at(self, index, value):
        self.keywordSet.insert(index, value)
    def replace_keywordSet_at(self, index, value):
        self.keywordSet[index] = value
    def get_additionalInfo(self):
        return self.additionalInfo
    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo
    def add_additionalInfo(self, value):
        self.additionalInfo.append(value)
    def insert_additionalInfo_at(self, index, value):
        self.additionalInfo.insert(index, value)
    def replace_additionalInfo_at(self, index, value):
        self.additionalInfo[index] = value
    def get_intellectualRights(self):
        return self.intellectualRights
    def set_intellectualRights(self, intellectualRights):
        self.intellectualRights = intellectualRights
    def get_licensed(self):
        return self.licensed
    def set_licensed(self, licensed):
        self.licensed = licensed
    def add_licensed(self, value):
        self.licensed.append(value)
    def insert_licensed_at(self, index, value):
        self.licensed.insert(index, value)
    def replace_licensed_at(self, index, value):
        self.licensed[index] = value
    def get_distribution(self):
        return self.distribution
    def set_distribution(self, distribution):
        self.distribution = distribution
    def add_distribution(self, value):
        self.distribution.append(value)
    def insert_distribution_at(self, index, value):
        self.distribution.insert(index, value)
    def replace_distribution_at(self, index, value):
        self.distribution[index] = value
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_purpose(self):
        return self.purpose
    def set_purpose(self, purpose):
        self.purpose = purpose
    def get_introduction(self):
        return self.introduction
    def set_introduction(self, introduction):
        self.introduction = introduction
    def get_gettingStarted(self):
        return self.gettingStarted
    def set_gettingStarted(self, gettingStarted):
        self.gettingStarted = gettingStarted
    def get_acknowledgements(self):
        return self.acknowledgements
    def set_acknowledgements(self, acknowledgements):
        self.acknowledgements = acknowledgements
    def get_maintenance(self):
        return self.maintenance
    def set_maintenance(self, maintenance):
        self.maintenance = maintenance
    def get_contact(self):
        return self.contact
    def set_contact(self, contact):
        self.contact = contact
    def add_contact(self, value):
        self.contact.append(value)
    def insert_contact_at(self, index, value):
        self.contact.insert(index, value)
    def replace_contact_at(self, index, value):
        self.contact[index] = value
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_pubPlace(self):
        return self.pubPlace
    def set_pubPlace(self, pubPlace):
        self.pubPlace = pubPlace
    def get_methods(self):
        return self.methods
    def set_methods(self, methods):
        self.methods = methods
    def get_project(self):
        return self.project
    def set_project(self, project):
        self.project = project
    def get_dataTable(self):
        return self.dataTable
    def set_dataTable(self, dataTable):
        self.dataTable = dataTable
    def add_dataTable(self, value):
        self.dataTable.append(value)
    def insert_dataTable_at(self, index, value):
        self.dataTable.insert(index, value)
    def replace_dataTable_at(self, index, value):
        self.dataTable[index] = value
    def get_spatialRaster(self):
        return self.spatialRaster
    def set_spatialRaster(self, spatialRaster):
        self.spatialRaster = spatialRaster
    def add_spatialRaster(self, value):
        self.spatialRaster.append(value)
    def insert_spatialRaster_at(self, index, value):
        self.spatialRaster.insert(index, value)
    def replace_spatialRaster_at(self, index, value):
        self.spatialRaster[index] = value
    def get_spatialVector(self):
        return self.spatialVector
    def set_spatialVector(self, spatialVector):
        self.spatialVector = spatialVector
    def add_spatialVector(self, value):
        self.spatialVector.append(value)
    def insert_spatialVector_at(self, index, value):
        self.spatialVector.insert(index, value)
    def replace_spatialVector_at(self, index, value):
        self.spatialVector[index] = value
    def get_storedProcedure(self):
        return self.storedProcedure
    def set_storedProcedure(self, storedProcedure):
        self.storedProcedure = storedProcedure
    def add_storedProcedure(self, value):
        self.storedProcedure.append(value)
    def insert_storedProcedure_at(self, index, value):
        self.storedProcedure.insert(index, value)
    def replace_storedProcedure_at(self, index, value):
        self.storedProcedure[index] = value
    def get_view(self):
        return self.view
    def set_view(self, view):
        self.view = view
    def add_view(self, value):
        self.view.append(value)
    def insert_view_at(self, index, value):
        self.view.insert(index, value)
    def replace_view_at(self, index, value):
        self.view[index] = value
    def get_otherEntity(self):
        return self.otherEntity
    def set_otherEntity(self, otherEntity):
        self.otherEntity = otherEntity
    def add_otherEntity(self, value):
        self.otherEntity.append(value)
    def insert_otherEntity_at(self, index, value):
        self.otherEntity.insert(index, value)
    def replace_otherEntity_at(self, index, value):
        self.otherEntity[index] = value
    def get_referencePublication(self):
        return self.referencePublication
    def set_referencePublication(self, referencePublication):
        self.referencePublication = referencePublication
    def get_usageCitation(self):
        return self.usageCitation
    def set_usageCitation(self, usageCitation):
        self.usageCitation = usageCitation
    def add_usageCitation(self, value):
        self.usageCitation.append(value)
    def insert_usageCitation_at(self, index, value):
        self.usageCitation.insert(index, value)
    def replace_usageCitation_at(self, index, value):
        self.usageCitation[index] = value
    def get_literatureCited(self):
        return self.literatureCited
    def set_literatureCited(self, literatureCited):
        self.literatureCited = literatureCited
    def add_literatureCited(self, value):
        self.literatureCited.append(value)
    def insert_literatureCited_at(self, index, value):
        self.literatureCited.insert(index, value)
    def replace_literatureCited_at(self, index, value):
        self.literatureCited[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_yearDate(self, value):
        result = True
        # Validate type yearDate, a restriction on None.
        pass
        return result
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.alternateIdentifier or
            self.shortName is not None or
            self.title or
            self.creator or
            self.metadataProvider or
            self.associatedParty or
            self.pubDate is not None or
            self.language is not None or
            self.series is not None or
            self.abstract is not None or
            self.keywordSet or
            self.additionalInfo or
            self.intellectualRights is not None or
            self.licensed or
            self.distribution or
            self.coverage is not None or
            self.annotation or
            self.purpose is not None or
            self.introduction is not None or
            self.gettingStarted is not None or
            self.acknowledgements is not None or
            self.maintenance is not None or
            self.contact or
            self.publisher is not None or
            self.pubPlace is not None or
            self.methods is not None or
            self.project is not None or
            self.dataTable or
            self.spatialRaster or
            self.spatialVector or
            self.storedProcedure or
            self.view or
            self.otherEntity or
            self.referencePublication is not None or
            self.usageCitation or
            self.literatureCited or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:proj="https://eml.ecoinformatics.org/project-2.2.0"  xmlns:dat="https://eml.ecoinformatics.org/dataTable-2.2.0"  xmlns:sr="https://eml.ecoinformatics.org/spatialRaster-2.2.0"  xmlns:sv="https://eml.ecoinformatics.org/spatialVector-2.2.0"  xmlns:sp="https://eml.ecoinformatics.org/storedProcedure-2.2.0"  xmlns:v="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:ent="https://eml.ecoinformatics.org/entity-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0" ', name_='DatasetType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DatasetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DatasetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DatasetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DatasetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DatasetType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:proj="https://eml.ecoinformatics.org/project-2.2.0"  xmlns:dat="https://eml.ecoinformatics.org/dataTable-2.2.0"  xmlns:sr="https://eml.ecoinformatics.org/spatialRaster-2.2.0"  xmlns:sv="https://eml.ecoinformatics.org/spatialVector-2.2.0"  xmlns:sp="https://eml.ecoinformatics.org/storedProcedure-2.2.0"  xmlns:v="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:ent="https://eml.ecoinformatics.org/entity-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0" ', name_='DatasetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for alternateIdentifier_ in self.alternateIdentifier:
            namespaceprefix_ = self.alternateIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.alternateIdentifier_nsprefix_) else ''
            alternateIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternateIdentifier', pretty_print=pretty_print)
        if self.shortName is not None:
            namespaceprefix_ = self.shortName_nsprefix_ + ':' if (UseCapturedNS_ and self.shortName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshortName>%s</%sshortName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shortName), input_name='shortName')), namespaceprefix_ , eol_))
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for creator_ in self.creator:
            namespaceprefix_ = self.creator_nsprefix_ + ':' if (UseCapturedNS_ and self.creator_nsprefix_) else ''
            creator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='creator', pretty_print=pretty_print)
        for metadataProvider_ in self.metadataProvider:
            namespaceprefix_ = self.metadataProvider_nsprefix_ + ':' if (UseCapturedNS_ and self.metadataProvider_nsprefix_) else ''
            metadataProvider_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='metadataProvider', pretty_print=pretty_print)
        for associatedParty_ in self.associatedParty:
            namespaceprefix_ = self.associatedParty_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedParty_nsprefix_) else ''
            associatedParty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedParty', pretty_print=pretty_print)
        if self.pubDate is not None:
            namespaceprefix_ = self.pubDate_nsprefix_ + ':' if (UseCapturedNS_ and self.pubDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spubDate>%s</%spubDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pubDate), input_name='pubDate')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.series is not None:
            namespaceprefix_ = self.series_nsprefix_ + ':' if (UseCapturedNS_ and self.series_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseries>%s</%sseries>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.series), input_name='series')), namespaceprefix_ , eol_))
        if self.abstract is not None:
            namespaceprefix_ = self.abstract_nsprefix_ + ':' if (UseCapturedNS_ and self.abstract_nsprefix_) else ''
            self.abstract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstract', pretty_print=pretty_print)
        for keywordSet_ in self.keywordSet:
            namespaceprefix_ = self.keywordSet_nsprefix_ + ':' if (UseCapturedNS_ and self.keywordSet_nsprefix_) else ''
            keywordSet_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='keywordSet', pretty_print=pretty_print)
        for additionalInfo_ in self.additionalInfo:
            namespaceprefix_ = self.additionalInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalInfo_nsprefix_) else ''
            additionalInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalInfo', pretty_print=pretty_print)
        if self.intellectualRights is not None:
            namespaceprefix_ = self.intellectualRights_nsprefix_ + ':' if (UseCapturedNS_ and self.intellectualRights_nsprefix_) else ''
            self.intellectualRights.export(outfile, level, namespaceprefix_, namespacedef_='', name_='intellectualRights', pretty_print=pretty_print)
        for licensed_ in self.licensed:
            namespaceprefix_ = self.licensed_nsprefix_ + ':' if (UseCapturedNS_ and self.licensed_nsprefix_) else ''
            licensed_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='licensed', pretty_print=pretty_print)
        for distribution_ in self.distribution:
            namespaceprefix_ = self.distribution_nsprefix_ + ':' if (UseCapturedNS_ and self.distribution_nsprefix_) else ''
            distribution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='distribution', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        if self.purpose is not None:
            namespaceprefix_ = self.purpose_nsprefix_ + ':' if (UseCapturedNS_ and self.purpose_nsprefix_) else ''
            self.purpose.export(outfile, level, namespaceprefix_, namespacedef_='', name_='purpose', pretty_print=pretty_print)
        if self.introduction is not None:
            namespaceprefix_ = self.introduction_nsprefix_ + ':' if (UseCapturedNS_ and self.introduction_nsprefix_) else ''
            self.introduction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='introduction', pretty_print=pretty_print)
        if self.gettingStarted is not None:
            namespaceprefix_ = self.gettingStarted_nsprefix_ + ':' if (UseCapturedNS_ and self.gettingStarted_nsprefix_) else ''
            self.gettingStarted.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gettingStarted', pretty_print=pretty_print)
        if self.acknowledgements is not None:
            namespaceprefix_ = self.acknowledgements_nsprefix_ + ':' if (UseCapturedNS_ and self.acknowledgements_nsprefix_) else ''
            self.acknowledgements.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acknowledgements', pretty_print=pretty_print)
        if self.maintenance is not None:
            namespaceprefix_ = self.maintenance_nsprefix_ + ':' if (UseCapturedNS_ and self.maintenance_nsprefix_) else ''
            self.maintenance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='maintenance', pretty_print=pretty_print)
        for contact_ in self.contact:
            namespaceprefix_ = self.contact_nsprefix_ + ':' if (UseCapturedNS_ and self.contact_nsprefix_) else ''
            contact_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contact', pretty_print=pretty_print)
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            self.publisher.export(outfile, level, namespaceprefix_, namespacedef_='', name_='publisher', pretty_print=pretty_print)
        if self.pubPlace is not None:
            namespaceprefix_ = self.pubPlace_nsprefix_ + ':' if (UseCapturedNS_ and self.pubPlace_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spubPlace>%s</%spubPlace>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pubPlace), input_name='pubPlace')), namespaceprefix_ , eol_))
        if self.methods is not None:
            namespaceprefix_ = self.methods_nsprefix_ + ':' if (UseCapturedNS_ and self.methods_nsprefix_) else ''
            self.methods.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methods', pretty_print=pretty_print)
        if self.project is not None:
            namespaceprefix_ = self.project_nsprefix_ + ':' if (UseCapturedNS_ and self.project_nsprefix_) else ''
            self.project.export(outfile, level, namespaceprefix_, namespacedef_='', name_='project', pretty_print=pretty_print)
        for dataTable_ in self.dataTable:
            namespaceprefix_ = self.dataTable_nsprefix_ + ':' if (UseCapturedNS_ and self.dataTable_nsprefix_) else ''
            dataTable_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dataTable', pretty_print=pretty_print)
        for spatialRaster_ in self.spatialRaster:
            namespaceprefix_ = self.spatialRaster_nsprefix_ + ':' if (UseCapturedNS_ and self.spatialRaster_nsprefix_) else ''
            spatialRaster_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='spatialRaster', pretty_print=pretty_print)
        for spatialVector_ in self.spatialVector:
            namespaceprefix_ = self.spatialVector_nsprefix_ + ':' if (UseCapturedNS_ and self.spatialVector_nsprefix_) else ''
            spatialVector_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='spatialVector', pretty_print=pretty_print)
        for storedProcedure_ in self.storedProcedure:
            namespaceprefix_ = self.storedProcedure_nsprefix_ + ':' if (UseCapturedNS_ and self.storedProcedure_nsprefix_) else ''
            storedProcedure_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='storedProcedure', pretty_print=pretty_print)
        for view_ in self.view:
            namespaceprefix_ = self.view_nsprefix_ + ':' if (UseCapturedNS_ and self.view_nsprefix_) else ''
            view_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='view', pretty_print=pretty_print)
        for otherEntity_ in self.otherEntity:
            namespaceprefix_ = self.otherEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.otherEntity_nsprefix_) else ''
            otherEntity_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='otherEntity', pretty_print=pretty_print)
        if self.referencePublication is not None:
            namespaceprefix_ = self.referencePublication_nsprefix_ + ':' if (UseCapturedNS_ and self.referencePublication_nsprefix_) else ''
            self.referencePublication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='referencePublication', pretty_print=pretty_print)
        for usageCitation_ in self.usageCitation:
            namespaceprefix_ = self.usageCitation_nsprefix_ + ':' if (UseCapturedNS_ and self.usageCitation_nsprefix_) else ''
            usageCitation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='usageCitation', pretty_print=pretty_print)
        for literatureCited_ in self.literatureCited:
            namespaceprefix_ = self.literatureCited_nsprefix_ + ':' if (UseCapturedNS_ and self.literatureCited_nsprefix_) else ''
            literatureCited_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='literatureCited', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternateIdentifier':
            obj_ = alternateIdentifierType18.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternateIdentifier.append(obj_)
            obj_.original_tagname_ = 'alternateIdentifier'
        elif nodeName_ == 'shortName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shortName')
            value_ = self.gds_validate_string(value_, node, 'shortName')
            self.shortName = value_
            self.shortName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.shortName)
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'creator':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.creator.append(obj_)
            obj_.original_tagname_ = 'creator'
        elif nodeName_ == 'metadataProvider':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.metadataProvider.append(obj_)
            obj_.original_tagname_ = 'metadataProvider'
        elif nodeName_ == 'associatedParty':
            obj_ = associatedPartyType19.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedParty.append(obj_)
            obj_.original_tagname_ = 'associatedParty'
        elif nodeName_ == 'pubDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pubDate')
            value_ = self.gds_validate_string(value_, node, 'pubDate')
            self.pubDate = value_
            self.pubDate_nsprefix_ = child_.prefix
            # validate type yearDate
            self.validate_yearDate(self.pubDate)
        elif nodeName_ == 'language':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'series':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'series')
            value_ = self.gds_validate_string(value_, node, 'series')
            self.series = value_
            self.series_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.series)
        elif nodeName_ == 'abstract':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstract = obj_
            obj_.original_tagname_ = 'abstract'
        elif nodeName_ == 'keywordSet':
            obj_ = keywordSetType20.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.keywordSet.append(obj_)
            obj_.original_tagname_ = 'keywordSet'
        elif nodeName_ == 'additionalInfo':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalInfo.append(obj_)
            obj_.original_tagname_ = 'additionalInfo'
        elif nodeName_ == 'intellectualRights':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intellectualRights = obj_
            obj_.original_tagname_ = 'intellectualRights'
        elif nodeName_ == 'licensed':
            obj_ = LicenseType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.licensed.append(obj_)
            obj_.original_tagname_ = 'licensed'
        elif nodeName_ == 'distribution':
            obj_ = DistributionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distribution.append(obj_)
            obj_.original_tagname_ = 'distribution'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'purpose':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.purpose = obj_
            obj_.original_tagname_ = 'purpose'
        elif nodeName_ == 'introduction':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.introduction = obj_
            obj_.original_tagname_ = 'introduction'
        elif nodeName_ == 'gettingStarted':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.gettingStarted = obj_
            obj_.original_tagname_ = 'gettingStarted'
        elif nodeName_ == 'acknowledgements':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.acknowledgements = obj_
            obj_.original_tagname_ = 'acknowledgements'
        elif nodeName_ == 'maintenance':
            obj_ = MaintenanceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.maintenance = obj_
            obj_.original_tagname_ = 'maintenance'
        elif nodeName_ == 'contact':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact.append(obj_)
            obj_.original_tagname_ = 'contact'
        elif nodeName_ == 'publisher':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.publisher = obj_
            obj_.original_tagname_ = 'publisher'
        elif nodeName_ == 'pubPlace':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pubPlace')
            value_ = self.gds_validate_string(value_, node, 'pubPlace')
            self.pubPlace = value_
            self.pubPlace_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.pubPlace)
        elif nodeName_ == 'methods':
            obj_ = MethodsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methods = obj_
            obj_.original_tagname_ = 'methods'
        elif nodeName_ == 'project':
            obj_ = ResearchProjectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.project = obj_
            obj_.original_tagname_ = 'project'
        elif nodeName_ == 'dataTable':
            obj_ = DataTableType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dataTable.append(obj_)
            obj_.original_tagname_ = 'dataTable'
        elif nodeName_ == 'spatialRaster':
            obj_ = SpatialRasterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spatialRaster.append(obj_)
            obj_.original_tagname_ = 'spatialRaster'
        elif nodeName_ == 'spatialVector':
            obj_ = SpatialVectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spatialVector.append(obj_)
            obj_.original_tagname_ = 'spatialVector'
        elif nodeName_ == 'storedProcedure':
            obj_ = StoredProcedureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.storedProcedure.append(obj_)
            obj_.original_tagname_ = 'storedProcedure'
        elif nodeName_ == 'view':
            obj_ = ViewType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.view.append(obj_)
            obj_.original_tagname_ = 'view'
        elif nodeName_ == 'otherEntity':
            obj_ = OtherEntityType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.otherEntity.append(obj_)
            obj_.original_tagname_ = 'otherEntity'
        elif nodeName_ == 'referencePublication':
            obj_ = CitationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.referencePublication = obj_
            obj_.original_tagname_ = 'referencePublication'
        elif nodeName_ == 'usageCitation':
            obj_ = CitationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.usageCitation.append(obj_)
            obj_.original_tagname_ = 'usageCitation'
        elif nodeName_ == 'literatureCited':
            obj_ = CitationListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.literatureCited.append(obj_)
            obj_.original_tagname_ = 'literatureCited'
        elif nodeName_ == 'references':
            obj_ = referencesType22.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class DatasetType


class MaintenanceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('description', 'TextType', 0, 0, {'name': 'description', 'type': 'TextType'}, None),
        MemberSpec_('maintenanceUpdateFrequency', ['MaintUpFreqType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'maintenanceUpdateFrequency', 'type': 'xs:string'}, None),
        MemberSpec_('changeHistory', 'changeHistoryType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'changeHistory', 'type': 'changeHistoryType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, description=None, maintenanceUpdateFrequency=None, changeHistory=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        self.maintenanceUpdateFrequency = maintenanceUpdateFrequency
        self.validate_MaintUpFreqType(self.maintenanceUpdateFrequency)
        self.maintenanceUpdateFrequency_nsprefix_ = None
        if changeHistory is None:
            self.changeHistory = []
        else:
            self.changeHistory = changeHistory
        self.changeHistory_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MaintenanceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MaintenanceType.subclass:
            return MaintenanceType.subclass(*args_, **kwargs_)
        else:
            return MaintenanceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_maintenanceUpdateFrequency(self):
        return self.maintenanceUpdateFrequency
    def set_maintenanceUpdateFrequency(self, maintenanceUpdateFrequency):
        self.maintenanceUpdateFrequency = maintenanceUpdateFrequency
    def get_changeHistory(self):
        return self.changeHistory
    def set_changeHistory(self, changeHistory):
        self.changeHistory = changeHistory
    def add_changeHistory(self, value):
        self.changeHistory.append(value)
    def insert_changeHistory_at(self, index, value):
        self.changeHistory.insert(index, value)
    def replace_changeHistory_at(self, index, value):
        self.changeHistory[index] = value
    def validate_MaintUpFreqType(self, value):
        result = True
        # Validate type MaintUpFreqType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['annually', 'asNeeded', 'biannually', 'continually', 'daily', 'irregular', 'monthly', 'notPlanned', 'weekly', 'unknown', 'unkown', 'otherMaintenancePeriod']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on MaintUpFreqType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.description is not None or
            self.maintenanceUpdateFrequency is not None or
            self.changeHistory
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='MaintenanceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MaintenanceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MaintenanceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MaintenanceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MaintenanceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MaintenanceType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='MaintenanceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            self.description.export(outfile, level, namespaceprefix_, namespacedef_='', name_='description', pretty_print=pretty_print)
        if self.maintenanceUpdateFrequency is not None:
            namespaceprefix_ = self.maintenanceUpdateFrequency_nsprefix_ + ':' if (UseCapturedNS_ and self.maintenanceUpdateFrequency_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaintenanceUpdateFrequency>%s</%smaintenanceUpdateFrequency>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.maintenanceUpdateFrequency), input_name='maintenanceUpdateFrequency')), namespaceprefix_ , eol_))
        for changeHistory_ in self.changeHistory:
            namespaceprefix_ = self.changeHistory_nsprefix_ + ':' if (UseCapturedNS_ and self.changeHistory_nsprefix_) else ''
            changeHistory_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='changeHistory', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'description':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.description = obj_
            obj_.original_tagname_ = 'description'
        elif nodeName_ == 'maintenanceUpdateFrequency':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'maintenanceUpdateFrequency')
            value_ = self.gds_validate_string(value_, node, 'maintenanceUpdateFrequency')
            self.maintenanceUpdateFrequency = value_
            self.maintenanceUpdateFrequency_nsprefix_ = child_.prefix
            # validate type MaintUpFreqType
            self.validate_MaintUpFreqType(self.maintenanceUpdateFrequency)
        elif nodeName_ == 'changeHistory':
            obj_ = changeHistoryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.changeHistory.append(obj_)
            obj_.original_tagname_ = 'changeHistory'
# end class MaintenanceType


class OtherEntityType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('alternateIdentifier', 'alternateIdentifierType23', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'alternateIdentifier', 'type': 'alternateIdentifierType23'}, 30),
        MemberSpec_('entityName', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'entityName', 'type': 'xs:string'}, 30),
        MemberSpec_('entityDescription', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'entityDescription', 'type': 'xs:string'}, 30),
        MemberSpec_('physical', 'PhysicalType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'physical', 'type': 'PhysicalType'}, 30),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 30),
        MemberSpec_('methods', 'MethodsType', 0, 1, {'minOccurs': '0', 'name': 'methods', 'type': 'MethodsType'}, 30),
        MemberSpec_('additionalInfo', 'TextType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalInfo', 'type': 'TextType'}, 30),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 30),
        MemberSpec_('attributeList', 'AttributeListType', 0, 1, {'minOccurs': '0', 'name': 'attributeList', 'type': 'AttributeListType'}, 30),
        MemberSpec_('constraint', 'ConstraintType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'constraint', 'type': 'ConstraintType'}, 30),
        MemberSpec_('entityType', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'entityType', 'type': 'xs:string'}, 30),
        MemberSpec_('references', 'referencesType24', 0, 0, {'name': 'references', 'type': 'referencesType24'}, 30),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', alternateIdentifier=None, entityName=None, entityDescription=None, physical=None, coverage=None, methods=None, additionalInfo=None, annotation=None, attributeList=None, constraint=None, entityType=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if alternateIdentifier is None:
            self.alternateIdentifier = []
        else:
            self.alternateIdentifier = alternateIdentifier
        self.alternateIdentifier_nsprefix_ = None
        self.entityName = entityName
        self.validate_NonEmptyStringType(self.entityName)
        self.entityName_nsprefix_ = None
        self.entityDescription = entityDescription
        self.validate_NonEmptyStringType(self.entityDescription)
        self.entityDescription_nsprefix_ = None
        if physical is None:
            self.physical = []
        else:
            self.physical = physical
        self.physical_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        self.methods = methods
        self.methods_nsprefix_ = None
        if additionalInfo is None:
            self.additionalInfo = []
        else:
            self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        self.attributeList = attributeList
        self.attributeList_nsprefix_ = None
        if constraint is None:
            self.constraint = []
        else:
            self.constraint = constraint
        self.constraint_nsprefix_ = None
        self.entityType = entityType
        self.validate_NonEmptyStringType(self.entityType)
        self.entityType_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OtherEntityType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OtherEntityType.subclass:
            return OtherEntityType.subclass(*args_, **kwargs_)
        else:
            return OtherEntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternateIdentifier(self):
        return self.alternateIdentifier
    def set_alternateIdentifier(self, alternateIdentifier):
        self.alternateIdentifier = alternateIdentifier
    def add_alternateIdentifier(self, value):
        self.alternateIdentifier.append(value)
    def insert_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier.insert(index, value)
    def replace_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier[index] = value
    def get_entityName(self):
        return self.entityName
    def set_entityName(self, entityName):
        self.entityName = entityName
    def get_entityDescription(self):
        return self.entityDescription
    def set_entityDescription(self, entityDescription):
        self.entityDescription = entityDescription
    def get_physical(self):
        return self.physical
    def set_physical(self, physical):
        self.physical = physical
    def add_physical(self, value):
        self.physical.append(value)
    def insert_physical_at(self, index, value):
        self.physical.insert(index, value)
    def replace_physical_at(self, index, value):
        self.physical[index] = value
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_methods(self):
        return self.methods
    def set_methods(self, methods):
        self.methods = methods
    def get_additionalInfo(self):
        return self.additionalInfo
    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo
    def add_additionalInfo(self, value):
        self.additionalInfo.append(value)
    def insert_additionalInfo_at(self, index, value):
        self.additionalInfo.insert(index, value)
    def replace_additionalInfo_at(self, index, value):
        self.additionalInfo[index] = value
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_attributeList(self):
        return self.attributeList
    def set_attributeList(self, attributeList):
        self.attributeList = attributeList
    def get_constraint(self):
        return self.constraint
    def set_constraint(self, constraint):
        self.constraint = constraint
    def add_constraint(self, value):
        self.constraint.append(value)
    def insert_constraint_at(self, index, value):
        self.constraint.insert(index, value)
    def replace_constraint_at(self, index, value):
        self.constraint[index] = value
    def get_entityType(self):
        return self.entityType
    def set_entityType(self, entityType):
        self.entityType = entityType
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.alternateIdentifier or
            self.entityName is not None or
            self.entityDescription is not None or
            self.physical or
            self.coverage is not None or
            self.methods is not None or
            self.additionalInfo or
            self.annotation or
            self.attributeList is not None or
            self.constraint or
            self.entityType is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:phys="https://eml.ecoinformatics.org/physical-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:att="https://eml.ecoinformatics.org/attribute-2.2.0"  xmlns:con="https://eml.ecoinformatics.org/constraint-2.2.0" ', name_='OtherEntityType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OtherEntityType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OtherEntityType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OtherEntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OtherEntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OtherEntityType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:phys="https://eml.ecoinformatics.org/physical-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:att="https://eml.ecoinformatics.org/attribute-2.2.0"  xmlns:con="https://eml.ecoinformatics.org/constraint-2.2.0" ', name_='OtherEntityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for alternateIdentifier_ in self.alternateIdentifier:
            namespaceprefix_ = self.alternateIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.alternateIdentifier_nsprefix_) else ''
            alternateIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternateIdentifier', pretty_print=pretty_print)
        if self.entityName is not None:
            namespaceprefix_ = self.entityName_nsprefix_ + ':' if (UseCapturedNS_ and self.entityName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentityName>%s</%sentityName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.entityName), input_name='entityName')), namespaceprefix_ , eol_))
        if self.entityDescription is not None:
            namespaceprefix_ = self.entityDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.entityDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentityDescription>%s</%sentityDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.entityDescription), input_name='entityDescription')), namespaceprefix_ , eol_))
        for physical_ in self.physical:
            namespaceprefix_ = self.physical_nsprefix_ + ':' if (UseCapturedNS_ and self.physical_nsprefix_) else ''
            physical_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='physical', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        if self.methods is not None:
            namespaceprefix_ = self.methods_nsprefix_ + ':' if (UseCapturedNS_ and self.methods_nsprefix_) else ''
            self.methods.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methods', pretty_print=pretty_print)
        for additionalInfo_ in self.additionalInfo:
            namespaceprefix_ = self.additionalInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalInfo_nsprefix_) else ''
            additionalInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalInfo', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        if self.attributeList is not None:
            namespaceprefix_ = self.attributeList_nsprefix_ + ':' if (UseCapturedNS_ and self.attributeList_nsprefix_) else ''
            self.attributeList.export(outfile, level, namespaceprefix_, namespacedef_='', name_='attributeList', pretty_print=pretty_print)
        for constraint_ in self.constraint:
            namespaceprefix_ = self.constraint_nsprefix_ + ':' if (UseCapturedNS_ and self.constraint_nsprefix_) else ''
            constraint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='constraint', pretty_print=pretty_print)
        if self.entityType is not None:
            namespaceprefix_ = self.entityType_nsprefix_ + ':' if (UseCapturedNS_ and self.entityType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentityType>%s</%sentityType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.entityType), input_name='entityType')), namespaceprefix_ , eol_))
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternateIdentifier':
            obj_ = alternateIdentifierType23.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternateIdentifier.append(obj_)
            obj_.original_tagname_ = 'alternateIdentifier'
        elif nodeName_ == 'entityName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'entityName')
            value_ = self.gds_validate_string(value_, node, 'entityName')
            self.entityName = value_
            self.entityName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.entityName)
        elif nodeName_ == 'entityDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'entityDescription')
            value_ = self.gds_validate_string(value_, node, 'entityDescription')
            self.entityDescription = value_
            self.entityDescription_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.entityDescription)
        elif nodeName_ == 'physical':
            obj_ = PhysicalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.physical.append(obj_)
            obj_.original_tagname_ = 'physical'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'methods':
            obj_ = MethodsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methods = obj_
            obj_.original_tagname_ = 'methods'
        elif nodeName_ == 'additionalInfo':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalInfo.append(obj_)
            obj_.original_tagname_ = 'additionalInfo'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'attributeList':
            obj_ = AttributeListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.attributeList = obj_
            obj_.original_tagname_ = 'attributeList'
        elif nodeName_ == 'constraint':
            obj_ = ConstraintType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.constraint.append(obj_)
            obj_.original_tagname_ = 'constraint'
        elif nodeName_ == 'entityType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'entityType')
            value_ = self.gds_validate_string(value_, node, 'entityType')
            self.entityType = value_
            self.entityType_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.entityType)
        elif nodeName_ == 'references':
            obj_ = referencesType24.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class OtherEntityType


class PhysicalType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('objectName', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'objectName', 'type': 'xs:string'}, 31),
        MemberSpec_('size', 'sizeType', 0, 1, {'minOccurs': '0', 'name': 'size', 'type': 'sizeType'}, 31),
        MemberSpec_('authentication', 'authenticationType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'authentication', 'type': 'authenticationType'}, 31),
        MemberSpec_('compressionMethod', ['NonEmptyStringType', 'xs:string'], 1, 1, {'name': 'compressionMethod', 'type': 'xs:string'}, 32),
        MemberSpec_('encodingMethod', ['NonEmptyStringType', 'xs:string'], 1, 1, {'name': 'encodingMethod', 'type': 'xs:string'}, 32),
        MemberSpec_('characterEncoding', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'characterEncoding', 'type': 'xs:string'}, None),
        MemberSpec_('dataFormat', 'dataFormatType', 0, 0, {'name': 'dataFormat', 'type': 'dataFormatType'}, None),
        MemberSpec_('distribution', 'PhysicalDistributionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'distribution', 'type': 'PhysicalDistributionType'}, None),
        MemberSpec_('references', 'referencesType27', 0, 0, {'name': 'references', 'type': 'referencesType27'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', objectName=None, size=None, authentication=None, compressionMethod=None, encodingMethod=None, characterEncoding=None, dataFormat=None, distribution=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.objectName = objectName
        self.validate_NonEmptyStringType(self.objectName)
        self.objectName_nsprefix_ = None
        self.size = size
        self.size_nsprefix_ = None
        if authentication is None:
            self.authentication = []
        else:
            self.authentication = authentication
        self.authentication_nsprefix_ = None
        if compressionMethod is None:
            self.compressionMethod = []
        else:
            self.compressionMethod = compressionMethod
        self.compressionMethod_nsprefix_ = None
        if encodingMethod is None:
            self.encodingMethod = []
        else:
            self.encodingMethod = encodingMethod
        self.encodingMethod_nsprefix_ = None
        self.characterEncoding = characterEncoding
        self.validate_NonEmptyStringType(self.characterEncoding)
        self.characterEncoding_nsprefix_ = None
        self.dataFormat = dataFormat
        self.dataFormat_nsprefix_ = None
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.distribution_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PhysicalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PhysicalType.subclass:
            return PhysicalType.subclass(*args_, **kwargs_)
        else:
            return PhysicalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_objectName(self):
        return self.objectName
    def set_objectName(self, objectName):
        self.objectName = objectName
    def get_size(self):
        return self.size
    def set_size(self, size):
        self.size = size
    def get_authentication(self):
        return self.authentication
    def set_authentication(self, authentication):
        self.authentication = authentication
    def add_authentication(self, value):
        self.authentication.append(value)
    def insert_authentication_at(self, index, value):
        self.authentication.insert(index, value)
    def replace_authentication_at(self, index, value):
        self.authentication[index] = value
    def get_compressionMethod(self):
        return self.compressionMethod
    def set_compressionMethod(self, compressionMethod):
        self.compressionMethod = compressionMethod
    def add_compressionMethod(self, value):
        self.compressionMethod.append(value)
    def insert_compressionMethod_at(self, index, value):
        self.compressionMethod.insert(index, value)
    def replace_compressionMethod_at(self, index, value):
        self.compressionMethod[index] = value
    def get_encodingMethod(self):
        return self.encodingMethod
    def set_encodingMethod(self, encodingMethod):
        self.encodingMethod = encodingMethod
    def add_encodingMethod(self, value):
        self.encodingMethod.append(value)
    def insert_encodingMethod_at(self, index, value):
        self.encodingMethod.insert(index, value)
    def replace_encodingMethod_at(self, index, value):
        self.encodingMethod[index] = value
    def get_characterEncoding(self):
        return self.characterEncoding
    def set_characterEncoding(self, characterEncoding):
        self.characterEncoding = characterEncoding
    def get_dataFormat(self):
        return self.dataFormat
    def set_dataFormat(self, dataFormat):
        self.dataFormat = dataFormat
    def get_distribution(self):
        return self.distribution
    def set_distribution(self, distribution):
        self.distribution = distribution
    def add_distribution(self, value):
        self.distribution.append(value)
    def insert_distribution_at(self, index, value):
        self.distribution.insert(index, value)
    def replace_distribution_at(self, index, value):
        self.distribution[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.objectName is not None or
            self.size is not None or
            self.authentication or
            self.compressionMethod or
            self.encodingMethod or
            self.characterEncoding is not None or
            self.dataFormat is not None or
            self.distribution or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='PhysicalType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PhysicalType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PhysicalType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PhysicalType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PhysicalType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PhysicalType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='PhysicalType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.objectName is not None:
            namespaceprefix_ = self.objectName_nsprefix_ + ':' if (UseCapturedNS_ and self.objectName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sobjectName>%s</%sobjectName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.objectName), input_name='objectName')), namespaceprefix_ , eol_))
        if self.size is not None:
            namespaceprefix_ = self.size_nsprefix_ + ':' if (UseCapturedNS_ and self.size_nsprefix_) else ''
            self.size.export(outfile, level, namespaceprefix_, namespacedef_='', name_='size', pretty_print=pretty_print)
        for authentication_ in self.authentication:
            namespaceprefix_ = self.authentication_nsprefix_ + ':' if (UseCapturedNS_ and self.authentication_nsprefix_) else ''
            authentication_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authentication', pretty_print=pretty_print)
        for compressionMethod_ in self.compressionMethod:
            namespaceprefix_ = self.compressionMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.compressionMethod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompressionMethod>%s</%scompressionMethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(compressionMethod_), input_name='compressionMethod')), namespaceprefix_ , eol_))
        for encodingMethod_ in self.encodingMethod:
            namespaceprefix_ = self.encodingMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.encodingMethod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sencodingMethod>%s</%sencodingMethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(encodingMethod_), input_name='encodingMethod')), namespaceprefix_ , eol_))
        if self.characterEncoding is not None:
            namespaceprefix_ = self.characterEncoding_nsprefix_ + ':' if (UseCapturedNS_ and self.characterEncoding_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scharacterEncoding>%s</%scharacterEncoding>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.characterEncoding), input_name='characterEncoding')), namespaceprefix_ , eol_))
        if self.dataFormat is not None:
            namespaceprefix_ = self.dataFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.dataFormat_nsprefix_) else ''
            self.dataFormat.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dataFormat', pretty_print=pretty_print)
        for distribution_ in self.distribution:
            namespaceprefix_ = self.distribution_nsprefix_ + ':' if (UseCapturedNS_ and self.distribution_nsprefix_) else ''
            distribution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='distribution', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'objectName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'objectName')
            value_ = self.gds_validate_string(value_, node, 'objectName')
            self.objectName = value_
            self.objectName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.objectName)
        elif nodeName_ == 'size':
            obj_ = sizeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.size = obj_
            obj_.original_tagname_ = 'size'
        elif nodeName_ == 'authentication':
            obj_ = authenticationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authentication.append(obj_)
            obj_.original_tagname_ = 'authentication'
        elif nodeName_ == 'compressionMethod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'compressionMethod')
            value_ = self.gds_validate_string(value_, node, 'compressionMethod')
            self.compressionMethod.append(value_)
            self.compressionMethod_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.compressionMethod[-1])
        elif nodeName_ == 'encodingMethod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'encodingMethod')
            value_ = self.gds_validate_string(value_, node, 'encodingMethod')
            self.encodingMethod.append(value_)
            self.encodingMethod_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.encodingMethod[-1])
        elif nodeName_ == 'characterEncoding':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'characterEncoding')
            value_ = self.gds_validate_string(value_, node, 'characterEncoding')
            self.characterEncoding = value_
            self.characterEncoding_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.characterEncoding)
        elif nodeName_ == 'dataFormat':
            obj_ = dataFormatType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dataFormat = obj_
            obj_.original_tagname_ = 'dataFormat'
        elif nodeName_ == 'distribution':
            obj_ = PhysicalDistributionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distribution.append(obj_)
            obj_.original_tagname_ = 'distribution'
        elif nodeName_ == 'references':
            obj_ = referencesType27.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class PhysicalType


class PhysicalDistributionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('online', 'PhysicalOnlineType', 0, 0, {'name': 'online', 'type': 'PhysicalOnlineType'}, 34),
        MemberSpec_('offline', 'OfflineType', 0, 0, {'name': 'offline', 'type': 'OfflineType'}, 34),
        MemberSpec_('inline', 'InlineType', 0, 0, {'name': 'inline', 'type': 'InlineType'}, 34),
        MemberSpec_('access', 'AccessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'type': 'AccessType'}, None),
        MemberSpec_('references', 'referencesType28', 0, 0, {'name': 'references', 'type': 'referencesType28'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', online=None, offline=None, inline=None, access=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.online = online
        self.online_nsprefix_ = None
        self.offline = offline
        self.offline_nsprefix_ = None
        self.inline = inline
        self.inline_nsprefix_ = None
        self.access = access
        self.access_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PhysicalDistributionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PhysicalDistributionType.subclass:
            return PhysicalDistributionType.subclass(*args_, **kwargs_)
        else:
            return PhysicalDistributionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_online(self):
        return self.online
    def set_online(self, online):
        self.online = online
    def get_offline(self):
        return self.offline
    def set_offline(self, offline):
        self.offline = offline
    def get_inline(self):
        return self.inline
    def set_inline(self, inline):
        self.inline = inline
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.online is not None or
            self.offline is not None or
            self.inline is not None or
            self.access is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:acc="https://eml.ecoinformatics.org/access-2.2.0" ', name_='PhysicalDistributionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PhysicalDistributionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PhysicalDistributionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PhysicalDistributionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PhysicalDistributionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PhysicalDistributionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:acc="https://eml.ecoinformatics.org/access-2.2.0" ', name_='PhysicalDistributionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.online is not None:
            namespaceprefix_ = self.online_nsprefix_ + ':' if (UseCapturedNS_ and self.online_nsprefix_) else ''
            self.online.export(outfile, level, namespaceprefix_, namespacedef_='', name_='online', pretty_print=pretty_print)
        if self.offline is not None:
            namespaceprefix_ = self.offline_nsprefix_ + ':' if (UseCapturedNS_ and self.offline_nsprefix_) else ''
            self.offline.export(outfile, level, namespaceprefix_, namespacedef_='', name_='offline', pretty_print=pretty_print)
        if self.inline is not None:
            namespaceprefix_ = self.inline_nsprefix_ + ':' if (UseCapturedNS_ and self.inline_nsprefix_) else ''
            self.inline.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inline', pretty_print=pretty_print)
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_, namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'online':
            obj_ = PhysicalOnlineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.online = obj_
            obj_.original_tagname_ = 'online'
        elif nodeName_ == 'offline':
            obj_ = OfflineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.offline = obj_
            obj_.original_tagname_ = 'offline'
        elif nodeName_ == 'inline':
            obj_ = InlineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inline = obj_
            obj_.original_tagname_ = 'inline'
        elif nodeName_ == 'access':
            obj_ = AccessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'references':
            obj_ = referencesType28.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class PhysicalDistributionType


class PhysicalOnlineType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('onlineDescription', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'onlineDescription', 'type': 'xs:string'}, None),
        MemberSpec_('url', 'UrlType', 0, 0, {'name': 'url', 'type': 'UrlType'}, 35),
        MemberSpec_('connection', 'ConnectionType', 0, 0, {'name': 'connection', 'type': 'ConnectionType'}, 35),
    ]
    subclass = None
    superclass = None
    def __init__(self, onlineDescription=None, url=None, connection=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.onlineDescription = onlineDescription
        self.validate_NonEmptyStringType(self.onlineDescription)
        self.onlineDescription_nsprefix_ = None
        self.url = url
        self.url_nsprefix_ = None
        self.connection = connection
        self.connection_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PhysicalOnlineType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PhysicalOnlineType.subclass:
            return PhysicalOnlineType.subclass(*args_, **kwargs_)
        else:
            return PhysicalOnlineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_onlineDescription(self):
        return self.onlineDescription
    def set_onlineDescription(self, onlineDescription):
        self.onlineDescription = onlineDescription
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_connection(self):
        return self.connection
    def set_connection(self, connection):
        self.connection = connection
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.onlineDescription is not None or
            self.url is not None or
            self.connection is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='PhysicalOnlineType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PhysicalOnlineType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PhysicalOnlineType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PhysicalOnlineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PhysicalOnlineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PhysicalOnlineType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='PhysicalOnlineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.onlineDescription is not None:
            namespaceprefix_ = self.onlineDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.onlineDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sonlineDescription>%s</%sonlineDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.onlineDescription), input_name='onlineDescription')), namespaceprefix_ , eol_))
        if self.url is not None:
            namespaceprefix_ = self.url_nsprefix_ + ':' if (UseCapturedNS_ and self.url_nsprefix_) else ''
            self.url.export(outfile, level, namespaceprefix_, namespacedef_='', name_='url', pretty_print=pretty_print)
        if self.connection is not None:
            namespaceprefix_ = self.connection_nsprefix_ + ':' if (UseCapturedNS_ and self.connection_nsprefix_) else ''
            self.connection.export(outfile, level, namespaceprefix_, namespacedef_='', name_='connection', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'onlineDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'onlineDescription')
            value_ = self.gds_validate_string(value_, node, 'onlineDescription')
            self.onlineDescription = value_
            self.onlineDescription_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.onlineDescription)
        elif nodeName_ == 'url':
            obj_ = UrlType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.url = obj_
            obj_.original_tagname_ = 'url'
        elif nodeName_ == 'connection':
            obj_ = ConnectionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.connection = obj_
            obj_.original_tagname_ = 'connection'
# end class PhysicalOnlineType


class MethodsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('methodStep', 'methodStepType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'methodStep', 'type': 'methodStepType'}, None),
        MemberSpec_('sampling', 'samplingType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'sampling', 'type': 'samplingType'}, None),
        MemberSpec_('qualityControl', 'ProcedureStepType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'qualityControl', 'type': 'ProcedureStepType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, methodStep=None, sampling=None, qualityControl=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if methodStep is None:
            self.methodStep = []
        else:
            self.methodStep = methodStep
        self.methodStep_nsprefix_ = None
        if sampling is None:
            self.sampling = []
        else:
            self.sampling = sampling
        self.sampling_nsprefix_ = None
        if qualityControl is None:
            self.qualityControl = []
        else:
            self.qualityControl = qualityControl
        self.qualityControl_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MethodsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MethodsType.subclass:
            return MethodsType.subclass(*args_, **kwargs_)
        else:
            return MethodsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_methodStep(self):
        return self.methodStep
    def set_methodStep(self, methodStep):
        self.methodStep = methodStep
    def add_methodStep(self, value):
        self.methodStep.append(value)
    def insert_methodStep_at(self, index, value):
        self.methodStep.insert(index, value)
    def replace_methodStep_at(self, index, value):
        self.methodStep[index] = value
    def get_sampling(self):
        return self.sampling
    def set_sampling(self, sampling):
        self.sampling = sampling
    def add_sampling(self, value):
        self.sampling.append(value)
    def insert_sampling_at(self, index, value):
        self.sampling.insert(index, value)
    def replace_sampling_at(self, index, value):
        self.sampling[index] = value
    def get_qualityControl(self):
        return self.qualityControl
    def set_qualityControl(self, qualityControl):
        self.qualityControl = qualityControl
    def add_qualityControl(self, value):
        self.qualityControl.append(value)
    def insert_qualityControl_at(self, index, value):
        self.qualityControl.insert(index, value)
    def replace_qualityControl_at(self, index, value):
        self.qualityControl[index] = value
    def hasContent_(self):
        if (
            self.methodStep or
            self.sampling or
            self.qualityControl
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='MethodsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MethodsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MethodsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MethodsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MethodsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MethodsType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='MethodsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for methodStep_ in self.methodStep:
            namespaceprefix_ = self.methodStep_nsprefix_ + ':' if (UseCapturedNS_ and self.methodStep_nsprefix_) else ''
            methodStep_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methodStep', pretty_print=pretty_print)
        for sampling_ in self.sampling:
            namespaceprefix_ = self.sampling_nsprefix_ + ':' if (UseCapturedNS_ and self.sampling_nsprefix_) else ''
            sampling_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sampling', pretty_print=pretty_print)
        for qualityControl_ in self.qualityControl:
            namespaceprefix_ = self.qualityControl_nsprefix_ + ':' if (UseCapturedNS_ and self.qualityControl_nsprefix_) else ''
            qualityControl_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='qualityControl', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'methodStep':
            obj_ = methodStepType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methodStep.append(obj_)
            obj_.original_tagname_ = 'methodStep'
        elif nodeName_ == 'sampling':
            obj_ = samplingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sampling.append(obj_)
            obj_.original_tagname_ = 'sampling'
        elif nodeName_ == 'qualityControl':
            class_obj_ = self.get_class_obj_(child_, ProcedureStepType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.qualityControl.append(obj_)
            obj_.original_tagname_ = 'qualityControl'
# end class MethodsType


class ProcedureStepType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('description', 'TextType', 0, 0, {'name': 'description', 'type': 'TextType'}, None),
        MemberSpec_('citation', 'CitationType', 1, 1, {'name': 'citation', 'type': 'CitationType'}, 36),
        MemberSpec_('protocol', 'ProtocolType', 1, 1, {'name': 'protocol', 'type': 'ProtocolType'}, 36),
        MemberSpec_('instrumentation', ['NonEmptyStringType', 'xs:string'], 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'instrumentation', 'type': 'xs:string'}, None),
        MemberSpec_('software', 'SoftwareType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'software', 'type': 'SoftwareType'}, None),
        MemberSpec_('subStep', 'ProcedureStepType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'subStep', 'type': 'ProcedureStepType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, description=None, citation=None, protocol=None, instrumentation=None, software=None, subStep=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        if citation is None:
            self.citation = []
        else:
            self.citation = citation
        self.citation_nsprefix_ = None
        if protocol is None:
            self.protocol = []
        else:
            self.protocol = protocol
        self.protocol_nsprefix_ = None
        if instrumentation is None:
            self.instrumentation = []
        else:
            self.instrumentation = instrumentation
        self.instrumentation_nsprefix_ = None
        if software is None:
            self.software = []
        else:
            self.software = software
        self.software_nsprefix_ = None
        if subStep is None:
            self.subStep = []
        else:
            self.subStep = subStep
        self.subStep_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProcedureStepType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProcedureStepType.subclass:
            return ProcedureStepType.subclass(*args_, **kwargs_)
        else:
            return ProcedureStepType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_citation(self):
        return self.citation
    def set_citation(self, citation):
        self.citation = citation
    def add_citation(self, value):
        self.citation.append(value)
    def insert_citation_at(self, index, value):
        self.citation.insert(index, value)
    def replace_citation_at(self, index, value):
        self.citation[index] = value
    def get_protocol(self):
        return self.protocol
    def set_protocol(self, protocol):
        self.protocol = protocol
    def add_protocol(self, value):
        self.protocol.append(value)
    def insert_protocol_at(self, index, value):
        self.protocol.insert(index, value)
    def replace_protocol_at(self, index, value):
        self.protocol[index] = value
    def get_instrumentation(self):
        return self.instrumentation
    def set_instrumentation(self, instrumentation):
        self.instrumentation = instrumentation
    def add_instrumentation(self, value):
        self.instrumentation.append(value)
    def insert_instrumentation_at(self, index, value):
        self.instrumentation.insert(index, value)
    def replace_instrumentation_at(self, index, value):
        self.instrumentation[index] = value
    def get_software(self):
        return self.software
    def set_software(self, software):
        self.software = software
    def add_software(self, value):
        self.software.append(value)
    def insert_software_at(self, index, value):
        self.software.insert(index, value)
    def replace_software_at(self, index, value):
        self.software[index] = value
    def get_subStep(self):
        return self.subStep
    def set_subStep(self, subStep):
        self.subStep = subStep
    def add_subStep(self, value):
        self.subStep.append(value)
    def insert_subStep_at(self, index, value):
        self.subStep.insert(index, value)
    def replace_subStep_at(self, index, value):
        self.subStep[index] = value
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.description is not None or
            self.citation or
            self.protocol or
            self.instrumentation or
            self.software or
            self.subStep
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0"  xmlns:pro="https://eml.ecoinformatics.org/protocol-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:sw="https://eml.ecoinformatics.org/software-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ProcedureStepType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProcedureStepType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProcedureStepType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProcedureStepType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProcedureStepType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProcedureStepType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cit="https://eml.ecoinformatics.org/literature-2.2.0"  xmlns:pro="https://eml.ecoinformatics.org/protocol-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:sw="https://eml.ecoinformatics.org/software-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='ProcedureStepType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            self.description.export(outfile, level, namespaceprefix_, namespacedef_='', name_='description', pretty_print=pretty_print)
        for citation_ in self.citation:
            namespaceprefix_ = self.citation_nsprefix_ + ':' if (UseCapturedNS_ and self.citation_nsprefix_) else ''
            citation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='citation', pretty_print=pretty_print)
        for protocol_ in self.protocol:
            namespaceprefix_ = self.protocol_nsprefix_ + ':' if (UseCapturedNS_ and self.protocol_nsprefix_) else ''
            protocol_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protocol', pretty_print=pretty_print)
        for instrumentation_ in self.instrumentation:
            namespaceprefix_ = self.instrumentation_nsprefix_ + ':' if (UseCapturedNS_ and self.instrumentation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstrumentation>%s</%sinstrumentation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(instrumentation_), input_name='instrumentation')), namespaceprefix_ , eol_))
        for software_ in self.software:
            namespaceprefix_ = self.software_nsprefix_ + ':' if (UseCapturedNS_ and self.software_nsprefix_) else ''
            software_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software', pretty_print=pretty_print)
        for subStep_ in self.subStep:
            namespaceprefix_ = self.subStep_nsprefix_ + ':' if (UseCapturedNS_ and self.subStep_nsprefix_) else ''
            subStep_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subStep', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'description':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.description = obj_
            obj_.original_tagname_ = 'description'
        elif nodeName_ == 'citation':
            obj_ = CitationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.citation.append(obj_)
            obj_.original_tagname_ = 'citation'
        elif nodeName_ == 'protocol':
            obj_ = ProtocolType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protocol.append(obj_)
            obj_.original_tagname_ = 'protocol'
        elif nodeName_ == 'instrumentation':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'instrumentation')
            value_ = self.gds_validate_string(value_, node, 'instrumentation')
            self.instrumentation.append(value_)
            self.instrumentation_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.instrumentation[-1])
        elif nodeName_ == 'software':
            obj_ = SoftwareType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software.append(obj_)
            obj_.original_tagname_ = 'software'
        elif nodeName_ == 'subStep':
            class_obj_ = self.get_class_obj_(child_, ProcedureStepType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subStep.append(obj_)
            obj_.original_tagname_ = 'subStep'
# end class ProcedureStepType


class SoftwareType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('alternateIdentifier', 'alternateIdentifierType29', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'alternateIdentifier', 'type': 'alternateIdentifierType29'}, 37),
        MemberSpec_('shortName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'shortName', 'type': 'xs:string'}, 37),
        MemberSpec_('title', 'i18nNonEmptyStringType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'title', 'type': 'i18nNonEmptyStringType'}, 37),
        MemberSpec_('creator', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'creator', 'type': 'ResponsibleParty'}, 37),
        MemberSpec_('metadataProvider', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'metadataProvider', 'type': 'ResponsibleParty'}, 37),
        MemberSpec_('associatedParty', 'associatedPartyType30', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'associatedParty', 'type': 'associatedPartyType30'}, 37),
        MemberSpec_('pubDate', 'yearDate', 0, 1, {'minOccurs': '0', 'name': 'pubDate', 'type': 'xs:string'}, 37),
        MemberSpec_('language', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'language', 'type': 'i18nNonEmptyStringType'}, 37),
        MemberSpec_('series', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'series', 'type': 'xs:string'}, 37),
        MemberSpec_('abstract', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'abstract', 'type': 'TextType'}, 37),
        MemberSpec_('keywordSet', 'keywordSetType31', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'keywordSet', 'type': 'keywordSetType31'}, 37),
        MemberSpec_('additionalInfo', 'TextType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalInfo', 'type': 'TextType'}, 37),
        MemberSpec_('intellectualRights', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'intellectualRights', 'type': 'TextType'}, 37),
        MemberSpec_('licensed', 'LicenseType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'licensed', 'type': 'LicenseType'}, 37),
        MemberSpec_('distribution', 'DistributionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'distribution', 'type': 'DistributionType'}, 37),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 37),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 37),
        MemberSpec_('implementation', 'implementationType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'implementation', 'type': 'implementationType'}, 37),
        MemberSpec_('dependency', 'DependencyType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'dependency', 'type': 'DependencyType'}, 37),
        MemberSpec_('licenseURL', ['NonEmptyStringType', 'xs:string'], 1, 1, {'name': 'licenseURL', 'type': 'xs:string'}, 38),
        MemberSpec_('license', ['NonEmptyStringType', 'xs:string'], 1, 1, {'name': 'license', 'type': 'xs:string'}, 38),
        MemberSpec_('version', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'version', 'type': 'xs:string'}, None),
        MemberSpec_('project', 'ResearchProjectType', 0, 1, {'minOccurs': '0', 'name': 'project', 'type': 'ResearchProjectType'}, None),
        MemberSpec_('references', 'referencesType33', 0, 0, {'name': 'references', 'type': 'referencesType33'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', alternateIdentifier=None, shortName=None, title=None, creator=None, metadataProvider=None, associatedParty=None, pubDate=None, language=None, series=None, abstract=None, keywordSet=None, additionalInfo=None, intellectualRights=None, licensed=None, distribution=None, coverage=None, annotation=None, implementation=None, dependency=None, licenseURL=None, license=None, version=None, project=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if alternateIdentifier is None:
            self.alternateIdentifier = []
        else:
            self.alternateIdentifier = alternateIdentifier
        self.alternateIdentifier_nsprefix_ = None
        self.shortName = shortName
        self.validate_NonEmptyStringType(self.shortName)
        self.shortName_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if creator is None:
            self.creator = []
        else:
            self.creator = creator
        self.creator_nsprefix_ = None
        if metadataProvider is None:
            self.metadataProvider = []
        else:
            self.metadataProvider = metadataProvider
        self.metadataProvider_nsprefix_ = None
        if associatedParty is None:
            self.associatedParty = []
        else:
            self.associatedParty = associatedParty
        self.associatedParty_nsprefix_ = None
        self.pubDate = pubDate
        self.validate_yearDate(self.pubDate)
        self.pubDate_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.series = series
        self.validate_NonEmptyStringType(self.series)
        self.series_nsprefix_ = None
        self.abstract = abstract
        self.abstract_nsprefix_ = None
        if keywordSet is None:
            self.keywordSet = []
        else:
            self.keywordSet = keywordSet
        self.keywordSet_nsprefix_ = None
        if additionalInfo is None:
            self.additionalInfo = []
        else:
            self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.intellectualRights = intellectualRights
        self.intellectualRights_nsprefix_ = None
        if licensed is None:
            self.licensed = []
        else:
            self.licensed = licensed
        self.licensed_nsprefix_ = None
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.distribution_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        if implementation is None:
            self.implementation = []
        else:
            self.implementation = implementation
        self.implementation_nsprefix_ = None
        if dependency is None:
            self.dependency = []
        else:
            self.dependency = dependency
        self.dependency_nsprefix_ = None
        if licenseURL is None:
            self.licenseURL = []
        else:
            self.licenseURL = licenseURL
        self.licenseURL_nsprefix_ = None
        if license is None:
            self.license = []
        else:
            self.license = license
        self.license_nsprefix_ = None
        self.version = version
        self.validate_NonEmptyStringType(self.version)
        self.version_nsprefix_ = None
        self.project = project
        self.project_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SoftwareType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SoftwareType.subclass:
            return SoftwareType.subclass(*args_, **kwargs_)
        else:
            return SoftwareType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternateIdentifier(self):
        return self.alternateIdentifier
    def set_alternateIdentifier(self, alternateIdentifier):
        self.alternateIdentifier = alternateIdentifier
    def add_alternateIdentifier(self, value):
        self.alternateIdentifier.append(value)
    def insert_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier.insert(index, value)
    def replace_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier[index] = value
    def get_shortName(self):
        return self.shortName
    def set_shortName(self, shortName):
        self.shortName = shortName
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_creator(self):
        return self.creator
    def set_creator(self, creator):
        self.creator = creator
    def add_creator(self, value):
        self.creator.append(value)
    def insert_creator_at(self, index, value):
        self.creator.insert(index, value)
    def replace_creator_at(self, index, value):
        self.creator[index] = value
    def get_metadataProvider(self):
        return self.metadataProvider
    def set_metadataProvider(self, metadataProvider):
        self.metadataProvider = metadataProvider
    def add_metadataProvider(self, value):
        self.metadataProvider.append(value)
    def insert_metadataProvider_at(self, index, value):
        self.metadataProvider.insert(index, value)
    def replace_metadataProvider_at(self, index, value):
        self.metadataProvider[index] = value
    def get_associatedParty(self):
        return self.associatedParty
    def set_associatedParty(self, associatedParty):
        self.associatedParty = associatedParty
    def add_associatedParty(self, value):
        self.associatedParty.append(value)
    def insert_associatedParty_at(self, index, value):
        self.associatedParty.insert(index, value)
    def replace_associatedParty_at(self, index, value):
        self.associatedParty[index] = value
    def get_pubDate(self):
        return self.pubDate
    def set_pubDate(self, pubDate):
        self.pubDate = pubDate
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_series(self):
        return self.series
    def set_series(self, series):
        self.series = series
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def get_keywordSet(self):
        return self.keywordSet
    def set_keywordSet(self, keywordSet):
        self.keywordSet = keywordSet
    def add_keywordSet(self, value):
        self.keywordSet.append(value)
    def insert_keywordSet_at(self, index, value):
        self.keywordSet.insert(index, value)
    def replace_keywordSet_at(self, index, value):
        self.keywordSet[index] = value
    def get_additionalInfo(self):
        return self.additionalInfo
    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo
    def add_additionalInfo(self, value):
        self.additionalInfo.append(value)
    def insert_additionalInfo_at(self, index, value):
        self.additionalInfo.insert(index, value)
    def replace_additionalInfo_at(self, index, value):
        self.additionalInfo[index] = value
    def get_intellectualRights(self):
        return self.intellectualRights
    def set_intellectualRights(self, intellectualRights):
        self.intellectualRights = intellectualRights
    def get_licensed(self):
        return self.licensed
    def set_licensed(self, licensed):
        self.licensed = licensed
    def add_licensed(self, value):
        self.licensed.append(value)
    def insert_licensed_at(self, index, value):
        self.licensed.insert(index, value)
    def replace_licensed_at(self, index, value):
        self.licensed[index] = value
    def get_distribution(self):
        return self.distribution
    def set_distribution(self, distribution):
        self.distribution = distribution
    def add_distribution(self, value):
        self.distribution.append(value)
    def insert_distribution_at(self, index, value):
        self.distribution.insert(index, value)
    def replace_distribution_at(self, index, value):
        self.distribution[index] = value
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_implementation(self):
        return self.implementation
    def set_implementation(self, implementation):
        self.implementation = implementation
    def add_implementation(self, value):
        self.implementation.append(value)
    def insert_implementation_at(self, index, value):
        self.implementation.insert(index, value)
    def replace_implementation_at(self, index, value):
        self.implementation[index] = value
    def get_dependency(self):
        return self.dependency
    def set_dependency(self, dependency):
        self.dependency = dependency
    def add_dependency(self, value):
        self.dependency.append(value)
    def insert_dependency_at(self, index, value):
        self.dependency.insert(index, value)
    def replace_dependency_at(self, index, value):
        self.dependency[index] = value
    def get_licenseURL(self):
        return self.licenseURL
    def set_licenseURL(self, licenseURL):
        self.licenseURL = licenseURL
    def add_licenseURL(self, value):
        self.licenseURL.append(value)
    def insert_licenseURL_at(self, index, value):
        self.licenseURL.insert(index, value)
    def replace_licenseURL_at(self, index, value):
        self.licenseURL[index] = value
    def get_license(self):
        return self.license
    def set_license(self, license):
        self.license = license
    def add_license(self, value):
        self.license.append(value)
    def insert_license_at(self, index, value):
        self.license.insert(index, value)
    def replace_license_at(self, index, value):
        self.license[index] = value
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_project(self):
        return self.project
    def set_project(self, project):
        self.project = project
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_yearDate(self, value):
        result = True
        # Validate type yearDate, a restriction on None.
        pass
        return result
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.alternateIdentifier or
            self.shortName is not None or
            self.title or
            self.creator or
            self.metadataProvider or
            self.associatedParty or
            self.pubDate is not None or
            self.language is not None or
            self.series is not None or
            self.abstract is not None or
            self.keywordSet or
            self.additionalInfo or
            self.intellectualRights is not None or
            self.licensed or
            self.distribution or
            self.coverage is not None or
            self.annotation or
            self.implementation or
            self.dependency or
            self.licenseURL or
            self.license or
            self.version is not None or
            self.project is not None or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:proj="https://eml.ecoinformatics.org/project-2.2.0" ', name_='SoftwareType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SoftwareType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SoftwareType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SoftwareType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SoftwareType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SoftwareType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:proj="https://eml.ecoinformatics.org/project-2.2.0" ', name_='SoftwareType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for alternateIdentifier_ in self.alternateIdentifier:
            namespaceprefix_ = self.alternateIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.alternateIdentifier_nsprefix_) else ''
            alternateIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternateIdentifier', pretty_print=pretty_print)
        if self.shortName is not None:
            namespaceprefix_ = self.shortName_nsprefix_ + ':' if (UseCapturedNS_ and self.shortName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshortName>%s</%sshortName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shortName), input_name='shortName')), namespaceprefix_ , eol_))
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for creator_ in self.creator:
            namespaceprefix_ = self.creator_nsprefix_ + ':' if (UseCapturedNS_ and self.creator_nsprefix_) else ''
            creator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='creator', pretty_print=pretty_print)
        for metadataProvider_ in self.metadataProvider:
            namespaceprefix_ = self.metadataProvider_nsprefix_ + ':' if (UseCapturedNS_ and self.metadataProvider_nsprefix_) else ''
            metadataProvider_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='metadataProvider', pretty_print=pretty_print)
        for associatedParty_ in self.associatedParty:
            namespaceprefix_ = self.associatedParty_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedParty_nsprefix_) else ''
            associatedParty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedParty', pretty_print=pretty_print)
        if self.pubDate is not None:
            namespaceprefix_ = self.pubDate_nsprefix_ + ':' if (UseCapturedNS_ and self.pubDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spubDate>%s</%spubDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pubDate), input_name='pubDate')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.series is not None:
            namespaceprefix_ = self.series_nsprefix_ + ':' if (UseCapturedNS_ and self.series_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseries>%s</%sseries>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.series), input_name='series')), namespaceprefix_ , eol_))
        if self.abstract is not None:
            namespaceprefix_ = self.abstract_nsprefix_ + ':' if (UseCapturedNS_ and self.abstract_nsprefix_) else ''
            self.abstract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstract', pretty_print=pretty_print)
        for keywordSet_ in self.keywordSet:
            namespaceprefix_ = self.keywordSet_nsprefix_ + ':' if (UseCapturedNS_ and self.keywordSet_nsprefix_) else ''
            keywordSet_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='keywordSet', pretty_print=pretty_print)
        for additionalInfo_ in self.additionalInfo:
            namespaceprefix_ = self.additionalInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalInfo_nsprefix_) else ''
            additionalInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalInfo', pretty_print=pretty_print)
        if self.intellectualRights is not None:
            namespaceprefix_ = self.intellectualRights_nsprefix_ + ':' if (UseCapturedNS_ and self.intellectualRights_nsprefix_) else ''
            self.intellectualRights.export(outfile, level, namespaceprefix_, namespacedef_='', name_='intellectualRights', pretty_print=pretty_print)
        for licensed_ in self.licensed:
            namespaceprefix_ = self.licensed_nsprefix_ + ':' if (UseCapturedNS_ and self.licensed_nsprefix_) else ''
            licensed_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='licensed', pretty_print=pretty_print)
        for distribution_ in self.distribution:
            namespaceprefix_ = self.distribution_nsprefix_ + ':' if (UseCapturedNS_ and self.distribution_nsprefix_) else ''
            distribution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='distribution', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        for implementation_ in self.implementation:
            namespaceprefix_ = self.implementation_nsprefix_ + ':' if (UseCapturedNS_ and self.implementation_nsprefix_) else ''
            implementation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='implementation', pretty_print=pretty_print)
        for dependency_ in self.dependency:
            namespaceprefix_ = self.dependency_nsprefix_ + ':' if (UseCapturedNS_ and self.dependency_nsprefix_) else ''
            dependency_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dependency', pretty_print=pretty_print)
        for licenseURL_ in self.licenseURL:
            namespaceprefix_ = self.licenseURL_nsprefix_ + ':' if (UseCapturedNS_ and self.licenseURL_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseURL>%s</%slicenseURL>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(licenseURL_), input_name='licenseURL')), namespaceprefix_ , eol_))
        for license_ in self.license:
            namespaceprefix_ = self.license_nsprefix_ + ':' if (UseCapturedNS_ and self.license_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicense>%s</%slicense>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(license_), input_name='license')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.project is not None:
            namespaceprefix_ = self.project_nsprefix_ + ':' if (UseCapturedNS_ and self.project_nsprefix_) else ''
            self.project.export(outfile, level, namespaceprefix_, namespacedef_='', name_='project', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternateIdentifier':
            obj_ = alternateIdentifierType29.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternateIdentifier.append(obj_)
            obj_.original_tagname_ = 'alternateIdentifier'
        elif nodeName_ == 'shortName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shortName')
            value_ = self.gds_validate_string(value_, node, 'shortName')
            self.shortName = value_
            self.shortName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.shortName)
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'creator':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.creator.append(obj_)
            obj_.original_tagname_ = 'creator'
        elif nodeName_ == 'metadataProvider':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.metadataProvider.append(obj_)
            obj_.original_tagname_ = 'metadataProvider'
        elif nodeName_ == 'associatedParty':
            obj_ = associatedPartyType30.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedParty.append(obj_)
            obj_.original_tagname_ = 'associatedParty'
        elif nodeName_ == 'pubDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pubDate')
            value_ = self.gds_validate_string(value_, node, 'pubDate')
            self.pubDate = value_
            self.pubDate_nsprefix_ = child_.prefix
            # validate type yearDate
            self.validate_yearDate(self.pubDate)
        elif nodeName_ == 'language':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'series':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'series')
            value_ = self.gds_validate_string(value_, node, 'series')
            self.series = value_
            self.series_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.series)
        elif nodeName_ == 'abstract':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstract = obj_
            obj_.original_tagname_ = 'abstract'
        elif nodeName_ == 'keywordSet':
            obj_ = keywordSetType31.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.keywordSet.append(obj_)
            obj_.original_tagname_ = 'keywordSet'
        elif nodeName_ == 'additionalInfo':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalInfo.append(obj_)
            obj_.original_tagname_ = 'additionalInfo'
        elif nodeName_ == 'intellectualRights':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intellectualRights = obj_
            obj_.original_tagname_ = 'intellectualRights'
        elif nodeName_ == 'licensed':
            obj_ = LicenseType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.licensed.append(obj_)
            obj_.original_tagname_ = 'licensed'
        elif nodeName_ == 'distribution':
            obj_ = DistributionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distribution.append(obj_)
            obj_.original_tagname_ = 'distribution'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'implementation':
            obj_ = implementationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.implementation.append(obj_)
            obj_.original_tagname_ = 'implementation'
        elif nodeName_ == 'dependency':
            obj_ = DependencyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dependency.append(obj_)
            obj_.original_tagname_ = 'dependency'
        elif nodeName_ == 'licenseURL':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'licenseURL')
            value_ = self.gds_validate_string(value_, node, 'licenseURL')
            self.licenseURL.append(value_)
            self.licenseURL_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.licenseURL[-1])
        elif nodeName_ == 'license':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'license')
            value_ = self.gds_validate_string(value_, node, 'license')
            self.license.append(value_)
            self.license_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.license[-1])
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.version)
        elif nodeName_ == 'project':
            obj_ = ResearchProjectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.project = obj_
            obj_.original_tagname_ = 'project'
        elif nodeName_ == 'references':
            obj_ = referencesType33.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class SoftwareType


class DependencyType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('action', ['Action', 'xs:string'], 0, 0, {'name': 'action', 'type': 'xs:string'}, None),
        MemberSpec_('software', 'SoftwareType', 0, 0, {'name': 'software', 'type': 'SoftwareType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, action=None, software=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.action = action
        self.validate_Action(self.action)
        self.action_nsprefix_ = None
        self.software = software
        self.software_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DependencyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DependencyType.subclass:
            return DependencyType.subclass(*args_, **kwargs_)
        else:
            return DependencyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_action(self):
        return self.action
    def set_action(self, action):
        self.action = action
    def get_software(self):
        return self.software
    def set_software(self, software):
        self.software = software
    def validate_Action(self, value):
        result = True
        # Validate type Action, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['install', 'assert']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Action' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.action is not None or
            self.software is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='DependencyType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DependencyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DependencyType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DependencyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DependencyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DependencyType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='DependencyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.action is not None:
            namespaceprefix_ = self.action_nsprefix_ + ':' if (UseCapturedNS_ and self.action_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saction>%s</%saction>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.action), input_name='action')), namespaceprefix_ , eol_))
        if self.software is not None:
            namespaceprefix_ = self.software_nsprefix_ + ':' if (UseCapturedNS_ and self.software_nsprefix_) else ''
            self.software.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'action':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'action')
            value_ = self.gds_validate_string(value_, node, 'action')
            self.action = value_
            self.action_nsprefix_ = child_.prefix
            # validate type Action
            self.validate_Action(self.action)
        elif nodeName_ == 'software':
            obj_ = SoftwareType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software = obj_
            obj_.original_tagname_ = 'software'
# end class DependencyType


class ProtocolType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('alternateIdentifier', 'alternateIdentifierType34', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'alternateIdentifier', 'type': 'alternateIdentifierType34'}, 39),
        MemberSpec_('shortName', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'shortName', 'type': 'xs:string'}, 39),
        MemberSpec_('title', 'i18nNonEmptyStringType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'title', 'type': 'i18nNonEmptyStringType'}, 39),
        MemberSpec_('creator', 'ResponsibleParty', 1, 0, {'maxOccurs': 'unbounded', 'name': 'creator', 'type': 'ResponsibleParty'}, 39),
        MemberSpec_('metadataProvider', 'ResponsibleParty', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'metadataProvider', 'type': 'ResponsibleParty'}, 39),
        MemberSpec_('associatedParty', 'associatedPartyType35', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'associatedParty', 'type': 'associatedPartyType35'}, 39),
        MemberSpec_('pubDate', 'yearDate', 0, 1, {'minOccurs': '0', 'name': 'pubDate', 'type': 'xs:string'}, 39),
        MemberSpec_('language', 'i18nNonEmptyStringType', 0, 1, {'minOccurs': '0', 'name': 'language', 'type': 'i18nNonEmptyStringType'}, 39),
        MemberSpec_('series', ['NonEmptyStringType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'series', 'type': 'xs:string'}, 39),
        MemberSpec_('abstract', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'abstract', 'type': 'TextType'}, 39),
        MemberSpec_('keywordSet', 'keywordSetType36', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'keywordSet', 'type': 'keywordSetType36'}, 39),
        MemberSpec_('additionalInfo', 'TextType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'additionalInfo', 'type': 'TextType'}, 39),
        MemberSpec_('intellectualRights', 'TextType', 0, 1, {'minOccurs': '0', 'name': 'intellectualRights', 'type': 'TextType'}, 39),
        MemberSpec_('licensed', 'LicenseType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'licensed', 'type': 'LicenseType'}, 39),
        MemberSpec_('distribution', 'DistributionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'distribution', 'type': 'DistributionType'}, 39),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 39),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 39),
        MemberSpec_('proceduralStep', 'ProcedureStepType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'proceduralStep', 'type': 'ProcedureStepType'}, 39),
        MemberSpec_('references', 'referencesType38', 0, 0, {'name': 'references', 'type': 'referencesType38'}, 39),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', alternateIdentifier=None, shortName=None, title=None, creator=None, metadataProvider=None, associatedParty=None, pubDate=None, language=None, series=None, abstract=None, keywordSet=None, additionalInfo=None, intellectualRights=None, licensed=None, distribution=None, coverage=None, annotation=None, proceduralStep=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        if alternateIdentifier is None:
            self.alternateIdentifier = []
        else:
            self.alternateIdentifier = alternateIdentifier
        self.alternateIdentifier_nsprefix_ = None
        self.shortName = shortName
        self.validate_NonEmptyStringType(self.shortName)
        self.shortName_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if creator is None:
            self.creator = []
        else:
            self.creator = creator
        self.creator_nsprefix_ = None
        if metadataProvider is None:
            self.metadataProvider = []
        else:
            self.metadataProvider = metadataProvider
        self.metadataProvider_nsprefix_ = None
        if associatedParty is None:
            self.associatedParty = []
        else:
            self.associatedParty = associatedParty
        self.associatedParty_nsprefix_ = None
        self.pubDate = pubDate
        self.validate_yearDate(self.pubDate)
        self.pubDate_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.series = series
        self.validate_NonEmptyStringType(self.series)
        self.series_nsprefix_ = None
        self.abstract = abstract
        self.abstract_nsprefix_ = None
        if keywordSet is None:
            self.keywordSet = []
        else:
            self.keywordSet = keywordSet
        self.keywordSet_nsprefix_ = None
        if additionalInfo is None:
            self.additionalInfo = []
        else:
            self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.intellectualRights = intellectualRights
        self.intellectualRights_nsprefix_ = None
        if licensed is None:
            self.licensed = []
        else:
            self.licensed = licensed
        self.licensed_nsprefix_ = None
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.distribution_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        if proceduralStep is None:
            self.proceduralStep = []
        else:
            self.proceduralStep = proceduralStep
        self.proceduralStep_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProtocolType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProtocolType.subclass:
            return ProtocolType.subclass(*args_, **kwargs_)
        else:
            return ProtocolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_alternateIdentifier(self):
        return self.alternateIdentifier
    def set_alternateIdentifier(self, alternateIdentifier):
        self.alternateIdentifier = alternateIdentifier
    def add_alternateIdentifier(self, value):
        self.alternateIdentifier.append(value)
    def insert_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier.insert(index, value)
    def replace_alternateIdentifier_at(self, index, value):
        self.alternateIdentifier[index] = value
    def get_shortName(self):
        return self.shortName
    def set_shortName(self, shortName):
        self.shortName = shortName
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_creator(self):
        return self.creator
    def set_creator(self, creator):
        self.creator = creator
    def add_creator(self, value):
        self.creator.append(value)
    def insert_creator_at(self, index, value):
        self.creator.insert(index, value)
    def replace_creator_at(self, index, value):
        self.creator[index] = value
    def get_metadataProvider(self):
        return self.metadataProvider
    def set_metadataProvider(self, metadataProvider):
        self.metadataProvider = metadataProvider
    def add_metadataProvider(self, value):
        self.metadataProvider.append(value)
    def insert_metadataProvider_at(self, index, value):
        self.metadataProvider.insert(index, value)
    def replace_metadataProvider_at(self, index, value):
        self.metadataProvider[index] = value
    def get_associatedParty(self):
        return self.associatedParty
    def set_associatedParty(self, associatedParty):
        self.associatedParty = associatedParty
    def add_associatedParty(self, value):
        self.associatedParty.append(value)
    def insert_associatedParty_at(self, index, value):
        self.associatedParty.insert(index, value)
    def replace_associatedParty_at(self, index, value):
        self.associatedParty[index] = value
    def get_pubDate(self):
        return self.pubDate
    def set_pubDate(self, pubDate):
        self.pubDate = pubDate
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_series(self):
        return self.series
    def set_series(self, series):
        self.series = series
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def get_keywordSet(self):
        return self.keywordSet
    def set_keywordSet(self, keywordSet):
        self.keywordSet = keywordSet
    def add_keywordSet(self, value):
        self.keywordSet.append(value)
    def insert_keywordSet_at(self, index, value):
        self.keywordSet.insert(index, value)
    def replace_keywordSet_at(self, index, value):
        self.keywordSet[index] = value
    def get_additionalInfo(self):
        return self.additionalInfo
    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo
    def add_additionalInfo(self, value):
        self.additionalInfo.append(value)
    def insert_additionalInfo_at(self, index, value):
        self.additionalInfo.insert(index, value)
    def replace_additionalInfo_at(self, index, value):
        self.additionalInfo[index] = value
    def get_intellectualRights(self):
        return self.intellectualRights
    def set_intellectualRights(self, intellectualRights):
        self.intellectualRights = intellectualRights
    def get_licensed(self):
        return self.licensed
    def set_licensed(self, licensed):
        self.licensed = licensed
    def add_licensed(self, value):
        self.licensed.append(value)
    def insert_licensed_at(self, index, value):
        self.licensed.insert(index, value)
    def replace_licensed_at(self, index, value):
        self.licensed[index] = value
    def get_distribution(self):
        return self.distribution
    def set_distribution(self, distribution):
        self.distribution = distribution
    def add_distribution(self, value):
        self.distribution.append(value)
    def insert_distribution_at(self, index, value):
        self.distribution.insert(index, value)
    def replace_distribution_at(self, index, value):
        self.distribution[index] = value
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_proceduralStep(self):
        return self.proceduralStep
    def set_proceduralStep(self, proceduralStep):
        self.proceduralStep = proceduralStep
    def add_proceduralStep(self, value):
        self.proceduralStep.append(value)
    def insert_proceduralStep_at(self, index, value):
        self.proceduralStep.insert(index, value)
    def replace_proceduralStep_at(self, index, value):
        self.proceduralStep[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_yearDate(self, value):
        result = True
        # Validate type yearDate, a restriction on None.
        pass
        return result
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.alternateIdentifier or
            self.shortName is not None or
            self.title or
            self.creator or
            self.metadataProvider or
            self.associatedParty or
            self.pubDate is not None or
            self.language is not None or
            self.series is not None or
            self.abstract is not None or
            self.keywordSet or
            self.additionalInfo or
            self.intellectualRights is not None or
            self.licensed or
            self.distribution or
            self.coverage is not None or
            self.annotation or
            self.proceduralStep or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0" ', name_='ProtocolType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProtocolType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ProtocolType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProtocolType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ProtocolType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ProtocolType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:rp="https://eml.ecoinformatics.org/party-2.2.0"  xmlns:txt="https://eml.ecoinformatics.org/text-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0" ', name_='ProtocolType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for alternateIdentifier_ in self.alternateIdentifier:
            namespaceprefix_ = self.alternateIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.alternateIdentifier_nsprefix_) else ''
            alternateIdentifier_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alternateIdentifier', pretty_print=pretty_print)
        if self.shortName is not None:
            namespaceprefix_ = self.shortName_nsprefix_ + ':' if (UseCapturedNS_ and self.shortName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshortName>%s</%sshortName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.shortName), input_name='shortName')), namespaceprefix_ , eol_))
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for creator_ in self.creator:
            namespaceprefix_ = self.creator_nsprefix_ + ':' if (UseCapturedNS_ and self.creator_nsprefix_) else ''
            creator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='creator', pretty_print=pretty_print)
        for metadataProvider_ in self.metadataProvider:
            namespaceprefix_ = self.metadataProvider_nsprefix_ + ':' if (UseCapturedNS_ and self.metadataProvider_nsprefix_) else ''
            metadataProvider_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='metadataProvider', pretty_print=pretty_print)
        for associatedParty_ in self.associatedParty:
            namespaceprefix_ = self.associatedParty_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedParty_nsprefix_) else ''
            associatedParty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedParty', pretty_print=pretty_print)
        if self.pubDate is not None:
            namespaceprefix_ = self.pubDate_nsprefix_ + ':' if (UseCapturedNS_ and self.pubDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spubDate>%s</%spubDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pubDate), input_name='pubDate')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.series is not None:
            namespaceprefix_ = self.series_nsprefix_ + ':' if (UseCapturedNS_ and self.series_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sseries>%s</%sseries>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.series), input_name='series')), namespaceprefix_ , eol_))
        if self.abstract is not None:
            namespaceprefix_ = self.abstract_nsprefix_ + ':' if (UseCapturedNS_ and self.abstract_nsprefix_) else ''
            self.abstract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstract', pretty_print=pretty_print)
        for keywordSet_ in self.keywordSet:
            namespaceprefix_ = self.keywordSet_nsprefix_ + ':' if (UseCapturedNS_ and self.keywordSet_nsprefix_) else ''
            keywordSet_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='keywordSet', pretty_print=pretty_print)
        for additionalInfo_ in self.additionalInfo:
            namespaceprefix_ = self.additionalInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.additionalInfo_nsprefix_) else ''
            additionalInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='additionalInfo', pretty_print=pretty_print)
        if self.intellectualRights is not None:
            namespaceprefix_ = self.intellectualRights_nsprefix_ + ':' if (UseCapturedNS_ and self.intellectualRights_nsprefix_) else ''
            self.intellectualRights.export(outfile, level, namespaceprefix_, namespacedef_='', name_='intellectualRights', pretty_print=pretty_print)
        for licensed_ in self.licensed:
            namespaceprefix_ = self.licensed_nsprefix_ + ':' if (UseCapturedNS_ and self.licensed_nsprefix_) else ''
            licensed_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='licensed', pretty_print=pretty_print)
        for distribution_ in self.distribution:
            namespaceprefix_ = self.distribution_nsprefix_ + ':' if (UseCapturedNS_ and self.distribution_nsprefix_) else ''
            distribution_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='distribution', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        for proceduralStep_ in self.proceduralStep:
            namespaceprefix_ = self.proceduralStep_nsprefix_ + ':' if (UseCapturedNS_ and self.proceduralStep_nsprefix_) else ''
            proceduralStep_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proceduralStep', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'alternateIdentifier':
            obj_ = alternateIdentifierType34.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alternateIdentifier.append(obj_)
            obj_.original_tagname_ = 'alternateIdentifier'
        elif nodeName_ == 'shortName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'shortName')
            value_ = self.gds_validate_string(value_, node, 'shortName')
            self.shortName = value_
            self.shortName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.shortName)
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'creator':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.creator.append(obj_)
            obj_.original_tagname_ = 'creator'
        elif nodeName_ == 'metadataProvider':
            class_obj_ = self.get_class_obj_(child_, ResponsibleParty)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.metadataProvider.append(obj_)
            obj_.original_tagname_ = 'metadataProvider'
        elif nodeName_ == 'associatedParty':
            obj_ = associatedPartyType35.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedParty.append(obj_)
            obj_.original_tagname_ = 'associatedParty'
        elif nodeName_ == 'pubDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pubDate')
            value_ = self.gds_validate_string(value_, node, 'pubDate')
            self.pubDate = value_
            self.pubDate_nsprefix_ = child_.prefix
            # validate type yearDate
            self.validate_yearDate(self.pubDate)
        elif nodeName_ == 'language':
            class_obj_ = self.get_class_obj_(child_, i18nNonEmptyStringType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'series':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'series')
            value_ = self.gds_validate_string(value_, node, 'series')
            self.series = value_
            self.series_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.series)
        elif nodeName_ == 'abstract':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstract = obj_
            obj_.original_tagname_ = 'abstract'
        elif nodeName_ == 'keywordSet':
            obj_ = keywordSetType36.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.keywordSet.append(obj_)
            obj_.original_tagname_ = 'keywordSet'
        elif nodeName_ == 'additionalInfo':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.additionalInfo.append(obj_)
            obj_.original_tagname_ = 'additionalInfo'
        elif nodeName_ == 'intellectualRights':
            obj_ = TextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intellectualRights = obj_
            obj_.original_tagname_ = 'intellectualRights'
        elif nodeName_ == 'licensed':
            obj_ = LicenseType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.licensed.append(obj_)
            obj_.original_tagname_ = 'licensed'
        elif nodeName_ == 'distribution':
            obj_ = DistributionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distribution.append(obj_)
            obj_.original_tagname_ = 'distribution'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'proceduralStep':
            class_obj_ = self.get_class_obj_(child_, ProcedureStepType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proceduralStep.append(obj_)
            obj_.original_tagname_ = 'proceduralStep'
        elif nodeName_ == 'references':
            obj_ = referencesType38.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class ProtocolType


class AttributeListType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('attribute', 'AttributeType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'attribute', 'type': 'AttributeType'}, 40),
        MemberSpec_('references', 'referencesType39', 0, 0, {'name': 'references', 'type': 'referencesType39'}, 40),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, attribute=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if attribute is None:
            self.attribute = []
        else:
            self.attribute = attribute
        self.attribute_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AttributeListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AttributeListType.subclass:
            return AttributeListType.subclass(*args_, **kwargs_)
        else:
            return AttributeListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def add_attribute(self, value):
        self.attribute.append(value)
    def insert_attribute_at(self, index, value):
        self.attribute.insert(index, value)
    def replace_attribute_at(self, index, value):
        self.attribute[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.attribute or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AttributeListType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AttributeListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AttributeListType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AttributeListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AttributeListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AttributeListType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='AttributeListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for attribute_ in self.attribute:
            namespaceprefix_ = self.attribute_nsprefix_ + ':' if (UseCapturedNS_ and self.attribute_nsprefix_) else ''
            attribute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='attribute', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'attribute':
            obj_ = AttributeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.attribute.append(obj_)
            obj_.original_tagname_ = 'attribute'
        elif nodeName_ == 'references':
            obj_ = referencesType39.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class AttributeListType


class AttributeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'res:IDType', 0, 1, {'use': 'optional'}),
        MemberSpec_('system', 'res:SystemType', 0, 1, {'use': 'optional'}),
        MemberSpec_('scope', 'res:ScopeType', 0, 1, {'use': 'optional'}),
        MemberSpec_('attributeName', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'attributeName', 'type': 'xs:string'}, 41),
        MemberSpec_('attributeLabel', ['NonEmptyStringType', 'xs:string'], 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'attributeLabel', 'type': 'xs:string'}, 41),
        MemberSpec_('attributeDefinition', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'attributeDefinition', 'type': 'xs:string'}, 41),
        MemberSpec_('storageType', 'storageTypeType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'storageType', 'type': 'storageTypeType'}, 41),
        MemberSpec_('measurementScale', 'measurementScaleType', 0, 0, {'name': 'measurementScale', 'type': 'measurementScaleType'}, 41),
        MemberSpec_('missingValueCode', 'missingValueCodeType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'missingValueCode', 'type': 'missingValueCodeType'}, 41),
        MemberSpec_('accuracy', 'Accuracy', 0, 1, {'minOccurs': '0', 'name': 'accuracy', 'type': 'Accuracy'}, 41),
        MemberSpec_('coverage', 'Coverage', 0, 1, {'minOccurs': '0', 'name': 'coverage', 'type': 'Coverage'}, 41),
        MemberSpec_('methods', 'MethodsType', 0, 1, {'minOccurs': '0', 'name': 'methods', 'type': 'MethodsType'}, 41),
        MemberSpec_('annotation', 'SemanticAnnotation', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'annotation', 'type': 'SemanticAnnotation'}, 41),
        MemberSpec_('references', 'referencesType40', 0, 0, {'name': 'references', 'type': 'referencesType40'}, 41),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, system=None, scope='document', attributeName=None, attributeLabel=None, attributeDefinition=None, storageType=None, measurementScale=None, missingValueCode=None, accuracy=None, coverage=None, methods=None, annotation=None, references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.system = _cast(None, system)
        self.system_nsprefix_ = None
        self.scope = _cast(None, scope)
        self.scope_nsprefix_ = None
        self.attributeName = attributeName
        self.validate_NonEmptyStringType(self.attributeName)
        self.attributeName_nsprefix_ = None
        if attributeLabel is None:
            self.attributeLabel = []
        else:
            self.attributeLabel = attributeLabel
        self.attributeLabel_nsprefix_ = None
        self.attributeDefinition = attributeDefinition
        self.validate_NonEmptyStringType(self.attributeDefinition)
        self.attributeDefinition_nsprefix_ = None
        if storageType is None:
            self.storageType = []
        else:
            self.storageType = storageType
        self.storageType_nsprefix_ = None
        self.measurementScale = measurementScale
        self.measurementScale_nsprefix_ = None
        if missingValueCode is None:
            self.missingValueCode = []
        else:
            self.missingValueCode = missingValueCode
        self.missingValueCode_nsprefix_ = None
        self.accuracy = accuracy
        self.accuracy_nsprefix_ = None
        self.coverage = coverage
        self.coverage_nsprefix_ = None
        self.methods = methods
        self.methods_nsprefix_ = None
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.annotation_nsprefix_ = None
        self.references = references
        self.references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AttributeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AttributeType.subclass:
            return AttributeType.subclass(*args_, **kwargs_)
        else:
            return AttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_attributeName(self):
        return self.attributeName
    def set_attributeName(self, attributeName):
        self.attributeName = attributeName
    def get_attributeLabel(self):
        return self.attributeLabel
    def set_attributeLabel(self, attributeLabel):
        self.attributeLabel = attributeLabel
    def add_attributeLabel(self, value):
        self.attributeLabel.append(value)
    def insert_attributeLabel_at(self, index, value):
        self.attributeLabel.insert(index, value)
    def replace_attributeLabel_at(self, index, value):
        self.attributeLabel[index] = value
    def get_attributeDefinition(self):
        return self.attributeDefinition
    def set_attributeDefinition(self, attributeDefinition):
        self.attributeDefinition = attributeDefinition
    def get_storageType(self):
        return self.storageType
    def set_storageType(self, storageType):
        self.storageType = storageType
    def add_storageType(self, value):
        self.storageType.append(value)
    def insert_storageType_at(self, index, value):
        self.storageType.insert(index, value)
    def replace_storageType_at(self, index, value):
        self.storageType[index] = value
    def get_measurementScale(self):
        return self.measurementScale
    def set_measurementScale(self, measurementScale):
        self.measurementScale = measurementScale
    def get_missingValueCode(self):
        return self.missingValueCode
    def set_missingValueCode(self, missingValueCode):
        self.missingValueCode = missingValueCode
    def add_missingValueCode(self, value):
        self.missingValueCode.append(value)
    def insert_missingValueCode_at(self, index, value):
        self.missingValueCode.insert(index, value)
    def replace_missingValueCode_at(self, index, value):
        self.missingValueCode[index] = value
    def get_accuracy(self):
        return self.accuracy
    def set_accuracy(self, accuracy):
        self.accuracy = accuracy
    def get_coverage(self):
        return self.coverage
    def set_coverage(self, coverage):
        self.coverage = coverage
    def get_methods(self):
        return self.methods
    def set_methods(self, methods):
        self.methods = methods
    def get_annotation(self):
        return self.annotation
    def set_annotation(self, annotation):
        self.annotation = annotation
    def add_annotation(self, value):
        self.annotation.append(value)
    def insert_annotation_at(self, index, value):
        self.annotation.insert(index, value)
    def replace_annotation_at(self, index, value):
        self.annotation[index] = value
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def validate_IDType(self, value):
        # Validate type res:IDType, a restriction on xs:string.
        pass
    def validate_SystemType(self, value):
        # Validate type res:SystemType, a restriction on xs:string.
        pass
    def validate_ScopeType(self, value):
        # Validate type res:ScopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['system', 'document']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ScopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.attributeName is not None or
            self.attributeLabel or
            self.attributeDefinition is not None or
            self.storageType or
            self.measurementScale is not None or
            self.missingValueCode or
            self.accuracy is not None or
            self.coverage is not None or
            self.methods is not None or
            self.annotation or
            self.references is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0" ', name_='AttributeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AttributeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AttributeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AttributeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AttributeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AttributeType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.system is not None and 'system' not in already_processed:
            already_processed.add('system')
            outfile.write(' system=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.system), input_name='system')), ))
        if self.scope != "document" and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0"  xmlns:cov="https://eml.ecoinformatics.org/coverage-2.2.0"  xmlns:md="https://eml.ecoinformatics.org/methods-2.2.0"  xmlns:sem="https://eml.ecoinformatics.org/semantics-2.2.0" ', name_='AttributeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.attributeName is not None:
            namespaceprefix_ = self.attributeName_nsprefix_ + ':' if (UseCapturedNS_ and self.attributeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattributeName>%s</%sattributeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.attributeName), input_name='attributeName')), namespaceprefix_ , eol_))
        for attributeLabel_ in self.attributeLabel:
            namespaceprefix_ = self.attributeLabel_nsprefix_ + ':' if (UseCapturedNS_ and self.attributeLabel_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattributeLabel>%s</%sattributeLabel>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(attributeLabel_), input_name='attributeLabel')), namespaceprefix_ , eol_))
        if self.attributeDefinition is not None:
            namespaceprefix_ = self.attributeDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.attributeDefinition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattributeDefinition>%s</%sattributeDefinition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.attributeDefinition), input_name='attributeDefinition')), namespaceprefix_ , eol_))
        for storageType_ in self.storageType:
            namespaceprefix_ = self.storageType_nsprefix_ + ':' if (UseCapturedNS_ and self.storageType_nsprefix_) else ''
            storageType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='storageType', pretty_print=pretty_print)
        if self.measurementScale is not None:
            namespaceprefix_ = self.measurementScale_nsprefix_ + ':' if (UseCapturedNS_ and self.measurementScale_nsprefix_) else ''
            self.measurementScale.export(outfile, level, namespaceprefix_, namespacedef_='', name_='measurementScale', pretty_print=pretty_print)
        for missingValueCode_ in self.missingValueCode:
            namespaceprefix_ = self.missingValueCode_nsprefix_ + ':' if (UseCapturedNS_ and self.missingValueCode_nsprefix_) else ''
            missingValueCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='missingValueCode', pretty_print=pretty_print)
        if self.accuracy is not None:
            namespaceprefix_ = self.accuracy_nsprefix_ + ':' if (UseCapturedNS_ and self.accuracy_nsprefix_) else ''
            self.accuracy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='accuracy', pretty_print=pretty_print)
        if self.coverage is not None:
            namespaceprefix_ = self.coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.coverage_nsprefix_) else ''
            self.coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coverage', pretty_print=pretty_print)
        if self.methods is not None:
            namespaceprefix_ = self.methods_nsprefix_ + ':' if (UseCapturedNS_ and self.methods_nsprefix_) else ''
            self.methods.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methods', pretty_print=pretty_print)
        for annotation_ in self.annotation:
            namespaceprefix_ = self.annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.annotation_nsprefix_) else ''
            annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotation', pretty_print=pretty_print)
        if self.references is not None:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            self.references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_IDType(self.id)    # validate type IDType
        value = find_attr_value_('system', node)
        if value is not None and 'system' not in already_processed:
            already_processed.add('system')
            self.system = value
            self.validate_SystemType(self.system)    # validate type SystemType
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_ScopeType(self.scope)    # validate type ScopeType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'attributeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'attributeName')
            value_ = self.gds_validate_string(value_, node, 'attributeName')
            self.attributeName = value_
            self.attributeName_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.attributeName)
        elif nodeName_ == 'attributeLabel':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'attributeLabel')
            value_ = self.gds_validate_string(value_, node, 'attributeLabel')
            self.attributeLabel.append(value_)
            self.attributeLabel_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.attributeLabel[-1])
        elif nodeName_ == 'attributeDefinition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'attributeDefinition')
            value_ = self.gds_validate_string(value_, node, 'attributeDefinition')
            self.attributeDefinition = value_
            self.attributeDefinition_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.attributeDefinition)
        elif nodeName_ == 'storageType':
            obj_ = storageTypeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.storageType.append(obj_)
            obj_.original_tagname_ = 'storageType'
        elif nodeName_ == 'measurementScale':
            obj_ = measurementScaleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.measurementScale = obj_
            obj_.original_tagname_ = 'measurementScale'
        elif nodeName_ == 'missingValueCode':
            obj_ = missingValueCodeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.missingValueCode.append(obj_)
            obj_.original_tagname_ = 'missingValueCode'
        elif nodeName_ == 'accuracy':
            obj_ = Accuracy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.accuracy = obj_
            obj_.original_tagname_ = 'accuracy'
        elif nodeName_ == 'coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coverage = obj_
            obj_.original_tagname_ = 'coverage'
        elif nodeName_ == 'methods':
            obj_ = MethodsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methods = obj_
            obj_.original_tagname_ = 'methods'
        elif nodeName_ == 'annotation':
            class_obj_ = self.get_class_obj_(child_, SemanticAnnotation)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation.append(obj_)
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'references':
            obj_ = referencesType40.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references = obj_
            obj_.original_tagname_ = 'references'
# end class AttributeType


class Accuracy(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('attributeAccuracyReport', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'attributeAccuracyReport', 'type': 'xs:string'}, None),
        MemberSpec_('quantitativeAttributeAccuracyAssessment', 'quantitativeAttributeAccuracyAssessmentType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'quantitativeAttributeAccuracyAssessment', 'type': 'quantitativeAttributeAccuracyAssessmentType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, attributeAccuracyReport=None, quantitativeAttributeAccuracyAssessment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.attributeAccuracyReport = attributeAccuracyReport
        self.validate_NonEmptyStringType(self.attributeAccuracyReport)
        self.attributeAccuracyReport_nsprefix_ = None
        if quantitativeAttributeAccuracyAssessment is None:
            self.quantitativeAttributeAccuracyAssessment = []
        else:
            self.quantitativeAttributeAccuracyAssessment = quantitativeAttributeAccuracyAssessment
        self.quantitativeAttributeAccuracyAssessment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Accuracy)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Accuracy.subclass:
            return Accuracy.subclass(*args_, **kwargs_)
        else:
            return Accuracy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_attributeAccuracyReport(self):
        return self.attributeAccuracyReport
    def set_attributeAccuracyReport(self, attributeAccuracyReport):
        self.attributeAccuracyReport = attributeAccuracyReport
    def get_quantitativeAttributeAccuracyAssessment(self):
        return self.quantitativeAttributeAccuracyAssessment
    def set_quantitativeAttributeAccuracyAssessment(self, quantitativeAttributeAccuracyAssessment):
        self.quantitativeAttributeAccuracyAssessment = quantitativeAttributeAccuracyAssessment
    def add_quantitativeAttributeAccuracyAssessment(self, value):
        self.quantitativeAttributeAccuracyAssessment.append(value)
    def insert_quantitativeAttributeAccuracyAssessment_at(self, index, value):
        self.quantitativeAttributeAccuracyAssessment.insert(index, value)
    def replace_quantitativeAttributeAccuracyAssessment_at(self, index, value):
        self.quantitativeAttributeAccuracyAssessment[index] = value
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.attributeAccuracyReport is not None or
            self.quantitativeAttributeAccuracyAssessment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Accuracy', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Accuracy')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Accuracy':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Accuracy')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Accuracy', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Accuracy'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0"  xmlns:None="https://eml.ecoinformatics.org/view-2.2.0" ', name_='Accuracy', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.attributeAccuracyReport is not None:
            namespaceprefix_ = self.attributeAccuracyReport_nsprefix_ + ':' if (UseCapturedNS_ and self.attributeAccuracyReport_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattributeAccuracyReport>%s</%sattributeAccuracyReport>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.attributeAccuracyReport), input_name='attributeAccuracyReport')), namespaceprefix_ , eol_))
        for quantitativeAttributeAccuracyAssessment_ in self.quantitativeAttributeAccuracyAssessment:
            namespaceprefix_ = self.quantitativeAttributeAccuracyAssessment_nsprefix_ + ':' if (UseCapturedNS_ and self.quantitativeAttributeAccuracyAssessment_nsprefix_) else ''
            quantitativeAttributeAccuracyAssessment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='quantitativeAttributeAccuracyAssessment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'attributeAccuracyReport':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'attributeAccuracyReport')
            value_ = self.gds_validate_string(value_, node, 'attributeAccuracyReport')
            self.attributeAccuracyReport = value_
            self.attributeAccuracyReport_nsprefix_ = child_.prefix
            # validate type NonEmptyStringType
            self.validate_NonEmptyStringType(self.attributeAccuracyReport)
        elif nodeName_ == 'quantitativeAttributeAccuracyAssessment':
            obj_ = quantitativeAttributeAccuracyAssessmentType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.quantitativeAttributeAccuracyAssessment.append(obj_)
            obj_.original_tagname_ = 'quantitativeAttributeAccuracyAssessment'
# end class Accuracy


class UnitType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('standardUnit', 'StandardUnitDictionary', 0, 0, {'name': 'standardUnit', 'type': 'xs:string'}, 42),
        MemberSpec_('customUnit', ['NonEmptyStringType', 'xs:string'], 0, 0, {'name': 'customUnit', 'type': 'xs:string'}, 42),
    ]
    subclass = None
    superclass = None
    def __init__(self, standardUnit=None, customUnit=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.standardUnit = standardUnit
        self.validate_StandardUnitDictionary(self.standardUnit)
        self.standardUnit_nsprefix_ = None
        self.customUnit = customUnit
        self.validate_NonEmptyStringType(self.customUnit)
        self.customUnit_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnitType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnitType.subclass:
            return UnitType.subclass(*args_, **kwargs_)
        else:
            return UnitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_standardUnit(self):
        return self.standardUnit
    def set_standardUnit(self, standardUnit):
        self.standardUnit = standardUnit
    def get_customUnit(self):
        return self.customUnit
    def set_customUnit(self, customUnit):
        self.customUnit = customUnit
    def validate_StandardUnitDictionary(self, value):
        result = True
        # Validate type StandardUnitDictionary, a restriction on None.
        pass
        return result
    def validate_NonEmptyStringType(self, value):
        result = True
        # Validate type NonEmptyStringType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NonEmptyStringType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NonEmptyStringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NonEmptyStringType_patterns_, ))
                result = False
        return result
    validate_NonEmptyStringType_patterns_ = [['^([\\s]*[\\S][\\s\\S]*)$']]
    def hasContent_(self):
        if (
            self.standardUnit is not None or
            self.customUnit is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:unit="https://eml.ecoinformatics.org/units-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='UnitType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UnitType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UnitType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UnitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UnitType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UnitType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:eml="https://eml.ecoinformatics.org/eml-2.2.0" xmlns:unit="https://eml.ecoinformatics.org/units-2.2.0"  xmlns:res="https://eml.ecoinformatics.org/resource-2.2.0" ', name_='UnitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.standardUnit is not None:
            namespaceprefix_ = self.standardUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.standardUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstandardUnit>%s</%sstandardUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.standardUnit), input_name='standardUnit')), namespaceprefix_ , eol_))
        if self.customUnit is not None:
            namespaceprefix_ = self.customUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.customUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustomUnit>%s</%scustomUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.customUnit), input_name='customUnit')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=Fa