from enum import Enum

__NAMESPACE__ = "https://eml.ecoinformatics.org/units-2.2.0"


class StandardUnitDictionary(Enum):
    METER = "meter"
    NANOMETER = "nanometer"
    MICROMETER = "micrometer"
    MICRON = "micron"
    MILLIMETER = "millimeter"
    CENTIMETER = "centimeter"
    DECIMETER = "decimeter"
    DEKAMETER = "dekameter"
    HECTOMETER = "hectometer"
    KILOMETER = "kilometer"
    MEGAMETER = "megameter"
    ANGSTROM = "angstrom"
    INCH = "inch"
    FOOT_US = "Foot_US"
    FOOT = "foot"
    FOOT_GOLD_COAST = "Foot_Gold_Coast"
    FATHOM = "fathom"
    NAUTICAL_MILE = "nauticalMile"
    YARD = "yard"
    YARD_INDIAN = "Yard_Indian"
    LINK_CLARKE = "Link_Clarke"
    YARD_SEARS = "Yard_Sears"
    MILE = "mile"
    KILOGRAM = "kilogram"
    NANOGRAM = "nanogram"
    MICROGRAM = "microgram"
    MILLIGRAM = "milligram"
    CENTIGRAM = "centigram"
    DECIGRAM = "decigram"
    GRAM = "gram"
    DEKAGRAM = "dekagram"
    HECTOGRAM = "hectogram"
    MEGAGRAM = "megagram"
    TONNE = "tonne"
    POUND = "pound"
    TON = "ton"
    RADIAN = "radian"
    DEGREE = "degree"
    GRAD = "grad"
    STERADIAN = "steradian"
    ACRE = "acre"
    AMPERE = "ampere"
    AMPERE_PER_METER = "amperePerMeter"
    AMPERE_PER_METER_SQUARED = "amperePerMeterSquared"
    AMPERE_PER_SQUARE_METER = "amperePerSquareMeter"
    ARE = "are"
    ATMOSPHERE = "atmosphere"
    BAR = "bar"
    BECQUEREL = "becquerel"
    BRITISH_THERMAL_UNIT = "britishThermalUnit"
    BUSHEL = "bushel"
    BUSHEL_PER_ACRE = "bushelPerAcre"
    BUSHELS_PER_ACRE = "bushelsPerAcre"
    CALORIE = "calorie"
    CANDELA = "candela"
    CANDELA_PER_METER_SQUARED = "candelaPerMeterSquared"
    CANDELA_PER_SQUARE_METER = "candelaPerSquareMeter"
    CELSIUS = "celsius"
    CENTIMETER_CUBED = "centimeterCubed"
    CENTIMETER_PER_SECOND = "centimeterPerSecond"
    CENTIMETER_PER_YEAR = "centimeterPerYear"
    CENTIMETER_SQUARED = "centimeterSquared"
    CENTIMETERS_PER_SECOND = "centimetersPerSecond"
    CENTISECOND = "centisecond"
    COULOMB = "coulomb"
    CUBIC_CENTIMETERS_PER_CUBIC_CENTIMETERS = "cubicCentimetersPerCubicCentimeters"
    CUBIC_FEET_PER_SECOND = "cubicFeetPerSecond"
    CUBIC_INCH = "cubicInch"
    CUBIC_METER = "cubicMeter"
    CUBIC_METER_PER_KILOGRAM = "cubicMeterPerKilogram"
    CUBIC_METERS_PER_SECOND = "cubicMetersPerSecond"
    CUBIC_MICROMETERS_PER_GRAM = "cubicMicrometersPerGram"
    DECIBAR = "decibar"
    DECISECOND = "decisecond"
    DEKASECOND = "dekasecond"
    DIMENSIONLESS = "dimensionless"
    EQUIVALENT_PER_LITER = "equivalentPerLiter"
    FAHRENHEIT = "fahrenheit"
    FARAD = "farad"
    FEET_PER_DAY = "feetPerDay"
    FEET_PER_HOUR = "feetPerHour"
    FEET_PER_SECOND = "feetPerSecond"
    FEET_SQUARED_PER_DAY = "feetSquaredPerDay"
    FOOT_CUBED_PER_SECOND = "footCubedPerSecond"
    FOOT_PER_DAY = "footPerDay"
    FOOT_PER_HOUR = "footPerHour"
    FOOT_PER_SECOND = "footPerSecond"
    FOOT_POUND = "footPound"
    FOOT_SQUARED = "footSquared"
    FOOT_SQUARED_PER_DAY = "footSquaredPerDay"
    GALLON = "gallon"
    GRAM_PER_CENTIMETER_CUBED = "gramPerCentimeterCubed"
    GRAM_PER_CENTIMETER_SQUARED_PER_SECOND = "gramPerCentimeterSquaredPerSecond"
    GRAM_PER_DAY_PER_HECTARE = "gramPerDayPerHectare"
    GRAM_PER_DAY_PER_LITER = "gramPerDayPerLiter"
    GRAM_PER_GRAM = "gramPerGram"
    GRAM_PER_LITER = "gramPerLiter"
    GRAM_PER_METER_SQUARED = "gramPerMeterSquared"
    GRAM_PER_METER_SQUARED_PER_DAY = "gramPerMeterSquaredPerDay"
    GRAM_PER_METER_SQUARED_PER_YEAR = "gramPerMeterSquaredPerYear"
    GRAM_PER_MILLILITER = "gramPerMilliliter"
    GRAM_PER_YEAR = "gramPerYear"
    GRAM_PERCENTIMETER_SQUARED = "gramPercentimeterSquared"
    GRAMS_PER_CENTIMETER_SQUARED_PER_SECOND = "gramsPerCentimeterSquaredPerSecond"
    GRAMS_PER_CUBIC_CENTIMETER = "gramsPerCubicCentimeter"
    GRAMS_PER_GRAM = "gramsPerGram"
    GRAMS_PER_HECTARE_PER_DAY = "gramsPerHectarePerDay"
    GRAMS_PER_LITER = "gramsPerLiter"
    GRAMS_PER_LITER_PER_DAY = "gramsPerLiterPerDay"
    GRAMS_PER_METER_SQUARED_PER_YEAR = "gramsPerMeterSquaredPerYear"
    GRAMS_PER_MILLILITER = "gramsPerMilliliter"
    GRAMS_PER_SQUARE_METER = "gramsPerSquareMeter"
    GRAMS_PER_YEAR = "gramsPerYear"
    GRAY = "gray"
    HECTARE = "hectare"
    HECTOPASCAL = "hectopascal"
    HECTOSECOND = "hectosecond"
    HENRY = "henry"
    HERTZ = "hertz"
    HOUR = "hour"
    INCH_CUBED = "inchCubed"
    INCH_PER_HOUR = "inchPerHour"
    INVERSE_CENTIMETER = "inverseCentimeter"
    INVERSE_METER = "inverseMeter"
    JOULE = "joule"
    KATAL = "katal"
    KELVIN = "kelvin"
    KILOGRAM_PER_CUBIC_METER = "kilogramPerCubicMeter"
    KILOGRAM_PER_HECTARE = "kilogramPerHectare"
    KILOGRAM_PER_HECTARE_PER_YEAR = "kilogramPerHectarePerYear"
    KILOGRAM_PER_METER_CUBED = "kilogramPerMeterCubed"
    KILOGRAM_PER_METER_SQUARED = "kilogramPerMeterSquared"
    KILOGRAM_PER_METER_SQUARED_PER_DAY = "kilogramPerMeterSquaredPerDay"
    KILOGRAM_PER_METER_SQUARED_PER_SECOND = "kilogramPerMeterSquaredPerSecond"
    KILOGRAM_PER_METER_SQUARED_PER_YEAR = "kilogramPerMeterSquaredPerYear"
    KILOGRAM_PER_SECOND = "kilogramPerSecond"
    KILOGRAMS_PER_HECTARE = "kilogramsPerHectare"
    KILOGRAMS_PER_HECTARE_PER_YEAR = "kilogramsPerHectarePerYear"
    KILOGRAMS_PER_METER_SQUARED_PER_SECOND = "kilogramsPerMeterSquaredPerSecond"
    KILOGRAMS_PER_METER_SQUARED_PER_YEAR = "kilogramsPerMeterSquaredPerYear"
    KILOGRAMS_PER_SECOND = "kilogramsPerSecond"
    KILOGRAMS_PER_SQUARE_METER = "kilogramsPerSquareMeter"
    KILOHERTZ = "kilohertz"
    KILOLITER = "kiloliter"
    KILOMETER_PER_HOUR = "kilometerPerHour"
    KILOMETER_SQUARED = "kilometerSquared"
    KILOMETERS_PER_HOUR = "kilometersPerHour"
    KILOPASCAL = "kilopascal"
    KILOSECOND = "kilosecond"
    KILOVOLT = "kilovolt"
    KILOWATT = "kilowatt"
    KILOWATT_PER_METER_SQUARED = "kilowattPerMeterSquared"
    KNOT = "knot"
    KNOTS = "knots"
    LANGLEY = "langley"
    LANGLEY_PER_DAY = "langleyPerDay"
    LITER = "liter"
    LITER_PER_HECTARE = "literPerHectare"
    LITER_PER_LITER = "literPerLiter"
    LITER_PER_METER_SQUARED = "literPerMeterSquared"
    LITER_PER_SECOND = "literPerSecond"
    LITERS_PER_HECTARE = "litersPerHectare"
    LITERS_PER_SECOND = "litersPerSecond"
    LITERS_PER_SQUARE_METER = "litersPerSquareMeter"
    LUMEN = "lumen"
    LUX = "lux"
    MEGAGRAM_PER_METER_CUBED = "megagramPerMeterCubed"
    MEGAHERTZ = "megahertz"
    MEGAJOULE_PER_METER_SQUARED_PER_DAY = "megajoulePerMeterSquaredPerDay"
    MEGAPASCAL = "megapascal"
    MEGASECOND = "megasecond"
    MEGAVOLT = "megavolt"
    MEGAWATT = "megawatt"
    METER_CUBED = "meterCubed"
    METER_CUBED_PER_HECTARE = "meterCubedPerHectare"
    METER_CUBED_PER_KILOGRAM = "meterCubedPerKilogram"
    METER_CUBED_PER_METER_CUBED = "meterCubedPerMeterCubed"
    METER_CUBED_PER_METER_SQUARED = "meterCubedPerMeterSquared"
    METER_CUBED_PER_SECOND = "meterCubedPerSecond"
    METER_PER_DAY = "meterPerDay"
    METER_PER_GRAM = "meterPerGram"
    METER_PER_SECOND = "meterPerSecond"
    METER_PER_SECOND_SQUARED = "meterPerSecondSquared"
    METER_SQUARED = "meterSquared"
    METER_SQUARED_PER_DAY = "meterSquaredPerDay"
    METER_SQUARED_PER_HECTARE = "meterSquaredPerHectare"
    METER_SQUARED_PER_KILOGRAM = "meterSquaredPerKilogram"
    METER_SQUARED_PER_SECOND = "meterSquaredPerSecond"
    METERS_PER_DAY = "metersPerDay"
    METERS_PER_GRAM = "metersPerGram"
    METERS_PER_SECOND = "metersPerSecond"
    METERS_PER_SECOND_SQUARED = "metersPerSecondSquared"
    METERS_SQUARED_PER_DAY = "metersSquaredPerDay"
    METERS_SQUARED_PER_SECOND = "metersSquaredPerSecond"
    MICROEQUIVALENT_PER_LITER = "microequivalentPerLiter"
    MICROGRAM_PER_GRAM = "microgramPerGram"
    MICROGRAM_PER_GRAM_PER_DAY = "microgramPerGramPerDay"
    MICROGRAM_PER_GRAM_PER_HOUR = "microgramPerGramPerHour"
    MICROGRAM_PER_GRAM_PER_WEEK = "microgramPerGramPerWeek"
    MICROGRAM_PER_LITER = "microgramPerLiter"
    MICROGRAMS_PER_GRAM = "microgramsPerGram"
    MICROGRAMS_PER_LITER = "microgramsPerLiter"
    MICROLITER = "microliter"
    MICROLITER_PER_LITER = "microliterPerLiter"
    MICROMETER_CUBED_PER_GRAM = "micrometerCubedPerGram"
    MICROMOLE_PER_CENTIMETER_SQUARED_PER_SECOND = "micromolePerCentimeterSquaredPerSecond"
    MICROMOLE_PER_GRAM = "micromolePerGram"
    MICROMOLE_PER_GRAM_PER_DAY = "micromolePerGramPerDay"
    MICROMOLE_PER_GRAM_PER_HOUR = "micromolePerGramPerHour"
    MICROMOLE_PER_GRAM_PER_SECOND = "micromolePerGramPerSecond"
    MICROMOLE_PER_KILOGRAM = "micromolePerKilogram"
    MICROMOLE_PER_LITER = "micromolePerLiter"
    MICROMOLE_PER_METER_SQUARED_PER_SECOND = "micromolePerMeterSquaredPerSecond"
    MICROMOLE_PER_MOLE = "micromolePerMole"
    MICROSECOND = "microsecond"
    MICROWATT_PER_CENTIMETER_SQUARED_PER_NANOMETER = "microwattPerCentimeterSquaredPerNanometer"
    MICROWATT_PER_CENTIMETER_SQUARED_PER_NANOMETER_PER_STERADIAN = (
        "microwattPerCentimeterSquaredPerNanometerPerSteradian"
    )
    MICROWATT_PER_CENTIMETER_SQUARED_PER_STERADIAN = "microwattPerCentimeterSquaredPerSteradian"
    MILE_PER_HOUR = "milePerHour"
    MILE_PER_MINUTE = "milePerMinute"
    MILE_PER_SECOND = "milePerSecond"
    MILE_SQUARED = "mileSquared"
    MILES_PER_HOUR = "milesPerHour"
    MILES_PER_MINUTE = "milesPerMinute"
    MILES_PER_SECOND = "milesPerSecond"
    MILLI_GRAMS_PER_MILLI_LITER = "milliGramsPerMilliLiter"
    MILLIBAR = "millibar"
    MILLIEQUIVALENT_PER_LITER = "milliequivalentPerLiter"
    MILLIGRAM_PER_KILOGRAM = "milligramPerKilogram"
    MILLIGRAM_PER_LITER = "milligramPerLiter"
    MILLIGRAM_PER_METER_CUBED = "milligramPerMeterCubed"
    MILLIGRAM_PER_METER_CUBED_PER_DAY = "milligramPerMeterCubedPerDay"
    MILLIGRAM_PER_METER_SQUARED = "milligramPerMeterSquared"
    MILLIGRAM_PER_METER_SQUARED_PER_DAY = "milligramPerMeterSquaredPerDay"
    MILLIGRAM_PER_MILLILITER = "milligramPerMilliliter"
    MILLIGRAMS_PER_CUBIC_METER = "milligramsPerCubicMeter"
    MILLIGRAMS_PER_LITER = "milligramsPerLiter"
    MILLIGRAMS_PER_SQUARE_METER = "milligramsPerSquareMeter"
    MILLIHERTZ = "millihertz"
    MILLILITER = "milliliter"
    MILLILITER_PER_LITER = "milliliterPerLiter"
    MILLIMETER_PER_DAY = "millimeterPerDay"
    MILLIMETER_PER_SECOND = "millimeterPerSecond"
    MILLIMETER_SQUARED = "millimeterSquared"
    MILLIMETERS_PER_SECOND = "millimetersPerSecond"
    MILLIMOLE_PER_GRAM = "millimolePerGram"
    MILLIMOLE_PER_KILOGRAM = "millimolePerKilogram"
    MILLIMOLE_PER_LITER = "millimolePerLiter"
    MILLIMOLE_PER_METER_CUBED = "millimolePerMeterCubed"
    MILLIMOLE_PER_MOLE = "millimolePerMole"
    MILLIMOLES_PER_GRAM = "millimolesPerGram"
    MILLISECOND = "millisecond"
    MILLIVOLT = "millivolt"
    MILLIWATT = "milliwatt"
    MINUTE = "minute"
    MOLALITY = "molality"
    MOLARITY = "molarity"
    MOLE = "mole"
    MOLE_PER_CUBIC_METER = "molePerCubicMeter"
    MOLE_PER_GRAM = "molePerGram"
    MOLE_PER_KILOGRAM = "molePerKilogram"
    MOLE_PER_KILOGRAM_PER_SECOND = "molePerKilogramPerSecond"
    MOLE_PER_LITER = "molePerLiter"
    MOLE_PER_METER_CUBED = "molePerMeterCubed"
    MOLE_PER_METER_SQUARED_PER_SECOND = "molePerMeterSquaredPerSecond"
    MOLE_PER_MOLE = "molePerMole"
    MOLES_PER_GRAM = "molesPerGram"
    MOLES_PER_KILOGRAM = "molesPerKilogram"
    MOLES_PER_KILOGRAM_PER_SECOND = "molesPerKilogramPerSecond"
    NANOGRAM_PER_GRAM = "nanogramPerGram"
    NANOGRAM_PER_GRAM_PER_HOUR = "nanogramPerGramPerHour"
    NANOLITER_PER_LITER = "nanoliterPerLiter"
    NANOMOLE_PER_GRAM_PER_DAY = "nanomolePerGramPerDay"
    NANOMOLE_PER_GRAM_PER_HOUR = "nanomolePerGramPerHour"
    NANOMOLE_PER_GRAM_PER_SECOND = "nanomolePerGramPerSecond"
    NANOMOLE_PER_KILOGRAM = "nanomolePerKilogram"
    NANOMOLE_PER_LITER = "nanomolePerLiter"
    NANOMOLE_PER_MOLE = "nanomolePerMole"
    NANOMOLES_PER_GRAM_PER_SECOND = "nanomolesPerGramPerSecond"
    NANOSECOND = "nanosecond"
    NEWTON = "newton"
    NOMINAL_DAY = "nominalDay"
    NOMINAL_HOUR = "nominalHour"
    NOMINAL_LEAP_YEAR = "nominalLeapYear"
    NOMINAL_MINUTE = "nominalMinute"
    NOMINAL_WEEK = "nominalWeek"
    NOMINAL_YEAR = "nominalYear"
    NUMBER = "number"
    NUMBER_PER_GRAM = "numberPerGram"
    NUMBER_PER_HECTARE = "numberPerHectare"
    NUMBER_PER_KILOMETER_SQUARED = "numberPerKilometerSquared"
    NUMBER_PER_LITER = "numberPerLiter"
    NUMBER_PER_METER_CUBED = "numberPerMeterCubed"
    NUMBER_PER_METER_SQUARED = "numberPerMeterSquared"
    NUMBER_PER_MILLILITER = "numberPerMilliliter"
    OHM = "ohm"
    OHM_METER = "ohmMeter"
    PASCAL = "pascal"
    PERCENT = "percent"
    PERMIL = "permil"
    PINT = "pint"
    POUND_PER_ACRE = "poundPerAcre"
    POUND_PER_INCH_SQUARED = "poundPerInchSquared"
    POUNDS_PER_SQUARE_INCH = "poundsPerSquareInch"
    QUART = "quart"
    SECOND = "second"
    SIEMEN = "siemen"
    SIEMENS = "siemens"
    SIEMENS_PER_CENTIMETER = "siemensPerCentimeter"
    SIEMENS_PER_METER = "siemensPerMeter"
    SIEVERT = "sievert"
    SQUARE_CENTIMETERS = "squareCentimeters"
    SQUARE_FOOT = "squareFoot"
    SQUARE_KILOMETERS = "squareKilometers"
    SQUARE_METER = "squareMeter"
    SQUARE_METER_PER_KILOGRAM = "squareMeterPerKilogram"
    SQUARE_MILE = "squareMile"
    SQUARE_MILLIMETERS = "squareMillimeters"
    SQUARE_YARD = "squareYard"
    TESLA = "tesla"
    TONNE_PER_HECTARE = "tonnePerHectare"
    TONNE_PER_YEAR = "tonnePerYear"
    TONNES_PER_YEAR = "tonnesPerYear"
    VOLT = "volt"
    WATT = "watt"
    WATT_PER_METER_SQUARED = "wattPerMeterSquared"
    WATT_PER_METER_SQUARED_PER_NANOMETER = "wattPerMeterSquaredPerNanometer"
    WATT_PER_METER_SQUARED_PER_NANOMETER_PER_STERADIAN = "wattPerMeterSquaredPerNanometerPerSteradian"
    WATT_PER_METER_SQUARED_PER_STERADIAN = "wattPerMeterSquaredPerSteradian"
    WAVE_NUMBER = "waveNumber"
    WEBER = "weber"
    YARD_PER_SECOND = "yardPerSecond"
    YARD_SQUARED = "yardSquared"
    YARDS_PER_SECOND = "yardsPerSecond"
