# Vyxal

[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/Vyxal/Vyxal.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/Vyxal/Vyxal/context:python) ![Test status](https://github.com/Vyxal/Vyxal/actions/workflows/run-tests.yaml/badge.svg)

Vyxal is a golfing language with a unique design philosophy: make things as short as possible but retain elegance while doing so. In very simple terms, this means
keeping aspects of traditional programming languages that most developers are familiar with, while still providing commands that allow golfers to actually _win_
challenges.

Vyxal is _not_ a language which forces users to mash random characters togther until something works. Nor is it a language that needs to be verbose. Vyxal is terse when
it needs to be, and readable/stylish when it wants to be.

Vyxal is also deliberately designed to be an easy language to learn. While it may be possible to teach golfers how to program in Vyxal, it is far more likely that they will just learn through experience. The language is designed to be easy to understand, and to allow for fast development.

Ultimately, Vyxal is a language for golfers, by golfers.

## Installation

You can also use the [online interpreter](https://vyxal.pythonanywhere.com) with no need to install!

If you only want to run Vyxal, all you need to run is this:
```
pip install vyxal
```

If you are working on Vyxal, install [Poetry](https://python-poetry.org), and then you can clone this repo and run:
```
poetry install
```

## Usage

To run using the script:
```
vyxal <file> <flags (single string of flags)> <input(s)>
```

If you're using Poetry:
```
poetry run vyxal <file> <flags (single string of flags)> <input(s)>
```

## Why Make Another Golfing Language When There's Like Hundreds of Them Already?

Most golfing languages are created with the intent of terse code - a goal that is obviously essential to the very core of what a golfing language is. However, this is
mostly done at the expense of losing constructs within traditional programming languages that make things simple to do. Vyxal's raison d'être is to provide structures
of practical languages - such as functions, variables and comments - that are oftentimes lost within the modern golfing language market.

Another reason for Vyxal is to provide an easy to use golfing language that anyone can quickly pick up - by providing tools that both new and experienced users are
familiar with, Vyxal aims to cater to a wide demographic of golfers.

Put simply, Vyxal exists because golfers need a golfing language - and because golfing languages could be better.

## Links

- [Repository](https://github.com/Vyxal/Vyxal)
- [Online Interpreter](http://vyxal.pythonanywhere.com)
<!-- TODO: fix broken links
- [Tutorial](https://github.com/Vyxal/Vyxal/blob/master/docs/Tutorial.md)
- [Codepage](https://github.com/Vyxal/Vyxal/blob/master/docs/codepage.txt)
-->
- [Chat Room (SE Chat)](https://chat.stackexchange.com/rooms/106764/vyxal)
- [Elements](https://github.com/Vyxal/Vyxal/blob/v2.6.0/documents/knowledge/elements.md)
- [Vyxapedia](https://vyxapedia.hyper-neutrino.xyz/)
