import numpy as np            # pylint: disable=unused-import
import typing                 # pylint: disable=unused-import
from nomad.metainfo import (  # pylint: disable=unused-import
    MSection, MCategory, Category, Package, Quantity, Section, SubSection, SectionProxy,
    Reference
)
from nomad.metainfo.legacy import LegacyDefinition

from nomad.datamodel.metainfo import public

m_package = Package(
    name='cp2k_nomadmetainfo_json',
    description='None',
    a_legacy=LegacyDefinition(name='cp2k.nomadmetainfo.json'))


class x_cp2k_section_input_ATOM_AE_BASIS_BASIS(MSection):
    '''
    Section used to specify a general basis set for QM calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.AE_BASIS.BASIS'))

    x_cp2k_input_ATOM_AE_BASIS_BASIS_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        CP2K Basis Set Standard Format
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.BASIS.DEFAULT_KEYWORD'))


class x_cp2k_section_input_ATOM_AE_BASIS(MSection):
    '''
    Section of basis set information for all-electron calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.AE_BASIS'))

    x_cp2k_input_ATOM_AE_BASIS_BASIS_SET_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the basis set file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.BASIS_SET_FILE_NAME'))

    x_cp2k_input_ATOM_AE_BASIS_BASIS_SET = Quantity(
        type=str,
        shape=[],
        description='''
        The contracted Gaussian basis set
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.BASIS_SET'))

    x_cp2k_input_ATOM_AE_BASIS_BASIS_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Basis set type
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.BASIS_TYPE'))

    x_cp2k_input_ATOM_AE_BASIS_D_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for d functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.D_EXPONENTS'))

    x_cp2k_input_ATOM_AE_BASIS_D_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for d functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.D_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_AE_BASIS_EPS_EIGENVALUE = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff of overlap matrix eigenvalues included into basis
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.EPS_EIGENVALUE'))

    x_cp2k_input_ATOM_AE_BASIS_F_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for f functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.F_EXPONENTS'))

    x_cp2k_input_ATOM_AE_BASIS_F_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for f functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.F_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_AE_BASIS_GEO_START_VALUE = Quantity(
        type=str,
        shape=[],
        description='''
        Geometrical basis: starting value a in a*C^k
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.GEO_START_VALUE'))

    x_cp2k_input_ATOM_AE_BASIS_GEOMETRICAL_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Geometrical basis: factor C in a*C^k
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.GEOMETRICAL_FACTOR'))

    x_cp2k_input_ATOM_AE_BASIS_GRID_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of radial grid points
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.GRID_POINTS'))

    x_cp2k_input_ATOM_AE_BASIS_NUM_GTO = Quantity(
        type=str,
        shape=[],
        description='''
        Number of Gaussian type functions for s, p, d, ...
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.NUM_GTO'))

    x_cp2k_input_ATOM_AE_BASIS_NUM_SLATER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of Slater type functions for s, p, d, ...
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.NUM_SLATER'))

    x_cp2k_input_ATOM_AE_BASIS_P_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for p functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.P_EXPONENTS'))

    x_cp2k_input_ATOM_AE_BASIS_P_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for p functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.P_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_AE_BASIS_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to construct the atomic radial grids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.QUADRATURE'))

    x_cp2k_input_ATOM_AE_BASIS_S_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for s functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.S_EXPONENTS'))

    x_cp2k_input_ATOM_AE_BASIS_S_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for s functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.S_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_AE_BASIS_START_INDEX = Quantity(
        type=str,
        shape=[],
        description='''
        Starting index for Geometrical Basis sets
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.AE_BASIS.START_INDEX'))

    x_cp2k_section_input_ATOM_AE_BASIS_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_AE_BASIS_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.AE_BASIS.BASIS'))


class x_cp2k_section_input_ATOM_METHOD_EXTERNAL_VXC(MSection):
    '''
    Section used to specify exernal VXC Potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.EXTERNAL_VXC'))

    x_cp2k_input_ATOM_METHOD_EXTERNAL_VXC_FILE_VXC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename containing the external vxc
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.EXTERNAL_VXC.FILE_VXC'))

    x_cp2k_input_ATOM_METHOD_EXTERNAL_VXC_GRID_TOL = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance in the equivalence of read-grid in ZMP method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.EXTERNAL_VXC.GRID_TOL'))


class x_cp2k_section_input_ATOM_METHOD_XC_ADIABATIC_RESCALING(MSection):
    '''
    Parameters for self interation corrected hybrid functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.ADIABATIC_RESCALING'))

    x_cp2k_input_ATOM_METHOD_XC_ADIABATIC_RESCALING_FUNCTIONAL_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        Which model for the coupling constant integration should be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.ADIABATIC_RESCALING.FUNCTIONAL_MODEL'))

    x_cp2k_input_ATOM_METHOD_XC_ADIABATIC_RESCALING_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which Hybrid functional should be used. (Has to be consistent with the definitions
        in XC and HF).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.ADIABATIC_RESCALING.FUNCTIONAL_TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_ADIABATIC_RESCALING_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        The point to be used along the adiabatic curve (0 &#60; λ &#60; 1)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.ADIABATIC_RESCALING.LAMBDA'))

    x_cp2k_input_ATOM_METHOD_XC_ADIABATIC_RESCALING_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Long-range parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.ADIABATIC_RESCALING.OMEGA'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.HF_INFO'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HF_INFO.FILENAME'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.HFX_RI'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_ATOM_METHOD_XC_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.LOAD_BALANCE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_ATOM_METHOD_XC_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.MEMORY'))

    x_cp2k_input_ATOM_METHOD_XC_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_ATOM_METHOD_XC_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_ATOM_METHOD_XC_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_ATOM_METHOD_XC_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.PERIODIC'))

    x_cp2k_input_ATOM_METHOD_XC_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.SCREENING'))

    x_cp2k_input_ATOM_METHOD_XC_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_ATOM_METHOD_XC_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_ATOM_METHOD_XC_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_ATOM_METHOD_XC_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_ATOM_METHOD_XC_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_ATOM_METHOD_XC_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF'))

    x_cp2k_input_ATOM_METHOD_XC_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.FRACTION'))

    x_cp2k_input_ATOM_METHOD_XC_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_ATOM_METHOD_XC_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.PW_HFX'))

    x_cp2k_input_ATOM_METHOD_XC_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.HF_INFO'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.HFX_RI'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.LOAD_BALANCE'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.MEMORY'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.PERIODIC'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF.SCREENING'))


class x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL(MSection):
    '''
    Information on the non local dispersion functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the FFT grid used in the calculation of the nonlocal vdW functional
        [Ry].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL.CUTOFF'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL_KERNEL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the kernel data file, may include a path.vdW_kernel_table.dat is for DRSLL
        and LMKLL andrVV10_kernel_table.dat is for rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL.KERNEL_FILE_NAME'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Parameters b and C of the rVV10 functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL.PARAMETERS'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of functional (the corresponding kernel data file should be selected).Allows
        for common forms such as vdW-DF, vdW-DF2, optB88-vdW, rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL.TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for non local functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL.VERBOSE_OUTPUT'))


class x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD(MSection):
    '''
    Controls the printing of some info about DFTD contributions
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.ADD_LAST'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.FILENAME'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.LOG_PRINT_KEY'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL(MSection):
    '''
    Information on the pair potential to calculate dispersion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOM_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number of a set of atoms for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOM_COORDINATION_NUMBERS'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOMPARM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies parameters for atom types (in atomic units). If not provided default
        parameters are used (DFT-D2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOMPARM'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_CALCULATE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.CALCULATE_C9_TERM'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,sr6,s8) for the DFT-D3 method, if
        set to zero CP2K attempts to guess the xc functional from REFERENCE_FUNCTIONAL and
        sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3_SCALING'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3BJ_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,a1,s8,a2) for the DFT-D3(BJ)
        method, if set to zero CP2K attempts to guess the xc functional from
        REFERENCE_FUNCTIONAL and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3BJ_SCALING'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EPS_CN = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff value for coordination number function (DFT-D3 method)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EPS_CN'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EXP_PRE = Quantity(
        type=str,
        shape=[],
        description='''
        Prefactor in exponential damping factor (DFT-D2 potential)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EXP_PRE'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_KIND_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number for a kind for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.KIND_COORDINATION_NUMBERS'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_LONG_RANGE_CORRECTION = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate a long range correction to the DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.LONG_RANGE_CORRECTION'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PARAMETER_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the parameter file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PARAMETER_FILE_NAME'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_R_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Range of potential. The cutoff will be 2 times this value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.R_CUTOFF'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model using reference coordination numbers
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_C9_TERM'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Use parameters for this specific density functional. For available D3 and D3(BJ)
        parameters see: http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionals.html,
        http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionalsbj.html
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameter, if set to zero CP2K attempts to guess
        the xc functional that is in use and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.SCALING'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for the DFT-D2 and DFT-D3 models
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.VERBOSE_OUTPUT'))

    x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))


class x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL(MSection):
    '''
    This section combines all possible additional dispersion corrections to the normal XC
    functionals. This can be more functionals or simple empirical pair potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_VDW_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of dispersion/vdW functional or potential to use
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.VDW_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_NON_LOCAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL_PAIR_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_CPHF(MSection):
    '''
    Parameters influencing the solution of the Z-vector equations in MP2 gradients
    calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.CPHF'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_CPHF_EPS_CONV = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence threshold for the solution of the Z-vector equations. The Z-vector
        equations have the form of a linear system of equations Ax=b, convergence is
        achieved when |Ax-b|<=EPS_CONV.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.CPHF.EPS_CONV'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_CPHF_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations allowed for the solution of the Z-vector equations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.CPHF.MAX_ITER'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_DIRECT_CANONICAL(MSection):
    '''
    Parameters influencing the direct canonical method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_DIRECT_CANONICAL_BIG_SEND = Quantity(
        type=str,
        shape=[],
        description='''
        Send big messages between processes (useful for >48 processors).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.DIRECT_CANONICAL.BIG_SEND'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL(MSection):
    '''
    Parameters the interaction potential in computing the biel integrals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, TShPSC operator).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TRUNCATION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines truncation radius for the truncated TShPSC potential. Only valid when
        doing truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TRUNCATION_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TSHPSC_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file TShPSC.dat that contains the data for the evaluation of the
        TShPSC G0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TSHPSC_DATA'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO(MSection):
    '''
    Controls the printing basic info about MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO.ADD_LAST'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO.FILENAME'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS(MSection):
    '''
    Parameters influencing the optimization of the RI MP2 basis. Only exponents of non-
    contracted auxiliary basis can be optimized. An initial RI auxiliary basis has to be
    specified.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_BASIS_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the size of the auxiliary basis set automatically generated as initial
        guess. This will be effective only if RI_AUX_BASIS_SET in the KIND section and
        NUM_FUNC are not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.BASIS_SIZE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_I_REL = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the relative deviation of the amplitudes calculated with and
        without RI approximation, (more details in Chem.Phys.Lett.294(1998)143).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_I_REL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_RI = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the absolute difference between the RI-MP2 and the exact MP2
        energy, DRI=ABS(E_MP2-E_RI-MP2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_RI'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_EPS_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The derivatives of the MP2 energy with respect to the exponents of the basis are
        calculated numerically. The change in the exponent a_i employed for the numerical
        evaluation is defined as h_i=EPS_DERIV*a_i.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.EPS_DERIV'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the maximum number of steps in the RI basis optimization.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.MAX_ITER'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS_NUM_FUNC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of function, for each angular momentum (s, p, d ...),
        employed in the automatically generated initial guess. This will be effective only
        if RI_AUX_BASIS_SET in the KIND section is not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS.NUM_FUNC'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_LAPLACE(MSection):
    '''
    Parameters influencing the RI-SOS-MP2-Laplace method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_LAPLACE_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-SOS-
        MP2-Laplace method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_LAPLACE.QUADRATURE_POINTS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_LAPLACE_SIZE_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for the integration in the Laplace method, that is the number of
        processes involved in the computation of each integration point. SIZE_INTEG_GROUP
        has to be a multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1)
        is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_LAPLACE.SIZE_INTEG_GROUP'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2(MSection):
    '''
    Parameters influencing the RI MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for communication in RI-MP2. Larger BLOCK_SIZE
        reduces communication but requires more memory. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_MP2.BLOCK_SIZE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2_EPS_CANONICAL = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold for discriminate if a given ij pairs of the unrelaxed MP2 density matrix
        has to be calculated with a canonical reformulation based on the occupied
        eigenvalues differences.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_MP2.EPS_CANONICAL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2_FREE_HFX_BUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Free the buffer containing the 4 center integrals used in the Hartree-Fock
        exchange calculation. This will be effective only for gradients calculations,
        since for the energy only case, the buffers are released by default. (Right now
        debugging only).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_MP2.FREE_HFX_BUFFER'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.FILENAME'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.FRACTION'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA(MSection):
    '''
    Parameters influencing the RI RPA method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_MINIMAX_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Use the Minimax quadrature scheme for performing the numerical integration.
        Maximum number of quadrature point limited to 20.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.MINIMAX_QUADRATURE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_MM_STYLE = Quantity(
        type=str,
        shape=[],
        description='''
        Matrix multiplication style for the Q matrix.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.MM_STYLE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-RPA method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.QUADRATURE_POINTS'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_SIZE_FREQ_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for frequency integration, that is the number of processes involved in
        the computation of each integration point. SIZE_FREQ_INTEG_GROUP has to be a
        multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1) is
        automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.SIZE_FREQ_INTEG_GROUP'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA.HF'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW(MSection):
    '''
    Parameters for the GPW approach in Wavefunction-based Correlation methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the finest grid level in the MP2 gpw integration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW.CUTOFF'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the DBCSR based multiply (usually 10 times smaller than
        EPS_GRID).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW.EPS_FILTER'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW_EPS_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the GPW based integration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW.EPS_GRID'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW_PRINT_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        How much output is written by the individual groups.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW.PRINT_LEVEL'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the grid at which a Gaussian is mapped.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW.REL_CUTOFF'))


class x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION(MSection):
    '''
    Sets up the Wavefunction-based Correlation parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_CALC_COND_NUM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate the condition number of the (P|Q) matrix for the RI methods.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.CALC_COND_NUM'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_COL_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the column block used in the SCALAPACK block cyclic data
        distribution.Default is (COL_BLOCK=-1) is automatic. A proper choice can speedup
        the parallel matrix multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.COL_BLOCK'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_GROUP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Group size used in the computation of the integrals. Default is to use all
        processors (GROUP_SIZE=-1).A smaller group size (for example the node size), might
        a better choice if the actual MP2 time is large compared to integral computation
        time. This is usually the case if the total number of processors is not too large.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.GROUP_SIZE'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed total memory usage during MP2 methods [Mb].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.MEMORY'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Which method should be used to compute the MP2 energy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.METHOD'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_ROW_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the row block used in the SCALAPACK block cyclic data distribution.Default
        is (ROW_BLOCK=-1) is automatic. A proper choice can speedup the parallel matrix
        multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.ROW_BLOCK'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_SCALE_S = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the singlet energy component (opposite spin, OS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.SCALE_S'))

    x_cp2k_input_ATOM_METHOD_XC_WF_CORRELATION_SCALE_T = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the triplet energy component (same spin, SS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.WF_CORRELATION.SCALE_T'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_CPHF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_CPHF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.CPHF'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_DIRECT_CANONICAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_DIRECT_CANONICAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_MP2_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_OPT_RI_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_LAPLACE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_LAPLACE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_MP2'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_RI_RPA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION_WFC_GPW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION.WFC_GPW'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC(MSection):
    '''
    Uses the Becke 88 longrange exchange functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.LAMBDA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.OMEGA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR(MSection):
    '''
    Uses the Becke 88 longrange exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR.OMEGA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88(MSection):
    '''
    Uses the Becke 88 exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97(MSection):
    '''
    Uses the Becke 97 exchange correlation functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the B97 and Grimme parametrization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97.PARAMETRIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional, if -1 the default for the given
        parametrization is used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL(MSection):
    '''
    Becke Roussel exchange hole model. Can be usedas long range correction with a
    truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff radius for the truncation. If put to zero, the standard full
        range potential will be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter in the exchange hole. Usually this is put to 1.0 or 0.8
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.GAMMA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BEEF(MSection):
    '''
    Uses the BEEFvdW exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BEEF_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BEEF.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BEEF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BEEF.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_CS1(MSection):
    '''
    Uses the CS1 functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_CS1_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.CS1.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09(MSection):
    '''
    Combination of three different exchange hole models
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for Becke Roussel hole
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09.GAMMA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_HCTH(MSection):
    '''
    Uses the HCTH class of functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_HCTH_PARAMETER_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the parameters should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.HCTH.PARAMETER_SET'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_HCTH_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.HCTH.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_GGA(MSection):
    '''
    Uses one of the KE_GGA functionals (optimized versions of some of these functionals
    might be available outside this section). These functionals are needed for the
    computation of the kinetic energy in the Kim-Gordon method.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_GGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the KE_GGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_GGA.FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_GGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_GGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC(MSection):
    '''
    To be used for KG runs. Uses kinetic energy functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC.FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC.PARAMETERS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC.SCALE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR(MSection):
    '''
    LDA exchange hole model in truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC(MSection):
    '''
    Uses functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC.FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC.PARAMETERS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC.SCALE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_ADIABATIC(MSection):
    '''
    Uses the LYP correlation functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP_ADIABATIC.LAMBDA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP(MSection):
    '''
    Uses the LYP functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_OPTX(MSection):
    '''
    Uses the OPTX functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_OPTX_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.OPTX.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_OPTX_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.OPTX.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_P86C(MSection):
    '''
    Uses the P86C functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_P86C_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.P86C.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_P86C_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.P86C.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PADE(MSection):
    '''
    Uses the PADE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PADE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PADE.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR(MSection):
    '''
    PBE exchange hole model in trucanted coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE(MSection):
    '''
    Uses the PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the different parametrizations of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE.PARAMETRIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92(MSection):
    '''
    Uses the PerdewWang correlation functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PW92.PARAMETRIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the energy functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PW92.SCALE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PW92.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81(MSection):
    '''
    Uses the PZ functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PZ81.PARAMETRIZATION'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PZ81.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PZ81.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TFW(MSection):
    '''
    Uses the TFW functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TFW_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TFW.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TF(MSection):
    '''
    Uses the TF functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TF.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS(MSection):
    '''
    Uses the TPSS functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TPSS.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TPSS.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TPSS.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN(MSection):
    '''
    Uses the VWN functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the VWN functional should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.VWN.FUNCTIONAL_TYPE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.VWN.SCALE_C'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.VWN.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA(MSection):
    '''
    Uses the XALPHA (SLATER) functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XALPHA.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XALPHA.SECTION_PARAMETERS'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA_XA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the xa parameter (this does not change the exponent, just the mixing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XALPHA.XA'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XGGA(MSection):
    '''
    Uses one of the XGGA functionals (optimized versions of some of these functionals
    might be available outside this section).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XGGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the XGGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XGGA.FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XGGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XGGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE(MSection):
    '''
    Uses the short range PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        screening parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE.OMEGA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE_SCALE_X0 = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the original hole PBE-functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE.SCALE_X0'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE.SCALE_X'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL(MSection):
    '''
    The xc functional to use
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_FUNCTIONAL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Shortcut for the most common functional combinations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_FUNCTIONAL.SECTION_PARAMETERS'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE88'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE97'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BECKE_ROUSSEL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BEEF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_BEEF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_CS1 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_CS1'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_GV09'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_HCTH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_HCTH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_GGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_GGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_KE_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_LYP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_OPTX = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_OPTX'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_P86C = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_P86C'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PADE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PADE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PW92'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_PZ81'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TFW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TFW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_TPSS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_VWN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XALPHA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XGGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XGGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL_XWPBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL.XWPBE'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_GRID(MSection):
    '''
    The xc parameters used when calculating the xc on the grid
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_GRID'))

    x_cp2k_input_ATOM_METHOD_XC_XC_GRID_USE_FINER_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a finer grid only to calculate the xc
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_GRID.USE_FINER_GRID'))

    x_cp2k_input_ATOM_METHOD_XC_XC_GRID_XC_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The method used to compute the derivatives
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_GRID.XC_DERIV'))

    x_cp2k_input_ATOM_METHOD_XC_XC_GRID_XC_SMOOTH_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        The density smoothing used for the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_GRID.XC_SMOOTH_RHO'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP(MSection):
    '''
    Uses the SAOP potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_POTENTIAL.SAOP'))

    x_cp2k_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the alpha parameter (default = 1.19).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_POTENTIAL.SAOP.ALPHA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the beta parameter (default = 0.01).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_POTENTIAL.SAOP.BETA'))

    x_cp2k_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP_K_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the K_rho parameter (default = 0.42).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_POTENTIAL.SAOP.K_RHO'))


class x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL(MSection):
    '''
    The xc potential to use (CAREFUL: xc potential here refers to potentials that are not
    derived from an xc functional, but rather are modelled directly. Therefore there is no
    consistent xc energy available. To still get an energy expression, see ENERGY below
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_POTENTIAL'))

    x_cp2k_input_ATOM_METHOD_XC_XC_POTENTIAL_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        How to determine the total energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.XC_POTENTIAL.ENERGY'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL_SAOP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_POTENTIAL.SAOP'))


class x_cp2k_section_input_ATOM_METHOD_XC(MSection):
    '''
    parameters needed calculate the xc potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC'))

    x_cp2k_input_ATOM_METHOD_XC_DENSITY_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.DENSITY_CUTOFF'))

    x_cp2k_input_ATOM_METHOD_XC_DENSITY_SMOOTH_CUTOFF_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for the smoothing procedure inxc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.DENSITY_SMOOTH_CUTOFF_RANGE'))

    x_cp2k_input_ATOM_METHOD_XC_FUNCTIONAL_ROUTINE = Quantity(
        type=str,
        shape=[],
        description='''
        Select the code for xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.FUNCTIONAL_ROUTINE'))

    x_cp2k_input_ATOM_METHOD_XC_GRADIENT_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the gradient of the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.GRADIENT_CUTOFF'))

    x_cp2k_input_ATOM_METHOD_XC_TAU_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on tau used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.XC.TAU_CUTOFF'))

    x_cp2k_section_input_ATOM_METHOD_XC_ADIABATIC_RESCALING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_ADIABATIC_RESCALING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.ADIABATIC_RESCALING'))

    x_cp2k_section_input_ATOM_METHOD_XC_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.HF'))

    x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_VDW_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.VDW_POTENTIAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_WF_CORRELATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.WF_CORRELATION'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_FUNCTIONAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_FUNCTIONAL'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_GRID'))

    x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC_XC_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC.XC_POTENTIAL'))


class x_cp2k_section_input_ATOM_METHOD_ZMP_RESTART(MSection):
    '''
    Section used to specify the restart option in the ZMPprocedure, and the file that must
    be read.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.ZMP.RESTART'))

    x_cp2k_input_ATOM_METHOD_ZMP_RESTART_FILE_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename containing the restart file density
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.ZMP.RESTART.FILE_RESTART'))


class x_cp2k_section_input_ATOM_METHOD_ZMP(MSection):
    '''
    Section used to specify ZMP Potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.ZMP'))

    x_cp2k_input_ATOM_METHOD_ZMP_DM = Quantity(
        type=str,
        shape=[],
        description='''
        read external density from density matrix
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.ZMP.DM'))

    x_cp2k_input_ATOM_METHOD_ZMP_FILE_DENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename containing the target density
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.ZMP.FILE_DENSITY'))

    x_cp2k_input_ATOM_METHOD_ZMP_GRID_TOL = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance in the equivalence of read-grid in ZMP method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.ZMP.GRID_TOL'))

    x_cp2k_input_ATOM_METHOD_ZMP_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter used for the constraint in ZMP method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.ZMP.LAMBDA'))

    x_cp2k_section_input_ATOM_METHOD_ZMP_RESTART = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_ZMP_RESTART'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.ZMP.RESTART'))


class x_cp2k_section_input_ATOM_METHOD(MSection):
    '''
    Section of information on method to use.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD'))

    x_cp2k_input_ATOM_METHOD_METHOD_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of electronic structure method to be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.METHOD_TYPE'))

    x_cp2k_input_ATOM_METHOD_RELATIVISTIC = Quantity(
        type=str,
        shape=[],
        description='''
        Type of scalar relativistic method to be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.METHOD.RELATIVISTIC'))

    x_cp2k_section_input_ATOM_METHOD_EXTERNAL_VXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_EXTERNAL_VXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.EXTERNAL_VXC'))

    x_cp2k_section_input_ATOM_METHOD_XC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_XC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.XC'))

    x_cp2k_section_input_ATOM_METHOD_ZMP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD_ZMP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD.ZMP'))


class x_cp2k_section_input_ATOM_OPTIMIZATION(MSection):
    '''
    Section of information on optimization thresholds and algorithms.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.OPTIMIZATION'))

    x_cp2k_input_ATOM_OPTIMIZATION_DAMPING = Quantity(
        type=str,
        shape=[],
        description='''
        Damping parameter for extrapolation method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.OPTIMIZATION.DAMPING'))

    x_cp2k_input_ATOM_OPTIMIZATION_EPS_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Starting DIIS method at convergence to EPS_DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.OPTIMIZATION.EPS_DIIS'))

    x_cp2k_input_ATOM_OPTIMIZATION_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence criterion for SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.OPTIMIZATION.EPS_SCF'))

    x_cp2k_input_ATOM_OPTIMIZATION_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations for optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.OPTIMIZATION.MAX_ITER'))

    x_cp2k_input_ATOM_OPTIMIZATION_N_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of DIIS vectors
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.OPTIMIZATION.N_DIIS'))


class x_cp2k_section_input_ATOM_POTENTIAL_GTH_POTENTIAL(MSection):
    '''
    Section used to specify Potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POTENTIAL.GTH_POTENTIAL'))

    x_cp2k_input_ATOM_POTENTIAL_GTH_POTENTIAL_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        CP2K Pseudo Potential Standard Format (GTH, ALL or KG)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POTENTIAL.GTH_POTENTIAL.DEFAULT_KEYWORD'))


class x_cp2k_section_input_ATOM_POTENTIAL(MSection):
    '''
    Section of information on potential.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POTENTIAL'))

    x_cp2k_input_ATOM_POTENTIAL_CONFINEMENT = Quantity(
        type=str,
        shape=[],
        description='''
        Definition of confinement potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POTENTIAL.CONFINEMENT'))

    x_cp2k_input_ATOM_POTENTIAL_POTENTIAL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the pseudo potential file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POTENTIAL.POTENTIAL_FILE_NAME'))

    x_cp2k_input_ATOM_POTENTIAL_POTENTIAL_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        The name of the pseudopotential for the defined kind.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POTENTIAL.POTENTIAL_NAME'))

    x_cp2k_input_ATOM_POTENTIAL_PSEUDO_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Pseudopotential type
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POTENTIAL.PSEUDO_TYPE'))

    x_cp2k_section_input_ATOM_POTENTIAL_GTH_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_POTENTIAL_GTH_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POTENTIAL.GTH_POTENTIAL'))


class x_cp2k_section_input_ATOM_POWELL(MSection):
    '''
    Section defines basic parameters for Powell optimization
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POWELL'))

    x_cp2k_input_ATOM_POWELL_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Final accuracy requested in optimization (RHOEND)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.ACCURACY'))

    x_cp2k_input_ATOM_POWELL_MAX_FUN = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of function evaluations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.MAX_FUN'))

    x_cp2k_input_ATOM_POWELL_RCOV_MULTIPLICATION = Quantity(
        type=str,
        shape=[],
        description='''
        Multiply Rcov integration limit for charge conservation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.RCOV_MULTIPLICATION'))

    x_cp2k_input_ATOM_POWELL_STEP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial step size for search algorithm (RHOBEG)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.STEP_SIZE'))

    x_cp2k_input_ATOM_POWELL_TARGET_POT_SEMICORE = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy for semicore state eigenvalues in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.TARGET_POT_SEMICORE'))

    x_cp2k_input_ATOM_POWELL_TARGET_POT_VALENCE = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy for valence state eigenvalues in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.TARGET_POT_VALENCE'))

    x_cp2k_input_ATOM_POWELL_TARGET_POT_VIRTUAL = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy for virtual state eigenvalues in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.TARGET_POT_VIRTUAL'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_ELECTRON_CONFIGURATION = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for different electronic states in optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_ELECTRON_CONFIGURATION'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for different methods in optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_METHOD'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_POT_NODE = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for node mismatch in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_POT_NODE'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_POT_SEMICORE = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for semi core states in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_POT_SEMICORE'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_POT_VALENCE = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for valence states in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_POT_VALENCE'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_POT_VIRTUAL = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for virtual states in pseudopotential optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_POT_VIRTUAL'))

    x_cp2k_input_ATOM_POWELL_WEIGHT_PSIR0 = Quantity(
        type=str,
        shape=[],
        description='''
        Weight for the wavefunctions at r=0 (only occupied states)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.POWELL.WEIGHT_PSIR0'))


class x_cp2k_section_input_ATOM_PP_BASIS_BASIS(MSection):
    '''
    Section used to specify a general basis set for QM calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.PP_BASIS.BASIS'))

    x_cp2k_input_ATOM_PP_BASIS_BASIS_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        CP2K Basis Set Standard Format
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.BASIS.DEFAULT_KEYWORD'))


class x_cp2k_section_input_ATOM_PP_BASIS(MSection):
    '''
    Section of basis set information for pseudopotential calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.PP_BASIS'))

    x_cp2k_input_ATOM_PP_BASIS_BASIS_SET_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the basis set file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.BASIS_SET_FILE_NAME'))

    x_cp2k_input_ATOM_PP_BASIS_BASIS_SET = Quantity(
        type=str,
        shape=[],
        description='''
        The contracted Gaussian basis set
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.BASIS_SET'))

    x_cp2k_input_ATOM_PP_BASIS_BASIS_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Basis set type
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.BASIS_TYPE'))

    x_cp2k_input_ATOM_PP_BASIS_D_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for d functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.D_EXPONENTS'))

    x_cp2k_input_ATOM_PP_BASIS_D_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for d functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.D_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_PP_BASIS_EPS_EIGENVALUE = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff of overlap matrix eigenvalues included into basis
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.EPS_EIGENVALUE'))

    x_cp2k_input_ATOM_PP_BASIS_F_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for f functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.F_EXPONENTS'))

    x_cp2k_input_ATOM_PP_BASIS_F_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for f functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.F_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_PP_BASIS_GEO_START_VALUE = Quantity(
        type=str,
        shape=[],
        description='''
        Geometrical basis: starting value a in a*C^k
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.GEO_START_VALUE'))

    x_cp2k_input_ATOM_PP_BASIS_GEOMETRICAL_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Geometrical basis: factor C in a*C^k
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.GEOMETRICAL_FACTOR'))

    x_cp2k_input_ATOM_PP_BASIS_GRID_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of radial grid points
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.GRID_POINTS'))

    x_cp2k_input_ATOM_PP_BASIS_NUM_GTO = Quantity(
        type=str,
        shape=[],
        description='''
        Number of Gaussian type functions for s, p, d, ...
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.NUM_GTO'))

    x_cp2k_input_ATOM_PP_BASIS_NUM_SLATER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of Slater type functions for s, p, d, ...
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.NUM_SLATER'))

    x_cp2k_input_ATOM_PP_BASIS_P_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for p functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.P_EXPONENTS'))

    x_cp2k_input_ATOM_PP_BASIS_P_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for p functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.P_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_PP_BASIS_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to construct the atomic radial grids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.QUADRATURE'))

    x_cp2k_input_ATOM_PP_BASIS_S_EXPONENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents for s functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.S_EXPONENTS'))

    x_cp2k_input_ATOM_PP_BASIS_S_QUANTUM_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Main quantum numbers for s functions
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.S_QUANTUM_NUMBERS'))

    x_cp2k_input_ATOM_PP_BASIS_START_INDEX = Quantity(
        type=str,
        shape=[],
        description='''
        Starting index for Geometrical Basis sets
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.PP_BASIS.START_INDEX'))

    x_cp2k_section_input_ATOM_PP_BASIS_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_PP_BASIS_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.PP_BASIS.BASIS'))


class x_cp2k_section_input_ATOM(MSection):
    '''
    Section handling input for atomic calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM'))

    x_cp2k_input_ATOM_ATOMIC_NUMBER = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the atomic number
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.ATOMIC_NUMBER'))

    x_cp2k_input_ATOM_CALCULATE_STATES = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of states calculated per l value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.CALCULATE_STATES'))

    x_cp2k_input_ATOM_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the core electrons for a pseudopotential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.CORE'))

    x_cp2k_input_ATOM_COULOMB_INTEGRALS = Quantity(
        type=str,
        shape=[],
        description='''
        Method to calculate Coulomb integrals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.COULOMB_INTEGRALS'))

    x_cp2k_input_ATOM_ELECTRON_CONFIGURATION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the electron configuration. Optional the multiplicity (m) and a core
        state [XX] can be declared
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.ELECTRON_CONFIGURATION'))

    x_cp2k_input_ATOM_ELEMENT = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the element to be calculated
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.ELEMENT'))

    x_cp2k_input_ATOM_EXCHANGE_INTEGRALS = Quantity(
        type=str,
        shape=[],
        description='''
        Method to calculate Exchange integrals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.EXCHANGE_INTEGRALS'))

    x_cp2k_input_ATOM_MAX_ANGULAR_MOMENTUM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the largest angular momentum calculated [0-3]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.MAX_ANGULAR_MOMENTUM'))

    x_cp2k_input_ATOM_RUN_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of run that you want to perform
        [ENERGY,BASIS_OPTIMIZATION,PSEUDOPOTENTIAL_OPTIMIZATION,,...]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_ATOM.RUN_TYPE'))

    x_cp2k_section_input_ATOM_AE_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_AE_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.AE_BASIS'))

    x_cp2k_section_input_ATOM_METHOD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_METHOD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.METHOD'))

    x_cp2k_section_input_ATOM_OPTIMIZATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_OPTIMIZATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.OPTIMIZATION'))

    x_cp2k_section_input_ATOM_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POTENTIAL'))

    x_cp2k_section_input_ATOM_POWELL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_POWELL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.POWELL'))

    x_cp2k_section_input_ATOM_PP_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_ATOM_PP_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_ATOM.PP_BASIS'))


class x_cp2k_section_input_DEBUG_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing of the DEBUG specific output
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_DEBUG.PROGRAM_RUN_INFO'))

    x_cp2k_input_DEBUG_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_DEBUG_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_DEBUG_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_DEBUG_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_DEBUG_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_DEBUG(MSection):
    '''
    Section to setup parameters for debug runs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_DEBUG'))

    x_cp2k_input_DEBUG_DEBUG_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Activates the debugging of the atomic forces
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.DEBUG_FORCES'))

    x_cp2k_input_DEBUG_DEBUG_STRESS_TENSOR = Quantity(
        type=str,
        shape=[],
        description='''
        Activates the debugging of the stress tensor
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.DEBUG_STRESS_TENSOR'))

    x_cp2k_input_DEBUG_DX = Quantity(
        type=str,
        shape=[],
        description='''
        Increment for the calculation of the numerical derivatives
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.DX'))

    x_cp2k_input_DEBUG_EPS_NO_ERROR_CHECK = Quantity(
        type=str,
        shape=[],
        description='''
        The mismatch between the numerical and the analytical value is not checked for
        analytical values smaller than this threshold value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.EPS_NO_ERROR_CHECK'))

    x_cp2k_input_DEBUG_STOP_ON_MISMATCH = Quantity(
        type=str,
        shape=[],
        description='''
        Stop the debug run when a mismatch between the numerical and the analytical value
        is detected
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_DEBUG.STOP_ON_MISMATCH'))

    x_cp2k_section_input_DEBUG_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_DEBUG_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_DEBUG.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_EXT_RESTART(MSection):
    '''
    Section for external restart, specifies an external input file where to take
    positions,...
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_EXT_RESTART'))

    x_cp2k_input_EXT_RESTART_BINARY_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the name of an additional restart file from which selected input
        sections are read in binary format (see SPLIT_RESTART_FILE).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.BINARY_RESTART_FILE_NAME'))

    x_cp2k_input_EXT_RESTART_CUSTOM_PATH = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the given path from the EXTERNAL file. Allows a major flexibility for
        restarts.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.CUSTOM_PATH'))

    x_cp2k_input_EXT_RESTART_RESTART_AVERAGES = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts information for AVERAGES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_AVERAGES'))

    x_cp2k_input_EXT_RESTART_RESTART_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts positions and velocities of the Band.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_BAND'))

    x_cp2k_input_EXT_RESTART_RESTART_BAROSTAT_THERMOSTAT = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the barostat thermostat from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_BAROSTAT_THERMOSTAT'))

    x_cp2k_input_EXT_RESTART_RESTART_BAROSTAT = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the barostat from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_BAROSTAT'))

    x_cp2k_input_EXT_RESTART_RESTART_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts information for BSSE calculations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_BSSE'))

    x_cp2k_input_EXT_RESTART_RESTART_CELL = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the cell (and cell_ref) from the EXTERNAL file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_CELL'))

    x_cp2k_input_EXT_RESTART_RESTART_CONSTRAINT = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts constraint section. It's necessary when doing restraint calculation to
        have a perfect energy conservation. For constraints only it's use is optional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_CONSTRAINT'))

    x_cp2k_input_EXT_RESTART_RESTART_CORE_POS = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the positions of the cores from the external file (only if shell-model)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_CORE_POS'))

    x_cp2k_input_EXT_RESTART_RESTART_CORE_VELOCITY = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the velocities of the shells from the external file (only if shell-model)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_CORE_VELOCITY'))

    x_cp2k_input_EXT_RESTART_RESTART_COUNTERS = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the counters in MD schemes
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_COUNTERS'))

    x_cp2k_input_EXT_RESTART_RESTART_DEFAULT = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword controls the default value for all possible  restartable keywords,
        unless explicitly defined. For example setting this keyword to .FALSE. does not
        restart any quantity. If, at the  same time, one keyword is set to .TRUE. only
        that quantity will be restarted.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_DEFAULT'))

    x_cp2k_input_EXT_RESTART_RESTART_DIMER = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts information for DIMER geometry optimizations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_DIMER'))

    x_cp2k_input_EXT_RESTART_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the name of restart file (or any other input file) to be read. Only
        fields relevant to a restart will be used (unless switched off with the keywords
        in this section)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_FILE_NAME'))

    x_cp2k_input_EXT_RESTART_RESTART_HELIUM_DENSITIES = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts helium density distributions from PINT%HELIUM%RHO.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_HELIUM_DENSITIES'))

    x_cp2k_input_EXT_RESTART_RESTART_HELIUM_FORCE = Quantity(
        type=str,
        shape=[],
        description='''
        Restart helium forces exerted on the solute from PINT%HELIUM%FORCE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_HELIUM_FORCE'))

    x_cp2k_input_EXT_RESTART_RESTART_HELIUM_PERMUTATION = Quantity(
        type=str,
        shape=[],
        description='''
        Restart helium permutation state from PINT%HELIUM%PERM.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_HELIUM_PERMUTATION'))

    x_cp2k_input_EXT_RESTART_RESTART_HELIUM_POS = Quantity(
        type=str,
        shape=[],
        description='''
        Restart helium positions from PINT%HELIUM%COORD.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_HELIUM_POS'))

    x_cp2k_input_EXT_RESTART_RESTART_HELIUM_RNG = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts helium random number generators from PINT%HELIUM%RNG_STATE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_HELIUM_RNG'))

    x_cp2k_input_EXT_RESTART_RESTART_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts hills from a previous metadynamics run from the EXTERNAL file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_METADYNAMICS'))

    x_cp2k_input_EXT_RESTART_RESTART_OPTIMIZE_INPUT_VARIABLES = Quantity(
        type=str,
        shape=[],
        description='''
        Restart with the optimize input variables
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_OPTIMIZE_INPUT_VARIABLES'))

    x_cp2k_input_EXT_RESTART_RESTART_PINT_GLE = Quantity(
        type=str,
        shape=[],
        description='''
        Restart GLE thermostat for beads from PINT%GLE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_PINT_GLE'))

    x_cp2k_input_EXT_RESTART_RESTART_PINT_NOSE = Quantity(
        type=str,
        shape=[],
        description='''
        Restart Nose thermostat for beads from PINT%NOSE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_PINT_NOSE'))

    x_cp2k_input_EXT_RESTART_RESTART_PINT_POS = Quantity(
        type=str,
        shape=[],
        description='''
        Restart bead positions from PINT%BEADS%COORD.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_PINT_POS'))

    x_cp2k_input_EXT_RESTART_RESTART_PINT_VEL = Quantity(
        type=str,
        shape=[],
        description='''
        Restart bead velocities from PINT%BEADS%VELOCITY.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_PINT_VEL'))

    x_cp2k_input_EXT_RESTART_RESTART_POS = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the positions from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_POS'))

    x_cp2k_input_EXT_RESTART_RESTART_QMMM = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the following specific QMMM info: translation vectors.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_QMMM'))

    x_cp2k_input_EXT_RESTART_RESTART_RANDOMG = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the random number generator from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_RANDOMG'))

    x_cp2k_input_EXT_RESTART_RESTART_RTP = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts information for REAL TIME PROPAGATION and EHRENFEST DYNAMICS.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_RTP'))

    x_cp2k_input_EXT_RESTART_RESTART_SHELL_POS = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the positions of the shells from the external file (only if shell-model)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_SHELL_POS'))

    x_cp2k_input_EXT_RESTART_RESTART_SHELL_THERMOSTAT = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the shell thermostat from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_SHELL_THERMOSTAT'))

    x_cp2k_input_EXT_RESTART_RESTART_SHELL_VELOCITY = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the velocities of the shells from the external file (only if shell-model)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_SHELL_VELOCITY'))

    x_cp2k_input_EXT_RESTART_RESTART_THERMOSTAT = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts the nose thermostats of the particles from the EXTERNAL file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_THERMOSTAT'))

    x_cp2k_input_EXT_RESTART_RESTART_VEL = Quantity(
        type=str,
        shape=[],
        description='''
        Takes the velocities from the external file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_VEL'))

    x_cp2k_input_EXT_RESTART_RESTART_WALKERS = Quantity(
        type=str,
        shape=[],
        description='''
        Restarts walkers informations from a previous metadynamics run from the EXTERNAL
        file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_EXT_RESTART.RESTART_WALKERS'))


class x_cp2k_section_input_FARMING_JOB(MSection):
    '''
    description of the jobs to be executed
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.JOB'))

    x_cp2k_input_FARMING_JOB_DEPENDENCIES = Quantity(
        type=str,
        shape=[],
        description='''
        specifies a list of JOB_IDs on which the current job depends. The current job will
        not be executed before all the dependencies have finished. The keyword requires a
        MASTER_SLAVE farming run. Beyond the default case, some special cases might arise:
        1) circular dependencies will lead to a deadlock. 2) This keyword is not
        compatible with CYCLE. 3) MAX_JOBS_PER_GROUP is ignored (though only a total of
        MAX_JOBS_PER_GROUP*NGROUPS jobs will be executed) 4) dependencies on jobs that
        will not be executed (due to RESTART or MAX_JOBS_PER_GROUP) are ignored.
        Additionally, note that, on some file systems,  output (restart) files might not
        be immediately available on all compute nodes,potentially resulting in unexpected
        failures.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.JOB.DEPENDENCIES'))

    x_cp2k_input_FARMING_JOB_DIRECTORY = Quantity(
        type=str,
        shape=[],
        description='''
        the directory in which the job should be executed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.JOB.DIRECTORY'))

    x_cp2k_input_FARMING_JOB_INPUT_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        the filename of the input file
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.JOB.INPUT_FILE_NAME'))

    x_cp2k_input_FARMING_JOB_JOB_ID = Quantity(
        type=str,
        shape=[],
        description='''
        An ID used to indentify a job in DEPENDENCIES. JOB_IDs do not need to be unique,
        dependencies will be on all jobs with a given ID. If no JOB_ID is given, the index
        of the &JOB section in the input file will be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.JOB.JOB_ID'))

    x_cp2k_input_FARMING_JOB_OUTPUT_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        the filename of the output file, if not specified will use the project name in the
        &GLOBAL section.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.JOB.OUTPUT_FILE_NAME'))


class x_cp2k_section_input_FARMING_PROGRAM_RUN_INFO(MSection):
    '''
    controls the printing of FARMING specific output
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.PROGRAM_RUN_INFO'))

    x_cp2k_input_FARMING_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FARMING_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FARMING_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FARMING_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FARMING_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FARMING_RESTART(MSection):
    '''
    controls the printing of the restart for FARMING.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.RESTART'))

    x_cp2k_input_FARMING_RESTART_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART.ADD_LAST'))

    x_cp2k_input_FARMING_RESTART_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FARMING_RESTART_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART.FILENAME'))

    x_cp2k_input_FARMING_RESTART_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART.LOG_PRINT_KEY'))

    x_cp2k_input_FARMING_RESTART_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART.SECTION_PARAMETERS'))


class x_cp2k_section_input_FARMING(MSection):
    '''
    Describes a farming job, in which multiple inputs are executed.

    The RUN_TYPE in the global section has to be set to NONE for FARMING.

    The different groups are executed in parallel. The jobs inside the same groups in
    series.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING'))

    x_cp2k_input_FARMING_CYCLE = Quantity(
        type=str,
        shape=[],
        description='''
        If farming should process all jobs in a cyclic way, stopping only if
        MAX_JOBS_PER_GROUP is exceeded.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.CYCLE'))

    x_cp2k_input_FARMING_DO_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        Restart a farming job (and should pick up where the previous left off)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.DO_RESTART'))

    x_cp2k_input_FARMING_GROUP_PARTITION = Quantity(
        type=str,
        shape=[],
        description='''
        gives the exact number of processors for each group.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.GROUP_PARTITION'))

    x_cp2k_input_FARMING_GROUP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Gives the preferred size of a working group, groups will always be equal or larger
        than this size.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.GROUP_SIZE'))

    x_cp2k_input_FARMING_MASTER_SLAVE = Quantity(
        type=str,
        shape=[],
        description='''
        If a master-slave setup should be employed, in which one process is used to
        distribute the tasks. This is most useful to load-balance if not all jobs have the
        same length, and a lot of CPUs/groups are availabe.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.MASTER_SLAVE'))

    x_cp2k_input_FARMING_MAX_JOBS_PER_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        maximum number of jobs executed per group
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.MAX_JOBS_PER_GROUP'))

    x_cp2k_input_FARMING_NGROUPS = Quantity(
        type=str,
        shape=[],
        description='''
        Gives the preferred number of working groups.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.NGROUPS'))

    x_cp2k_input_FARMING_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the restart file to use for restarting a FARMING run. If not specified the
        name is determined from PROJECT name.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.RESTART_FILE_NAME'))

    x_cp2k_input_FARMING_WAIT_TIME = Quantity(
        type=str,
        shape=[],
        description='''
        Time to wait [s] for a new task if no task is currently available, make this zero
        if no clock is available
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FARMING.WAIT_TIME'))

    x_cp2k_section_input_FARMING_JOB = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FARMING_JOB'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.JOB'))

    x_cp2k_section_input_FARMING_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FARMING_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.PROGRAM_RUN_INFO'))

    x_cp2k_section_input_FARMING_RESTART = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FARMING_RESTART'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FARMING.RESTART'))


class x_cp2k_section_input_FORCE_EVAL_BSSE_CONFIGURATION(MSection):
    '''
    Specify additional parameters for the combinatorial configurations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.CONFIGURATION'))

    x_cp2k_input_FORCE_EVAL_BSSE_CONFIGURATION_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        The total charge for each fragment.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.CONFIGURATION.CHARGE'))

    x_cp2k_input_FORCE_EVAL_BSSE_CONFIGURATION_GLB_CONF = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the global configuration using 1 or 0.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.CONFIGURATION.GLB_CONF'))

    x_cp2k_input_FORCE_EVAL_BSSE_CONFIGURATION_MULTIPLICITY = Quantity(
        type=str,
        shape=[],
        description='''
        Specify for each fragment the multiplicity. Two times the total spin plus one.
        Specify 3 for a triplet, 4 for a quartet,and so on. Default is 1 (singlet) for an
        even number and 2 (doublet) for an odd number of electrons.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.CONFIGURATION.MULTIPLICITY'))

    x_cp2k_input_FORCE_EVAL_BSSE_CONFIGURATION_SUB_CONF = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the subconfiguration using 1 or 0 belonging to the global configuration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.CONFIGURATION.SUB_CONF'))


class x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT_ENERGIES(MSection):
    '''
    This section contains the energies of the fragments already computed. It is useful as
    a summary and specifically for restarting BSSE runs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.FRAGMENT_ENERGIES'))

    x_cp2k_input_FORCE_EVAL_BSSE_FRAGMENT_ENERGIES_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        The energy computed for each fragment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.FRAGMENT_ENERGIES.DEFAULT_KEYWORD'))


class x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT(MSection):
    '''
    Specify the atom number belonging to this fragment.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.FRAGMENT'))

    x_cp2k_input_FORCE_EVAL_BSSE_FRAGMENT_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies a list of atoms.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.BSSE.FRAGMENT.LIST'))


class x_cp2k_section_input_FORCE_EVAL_BSSE(MSection):
    '''
    This section is used to set up the BSSE calculation. It also requires that for each
    atomic kind X a kind X_ghost is present, with the GHOST keyword specified, in addition
    to the other required fields.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE'))

    x_cp2k_section_input_FORCE_EVAL_BSSE_CONFIGURATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_BSSE_CONFIGURATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.CONFIGURATION'))

    x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT_ENERGIES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT_ENERGIES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.FRAGMENT_ENERGIES'))

    x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_BSSE_FRAGMENT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.BSSE.FRAGMENT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS(MSection):
    '''
    Controls the iterative DIIS-accelerated optimization of block-diagonal ALMOs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS_EPS_ERROR = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the MAX norm of the error
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_DIIS.EPS_ERROR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_DIIS.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS_N_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of error vectors to be used in the DIIS optimization procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_DIIS.N_DIIS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG(MSection):
    '''
    Controls the PCG optimization of block-diagonal ALMOs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_CONJUGATOR = Quantity(
        type=str,
        shape=[],
        description='''
        Various methods to compute step directions in the PCG optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.CONJUGATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_EPS_ERROR = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the MAX norm of the error
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.EPS_ERROR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_LIN_SEARCH_EPS_ERROR = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the gradient norm during the linear search
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.LIN_SEARCH_EPS_ERROR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_LIN_SEARCH_STEP_SIZE_GUESS = Quantity(
        type=str,
        shape=[],
        description='''
        The size of the first step in the linear search
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.LIN_SEARCH_STEP_SIZE_GUESS'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_MAX_ITER_OUTER_LOOP = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations in the outer loop. Use the outer loop to update the
        preconditioner and reset the conjugator. This can speed up convergence
        significantly.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.MAX_ITER_OUTER_LOOP'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Select a preconditioner for the conjugate gradient optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG.PRECONDITIONER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG(MSection):
    '''
    Controls the PCG optimization of extended ALMOs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_CONJUGATOR = Quantity(
        type=str,
        shape=[],
        description='''
        Various methods to compute step directions in the PCG optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.CONJUGATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_EPS_ERROR = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the MAX norm of the error
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.EPS_ERROR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_LIN_SEARCH_EPS_ERROR = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the gradient norm during the linear search
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.LIN_SEARCH_EPS_ERROR'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_LIN_SEARCH_STEP_SIZE_GUESS = Quantity(
        type=str,
        shape=[],
        description='''
        The size of the first step in the linear search
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.LIN_SEARCH_STEP_SIZE_GUESS'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_MAX_ITER_OUTER_LOOP = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations in the outer loop. Use the outer loop to update the
        preconditioner and reset the conjugator. This can speed up convergence
        significantly.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.MAX_ITER_OUTER_LOOP'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Select a preconditioner for the conjugate gradient optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG.PRECONDITIONER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF(MSection):
    '''
    Settings for a class of efficient linear scaling methods based on absolutely localized
    orbitals (ALMOs). ALMO methods are currently restricted to closed-shell molecular
    systems.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the algorithm to update block-diagonal ALMOs during the SCF procedure.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_SCF_GUESS = Quantity(
        type=str,
        shape=[],
        description='''
        The method to generate initial ALMOs.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_SCF_GUESS'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_DELOCALIZE_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Methods to reintroduce electron delocalization, which is excluded with the block-
        diagonal ALMO reference. Electron delocalization can be computed using either
        fully delocalized MOs or spatially restricted ALMOs (called extended ALMOs or
        XALMOs). All methods below use a PCG optimizer controlled by XALMO_OPTIMIZER_PCG.
        The only exception is the non-iterative XALMO_1DIAG.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.DELOCALIZE_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold for the matrix sparsity filter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.EPS_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_R_CUTOFF_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the localization radius of XALMOs: R_cutoff =
        XALMO_R_CUTOFF_FACTOR*(radius(at1)+radius(at2))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_R_CUTOFF_FACTOR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_DIIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_DIIS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_ALMO_OPTIMIZER_PCG'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.ALMO_OPTIMIZER_PCG'))

    x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF_XALMO_OPTIMIZER_PCG'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF.XALMO_OPTIMIZER_PCG'))


class x_cp2k_section_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD(MSection):
    '''
    Parameters needed for the ADMM method.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_ADMM_PURIFICATION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method that shall be used for wavefunction fitting. Use MO_DIAG for MD.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.ADMM_PURIFICATION_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_BLOCK_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies a list of atoms.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.BLOCK_LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Define accuracy of DBCSR operations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.EPS_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_EXCH_CORRECTION_FUNC = Quantity(
        type=str,
        shape=[],
        description='''
        Exchange functional which is used for the ADMM correction.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.EXCH_CORRECTION_FUNC'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_EXCH_SCALING_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the exchange correction calculated by the auxiliary density matrix.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.EXCH_SCALING_MODEL'))

    x_cp2k_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method that shall be used for wavefunction fitting. Use BASIS_PROJECTION for MD.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD.METHOD'))


class x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing of basic information during the run
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_CONDITION_NUMBER = Quantity(
        type=str,
        shape=[],
        description='''
        Prints information regarding the condition numbers of the A matrix (to be
        inverted)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.CONDITION_NUMBER'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING(MSection):
    '''
    Setup parameters for density fitting (Bloechl charges or density derived  atomic point
    charges (DDAPC) charges)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.DENSITY_FITTING'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_GCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff for charge fit in G-space.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.GCUT'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_MIN_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the smallest radius of the gaussian used in the fit. All other radius
        are obtained with the progression factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.MIN_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_NUM_GAUSS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the numbers of gaussian used to fit the QM density for each atomic site.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.NUM_GAUSS'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_PFACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the progression factor for the gaussian exponent for each atomic site.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.PFACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_DENSITY_FITTING_RADII = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies all the radius of the gaussian used in the fit for each atomic site. The
        use of this keyword disables all other keywords of this section.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.DENSITY_FITTING.RADII'))

    x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.DENSITY_FITTING.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_CONSTANT_ENV(MSection):
    '''
    parameters for a constant envelop
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.CONSTANT_ENV'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_CONSTANT_ENV_END_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        Last step the field is applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.CONSTANT_ENV.END_STEP'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_CONSTANT_ENV_START_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        First step the field is applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.CONSTANT_ENV.START_STEP'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_GAUSSIAN_ENV(MSection):
    '''
    parameters for a gaussian envelop
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.GAUSSIAN_ENV'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_GAUSSIAN_ENV_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Width of the gaussian
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.GAUSSIAN_ENV.SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_GAUSSIAN_ENV_T0 = Quantity(
        type=str,
        shape=[],
        description='''
        Center of the gaussian envelop (maximum of the gaussian)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.GAUSSIAN_ENV.T0'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV(MSection):
    '''
    Parameters for an trapeziodal envelop
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV_END_STEP_IN = Quantity(
        type=str,
        shape=[],
        description='''
        Step when the field reaches the full strength
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV.END_STEP_IN'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV_END_STEP_OUT = Quantity(
        type=str,
        shape=[],
        description='''
        Step when the field disappears
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV.END_STEP_OUT'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV_START_STEP_IN = Quantity(
        type=str,
        shape=[],
        description='''
        Step when the electric field starts to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV.START_STEP_IN'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV_START_STEP_OUT = Quantity(
        type=str,
        shape=[],
        description='''
        Step when the field starts to vanish
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV.START_STEP_OUT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD(MSection):
    '''
    parameters for finite, time dependent, nonperiodic electric fields
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_ENVELOP = Quantity(
        type=str,
        shape=[],
        description='''
        Shape of the efield pulse
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.ENVELOP'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_INTENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Intensity of the electric field in W*cm-2 which corresponds to a maximal amplitude
        in a.u. of sqrt(I/(3.50944*10^16))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.INTENSITY'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_PHASE = Quantity(
        type=str,
        shape=[],
        description='''
        phase offset of the cosine given in multiples of pi
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.PHASE'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_POLARISATION = Quantity(
        type=str,
        shape=[],
        description='''
        Polarisation vector of electric field
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.POLARISATION'))

    x_cp2k_input_FORCE_EVAL_DFT_EFIELD_WAVELENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        Wavelength of efield field
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EFIELD.WAVELENGTH'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_CONSTANT_ENV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_CONSTANT_ENV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.CONSTANT_ENV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_GAUSSIAN_ENV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_GAUSSIAN_ENV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.GAUSSIAN_ENV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD_RAMP_ENV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD.RAMP_ENV'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY(MSection):
    '''
    Section for the use of the ZMP technique on external densities.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY_FERMI_AMALDI = Quantity(
        type=str,
        shape=[],
        description='''
        Add the Fermi-Amaldi contribution to the Hartree potential.It leads to a more
        stable convergence.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY.FERMI_AMALDI'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY_FILE_DENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename containing the target density in *.cube format.In the MGRID
        section it must be imposed NGRID 1, as it works with onlyone grid. The number of
        points in each direction, and the spacing mustbe previously defined choosing the
        plane waves cut-off in section MGRIDkeyword CUTOFF, and the cube dimention in
        section SUBSYS / CELL / keyword ABC
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY.FILE_DENSITY'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Lagrange multiplier defined in the constraint ZMP method. When starting, usesmall
        values when starting from scratch (around 5,10). Then gradually increasethe values
        depending, restarting from the previous calculation with the smallervalue. To
        choose the progressive values of LAMBDA look at the convergence of the
        eigenvalues.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY_ZMP_CONSTRAINT = Quantity(
        type=str,
        shape=[],
        description='''
        Specify which kind of constraint to solve the ZMP equation. The COULOMB
        defaultoption is more stable.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY.ZMP_CONSTRAINT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL(MSection):
    '''
    Section controlling the presence of an electrostatic external potential dependent on
    the atomic positions (X,Y,Z)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_DX = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter used for computing the derivative with the Ridders method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.DX'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_ERROR_LIMIT = Quantity(
        type=str,
        shape=[],
        description='''
        Checks that the error in computing the derivative is not larger than the value
        set. In case prints a warning message.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.ERROR_LIMIT'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_FUNCTION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form in mathematical notation. Variables must be the
        atomic coordinates (X,Y,Z) of the grid.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.FUNCTION'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameters of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_READ_FROM_CUBE = Quantity(
        type=str,
        shape=[],
        description='''
        Switch for reading the external potential from file pot.cube. The values of the
        potential must be on the grid points of the realspace grid.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.READ_FROM_CUBE'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_SCALING_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        A factor for scaling the the external potential that is read from file.The value
        of the potential at each grid point is multiplied by this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.SCALING_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_STATIC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the external potential as STATIC or time dependent. At the moment only
        static potentials are implemented.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.STATIC'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_UNITS = Quantity(
        type=str,
        shape=[],
        description='''
        Optionally, allows to define valid CP2K unit strings for each parameter value. It
        is assumed that the corresponding parameter value is specified in this unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.UNITS'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL_VALUES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the values of parameter of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL.VALUES'))


class x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_VXC(MSection):
    '''
    SCF convergence with external v_xc calculated through previous ZMPcalculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_VXC'))

    x_cp2k_input_FORCE_EVAL_DFT_EXTERNAL_VXC_FILE_VXC = Quantity(
        type=str,
        shape=[],
        description='''
        The *.cube filename containing the v_xc potential. This works onlywith NGRID 1
        imposed in the MGRID section. The number of points in eachdirection, and the
        spacing must equal to those previously used in the ZMPcalculation and defined
        through the plane wave cut-off and the cube dimensionrespectively set in section
        MGRID / keyword CUTOFF, and in section SUBSYS /CELL / keyword ABC
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXTERNAL_VXC.FILE_VXC'))


class x_cp2k_section_input_FORCE_EVAL_DFT_KG_METHOD(MSection):
    '''
    Specifies the parameters for a Kim-Gordon-like partitioning into molecular subunits
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.KG_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_KG_METHOD_COLORING_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Which algorithm to use for coloring.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KG_METHOD.COLORING_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_KG_METHOD_TNADD_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to use for the calculation of the nonadditive kinetic energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KG_METHOD.TNADD_METHOD'))


class x_cp2k_section_input_FORCE_EVAL_DFT_KPOINTS(MSection):
    '''
    Sets up the kpoints.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.KPOINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_EPS_GEO = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy in symmetry determination.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.EPS_GEO'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_FULL_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Use full non-reduced kpoint grid.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.FULL_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_KPOINT = Quantity(
        type=str,
        shape=[],
        description='''
        Specify kpoint coordinates and weight.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.KPOINT'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_PARALLEL_GROUP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Number of processors to be used for a single kpoint. Value=-1 (minimum number of
        processes). Value=0 (maximum number of processes). Value=n (exactly n processes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.PARALLEL_GROUP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_SCHEME = Quantity(
        type=str,
        shape=[],
        description='''
        Kpoint scheme to be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.SCHEME'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_SYMMETRY = Quantity(
        type=str,
        shape=[],
        description='''
        Use symmetry to reduce the number of kpoints.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.SYMMETRY'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_VERBOSE = Quantity(
        type=str,
        shape=[],
        description='''
        Verbose output information.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.VERBOSE'))

    x_cp2k_input_FORCE_EVAL_DFT_KPOINTS_WAVEFUNCTIONS = Quantity(
        type=str,
        shape=[],
        description='''
        Use real/complex wavefunctions if possible.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.KPOINTS.WAVEFUNCTIONS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LOCALIZE(MSection):
    '''
    Use one of the available methods to define the localization  and possibly to optimize
    it to a minimum or a maximum.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LOCALIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_CRAZY_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scale angles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.CRAZY_SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_CRAZY_USE_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Use diagonalization (slow) or pade based calculation of matrix exponentials.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.CRAZY_USE_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_ENERGY_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Select the orbitals to be localized within the given energy range.This type of
        selection cannot be added on top of the selection through a LIST. It reads to
        reals that are lower and higher boundaries of the energy range.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.ENERGY_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_EPS_LOCALIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance used in the convergence criterium of the localization methods.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.EPS_LOCALIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_EPS_OCCUPATION = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance in the occupation number to select only fully occupied orbitals for the
        rotation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.EPS_OCCUPATION'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_JACOBI_FALLBACK = Quantity(
        type=str,
        shape=[],
        description='''
        Use Jacobi method in case no convergence was achieved by using the crazy rotations
        method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.JACOBI_FALLBACK'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_LIST_UNOCCUPIED = Quantity(
        type=str,
        shape=[],
        description='''
        Indexes of the unoccupied states to be localized, up to now only valid in
        combination with GPW. This keyword has to be present if unoccupied states should
        be localized. This keyword can be repeated several times(useful if you have to
        specify many indexes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.LIST_UNOCCUPIED'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Indexes of the occupied wfn to be localizedThis keyword can be repeated several
        times(useful if you have to specify many indexes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_LOCHOMO_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        File name where to read the MOS fromwhich to restart the localization procedure
        for occupied states
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.LOCHOMO_RESTART_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_LOCLUMO_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        File name where to read the MOS fromwhich to restart the localization procedure
        for unoccupied states
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.LOCLUMO_RESTART_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_MAX_CRAZY_ANGLE = Quantity(
        type=str,
        shape=[],
        description='''
        Largest allowed angle for the crazy rotations algorithm (smaller is slower but
        more stable).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.MAX_CRAZY_ANGLE'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations used for localization methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method of optimization if any
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_MIN_OR_MAX = Quantity(
        type=str,
        shape=[],
        description='''
        Requires the maximization of the spread of the wfn
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.MIN_OR_MAX'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_OPERATOR = Quantity(
        type=str,
        shape=[],
        description='''
        Type of opertator which defines the spread functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.OPERATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_OUT_ITER_EACH = Quantity(
        type=str,
        shape=[],
        description='''
        Every how many iterations of the localization algorithm(Jacobi) the tolerance
        value is printed out
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.OUT_ITER_EACH'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        Restart the localization from a set of orbitals read from a localization restart
        file.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.RESTART'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the MOS localization procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_STATES = Quantity(
        type=str,
        shape=[],
        description='''
        Which states to localize, LUMO up to now only available in GPW
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.STATES'))

    x_cp2k_input_FORCE_EVAL_DFT_LOCALIZE_USE_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Generate an improved initial guess based on a history of results, which is useful
        during MD.Will only work if the number of states to be localized remains constant.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOCALIZE.USE_HISTORY'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LOW_SPIN_ROKS(MSection):
    '''
    Specify the details of the low spin ROKS method.In particular, one can specify various
    terms added to the energy of the high spin roks configuration with a energy scaling
    factor, and a prescription of the spin state.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LOW_SPIN_ROKS'))

    x_cp2k_input_FORCE_EVAL_DFT_LOW_SPIN_ROKS_ENERGY_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        The scaling factors for each term added to the total energy.This list should
        contain one number for each term added to the total energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOW_SPIN_ROKS.ENERGY_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_LOW_SPIN_ROKS_SPIN_CONFIGURATION = Quantity(
        type=str,
        shape=[],
        description='''
        for each singly occupied orbital, specify if this should be an alpha (=1) or a
        beta (=2) orbitalThis keyword should be repeated, each repetition corresponding to
        an additional term.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LOW_SPIN_ROKS.SPIN_CONFIGURATION'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS(MSection):
    '''
    Controls the printing of the Density of States (DOS).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_N_GRIDPOINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of points in the computed DOS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.N_GRIDPOINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE(MSection):
    '''
    Controls the printing of cube files with the electronic density (states) contributing
    to the density of states within the specific energy range (MIN_ENERGY ≤ E ≤
    MAX_ENERGY). MIN_ENERGY and MAX_ENERGY need to be specified explicitly.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_MAX_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Upper bounds of the energy ranges of interest.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.MAX_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_MIN_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Lower bounds of the energy ranges of interest.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.MIN_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE_STRIDE = Quantity(
        type=str,
        shape=[],
        description='''
        The stride (X,Y,Z) used to write the cube file (larger values result in smaller
        cube files). You can provide 3 numbers (for X,Y,Z) or 1 number valid for all
        components.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE.STRIDE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV(MSection):
    '''
    Specifies the parameters needed for the chebyshev expansion based properties.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_N_CHEBYSHEV = Quantity(
        type=str,
        shape=[],
        description='''
        Order of the polynomial expansion.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.N_CHEBYSHEV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_DOS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.DOS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV_PRINT_SPECIFIC_E_DENSITY_CUBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV.PRINT_SPECIFIC_E_DENSITY_CUBE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS(MSection):
    '''
    Specifies the parameters of the linear scaling SCF routines
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_FILTER_FACTOR_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Allows for dynamic EPS_FILTER. Updates the filter factor every scf-newton step by
        FILTER_FACTOR=FILTER_FACTOR*FILTER_FACTOR_SCALE
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.FILTER_FACTOR_SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_FILTER_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Allows to set a seperate EPS_FILTER in the newton iterations. The new EPS is
        EPS_FILTER*FILTER_FACTOR.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.FILTER_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_LINE_SEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        Line serch type used in the curvy_setp optimization.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.LINE_SEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_MIN_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Lowest EPS_FILTER in dynamic filtering. Given as multiple of EPS_FILTER:
        EPS_FILTER_MIN=EPS_FILTER*MIN_FILTER
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.MIN_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_MIN_HESSIAN_SHIFT = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal eigenvalue shift for the Hessian in the Newton iteration. Useful for small
        band gap systems (0.5-1.0 recommended).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.MIN_HESSIAN_SHIFT'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS_N_BCH_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Number of stored matrices in the Baker-Campbell-Hausdorff series. Reduces the BCH
        evaluation during line search but can be memory intense.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS.N_BCH_HISTORY'))


class x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF(MSection):
    '''
    Specifies the parameters of the linear scaling SCF routines
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_DYNAMIC_THRESHOLD = Quantity(
        type=str,
        shape=[],
        description='''
        Should the threshold for the purification be chosen dynamically
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.DYNAMIC_THRESHOLD'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_EPS_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold on the convergence to start using DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.EPS_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold used for filtering matrix operations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.EPS_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_EPS_LANCZOS = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold used for lanczos estimates.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.EPS_LANCZOS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy for the scf convergence. Change of the total energy per electron
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_EXTRAPOLATION_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of previous matrices used for the ASPC extrapolation of the initial guess.
        0 implies that an atomic guess is used at each step. low (1-2) will result in a
        drift of the constant of motion during MD. high (>5) might be somewhat unstable,
        leading to more SCF iterations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.EXTRAPOLATION_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_FIXED_MU = Quantity(
        type=str,
        shape=[],
        description='''
        Should the calculation be performed at fixed chemical potential, or should it be
        found fixing the number of electrons
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.FIXED_MU'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_INI_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration cycle to start DIIS Kohn-Sham matrix update
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.INI_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_LS_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Perform DIIS within linear scaling SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.LS_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MATRIX_CLUSTER_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify how atomic blocks should be clustered in the used matrices, in order to
        improve flop rate, and possibly speedup the matrix multiply. Note that the atomic
        s_preconditioner can not be used.Furthermore, since screening is on matrix blocks,
        slightly more accurate results can be expected with molecular.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MATRIX_CLUSTER_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MAX_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Size of LS_DIIS buffer
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MAX_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MAX_ITER_LANCZOS = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of lanczos iterations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MAX_ITER_LANCZOS'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MAX_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCF iteration to be performed for one optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MAX_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MIXING_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing density matrices uses the specified fraction in the SCF procedure.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MIXING_FRACTION'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_MU = Quantity(
        type=str,
        shape=[],
        description='''
        Value (or initial guess) for the chemical potential, i.e. some suitable energy
        between HOMO and LUMO energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.MU'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_NMIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal number of density mixing before start DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.NMIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_NON_MONOTONIC = Quantity(
        type=str,
        shape=[],
        description='''
        Should the purification be performed non-monotonically. Relevant for TC2 only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.NON_MONOTONIC'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_PERFORM_MU_SCAN = Quantity(
        type=str,
        shape=[],
        description='''
        Do a scan of the chemical potential after the SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.PERFORM_MU_SCAN'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_PURIFICATION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Scheme used to purify the Kohn-Sham matrix into the density matrix.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.PURIFICATION_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_REPORT_ALL_SPARSITIES = Quantity(
        type=str,
        shape=[],
        description='''
        Run the sparsity report at the end of the SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.REPORT_ALL_SPARSITIES'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_RESTART_READ = Quantity(
        type=str,
        shape=[],
        description='''
        Read the density matrix before the (first) SCF.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.RESTART_READ'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_RESTART_WRITE = Quantity(
        type=str,
        shape=[],
        description='''
        Write the density matrix at the end of the SCF (currently requires
        EXTRAPOLATION_ORDER>0). Files might be rather large.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.RESTART_WRITE'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_S_INVERSION = Quantity(
        type=str,
        shape=[],
        description='''
        Method used to compute the inverse of S.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.S_INVERSION'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_S_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Preconditions S with some appropriate form.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.S_PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_SIGN_SQRT_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Order of the sqrt iteration, should be 2..5, 3 or 5 recommended
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.SIGN_SQRT_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_LS_SCF_SINGLE_PRECISION_MATRICES = Quantity(
        type=str,
        shape=[],
        description='''
        Matrices used within the LS code can be either double or single precision.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.LS_SCF.SINGLE_PRECISION_MATRICES'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CHEBYSHEV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CHEBYSHEV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF_CURVY_STEPS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF.CURVY_STEPS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO(MSection):
    '''
    if convergence information about the linear solver of the spline methods should be
    printed
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR(MSection):
    '''
    kind of interpolation used between the multigrids
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_AINT_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        the approximate inverse to use to get the starting point for the linear solver of
        the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.AINT_PRECOND'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_EPS_R = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the residual for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.EPS_R'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_EPS_X = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the solution for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.EPS_X'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        the interpolator to use
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.KIND'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        the maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        The preconditioner used for the linear solver of the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.PRECOND'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_SAFE_COMPUTATION = Quantity(
        type=str,
        shape=[],
        description='''
        if a non unrolled calculation is to be performed in parallel
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.SAFE_COMPUTATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR_CONV_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR.CONV_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_RS_GRID(MSection):
    '''
    Set options that influence how the realspace grids are being distributed in parallel
    runs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.RS_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_DISTRIBUTION_LAYOUT = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of slices in the x, y and z directions.-1 specifies that any
        number of slices is OK.If a given distribution can not be satisfied, a replicated
        grid will result.Also see LOCK_DISTRIBUTION.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.DISTRIBUTION_LAYOUT'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_DISTRIBUTION_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Parallelization strategy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.DISTRIBUTION_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_HALO_REDUCTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Can be used to reduce the halo of the distributed grid (experimental features).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.HALO_REDUCTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_LOCK_DISTRIBUTION = Quantity(
        type=str,
        shape=[],
        description='''
        Expert use only, only basic QS deals correctly with a non-default value.If the
        distribution is locked, a grid will have the same distribution asthe next finer
        multigrid (provided it is distributed).If unlocked, all grids can be distributed
        freely.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.LOCK_DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_MAX_DISTRIBUTED_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        If the multigrid-level of a grid is larger than the parameter, it will not be
        distributed in the automatic scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.MAX_DISTRIBUTED_LEVEL'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_RS_GRID_MEMORY_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        A grid will only be distributed if the memory usage for that grid (including halo)
        is smaller than a replicated grid by this parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.RS_GRID.MEMORY_FACTOR'))


class x_cp2k_section_input_FORCE_EVAL_DFT_MGRID(MSection):
    '''
    multigrid information
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_COMMENSURATE = Quantity(
        type=str,
        shape=[],
        description='''
        If the grids should be commensurate. If true overrides the progression factor and
        the cutoffs of the sub grids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.COMMENSURATE'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the finest grid level. Default value for SE or DFTB calculation is
        1.0 [Ry].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_MULTIGRID_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        List of cutoff values to set up multigrids manually
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.MULTIGRID_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_MULTIGRID_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Activate a manual setting of the multigrids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.MULTIGRID_SET'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_NGRIDS = Quantity(
        type=str,
        shape=[],
        description='''
        The number of multigrids to use
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.NGRIDS'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_PROGRESSION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Factor used to find the cutoff of the multigrids that where not given explicitly
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.PROGRESSION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_REALSPACE = Quantity(
        type=str,
        shape=[],
        description='''
        If both rho and rho_gspace are needed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.REALSPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the grid at which a Gaussian is mapped, giving the cutoff used for a
        gaussian with alpha=1. A value 50+-10Ry might be required for highly accurate
        results,  Or for simulations with a variable cell. Versions prior to 2.3 used a
        default of 30Ry.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.REL_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_MGRID_SKIP_LOAD_BALANCE_DISTRIBUTED = Quantity(
        type=str,
        shape=[],
        description='''
        Skip load balancing on distributed multigrids, which might be memory intensive.If
        not explicitly specified, runs using more than 1024 MPI tasks will default to
        .TRUE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MGRID.SKIP_LOAD_BALANCE_DISTRIBUTED'))

    x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_INTERPOLATOR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.INTERPOLATOR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_RS_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_MGRID_RS_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID.RS_GRID'))


class x_cp2k_section_input_FORCE_EVAL_DFT_PERIODIC_EFIELD(MSection):
    '''
    parameters for finite periodic electric field computed using the Berry phase approach.
    IMPORTANT: Can only be used in combination  with OT. Can not be used in combination
    with RTP or EMD.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.PERIODIC_EFIELD'))

    x_cp2k_input_FORCE_EVAL_DFT_PERIODIC_EFIELD_INTENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Intensity of the electric field in a.u
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.PERIODIC_EFIELD.INTENSITY'))

    x_cp2k_input_FORCE_EVAL_DFT_PERIODIC_EFIELD_POLARISATION = Quantity(
        type=str,
        shape=[],
        description='''
        Polarisation vector of electric field
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.PERIODIC_EFIELD.POLARISATION'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES(MSection):
    '''
    Enables the use of multipoles in the treatment of the electrostatics.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES_EPS_POL = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the rmsd threshold for the derivatives of the energy towards the Cartesian
        dipoles components
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES.EPS_POL'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES_MAX_IPOL_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum number of iterations for induced dipoles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES.MAX_IPOL_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES_MAX_MULTIPOLE_EXPANSION = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum level of multipoles expansion used  for the electrostatics.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES.MAX_MULTIPOLE_EXPANSION'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES_POL_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the method to obtain self consistent induced multipole moments.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES.POL_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the Multipoles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID(MSection):
    '''
    Set options that influence how the realspace grids are being distributed in parallel
    runs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_DISTRIBUTION_LAYOUT = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of slices in the x, y and z directions.-1 specifies that any
        number of slices is OK.If a given distribution can not be satisfied, a replicated
        grid will result.Also see LOCK_DISTRIBUTION.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.DISTRIBUTION_LAYOUT'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_DISTRIBUTION_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Parallelization strategy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.DISTRIBUTION_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_HALO_REDUCTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Can be used to reduce the halo of the distributed grid (experimental features).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.HALO_REDUCTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_LOCK_DISTRIBUTION = Quantity(
        type=str,
        shape=[],
        description='''
        Expert use only, only basic QS deals correctly with a non-default value.If the
        distribution is locked, a grid will have the same distribution asthe next finer
        multigrid (provided it is distributed).If unlocked, all grids can be distributed
        freely.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.LOCK_DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_MAX_DISTRIBUTED_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        If the multigrid-level of a grid is larger than the parameter, it will not be
        distributed in the automatic scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.MAX_DISTRIBUTED_LEVEL'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID_MEMORY_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        A grid will only be distributed if the memory usage for that grid (including halo)
        is smaller than a replicated grid by this parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID.MEMORY_FACTOR'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD(MSection):
    '''
    Ewald parameters controlling electrostatic only for CLASSICAL MM.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        alpha parameter associated with Ewald (EWALD|PME|SPME). Recommended for small
        systems is is alpha = 3.5 / r_cut. Tuning alpha, r_cut and gmax is needed to
        obtain O(N**1.5) scaling for ewald.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_EPSILON = Quantity(
        type=str,
        shape=[],
        description='''
        tolerance of gaussians for fft interpolation (PME only)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.EPSILON'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_EWALD_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Expected accuracy in the Ewald sum. This number affects only the calculation of
        the cutoff for the real-space term of the ewald summation (EWALD|PME|SPME) as well
        as the construction of the neighbor lists (if the cutoff for non-bonded terms is
        smaller than the value employed to compute the EWALD real-space term). This
        keyword has no effect on the reciprocal space term (which can be tuned
        independently).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.EWALD_ACCURACY'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_EWALD_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        The type of ewald you want to perform.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.EWALD_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_GMAX = Quantity(
        type=str,
        shape=[],
        description='''
        number of grid points (SPME and EWALD). If a single number is specified,the same
        number of points is used for all three directions on the grid.If three numbers are
        given, each direction can have a different number of points.The number of points
        needs to be FFTable (which depends on the library used) and odd for EWALD.The
        optimal number depends e.g. on alpha and the size of the cell. 1 point per
        Angstrom is common.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.GMAX'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_NS_MAX = Quantity(
        type=str,
        shape=[],
        description='''
        number of grid points on small mesh (PME only), should be odd.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.NS_MAX'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_O_SPLINE = Quantity(
        type=str,
        shape=[],
        description='''
        order of the beta-Euler spline (SPME only)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.O_SPLINE'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_EWALD_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Explicitly provide the real-space cutoff of the ewald summation (EWALD|PME|SPME).
        If present, overwrites the estimate of EWALD_ACCURACY and may affect the
        construction of the neighbor lists for non-bonded terms (in FIST), if the value
        specified is larger than the cutoff for non-bonded interactions.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.EWALD.RCUT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_MULTIPOLES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD.MULTIPOLES'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD_RS_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD.RS_GRID'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MT(MSection):
    '''
    Sets up parameters of  Martyna-Tuckerman poisson solver. Note that exact results are
    only guaranteed if the unit cell is twice as large as charge density (and serious
    artefacts can result if the cell is much smaller).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MT'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MT_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence parameter ALPHA*RMIN. Default value 7.0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MT.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MT_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the multiplicative factor for the CUTOFF keyword in MULTI_GRID  section.
        The result gives the cutoff at which the 1/r non-periodic FFT3D is
        evaluated.Default is 2.0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MT.REL_CUTOFF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE(MSection):
    '''
    Controls the checking of the G-space term Spline Interpolation.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO(MSection):
    '''
    if convergence information about the linear solver of the spline methods should be
    printed
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR(MSection):
    '''
    controls the interpolation for the G-space term
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_AINT_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        the approximate inverse to use to get the starting point for the linear solver of
        the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.AINT_PRECOND'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_EPS_R = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the residual for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.EPS_R'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_EPS_X = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the solution for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.EPS_X'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        the maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        The preconditioner used for the linear solver of the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.PRECOND'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing of basic information during the run
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE(MSection):
    '''
    This section is used to set up the decoupling of QM periodic images with the use of
    density derived atomic point charges.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_ANALYTICAL_GTERM = Quantity(
        type=str,
        shape=[],
        description='''
        Evaluates the Gterm in the Ewald Scheme analytically instead of using Splines.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.ANALYTICAL_GTERM'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_EWALD_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Precision achieved in the Ewald sum.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.EWALD_PRECISION'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_NGRIDS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of grid points used for the Interpolation of the G-space term
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.NGRIDS'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Real space cutoff for the Ewald sum.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.RCUT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_CHECK_SPLINE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.CHECK_SPLINE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_INTERPOLATOR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.INTERPOLATOR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_WAVELET(MSection):
    '''
    Sets up parameters of  wavelet based poisson solver.This solver allows for non-
    periodic (PERIODIC NONE) boundary conditions and slab-boundary conditions (but only
    PERIODIC XZ).It does not require very large unit cells, only that the density goes to
    zero on the faces of the cell.The use of PREFERRED_FFT_LIBRARY FFTSG is required
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.WAVELET'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_WAVELET_SCF_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of scaling function used in the wavelet approach, the total energy depends on
        this choice,and the convergence with respect to cutoff depends on the selected
        scaling functions.Possible values are 8,14,16,20,24,30,40,50,60,100
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.WAVELET.SCF_TYPE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_POISSON(MSection):
    '''
    Sets up the poisson resolutor.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_PERIODIC = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the directions on wich apply PBC. Important notice,  this only applies to
        the electrostatics. See the CELL section to specify the periodicity used for e.g.
        the pair lists. Typically the settings should be the same.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_POISSON_POISSON_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Specify which kind of solver to use to solve the Poisson equation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POISSON.POISSON_SOLVER'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_EWALD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.EWALD'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_MULTIPOLE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.MULTIPOLE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_WAVELET = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON_WAVELET'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON.WAVELET'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing basic info about the method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT(MSection):
    '''
    Use Becke weight population in a restraint/constraint
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the list of atoms that is summed in the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_COEFF = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the the coefficient of the atom in the atom list (default is one)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.COEFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_FUNCTIONAL_FORM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form of the term added
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.FUNCTIONAL_FORM'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        force constant of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        target value of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_TYPE_OF_DENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the type of density used for the fitting
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.TYPE_OF_DENSITY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing basic info about the method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT(MSection):
    '''
    Use DDAPC charges in a restraint (check code for details)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the list of atoms that is summed in the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_COEFF = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the the coefficient of the atom in the atom list (default is one)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.COEFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_FUNCTIONAL_FORM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form of the term added
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.FUNCTIONAL_FORM'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        force constant of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        target value of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_TYPE_OF_DENSITY = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the type of density used for the fitting
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.TYPE_OF_DENSITY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER(MSection):
    '''
    Information on where to find DFTB parameters
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_COORDINATION_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Define cutoff for coordination number calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.COORDINATION_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling parameters (s6,sr6,s8) for the D3 dispersion method,
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.D3_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_DISPERSION_PARAMETER_FILE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify file that contains the atomic dispersion parameters for the D3 method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.DISPERSION_PARAMETER_FILE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_DISPERSION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Define radius of dispersion interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.DISPERSION_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_DISPERSION_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Use dispersion correction of the specified type. Dispersion correction has to be
        switched on in the DFTB section.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.DISPERSION_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_HB_SR_PARAM = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a modified version for the GAMMA within the SCC-DFTB scheme, specifically
        tuned for hydrogen bonds. Specify the exponent used in the exponential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.HB_SR_PARAM'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_PARAM_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specify file that contains the names of Slater-Koster tables: A plain text file,
        each line has the format "ATOM1 ATOM2 filename.spl".
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.PARAM_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_PARAM_FILE_PATH = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the directory with the DFTB parameter files. Used in combination with the
        filenames specified in the file given in PARAM_FILE_NAME.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.PARAM_FILE_PATH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_SK_FILE = Quantity(
        type=str,
        shape=[],
        description='''
        Define parameter file for atom pair
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.SK_FILE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER_UFF_FORCE_FIELD = Quantity(
        type=str,
        shape=[],
        description='''
        Name of file with UFF parameters that will be used for the dispersion correction.
        Needs to be specified when DISPERSION==.TRUE., otherwise cp2k crashes with a
        Segmentation Fault.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER.UFF_FORCE_FIELD'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB(MSection):
    '''
    Parameters needed to set up the DFTB methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DFTB'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_DIAGONAL_DFTB3 = Quantity(
        type=str,
        shape=[],
        description='''
        Use a diagonal version of the 3rd order energy correction (DFTB3)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.DIAGONAL_DFTB3'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_DISPERSION = Quantity(
        type=str,
        shape=[],
        description='''
        Use dispersion correction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.DISPERSION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_DO_EWALD = Quantity(
        type=str,
        shape=[],
        description='''
        Use Ewald type method instead of direct sum for Coulomb interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.DO_EWALD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_EPS_DISP = Quantity(
        type=str,
        shape=[],
        description='''
        Define accuracy of dispersion interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.EPS_DISP'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_HB_SR_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a modified version for the GAMMA within the SCC-DFTB scheme, specifically
        tuned for hydrogen bonds.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.HB_SR_GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_ORTHOGONAL_BASIS = Quantity(
        type=str,
        shape=[],
        description='''
        Assume orthogonal basis set
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.ORTHOGONAL_BASIS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DFTB_SELF_CONSISTENT = Quantity(
        type=str,
        shape=[],
        description='''
        Use self-consistent method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DFTB.SELF_CONSISTENT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB_PARAMETER'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DFTB.PARAMETER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_DISTRIBUTION(MSection):
    '''
    can be used used to tune the parallel distribution of the data
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_2D_MOLECULAR_DISTRIBUTION = Quantity(
        type=str,
        shape=[],
        description='''
        Distribute the atoms so that atoms belonging to a given molecule are on the same
        CPU for the 2D distribution. This might give rise to a worse distribution but
        reduces memory needs of finding the optimal distribution.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.2D_MOLECULAR_DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_BASIC_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Creates a distribution based on a few heuristics using only minimal memory and CPU
        time.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.BASIC_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_BASIC_SPATIAL_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Creates a distribution with spatial info, using only minimal memory and CPU time.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.BASIC_SPATIAL_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_COST_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        The cost model that needs to be minimized
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.COST_MODEL'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_SKIP_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Do not optimize the distribution, go for something very simple. Might be useful if
        the optimization, which scales quadratically in system size, is too expensive.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.SKIP_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DISTRIBUTION_SYMMETRIC = Quantity(
        type=str,
        shape=[],
        description='''
        Take the symmetry of the distribution_2d into account.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DISTRIBUTION.SYMMETRIC'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_HARRIS(MSection):
    '''
    This section specifies the flags for the calculation of the harris functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.HARRIS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_HARRIS_ACTIVATE = Quantity(
        type=str,
        shape=[],
        description='''
        Activates the harris functional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.HARRIS.ACTIVATE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_HARRIS_HARRIS_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Overrides the QS Energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.HARRIS.HARRIS_ENERGY'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT(MSection):
    '''
    Use mulliken charges in a restraint (check code for details)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.MULLIKEN_RESTRAINT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the list of atoms that is summed in the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.MULLIKEN_RESTRAINT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        force constant of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.MULLIKEN_RESTRAINT.STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        target value of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.MULLIKEN_RESTRAINT.TARGET'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONSTRAIN_EXPONENTS(MSection):
    '''
    specifies constraints for the exponents of the lri auxiliary basis sets in the
    optimization.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.CONSTRAIN_EXPONENTS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONSTRAIN_EXPONENTS_FERMI_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Exponent in the fermi-like constraint function.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.CONSTRAIN_EXPONENTS.FERMI_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONSTRAIN_EXPONENTS_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper and lower boundaries as (1+scale)*exp and (1-scale)*exp. Fermi-
        like constraint function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.CONSTRAIN_EXPONENTS.SCALE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS(MSection):
    '''
    This section specifies the parameters for optimizing the lri auxiliary basis sets for
    LRIGPW. The Powell optimizer is used.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy for the objective function (RHOEND)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.ACCURACY'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONDITION_WEIGHT = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword allows to give different weight factors to the condition number
        (LOG(cond) is used).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.CONDITION_WEIGHT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_DEGREES_OF_FREEDOM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the degrees of freedom in the basis optimization.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.DEGREES_OF_FREEDOM'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_GEOMETRIC_SEQUENCE = Quantity(
        type=str,
        shape=[],
        description='''
        Exponents are assumed to be a geometric squence. Only the minimal and maximal
        exponents of one set are optimized and the other exponents are obtained by
        geometric progression.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.GEOMETRIC_SEQUENCE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_MAX_FUN = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of function evaluations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.MAX_FUN'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_STEP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial step size for search algorithm (RHOBEG)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.STEP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_USE_CONDITION_NUMBER = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether condition number should be part of optimization or not
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.USE_CONDITION_NUMBER'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONSTRAIN_EXPONENTS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS_CONSTRAIN_EXPONENTS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS.CONSTRAIN_EXPONENTS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT(MSection):
    '''
    Use S2 in a re/constraint (OT only)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.S2_RESTRAINT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT_FUNCTIONAL_FORM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form of the term added
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.S2_RESTRAINT.FUNCTIONAL_FORM'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        force constant of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.S2_RESTRAINT.STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        target value of the restraint
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.S2_RESTRAINT.TARGET'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SCPTB(MSection):
    '''
    Parameters needed to set up the SCPTB methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SCPTB'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_COORDINATION_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Define cutoff for coordination number calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.COORDINATION_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling parameters (s6,sr6,s8) for the D3 dispersion method,
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.D3_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DISPERSION_PARAMETER_FILE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify file that contains the atomic dispersion parameters
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DISPERSION_PARAMETER_FILE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DISPERSION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Define radius of dispersion interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DISPERSION_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DISPERSION = Quantity(
        type=str,
        shape=[],
        description='''
        Use dispersion correction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DISPERSION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DO_EWALD = Quantity(
        type=str,
        shape=[],
        description='''
        Use Ewald type method instead of direct sum for Coulomb interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DO_EWALD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DO_SCC = Quantity(
        type=str,
        shape=[],
        description='''
        Use self consistent charge method. Can be used together with DO_SCP to get TB
        method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DO_SCC'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_DO_SCP = Quantity(
        type=str,
        shape=[],
        description='''
        Use SCP method. Can be used to switch off SCP to get a SCC-DFTB method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.DO_SCP'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_PAIR_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Define cutoff for pair potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.PAIR_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_PARAMETER_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specify file that contains the atomic parameters
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.PARAMETER_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCPTB_STO_NG = Quantity(
        type=str,
        shape=[],
        description='''
        Provides the order of the Slater orbital expansion of Gaussian-Type Orbitals.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCPTB.STO_NG'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_COULOMB(MSection):
    '''
    Setup parameters for the evaluation of the COULOMB term in SE calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.COULOMB'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_COULOMB_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for the evaluation of the  Coulomb integrals. For non-
        periodic calculation the default value is exactly the full cell dimension, in
        order to evaluate all pair interactions. Instead, for periodic calculations the
        default numerical value is used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.COULOMB.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_COULOMB_RC_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Range of cutoff switch function (tapering): 0.5*(1-TANH((r-r0)/RC_RANGE)), where
        r0=2.0*RC_TAPER-20.0*RC_RANGE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.COULOMB.RC_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_COULOMB_RC_TAPER = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for Tapering Coulomb integrals. If not specified it
        assumes the same value specified for the CUTOFF.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.COULOMB.RC_TAPER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE(MSection):
    '''
    Setup parameters for the evaluation of the EXCHANGE and  core Hamiltonian terms in SE
    calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.EXCHANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for the evaluation of the Exchange integrals. For non-
        periodic calculation the default value is exactly the full cell dimension, in
        order to evaluate all pair interactions. Instead, for periodic calculations the
        default is the minimum value between 1/4 of the cell dimension and the value
        specified in input (either explicitly defined or the default numerical value).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.EXCHANGE.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE_RC_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Range of cutoff switch function (tapering): 0.5*(1-TANH((r-r0)/RC_RANGE)), where
        r0=2.0*RC_TAPER-20.0*RC_RANGE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.EXCHANGE.RC_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE_RC_TAPER = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for Tapering Exchange integrals. If not specified it
        assumes the same value specified for the CUTOFF.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.EXCHANGE.RC_TAPER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_GA(MSection):
    '''
    Sets up memory parameters for the storage of the integrals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.GA'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_GA_NCELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the number of linked cells for the neighbor list. Default value is number
        of processors
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.GA.NCELLS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION(MSection):
    '''
    Setup parameters for the evaluation of the long-range correction term in SE
    calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.LR_CORRECTION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for the evaluation of the long-ranbe correction
        integrals.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.LR_CORRECTION.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION_RC_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Range of cutoff switch function (tapering): 0.5*(1-TANH((r-r0)/RC_RANGE)), where
        r0=2.0*RC_TAPER-20.0*RC_RANGE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.LR_CORRECTION.RC_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION_RC_TAPER = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for Tapering the long-range correction integrals. If
        not specified it assumes the same value specified for the CUTOFF.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.LR_CORRECTION.RC_TAPER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the integrals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_MEMORY_COMPRESS = Quantity(
        type=str,
        shape=[],
        description='''
        Enables the compression of the integrals in memory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.MEMORY.COMPRESS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_MEMORY_EPS_STORAGE = Quantity(
        type=str,
        shape=[],
        description='''
        Storage threshold for compression is EPS_STORAGE
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.MEMORY.EPS_STORAGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] used to store precomputed (possibly
        compressed) two-electron two-center integrals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.MEMORY.MAX_MEMORY'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS(MSection):
    '''
    This section specifies the input parameters for the construction of neighbor lists.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.NEIGHBOR_LISTS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS_GEO_CHECK = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword enables the check that two atoms are never below the minimum value
        used to construct the splines during the construction of the neighbouring list.
        Disabling this keyword avoids CP2K to abort in case two atoms are below the
        minimum  value of the radius used to generate the splines.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.NEIGHBOR_LISTS.GEO_CHECK'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS_NEIGHBOR_LISTS_FROM_SCRATCH = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword enables the building of the neighbouring list from scratch.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.NEIGHBOR_LISTS.NEIGHBOR_LISTS_FROM_SCRATCH'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS_VERLET_SKIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the Verlet Skin for the generation of the neighbor lists
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.NEIGHBOR_LISTS.VERLET_SKIN'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_SCREENING(MSection):
    '''
    Setup parameters for the tapering of the Coulomb/Exchange Screening in KDSO-D integral
    scheme,
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_SCREENING_RC_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Range of cutoff switch function (tapering): 0.5*(1-TANH((r-r0)/RC_RANGE)), where
        r0=2*RC_TAPER-20*RC_RANGE.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.SCREENING.RC_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_SCREENING_RC_TAPER = Quantity(
        type=str,
        shape=[],
        description='''
        Atomic Cutoff Radius Cutoff for Tapering the screening term.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.SCREENING.RC_TAPER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE(MSection):
    '''
    Parameters needed to set up the Semi-empirical methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_ANALYTICAL_GRADIENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Nuclear Gradients are computed analytically or numerically
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.ANALYTICAL_GRADIENTS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_COORDINATION_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Define cutoff for coordination number calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.COORDINATION_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling parameters (s6,sr6,s8) for the D3 dispersion method,
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.D3_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_DELTA = Quantity(
        type=str,
        shape=[],
        description='''
        Step size in finite difference force calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.DELTA'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_DISPERSION_PARAMETER_FILE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify file that contains the atomic dispersion parameters
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.DISPERSION_PARAMETER_FILE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_DISPERSION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Define radius of dispersion interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.DISPERSION_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_DISPERSION = Quantity(
        type=str,
        shape=[],
        description='''
        Use dispersion correction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.DISPERSION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_FORCE_KDSO_D_EXCHANGE = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords forces the usage of the KDSO-D integral screening for the Exchange
        integrals (default is to apply the screening only to the Coulomb integrals.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.FORCE_KDSO-D_EXCHANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_INTEGRAL_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form for the
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.INTEGRAL_SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_ORTHOGONAL_BASIS = Quantity(
        type=str,
        shape=[],
        description='''
        Assume orthogonal basis set. This flag is overwritten by methods with fixed
        orthogonal/non-orthogonal basis set.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.ORTHOGONAL_BASIS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_PERIODIC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the type of treatment for the electrostatic long-range part in semi-
        empirical calculations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_SCP = Quantity(
        type=str,
        shape=[],
        description='''
        Perform a SCP-NDDO calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.SCP'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SE_STO_NG = Quantity(
        type=str,
        shape=[],
        description='''
        Provides the order of the Slater orbital expansion of Gaussian-Type Orbitals.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SE.STO_NG'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_COULOMB = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_COULOMB'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.COULOMB'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_EXCHANGE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.EXCHANGE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_GA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_GA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.GA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_LR_CORRECTION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.LR_CORRECTION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.MEMORY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_NEIGHBOR_LISTS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.NEIGHBOR_LISTS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE.SCREENING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_QS(MSection):
    '''
    parameters needed to set up the Quickstep framework
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_ALMO_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Perform ALMO SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.ALMO_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_ALPHA0_HARD = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW: Exponent for hard compensation charge
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.ALPHA0_HARD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_BCSR_CODE = Quantity(
        type=str,
        shape=[],
        description='''
        Selects BCSR pathway.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.BCSR_CODE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_CHECK_BCSR_CODE = Quantity(
        type=str,
        shape=[],
        description='''
        Check the BCSR code on actual data, once per QS run.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.CHECK_BCSR_CODE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_CORE_PPL = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the method used to calculate the local pseudopotential contribution.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.CORE_PPL'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_DEBUG_LRI_INTEGRALS = Quantity(
        type=str,
        shape=[],
        description='''
        Debug the integrals needed for LRIGPW.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.DEBUG_LRI_INTEGRALS'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_CORE_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        Precision for mapping the core charges.Overrides EPS_DEFAULT/100.0 value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_CORE_CHARGE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_CPC = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the GAPW projection. Overrides EPS_DEFAULT value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_CPC'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_DEFAULT = Quantity(
        type=str,
        shape=[],
        description='''
        Try setting all EPS_xxx to values leading to an energy correct up to EPS_DEFAULT
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_DEFAULT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_FILTER_MATRIX = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the threshold for filtering matrix elements.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_FILTER_MATRIX'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_GVG_RSPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the realspace KS matrix element integration. Overrides
        SQRT(EPS_DEFAULT) value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_GVG_RSPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_KG_ORB = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision used in coloring the subsets for the Kim-Gordon method. Overrides
        SQRT(EPS_DEFAULT) value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_KG_ORB'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_PGF_ORB = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the overlap matrix elements. Overrides SQRT(EPS_DEFAULT) value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_PGF_ORB'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_PPL = Quantity(
        type=str,
        shape=[],
        description='''
        Adjusts the precision for the local part of the pseudo potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_PPL'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_PPNL = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the non-local part of the pseudo potential. Overrides
        sqrt(EPS_DEFAULT) value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_PPNL'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_RHO_GSPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the density mapping in gspace.Overrides EPS_DEFAULT
        value..Overrides EPS_RHO value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_RHO_GSPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_RHO_RSPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the density mapping in rspace.Overrides EPS_DEFAULT
        value..Overrides EPS_RHO value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_RHO_RSPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPS_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        Sets precision of the density mapping on the grids.Overrides EPS_DEFAULT value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPS_RHO'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPSFIT = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW: precision to give the extention of a hard gaussian
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPSFIT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPSISO = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW: precision to determine an isolated projector
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPSISO'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPSRHO0 = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW : precision to determine the range of V(rho0-rho0soft)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPSRHO0'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EPSSVD = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW: tolerance used in the singular value decomposition of the projector matrix
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EPSSVD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EXTRAPOLATION_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Order for the PS or ASPC extrapolation (typically 2-4). Higher order might bring
        more accuracy, but comes, for large systems, also at some cost. In some cases, a
        high order extrapolation is not stable, and the order needs to be reduced.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EXTRAPOLATION_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_EXTRAPOLATION = Quantity(
        type=str,
        shape=[],
        description='''
        Extrapolation strategy for the wavefunction during e.g. MD.PS and ASPC are
        recommended, see also EXTRAPOLATION_ORDER.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.EXTRAPOLATION'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_FORCE_PAW = Quantity(
        type=str,
        shape=[],
        description='''
        Use the GAPW scheme also for atoms with soft basis sets, i.e.  the local densities
        are computed even if hard and soft should be equal. If this keyword is not set to
        true, those atoms with soft basis sets are treated by a GPW scheme, i.e. the
        corresponding density contribution goes on the global grid and is expanded in PW.
        This option nullifies the effect of the GPW_TYPE in the atomic KIND
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.FORCE_PAW'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_KG_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Use a Kim-Gordon-like scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.KG_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_LADDN0 = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW : integer added to the max L of the basis set, used to determine the maximum
        value of L for the compensation charge density.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.LADDN0'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_LMAXN0 = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW : max L number for the expansion compensation densities in spherical
        gaussians
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.LMAXN0'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_LMAXN1 = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW : max L number for expansion of the atomic densities in spherical gaussians
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.LMAXN1'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_LS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Perform a linear scaling SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.LS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_MAP_CONSISTENT = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the exact derivative (Hks) of the energy with respect to the density
        matrix. This is slightly more expensive than using an approximate computation, but
        consistent mapping can improve the stability of the SCF procedure, especially for
        a tight EPS_SCF and a less tight EPS_DEFAULT.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.MAP_CONSISTENT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_MAX_RAD_LOCAL = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW : maximum radius of gaussian functions included in the generation of
        projectors
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.MAX_RAD_LOCAL'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the electronic structure method that should be employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_PW_GRID_BLOCKED = Quantity(
        type=str,
        shape=[],
        description='''
        Can be used to set the distribution in g-space for the pw grids and their FFT.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.PW_GRID_BLOCKED'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_PW_GRID_LAYOUT = Quantity(
        type=str,
        shape=[],
        description='''
        Force a particular real-space layout for the plane waves grids. Numbers ≤ 0 mean
        that this dimension is free, incorrect layouts will be ignored. The default
        (/-1,-1/) causes CP2K to select a good value, i.e. plane distributed for large
        grids, more general distribution for small grids.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.PW_GRID_LAYOUT'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_PW_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        What kind of PW_GRID should be employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.PW_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        GAPW: algorithm to construct the atomic radial grids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.QUADRATURE'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_SCP = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional self-consistent polarization through additional response
        basis functions (read in through AUX_BASIS.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.SCP'))

    x_cp2k_input_FORCE_EVAL_DFT_QS_TRANSPORT = Quantity(
        type=str,
        shape=[],
        description='''
        Perform transport calculations (coupling CP2K and OMEN)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.QS.TRANSPORT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_BECKE_RESTRAINT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.BECKE_RESTRAINT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_DDAPC_RESTRAINT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DDAPC_RESTRAINT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_DFTB'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DFTB'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_DISTRIBUTION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_DISTRIBUTION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.DISTRIBUTION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_HARRIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_HARRIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.HARRIS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_MULLIKEN_RESTRAINT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.MULLIKEN_RESTRAINT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_OPTIMIZE_LRI_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.OPTIMIZE_LRI_BASIS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_S2_RESTRAINT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.S2_RESTRAINT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SCPTB = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SCPTB'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SCPTB'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS_SE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS.SE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION(MSection):
    '''
    Parameters needed to set up the real time propagation for the electron dynamics
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_ACCURACY_REFINEMENT = Quantity(
        type=str,
        shape=[],
        description='''
        If using density propagation some parts should be calculated with a higher
        accuracy than the rest to reduce numerical noise. This factor determines by how
        much the filtering threshold is reduced for these calculations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.ACCURACY_REFINEMENT'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_APPLY_DELTA_PULSE = Quantity(
        type=str,
        shape=[],
        description='''
        Applies a delta kick to the initial wfn (only RTP for now - the EMD  case is not
        yet implemented).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.APPLY_DELTA_PULSE'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_ASPC_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Speciefies how many steps will be used for extrapolation. One will be always used
        which is means X(t+dt)=X(t)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.ASPC_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_CALCULATE_IDEMPOTENCY = Quantity(
        type=str,
        shape=[],
        description='''
        Calculates the idempotency. Costs some performance. Is for free if McWeeny is used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.CALCULATE_IDEMPOTENCY'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_DELTA_PULSE_DIRECTION = Quantity(
        type=str,
        shape=[],
        description='''
        Direction of the applied electric field. The k vector is given as
        2*Pi*[i,j,k]*inv(h_mat), which for PERIODIC .FALSE. yields exp(ikr) periodic with
        the unit cell, only if DELTA_PULSE_SCALE is set to unity. For an orthorhombic cell
        [1,0,0] yields [2*Pi/L_x,0,0]. For small cells, this results in a very large kick.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.DELTA_PULSE_DIRECTION'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_DELTA_PULSE_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Scale the k vector, which for PERIODIC .FALSE. results in exp(ikr) no longer being
        periodic with the unit cell. The norm of k is the strength of the applied electric
        field in atomic units.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.DELTA_PULSE_SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_DENSITY_PROPAGATION = Quantity(
        type=str,
        shape=[],
        description='''
        The density matrix is propagated instead of the molecular orbitals. This allows
        for a linear scaling simulation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.DENSITY_PROPAGATION'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_EPS_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence criterium for the self consistent propagator loop.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.EPS_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_EXP_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy for the taylor and pade approximation. This is only an upper bound bound
        since the norm used for the guess is an upper bound for the needed one.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.EXP_ACCURACY'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_HFX_BALANCE_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        If HFX is used, this keyword forces a redistribution/recalculation of the
        integrals, balanced with respect to the in core steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.HFX_BALANCE_IN_CORE'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_INITIAL_WFN = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the initial WFN used for propagation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.INITIAL_WFN'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_MAT_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Which method should be used to calculate the exponential in the propagator. For
        Ehrenfest MD only the Taylor method works, for real time propagation
        diagonalization works as well.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.MAT_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximal number of iterations for the self consistent propagator loop.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_MCWEENY_EPS = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold after which McWeeny is terminated
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.MCWEENY_EPS'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_MCWEENY_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the maximum amount of McWeeny steps used after each converged step in
        density propagation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.MCWEENY_MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_ORTHONORMAL = Quantity(
        type=str,
        shape=[],
        description='''
        Performs rtp in the orthonormal basis, currently only works with density
        propagation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.ORTHONORMAL'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_PERIODIC = Quantity(
        type=str,
        shape=[],
        description='''
        Apply a delta-kick that is compatible with periodic boundary conditions for any
        value of DELTA_PULSE_SCALE. Uses perturbation theory for the preparation of the
        initial wfn. Note that the pulse is only applied when INITIAL_WFN is set to
        SCF_WFN, and not for restarts (RT_RESTART).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_PROPAGATOR = Quantity(
        type=str,
        shape=[],
        description='''
        Which propagator should be used for the orbitals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.PROPAGATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_SC_CHECK_START = Quantity(
        type=str,
        shape=[],
        description='''
        Speciefies how many iteration steps will be done without a check for self
        consistency. Can save some time in big calculations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.SC_CHECK_START'))

    x_cp2k_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION_WRITE_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        For density propagation. It writes out the density matrix after each step
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION.WRITE_RESTART'))


class x_cp2k_section_input_FORCE_EVAL_DFT_RELATIVISTIC(MSection):
    '''
    parameters needed and setup for relativistic calculations
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.RELATIVISTIC'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_DKH_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        The order of the DKH transformation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.DKH_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        type of relativistic correction used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_POTENTIAL = Quantity(
        type=str,
        shape=[],
        description='''
        External potential used in DKH transformation, full 1/r or erfc(r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_TRANSFORMATION = Quantity(
        type=str,
        shape=[],
        description='''
        Type of DKH transformation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.TRANSFORMATION'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_Z_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The minimal atomic number considered for atom transformation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.Z_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_RELATIVISTIC_ZORA_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of ZORA method to be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELATIVISTIC.ZORA_TYPE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_ANDREUSSI(MSection):
    '''
    Define the parameters of the dielectric smoothing function proposed by Andreussi et
    al.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS.ANDREUSSI'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_ANDREUSSI_RHO_MAX = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum density value used for the smoothing of the dielectric function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.ANDREUSSI.RHO_MAX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_ANDREUSSI_RHO_MIN = Quantity(
        type=str,
        shape=[],
        description='''
        Minimum density value used for the smoothing of the dielectric function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.ANDREUSSI.RHO_MIN'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_FATTEBERT_GYGI(MSection):
    '''
    Define the parameters of the dielectric smoothing function proposed by Fattebert and
    Gygi
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS.FATTEBERT-GYGI'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_FATTEBERT_GYGI_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter β changes the width of the interface solute-solvent
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.FATTEBERT-GYGI.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_FATTEBERT_GYGI_RHO_ZERO = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter ρ<sub>0</sub> defines the critical density in the middle of the
        interface solute-solvent
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.FATTEBERT-GYGI.RHO_ZERO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCCS(MSection):
    '''
    Define the parameters for self-consistent continuum solvation (SCCS) model
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Solvent specific tunable parameter for the calculation of the repulsion term
        <i>G<sup>rep</sup> = α S</i> where <i>S</i> is the (quantum) surface of the cavity
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Solvent specific tunable parameter for the calculation of the dispersion term
        <i>G<sup>dis</sup> = β V</i> where <i>V</i> is the (quantum) volume of the cavity
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_DELTA_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        Numerical increment for the calculation of the (quantum) surface of the solute
        cavity
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.DELTA_RHO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_DERIVATIVE_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method for the calculation of the numerical derivatives on the real-space grids
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.DERIVATIVE_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_DIELECTRIC_CONSTANT = Quantity(
        type=str,
        shape=[],
        description='''
        Dielectric constant of the solvent
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.DIELECTRIC_CONSTANT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_EPS_SCCS = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance for the convergence of the polarisation density, i.e. requested accuracy
        for the SCCS iteration cycle
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.EPS_SCCS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        The SCCS iteration cycle is activated only if the SCF iteration cycle is converged
        to this threshold value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Surface tension of the solvent used for the calculation of the cavitation term
        <i>G<sup>cav</sup> = γ S</i> where <i>S</i> is the (quantum) surface of the cavity
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCCS iteration steps performed to converge within the given
        tolerance
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method used for the smoothing of the dielectric function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_MIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing parameter (Hartree damping) employed during the iteration procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.MIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_SCCS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the SCCS section
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCCS.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_ANDREUSSI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_ANDREUSSI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS.ANDREUSSI'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_FATTEBERT_GYGI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCCS_FATTEBERT_GYGI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS.FATTEBERT-GYGI'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON(MSection):
    '''
    Settings for DAVIDSON
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_CONV_MOS_PERCENT = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal percent of MOS that have to converge within the Davidson loop before the
        SCF iteration is completed and a new Hamiltonian is computed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.CONV_MOS_PERCENT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (0.001 doing normally fine). For the
        other preconditioners, making this value larger (0.2) will tame the preconditioner
        in case of poor initial guesses.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_FIRST_PREC = Quantity(
        type=str,
        shape=[],
        description='''
        First SCF iteration at which a Preconditioner is employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.FIRST_PREC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_NEW_PREC_EACH = Quantity(
        type=str,
        shape=[],
        description='''
        Number of SCF iterations after which a new Preconditioner is computed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.NEW_PREC_EACH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON_SPARSE_MOS = Quantity(
        type=str,
        shape=[],
        description='''
        Use MOS as sparse matrix and avoid as much as possible multiplications with full
        matrices
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON.SPARSE_MOS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING(MSection):
    '''
    Define type and parameters for mixingprocedures to be applied to the density matrix.
    Normally, only one type of mixing method should be accepted. The mixing procedures
    activated by this section are only active for diagonalization methods, i.e. not with
    minimization methods based on OT.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be included
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Denominator parameter in Kerker damping introduced to suppress charge sloshing:
        rho_mix(g) =rho_in(g) + alpha*g^2/(g^2 + beta^2)*(rho_out(g)-rho_in(g))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_W0 = Quantity(
        type=str,
        shape=[],
        description='''
        w0 parameter used in Broyden mixing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_W0'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_WMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WMAX
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_WMAX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_WREF = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WREF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_WREF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_MAX_GVEC_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Restricts the G-space mixing to lower part of G-vector spectrum, up to a G0, by
        assigning the exponent of the Gaussian that can be represented by vectors smaller
        than G0 within a certain accuracy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.MAX_GVEC_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_MAX_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        Upper bound for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.MAX_STEP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_N_SIMPLE_MIX = Quantity(
        type=str,
        shape=[],
        description='''
        Number of kerker damping iterations before starting other mixing procedures
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.N_SIMPLE_MIX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NBUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of previous steps stored for the actual mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NBUFFER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NMIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal number of density mixing (should be greater than 0),before starting DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NMIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NSKIP = Quantity(
        type=str,
        shape=[],
        description='''
        Number of initial iteration for which the mixing is skipped
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NSKIP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_PULAY_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be added to the Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.PULAY_ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_PULAY_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of residual contribution to be added to Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.PULAY_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_R_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Control factor for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.R_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_REGULARIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Regularization parameter to stabilize the inversion of the residual matrix {Yn^t
        Yn} in the multisecant mixing scheme (noise)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.REGULARIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the mixing procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF(MSection):
    '''
    Activation of self-consistenf subspace refinement by diagonalization of H by adjusting
    the occupation but keeping the MOS unchanged.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_ADAPT_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Required density matrix accuracy as compared to current SCF convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_ADAPT_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_ENE = Quantity(
        type=str,
        shape=[],
        description='''
        Required energy accuracy for convergence of subspace diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_ENE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_SKIP_SUB_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Level of convergence to be reached before starting the internal loop of subspace
        rotations. Above this threshold only the outer diagonalization method is used.  If
        negative the subspace rotation is started at the first iteration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_SKIP_SUB_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations for the SCF inner loop
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of inner SCF loop to refine occupations in MOS subspace
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV(MSection):
    '''
    Settings for KRYLOV
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV_CHECK_MOS_CONV = Quantity(
        type=str,
        shape=[],
        description='''
        This requires to check the convergence of MOS also when standard diagonalization
        steps are performed, if the block krylov approach is active.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV.CHECK_MOS_CONV'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV_EPS_KRYLOV = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence criterion for the MOs
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV.EPS_KRYLOV'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV_EPS_STD_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Level of convergence to be reached before starting the Lanczos procedure. Above
        this threshold a standard diagonalization method is used.  If negative Lanczos is
        started at the first iteration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV.EPS_STD_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV_NBLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the block of vectors refined simultaneously by the Lanczos procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV.NBLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV_NKRYLOV = Quantity(
        type=str,
        shape=[],
        description='''
        Dimension of the Krylov space used for the Lanczos refinement
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV.NKRYLOV'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT(MSection):
    '''
    Sets the various options for the orbital transformation (OT) method. Default settings
    already provide an efficient, yet robust method. Most systems benefit from using the
    FULL_ALL preconditioner combined with a small value (0.001) of ENERGY_GAP.Well-behaved
    systems might benefit from using a DIIS minimizer.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for OT
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_ADAPTIVE_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Enable adaptive curvature estimation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_ADAPTIVE_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Underrelaxation for the broyden mixer
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_ENABLE_FLIP = Quantity(
        type=str,
        shape=[],
        description='''
        Ensure positive definite update
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_ENABLE_FLIP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_ETA = Quantity(
        type=str,
        shape=[],
        description='''
        Dampening of estimated energy curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_ETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_FORGET_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Forget history on bad approximation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_FORGET_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Backtracking parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Growth limit of curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA_DECREASE = Quantity(
        type=str,
        shape=[],
        description='''
        Reduction of curvature on bad approximation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA_DECREASE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA_MIN = Quantity(
        type=str,
        shape=[],
        description='''
        Minimum adaptive curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA_MIN'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Curvature of energy functional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ENERGIES = Quantity(
        type=str,
        shape=[],
        description='''
        Optimize orbital energies for use in Fermi-Dirac smearing (requires ROTATION and
        FD smearing to be active).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ENERGIES'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (can be a small number, e.g. 0.002).
        FULL_SINGLE_INVERSE takes it as lower bound (values below 0.05 can cause stability
        issues). In general, heigher values will tame the preconditioner in case of poor
        initial guesses. A negative value will leave the choice to CP2K depending on type
        of preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_EPS_IRAC_FILTER_MATRIX = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the threshold for filtering the matrices.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.EPS_IRAC_FILTER_MATRIX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_EPS_IRAC_QUICK_EXIT = Quantity(
        type=str,
        shape=[],
        description='''
        Only one extra refinement iteration is done when the norm is below this value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.EPS_IRAC_QUICK_EXIT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_EPS_IRAC_SWITCH = Quantity(
        type=str,
        shape=[],
        description='''
        The algorithm switches to the polynomial refinement when the norm is below this
        value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.EPS_IRAC_SWITCH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_EPS_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Targeted accuracy during the refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.EPS_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_EPS_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy of the taylor expansion for the matrix functions, should normally
        be kept as is.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.EPS_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_GOLD_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        Target relative uncertainty in the location of the minimum for LINESEARCH GOLD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.GOLD_TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_IRAC_DEGREE = Quantity(
        type=str,
        shape=[],
        description='''
        The refinement polynomial degree (2, 3 or 4).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.IRAC_DEGREE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_LINESEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        1D line search algorithm to be used with the OT minimizer, in increasing order of
        robustness and cost. MINIMIZER CG combined with LINESEARCH GOLD should always find
        an electronic minimum.  Whereas the 2PNT minimizer is almost always OK, 3PNT might
        be needed for systems in which successive OT CG steps do not decrease the total
        energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.LINESEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_MAX_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.MAX_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_MAX_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum order of the Taylor expansion before diagonalisation is prefered, for
        large parallel runs a slightly higher order could sometimes result in a small
        speedup.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.MAX_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_MINIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Minimizer to be used with the OT method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.MINIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_MIXED_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a mixed precision algorithm.With a well behaved basis set (i.e. condition
        number less than 1/eps_sp)it provides double precision accuracy results and up to
        a 2 fold speedup for building and applying the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.MIXED_PRECISION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_N_HISTORY_VEC = Quantity(
        type=str,
        shape=[],
        description='''
        Number of history vectors to be used with DIIS or BROYDEN
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.N_HISTORY_VEC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_NONDIAG_ENERGY_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        The prefactor for the non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.NONDIAG_ENERGY_STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_NONDIAG_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Add a non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.NONDIAG_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_OCCUPATION_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Preconditioner with the occupation numbers (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.OCCUPATION_PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ON_THE_FLY_LOC = Quantity(
        type=str,
        shape=[],
        description='''
        On the fly localization of the molecular orbitals. Can only be used with OT/IRAC.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ON_THE_FLY_LOC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ORTHO_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        The orthogonality method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ORTHO_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes. They differ in
        effectiveness, cost of construction, cost of application. Properly preconditioned
        minimization can be orders of magnitude faster than doing nothing.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_ROTATION = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional variables so that rotations of the occupied subspace are
        allowed as well, only needed for cases where the energy is not invariant under  a
        rotation of the occupied subspace such as non-singlet restricted calculations  or
        fractional occupations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.ROTATION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_SAFE_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Reject DIIS steps if they point away from the minimum, do SD in that case.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.SAFE_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_SCP_NDDO = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional self-consistent polarization through response basis set =
        orbital basis set for NDDO.)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.SCP_NDDO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the ot method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT_STEPSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial stepsize used for the line search, sometimes this parameter can be reduced
        to stablize DIIS or to improve the CG behavior in the first few steps. The optimal
        value depends on the quality of the preconditioner. A negative values leaves the
        choice to CP2K depending on the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT.STEPSIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION(MSection):
    '''
    Set up type and parameters for Kohn-Sham matrix diagonalization.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_EPS_ADAPT = Quantity(
        type=str,
        shape=[],
        description='''
        Required accuracy in iterative diagonalization as compared to current SCF
        convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.EPS_ADAPT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_EPS_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Required accuracy in iterative diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.EPS_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_EPS_JACOBI = Quantity(
        type=str,
        shape=[],
        description='''
        Below this threshold value for the SCF convergence the pseudo-diagonalization
        method using Jacobi rotations is activated. This method is much faster than a real
        diagonalization and it is even speeding up while achieving full
        convergence.However, it needs a pre-converged wavefunction obtained by at least
        one real diagonalization which is further optimized while keeping the original
        eigenvalue spectrum. The MO eigenvalues are NOT updated. The method might be
        useful to speed up calculations for large systems e.g. using a semi-empirical
        method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.EPS_JACOBI'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_JACOBI_THRESHOLD = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the accuracy of the pseudo-diagonalization method using Jacobi rotations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.JACOBI_THRESHOLD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations in iterative diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the diagonalization method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DAVIDSON'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DAVIDSON'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_DIAG_SUB_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.DIAG_SUB_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_KRYLOV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.KRYLOV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION_OT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION.OT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_MIXING(MSection):
    '''
    Define type and parameters for mixingprocedures to be applied to the density matrix.
    Normally, only one type of mixing method should be accepted. The mixing procedures
    activated by this section are only active for diagonalization methods, i.e. not with
    minimization methods based on OT.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.MIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be included
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Denominator parameter in Kerker damping introduced to suppress charge sloshing:
        rho_mix(g) =rho_in(g) + alpha*g^2/(g^2 + beta^2)*(rho_out(g)-rho_in(g))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_BROY_W0 = Quantity(
        type=str,
        shape=[],
        description='''
        w0 parameter used in Broyden mixing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.BROY_W0'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_BROY_WMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WMAX
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.BROY_WMAX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_BROY_WREF = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WREF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.BROY_WREF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_MAX_GVEC_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Restricts the G-space mixing to lower part of G-vector spectrum, up to a G0, by
        assigning the exponent of the Gaussian that can be represented by vectors smaller
        than G0 within a certain accuracy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.MAX_GVEC_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_MAX_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        Upper bound for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.MAX_STEP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_N_SIMPLE_MIX = Quantity(
        type=str,
        shape=[],
        description='''
        Number of kerker damping iterations before starting other mixing procedures
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.N_SIMPLE_MIX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_NBUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of previous steps stored for the actual mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.NBUFFER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_NMIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal number of density mixing (should be greater than 0),before starting DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.NMIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_NSKIP = Quantity(
        type=str,
        shape=[],
        description='''
        Number of initial iteration for which the mixing is skipped
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.NSKIP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_PULAY_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be added to the Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.PULAY_ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_PULAY_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of residual contribution to be added to Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.PULAY_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_R_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Control factor for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.R_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_REGULARIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Regularization parameter to stabilize the inversion of the residual matrix {Yn^t
        Yn} in the multisecant mixing scheme (noise)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.REGULARIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MIXING_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the mixing procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MIXING.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OT(MSection):
    '''
    Sets the various options for the orbital transformation (OT) method. Default settings
    already provide an efficient, yet robust method. Most systems benefit from using the
    FULL_ALL preconditioner combined with a small value (0.001) of ENERGY_GAP.Well-behaved
    systems might benefit from using a DIIS minimizer.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.OT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for OT
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_ADAPTIVE_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Enable adaptive curvature estimation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_ADAPTIVE_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Underrelaxation for the broyden mixer
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_ENABLE_FLIP = Quantity(
        type=str,
        shape=[],
        description='''
        Ensure positive definite update
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_ENABLE_FLIP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_ETA = Quantity(
        type=str,
        shape=[],
        description='''
        Dampening of estimated energy curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_ETA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_FORGET_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Forget history on bad approximation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_FORGET_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Backtracking parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Growth limit of curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_SIGMA_DECREASE = Quantity(
        type=str,
        shape=[],
        description='''
        Reduction of curvature on bad approximation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_SIGMA_DECREASE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_SIGMA_MIN = Quantity(
        type=str,
        shape=[],
        description='''
        Minimum adaptive curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_SIGMA_MIN'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_BROYDEN_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Curvature of energy functional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.BROYDEN_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ENERGIES = Quantity(
        type=str,
        shape=[],
        description='''
        Optimize orbital energies for use in Fermi-Dirac smearing (requires ROTATION and
        FD smearing to be active).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ENERGIES'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (can be a small number, e.g. 0.002).
        FULL_SINGLE_INVERSE takes it as lower bound (values below 0.05 can cause stability
        issues). In general, heigher values will tame the preconditioner in case of poor
        initial guesses. A negative value will leave the choice to CP2K depending on type
        of preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_EPS_IRAC_FILTER_MATRIX = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the threshold for filtering the matrices.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.EPS_IRAC_FILTER_MATRIX'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_EPS_IRAC_QUICK_EXIT = Quantity(
        type=str,
        shape=[],
        description='''
        Only one extra refinement iteration is done when the norm is below this value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.EPS_IRAC_QUICK_EXIT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_EPS_IRAC_SWITCH = Quantity(
        type=str,
        shape=[],
        description='''
        The algorithm switches to the polynomial refinement when the norm is below this
        value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.EPS_IRAC_SWITCH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_EPS_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Targeted accuracy during the refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.EPS_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_EPS_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy of the taylor expansion for the matrix functions, should normally
        be kept as is.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.EPS_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_GOLD_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        Target relative uncertainty in the location of the minimum for LINESEARCH GOLD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.GOLD_TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_IRAC_DEGREE = Quantity(
        type=str,
        shape=[],
        description='''
        The refinement polynomial degree (2, 3 or 4).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.IRAC_DEGREE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_LINESEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        1D line search algorithm to be used with the OT minimizer, in increasing order of
        robustness and cost. MINIMIZER CG combined with LINESEARCH GOLD should always find
        an electronic minimum.  Whereas the 2PNT minimizer is almost always OK, 3PNT might
        be needed for systems in which successive OT CG steps do not decrease the total
        energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.LINESEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_MAX_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.MAX_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_MAX_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum order of the Taylor expansion before diagonalisation is prefered, for
        large parallel runs a slightly higher order could sometimes result in a small
        speedup.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.MAX_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_MINIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Minimizer to be used with the OT method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.MINIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_MIXED_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a mixed precision algorithm.With a well behaved basis set (i.e. condition
        number less than 1/eps_sp)it provides double precision accuracy results and up to
        a 2 fold speedup for building and applying the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.MIXED_PRECISION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_N_HISTORY_VEC = Quantity(
        type=str,
        shape=[],
        description='''
        Number of history vectors to be used with DIIS or BROYDEN
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.N_HISTORY_VEC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_NONDIAG_ENERGY_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        The prefactor for the non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.NONDIAG_ENERGY_STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_NONDIAG_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Add a non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.NONDIAG_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_OCCUPATION_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Preconditioner with the occupation numbers (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.OCCUPATION_PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ON_THE_FLY_LOC = Quantity(
        type=str,
        shape=[],
        description='''
        On the fly localization of the molecular orbitals. Can only be used with OT/IRAC.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ON_THE_FLY_LOC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ORTHO_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        The orthogonality method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ORTHO_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes. They differ in
        effectiveness, cost of construction, cost of application. Properly preconditioned
        minimization can be orders of magnitude faster than doing nothing.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_ROTATION = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional variables so that rotations of the occupied subspace are
        allowed as well, only needed for cases where the energy is not invariant under  a
        rotation of the occupied subspace such as non-singlet restricted calculations  or
        fractional occupations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.ROTATION'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_SAFE_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Reject DIIS steps if they point away from the minimum, do SD in that case.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.SAFE_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_SCP_NDDO = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional self-consistent polarization through response basis set =
        orbital basis set for NDDO.)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.SCP_NDDO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the ot method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OT_STEPSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial stepsize used for the line search, sometimes this parameter can be reduced
        to stablize DIIS or to improve the CG behavior in the first few steps. The optimal
        value depends on the quality of the preconditioner. A negative values leaves the
        choice to CP2K depending on the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OT.STEPSIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OUTER_SCF(MSection):
    '''
    parameters controlling the outer SCF loop
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.OUTER_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_BISECT_TRUST_COUNT = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of times the same point will be used in bisection, a small number
        guards against the effect of wrongly converged states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.BISECT_TRUST_COUNT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_DIIS_BUFFER_LENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of DIIS vectors used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.DIIS_BUFFER_LENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        The target gradient of the outer scf variables. Notice that the EPS_SCF of the
        inner loop also determines the value that can be reached in the outer loop,
        typically EPS_SCF of the outer loop must be smaller than EPS_SCF of the inner
        loop.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_EXTRAPOLATION_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of past states used in the extrapolation of the variables during e.g. MD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.EXTRAPOLATION_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_MAX_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        The maximum number of outer loops
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.MAX_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_OPTIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Method used to bring the outer loop to a stationary point
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.OPTIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the outer SCF loop
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_STEP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        The initial step_size used in the optimizer (currently steepest descent).Note that
        in cases where a sadle point is sought for (DDAPC_CONSTRAINT), this can be
        negative
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.STEP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_OUTER_SCF_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies which kind of outer SCF should be employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.OUTER_SCF.TYPE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF_SMEAR(MSection):
    '''
    Define the smearing of the MO occupation numbers
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.SMEAR'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_ELECTRONIC_TEMPERATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Electronic temperature in the case of Fermi-Dirac smearing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.ELECTRONIC_TEMPERATURE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_EPS_FERMI_DIRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy checks on occupation numbers use this as a tolerance
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.EPS_FERMI_DIRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_FIXED_MAGNETIC_MOMENT = Quantity(
        type=str,
        shape=[],
        description='''
        Imposed difference between the numbers of electrons of spin up and spin down: m =
        n(up) - n(down). A negative value (default) allows for a change of the magnetic
        moment. -1 specifically keeps an integer number of spin up and spin down
        electrons.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.FIXED_MAGNETIC_MOMENT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        A list of fractional occupations to use. Must match the number of states and sum
        up to the correct number of electrons
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Smearing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of smearing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SMEAR_WINDOW_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the energy window centred at the Fermi level
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SMEAR.WINDOW_SIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCF(MSection):
    '''
    parameters needed perform an scf run
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_ADDED_MOS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of additional MOS added for each spin
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.ADDED_MOS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_CHOLESKY = Quantity(
        type=str,
        shape=[],
        description='''
        If the cholesky method should be used for computing the inverse of S, and in this
        case calling which Lapack routines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.CHOLESKY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_EPS_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold on the convergence to start using DIAG/DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.EPS_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_EPS_EIGVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Throw away linear combinations of basis functions with a small eigenvalue in S
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.EPS_EIGVAL'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_EPS_LUMO = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy of the computation of the lumo energy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.EPS_LUMO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_EPS_SCF_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy for the scf convergence after the history pipeline is filled
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.EPS_SCF_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy for the scf convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_LEVEL_SHIFT = Quantity(
        type=str,
        shape=[],
        description='''
        Use level shifting to improve convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.LEVEL_SHIFT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MAX_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of DIIS vectors to be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MAX_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MAX_ITER_LUMO = Quantity(
        type=str,
        shape=[],
        description='''
        The maximum number of iteration for the lumo computation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MAX_ITER_LUMO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MAX_SCF_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCF iterations after the history pipeline is filled
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MAX_SCF_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_MAX_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCF iteration to be performed for one optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.MAX_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_NCOL_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the number of columns in a scalapack block
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.NCOL_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_NROW_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        sets the number of rows in a scalapack block
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.NROW_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_ROKS_F = Quantity(
        type=str,
        shape=[],
        description='''
        Allows to define the parameter f for the general ROKS scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.ROKS_F'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_ROKS_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Allows to define all parameters for the high-spin ROKS scheme explicitly. The full
        set of 6 parameters has to be specified in the order acc, bcc, aoo, boo, avv, bvv
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.ROKS_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_ROKS_SCHEME = Quantity(
        type=str,
        shape=[],
        description='''
        Selects the ROKS scheme when ROKS is applied.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.ROKS_SCHEME'))

    x_cp2k_input_FORCE_EVAL_DFT_SCF_SCF_GUESS = Quantity(
        type=str,
        shape=[],
        description='''
        Change the initial guess for the wavefunction.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCF.SCF_GUESS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_DIAGONALIZATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.DIAGONALIZATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_MIXING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_MIXING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.MIXING'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.OT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OUTER_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_OUTER_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.OUTER_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF_SMEAR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF_SMEAR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF.SMEAR'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing basic info about the method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER(MSection):
    '''
    Defines the center of the sphere.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER_ATOM_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Defines a list of atoms to define the center of the sphere
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER.ATOM_LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER_FIXED = Quantity(
        type=str,
        shape=[],
        description='''
        Specify if the center of the sphere should be fixed or allowed to move
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER.FIXED'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER_WEIGHT_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the weight used to define the center of the sphere (if ATOM_LIST is
        provided)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER.WEIGHT_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER_XYZ = Quantity(
        type=str,
        shape=[],
        description='''
        Coordinates of the center of the sphere
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER.XYZ'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE(MSection):
    '''
    Treats the implicit solvent environment like a sphere
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.SPHERE'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_SPHERE_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the spherical cavity in the dielectric medium
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.SPHERE.RADIUS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE_CENTER'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.SPHERE.CENTER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SCRF(MSection):
    '''
    Adds an implicit solvation model to the DFT calculation. Know also as Self Consistent
    Reaction Field.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_EPS_OUT = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the dielectric constant outside the sphere
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.EPS_OUT'))

    x_cp2k_input_FORCE_EVAL_DFT_SCRF_LMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum value of L used in the multipole expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SCRF.LMAX'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.PROGRAM_RUN_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCRF_SPHERE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF.SPHERE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_SIC(MSection):
    '''
    parameters for the self interaction correction
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SIC'))

    x_cp2k_input_FORCE_EVAL_DFT_SIC_ORBITAL_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Type of orbitals treated with the SIC
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SIC.ORBITAL_SET'))

    x_cp2k_input_FORCE_EVAL_DFT_SIC_SIC_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method used to remove the self interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SIC.SIC_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_SIC_SIC_SCALING_A = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the coulomb term in sic [experimental]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SIC.SIC_SCALING_A'))

    x_cp2k_input_FORCE_EVAL_DFT_SIC_SIC_SCALING_B = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the xc term in sic [experimental]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SIC.SIC_SCALING_B'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_SIC(MSection):
    '''
    parameters for the self interaction correction
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.SIC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_SIC_ORBITAL_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Type of orbitals treated with the SIC
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.SIC.ORBITAL_SET'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_SIC_SIC_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method used to remove the self interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.SIC.SIC_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_SIC_SIC_SCALING_A = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the coulomb term in sic [experimental]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.SIC.SIC_SCALING_A'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_SIC_SIC_SCALING_B = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the xc term in sic [experimental]
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.SIC.SIC_SCALING_B'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING(MSection):
    '''
    Parameters for self interation corrected hybrid functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING_FUNCTIONAL_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        Which model for the coupling constant integration should be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING.FUNCTIONAL_MODEL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which Hybrid functional should be used. (Has to be consistent with the definitions
        in XC and HF).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING.FUNCTIONAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        The point to be used along the adiabatic curve (0 &#60; λ &#60; 1)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Long-range parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING.OMEGA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HFX_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.LOAD_BALANCE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.FRACTION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.PW_HFX'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HF_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.HFX_RI'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.LOAD_BALANCE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.MEMORY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.PERIODIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF.SCREENING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL(MSection):
    '''
    Information on the non local dispersion functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the FFT grid used in the calculation of the nonlocal vdW functional
        [Ry].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL_KERNEL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the kernel data file, may include a path.vdW_kernel_table.dat is for DRSLL
        and LMKLL andrVV10_kernel_table.dat is for rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL.KERNEL_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Parameters b and C of the rVV10 functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of functional (the corresponding kernel data file should be selected).Allows
        for common forms such as vdW-DF, vdW-DF2, optB88-vdW, rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL.TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for non local functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL.VERBOSE_OUTPUT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD(MSection):
    '''
    Controls the printing of some info about DFTD contributions
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL(MSection):
    '''
    Information on the pair potential to calculate dispersion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOM_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number of a set of atoms for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOM_COORDINATION_NUMBERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOMPARM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies parameters for atom types (in atomic units). If not provided default
        parameters are used (DFT-D2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOMPARM'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_CALCULATE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.CALCULATE_C9_TERM'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,sr6,s8) for the DFT-D3 method, if
        set to zero CP2K attempts to guess the xc functional from REFERENCE_FUNCTIONAL and
        sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3BJ_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,a1,s8,a2) for the DFT-D3(BJ)
        method, if set to zero CP2K attempts to guess the xc functional from
        REFERENCE_FUNCTIONAL and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3BJ_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EPS_CN = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff value for coordination number function (DFT-D3 method)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EPS_CN'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EXP_PRE = Quantity(
        type=str,
        shape=[],
        description='''
        Prefactor in exponential damping factor (DFT-D2 potential)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EXP_PRE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_KIND_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number for a kind for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.KIND_COORDINATION_NUMBERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_LONG_RANGE_CORRECTION = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate a long range correction to the DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.LONG_RANGE_CORRECTION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PARAMETER_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the parameter file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PARAMETER_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_R_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Range of potential. The cutoff will be 2 times this value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.R_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model using reference coordination numbers
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_C9_TERM'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Use parameters for this specific density functional. For available D3 and D3(BJ)
        parameters see: http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionals.html,
        http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionalsbj.html
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameter, if set to zero CP2K attempts to guess
        the xc functional that is in use and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for the DFT-D2 and DFT-D3 models
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.VERBOSE_OUTPUT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL(MSection):
    '''
    This section combines all possible additional dispersion corrections to the normal XC
    functionals. This can be more functionals or simple empirical pair potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of dispersion/vdW functional or potential to use
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_NON_LOCAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL_PAIR_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CPHF(MSection):
    '''
    Parameters influencing the solution of the Z-vector equations in MP2 gradients
    calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.CPHF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CPHF_EPS_CONV = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence threshold for the solution of the Z-vector equations. The Z-vector
        equations have the form of a linear system of equations Ax=b, convergence is
        achieved when |Ax-b|<=EPS_CONV.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.CPHF.EPS_CONV'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CPHF_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations allowed for the solution of the Z-vector equations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.CPHF.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_DIRECT_CANONICAL(MSection):
    '''
    Parameters influencing the direct canonical method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_DIRECT_CANONICAL_BIG_SEND = Quantity(
        type=str,
        shape=[],
        description='''
        Send big messages between processes (useful for >48 processors).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.DIRECT_CANONICAL.BIG_SEND'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL(MSection):
    '''
    Parameters the interaction potential in computing the biel integrals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, TShPSC operator).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TRUNCATION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines truncation radius for the truncated TShPSC potential. Only valid when
        doing truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TRUNCATION_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TSHPSC_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file TShPSC.dat that contains the data for the evaluation of the
        TShPSC G0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TSHPSC_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO(MSection):
    '''
    Controls the printing basic info about MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS(MSection):
    '''
    Parameters influencing the optimization of the RI MP2 basis. Only exponents of non-
    contracted auxiliary basis can be optimized. An initial RI auxiliary basis has to be
    specified.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_BASIS_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the size of the auxiliary basis set automatically generated as initial
        guess. This will be effective only if RI_AUX_BASIS_SET in the KIND section and
        NUM_FUNC are not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.BASIS_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_I_REL = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the relative deviation of the amplitudes calculated with and
        without RI approximation, (more details in Chem.Phys.Lett.294(1998)143).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_I_REL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_RI = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the absolute difference between the RI-MP2 and the exact MP2
        energy, DRI=ABS(E_MP2-E_RI-MP2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_EPS_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The derivatives of the MP2 energy with respect to the exponents of the basis are
        calculated numerically. The change in the exponent a_i employed for the numerical
        evaluation is defined as h_i=EPS_DERIV*a_i.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.EPS_DERIV'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the maximum number of steps in the RI basis optimization.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS_NUM_FUNC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of function, for each angular momentum (s, p, d ...),
        employed in the automatically generated initial guess. This will be effective only
        if RI_AUX_BASIS_SET in the KIND section is not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS.NUM_FUNC'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_LAPLACE(MSection):
    '''
    Parameters influencing the RI-SOS-MP2-Laplace method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_LAPLACE_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-SOS-
        MP2-Laplace method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_LAPLACE.QUADRATURE_POINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_LAPLACE_SIZE_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for the integration in the Laplace method, that is the number of
        processes involved in the computation of each integration point. SIZE_INTEG_GROUP
        has to be a multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1)
        is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_LAPLACE.SIZE_INTEG_GROUP'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2(MSection):
    '''
    Parameters influencing the RI MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for communication in RI-MP2. Larger BLOCK_SIZE
        reduces communication but requires more memory. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_MP2.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2_EPS_CANONICAL = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold for discriminate if a given ij pairs of the unrelaxed MP2 density matrix
        has to be calculated with a canonical reformulation based on the occupied
        eigenvalues differences.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_MP2.EPS_CANONICAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2_FREE_HFX_BUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Free the buffer containing the 4 center integrals used in the Hartree-Fock
        exchange calculation. This will be effective only for gradients calculations,
        since for the energy only case, the buffers are released by default. (Right now
        debugging only).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_MP2.FREE_HFX_BUFFER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.FRACTION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA(MSection):
    '''
    Parameters influencing the RI RPA method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_MINIMAX_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Use the Minimax quadrature scheme for performing the numerical integration.
        Maximum number of quadrature point limited to 20.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.MINIMAX_QUADRATURE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_MM_STYLE = Quantity(
        type=str,
        shape=[],
        description='''
        Matrix multiplication style for the Q matrix.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.MM_STYLE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-RPA method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.QUADRATURE_POINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_SIZE_FREQ_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for frequency integration, that is the number of processes involved in
        the computation of each integration point. SIZE_FREQ_INTEG_GROUP has to be a
        multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1) is
        automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.SIZE_FREQ_INTEG_GROUP'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA.HF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW(MSection):
    '''
    Parameters for the GPW approach in Wavefunction-based Correlation methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the finest grid level in the MP2 gpw integration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the DBCSR based multiply (usually 10 times smaller than
        EPS_GRID).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW.EPS_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW_EPS_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the GPW based integration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW.EPS_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW_PRINT_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        How much output is written by the individual groups.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW.PRINT_LEVEL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the grid at which a Gaussian is mapped.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW.REL_CUTOFF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION(MSection):
    '''
    Sets up the Wavefunction-based Correlation parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CALC_COND_NUM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate the condition number of the (P|Q) matrix for the RI methods.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.CALC_COND_NUM'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_COL_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the column block used in the SCALAPACK block cyclic data
        distribution.Default is (COL_BLOCK=-1) is automatic. A proper choice can speedup
        the parallel matrix multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.COL_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_GROUP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Group size used in the computation of the integrals. Default is to use all
        processors (GROUP_SIZE=-1).A smaller group size (for example the node size), might
        a better choice if the actual MP2 time is large compared to integral computation
        time. This is usually the case if the total number of processors is not too large.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.GROUP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed total memory usage during MP2 methods [Mb].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Which method should be used to compute the MP2 energy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_ROW_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the row block used in the SCALAPACK block cyclic data distribution.Default
        is (ROW_BLOCK=-1) is automatic. A proper choice can speedup the parallel matrix
        multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.ROW_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_SCALE_S = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the singlet energy component (opposite spin, OS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.SCALE_S'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_SCALE_T = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the triplet energy component (same spin, SS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.SCALE_T'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CPHF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_CPHF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.CPHF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_DIRECT_CANONICAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_DIRECT_CANONICAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_MP2_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_OPT_RI_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_LAPLACE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_LAPLACE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_MP2'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_RI_RPA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION_WFC_GPW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION.WFC_GPW'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC(MSection):
    '''
    Uses the Becke 88 longrange exchange functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR(MSection):
    '''
    Uses the Becke 88 longrange exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88(MSection):
    '''
    Uses the Becke 88 exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97(MSection):
    '''
    Uses the Becke 97 exchange correlation functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the B97 and Grimme parametrization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional, if -1 the default for the given
        parametrization is used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL(MSection):
    '''
    Becke Roussel exchange hole model. Can be usedas long range correction with a
    truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff radius for the truncation. If put to zero, the standard full
        range potential will be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter in the exchange hole. Usually this is put to 1.0 or 0.8
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BEEF(MSection):
    '''
    Uses the BEEFvdW exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BEEF_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BEEF.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BEEF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BEEF.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_CS1(MSection):
    '''
    Uses the CS1 functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_CS1_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.CS1.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09(MSection):
    '''
    Combination of three different exchange hole models
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for Becke Roussel hole
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09.GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_HCTH(MSection):
    '''
    Uses the HCTH class of functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_HCTH_PARAMETER_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the parameters should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.HCTH.PARAMETER_SET'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_HCTH_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.HCTH.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_GGA(MSection):
    '''
    Uses one of the KE_GGA functionals (optimized versions of some of these functionals
    might be available outside this section). These functionals are needed for the
    computation of the kinetic energy in the Kim-Gordon method.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_GGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the KE_GGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_GGA.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_GGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_GGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC(MSection):
    '''
    To be used for KG runs. Uses kinetic energy functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR(MSection):
    '''
    LDA exchange hole model in truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC(MSection):
    '''
    Uses functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_ADIABATIC(MSection):
    '''
    Uses the LYP correlation functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP_ADIABATIC.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP(MSection):
    '''
    Uses the LYP functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_OPTX(MSection):
    '''
    Uses the OPTX functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_OPTX_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.OPTX.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_OPTX_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.OPTX.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_P86C(MSection):
    '''
    Uses the P86C functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_P86C_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.P86C.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_P86C_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.P86C.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PADE(MSection):
    '''
    Uses the PADE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PADE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PADE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR(MSection):
    '''
    PBE exchange hole model in trucanted coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE(MSection):
    '''
    Uses the PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the different parametrizations of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92(MSection):
    '''
    Uses the PerdewWang correlation functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PW92.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the energy functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PW92.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PW92.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81(MSection):
    '''
    Uses the PZ functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PZ81.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PZ81.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PZ81.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TFW(MSection):
    '''
    Uses the TFW functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TFW_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TFW.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TF(MSection):
    '''
    Uses the TF functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TF.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS(MSection):
    '''
    Uses the TPSS functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TPSS.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TPSS.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TPSS.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN(MSection):
    '''
    Uses the VWN functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the VWN functional should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.VWN.FUNCTIONAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.VWN.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.VWN.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA(MSection):
    '''
    Uses the XALPHA (SLATER) functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XALPHA.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XALPHA.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA_XA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the xa parameter (this does not change the exponent, just the mixing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XALPHA.XA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XGGA(MSection):
    '''
    Uses one of the XGGA functionals (optimized versions of some of these functionals
    might be available outside this section).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XGGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the XGGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XGGA.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XGGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XGGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE(MSection):
    '''
    Uses the short range PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        screening parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE_SCALE_X0 = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the original hole PBE-functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE.SCALE_X0'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL(MSection):
    '''
    The xc functional to use
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Shortcut for the most common functional combinations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE88'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE97'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BEEF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_BEEF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_CS1 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_CS1'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_GV09'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_HCTH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_HCTH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_GGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_GGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_KE_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_LYP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_OPTX = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_OPTX'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_P86C = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_P86C'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PADE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PADE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PW92'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_PZ81'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TFW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TFW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_TPSS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_VWN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XALPHA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XGGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XGGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL_XWPBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL.XWPBE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID(MSection):
    '''
    The xc parameters used when calculating the xc on the grid
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID_USE_FINER_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a finer grid only to calculate the xc
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_GRID.USE_FINER_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID_XC_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The method used to compute the derivatives
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_GRID.XC_DERIV'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID_XC_SMOOTH_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        The density smoothing used for the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_GRID.XC_SMOOTH_RHO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP(MSection):
    '''
    Uses the SAOP potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.SAOP'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the alpha parameter (default = 1.19).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.SAOP.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the beta parameter (default = 0.01).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.SAOP.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP_K_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the K_rho parameter (default = 0.42).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.SAOP.K_RHO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL(MSection):
    '''
    The xc potential to use (CAREFUL: xc potential here refers to potentials that are not
    derived from an xc functional, but rather are modelled directly. Therefore there is no
    consistent xc energy available. To still get an energy expression, see ENERGY below
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        How to determine the total energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.ENERGY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL_SAOP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL.SAOP'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC(MSection):
    '''
    parameters needed calculate the xc potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_DENSITY_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.DENSITY_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_DENSITY_SMOOTH_CUTOFF_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for the smoothing procedure inxc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.DENSITY_SMOOTH_CUTOFF_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_FUNCTIONAL_ROUTINE = Quantity(
        type=str,
        shape=[],
        description='''
        Select the code for xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.FUNCTIONAL_ROUTINE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_GRADIENT_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the gradient of the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.GRADIENT_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_XC_TAU_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on tau used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.XC.TAU_CUTOFF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_ADIABATIC_RESCALING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.ADIABATIC_RESCALING'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.HF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_VDW_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.VDW_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_WF_CORRELATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.WF_CORRELATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_FUNCTIONAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_FUNCTIONAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_GRID'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC_XC_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC.XC_POTENTIAL'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT(MSection):
    '''
    parameters needed to set up the Time Dependent Density Functional PT
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_CONVERGENCE = Quantity(
        type=str,
        shape=[],
        description='''
        The convergence of the eigenvalues
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.CONVERGENCE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_DIAG_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Diagonalization method used in tddfpt
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.DIAG_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_INVERT_S = Quantity(
        type=str,
        shape=[],
        description='''
        use the inverse of the overlap matrix
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.INVERT_S'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_KERNEL = Quantity(
        type=str,
        shape=[],
        description='''
        compute the kernel (debug purpose only)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.KERNEL'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_LSD_SINGLETS = Quantity(
        type=str,
        shape=[],
        description='''
        compute singlets using lsd vxc kernel
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.LSD_SINGLETS'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_MAX_KV = Quantity(
        type=str,
        shape=[],
        description='''
        maximal number of Krylov space vectors
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.MAX_KV'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_NEV = Quantity(
        type=str,
        shape=[],
        description='''
        number of excitations to calculate
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.NEV'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_NLUMO = Quantity(
        type=str,
        shape=[],
        description='''
        number of additional unoccupied orbitals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.NLUMO'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_NREORTHO = Quantity(
        type=str,
        shape=[],
        description='''
        number of reorthogonalization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.NREORTHO'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_OE_CORR = Quantity(
        type=str,
        shape=[],
        description='''
        Which type of orbital eigenvalue correction to use\\n(to yield better HOMO-LUMO
        energies)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.OE_CORR'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        use the preconditioner (only for Davidson)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_RES_ETYPE = Quantity(
        type=str,
        shape=[],
        description='''
        (singlets/triplets) for restricted calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.RES_ETYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_TDDFPT_RESTARTS = Quantity(
        type=str,
        shape=[],
        description='''
        maximal number subspace search restarts
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TDDFPT.RESTARTS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_SIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_SIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.SIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT_XC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT.XC'))


class x_cp2k_section_input_FORCE_EVAL_DFT_TRANSPORT(MSection):
    '''
    Specifies the parameters for transport, sets parameters for the OMEN code, see also
    http://www.nano-tcad.ethz.ch/
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TRANSPORT'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_BANDWIDTH = Quantity(
        type=str,
        shape=[],
        description='''
        The number of neighboring unit cells that one unit cell interacts with.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.BANDWIDTH'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_COLZERO_THRESHOLD = Quantity(
        type=str,
        shape=[],
        description='''
        The smallest number that is not zero in the full diagonalization part.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.COLZERO_THRESHOLD'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_CORES_PER_NODE = Quantity(
        type=str,
        shape=[],
        description='''
        Number of cores per node.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.CORES_PER_NODE'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_DENSITY_MATRIX_CONSTRUCTION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method used for constructing the density matrix
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.DENSITY_MATRIX_CONSTRUCTION_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_ENERGY_INTERVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Average distance for big intervals in energy vector.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.ENERGY_INTERVAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_EPS_DECAY = Quantity(
        type=str,
        shape=[],
        description='''
        The smallest imaginary part that a decaying eigenvalue may have not to be
        considered as propagating.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.EPS_DECAY'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_EPS_EIGVAL_DEGEN = Quantity(
        type=str,
        shape=[],
        description='''
        Filter for degenerate bands in the injection vector.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.EPS_EIGVAL_DEGEN'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_EPS_LIMIT = Quantity(
        type=str,
        shape=[],
        description='''
        The smallest eigenvalue that is kept.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.EPS_LIMIT'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_EPS_MU = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy to which the Fermi level should be determined.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.EPS_MU'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_EPS_SINGULARITY_CURVATURES = Quantity(
        type=str,
        shape=[],
        description='''
        Filter for degenerate bands in the bandstructure.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.EPS_SINGULARITY_CURVATURES'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_MIN_INTERVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Smallest enery distance in energy vector.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.MIN_INTERVAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_N_ABSCISSAE = Quantity(
        type=str,
        shape=[],
        description='''
        The number of abscissae per integration interval on the real axis.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.N_ABSCISSAE'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_N_CELLS = Quantity(
        type=str,
        shape=[],
        description='''
        The number of unit cells.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.N_CELLS'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_N_DOF = Quantity(
        type=str,
        shape=[],
        description='''
        Number of degrees of freedom for the contact unit cell.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.N_DOF'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_N_KPOINTS = Quantity(
        type=str,
        shape=[],
        description='''
        The number of k points for determination of the singularities.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.N_KPOINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_NUM_CONTACTS = Quantity(
        type=str,
        shape=[],
        description='''
        The number of contacts.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.NUM_CONTACTS'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_NUM_INTERVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Max number of energy points per small interval.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.NUM_INTERVAL'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_TASKS_PER_POINT = Quantity(
        type=str,
        shape=[],
        description='''
        Number of tasks per energy point.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.TASKS_PER_POINT'))

    x_cp2k_input_FORCE_EVAL_DFT_TRANSPORT_TEMPERATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Temperature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.TRANSPORT.TEMPERATURE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_LOCALIZE(MSection):
    '''
    Use one of the available methods to define the localization  and possibly to optimize
    it to a minimum or a maximum.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.LOCALIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_CRAZY_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scale angles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.CRAZY_SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_CRAZY_USE_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Use diagonalization (slow) or pade based calculation of matrix exponentials.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.CRAZY_USE_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_ENERGY_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Select the orbitals to be localized within the given energy range.This type of
        selection cannot be added on top of the selection through a LIST. It reads to
        reals that are lower and higher boundaries of the energy range.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.ENERGY_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_EPS_LOCALIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance used in the convergence criterium of the localization methods.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.EPS_LOCALIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_EPS_OCCUPATION = Quantity(
        type=str,
        shape=[],
        description='''
        Tolerance in the occupation number to select only fully occupied orbitals for the
        rotation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.EPS_OCCUPATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_JACOBI_FALLBACK = Quantity(
        type=str,
        shape=[],
        description='''
        Use Jacobi method in case no convergence was achieved by using the crazy rotations
        method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.JACOBI_FALLBACK'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_LIST_UNOCCUPIED = Quantity(
        type=str,
        shape=[],
        description='''
        Indexes of the unoccupied states to be localized, up to now only valid in
        combination with GPW. This keyword has to be present if unoccupied states should
        be localized. This keyword can be repeated several times(useful if you have to
        specify many indexes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.LIST_UNOCCUPIED'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Indexes of the occupied wfn to be localizedThis keyword can be repeated several
        times(useful if you have to specify many indexes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_LOCHOMO_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        File name where to read the MOS fromwhich to restart the localization procedure
        for occupied states
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.LOCHOMO_RESTART_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_LOCLUMO_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        File name where to read the MOS fromwhich to restart the localization procedure
        for unoccupied states
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.LOCLUMO_RESTART_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_MAX_CRAZY_ANGLE = Quantity(
        type=str,
        shape=[],
        description='''
        Largest allowed angle for the crazy rotations algorithm (smaller is slower but
        more stable).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.MAX_CRAZY_ANGLE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations used for localization methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method of optimization if any
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_MIN_OR_MAX = Quantity(
        type=str,
        shape=[],
        description='''
        Requires the maximization of the spread of the wfn
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.MIN_OR_MAX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_OPERATOR = Quantity(
        type=str,
        shape=[],
        description='''
        Type of opertator which defines the spread functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.OPERATOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_OUT_ITER_EACH = Quantity(
        type=str,
        shape=[],
        description='''
        Every how many iterations of the localization algorithm(Jacobi) the tolerance
        value is printed out
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.OUT_ITER_EACH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        Restart the localization from a set of orbitals read from a localization restart
        file.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.RESTART'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the MOS localization procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_STATES = Quantity(
        type=str,
        shape=[],
        description='''
        Which states to localize, LUMO up to now only available in GPW
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.STATES'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_LOCALIZE_USE_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Generate an improved initial guess based on a history of results, which is useful
        during MD.Will only work if the number of states to be localized remains constant.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.LOCALIZE.USE_HISTORY'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON(MSection):
    '''
    Settings for DAVIDSON
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_CONV_MOS_PERCENT = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal percent of MOS that have to converge within the Davidson loop before the
        SCF iteration is completed and a new Hamiltonian is computed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.CONV_MOS_PERCENT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (0.001 doing normally fine). For the
        other preconditioners, making this value larger (0.2) will tame the preconditioner
        in case of poor initial guesses.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_FIRST_PREC = Quantity(
        type=str,
        shape=[],
        description='''
        First SCF iteration at which a Preconditioner is employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.FIRST_PREC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_NEW_PREC_EACH = Quantity(
        type=str,
        shape=[],
        description='''
        Number of SCF iterations after which a new Preconditioner is computed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.NEW_PREC_EACH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON_SPARSE_MOS = Quantity(
        type=str,
        shape=[],
        description='''
        Use MOS as sparse matrix and avoid as much as possible multiplications with full
        matrices
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON.SPARSE_MOS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING(MSection):
    '''
    Define type and parameters for mixingprocedures to be applied to the density matrix.
    Normally, only one type of mixing method should be accepted. The mixing procedures
    activated by this section are only active for diagonalization methods, i.e. not with
    minimization methods based on OT.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be included
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Denominator parameter in Kerker damping introduced to suppress charge sloshing:
        rho_mix(g) =rho_in(g) + alpha*g^2/(g^2 + beta^2)*(rho_out(g)-rho_in(g))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_W0 = Quantity(
        type=str,
        shape=[],
        description='''
        w0 parameter used in Broyden mixing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_W0'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_WMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WMAX
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_WMAX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_BROY_WREF = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WREF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.BROY_WREF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_MAX_GVEC_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Restricts the G-space mixing to lower part of G-vector spectrum, up to a G0, by
        assigning the exponent of the Gaussian that can be represented by vectors smaller
        than G0 within a certain accuracy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.MAX_GVEC_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_MAX_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        Upper bound for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.MAX_STEP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_N_SIMPLE_MIX = Quantity(
        type=str,
        shape=[],
        description='''
        Number of kerker damping iterations before starting other mixing procedures
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.N_SIMPLE_MIX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NBUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of previous steps stored for the actual mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NBUFFER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NMIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal number of density mixing (should be greater than 0),before starting DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NMIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_NSKIP = Quantity(
        type=str,
        shape=[],
        description='''
        Number of initial iteration for which the mixing is skipped
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.NSKIP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_PULAY_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be added to the Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.PULAY_ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_PULAY_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of residual contribution to be added to Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.PULAY_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_R_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Control factor for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.R_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_REGULARIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Regularization parameter to stabilize the inversion of the residual matrix {Yn^t
        Yn} in the multisecant mixing scheme (noise)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.REGULARIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the mixing procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF(MSection):
    '''
    Activation of self-consistenf subspace refinement by diagonalization of H by adjusting
    the occupation but keeping the MOS unchanged.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_ADAPT_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Required density matrix accuracy as compared to current SCF convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_ADAPT_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_ENE = Quantity(
        type=str,
        shape=[],
        description='''
        Required energy accuracy for convergence of subspace diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_ENE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_EPS_SKIP_SUB_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Level of convergence to be reached before starting the internal loop of subspace
        rotations. Above this threshold only the outer diagonalization method is used.  If
        negative the subspace rotation is started at the first iteration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.EPS_SKIP_SUB_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations for the SCF inner loop
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of inner SCF loop to refine occupations in MOS subspace
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF_MIXING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF.MIXING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV(MSection):
    '''
    Settings for KRYLOV
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV_CHECK_MOS_CONV = Quantity(
        type=str,
        shape=[],
        description='''
        This requires to check the convergence of MOS also when standard diagonalization
        steps are performed, if the block krylov approach is active.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV.CHECK_MOS_CONV'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV_EPS_KRYLOV = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence criterion for the MOs
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV.EPS_KRYLOV'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV_EPS_STD_DIAG = Quantity(
        type=str,
        shape=[],
        description='''
        Level of convergence to be reached before starting the Lanczos procedure. Above
        this threshold a standard diagonalization method is used.  If negative Lanczos is
        started at the first iteration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV.EPS_STD_DIAG'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV_NBLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the block of vectors refined simultaneously by the Lanczos procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV.NBLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV_NKRYLOV = Quantity(
        type=str,
        shape=[],
        description='''
        Dimension of the Krylov space used for the Lanczos refinement
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV.NKRYLOV'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT(MSection):
    '''
    Sets the various options for the orbital transformation (OT) method. Default settings
    already provide an efficient, yet robust method. Most systems benefit from using the
    FULL_ALL preconditioner combined with a small value (0.001) of ENERGY_GAP.Well-behaved
    systems might benefit from using a DIIS minimizer.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for OT
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_ADAPTIVE_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Enable adaptive curvature estimation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_ADAPTIVE_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Underrelaxation for the broyden mixer
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_ENABLE_FLIP = Quantity(
        type=str,
        shape=[],
        description='''
        Ensure positive definite update
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_ENABLE_FLIP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_ETA = Quantity(
        type=str,
        shape=[],
        description='''
        Dampening of estimated energy curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_ETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_FORGET_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Forget history on bad approximation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_FORGET_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Backtracking parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Growth limit of curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA_DECREASE = Quantity(
        type=str,
        shape=[],
        description='''
        Reduction of curvature on bad approximation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA_DECREASE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA_MIN = Quantity(
        type=str,
        shape=[],
        description='''
        Minimum adaptive curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA_MIN'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_BROYDEN_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Curvature of energy functional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.BROYDEN_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ENERGIES = Quantity(
        type=str,
        shape=[],
        description='''
        Optimize orbital energies for use in Fermi-Dirac smearing (requires ROTATION and
        FD smearing to be active).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ENERGIES'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (can be a small number, e.g. 0.002).
        FULL_SINGLE_INVERSE takes it as lower bound (values below 0.05 can cause stability
        issues). In general, heigher values will tame the preconditioner in case of poor
        initial guesses. A negative value will leave the choice to CP2K depending on type
        of preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_EPS_IRAC_FILTER_MATRIX = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the threshold for filtering the matrices.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.EPS_IRAC_FILTER_MATRIX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_EPS_IRAC_QUICK_EXIT = Quantity(
        type=str,
        shape=[],
        description='''
        Only one extra refinement iteration is done when the norm is below this value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.EPS_IRAC_QUICK_EXIT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_EPS_IRAC_SWITCH = Quantity(
        type=str,
        shape=[],
        description='''
        The algorithm switches to the polynomial refinement when the norm is below this
        value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.EPS_IRAC_SWITCH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_EPS_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Targeted accuracy during the refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.EPS_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_EPS_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy of the taylor expansion for the matrix functions, should normally
        be kept as is.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.EPS_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_GOLD_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        Target relative uncertainty in the location of the minimum for LINESEARCH GOLD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.GOLD_TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_IRAC_DEGREE = Quantity(
        type=str,
        shape=[],
        description='''
        The refinement polynomial degree (2, 3 or 4).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.IRAC_DEGREE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_LINESEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        1D line search algorithm to be used with the OT minimizer, in increasing order of
        robustness and cost. MINIMIZER CG combined with LINESEARCH GOLD should always find
        an electronic minimum.  Whereas the 2PNT minimizer is almost always OK, 3PNT might
        be needed for systems in which successive OT CG steps do not decrease the total
        energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.LINESEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_MAX_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.MAX_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_MAX_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum order of the Taylor expansion before diagonalisation is prefered, for
        large parallel runs a slightly higher order could sometimes result in a small
        speedup.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.MAX_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_MINIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Minimizer to be used with the OT method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.MINIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_MIXED_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a mixed precision algorithm.With a well behaved basis set (i.e. condition
        number less than 1/eps_sp)it provides double precision accuracy results and up to
        a 2 fold speedup for building and applying the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.MIXED_PRECISION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_N_HISTORY_VEC = Quantity(
        type=str,
        shape=[],
        description='''
        Number of history vectors to be used with DIIS or BROYDEN
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.N_HISTORY_VEC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_NONDIAG_ENERGY_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        The prefactor for the non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.NONDIAG_ENERGY_STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_NONDIAG_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Add a non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.NONDIAG_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_OCCUPATION_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Preconditioner with the occupation numbers (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.OCCUPATION_PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ON_THE_FLY_LOC = Quantity(
        type=str,
        shape=[],
        description='''
        On the fly localization of the molecular orbitals. Can only be used with OT/IRAC.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ON_THE_FLY_LOC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ORTHO_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        The orthogonality method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ORTHO_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes. They differ in
        effectiveness, cost of construction, cost of application. Properly preconditioned
        minimization can be orders of magnitude faster than doing nothing.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_ROTATION = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional variables so that rotations of the occupied subspace are
        allowed as well, only needed for cases where the energy is not invariant under  a
        rotation of the occupied subspace such as non-singlet restricted calculations  or
        fractional occupations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.ROTATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_SAFE_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Reject DIIS steps if they point away from the minimum, do SD in that case.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.SAFE_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_SCP_NDDO = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional self-consistent polarization through response basis set =
        orbital basis set for NDDO.)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.SCP_NDDO'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the ot method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT_STEPSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial stepsize used for the line search, sometimes this parameter can be reduced
        to stablize DIIS or to improve the CG behavior in the first few steps. The optimal
        value depends on the quality of the preconditioner. A negative values leaves the
        choice to CP2K depending on the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT.STEPSIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION(MSection):
    '''
    Set up type and parameters for Kohn-Sham matrix diagonalization.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_EPS_ADAPT = Quantity(
        type=str,
        shape=[],
        description='''
        Required accuracy in iterative diagonalization as compared to current SCF
        convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.EPS_ADAPT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_EPS_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Required accuracy in iterative diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.EPS_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_EPS_JACOBI = Quantity(
        type=str,
        shape=[],
        description='''
        Below this threshold value for the SCF convergence the pseudo-diagonalization
        method using Jacobi rotations is activated. This method is much faster than a real
        diagonalization and it is even speeding up while achieving full
        convergence.However, it needs a pre-converged wavefunction obtained by at least
        one real diagonalization which is further optimized while keeping the original
        eigenvalue spectrum. The MO eigenvalues are NOT updated. The method might be
        useful to speed up calculations for large systems e.g. using a semi-empirical
        method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.EPS_JACOBI'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_JACOBI_THRESHOLD = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the accuracy of the pseudo-diagonalization method using Jacobi rotations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.JACOBI_THRESHOLD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations in iterative diagonalization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the diagonalization method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DAVIDSON'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DAVIDSON'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_DIAG_SUB_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.DIAG_SUB_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_KRYLOV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.KRYLOV'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION_OT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION.OT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_MIXING(MSection):
    '''
    Define type and parameters for mixingprocedures to be applied to the density matrix.
    Normally, only one type of mixing method should be accepted. The mixing procedures
    activated by this section are only active for diagonalization methods, i.e. not with
    minimization methods based on OT.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.MIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be included
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Denominator parameter in Kerker damping introduced to suppress charge sloshing:
        rho_mix(g) =rho_in(g) + alpha*g^2/(g^2 + beta^2)*(rho_out(g)-rho_in(g))
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_BROY_W0 = Quantity(
        type=str,
        shape=[],
        description='''
        w0 parameter used in Broyden mixing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.BROY_W0'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_BROY_WMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WMAX
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.BROY_WMAX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_BROY_WREF = Quantity(
        type=str,
        shape=[],
        description='''
        Settings for BROY_WREF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.BROY_WREF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_MAX_GVEC_EXP = Quantity(
        type=str,
        shape=[],
        description='''
        Restricts the G-space mixing to lower part of G-vector spectrum, up to a G0, by
        assigning the exponent of the Gaussian that can be represented by vectors smaller
        than G0 within a certain accuracy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.MAX_GVEC_EXP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_MAX_STEP = Quantity(
        type=str,
        shape=[],
        description='''
        Upper bound for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.MAX_STEP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Mixing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_N_SIMPLE_MIX = Quantity(
        type=str,
        shape=[],
        description='''
        Number of kerker damping iterations before starting other mixing procedures
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.N_SIMPLE_MIX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_NBUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of previous steps stored for the actual mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.NBUFFER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_NMIXING = Quantity(
        type=str,
        shape=[],
        description='''
        Minimal number of density mixing (should be greater than 0),before starting DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.NMIXING'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_NSKIP = Quantity(
        type=str,
        shape=[],
        description='''
        Number of initial iteration for which the mixing is skipped
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.NSKIP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_PULAY_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of new density to be added to the Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.PULAY_ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_PULAY_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of residual contribution to be added to Pulay expansion
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.PULAY_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_R_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Control factor for the magnitude of the unpredicted step size in the update by the
        multisecant mixing scheme
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.R_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_REGULARIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Regularization parameter to stabilize the inversion of the residual matrix {Yn^t
        Yn} in the multisecant mixing scheme (noise)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.REGULARIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MIXING_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the mixing procedure
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MIXING.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OT(MSection):
    '''
    Sets the various options for the orbital transformation (OT) method. Default settings
    already provide an efficient, yet robust method. Most systems benefit from using the
    FULL_ALL preconditioner combined with a small value (0.001) of ENERGY_GAP.Well-behaved
    systems might benefit from using a DIIS minimizer.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.OT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ALGORITHM = Quantity(
        type=str,
        shape=[],
        description='''
        Algorithm to be used for OT
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ALGORITHM'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_ADAPTIVE_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Enable adaptive curvature estimation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_ADAPTIVE_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Underrelaxation for the broyden mixer
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_ENABLE_FLIP = Quantity(
        type=str,
        shape=[],
        description='''
        Ensure positive definite update
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_ENABLE_FLIP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_ETA = Quantity(
        type=str,
        shape=[],
        description='''
        Dampening of estimated energy curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_ETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_FORGET_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Forget history on bad approximation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_FORGET_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Backtracking parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Growth limit of curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_SIGMA_DECREASE = Quantity(
        type=str,
        shape=[],
        description='''
        Reduction of curvature on bad approximation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_SIGMA_DECREASE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_SIGMA_MIN = Quantity(
        type=str,
        shape=[],
        description='''
        Minimum adaptive curvature.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_SIGMA_MIN'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_BROYDEN_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Curvature of energy functional.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.BROYDEN_SIGMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ENERGIES = Quantity(
        type=str,
        shape=[],
        description='''
        Optimize orbital energies for use in Fermi-Dirac smearing (requires ROTATION and
        FD smearing to be active).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ENERGIES'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ENERGY_GAP = Quantity(
        type=str,
        shape=[],
        description='''
        Should be an estimate for the energy gap [a.u.] (HOMO-LUMO) and is used in
        preconditioning, especially effective with the FULL_ALL preconditioner, in which
        case it should be an underestimate of the gap (can be a small number, e.g. 0.002).
        FULL_SINGLE_INVERSE takes it as lower bound (values below 0.05 can cause stability
        issues). In general, heigher values will tame the preconditioner in case of poor
        initial guesses. A negative value will leave the choice to CP2K depending on type
        of preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ENERGY_GAP'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_EPS_IRAC_FILTER_MATRIX = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the threshold for filtering the matrices.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.EPS_IRAC_FILTER_MATRIX'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_EPS_IRAC_QUICK_EXIT = Quantity(
        type=str,
        shape=[],
        description='''
        Only one extra refinement iteration is done when the norm is below this value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.EPS_IRAC_QUICK_EXIT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_EPS_IRAC_SWITCH = Quantity(
        type=str,
        shape=[],
        description='''
        The algorithm switches to the polynomial refinement when the norm is below this
        value.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.EPS_IRAC_SWITCH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_EPS_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Targeted accuracy during the refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.EPS_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_EPS_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy of the taylor expansion for the matrix functions, should normally
        be kept as is.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.EPS_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_GOLD_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        Target relative uncertainty in the location of the minimum for LINESEARCH GOLD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.GOLD_TARGET'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_IRAC_DEGREE = Quantity(
        type=str,
        shape=[],
        description='''
        The refinement polynomial degree (2, 3 or 4).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.IRAC_DEGREE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_LINESEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        1D line search algorithm to be used with the OT minimizer, in increasing order of
        robustness and cost. MINIMIZER CG combined with LINESEARCH GOLD should always find
        an electronic minimum.  Whereas the 2PNT minimizer is almost always OK, 3PNT might
        be needed for systems in which successive OT CG steps do not decrease the total
        energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.LINESEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_MAX_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed refinement iteration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.MAX_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_MAX_TAYLOR = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum order of the Taylor expansion before diagonalisation is prefered, for
        large parallel runs a slightly higher order could sometimes result in a small
        speedup.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.MAX_TAYLOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_MINIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Minimizer to be used with the OT method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.MINIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_MIXED_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a mixed precision algorithm.With a well behaved basis set (i.e. condition
        number less than 1/eps_sp)it provides double precision accuracy results and up to
        a 2 fold speedup for building and applying the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.MIXED_PRECISION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_N_HISTORY_VEC = Quantity(
        type=str,
        shape=[],
        description='''
        Number of history vectors to be used with DIIS or BROYDEN
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.N_HISTORY_VEC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_NONDIAG_ENERGY_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        The prefactor for the non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.NONDIAG_ENERGY_STRENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_NONDIAG_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Add a non-diagonal energy penalty (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.NONDIAG_ENERGY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_OCCUPATION_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Preconditioner with the occupation numbers (FD smearing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.OCCUPATION_PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ON_THE_FLY_LOC = Quantity(
        type=str,
        shape=[],
        description='''
        On the fly localization of the molecular orbitals. Can only be used with OT/IRAC.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ON_THE_FLY_LOC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ORTHO_IRAC = Quantity(
        type=str,
        shape=[],
        description='''
        The orthogonality method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ORTHO_IRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_PRECOND_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        How the preconditioner is applied to the residual.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.PRECOND_SOLVER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_PRECONDITIONER = Quantity(
        type=str,
        shape=[],
        description='''
        Type of preconditioner to be used with all minimization schemes. They differ in
        effectiveness, cost of construction, cost of application. Properly preconditioned
        minimization can be orders of magnitude faster than doing nothing.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.PRECONDITIONER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_ROTATION = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional variables so that rotations of the occupied subspace are
        allowed as well, only needed for cases where the energy is not invariant under  a
        rotation of the occupied subspace such as non-singlet restricted calculations  or
        fractional occupations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.ROTATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_SAFE_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Reject DIIS steps if they point away from the minimum, do SD in that case.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.SAFE_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_SCP_NDDO = Quantity(
        type=str,
        shape=[],
        description='''
        Introduce additional self-consistent polarization through response basis set =
        orbital basis set for NDDO.)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.SCP_NDDO'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the ot method
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OT_STEPSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Initial stepsize used for the line search, sometimes this parameter can be reduced
        to stablize DIIS or to improve the CG behavior in the first few steps. The optimal
        value depends on the quality of the preconditioner. A negative values leaves the
        choice to CP2K depending on the preconditioner.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OT.STEPSIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF(MSection):
    '''
    parameters controlling the outer SCF loop
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_BISECT_TRUST_COUNT = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of times the same point will be used in bisection, a small number
        guards against the effect of wrongly converged states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.BISECT_TRUST_COUNT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_DIIS_BUFFER_LENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of DIIS vectors used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.DIIS_BUFFER_LENGTH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        The target gradient of the outer scf variables. Notice that the EPS_SCF of the
        inner loop also determines the value that can be reached in the outer loop,
        typically EPS_SCF of the outer loop must be smaller than EPS_SCF of the inner
        loop.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_EXTRAPOLATION_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Number of past states used in the extrapolation of the variables during e.g. MD
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.EXTRAPOLATION_ORDER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_MAX_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        The maximum number of outer loops
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.MAX_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_OPTIMIZER = Quantity(
        type=str,
        shape=[],
        description='''
        Method used to bring the outer loop to a stationary point
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.OPTIMIZER'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of the outer SCF loop
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_STEP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        The initial step_size used in the optimizer (currently steepest descent).Note that
        in cases where a sadle point is sought for (DDAPC_CONSTRAINT), this can be
        negative
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.STEP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies which kind of outer SCF should be employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF.TYPE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR(MSection):
    '''
    Define the smearing of the MO occupation numbers
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_ELECTRONIC_TEMPERATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Electronic temperature in the case of Fermi-Dirac smearing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.ELECTRONIC_TEMPERATURE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_EPS_FERMI_DIRAC = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy checks on occupation numbers use this as a tolerance
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.EPS_FERMI_DIRAC'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_FIXED_MAGNETIC_MOMENT = Quantity(
        type=str,
        shape=[],
        description='''
        Imposed difference between the numbers of electrons of spin up and spin down: m =
        n(up) - n(down). A negative value (default) allows for a change of the magnetic
        moment. -1 specifically keeps an integer number of spin up and spin down
        electrons.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.FIXED_MAGNETIC_MOMENT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        A list of fractional occupations to use. Must match the number of states and sum
        up to the correct number of electrons
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Smearing method to be applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of smearing
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR_WINDOW_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the energy window centred at the Fermi level
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR.WINDOW_SIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF(MSection):
    '''
    parameters needed perform an scf run
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_ADDED_MOS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of additional MOS added for each spin
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.ADDED_MOS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_CHOLESKY = Quantity(
        type=str,
        shape=[],
        description='''
        If the cholesky method should be used for computing the inverse of S, and in this
        case calling which Lapack routines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.CHOLESKY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_EPS_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold on the convergence to start using DIAG/DIIS
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.EPS_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_EPS_EIGVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Throw away linear combinations of basis functions with a small eigenvalue in S
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.EPS_EIGVAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_EPS_LUMO = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy of the computation of the lumo energy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.EPS_LUMO'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_EPS_SCF_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy for the scf convergence after the history pipeline is filled
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.EPS_SCF_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_EPS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy for the scf convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.EPS_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_LEVEL_SHIFT = Quantity(
        type=str,
        shape=[],
        description='''
        Use level shifting to improve convergence
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.LEVEL_SHIFT'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MAX_DIIS = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of DIIS vectors to be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MAX_DIIS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MAX_ITER_LUMO = Quantity(
        type=str,
        shape=[],
        description='''
        The maximum number of iteration for the lumo computation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MAX_ITER_LUMO'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MAX_SCF_HISTORY = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCF iterations after the history pipeline is filled
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MAX_SCF_HISTORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_MAX_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of SCF iteration to be performed for one optimization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.MAX_SCF'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_NCOL_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Sets the number of columns in a scalapack block
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.NCOL_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_NROW_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        sets the number of rows in a scalapack block
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.NROW_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_ROKS_F = Quantity(
        type=str,
        shape=[],
        description='''
        Allows to define the parameter f for the general ROKS scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.ROKS_F'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_ROKS_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Allows to define all parameters for the high-spin ROKS scheme explicitly. The full
        set of 6 parameters has to be specified in the order acc, bcc, aoo, boo, avv, bvv
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.ROKS_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_ROKS_SCHEME = Quantity(
        type=str,
        shape=[],
        description='''
        Selects the ROKS scheme when ROKS is applied.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.ROKS_SCHEME'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SCF_SCF_GUESS = Quantity(
        type=str,
        shape=[],
        description='''
        Change the initial guess for the wavefunction.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SCF.SCF_GUESS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_DIAGONALIZATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.DIAGONALIZATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_MIXING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_MIXING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.MIXING'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.OT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_OUTER_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.OUTER_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF_SMEAR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF.SMEAR'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XAS(MSection):
    '''
    Sets the method of choice to calculate core-level excitation spectra. The occupied
    states from  which we calculate the excitation should be specified. Localization of
    the orbitals may be useful.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_ADDED_MOS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of additional MOS added spin up only
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.ADDED_MOS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_ATOMS_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Indexes of the atoms to be excitedThis keyword can be repeated several
        times(useful if you have to specify many indexes).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.ATOMS_LIST'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_DIPOLE_FORM = Quantity(
        type=str,
        shape=[],
        description='''
        Type of integral to get the oscillator strengths in the diipole approximation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.DIPOLE_FORM'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_EPS_ADDED = Quantity(
        type=str,
        shape=[],
        description='''
        target accuracy incalculation of the added orbitals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.EPS_ADDED'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_MAX_ITER_ADDED = Quantity(
        type=str,
        shape=[],
        description='''
        maximum number of iteration in calculation of added orbitals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.MAX_ITER_ADDED'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method to be used to calculate core-level excitation spectra
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_NGAUSS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of gto's for the expansion of the stoof the type given by STATE_TYPE
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.NGAUSS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_RESTART = Quantity(
        type=str,
        shape=[],
        description='''
        Restart the excited state if the restart file exists
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.RESTART'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        controls the activation of core-level spectroscopy simulations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_STATE_SEARCH = Quantity(
        type=str,
        shape=[],
        description='''
        # of states where to look for the one to be excited
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.STATE_SEARCH'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_STATE_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of the orbitas that are excited for the xas spectra calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.STATE_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_WFN_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Root of the file names where to read the MOS fromwhich to restart the calculation
        of the core level excited states
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.WFN_RESTART_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_XAS_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Occupation of the core state in XAS calculation by TP_FLEX.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.XAS_CORE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_XAS_TOT_EL = Quantity(
        type=str,
        shape=[],
        description='''
        Total number of electrons for spin channel alpha, in XAS calculation by TP_FLEX.If
        negative value, the number of electrons is set to GS number of electron  minus the
        amount subtracted from the core state
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.XAS_TOT_EL'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_XES_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Occupation of the core state in XES calculation by TP_VAL.The homo is emptied by
        the same amount
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.XES_CORE'))

    x_cp2k_input_FORCE_EVAL_DFT_XAS_XES_EMPTY_HOMO = Quantity(
        type=str,
        shape=[],
        description='''
        Set the occupation of the HOMO in XES calculation by TP_VAL.The HOMO can be
        emptied or not, if the core is still full
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XAS.XES_EMPTY_HOMO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_LOCALIZE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_LOCALIZE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.LOCALIZE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS.SCF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING(MSection):
    '''
    Parameters for self interation corrected hybrid functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING_FUNCTIONAL_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        Which model for the coupling constant integration should be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING.FUNCTIONAL_MODEL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which Hybrid functional should be used. (Has to be consistent with the definitions
        in XC and HF).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING.FUNCTIONAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        The point to be used along the adiabatic curve (0 &#60; λ &#60; 1)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Long-range parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING.OMEGA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.HF_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HF_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.HFX_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.LOAD_BALANCE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.FRACTION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.PW_HFX'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.HF_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.HFX_RI'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.LOAD_BALANCE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.MEMORY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.PERIODIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF.SCREENING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL(MSection):
    '''
    Information on the non local dispersion functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the FFT grid used in the calculation of the nonlocal vdW functional
        [Ry].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL_KERNEL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the kernel data file, may include a path.vdW_kernel_table.dat is for DRSLL
        and LMKLL andrVV10_kernel_table.dat is for rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL.KERNEL_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Parameters b and C of the rVV10 functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of functional (the corresponding kernel data file should be selected).Allows
        for common forms such as vdW-DF, vdW-DF2, optB88-vdW, rVV10.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL.TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for non local functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL.VERBOSE_OUTPUT'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD(MSection):
    '''
    Controls the printing of some info about DFTD contributions
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL(MSection):
    '''
    Information on the pair potential to calculate dispersion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOM_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number of a set of atoms for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOM_COORDINATION_NUMBERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_ATOMPARM = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies parameters for atom types (in atomic units). If not provided default
        parameters are used (DFT-D2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.ATOMPARM'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_CALCULATE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.CALCULATE_C9_TERM'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,sr6,s8) for the DFT-D3 method, if
        set to zero CP2K attempts to guess the xc functional from REFERENCE_FUNCTIONAL and
        sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_D3BJ_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameters (s6,a1,s8,a2) for the DFT-D3(BJ)
        method, if set to zero CP2K attempts to guess the xc functional from
        REFERENCE_FUNCTIONAL and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.D3BJ_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EPS_CN = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff value for coordination number function (DFT-D3 method)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EPS_CN'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_EXP_PRE = Quantity(
        type=str,
        shape=[],
        description='''
        Prefactor in exponential damping factor (DFT-D2 potential)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.EXP_PRE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_KIND_COORDINATION_NUMBERS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the coordination number for a kind for the C9 term in DFT-D3.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.KIND_COORDINATION_NUMBERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_LONG_RANGE_CORRECTION = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate a long range correction to the DFT-D3 model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.LONG_RANGE_CORRECTION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PARAMETER_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the parameter file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PARAMETER_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_R_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Range of potential. The cutoff will be 2 times this value
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.R_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_C9_TERM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate C9 terms in DFT-D3 model using reference coordination numbers
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_C9_TERM'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_REFERENCE_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Use parameters for this specific density functional. For available D3 and D3(BJ)
        parameters see: http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionals.html,
        http://www.thch.uni-bonn.de/tc/downloads/DFT-D3/functionalsbj.html
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.REFERENCE_FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        XC Functional dependent scaling parameter, if set to zero CP2K attempts to guess
        the xc functional that is in use and sets the associated scaling parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_VERBOSE_OUTPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Extensive output for the DFT-D2 and DFT-D3 models
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.VERBOSE_OUTPUT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL_PRINT_DFTD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL.PRINT_DFTD'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL(MSection):
    '''
    This section combines all possible additional dispersion corrections to the normal XC
    functionals. This can be more functionals or simple empirical pair potentials.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of dispersion/vdW functional or potential to use
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_NON_LOCAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.NON_LOCAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL_PAIR_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL.PAIR_POTENTIAL'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CPHF(MSection):
    '''
    Parameters influencing the solution of the Z-vector equations in MP2 gradients
    calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.CPHF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CPHF_EPS_CONV = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence threshold for the solution of the Z-vector equations. The Z-vector
        equations have the form of a linear system of equations Ax=b, convergence is
        achieved when |Ax-b|<=EPS_CONV.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.CPHF.EPS_CONV'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CPHF_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iterations allowed for the solution of the Z-vector equations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.CPHF.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_DIRECT_CANONICAL(MSection):
    '''
    Parameters influencing the direct canonical method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_DIRECT_CANONICAL_BIG_SEND = Quantity(
        type=str,
        shape=[],
        description='''
        Send big messages between processes (useful for >48 processors).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.DIRECT_CANONICAL.BIG_SEND'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL(MSection):
    '''
    Parameters the interaction potential in computing the biel integrals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, TShPSC operator).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TRUNCATION_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines truncation radius for the truncated TShPSC potential. Only valid when
        doing truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TRUNCATION_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL_TSHPSC_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file TShPSC.dat that contains the data for the evaluation of the
        TShPSC G0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.INTERACTION_POTENTIAL.TSHPSC_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO(MSection):
    '''
    Controls the printing basic info about MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS(MSection):
    '''
    Parameters influencing the optimization of the RI MP2 basis. Only exponents of non-
    contracted auxiliary basis can be optimized. An initial RI auxiliary basis has to be
    specified.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_BASIS_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the size of the auxiliary basis set automatically generated as initial
        guess. This will be effective only if RI_AUX_BASIS_SET in the KIND section and
        NUM_FUNC are not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.BASIS_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_I_REL = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the relative deviation of the amplitudes calculated with and
        without RI approximation, (more details in Chem.Phys.Lett.294(1998)143).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_I_REL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_DELTA_RI = Quantity(
        type=str,
        shape=[],
        description='''
        Target accuracy in the absolute difference between the RI-MP2 and the exact MP2
        energy, DRI=ABS(E_MP2-E_RI-MP2).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.DELTA_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_EPS_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The derivatives of the MP2 energy with respect to the exponents of the basis are
        calculated numerically. The change in the exponent a_i employed for the numerical
        evaluation is defined as h_i=EPS_DERIV*a_i.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.EPS_DERIV'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the maximum number of steps in the RI basis optimization.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS_NUM_FUNC = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of function, for each angular momentum (s, p, d ...),
        employed in the automatically generated initial guess. This will be effective only
        if RI_AUX_BASIS_SET in the KIND section is not specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS.NUM_FUNC'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_LAPLACE(MSection):
    '''
    Parameters influencing the RI-SOS-MP2-Laplace method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_LAPLACE_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-SOS-
        MP2-Laplace method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_LAPLACE.QUADRATURE_POINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_LAPLACE_SIZE_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for the integration in the Laplace method, that is the number of
        processes involved in the computation of each integration point. SIZE_INTEG_GROUP
        has to be a multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1)
        is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_LAPLACE.SIZE_INTEG_GROUP'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2(MSection):
    '''
    Parameters influencing the RI MP2 method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for communication in RI-MP2. Larger BLOCK_SIZE
        reduces communication but requires more memory. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_MP2.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2_EPS_CANONICAL = Quantity(
        type=str,
        shape=[],
        description='''
        Threshold for discriminate if a given ij pairs of the unrelaxed MP2 density matrix
        has to be calculated with a canonical reformulation based on the occupied
        eigenvalues differences.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_MP2.EPS_CANONICAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2_FREE_HFX_BUFFER = Quantity(
        type=str,
        shape=[],
        description='''
        Free the buffer containing the 4 center integrals used in the Hartree-Fock
        exchange calculation. This will be effective only for gradients calculations,
        since for the energy only case, the buffers are released by default. (Right now
        debugging only).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_MP2.FREE_HFX_BUFFER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO(MSection):
    '''
    Controls the printing basic info about hf method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI(MSection):
    '''
    All parameters needed in a HFX RI calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_OPTIMIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of iterative RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_OPTIMIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_EPS_SCREENING = Quantity(
        type=str,
        shape=[],
        description='''
        Accuracy of geminal integral evaluation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.EPS_SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum number of iteration in RI fit
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI.MAX_ITER'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL(MSection):
    '''
    Sets up interaction potential if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Determines cutoff radius for the truncated 1/r potential. Only valid when doing
        truncated calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for short/longrange interaction
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_POTENTIAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which interaction potential should be used (Coulomb, longrange or shortrange).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.POTENTIAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_COULOMB = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a coulomb potential. Only valid when
        doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_COULOMB'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_GAUSSIAN = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a gaussian potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_GAUSSIAN'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_SCALE_LONGRANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Scales Hartree-Fock contribution arising from a longrange potential. Only valid
        when doing a mixed potential calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.SCALE_LONGRANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL_T_C_G_DATA = Quantity(
        type=str,
        shape=[],
        description='''
        Location of the file t_c_g.dat that contains the data for the evaluation of the
        truncated gamma function
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL.T_C_G_DATA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE(MSection):
    '''
    Parameters influencing the load balancing of the HF
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_BLOCK_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the blocking used for the atomic quartet loops. A proper choice can
        speedup the calculation. The default (-1) is automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.BLOCK_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_NBINS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of bins per process used to group atom quartets.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.NBINS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE_RANDOMIZE = Quantity(
        type=str,
        shape=[],
        description='''
        This flag controls the randomization of the bin assignment to processes. For
        highly ordered input structures with a bad load balance, setting this flag to TRUE
        might improve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE.RANDOMIZE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY(MSection):
    '''
    Sets up memory parameters for the storage of the ERI's if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_EPS_STORAGE_SCALING = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor to scale eps_schwarz. Storage threshold for compression will be
        EPS_SCHWARZ*EPS_STORAGE_SCALING.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.EPS_STORAGE_SCALING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_DISK_SPACE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of disk space [MB] used to store precomputed compressed
        four-center integrals. If 0, nothing is stored to disk
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_DISK_SPACE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_MAX_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the maximum amount of memory [MB] to be consumed by the full HFX module.
        All temporary buffers and helper arrays are subtracted from this number. What
        remains will be used for storage of integrals. NOTE: This number is assumed to
        represent the memory available to one MPI process. When running a threaded
        version, cp2k automatically takes care of distributing the memory among all the
        threads within a process.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.MAX_MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_STORAGE_LOCATION = Quantity(
        type=str,
        shape=[],
        description='''
        Loaction where ERI's are stored if MAX_DISK_SPACE /=0 Expects a path to a
        directory.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.STORAGE_LOCATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY_TREAT_FORCES_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines whether the derivative ERI's should be stored to RAM or not. Only
        meaningful when performing Ehrenfest MD. Memory usage is defined via MAX_MEMORY,
        i.e. the memory is shared wit the energy ERI's.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY.TREAT_FORCES_IN_CORE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC(MSection):
    '''
    Sets up periodic boundary condition parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC_NUMBER_OF_SHELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of shells taken into account for periodicity. By default, cp2k tries to
        automatically evaluate this number. This algorithm might be to conservative,
        resulting in some overhead. You can try to adjust this number in order to make a
        calculation cheaper.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC.NUMBER_OF_SHELLS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING(MSection):
    '''
    Sets up screening parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold. This will be approximately the
        accuracy of the forces,  and should normally be similar to EPS_SCF
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ_FORCES'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_EPS_SCHWARZ = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the near field part of the electronic repulsion integrals using the
        Schwarz inequality for the given threshold.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.EPS_SCHWARZ'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_P_SCREEN_CORRECTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Recalculates integrals on the fly if the actual density matrix is larger by a
        given factor than the initial one. If the factor is set to 0.0_dp, this feature is
        disabled.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.P_SCREEN_CORRECTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_ON_INITIAL_P = Quantity(
        type=str,
        shape=[],
        description='''
        Screen on an initial density matrix. For the first MD step this matrix must be
        provided by a Restart File.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_ON_INITIAL_P'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING_SCREEN_P_FORCES = Quantity(
        type=str,
        shape=[],
        description='''
        Screens the electronic repulsion integrals for the forces using the density
        matrix. This results in a significant speedup for large systems, but might require
        a somewhat tigher EPS_SCHWARZ_FORCES.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING.SCREEN_P_FORCES'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF(MSection):
    '''
    Sets up the Hartree-Fock parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        The fraction of Hartree-Fock to add to the total energy. 1.0 implies standard
        Hartree-Fock if used with XC_FUNCTIONAL NONE. NOTE: In a mixed potential
        calculation this should be set to 1.0, otherwise all parts are multiplied with
        this factor.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.FRACTION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX_BLOCKSIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Improve the performance of pw_hfx at the cost of some additional memory by storing
        the realspace representation of PW_HFX_BLOCKSIZE states.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX_BLOCKSIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PW_HFX = Quantity(
        type=str,
        shape=[],
        description='''
        Compute the Hartree-Fock energy also in the plane wave basis.The value is ignored,
        and intended for debugging only.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.PW_HFX'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_TREAT_LSD_IN_CORE = Quantity(
        type=str,
        shape=[],
        description='''
        Determines how spin denisities are taken into account. If true, the beta spin
        density is included via a second in core call. If false, alpha and beta spins are
        done in one shot
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.TREAT_LSD_IN_CORE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HF_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HF_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_HFX_RI'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.HFX_RI'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_LOAD_BALANCE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.LOAD_BALANCE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_MEMORY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.MEMORY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_PERIODIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.PERIODIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF_SCREENING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF.SCREENING'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA(MSection):
    '''
    Parameters influencing the RI RPA method
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_MINIMAX_QUADRATURE = Quantity(
        type=str,
        shape=[],
        description='''
        Use the Minimax quadrature scheme for performing the numerical integration.
        Maximum number of quadrature point limited to 20.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.MINIMAX_QUADRATURE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_MM_STYLE = Quantity(
        type=str,
        shape=[],
        description='''
        Matrix multiplication style for the Q matrix.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.MM_STYLE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_QUADRATURE_POINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Number of quadrature points for the numerical integration in the RI-RPA method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.QUADRATURE_POINTS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_SIZE_FREQ_INTEG_GROUP = Quantity(
        type=str,
        shape=[],
        description='''
        Group size for frequency integration, that is the number of processes involved in
        the computation of each integration point. SIZE_FREQ_INTEG_GROUP has to be a
        multiple of GROUP_SIZE in the WF_CORRELATION section. The default (-1) is
        automatic.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.SIZE_FREQ_INTEG_GROUP'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA.HF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW(MSection):
    '''
    Parameters for the GPW approach in Wavefunction-based Correlation methods
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff of the finest grid level in the MP2 gpw integration.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW.CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW_EPS_FILTER = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the DBCSR based multiply (usually 10 times smaller than
        EPS_GRID).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW.EPS_FILTER'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW_EPS_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Determines a threshold for the GPW based integration
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW.EPS_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW_PRINT_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        How much output is written by the individual groups.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW.PRINT_LEVEL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Determines the grid at which a Gaussian is mapped.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW.REL_CUTOFF'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION(MSection):
    '''
    Sets up the Wavefunction-based Correlation parameters if requested
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CALC_COND_NUM = Quantity(
        type=str,
        shape=[],
        description='''
        Calculate the condition number of the (P|Q) matrix for the RI methods.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.CALC_COND_NUM'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_COL_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the column block used in the SCALAPACK block cyclic data
        distribution.Default is (COL_BLOCK=-1) is automatic. A proper choice can speedup
        the parallel matrix multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.COL_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_GROUP_SIZE = Quantity(
        type=str,
        shape=[],
        description='''
        Group size used in the computation of the integrals. Default is to use all
        processors (GROUP_SIZE=-1).A smaller group size (for example the node size), might
        a better choice if the actual MP2 time is large compared to integral computation
        time. This is usually the case if the total number of processors is not too large.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.GROUP_SIZE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MEMORY = Quantity(
        type=str,
        shape=[],
        description='''
        Maximum allowed total memory usage during MP2 methods [Mb].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MEMORY'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Which method should be used to compute the MP2 energy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_ROW_BLOCK = Quantity(
        type=str,
        shape=[],
        description='''
        Size of the row block used in the SCALAPACK block cyclic data distribution.Default
        is (ROW_BLOCK=-1) is automatic. A proper choice can speedup the parallel matrix
        multiplication in the case of RI-RPA and RI-SOS-MP2-Laplace.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.ROW_BLOCK'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_SCALE_S = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the singlet energy component (opposite spin, OS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.SCALE_S'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_SCALE_T = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor of the triplet energy component (same spin, SS).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.SCALE_T'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CPHF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_CPHF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.CPHF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_DIRECT_CANONICAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_DIRECT_CANONICAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.DIRECT_CANONICAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_INTERACTION_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.INTERACTION_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_MP2_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.MP2_INFO'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_OPT_RI_BASIS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.OPT_RI_BASIS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_LAPLACE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_LAPLACE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_LAPLACE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_MP2'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_MP2'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_RI_RPA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.RI_RPA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION_WFC_GPW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION.WFC_GPW'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC(MSection):
    '''
    Uses the Becke 88 longrange exchange functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR(MSection):
    '''
    Uses the Becke 88 longrange exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        Potential parameter in erf(omega*r)/r
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88(MSection):
    '''
    Uses the Becke 88 exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97(MSection):
    '''
    Uses the Becke 97 exchange correlation functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the B97 and Grimme parametrization
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional, if -1 the default for the given
        parametrization is used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL(MSection):
    '''
    Becke Roussel exchange hole model. Can be usedas long range correction with a
    truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff radius for the truncation. If put to zero, the standard full
        range potential will be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter in the exchange hole. Usually this is put to 1.0 or 0.8
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BEEF(MSection):
    '''
    Uses the BEEFvdW exchange functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BEEF_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BEEF.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BEEF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BEEF.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_CS1(MSection):
    '''
    Uses the CS1 functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_CS1_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.CS1.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09(MSection):
    '''
    Combination of three different exchange hole models
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09_GAMMA = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for Becke Roussel hole
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09.GAMMA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_HCTH(MSection):
    '''
    Uses the HCTH class of functionals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_HCTH_PARAMETER_SET = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the parameters should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.HCTH.PARAMETER_SET'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_HCTH_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.HCTH.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_GGA(MSection):
    '''
    Uses one of the KE_GGA functionals (optimized versions of some of these functionals
    might be available outside this section). These functionals are needed for the
    computation of the kinetic energy in the Kim-Gordon method.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_GGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the KE_GGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_GGA.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_GGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_GGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC(MSection):
    '''
    To be used for KG runs. Uses kinetic energy functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR(MSection):
    '''
    LDA exchange hole model in truncated coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC(MSection):
    '''
    Uses functionals from LIBXC, see also
    http://www.tddft.org/programs/octopus/wiki/index.php/Libxc
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        names of the functionals, see also
        http://www.tddft.org/programs/octopus/wiki/index.php/Libxc:manual .The precise
        list of available functionals depends on the version of libxc interfaced
        (currently 2.0.1).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        parameters of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        scaling factors of the functionals
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_ADIABATIC(MSection):
    '''
    Uses the LYP correlation functional in an adiabatic fashion
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_ADIABATIC_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameter of the adiabatic curve.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP_ADIABATIC.LAMBDA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_ADIABATIC_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP_ADIABATIC.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP(MSection):
    '''
    Uses the LYP functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_OPTX(MSection):
    '''
    Uses the OPTX functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_OPTX_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.OPTX.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_OPTX_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.OPTX.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_P86C(MSection):
    '''
    Uses the P86C functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_P86C_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.P86C.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_P86C_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.P86C.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PADE(MSection):
    '''
    Uses the PADE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PADE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PADE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR(MSection):
    '''
    PBE exchange hole model in trucanted coulomb potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_CUTOFF_RADIUS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines cutoff for lower integration boundary
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.CUTOFF_RADIUS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE(MSection):
    '''
    Uses the PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        switches between the different parametrizations of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92(MSection):
    '''
    Uses the PerdewWang correlation functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PW92.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92_SCALE = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling of the energy functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PW92.SCALE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PW92.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81(MSection):
    '''
    Uses the PZ functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81_PARAMETRIZATION = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of parametrizations should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PZ81.PARAMETRIZATION'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PZ81.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PZ81.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TFW(MSection):
    '''
    Uses the TFW functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TFW_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TFW.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TF(MSection):
    '''
    Uses the TF functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TF_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TF.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS(MSection):
    '''
    Uses the TPSS functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TPSS.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TPSS.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TPSS.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN(MSection):
    '''
    Uses the VWN functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN_FUNCTIONAL_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Which version of the VWN functional should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.VWN.FUNCTIONAL_TYPE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN_SCALE_C = Quantity(
        type=str,
        shape=[],
        description='''
        scales the correlation part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.VWN.SCALE_C'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.VWN.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA(MSection):
    '''
    Uses the XALPHA (SLATER) functional.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XALPHA.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XALPHA.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA_XA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the xa parameter (this does not change the exponent, just the mixing)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XALPHA.XA'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XGGA(MSection):
    '''
    Uses one of the XGGA functionals (optimized versions of some of these functionals
    might be available outside this section).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XGGA_FUNCTIONAL = Quantity(
        type=str,
        shape=[],
        description='''
        Which one of the XGGA functionals should be used
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XGGA.FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XGGA_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XGGA.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE(MSection):
    '''
    Uses the short range PBE functional
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE_OMEGA = Quantity(
        type=str,
        shape=[],
        description='''
        screening parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE.OMEGA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE_SCALE_X0 = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the original hole PBE-functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE.SCALE_X0'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE_SCALE_X = Quantity(
        type=str,
        shape=[],
        description='''
        scales the exchange part of the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE.SCALE_X'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        activates the functional
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL(MSection):
    '''
    The xc functional to use
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Shortcut for the most common functional combinations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR_ADIABATIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE88'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE88'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE97'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE97'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BECKE_ROUSSEL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BECKE_ROUSSEL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BEEF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_BEEF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.BEEF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_CS1 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_CS1'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.CS1'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_GV09'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.GV09'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_HCTH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_HCTH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.HCTH'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_GGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_GGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_GGA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_KE_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.KE_LIBXC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LDA_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LDA_HOLE_T_C_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LIBXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LIBXC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_ADIABATIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP_ADIABATIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP_ADIABATIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_LYP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.LYP'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_OPTX = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_OPTX'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.OPTX'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_P86C = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_P86C'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.P86C'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PADE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PADE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PADE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE_HOLE_T_C_LR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE_HOLE_T_C_LR'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PBE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PW92'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PW92'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_PZ81'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.PZ81'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TFW = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TFW'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TFW'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_TPSS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.TPSS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_VWN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.VWN'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XALPHA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XALPHA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XGGA = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XGGA'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XGGA'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL_XWPBE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL.XWPBE'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_GRID(MSection):
    '''
    The xc parameters used when calculating the xc on the grid
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_GRID_USE_FINER_GRID = Quantity(
        type=str,
        shape=[],
        description='''
        Uses a finer grid only to calculate the xc
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_GRID.USE_FINER_GRID'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_GRID_XC_DERIV = Quantity(
        type=str,
        shape=[],
        description='''
        The method used to compute the derivatives
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_GRID.XC_DERIV'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_GRID_XC_SMOOTH_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        The density smoothing used for the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_GRID.XC_SMOOTH_RHO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP(MSection):
    '''
    Uses the SAOP potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.SAOP'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the alpha parameter (default = 1.19).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.SAOP.ALPHA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the beta parameter (default = 0.01).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.SAOP.BETA'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP_K_RHO = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the K_rho parameter (default = 0.42).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.SAOP.K_RHO'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL(MSection):
    '''
    The xc potential to use (CAREFUL: xc potential here refers to potentials that are not
    derived from an xc functional, but rather are modelled directly. Therefore there is no
    consistent xc energy available. To still get an energy expression, see ENERGY below
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        How to determine the total energy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.ENERGY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL_SAOP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL.SAOP'))


class x_cp2k_section_input_FORCE_EVAL_DFT_XC(MSection):
    '''
    parameters needed calculate the xc potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_DENSITY_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.DENSITY_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_DENSITY_SMOOTH_CUTOFF_RANGE = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter for the smoothing procedure inxc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.DENSITY_SMOOTH_CUTOFF_RANGE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_FUNCTIONAL_ROUTINE = Quantity(
        type=str,
        shape=[],
        description='''
        Select the code for xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.FUNCTIONAL_ROUTINE'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_GRADIENT_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on the gradient of the density used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.GRADIENT_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_DFT_XC_TAU_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        The cutoff on tau used by the xc calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.XC.TAU_CUTOFF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_ADIABATIC_RESCALING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.ADIABATIC_RESCALING'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_HF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.HF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_VDW_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.VDW_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_WF_CORRELATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.WF_CORRELATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_FUNCTIONAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_FUNCTIONAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_GRID'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC_XC_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC.XC_POTENTIAL'))


class x_cp2k_section_input_FORCE_EVAL_DFT(MSection):
    '''
    parameter needed by dft programs
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT'))

    x_cp2k_input_FORCE_EVAL_DFT_BASIS_SET_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the basis set file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.BASIS_SET_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        The total charge of the system
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.CHARGE'))

    x_cp2k_input_FORCE_EVAL_DFT_EXCITATIONS = Quantity(
        type=str,
        shape=[],
        description='''
        If excitations should be calculated
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.EXCITATIONS'))

    x_cp2k_input_FORCE_EVAL_DFT_GEMINAL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the geminal basis set file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.GEMINAL_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_MULTIPLICITY = Quantity(
        type=str,
        shape=[],
        description='''
        Two times the total spin plus one. Specify 3 for a triplet, 4 for a quartet, and
        so on. Default is 1 (singlet) for an even number and 2 (doublet) for an odd number
        of electrons.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.MULTIPLICITY'))

    x_cp2k_input_FORCE_EVAL_DFT_PLUS_U_METHOD = Quantity(
        type=str,
        shape=[],
        description='''
        Method employed for the calculation of the DFT+U contribution
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.PLUS_U_METHOD'))

    x_cp2k_input_FORCE_EVAL_DFT_POTENTIAL_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the pseudo potential file, may include a path
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.POTENTIAL_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_DFT_RELAX_MULTIPLICITY = Quantity(
        type=str,
        shape=[],
        description='''
        Do not enforce the occupation of alpha and beta MOs due to the initially defined
        multiplicity, but rather follow an Aufbau principle. A threshold value greater
        than zero activates this option. Larger threshold values increase the probability
        for a spin flip. This option is only valid for unrestricted (i.e. spin polarised)
        Kohn-Sham (UKS) calculations.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.RELAX_MULTIPLICITY'))

    x_cp2k_input_FORCE_EVAL_DFT_ROKS = Quantity(
        type=str,
        shape=[],
        description='''
        Requests a restricted open Kohn-Sham calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.ROKS'))

    x_cp2k_input_FORCE_EVAL_DFT_SUBCELLS = Quantity(
        type=str,
        shape=[],
        description='''
        Read the grid size for subcell generation in the construction of neighbor lists.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SUBCELLS'))

    x_cp2k_input_FORCE_EVAL_DFT_SURF_DIP_DIR = Quantity(
        type=str,
        shape=[],
        description='''
        Cartesian axis parallel to surface normal.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SURF_DIP_DIR'))

    x_cp2k_input_FORCE_EVAL_DFT_SURFACE_DIPOLE_CORRECTION = Quantity(
        type=str,
        shape=[],
        description='''
        For slab calculations with asymmetric geometries, activate the correction of  the
        electrostatic potential with by compensating for the surface dipole. Implemented
        only for slabs with normal  parallel to one Cartesian axis. The normal direction
        is given by the keyword SURF_DIP_DIR
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.SURFACE_DIPOLE_CORRECTION'))

    x_cp2k_input_FORCE_EVAL_DFT_UKS = Quantity(
        type=str,
        shape=[],
        description='''
        Requests a spin-polarized calculation using alpha and beta orbitals, i.e. no spin
        restriction is applied
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.UKS'))

    x_cp2k_input_FORCE_EVAL_DFT_WFN_RESTART_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Name of the wavefunction restart file, may include a path. If no file is
        specified, the default is to open the file as generated by the wfn restart print
        key.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.DFT.WFN_RESTART_FILE_NAME'))

    x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_ALMO_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.ALMO_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_AUXILIARY_DENSITY_MATRIX_METHOD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.AUXILIARY_DENSITY_MATRIX_METHOD'))

    x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_DENSITY_FITTING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.DENSITY_FITTING'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EFIELD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EFIELD'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_DENSITY'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_DENSITY'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_POTENTIAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_POTENTIAL'))

    x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_VXC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_EXTERNAL_VXC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.EXTERNAL_VXC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_KG_METHOD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_KG_METHOD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.KG_METHOD'))

    x_cp2k_section_input_FORCE_EVAL_DFT_KPOINTS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_KPOINTS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.KPOINTS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LOCALIZE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LOCALIZE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LOCALIZE'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LOW_SPIN_ROKS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LOW_SPIN_ROKS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LOW_SPIN_ROKS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_LS_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.LS_SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_MGRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_MGRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.MGRID'))

    x_cp2k_section_input_FORCE_EVAL_DFT_PERIODIC_EFIELD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_PERIODIC_EFIELD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.PERIODIC_EFIELD'))

    x_cp2k_section_input_FORCE_EVAL_DFT_POISSON = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_POISSON'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.POISSON'))

    x_cp2k_section_input_FORCE_EVAL_DFT_QS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_QS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.QS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_REAL_TIME_PROPAGATION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.REAL_TIME_PROPAGATION'))

    x_cp2k_section_input_FORCE_EVAL_DFT_RELATIVISTIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_RELATIVISTIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.RELATIVISTIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCCS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCCS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCCS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SCRF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SCRF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SCRF'))

    x_cp2k_section_input_FORCE_EVAL_DFT_SIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_SIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.SIC'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TDDFPT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TDDFPT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_TRANSPORT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_TRANSPORT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.TRANSPORT'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XAS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XAS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XAS'))

    x_cp2k_section_input_FORCE_EVAL_DFT_XC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_DFT_XC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.DFT.XC'))


class x_cp2k_section_input_FORCE_EVAL_EIP(MSection):
    '''
    This section contains all information to run an Empirical Interatomic Potential (EIP)
    calculation.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.EIP'))

    x_cp2k_input_FORCE_EVAL_EIP_EIP_MODEL = Quantity(
        type=str,
        shape=[],
        description='''
        Selects the empirical interaction potential model
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EIP.EIP_MODEL'))


class x_cp2k_section_input_FORCE_EVAL_EP(MSection):
    '''
    parameter needed by an ep calculation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.EP'))

    x_cp2k_input_FORCE_EVAL_EP_AT_PER_MOL = Quantity(
        type=str,
        shape=[],
        description='''
        Number of atoms in each molecule (at the moment only uniform system cam be
        handled)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.AT_PER_MOL'))

    x_cp2k_input_FORCE_EVAL_EP_COMP_INPUT = Quantity(
        type=str,
        shape=[],
        description='''
        Path to the input to be used for the component of the main system
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.COMP_INPUT'))

    x_cp2k_input_FORCE_EVAL_EP_E0_ONLY = Quantity(
        type=str,
        shape=[],
        description='''
        If only e0 should be calculated
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.E0_ONLY'))

    x_cp2k_input_FORCE_EVAL_EP_EPS_LIN_SOLV = Quantity(
        type=str,
        shape=[],
        description='''
        Requested convergence of the linear solver (for psi1)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.EPS_LIN_SOLV'))

    x_cp2k_input_FORCE_EVAL_EP_ROTATE = Quantity(
        type=str,
        shape=[],
        description='''
        If rotations from a unique set of coefficients should be used or if single
        molecule optimizations generate it
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.ROTATE'))

    x_cp2k_input_FORCE_EVAL_EP_START_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Starting coefficients for roatation based ep
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EP.START_COEFFS'))


class x_cp2k_section_input_FORCE_EVAL_EXTERNAL_POTENTIAL(MSection):
    '''
    Section controlling the presence of an external potential dependent  on the atomic
    positions (X,Y,Z)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.EXTERNAL_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_ATOMS_LIST = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the atoms on which the external potential will act
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.ATOMS_LIST'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_DX = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter used for computing the derivative with the Ridders method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.DX'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_ERROR_LIMIT = Quantity(
        type=str,
        shape=[],
        description='''
        Checks that the error in computing the derivative is not larger than the value
        set. In case prints a warning message.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.ERROR_LIMIT'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_FUNCTION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form in mathematical notation. Variables must be the
        atomic coordinates (X,Y,Z).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.FUNCTION'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameters of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_UNITS = Quantity(
        type=str,
        shape=[],
        description='''
        Optionally, allows to define valid CP2K unit strings for each parameter value. It
        is assumed that the corresponding parameter value is specified in this unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.UNITS'))

    x_cp2k_input_FORCE_EVAL_EXTERNAL_POTENTIAL_VALUES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the values of  parameter of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.EXTERNAL_POTENTIAL.VALUES'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_COUPLING(MSection):
    '''
    Coupling between two force_eval: E=(E1+E2 - sqrt((E1-E2)**2+4*H12**2))/2
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.COUPLING'))

    x_cp2k_input_FORCE_EVAL_MIXED_COUPLING_COUPLING_PARAMETER = Quantity(
        type=str,
        shape=[],
        description='''
        Coupling parameter H12 used in the coupling
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.COUPLING.COUPLING_PARAMETER'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_GENERIC(MSection):
    '''
    User driven coupling between two or more force_eval.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.GENERIC'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_DX = Quantity(
        type=str,
        shape=[],
        description='''
        Parameter used for computing the derivative with the Ridders method.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.DX'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_ERROR_LIMIT = Quantity(
        type=str,
        shape=[],
        description='''
        Checks that the error in computing the derivative is not larger than the value
        set. In case prints a warning message.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.ERROR_LIMIT'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_MIXING_FUNCTION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the mixing functional form in mathematical notation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.MIXING_FUNCTION'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameters of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_UNITS = Quantity(
        type=str,
        shape=[],
        description='''
        Optionally, allows to define valid CP2K unit strings for each parameter value. It
        is assumed that the corresponding parameter value is specified in this unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.UNITS'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_VALUES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the values of parameter of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.VALUES'))

    x_cp2k_input_FORCE_EVAL_MIXED_GENERIC_VARIABLES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the variables of the functional form. To allow an efficient mapping the
        order of the energy variables will be considered identical to the order of the
        force_eval in the force_eval_order list.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GENERIC.VARIABLES'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_LINEAR(MSection):
    '''
    Linear combination between two force_eval:  F= lambda F1 + (1-lambda) F2
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.LINEAR'))

    x_cp2k_input_FORCE_EVAL_MIXED_LINEAR_LAMBDA = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the mixing parameter lambda in the formula:
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.LINEAR.LAMBDA'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT(MSection):
    '''
    Fragment definition
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.FRAGMENT'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        Starting and ending atomic index defining one fragment must be provided
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.FRAGMENT.DEFAULT_KEYWORD'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT_MAP = Quantity(
        type=str,
        shape=[],
        description='''
        Provides the index of the fragment of the MIXED force_eval mapped on the locally
        defined fragment.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.FRAGMENT.MAP'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the index of the fragment defined
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.FRAGMENT.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED_FRAGMENT(MSection):
    '''
    Fragment definition
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED.FRAGMENT'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED_FRAGMENT_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        Starting and ending atomic index defining one fragment must be provided
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED.FRAGMENT.DEFAULT_KEYWORD'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED_FRAGMENT_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the index of the fragment defined
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED.FRAGMENT.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED(MSection):
    '''
    Defines the fragments for the mixed force_eval (reference)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED_FRAGMENT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED_FRAGMENT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED.FRAGMENT'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL(MSection):
    '''
    Defines the fragments and the mapping for each force_eval (an integer index (ID) needs
    to be provided as parameter)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_DEFINE_FRAGMENTS = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the fragments definition of the force_eval through the fragments of the
        force_eval_mixed. This avoids the pedantic definition of the fragments for the
        force_eval, assuming the order of the fragments for the specified force_eval is
        the same as the sequence  of integers provided. Easier to USE should be preferred
        to the specification of the single fragments.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.DEFINE_FRAGMENTS'))

    x_cp2k_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the index of the force_eval for which fragments and mappings are provided
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_FRAGMENT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL.FRAGMENT'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING(MSection):
    '''
    Defines the mapping of atoms for the different force_eval with the mixed force_eval.
    The default is to have a mapping 1-1 between atom index (i.e. all force_eval share the
    same geometrical structure). The mapping is based on defining fragments and the
    mapping the  fragments between the several force_eval and the mixed force_eval
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL_MIXED'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL_MIXED'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING_FORCE_EVAL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING.FORCE_EVAL'))


class x_cp2k_section_input_FORCE_EVAL_MIXED_RESTRAINT(MSection):
    '''
    Restraint between two force_eval: E = E1 + k*(E1-E2-t)**2
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.RESTRAINT'))

    x_cp2k_input_FORCE_EVAL_MIXED_RESTRAINT_RESTRAINT_STRENGTH = Quantity(
        type=str,
        shape=[],
        description='''
        Strength of the restraint (k) in k*(E1-E2-t)**2
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.RESTRAINT.RESTRAINT_STRENGTH'))

    x_cp2k_input_FORCE_EVAL_MIXED_RESTRAINT_RESTRAINT_TARGET = Quantity(
        type=str,
        shape=[],
        description='''
        Target value of the restraint (t)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.RESTRAINT.RESTRAINT_TARGET'))


class x_cp2k_section_input_FORCE_EVAL_MIXED(MSection):
    '''
    This section contains all information to run with a hamiltonian defined by a mixing of
    force_evals
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED'))

    x_cp2k_input_FORCE_EVAL_MIXED_GROUP_PARTITION = Quantity(
        type=str,
        shape=[],
        description='''
        gives the exact number of processors for each group. If not specified processors
        allocated will be equally distributed for the specified subforce_eval, trying to
        build a number of groups equal to the number of subforce_eval specified.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.GROUP_PARTITION'))

    x_cp2k_input_FORCE_EVAL_MIXED_MIXING_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        The type of mixing to be employed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.MIXING_TYPE'))

    x_cp2k_input_FORCE_EVAL_MIXED_NGROUPS = Quantity(
        type=str,
        shape=[],
        description='''
        Gives the wanted number of groups. If not specified the number of groups is set to
        the number of subforce_eval defined.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MIXED.NGROUPS'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_COUPLING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_COUPLING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.COUPLING'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_GENERIC = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_GENERIC'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.GENERIC'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_LINEAR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_LINEAR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.LINEAR'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_MAPPING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.MAPPING'))

    x_cp2k_section_input_FORCE_EVAL_MIXED_RESTRAINT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MIXED_RESTRAINT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MIXED.RESTRAINT'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB(MSection):
    '''
    Specifies the Urey-Bradley potential between the external atoms defining the angle
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB_CS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cubic stretch term.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB.CS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of Urey-Bradleypotential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential. For MORSE potentials 2 numbers are
        expected. For QUARTIC potentials 3 numbers are expected.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB_R0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the equilibrium distance.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB.R0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND(MSection):
    '''
    Specifies the bend potential of the MM system.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BEND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the bend.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_CB = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the the cubic force constant of the bend
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.CB'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_KBS12 = Quantity(
        type=str,
        shape=[],
        description='''
        Mixed bend stretch parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.KBS12'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_KBS32 = Quantity(
        type=str,
        shape=[],
        description='''
        Mixed bend stretch parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.KBS32'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of bend potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_KSS = Quantity(
        type=str,
        shape=[],
        description='''
        Mixed bend stretch parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.KSS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_R012 = Quantity(
        type=str,
        shape=[],
        description='''
        Mixed bend stretch parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.R012'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_R032 = Quantity(
        type=str,
        shape=[],
        description='''
        Mixed bend stretch parameter
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.R032'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BEND_THETA0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the equilibrium angle.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BEND.THETA0'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND_UB'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BEND.UB'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BOND(MSection):
    '''
    Specifies the bond potential
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BOND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BOND_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the bond.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BOND.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BOND_CS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cubic stretch term.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BOND.CS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BOND_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of Bondpotential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BOND.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BOND_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential. For MORSE potentials 2 numbers are
        expected. For QUARTIC potentials 3 numbers are expected.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BOND.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_BOND_R0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the equilibrium distance.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.BOND.R0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGES(MSection):
    '''
    Allow to specify an array of classical charges, thus avoiding the packing and
    permitting the usage of different charges for same atomic types.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.CHARGES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_CHARGES_DEFAULT_KEYWORD = Quantity(
        type=str,
        shape=[],
        description='''
        Value of the charge for the individual atom. Order MUST reflect the one specified
        for the geometry.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.CHARGES.DEFAULT_KEYWORD'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGE(MSection):
    '''
    This section specifies the charge of the MM atoms
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.CHARGE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_CHARGE_ATOM = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind of the charge.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.CHARGE.ATOM'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_CHARGE_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the charge of the MM atom in electron charge unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.CHARGE.CHARGE'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING(MSection):
    '''
    This section specifies optional electric field damping for the polarizable atoms.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING_ATOM = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind for this damping function.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING.ATOM'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING_BIJ = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the BIJ parameter for this damping.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING.BIJ'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING_CIJ = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the CIJ parameter for this damping.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING.CIJ'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the order for this damping.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING.ORDER'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the damping type.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING.TYPE'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE(MSection):
    '''
    This section specifies that we will perform an SCF dipole calculation of the MM atoms.
    Needs KEYWORD POL_SCF in POISSON secton
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_APOL = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the isotropic polarizability of the MM atom.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.APOL'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_ATOM = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind of the scf dipole.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.ATOM'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE_DAMPING'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE.DAMPING'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER(MSection):
    '''
    Specifies the improper torsion potential of the MM system.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the improper tors.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of improper torsion potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER_PHI0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the phase of the potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER.PHI0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD(MSection):
    '''
    This section specifies the input parameters for BMHFTD potential type.Functional form:
    V(r) = A*exp(-B*r) - f_6*(r)C/r^6 - f_8(r)*D/r^8.where f_order(r)=1-exp(-BD * r) *
    \\sum_{k=0}^order (BD * r)^k / k! .(Tang-Toennies damping function)No values available
    inside cp2k.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the BMHFTD nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of the dispersion-damped Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_BD = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the BD parameter of the dispersion-damped Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.BD'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of the dispersion-damped Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of the dispersion-damped Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of the dispersion-damped Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_MAP_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the kinds for which internally is defined the BMHFTD nonbond potential at
        the moment no species included.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.MAP_ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_ORDER = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the order for this damping.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.ORDER'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the BMHFTD potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT(MSection):
    '''
    This section specifies the input parameters for BMHFT potential type.Functional form:
    V(r) = A * EXP(-B*r) - C/r^6 - D/r^8.Values available inside cp2k only for the Na/Cl
    pair.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the BMHFT nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of the Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of the Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of the Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of the Fumi-Tosi Potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_MAP_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the kinds for which internally is defined the BMHFT nonbond potential at
        the moment only Na and Cl.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.MAP_ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the BMHFT potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES(MSection):
    '''
    This section specifies the input parameters for the Buckingham 4-ranges potential
    type. Functional form:<ul><li>V(r) = A*EXP(-B*r) for r &#60;
    r<sub>1</sub></li><li>V(r) = Sum_n POLY1(n)*r<sup>n</sup> for r<sub>1</sub> ≤ r &#60;
    r<sub>2</sub></li><li>V(r) = Sum_n POLY2(n)*r<sup>n</sup> for r<sub>2</sub> ≤ r &#60;
    r<sub>3</sub></li><li>V(r) = -C/r<sup>6</sup> for r ≥ r<sub>3</sub></li></ul>
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of the Buckingham potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of the Buckingham potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of the Buckingham  potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_POLY1 = Quantity(
        type=str,
        shape=[],
        description='''
        Coefficients of the polynomial used in the second rangeThis keyword can be
        repeated several times.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.POLY1'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_POLY2 = Quantity(
        type=str,
        shape=[],
        description='''
        Coefficients of the polynomial used in the third rangeThis keyword can be repeated
        several times.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.POLY2'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_R1 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the first range
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.R1'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_R2 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the second range
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.R2'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_R3 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the third range
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.R3'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Buckingham potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE(MSection):
    '''
    This section specifies the input parameters for Buckingham plus Morse potential type
    Functional Form: V(r) =
    F0*(B1+B2)*EXP([A1+A2-r]/[B1+B2])-C/r^6+D*{EXP[-2*beta*(r-R0)]-2*EXP[-beta*(r-R0)]}.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_A1 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A1 parameter of Buckingham+Morse potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.A1'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_A2 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A2 parameter of Buckingham+Morse potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.A2'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_B1 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B1 parameter of Buckingham+Morse potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.B1'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_B2 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B2 parameter of Buckingham+Morse potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.B2'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the width for the Morse part
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.BETA'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of Buckingham+Morse  potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the amplitude for the Morse part
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_F0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the f0 parameter of Buckingham+Morse potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.F0'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_R0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the equilibrium distance for the Morse part
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.R0'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Buckingham potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_EAM(MSection):
    '''
    This section specifies the input parameters for EAM potential type.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.EAM'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_EAM_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.EAM.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_EAM_PARM_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename that contains the tabulated EAM potential. File structure:
        the first line of the potential file contains a title. The second line contains:
        atomic number, mass and lattice constant. These information are parsed but not
        used in CP2K. The third line contains: dr: increment of r for the tabulated values
        of density and phi (assuming r starts in 0) [angstrom]; drho: increment of density
        for the tabulated values of the embedding function (assuming rho starts in 0)
        [au_c]; cutoff: cutoff of the EAM potential; npoints: number of points in
        tabulated. Follow in order npoints lines for rho [au_c] and its derivative
        [au_c*angstrom^-1]; npoints lines for PHI [ev] and its derivative [ev*angstrom^-1]
        and npoint lines for the embedded function [ev] and its derivative [ev*au_c^-1].
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.EAM.PARM_FILE_NAME'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT(MSection):
    '''
    This section specifies the input parameters for a generic potential type.A functional
    form is specified. Mathematical Operators recognized are +, -, *, /, ** or
    alternatively ^, whereas symbols for brackets must be (). The function parser
    recognizes the (single argument) Fortran 90 intrinsic functions abs, exp, log10, log,
    sqrt, sinh, cosh, tanh, sin, cos, tan, asin, acos, atan. Parsing for INTRINSIC
    functions is CASE INsensitive.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the generic potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_FUNCTION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form in mathematical notation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.FUNCTION'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameters of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the generic potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_UNITS = Quantity(
        type=str,
        shape=[],
        description='''
        Optionally, allows to define valid CP2K unit strings for each parameter value. It
        is assumed that the corresponding parameter value is specified in this unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.UNITS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_VALUES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the values of parameter of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.VALUES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT_VARIABLES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the variable of the functional form.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT.VARIABLES'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN(MSection):
    '''
    This section specifies the input parameters for GOODWIN potential type.Functional
    form: V(r) = EXP(M*(-(r/DC)**MC+(D/DC)**MC))*VR0*(D/r)**M.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_DC = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the DC parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.DC'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_MC = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the MC parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.MC'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_M = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the M parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.M'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN_VR0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the VR0 parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN.VR0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV(MSection):
    '''
    This section specifies the input parameters for IPBV potential type.Functional form:
    Implicit table function.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the IPBV nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the IPBV potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES(MSection):
    '''
    This section specifies the input parameters for LENNARD-JONES potential
    type.Functional form: V(r) = 4.0 * EPSILON * [(SIGMA/r)^12-(SIGMA/r)^6].
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_EPSILON = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the EPSILON parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.EPSILON'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the SIGMA parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES.SIGMA'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP(MSection):
    '''
    This section specifies the input parameters for QUIP potential type. Mainly intended
    for things like GAP corrections to DFT to achieve correlated-wavefunction-like
    accuracy. Requires linking with quip library from <a href="http://www.libatoms.org"
    target="_blank">http://www.libatoms.org</a> .
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the QUIP potential. For more than 2 elements,
        &QUIP section must be repeated until each element has been mentioned at least
        once. Set IGNORE_MISSING_CRITICAL_PARAMS to T in enclosing &FORCEFIELD section to
        avoid having to list every pair of elements separately.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP_CALC_ARGS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the potential calculation arguments for the QUIP potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP.CALC_ARGS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP_INIT_ARGS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the potential initialization arguments for the QUIP potential. If blank
        (default) first potential defined in QUIP parameter file will be used.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP.INIT_ARGS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP_PARM_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename that contains the QUIP potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP.PARM_FILE_NAME'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN(MSection):
    '''
    This section specifies the input parameters for the Siepmann-Sprik potential type.
    Consist of 4 terms: T1+T2+T3+T4. The terms T1=A/rij^alpha and T2=-C/rij^6 have to be
    given via the GENPOT section. The terms T3+T4 are obtained from the SIEPMANN section.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the beta parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.BETA'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_E = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the E parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.E'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_F = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the F parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.F'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of Siepmann potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN.RCUT'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF(MSection):
    '''
    This section specifies the input parameters for Tersoff potential type.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the alpha parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.ALPHA'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_BETA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the beta parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.BETA'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_BIGD = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.BIGD'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_BIGR = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the bigR parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.BIGR'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the c parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the d parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_H = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the h parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.H'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_LAMBDA1 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lambda1 parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.LAMBDA1'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_LAMBDA2 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lambda2 parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.LAMBDA2'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_LAMBDA3 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lambda3 parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.LAMBDA3'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_N = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the n parameter of Tersoff potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.N'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the tersoff potential.  This parameter is in
        principle already defined by the values of  bigD and bigR. But it is necessary to
        define it when using the tersoff  in conjuction with other potentials (for the
        same atomic pair) in order to have the same consistent definition of RCUT for all
        potentials.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF.RCUT'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS(MSection):
    '''
    This section specifies the input parameters for WILLIAMS potential type.Functional
    form: V(r) = A*EXP(-B*r) - C / r^6 .
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT(MSection):
    '''
    This section specifies the input parameters for a generic potential type.A functional
    form is specified. Mathematical Operators recognized are +, -, *, /, ** or
    alternatively ^, whereas symbols for brackets must be (). The function parser
    recognizes the (single argument) Fortran 90 intrinsic functions abs, exp, log10, log,
    sqrt, sinh, cosh, tanh, sin, cos, tan, asin, acos, atan. Parsing for INTRINSIC
    functions is CASE INsensitive.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the generic potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_FUNCTION = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the functional form in mathematical notation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.FUNCTION'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the parameters of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the generic potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_UNITS = Quantity(
        type=str,
        shape=[],
        description='''
        Optionally, allows to define valid CP2K unit strings for each parameter value. It
        is assumed that the corresponding parameter value is specified in this unit.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.UNITS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_VALUES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the values of parameter of the functional form
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.VALUES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT_VARIABLES = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the variable of the functional form.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT.VARIABLES'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN(MSection):
    '''
    This section specifies the input parameters for GOODWIN potential type.Functional
    form: V(r) = EXP(M*(-(r/DC)**MC+(D/DC)**MC))*VR0*(D/r)**M.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_DC = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the DC parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.DC'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_D = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the D parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.D'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_MC = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the MC parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.MC'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_M = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the M parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.M'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN_VR0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the VR0 parameter of the Goodwin potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN.VR0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES(MSection):
    '''
    This section specifies the input parameters for LENNARD-JONES potential
    type.Functional form: V(r) = 4.0 * EPSILON * [(SIGMA/r)^12-(SIGMA/r)^6].
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_EPSILON = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the EPSILON parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.EPSILON'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.RMIN'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES_SIGMA = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the SIGMA parameter of the LJ potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES.SIGMA'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS(MSection):
    '''
    This section specifies the input parameters for WILLIAMS potential type.Functional
    form: V(r) = A*EXP(-B*r) - C / r^6 .
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind involved in the nonbond potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_A = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the A parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.A'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_B = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the B parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.B'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_C = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the C parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.C'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the cutoff parameter of the Williams potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.RCUT'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_RMAX = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the upper bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.RMAX'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS_RMIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the lower bound of the potential. If not set the range is the full range
        generate by the spline
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS.RMIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14(MSection):
    '''
    This section specifies the input parameters for 1-4 NON-BONDED interactions.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GENPOT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GENPOT'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_GOODWIN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.GOODWIN'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_LENNARD_JONES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.LENNARD-JONES'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14_WILLIAMS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14.WILLIAMS'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED(MSection):
    '''
    This section specifies the input parameters for NON-BONDED interactions.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFTD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFTD'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BMHFT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BMHFT'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCK4RANGES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCK4RANGES'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_BUCKMORSE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.BUCKMORSE'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_EAM = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_EAM'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.EAM'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GENPOT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GENPOT'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_GOODWIN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.GOODWIN'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_IPBV'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.IPBV'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_LENNARD_JONES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.LENNARD-JONES'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_QUIP'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.QUIP'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_SIEPMANN'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.SIEPMANN'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_TERSOFF'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.TERSOFF'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED_WILLIAMS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED.WILLIAMS'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND(MSection):
    '''
    Specifies the out of plane bend potential of the MM system.(Only defined for atom
    quadruples which are also defined as an improper pattern in the topology.)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the opbend.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of out of plane bend potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND_PHI0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the phase of the potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND.PHI0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_QUADRUPOLE(MSection):
    '''
    This section specifies that we will perform an SCF quadrupole calculation of the MM
    atoms. Needs KEYWORD POL_SCF in POISSON secton
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.QUADRUPOLE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_QUADRUPOLE_ATOM = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kind of the scf quadrupole.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.QUADRUPOLE.ATOM'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_QUADRUPOLE_CPOL = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the isotropic polarizability of the MM atom.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.QUADRUPOLE.CPOL'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SHELL(MSection):
    '''
    This section specifies the parameters for shell-model potentials
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.SHELL'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_CORE_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        Partial charge assigned to the core (electron charge units)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.CORE_CHARGE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_K2_SPRING = Quantity(
        type=str,
        shape=[],
        description='''
        Force constant k2 of the spring potential 1/2*k2*r^2 + 1/24*k4*r^4 binding a core-
        shell pair when a core-shell potential is employed.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.K2_SPRING'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_K4_SPRING = Quantity(
        type=str,
        shape=[],
        description='''
        Force constant k4 of the spring potential 1/2*k2*r^2 + 1/24*k4*r^4 binding a core-
        shell pair when a core-shell potential is employed. By default a harmonic spring
        potential is used, i.e. k4 is zero.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.K4_SPRING'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_MASS_FRACTION = Quantity(
        type=str,
        shape=[],
        description='''
        Fraction of the mass of the atom to be assigned to the shell
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.MASS_FRACTION'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_MAX_DISTANCE = Quantity(
        type=str,
        shape=[],
        description='''
        Assign a maximum elongation of the spring, if negative no limit is imposed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.MAX_DISTANCE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        The kind for which the shell potential parameters are given
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.SECTION_PARAMETERS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_SHELL_CHARGE = Quantity(
        type=str,
        shape=[],
        description='''
        Partial charge assigned to the shell (electron charge units)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.SHELL_CHARGE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHELL_SHELL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Define a screening function to exclude some neighbors  of the shell when
        electrostatic interaction are considered, if negative no screening is operated
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHELL.SHELL_CUTOFF'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE(MSection):
    '''
    specifies parameters to set up the splines used in the nonboned interactions (both
    pair body potential and many body potential)
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_EMAX_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum value of energy used to check the accuracy requested through
        EPS_SPLINE. Energy values larger than EMAX_ACCURACY generally do not  satisfy the
        requested accuracy
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.EMAX_ACCURACY'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_EMAX_SPLINE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum value of the potential up to which splines will be constructed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.EMAX_SPLINE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_EPS_SPLINE = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the threshold for the choice of the number of points used in the splines
        (comparing the splined value with the  analytically evaluated one)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.EPS_SPLINE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_NPOINTS = Quantity(
        type=str,
        shape=[],
        description='''
        Override the default search for an accurate spline by specifying a fixed number of
        spline points.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.NPOINTS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_R0_NB = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the minimum value of the distance interval  that brackets the value of
        emax_spline.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.R0_NB'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_RCUT_NB = Quantity(
        type=str,
        shape=[],
        description='''
        Cutoff radius for nonbonded interactions. This value overrides  the value
        specified in the potential definition and is global for all potentials.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.RCUT_NB'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE_UNIQUE_SPLINE = Quantity(
        type=str,
        shape=[],
        description='''
        For few potentials (Lennard-Jones) one global optimal spline is generated instead
        of different optimal splines for each kind of potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE.UNIQUE_SPLINE'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_TORSION(MSection):
    '''
    Specifies the torsion potential of the MM system.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.TORSION'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_TORSION_ATOMS = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the atomic kinds involved in the tors.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.TORSION.ATOMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_TORSION_KIND = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of torsion potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.TORSION.KIND'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_TORSION_K = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the force constant of the potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.TORSION.K'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_TORSION_M = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the multiplicity of the potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.TORSION.M'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_TORSION_PHI0 = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the phase of the potential.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.TORSION.PHI0'))


class x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD(MSection):
    '''
    Section specifying information regarding how to set up properly a force_field for the
    classical calculations.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_DO_NONBONDED = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the computation of all the real-sapce (short-range) nonbonded
        interactions. This also includes the real-space corrections for excluded or scaled
        1-2, 1-3 and 1-4 interactions. When set to F, the neighborlists are not created
        and all interactions that depend on them are not computed.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.DO_NONBONDED'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_EI_SCALE14 = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor for the electrostatics 1-4
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.EI_SCALE14'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_IGNORE_MISSING_CRITICAL_PARAMS = Quantity(
        type=str,
        shape=[],
        description='''
        Do not abort when critical force-field parameters are missing. CP2K will run as if
        the terms containing the missing parameters are zero.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.IGNORE_MISSING_CRITICAL_PARAMS'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_MULTIPLE_POTENTIAL = Quantity(
        type=str,
        shape=[],
        description='''
        Enables the possibility to define NONBONDED and NONBONDED14 as a sum of different
        kinds of potential. Useful for piecewise defined potentials.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.MULTIPLE_POTENTIAL'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_PARM_FILE_NAME = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the filename that contains the parameters of the FF.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.PARM_FILE_NAME'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_PARMTYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Define the kind of torsion potential
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.PARMTYPE'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_SHIFT_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Add a constant energy shift to the real-space non-bonding interactions (both Van
        der Waals and electrostatic) such that the energy at the cutoff radius is zero.
        This makes the non-bonding interactions continuous at the cutoff.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.SHIFT_CUTOFF'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_VDW_SCALE14 = Quantity(
        type=str,
        shape=[],
        description='''
        Scaling factor for the VDW 1-4
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.VDW_SCALE14'))

    x_cp2k_input_FORCE_EVAL_MM_FORCEFIELD_ZBL_SCATTERING = Quantity(
        type=str,
        shape=[],
        description='''
        A short range repulsive potential is added, to simulate collisions and scattering.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.FORCEFIELD.ZBL_SCATTERING'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BEND'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BEND'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BOND = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_BOND'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.BOND'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.CHARGES'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_CHARGE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.CHARGE'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_DIPOLE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.DIPOLE'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_IMPROPER'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.IMPROPER'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14 = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED14'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED14'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_NONBONDED'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.NONBONDED'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_OPBEND'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.OPBEND'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_QUADRUPOLE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_QUADRUPOLE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.QUADRUPOLE'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SHELL = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SHELL'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.SHELL'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_SPLINE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.SPLINE'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_TORSION = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD_TORSION'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD.TORSION'))


class x_cp2k_section_input_FORCE_EVAL_MM_NEIGHBOR_LISTS(MSection):
    '''
    This section specifies the input parameters for the construction of neighbor lists.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.NEIGHBOR_LISTS'))

    x_cp2k_input_FORCE_EVAL_MM_NEIGHBOR_LISTS_GEO_CHECK = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword enables the check that two atoms are never below the minimum value
        used to construct the splines during the construction of the neighbouring list.
        Disabling this keyword avoids CP2K to abort in case two atoms are below the
        minimum  value of the radius used to generate the splines.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.NEIGHBOR_LISTS.GEO_CHECK'))

    x_cp2k_input_FORCE_EVAL_MM_NEIGHBOR_LISTS_NEIGHBOR_LISTS_FROM_SCRATCH = Quantity(
        type=str,
        shape=[],
        description='''
        This keyword enables the building of the neighbouring list from scratch.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.NEIGHBOR_LISTS.NEIGHBOR_LISTS_FROM_SCRATCH'))

    x_cp2k_input_FORCE_EVAL_MM_NEIGHBOR_LISTS_VERLET_SKIN = Quantity(
        type=str,
        shape=[],
        description='''
        Defines the Verlet Skin for the generation of the neighbor lists
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.NEIGHBOR_LISTS.VERLET_SKIN'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES(MSection):
    '''
    Enables the use of multipoles in the treatment of the electrostatics.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES_EPS_POL = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the rmsd threshold for the derivatives of the energy towards the Cartesian
        dipoles components
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES.EPS_POL'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES_MAX_IPOL_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum number of iterations for induced dipoles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES.MAX_IPOL_ITER'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES_MAX_MULTIPOLE_EXPANSION = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the maximum level of multipoles expansion used  for the electrostatics.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES.MAX_MULTIPOLE_EXPANSION'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES_POL_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the method to obtain self consistent induced multipole moments.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES.POL_SCF'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Controls the activation of the Multipoles
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID(MSection):
    '''
    Set options that influence how the realspace grids are being distributed in parallel
    runs.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_DISTRIBUTION_LAYOUT = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of slices in the x, y and z directions.-1 specifies that any
        number of slices is OK.If a given distribution can not be satisfied, a replicated
        grid will result.Also see LOCK_DISTRIBUTION.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.DISTRIBUTION_LAYOUT'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_DISTRIBUTION_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Parallelization strategy.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.DISTRIBUTION_TYPE'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_HALO_REDUCTION_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        Can be used to reduce the halo of the distributed grid (experimental features).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.HALO_REDUCTION_FACTOR'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_LOCK_DISTRIBUTION = Quantity(
        type=str,
        shape=[],
        description='''
        Expert use only, only basic QS deals correctly with a non-default value.If the
        distribution is locked, a grid will have the same distribution asthe next finer
        multigrid (provided it is distributed).If unlocked, all grids can be distributed
        freely.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.LOCK_DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_MAX_DISTRIBUTED_LEVEL = Quantity(
        type=str,
        shape=[],
        description='''
        If the multigrid-level of a grid is larger than the parameter, it will not be
        distributed in the automatic scheme.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.MAX_DISTRIBUTED_LEVEL'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID_MEMORY_FACTOR = Quantity(
        type=str,
        shape=[],
        description='''
        A grid will only be distributed if the memory usage for that grid (including halo)
        is smaller than a replicated grid by this parameter.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID.MEMORY_FACTOR'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD(MSection):
    '''
    Ewald parameters controlling electrostatic only for CLASSICAL MM.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        alpha parameter associated with Ewald (EWALD|PME|SPME). Recommended for small
        systems is is alpha = 3.5 / r_cut. Tuning alpha, r_cut and gmax is needed to
        obtain O(N**1.5) scaling for ewald.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.ALPHA'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_EPSILON = Quantity(
        type=str,
        shape=[],
        description='''
        tolerance of gaussians for fft interpolation (PME only)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.EPSILON'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_EWALD_ACCURACY = Quantity(
        type=str,
        shape=[],
        description='''
        Expected accuracy in the Ewald sum. This number affects only the calculation of
        the cutoff for the real-space term of the ewald summation (EWALD|PME|SPME) as well
        as the construction of the neighbor lists (if the cutoff for non-bonded terms is
        smaller than the value employed to compute the EWALD real-space term). This
        keyword has no effect on the reciprocal space term (which can be tuned
        independently).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.EWALD_ACCURACY'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_EWALD_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        The type of ewald you want to perform.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.EWALD_TYPE'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_GMAX = Quantity(
        type=str,
        shape=[],
        description='''
        number of grid points (SPME and EWALD). If a single number is specified,the same
        number of points is used for all three directions on the grid.If three numbers are
        given, each direction can have a different number of points.The number of points
        needs to be FFTable (which depends on the library used) and odd for EWALD.The
        optimal number depends e.g. on alpha and the size of the cell. 1 point per
        Angstrom is common.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.GMAX'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_NS_MAX = Quantity(
        type=str,
        shape=[],
        description='''
        number of grid points on small mesh (PME only), should be odd.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.NS_MAX'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_O_SPLINE = Quantity(
        type=str,
        shape=[],
        description='''
        order of the beta-Euler spline (SPME only)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.O_SPLINE'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_EWALD_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Explicitly provide the real-space cutoff of the ewald summation (EWALD|PME|SPME).
        If present, overwrites the estimate of EWALD_ACCURACY and may affect the
        construction of the neighbor lists for non-bonded terms (in FIST), if the value
        specified is larger than the cutoff for non-bonded interactions.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.EWALD.RCUT'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_MULTIPOLES'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD.MULTIPOLES'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD_RS_GRID'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD.RS_GRID'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MT(MSection):
    '''
    Sets up parameters of  Martyna-Tuckerman poisson solver. Note that exact results are
    only guaranteed if the unit cell is twice as large as charge density (and serious
    artefacts can result if the cell is much smaller).
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MT'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MT_ALPHA = Quantity(
        type=str,
        shape=[],
        description='''
        Convergence parameter ALPHA*RMIN. Default value 7.0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MT.ALPHA'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MT_REL_CUTOFF = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the multiplicative factor for the CUTOFF keyword in MULTI_GRID  section.
        The result gives the cutoff at which the 1/r non-periodic FFT3D is
        evaluated.Default is 2.0
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MT.REL_CUTOFF'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE(MSection):
    '''
    Controls the checking of the G-space term Spline Interpolation.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE.FILENAME'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO(MSection):
    '''
    if convergence information about the linear solver of the spline methods should be
    printed
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR(MSection):
    '''
    controls the interpolation for the G-space term
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_AINT_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        the approximate inverse to use to get the starting point for the linear solver of
        the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.AINT_PRECOND'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_EPS_R = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the residual for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.EPS_R'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_EPS_X = Quantity(
        type=str,
        shape=[],
        description='''
        accuracy on the solution for spline3 the interpolators
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.EPS_X'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_MAX_ITER = Quantity(
        type=str,
        shape=[],
        description='''
        the maximum number of iterations
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.MAX_ITER'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_PRECOND = Quantity(
        type=str,
        shape=[],
        description='''
        The preconditioner used for the linear solver of the spline3 methods
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.PRECOND'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR_CONV_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR.CONV_INFO'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing of basic information during the run
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE(MSection):
    '''
    This section is used to set up the decoupling of QM periodic images with the use of
    density derived atomic point charges.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_ANALYTICAL_GTERM = Quantity(
        type=str,
        shape=[],
        description='''
        Evaluates the Gterm in the Ewald Scheme analytically instead of using Splines.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.ANALYTICAL_GTERM'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_EWALD_PRECISION = Quantity(
        type=str,
        shape=[],
        description='''
        Precision achieved in the Ewald sum.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.EWALD_PRECISION'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_NGRIDS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of grid points used for the Interpolation of the G-space term
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.NGRIDS'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_RCUT = Quantity(
        type=str,
        shape=[],
        description='''
        Real space cutoff for the Ewald sum.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.RCUT'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_CHECK_SPLINE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.CHECK_SPLINE'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_INTERPOLATOR'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.INTERPOLATOR'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE_PROGRAM_RUN_INFO'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE.PROGRAM_RUN_INFO'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON_WAVELET(MSection):
    '''
    Sets up parameters of  wavelet based poisson solver.This solver allows for non-
    periodic (PERIODIC NONE) boundary conditions and slab-boundary conditions (but only
    PERIODIC XZ).It does not require very large unit cells, only that the density goes to
    zero on the faces of the cell.The use of PREFERRED_FFT_LIBRARY FFTSG is required
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.WAVELET'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_WAVELET_SCF_TYPE = Quantity(
        type=str,
        shape=[],
        description='''
        Type of scaling function used in the wavelet approach, the total energy depends on
        this choice,and the convergence with respect to cutoff depends on the selected
        scaling functions.Possible values are 8,14,16,20,24,30,40,50,60,100
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.WAVELET.SCF_TYPE'))


class x_cp2k_section_input_FORCE_EVAL_MM_POISSON(MSection):
    '''
    Sets up the poisson resolutor.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_PERIODIC = Quantity(
        type=str,
        shape=[],
        description='''
        Specify the directions on wich apply PBC. Important notice,  this only applies to
        the electrostatics. See the CELL section to specify the periodicity used for e.g.
        the pair lists. Typically the settings should be the same.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.PERIODIC'))

    x_cp2k_input_FORCE_EVAL_MM_POISSON_POISSON_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Specify which kind of solver to use to solve the Poisson equation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.MM.POISSON.POISSON_SOLVER'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_EWALD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.EWALD'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MT = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MT'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MT'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_MULTIPOLE'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.MULTIPOLE'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON_WAVELET = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON_WAVELET'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON.WAVELET'))


class x_cp2k_section_input_FORCE_EVAL_MM(MSection):
    '''
    This section contains all information to run a MM calculation.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM'))

    x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_FORCEFIELD'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.FORCEFIELD'))

    x_cp2k_section_input_FORCE_EVAL_MM_NEIGHBOR_LISTS = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_NEIGHBOR_LISTS'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.NEIGHBOR_LISTS'))

    x_cp2k_section_input_FORCE_EVAL_MM_POISSON = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_MM_POISSON'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.MM.POISSON'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION1D(MSection):
    '''
    Each node prints out its distribution info ...
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION1D'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION1D_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION1D.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION2D(MSection):
    '''
    Controls the printing of the distribution of matrix blocks,...
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION2D'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION2D_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION2D.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION(MSection):
    '''
    Controls the printing of the distribution of molecules, atoms, ...
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_DISTRIBUTION_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.DISTRIBUTION.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_DISTRIBUTION_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.DISTRIBUTION.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_FORCES_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.FORCES.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_FORCES(MSection):
    '''
    Controls the printing of the forces after each force evaluation
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.FORCES'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_NDIGITS = Quantity(
        type=str,
        shape=[],
        description='''
        Specifies the number of digits used for the printing of the forces
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.NDIGITS'))

    x_cp2k_input_FORCE_EVAL_PRINT_FORCES_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.FORCES.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_FORCES_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_FORCES_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.FORCES.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_GRID_INFORMATION(MSection):
    '''
    Controls the printing of information regarding the PW and RS grid structures.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.GRID_INFORMATION'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_GRID_INFORMATION_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.GRID_INFORMATION.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_GRID_INFORMATION_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.GRID_INFORMATION.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO(MSection):
    '''
    Controls the printing of basic information generated by force_eval
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        filename.  use ./filename to get filename. A middle name (if present), iteration
        numbers and extension are always added to the filename. if you want to avoid it
        use =filename, in this case the filename is always exactly as typed. Please note
        that this can lead to clashes of filenames.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.FILENAME'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_LOG_PRINT_KEY = Quantity(
        type=str,
        shape=[],
        description='''
        This keywords enables the logger for the print_key (a message is printed on screen
        everytime data, controlled by this print_key, are written)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.LOG_PRINT_KEY'))

    x_cp2k_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_SECTION_PARAMETERS = Quantity(
        type=str,
        shape=[],
        description='''
        Level starting at which this proprety is printed
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.SECTION_PARAMETERS'))

    x_cp2k_section_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH = SubSection(
        sub_section=SectionProxy('x_cp2k_section_input_FORCE_EVAL_PRINT_PROGRAM_RUN_INFO_EACH'),
        repeats=True,
        a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.PROGRAM_RUN_INFO.EACH'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH(MSection):
    '''
    This section specifies how often this proprety is printed.Each keyword inside this
    section is mapping to a specific iteration level and the value of each of these
    keywords is matched with the iteration level during the calculation. How to handle the
    last iteration is treated separately in ADD_LAST (this mean that each iteration level
    (MD, GEO_OPT, etc..), though equal to 0, might print the last iteration). If an
    iteration level is specified that is not present in the flow of the calculation it is
    just ignored.
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_BAND = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Band Calculation Steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.BAND'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_BSSE = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Basis Set Superposition Error (BSSE) Calculation
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.BSSE'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_CELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Cell optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.CELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_EP_LIN_SOLVER = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Energy Perturbation (EP) linear solver
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.EP_LIN_SOLVER'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_GEO_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Geometry optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.GEO_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_JUST_ENERGY = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for an ENERGY/ENERGY_FORCE calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.JUST_ENERGY'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_MD = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the MD steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.MD'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_METADYNAMICS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the METADYNAMICS steps (number of hills added).
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.METADYNAMICS'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_POWELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for POWELL based optimization steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.POWELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_QS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.QS_SCF'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_REPLICA_EVAL = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the evaluation of the Replica Environment
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.REPLICA_EVAL'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_ROT_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Rotational optimization steps in the Dimer Calculation.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.ROT_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_SHELL_OPT = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the Shell-Core distances optimization steps
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.SHELL_OPT'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_SPLINE_FIND_COEFFS = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the solution of the coefficients of the splines
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.SPLINE_FIND_COEFFS'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_EACH_XAS_SCF = Quantity(
        type=str,
        shape=[],
        description='''
        Iteration level for the X-Ray Absorption Spectroscopy (XAS) SCF Steps.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.EACH.XAS_SCF'))


class x_cp2k_section_input_FORCE_EVAL_PRINT_STRESS_TENSOR(MSection):
    '''
    Controls the printing of the stress tensor
    '''

    m_def = Section(validate=False, a_legacy=LegacyDefinition(name='x_cp2k_section_input_FORCE_EVAL.PRINT.STRESS_TENSOR'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_ADD_LAST = Quantity(
        type=str,
        shape=[],
        description='''
        If the last iteration should be added, and if it should be marked symbolically
        (with lowercase letter l) or with the iteration number. Not every iteration level
        is able to identify the last iteration early enough to be able to output. When
        this keyword is activated all iteration levels are checked for the last iteration
        step.
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.ADD_LAST'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_COMMON_ITERATION_LEVELS = Quantity(
        type=str,
        shape=[],
        description='''
        How many iterations levels should be written in the same file (no extra
        information about the actual iteration level is written to the file)
        ''',
        a_legacy=LegacyDefinition(name='x_cp2k_input_FORCE_EVAL.PRINT.STRESS_TENSOR.COMMON_ITERATION_LEVELS'))

    x_cp2k_input_FORCE_EVAL_PRINT_STRESS_TENSOR_FILENAME = Quantity(
        type=str,
        shape=[],
        description='''
        controls part of the filename for output.  use __STD_OUT__ (exactly as written
        here) for the screen or standard logger.  use filename to obtain projectname-
        file