#!/bin/sh
set -e

# Load env params from env file
# expecting these env vars to be set
# MODEL_NAME
# MODEL_TYPE_ID
source ./cloud_eval/.cloud_eval_env

# create dir for log/tracing files related to cloud evaluation
mkdir -p tmp

if [ $MODEL_TYPE_ID == "-1" ]; then
  echo "Find out and fill in your model type id in [./cloud_eval/.cloud_eval_env] . You can obtain the model type id from DSP (or ask the DSP Team)"
  exit 9
fi


# params validation
if [ "$1" != "" ]; then
  VERSION="$1"
else
  echo Please provide a version name
  exit 9
fi

if [ "$2" != "" ]; then
  DATASET="$2"
else
  echo "Please provide a dataset name (i.e [1600_sig_valid.csv])"
  exit 9
fi

DESCRIPTION="version ${VERSION}"
GIT_REPO=$(git config --get remote.origin.url | sed 's/.*\/\([^ ]*\/[^.]*\).*/\1/')


if [ "${SKIP_WORKAROUNDS}" != "TRUE" ]; then
  cloud_eval/tag_version.sh "${VERSION}" "${DESCRIPTION}"
  # upload model source
#  CODE_ARCHIVE_NAME="${MODEL_NAME}${VERSION}".zip
#  #S3_MODEL_LOCATION=s3://datascience-il/sagemaker/models/sigparser/
#  S3_MODEL_LOCATION=s3://noamm-test-batch-bucket/models/${MODEL_NAME}/
#  echo "uploading model version to ${S3_MODEL_LOCATION}${CODE_ARCHIVE_NAME}" ...
#  git archive --prefix=src/ --format=zip "${VERSION}"  > ./tmp/"${CODE_ARCHIVE_NAME}"
#  aws s3 cp ./tmp/"${CODE_ARCHIVE_NAME}" ${S3_MODEL_LOCATION}
fi


#STEPFUNCTION_STATE_MACHINE="arn:aws:states:us-east-2:767086418253:stateMachine:DS_IL_Model_Evaluation_Full"
#STEPFUNCTION_STATE_MACHINE="arn:aws:states:us-east-2:767086418253:stateMachine:DS_IL_Model_Evaluation_Full_Batch"
STEPFUNCTION_STATE_MACHINE="arn:aws:states:us-east-2:769057607614:stateMachine:DS_IL_Model_Evaluation_Full_Batch"
STEPFUNCTION_INPUT='{"env": "prd", "model": {"name": "'${MODEL_NAME}'", "version": "'${VERSION}'", "type_id": "'${MODEL_TYPE_ID}'", "repo": "'${GIT_REPO}'"}, "dataset": { "name": "'${DATASET}'" }}'
echo starting evalutation flow...
aws stepfunctions start-execution --region us-east-2 --state-machine-arn "${STEPFUNCTION_STATE_MACHINE}" --input "$STEPFUNCTION_INPUT" > ./tmp/exec_eval.json
echo "Simulation is underway with ${STEPFUNCTION_INPUT}. Execution details in ./tmp/exec_eval.json"
