# Neo Aramaic transcriptions

<style>
body {
    font-family: sans-serif;
}
pre.chars {
    border-collapse: collapse;
    color: #000080;
    font-family: monospace;
    font-size: medium;
    line-height: 1.0;
}
</style>

The following table is provided by the collectors of the
[NENA](https://github.com/CambridgeSemiticsLab/nena_corpus)
corpus at
[Cambridge Semitics Lab](https://github.com/CambridgeSemiticsLab).

There is also a
[PDF](../images/neoaramaic.pdf)
of the table below.


## Vowel inventory and conversions

### Special vowel signs

<pre class="chars">
┏━━━━━━━━━━━━━┳━━┯━━┯━━┯━━━┯━━━┯━━┯━━━┯━━━┯━┯━━┯━┯━┯━━┯━━┯━┯━┯━━┯━┯━━┯━━┯━┯━┓
┃             ┃á │à │ā │ā̀  │ā́  │ă │ắ  │ằ  │e│ē │ɛ│i│ī │ĭ │ə│o│ō │u│ū │ŭ │ı│ɑ┃
┠─────────────╂──┼──┼──┼───┼───┼──┼───┼───┼─┼──┼─┼─┼──┼──┼─┼─┼──┼─┼──┼──┼─┼─┨
┃precise match┃a'│a`│a-│a-`│a-'│a>│a>'│a>`│e│e-│3│i│i-│i>│9│o│o-│u│u-│u<│i│a┃
┃lite         ┃a │a │A │A  │A  │@ │@  │@  │e│E │3│i│I │9 │9│o│O │u│U │2 │i│a┃
┃fuzzy        ┃a │a │a │a  │a  │a │a  │a  │e│e │e│i│i │i │i│o│o │u│u │u │i│a┃
┗━━━━━━━━━━━━━┻━━┷━━┷━━┷━━━┷━━━┷━━┷━━━┷━━━┷━┷━━┷━┷━┷━━┷━━┷━┷━┷━━┷━┷━━┷━━┷━┷━┛
</pre>

##Symbol inventory for conversions

### Special signs alphabetical

<pre class="chars">
┏━━━━━━━━━━━━━┳━━━━━━┯━┯━┯━━┯━━┯━━━┯━━━┯━━┯━┯━┯━━┯━━┯━┯━━┯━━┯━━┯━━━┯━━┯━━┯━━┯━━┯━━┯━┯━┯━━┯━━┓
┃             ┃ʾ     │ʿ│c│c̭ │č │č̭  │č̣  │ḍ │ð│ð̣│ġ │ḥ │ɟ│k̭ │ḷ │ṃ │p̭,p̌│p̣ │ṛ │ṣ │š │ṱ │ṭ│θ│ž │ẓ ┃
┠─────────────╂──────┼─┼─┼──┼──┼───┼───┼──┼─┼─┼──┼──┼─┼──┼──┼──┼───┼──┼──┼──┼──┼──┼─┼─┼──┼──┨
┃precise match┃)     │(│c│c<│>c│>c<│>c.│d.│6│6│g.│h.│4│k<│l.│m.│p< │p.│r.│s.│>s│t<│t│8│>z│z.┃
┃lite         ┃)     │(│c│c │5 │*  │%  │D │6│^│G │H │4│& │L │M │p  │P │R │S │$ │+ │T│8│7 │Z ┃
┃fuzzy_all    ┃ignore│(│ │  │5 │5  │5  │d │d│d│g │h │ │  │l │m │p  │p │r │s │s │t │t│ │z │z ┃
┃fuzzy_Urmi   ┃      │ │k│k │  │   │   │  │ │ │  │  │g│q │  │  │   │  │  │  │  │  │ │ │  │  ┃
┃fuzzy_Barwar ┃      │ │ │  │  │   │   │  │d│ │  │  │ │k │  │  │   │  │  │  │  │  │ │t│  │  ┃
┗━━━━━━━━━━━━━┻━━━━━━┷━┷━┷━━┷━━┷━━━┷━━━┷━━┷━┷━┷━━┷━━┷━┷━━┷━━┷━━┷━━━┷━━┷━━┷━━┷━━┷━━┷━┷━┷━━┷━━┛
</pre>

### Capitals

<pre class="chars">
┏━━━━━━━━━━━━━┳━┯━┯━┯━┯━┯━┯━┯━┯━┯━┯━┯━┯━┯━┯━┓
┃             ┃ḍ│ġ│ḥ│ḷ│ṃ│p̣│ṛ│ṣ│ṭ│ẓ│ā│ē│ī│ō│ū┃
┠─────────────╂─┼─┼─┼─┼─┼─┼─┼─┼─┼─┼─┼─┼─┼─┼─┨
┃lite         ┃D│G│H│L│M│P│R│S│T│Z│A│E│I│O│U┃
┗━━━━━━━━━━━━━┻━┷━┷━┷━┷━┷━┷━┷━┷━┷━┷━┷━┷━┷━┷━┛
</pre>

### Special symbols

<pre class="chars">
┏━━━━━━━━━━━━━┳━┯━┯━┯━┯━┯━┯━┓
┃             ┃č̭│č̣│ð̣│k̭│ṱ│š│ă┃
┠─────────────╂─┼─┼─┼─┼─┼─┼─┨
┃lite         ┃*│%│^│&│+│$│@┃
┗━━━━━━━━━━━━━┻━┷━┷━┷━┷━┷━┷━┛
</pre>

### Numbers

<pre class="chars">
┏━━━━━━━━━━━━━┳━┯━┯━┯━┯━┯━┯━┯━┓
┃             ┃ŭ│ɛ│ɟ│č│ð│ž│θ│ə┃
┠─────────────╂─┼─┼─┼─┼─┼─┼─┼─┨
┃lite         ┃2│3│4│5│6│7│8│9┃
┗━━━━━━━━━━━━━┻━┷━┷━┷━┷━┷━┷━┷━┛
</pre>

## Consonant phoneme inventory: Lite and fuzzy conversions

**Legend**

**lt** = *lite*

**fz** = *fuzzy*

**fzUr** = *fuzzy Urmi*

**є** = empty


<pre class="chars">
┏━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━┳━━━━━━┳━━━━━━━┳━━━━━━━┓
┃                    ┃labial   ┃dental- ┃palatal-┃palatal┃(post-)┃uvular┃pharyn-┃laryn- ┃
┃                    ┃         ┃alveolar┃alveolar┃       ┃velar  ┃      ┃geal   ┃geal   ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━┯━━┯━━╋━┯━━┯━━━╋━┯━━┯━━━╋━┯━━┯━━╋━┯━━┯━━╋━━┯━━━╋━┯━━┯━━╋━┯━━┯━━┫
┃Stops/affricates    ┃   │lt│fz┃ │lt│fz ┃ │lt│fz ┃ │lt│fz┃ │lt│fz┃  │   ┃ │lt│fz┃ │lt│fz┃
┃                    ┃   │  │  ┃ │  │   ┃ │  │   ┃ │  │Ur┃ │  │Ur┃  │   ┃ │  │  ┃ │  │  ┃
┠────────────────────╂───┼──┼──╂─┼──┼───╂─┼──┼───╂─┼──┼──╂─┼──┼──╂──┼───╂─┴──┴──╂─┼──┼──┨
┃Unvoiced aspirated  ┃p  │p │  ┃t│t │t  ┃č│5 │5  ┃c│c │k ┃k│k │k ┃ q│q  ┃       ┃ʾ│) │є ┃
┃Unvoiced unaspirated┃p̭,p̌│p │p ┃ṱ│+ │t  ┃č̭│* │5  ┃c̭│c │k ┃k̭│& │q ┃  │   ┃       ┃ │  │  ┃
┃Voiced              ┃b  │b │  ┃d│d │d  ┃j│j │j  ┃ɟ│4 │g ┃g│g │g ┃  │   ┃       ┃ │  │  ┃
┃Emphatic            ┃p̣  │P │p ┃ṭ│T │t  ┃č│% │5  ┃ │  │  ┃ │  │  ┃  │   ┃       ┃ │  │  ┃
┃                    ┃   │  │  ┃ḍ│D │d  ┃ │  │   ┃ │  │  ┃ │  │  ┃  │   ┃       ┃ │  │  ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━┷━━┷━━╋━┷━━┷━━━╋━┷━━┷━━━┻━┷━━┷━━╋━┷━━┷━━╋━━┷━━━╋━━━━━━━╋━┷━━┷━━┫
┃Fricatives          ┃         ┃        ┃                ┃       ┃      ┃       ┃       ┃
┠────────────────────╂───┬──┬──╂─┬──┬───┨                ┠─┬──┬──┨      ┠─┬──┬──╂─┬──┬──┨
┃Unvoiced            ┃f  │f │f ┃θ│8 │t  ┃                ┃x│x │x ┃      ┃ḥ│H │h ┃h│h │h ┃
┃Voiced              ┃v  │v │w ┃ð│6 │d  ┃                ┃ġ│G │g ┃      ┃ │  │  ┃ │  │  ┃
┃Emphatic            ┃   │  │  ┃ð̣│^ │d  ┃                ┃ │  │  ┃      ┃ʿ│( │( ┃ │  │  ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━┷━━┷━━╋━┷━━┷━━━╋━━━━━━━━┓       ┗━┷━━┷━━┛      ┗━┷━━┷━━┻━┷━━┷━━┫
┃Sibilants           ┃         ┃        ┃        ┃                                      ┃
┠────────────────────┨         ┠─┬──┬───╂─┬──┬───┨                                      ┃
┃Unvoiced            ┃         ┃s│s │s  ┃š│$ │s  ┃                                      ┃
┃Voiced              ┃         ┃z│z │z  ┃ž│7 │z  ┃                                      ┃
┃Emphatic            ┃         ┃ṣ│S │s  ┃ │  │   ┃                                      ┃
┃                    ┃         ┃ẓ│Z │z  ┃ │  │   ┃                                      ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━━━━━━━╋━┷━━┷━━━╋━┷━━┷━━━┛                                      ┃
┃Nasals              ┃         ┃        ┃                                               ┃
┠────────────────────╂───┬──┬──╂─┬──┬───┨                                               ┃
┃Plain               ┃m  │m │m ┃n│n │n  ┃                                               ┃
┃Emphatic            ┃ṃ  │M │m ┃ │  │   ┃                                               ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━┷━━┷━━╋━┷━━┷━━━┫                                               ┃
┃Laterals            ┃         ┃        ┃                                               ┃
┠────────────────────┨         ┠─┬──┬───┨                                               ┃
┃Plain               ┃         ┃l│l │l  ┃                                               ┃
┃Emphatic            ┃         ┃ḷ│L │l  ┃                                               ┃
┣━━━━━━━━━━━━━━━━━━━━╋━━━━━━━━━╋━┷━━┷━━━┫        ┏━━━━━━━┓                              ┃
┃Other approximants  ┃         ┃        ┃        ┃       ┃                              ┃
┠────────────────────╂───┬──┬──╂─┬──┬───┨        ┠─┬──┬──┨                              ┃
┃Plain               ┃w  │w │w ┃r│r │r  ┃        ┃y│y │y ┃                              ┃
┃Emphatic            ┃   │  │  ┃ṛ│R │r  ┃        ┃ │  │  ┃                              ┃
┗━━━━━━━━━━━━━━━━━━━━┻━━━┷━━┷━━┻━┷━━┷━━━┻━━━━━━━━┻━┷━━┷━━┻━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
</pre>
