<img src="/tf/docs/images/tf-small.png" align="left"/>

# Text-Fabric

[![SWH](https://archive.softwareheritage.org/badge/origin/https://github.com/annotation/text-fabric/)](https://archive.softwareheritage.org/browse/origin/https://github.com/annotation/text-fabric/)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1008899.svg)](https://doi.org/10.5281/zenodo.592193)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/2592/badge)](https://bestpractices.coreinfrastructure.org/projects/2592)
[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
---

A corpus of ancient texts and (linguistic) annotations represents a large body of knowledge.
Text-Fabric makes that knowledge accessible to programmers and non-programmers.

Text-Fabric is machinery for processing such corpora as annotated graphs.
It treats corpora and annotations as data, much like big tables, but without
loosing the rich structure of text, such as embedding and multiple representations.
It deals with text in a state where all markup is gone, but where the complete logical
structure still sits in the data.

All about Text-Fabric is in the
[docs](https://annotation.github.io/text-fabric/tf).

Want to contribute?
Start with the [contribution notes](codestyle/contributing.md).

Found a vulnerability? Please read the [security note](SECURITY.md).

# Author

[Dirk Roorda](https://github.com/dirkroorda)

---

**This repository is being archived continuously by the 
[Software Heritage Archive](https://archive.softwareheritage.org).
If you want to cite snippets of the code of this repository, the Software Archive
offers an easy and elegant way to do so.
As an example, here I quote the 
[*stitching* algorithm](https://archive.softwareheritage.org/swh:1:cnt:6169c074089ddc8a0e048cb67e1fec57857ef54d;lines=3224-3270/),
by means of which Text-Fabric Search collects the solutions of a
[search template](https://annotation.github.io/text-fabric/tf/about/use.html).
The quote refers directly to specific lines of code, deeply buried in
a Python file within a particular version of Text-Fabric.**
