//Anime4K v3.0 GLSL

// MIT License

// Copyright (c) 2019-2020 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v3.0-RA-CNN(UL)-Downsample
//!HOOK NATIVE
//!BIND HOOKED
//!SAVE BACKUP

vec4 hook() {
	return HOOKED_tex(HOOKED_pos);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Downsample
//!HOOK NATIVE
//!BIND HOOKED
//!WIDTH NATIVE.w 2 /
//!HEIGHT NATIVE.h 2 /

vec4 hook() {
	return HOOKED_tex(HOOKED_pos);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!SAVE LUMAN00

vec4 hook() {
    vec2 dp = HOOKED_pt;
    float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
    float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
    float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
    float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
    float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
    float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
    float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
    float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
    float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;
    float s = 0.4227713*a + 0.65122205*b + -0.5894138*c + 0.12043042*d + 0.0069211754*e + -0.39494568*f + -0.099531725*g + -0.19280484*h + 0.0692256*i + 0.0059006587;
    float t = 0.56819385*a + -0.3877415*b + -0.55708647*c + -0.3175206*d + -0.3950954*e + 0.3758771*f + -0.5951176*g + 0.43890274*h + 0.69218725*i + -0.018986855;
    float u = 0.78672326*a + -0.50350785*b + -0.07692569*c + -0.7258339*d + 0.5834824*e + -0.067126095*f + -0.07342367*g + -0.029570417*h + 0.10244534*i + -0.00014415548;
    float v = -0.32709953*a + 0.05759759*b + 0.15932003*c + 0.19741072*d + 0.471859*e + -0.10562332*f + -0.39081043*g + -0.6708356*h + -0.035092503*i + -0.0720328;
    return vec4(s, t, u, v);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!SAVE LUMAN01

vec4 hook() {
    vec2 dp = HOOKED_pt;
    float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
    float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
    float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
    float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
    float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
    float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
    float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
    float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
    float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;
    float s = 0.14976382*a + -0.339064*b + 0.41322896*c + -0.56487453*d + -0.2509627*e + 0.19731471*f + 0.43869543*g + -0.09666573*h + -0.00792537*i + 0.06936363;
    float t = 0.10662149*a + -0.30642352*b + 0.3910136*c + -0.24240156*d + 0.4359778*e + -0.036186576*f + -0.016642952*g + -0.31993437*h + 0.3249198*i + 0.010320611;
    float u = 0.07377618*a + 0.5356365*b + -0.27441797*c + 0.13227409*d + -0.60764945*e + 0.28083587*f + 0.18271726*g + -0.9480309*h + 0.6223682*i + 0.015635386;
    float v = -0.43209586*a + 0.6188276*b + 0.27700275*c + -0.3111068*d + -0.22504452*e + 0.3990561*f + 0.11323281*g + -0.38872832*h + -0.110977426*i + 0.09095626;
    return vec4(s, t, u, v);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN00
//!BIND LUMAN01
//!SAVE LUMAN10

#define L0_tex LUMAN00_tex
#define L1_tex LUMAN01_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.16713218*a0.x + -0.22038573*b0.x + -0.13005029*c0.x + 0.35234368*d0.x + -0.24986069*e0.x + -0.03652803*f0.x + -0.0035137152*g0.x + -0.13065901*h0.x + 0.050993465*i0.x;
    float j = -0.15454529*a0.y + -0.18509507*b0.y + -0.070899874*c0.y + -0.055521097*d0.y + -0.08797286*e0.y + 0.017017594*f0.y + -0.07720207*g0.y + 0.030161398*h0.y + 0.07854566*i0.y;
    float k = -0.069296815*a0.z + 0.034658875*b0.z + 0.06815528*c0.z + 0.07031576*d0.z + 0.074399784*e0.z + -0.030513955*f0.z + 0.15191276*g0.z + 0.17954811*h0.z + 0.083867356*i0.z;
    float l = -0.2704385*a0.w + -0.143406*b0.w + -0.1905286*c0.w + 0.2303636*d0.w + -0.18995604*e0.w + -0.22714588*f0.w + 0.001024007*g0.w + 0.074870616*h0.w + 0.023121383*i0.w;
    float m = 0.0139397*a1.x + -0.22468825*b1.x + -0.19181927*c1.x + -0.18277143*d1.x + 0.14706787*e1.x + 0.19927207*f1.x + 0.13652366*g1.x + 0.06386827*h1.x + 0.00095346326*i1.x;
    float n = 0.14147504*a1.y + -0.14072193*b1.y + 0.1730557*c1.y + -0.002492399*d1.y + -0.55425644*e1.y + -0.19250399*f1.y + -0.20097452*g1.y + -0.29845634*h1.y + -0.094047815*i1.y;
    float o = 0.11046322*a1.z + -0.09760678*b1.z + -0.18652314*c1.z + 0.108983986*d1.z + 0.18999153*e1.z + -0.02505891*f1.z + 0.029467393*g1.z + 0.049988672*h1.z + -0.089773245*i1.z;
    float p = 0.18450986*a1.w + 0.109294355*b1.w + -0.112934336*c1.w + 0.047062654*d1.w + -0.04816292*e1.w + 0.13094686*f1.w + -0.0065878364*g1.w + 0.08924863*h1.w + 0.11312074*i1.w;
    float q = -0.12602906*na0.x + 0.37861553*nb0.x + 0.074422106*nc0.x + -0.3033126*nd0.x + -0.028096324*ne0.x + 0.050496474*nf0.x + 0.2239116*ng0.x + 0.1933884*nh0.x + -0.025817746*ni0.x;
    float r = 0.17847398*na0.y + 0.15596001*nb0.y + 0.09058693*nc0.y + 0.088395216*nd0.y + 0.05719792*ne0.y + -0.050784174*nf0.y + 0.04196272*ng0.y + -0.020845385*nh0.y + -0.0832895*ni0.y;
    float s = -0.24801292*na0.z + -0.37903556*nb0.z + -0.06962685*nc0.z + -0.194872*nd0.z + -0.13542567*ne0.z + -0.047440834*nf0.z + -0.20618482*ng0.z + 0.036017656*nh0.z + -0.083059475*ni0.z;
    float t = -0.050698828*na0.w + 0.076336786*nb0.w + 0.18337938*nc0.w + 0.067153335*nd0.w + 0.2950129*ne0.w + 0.015040506*nf0.w + -0.04881478*ng0.w + -0.06797305*nh0.w + 0.06590701*ni0.w;
    float u = -0.03218409*na1.x + 0.25265154*nb1.x + 0.24500562*nc1.x + 0.25738174*nd1.x + -0.21151006*ne1.x + -0.30471176*nf1.x + -0.06567392*ng1.x + -0.13929898*nh1.x + -0.05080991*ni1.x;
    float v = -0.22504985*na1.y + -0.030114856*nb1.y + -0.14878646*nc1.y + 0.076497145*nd1.y + 0.8536939*ne1.y + 0.11066291*nf1.y + 0.25284055*ng1.y + 0.3632721*nh1.y + 0.18241458*ni1.y;
    float w = 0.18823417*na1.z + 0.122003764*nb1.z + 0.1791294*nc1.z + 0.0069658747*nd1.z + -0.18533462*ne1.z + 0.06976361*nf1.z + -0.07724821*ng1.z + -0.02718515*nh1.z + 1.7301045e-05*ni1.z;
    float x = -0.12598836*na1.w + -0.1243634*nb1.w + 0.0985588*nc1.w + -0.06536376*nd1.w + 0.08385393*ne1.w + -0.09142982*nf1.w + -0.03531486*ng1.w + -0.038505223*nh1.w + -0.13392809*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.080690674;
    i = -0.01283581*a0.x + -0.018502438*b0.x + -0.02645647*c0.x + 0.42137372*d0.x + -0.31610605*e0.x + 0.1444233*f0.x + 0.0064831083*g0.x + -0.34260628*h0.x + -0.21241646*i0.x;
    j = 0.08500891*a0.y + -0.02485644*b0.y + -0.097824536*c0.y + -0.15899487*d0.y + -0.005132324*e0.y + 0.07605907*f0.y + -0.119112104*g0.y + -0.05230375*h0.y + 0.15778321*i0.y;
    k = -0.045043983*a0.z + 0.22099558*b0.z + 0.09173644*c0.z + -0.14121144*d0.z + -0.3364683*e0.z + 0.6992921*f0.z + 0.1879735*g0.z + 0.43442908*h0.z + 0.2507738*i0.z;
    l = 0.014832014*a0.w + -0.3057155*b0.w + -0.26674822*c0.w + 0.65893346*d0.w + 0.13837902*e0.w + 0.26448116*f0.w + 0.01925406*g0.w + 0.24712183*h0.w + 0.11824173*i0.w;
    m = -0.17148696*a1.x + -0.034435242*b1.x + -0.16856827*c1.x + 0.24088557*d1.x + 0.27181336*e1.x + 0.35544765*f1.x + -0.0637484*g1.x + 0.1394016*h1.x + 0.07805505*i1.x;
    n = -0.036200132*a1.y + -0.32828653*b1.y + -0.12464492*c1.y + 0.07681443*d1.y + -0.31755948*e1.y + -0.16249253*f1.y + 0.1459527*g1.y + -0.055870246*h1.y + -0.2188885*i1.y;
    o = -0.10257012*a1.z + 0.1738694*b1.z + 0.011674502*c1.z + 0.014357164*d1.z + 0.05336581*e1.z + -0.10754941*f1.z + 0.0053562997*g1.z + -0.20323943*h1.z + -0.044117864*i1.z;
    p = -0.00781972*a1.w + 0.2752947*b1.w + 0.07748963*c1.w + 0.0701277*d1.w + -0.1437367*e1.w + 0.27562895*f1.w + -0.09910902*g1.w + 0.10083873*h1.w + -0.12653753*i1.w;
    q = -0.0744636*na0.x + 0.030761313*nb0.x + 0.17157815*nc0.x + -0.27698746*nd0.x + 0.20659466*ne0.x + -0.12475179*nf0.x + 0.097487606*ng0.x + 0.47216818*nh0.x + 0.18254276*ni0.x;
    r = -0.17130595*na0.y + 0.08279622*nb0.y + 0.1008618*nc0.y + 0.10624062*nd0.y + 0.09339325*ne0.y + -0.12885687*nf0.y + 0.10866262*ng0.y + 0.015784606*nh0.y + -0.156208*ni0.y;
    s = 0.13901633*na0.z + -0.19871095*nb0.z + -0.1233926*nc0.z + 0.22571099*nd0.z + 0.5192358*ne0.z + -0.006695737*nf0.z + -0.23417531*ng0.z + -0.53020126*nh0.z + 0.0348989*ni0.z;
    t = 0.019743124*na0.w + 0.113042444*nb0.w + 0.044767845*nc0.w + -0.12496372*nd0.w + 0.7285443*ne0.w + 0.075844646*nf0.w + 0.003659028*ng0.w + -0.081003755*nh0.w + -0.1571919*ni0.w;
    u = 0.17188495*na1.x + 0.15267436*nb1.x + 0.12122173*nc1.x + -0.17361204*nd1.x + -0.35425422*ne1.x + -0.30314827*nf1.x + 0.112297654*ng1.x + -0.19984588*nh1.x + -0.17648791*ni1.x;
    v = 0.064333946*na1.y + 0.2798676*nb1.y + 0.029879512*nc1.y + -0.44719884*nd1.y + 0.37984368*ne1.y + 0.24928248*nf1.y + -0.26490667*ng1.y + -0.042627275*nh1.y + 0.34140655*ni1.y;
    w = 0.13693564*na1.z + -0.014451857*nb1.z + -0.13929443*nc1.z + 0.09930806*nd1.z + -0.0018792403*ne1.z + 0.14395392*nf1.z + 0.013773326*ng1.z + 0.28621295*nh1.z + 0.12418545*ni1.z;
    x = -0.07243978*na1.w + -0.20915549*nb1.w + -0.1439757*nc1.w + -0.030371284*nd1.w + 0.066944584*ne1.w + -0.19054636*nf1.w + 0.11164318*ng1.w + 0.013230124*nh1.w + 0.12154718*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.13904701;
    i = 0.08556065*a0.x + -0.06385027*b0.x + 0.08451666*c0.x + -0.16397515*d0.x + -0.12554236*e0.x + 0.51485914*f0.x + -0.3609132*g0.x + 0.22237258*h0.x + -0.14084372*i0.x;
    j = -0.29552463*a0.y + -0.07839635*b0.y + 0.023714216*c0.y + -0.39852586*d0.y + -0.0037621707*e0.y + 0.12410286*f0.y + 0.28074482*g0.y + 0.19966023*h0.y + -0.1299575*i0.y;
    k = -0.018056538*a0.z + -0.29889175*b0.z + 0.12264207*c0.z + 0.399607*d0.z + -0.08105918*e0.z + -0.006207723*f0.z + 0.19156073*g0.z + -0.4190811*h0.z + 0.41379926*i0.z;
    l = 0.25313407*a0.w + 0.2056271*b0.w + 0.1281935*c0.w + -0.4088654*d0.w + -0.75592035*e0.w + 0.677332*f0.w + -0.17531727*g0.w + -0.09792362*h0.w + 0.38767898*i0.w;
    m = 0.32970557*a1.x + 0.03836402*b1.x + -0.08182981*c1.x + 0.23050149*d1.x + 0.2949245*e1.x + -0.031266343*f1.x + 0.011828161*g1.x + 0.18952376*h1.x + -0.08358268*i1.x;
    n = 0.03825189*a1.y + 0.34718156*b1.y + 0.27608556*c1.y + -0.11617564*d1.y + -0.66690236*e1.y + 0.36254305*f1.y + -0.5285547*g1.y + 0.108788565*h1.y + -0.23637791*i1.y;
    o = 0.29810092*a1.z + -0.18387158*b1.z + -0.082416594*c1.z + -0.34253722*d1.z + 0.0759425*e1.z + -0.060609326*f1.z + -0.043806862*g1.z + 0.1224182*h1.z + 0.28538787*i1.z;
    p = -0.1166321*a1.w + -0.14290577*b1.w + -0.088152096*c1.w + 0.13844585*d1.w + 0.37557498*e1.w + 0.2985052*f1.w + 0.47108272*g1.w + -0.3133265*h1.w + 0.2837646*i1.w;
    q = -0.08935695*na0.x + -0.011969543*nb0.x + 0.11739229*nc0.x + 0.22418295*nd0.x + 0.51131123*ne0.x + 0.06826982*nf0.x + 0.06986366*ng0.x + -0.13083175*nh0.x + -0.0384642*ni0.x;
    r = 0.32759568*na0.y + 0.058782384*nb0.y + -0.097732335*nc0.y + 0.51180387*nd0.y + -0.062388137*ne0.y + -0.036372434*nf0.y + -0.28633046*ng0.y + -0.18776499*nh0.y + 0.13661087*ni0.y;
    s = -0.090851374*na0.z + 0.42352006*nb0.z + 0.39775237*nc0.z + -0.5250993*nd0.z + -0.28369164*ne0.z + 0.56977206*nf0.z + -0.32605034*ng0.z + -0.3297984*nh0.z + -0.9174496*ni0.z;
    t = -0.20263617*na0.w + 0.014055401*nb0.w + -0.015539904*nc0.w + -0.0056373915*nd0.w + 0.46529755*ne0.w + 0.20198935*nf0.w + 0.10306982*ng0.w + -0.1603279*nh0.w + -0.09719618*ni0.w;
    u = -0.37491882*na1.x + 0.0065687397*nb1.x + -0.075094976*nc1.x + -0.2910323*nd1.x + -0.31070456*ne1.x + -0.3181396*nf1.x + -0.2874679*ng1.x + -0.05630924*nh1.x + -0.08283336*ni1.x;
    v = 0.22579186*na1.y + -0.008379712*nb1.y + -0.13981205*nc1.y + 0.4876711*nd1.y + 0.75476116*ne1.y + -0.3979911*nf1.y + 0.17194936*ng1.y + 0.063620836*nh1.y + -0.2838596*ni1.y;
    w = -0.59080386*na1.z + 0.10265678*nb1.z + 0.44757754*nc1.z + 0.118315265*nd1.z + -0.17929387*ne1.z + 0.53549635*nf1.z + -0.16386764*ng1.z + -0.18721534*nh1.z + -0.07925579*ni1.z;
    x = 0.12679473*na1.w + 0.09201327*nb1.w + 0.11743293*nc1.w + -0.089954264*nd1.w + 0.025260787*ne1.w + -0.29346317*nf1.w + -0.40280733*ng1.w + 0.3339367*nh1.w + -0.2733761*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.18129607;
    i = -0.17462935*a0.x + 0.08743981*b0.x + 0.116527654*c0.x + -0.11788807*d0.x + 0.345168*e0.x + 0.12373737*f0.x + 0.061705504*g0.x + -0.03186453*h0.x + -0.14678453*i0.x;
    j = 0.3424341*a0.y + 0.18152006*b0.y + 0.10626323*c0.y + 0.080005355*d0.y + 0.27044943*e0.y + -0.05666261*f0.y + 0.08009715*g0.y + -0.038603935*h0.y + 0.1343475*i0.y;
    k = -0.076163*a0.z + -0.10620224*b0.z + 0.0471776*c0.z + -0.18697739*d0.z + 0.81948966*e0.z + 0.104977295*f0.z + -0.049898446*g0.z + 0.030969273*h0.z + -0.24446999*i0.z;
    l = 0.11316597*a0.w + -0.72845197*b0.w + 0.14612307*c0.w + -0.05467936*d0.w + 0.33790386*e0.w + 0.47690153*f0.w + 0.03290898*g0.w + 0.18591514*h0.w + 0.086933084*i0.w;
    m = 0.024091808*a1.x + 0.21152216*b1.x + 0.10427507*c1.x + 0.12340303*d1.x + 0.30569288*e1.x + -0.10540736*f1.x + 0.21034092*g1.x + 0.0078070415*h1.x + -0.15554547*i1.x;
    n = -0.30977434*a1.y + -0.12402293*b1.y + 0.06854388*c1.y + -0.059533276*d1.y + 0.29335344*e1.y + 0.06032923*f1.y + 0.10502131*g1.y + 0.0025917962*h1.y + 0.011287433*i1.y;
    o = 0.21300381*a1.z + 0.13182314*b1.z + -0.1794802*c1.z + 0.041218325*d1.z + -0.084293015*e1.z + -0.07785635*f1.z + 0.005804347*g1.z + -0.090246014*h1.z + -0.07069001*i1.z;
    p = -0.0090839965*a1.w + 0.13686492*b1.w + 0.1999011*c1.w + -0.18534096*d1.w + -0.03643351*e1.w + 0.3022044*f1.w + 0.020653404*g1.w + -0.053792052*h1.w + 0.08029478*i1.w;
    q = 0.09313165*na0.x + -0.20987953*nb0.x + -0.13642266*nc0.x + 0.01774858*nd0.x + -0.32583392*ne0.x + -0.10607029*nf0.x + 0.062344737*ng0.x + 0.22812237*nh0.x + 0.018149327*ni0.x;
    r = -0.4551336*na0.y + -0.18321747*nb0.y + -0.10392498*nc0.y + -0.11381515*nd0.y + -0.27942544*ne0.y + 0.107884325*nf0.y + -0.083248846*ng0.y + 0.014200544*nh0.y + -0.08907091*ni0.y;
    s = 0.120486066*na0.z + 0.16473046*nb0.z + -0.028575819*nc0.z + 0.17433837*nd0.z + -0.4197916*ne0.z + -0.24925393*nf0.z + 0.013189131*ng0.z + 0.039529253*nh0.z + 0.2124912*ni0.z;
    t = -0.042864945*na0.w + 0.514165*nb0.w + -0.16705744*nc0.w + 0.26858032*nd0.w + 0.025890924*ne0.w + -0.12886028*nf0.w + -0.0093325935*ng0.w + 0.036776513*nh0.w + -0.06780495*ni0.w;
    u = -0.09991671*na1.x + -0.24013445*nb1.x + -0.043176726*nc1.x + -0.06255361*nd1.x + -0.43966636*ne1.x + 0.03481608*nf1.x + -0.1976385*ng1.x + 0.025012735*nh1.x + 0.12251629*ni1.x;
    v = 0.03532957*na1.y + -0.12534937*nb1.y + -0.111054376*nc1.y + -0.32459697*nd1.y + -0.036310744*ne1.y + 0.10149172*nf1.y + 0.04345607*ng1.y + -0.1690419*nh1.y + 0.15201193*ni1.y;
    w = 0.0020700989*na1.z + 0.018126104*nb1.z + 0.1968919*nc1.z + -0.033329114*nd1.z + 0.20545799*ne1.z + 0.025382748*nf1.z + 0.11418677*ng1.z + 0.13705094*nh1.z + 0.012681161*ni1.z;
    x = -0.14087495*na1.w + -0.072729364*nb1.w + -0.24772419*nc1.w + 0.17076711*nd1.w + -0.021828393*ne1.w + -0.10543231*nf1.w + 0.014692333*ng1.w + 0.031828444*nh1.w + -0.14082411*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.10608039;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN00
//!BIND LUMAN01
//!SAVE LUMAN11

#define L0_tex LUMAN00_tex
#define L1_tex LUMAN01_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.08251482*a0.x + 0.29106933*b0.x + 0.059387296*c0.x + 0.37380347*d0.x + -0.21551596*e0.x + -0.050368074*f0.x + 0.06634412*g0.x + -0.3150945*h0.x + -0.14561915*i0.x;
    float j = 0.1698925*a0.y + -0.059246074*b0.y + 0.08630799*c0.y + 0.02389207*d0.y + 0.03793831*e0.y + -0.0582392*f0.y + -0.03397385*g0.y + -0.24723254*h0.y + 0.21064827*i0.y;
    float k = -0.21669565*a0.z + -0.19199888*b0.z + -0.24721447*c0.z + -0.7302215*d0.z + -0.4305342*e0.z + -0.1251449*f0.z + -0.07891673*g0.z + 0.36592582*h0.z + 0.25768483*i0.z;
    float l = 0.4126826*a0.w + 0.20862694*b0.w + 0.5041565*c0.w + -0.24220178*d0.w + -0.32580248*e0.w + 0.0035771998*f0.w + 0.19374675*g0.w + 0.050378945*h0.w + -0.12696394*i0.w;
    float m = -0.140747*a1.x + -0.097618654*b1.x + -0.42250344*c1.x + 0.1810929*d1.x + -0.114540584*e1.x + -0.06470164*f1.x + 0.025054755*g1.x + 0.1210664*h1.x + -0.06487856*i1.x;
    float n = 0.044984564*a1.y + -0.09150712*b1.y + 0.03883413*c1.y + 0.2700107*d1.y + -0.1924873*e1.y + -0.016006626*f1.y + 0.1937291*g1.y + -0.14800532*h1.y + -0.06977464*i1.y;
    float o = 0.028001428*a1.z + 0.38993812*b1.z + -0.24332824*c1.z + 0.03010299*d1.z + 0.55186975*e1.z + 0.04203979*f1.z + -0.06724078*g1.z + -0.30162588*h1.z + -0.18771334*i1.z;
    float p = -0.17779396*a1.w + 0.14025119*b1.w + 0.39543924*c1.w + -0.11448653*d1.w + 0.3944919*e1.w + 0.5594662*f1.w + 0.22536032*g1.w + 0.09355939*h1.w + -0.05477075*i1.w;
    float q = -0.05063325*na0.x + -0.19487661*nb0.x + -0.0486381*nc0.x + -0.4099135*nd0.x + 0.15758072*ne0.x + -0.14006934*nf0.x + 0.016247243*ng0.x + 0.21706717*nh0.x + 0.1730037*ni0.x;
    float r = -0.18323535*na0.y + 0.116462864*nb0.y + -0.08039124*nc0.y + -0.06274208*nd0.y + 0.053934556*ne0.y + 0.0833979*nf0.y + 0.060505584*ng0.y + 0.20092015*nh0.y + -0.20753656*ni0.y;
    float s = 0.10038492*na0.z + -0.097845115*nb0.z + -0.20988423*nc0.z + 0.56715375*nd0.z + 0.344541*ne0.z + -0.35184717*nf0.z + 0.056586858*ng0.z + 0.15026435*nh0.z + -0.061636005*ni0.z;
    float t = -0.106188744*na0.w + 0.07888199*nb0.w + -0.2636212*nc0.w + 0.066121526*nd0.w + 0.24769889*ne0.w + 0.068046436*nf0.w + -0.10188476*ng0.w + -0.010680762*nh0.w + 0.08574669*ni0.w;
    float u = 0.1835542*na1.x + 0.008937482*nb1.x + 0.5390035*nc1.x + -0.29016507*nd1.x + 0.15828976*ne1.x + 0.13055886*nf1.x + -0.032077167*ng1.x + -0.09232864*nh1.x + 0.026800178*ni1.x;
    float v = -0.16373107*na1.y + 0.12240949*nb1.y + -0.1514469*nc1.y + -0.066187665*nd1.y + 0.480507*ne1.y + 0.239324*nf1.y + -0.117546804*ng1.y + 0.10907446*nh1.y + 0.18901855*ni1.y;
    float w = 0.16920653*na1.z + -0.116989106*nb1.z + 0.15383393*nc1.z + -0.15339498*nd1.z + -0.43599066*ne1.z + -0.08481946*nf1.z + 0.09341884*ng1.z + 0.29806188*nh1.z + 0.1415666*ni1.z;
    float x = 0.19586475*na1.w + -0.074446365*nb1.w + -0.40643847*nc1.w + 0.11850669*nd1.w + -0.44227952*ne1.w + -0.3928542*nf1.w + -0.32883126*ng1.w + -0.12546194*nh1.w + -0.012666243*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.11223799;
    i = 0.26876807*a0.x + 0.0695523*b0.x + -0.344691*c0.x + 0.015203748*d0.x + -0.06949707*e0.x + 0.1781559*f0.x + -0.37520844*g0.x + -0.063073136*h0.x + 0.30087665*i0.x;
    j = -0.55691296*a0.y + -0.50857925*b0.y + -0.056020547*c0.y + -0.35320345*d0.y + 0.031270754*e0.y + 0.2983404*f0.y + -0.076483674*g0.y + 0.26416323*h0.y + 0.023565156*i0.y;
    k = 0.69414824*a0.z + 0.40440598*b0.z + 0.27192193*c0.z + 0.6970185*d0.z + 0.3389849*e0.z + -0.70087254*f0.z + 0.19736615*g0.z + -0.31259185*h0.z + -0.25468588*i0.z;
    l = 0.2020039*a0.w + 0.72199726*b0.w + 0.0022852335*c0.w + 0.298485*d0.w + -0.20830868*e0.w + 0.19032896*f0.w + 0.3657984*g0.w + -0.17007291*h0.w + 0.36441973*i0.w;
    m = -0.2508085*a1.x + -0.3401645*b1.x + -0.850176*c1.x + 0.06386162*d1.x + -0.003681138*e1.x + 0.6275042*f1.x + 0.11110598*g1.x + 0.47562084*h1.x + 0.13381582*i1.x;
    n = 0.020444876*a1.y + 0.2532999*b1.y + 0.2269895*c1.y + -0.017598275*d1.y + -0.45708385*e1.y + 0.1524704*f1.y + -0.34254953*g1.y + 0.04740127*h1.y + 0.017197018*i1.y;
    o = -0.002111269*a1.z + -0.22728685*b1.z + -0.23939796*c1.z + -0.10468774*d1.z + -0.29414457*e1.z + -0.24367806*f1.z + 0.17014527*g1.z + 0.27090183*h1.z + 0.054622088*i1.z;
    p = 0.41061872*a1.w + 0.0005123808*b1.w + -0.22415727*c1.w + -0.2519382*d1.w + 0.05781463*e1.w + 0.22721478*f1.w + -0.21616709*g1.w + -0.24962169*h1.w + 0.13280573*i1.w;
    q = -0.1373898*na0.x + -0.0981469*nb0.x + 0.39089695*nc0.x + 0.0852082*nd0.x + 0.350497*ne0.x + -0.11116323*nf0.x + 0.46357557*ng0.x + 0.029840166*nh0.x + -0.42227915*ni0.x;
    r = 0.5641577*na0.y + 0.51027757*nb0.y + 0.009071347*nc0.y + 0.38495895*nd0.y + -0.033866487*ne0.y + -0.27575114*nf0.y + 0.08055667*ng0.y + -0.3035854*nh0.y + -0.023016002*ni0.y;
    s = -0.32272196*na0.z + 0.20313929*nb0.z + 0.26362333*nc0.z + -0.41859806*nd0.z + 0.30431905*ne0.z + 0.45895672*nf0.z + -0.22528476*ng0.z + -0.1159145*nh0.z + -0.20209464*ni0.z;
    t = 0.081928305*na0.w + -0.39223*nb0.w + 0.0611548*nc0.w + -0.22477622*nd0.w + 0.522427*ne0.w + 0.08855894*nf0.w + -0.24657424*ng0.w + 0.20350339*nh0.w + -0.31071478*ni0.w;
    u = 0.33967844*na1.x + 0.49198282*nb1.x + 0.7863518*nc1.x + 0.11403914*nd1.x + -0.19266184*ne1.x + -0.45698294*nf1.x + -0.08126978*ng1.x + -0.5248899*nh1.x + -0.07797818*ni1.x;
    v = -0.20771638*na1.y + -0.8299212*nb1.y + -0.24834624*nc1.y + 0.45250767*nd1.y + 0.46488434*ne1.y + -0.11828078*nf1.y + 0.3505284*ng1.y + -0.50510573*nh1.y + -0.07697552*ni1.y;
    w = -0.04876213*na1.z + 0.11971257*nb1.z + 0.31340784*nc1.z + 0.200377*nd1.z + 0.35152084*ne1.z + 0.21963598*nf1.z + -0.076885894*ng1.z + -0.26809564*nh1.z + -0.09561077*ni1.z;
    x = -0.34259066*na1.w + 0.09505923*nb1.w + 0.14959009*nc1.w + 0.23431835*nd1.w + 0.0062933876*ne1.w + -0.1609717*nf1.w + 0.24410221*ng1.w + 0.27085063*nh1.w + -0.099992506*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.04949893;
    i = 0.0045639137*a0.x + -0.05743072*b0.x + 0.10285781*c0.x + 0.26087925*d0.x + -0.20553583*e0.x + 0.061200682*f0.x + -0.006694795*g0.x + -0.3745583*h0.x + -0.3707756*i0.x;
    j = -0.022965383*a0.y + -0.26371047*b0.y + 0.005787948*c0.y + -0.07437368*d0.y + 0.06782797*e0.y + -0.08120288*f0.y + -0.12914035*g0.y + -0.077741124*h0.y + 0.2501241*i0.y;
    k = 0.20610172*a0.z + 0.1284978*b0.z + -0.11886638*c0.z + 0.28653103*d0.z + -0.063644625*e0.z + -0.5884758*f0.z + 0.11728779*g0.z + 0.029905675*h0.z + 0.07379022*i0.z;
    l = 0.1538378*a0.w + 0.4065925*b0.w + 0.2281266*c0.w + 0.18172836*d0.w + -0.23893136*e0.w + -0.23435418*f0.w + 0.22755076*g0.w + 0.285046*h0.w + 0.14650422*i0.w;
    m = 0.11291303*a1.x + -0.08260544*b1.x + -0.3453159*c1.x + -0.080172844*d1.x + 0.2454293*e1.x + 0.08065602*f1.x + -0.161478*g1.x + 0.2600093*h1.x + 0.0272943*i1.x;
    n = -0.20061754*a1.y + -0.0686889*b1.y + 0.34669587*c1.y + 0.06513748*d1.y + -0.473736*e1.y + 0.27777022*f1.y + -0.024264947*g1.y + 0.02778163*h1.y + 0.21098697*i1.y;
    o = 0.05395608*a1.z + 0.02719116*b1.z + -0.32412598*c1.z + -0.27905193*d1.z + -0.06789973*e1.z + -0.062129535*f1.z + -0.08168251*g1.z + -0.41552538*h1.z + -0.3497803*i1.z;
    p = 0.25839904*a1.w + -0.22404832*b1.w + -0.05384204*c1.w + -0.2161867*d1.w + -0.0121894805*e1.w + 0.022278681*f1.w + -0.17689417*g1.w + -0.34242043*h1.w + -0.070397146*i1.w;
    q = 0.063034*na0.x + 0.05760969*nb0.x + -0.18728243*nc0.x + -0.22536343*nd0.x + 0.56690377*ne0.x + 0.03879585*nf0.x + 0.07536423*ng0.x + 0.3205974*nh0.x + 0.27575305*ni0.x;
    r = 0.1031107*na0.y + 0.272687*nb0.y + 0.006762844*nc0.y + 0.16900925*nd0.y + -0.072919*ne0.y + 0.14026049*nf0.y + 0.15526237*ng0.y + 0.18150571*nh0.y + -0.22151531*ni0.y;
    s = -0.24863394*na0.z + -0.09707596*nb0.z + 0.09795663*nc0.z + -0.22762008*nd0.z + -0.21057858*ne0.z + -0.24106069*nf0.z + -0.022255352*ng0.z + -0.1313767*nh0.z + -0.43121204*ni0.z;
    t = 0.066694*na0.w + -0.10496735*nb0.w + -0.025571965*nc0.w + -0.018413628*nd0.w + 0.11439308*ne0.w + -0.10751523*nf0.w + -0.07761101*ng0.w + -0.12299807*nh0.w + -0.0853496*ni0.w;
    u = -0.097931445*na1.x + -0.017077666*nb1.x + 0.39443842*nc1.x + 0.11578743*nd1.x + -0.12134833*ne1.x + -0.13418046*nf1.x + 0.1631315*ng1.x + -0.17905197*nh1.x + 0.1269253*ni1.x;
    v = 0.14395997*na1.y + -0.18397519*nb1.y + -0.2788941*nc1.y + 0.26155776*nd1.y + 0.43425953*ne1.y + -0.29808456*nf1.y + 0.44714943*ng1.y + -0.15123212*nh1.y + -0.16428284*ni1.y;
    w = 0.11957922*na1.z + -0.07498902*nb1.z + 0.5115902*nc1.z + 0.4331171*nd1.z + 0.051374156*ne1.z + 0.08533449*nf1.z + 0.09597762*ng1.z + 0.31204012*nh1.z + 0.31360728*ni1.z;
    x = -0.21514232*na1.w + 0.26941258*nb1.w + 0.014634563*nc1.w + 0.26335603*nd1.w + 0.17885374*ne1.w + -0.10330111*nf1.w + 0.1403563*ng1.w + 0.07782978*nh1.w + 0.14008115*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.13688515;
    i = -0.07804815*a0.x + 0.059407797*b0.x + 0.04977952*c0.x + 0.02773134*d0.x + 0.05410472*e0.x + -0.062854886*f0.x + 0.026472766*g0.x + -0.27023906*h0.x + -0.19210388*i0.x;
    j = -0.093932435*a0.y + 0.28328913*b0.y + -0.2901787*c0.y + 0.2604209*d0.y + 0.1867309*e0.y + -0.087907895*f0.y + -0.17325231*g0.y + -0.20677052*h0.y + 0.05084516*i0.y;
    k = 0.18059264*a0.z + 0.12659116*b0.z + 0.321166*c0.z + -0.095247015*d0.z + -0.057249375*e0.z + -0.083215155*f0.z + -0.084061414*g0.z + 0.016379947*h0.z + 0.27847067*i0.z;
    l = 0.0052076564*a0.w + 0.088261835*b0.w + 0.023966275*c0.w + 0.1916891*d0.w + -0.18803315*e0.w + 0.30314574*f0.w + -0.0049388534*g0.w + 0.06131603*h0.w + -0.1739463*i0.w;
    m = 0.053730816*a1.x + 0.044391237*b1.x + -0.23457325*c1.x + 0.16524185*d1.x + -0.06232111*e1.x + -0.009041229*f1.x + -0.14986548*g1.x + 0.2529295*h1.x + -0.06479601*i1.x;
    n = -0.0712835*a1.y + 0.08422339*b1.y + 0.06049955*c1.y + 0.19688065*d1.y + -0.2506823*e1.y + 0.028088713*f1.y + 0.5348856*g1.y + 0.30103734*h1.y + -0.19360717*i1.y;
    o = -0.24208106*a1.z + -0.122532606*b1.z + 0.20045316*c1.z + 0.05312705*d1.z + 0.5049963*e1.z + -0.14606343*f1.z + 0.049328245*g1.z + -0.078365676*h1.z + 0.03955016*i1.z;
    p = -0.2099684*a1.w + 0.040386654*b1.w + -0.013257981*c1.w + 0.0356436*d1.w + -0.325366*e1.w + 0.16636635*f1.w + -0.22065227*g1.w + -0.16084203*h1.w + 0.11005756*i1.w;
    q = 0.15815249*na0.x + -0.015369833*nb0.x + -0.12336756*nc0.x + -0.054385934*nd0.x + 0.074591964*ne0.x + -0.086368226*nf0.x + -0.14882945*ng0.x + 0.28417754*nh0.x + 0.21760134*ni0.x;
    r = 0.14566842*na0.y + -0.32228568*nb0.y + 0.3217725*nc0.y + -0.3236746*nd0.y + -0.24484256*ne0.y + 0.10371231*nf0.y + 0.16460484*ng0.y + 0.23163281*nh0.y + -0.012341124*ni0.y;
    s = -0.005058286*na0.z + -0.03453109*nb0.z + -0.23984626*nc0.z + 0.25166908*nd0.z + 0.27825156*ne0.z + 0.024285031*nf0.z + 0.10690525*ng0.z + -0.026662704*nh0.z + -0.10733832*ni0.z;
    t = -0.057425056*na0.w + -0.044107772*nb0.w + 0.14013149*nc0.w + -0.2928656*nd0.w + -0.027609475*ne0.w + -0.2120587*nf0.w + -0.048152808*ng0.w + -0.09314774*nh0.w + 0.17581387*ni0.w;
    u = -0.045317907*na1.x + -0.002658384*nb1.x + 0.26392183*nc1.x + -0.102072954*nd1.x + 0.15045899*ne1.x + 0.0026884302*nf1.x + 0.22182642*ng1.x + -0.16366667*nh1.x + 0.17252661*ni1.x;
    v = 0.037068292*na1.y + -0.035697266*nb1.y + -0.12798944*nc1.y + -0.104217514*nd1.y + 0.55114526*ne1.y + -0.08683132*nf1.y + -0.3960688*ng1.y + -0.058004502*nh1.y + 0.20123851*ni1.y;
    w = 0.061975777*na1.z + -0.007016737*nb1.z + -0.24395092*nc1.z + -0.18182912*nd1.z + -0.4203786*ne1.z + -0.0793229*nf1.z + -0.0062738233*ng1.z + 0.07010734*nh1.z + -0.07754023*ni1.z;
    x = 0.23575118*na1.w + 0.010342719*nb1.w + 0.053801455*nc1.w + -0.04112547*nd1.w + 0.22638881*ne1.w + -0.17857444*nf1.w + 0.32300612*ng1.w + 0.16535853*nh1.w + -0.032169778*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.09900063;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!SAVE LUMAN20

#define L0_tex LUMAN10_tex
#define L1_tex LUMAN11_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.013527977*a0.x + -0.021985358*b0.x + 0.05397565*c0.x + -0.0034767855*d0.x + -0.11890677*e0.x + 0.29082134*f0.x + -0.039291047*g0.x + 0.07665195*h0.x + 0.08196425*i0.x;
    float j = -0.094228186*a0.y + 0.07538697*b0.y + -0.060956057*c0.y + 0.059484713*d0.y + -0.17759728*e0.y + 0.09614218*f0.y + 0.03537611*g0.y + -0.037086073*h0.y + -0.008596415*i0.y;
    float k = 0.032117758*a0.z + 0.022979202*b0.z + -0.07695347*c0.z + 0.012811646*d0.z + -0.023976473*e0.z + 0.059492603*f0.z + 0.008878449*g0.z + -0.059855916*h0.z + -0.07344373*i0.z;
    float l = -0.021900775*a0.w + 0.031232128*b0.w + -0.06696601*c0.w + -0.009441922*d0.w + 0.1089948*e0.w + -0.06588389*f0.w + 0.012479958*g0.w + -0.08053917*h0.w + -0.04149462*i0.w;
    float m = -0.008463991*a1.x + -0.06539698*b1.x + 0.017473739*c1.x + -0.10556125*d1.x + -0.14444841*e1.x + 0.07904334*f1.x + -0.04443588*g1.x + -0.03508132*h1.x + -0.17745219*i1.x;
    float n = 0.020496715*a1.y + -0.08638652*b1.y + 0.05855077*c1.y + 0.00017441693*d1.y + 0.018543327*e1.y + -0.1013226*f1.y + -0.066230886*g1.y + 0.08413542*h1.y + 0.050962817*i1.y;
    float o = -0.017161256*a1.z + 0.13858159*b1.z + -0.041749604*c1.z + 0.03419109*d1.z + -0.056592952*e1.z + 0.18458726*f1.z + 0.043434385*g1.z + -0.061071083*h1.z + 0.012921071*i1.z;
    float p = 0.014755255*a1.w + -0.05182161*b1.w + -0.06731411*c1.w + 0.011102007*d1.w + -0.318703*e1.w + 0.075716965*f1.w + 0.101763345*g1.w + 0.15413295*h1.w + 0.024591988*i1.w;
    float q = -0.075562514*na0.x + -0.010590976*nb0.x + -0.11738534*nc0.x + -0.041761354*nd0.x + 0.11932829*ne0.x + -0.45476782*nf0.x + -0.0075228284*ng0.x + -0.086420506*nh0.x + 0.007089712*ni0.x;
    float r = 0.03096373*na0.y + 0.034649566*nb0.y + -0.031928774*nc0.y + -0.043111343*nd0.y + 0.31612563*ne0.y + -0.20350803*nf0.y + -0.026558274*ng0.y + 0.02289182*nh0.y + -0.020726833*ni0.y;
    float s = -0.0016090226*na0.z + -0.06752645*nb0.z + 0.099091955*nc0.z + -0.0024325743*nd0.z + 0.1011554*ne0.z + -0.04262747*nf0.z + -0.05447163*ng0.z + -0.050558403*nh0.z + 0.0081778*ni0.z;
    float t = -0.0049708895*na0.w + 0.0016392999*nb0.w + 0.057654087*nc0.w + 0.059012435*nd0.w + -0.057368375*ne0.w + 0.03879934*nf0.w + -0.10427082*ng0.w + 0.20068298*nh0.w + -0.01986618*ni0.w;
    float u = 0.038776297*na1.x + 0.09107378*nb1.x + -0.012062791*nc1.x + -0.039930277*nd1.x + 0.4725951*ne1.x + -0.08188476*nf1.x + 0.032464903*ng1.x + 0.022594651*nh1.x + 0.13316265*ni1.x;
    float v = 0.013261636*na1.y + 0.016820675*nb1.y + -0.072160594*nc1.y + -0.04779156*nd1.y + -0.111475825*ne1.y + -0.059117347*nf1.y + -0.0058553545*ng1.y + -0.08119034*nh1.y + -0.09739646*ni1.y;
    float w = -0.012684074*na1.z + -0.07658207*nb1.z + 0.08316156*nc1.z + 0.056792818*nd1.z + 0.19558784*ne1.z + -0.20766291*nf1.z + -0.020052088*ng1.z + -0.0004862114*nh1.z + -0.011227089*ni1.z;
    float x = 0.0073004025*na1.w + -0.13704851*nb1.w + 0.08306585*nc1.w + 0.07773706*nd1.w + 0.17363897*ne1.w + -0.1441048*nf1.w + -0.19439775*ng1.w + 0.107276335*nh1.w + -0.051084824*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.022949655;
    i = -0.04087157*a0.x + -0.02260197*b0.x + 0.117542826*c0.x + -0.012369363*d0.x + 0.08074506*e0.x + 0.061692882*f0.x + 0.022351578*g0.x + 0.10602042*h0.x + -0.06767196*i0.x;
    j = -0.064718924*a0.y + -0.22255176*b0.y + 0.05848093*c0.y + -0.14342205*d0.y + 0.119860075*e0.y + 0.06878551*f0.y + -0.013513069*g0.y + 0.046533465*h0.y + 0.040732548*i0.y;
    k = -0.06045028*a0.z + -0.01591852*b0.z + 0.06610767*c0.z + -0.1823601*d0.z + 0.20849596*e0.z + 0.07347752*f0.z + 0.04155757*g0.z + 0.00895664*h0.z + -0.07944645*i0.z;
    l = -0.016871834*a0.w + 0.045388754*b0.w + 0.011370655*c0.w + -0.14510797*d0.w + -0.15147415*e0.w + -0.1170348*f0.w + 0.017186902*g0.w + 0.09248375*h0.w + 0.007475839*i0.w;
    m = -0.16198191*a1.x + 0.031186389*b1.x + -0.015577391*c1.x + -0.22482629*d1.x + 0.24596654*e1.x + -0.050533623*f1.x + -0.25108784*g1.x + 0.04284556*h1.x + 0.08108874*i1.x;
    n = 0.027043452*a1.y + 0.16801552*b1.y + -0.003745599*c1.y + 0.070402175*d1.y + 0.053155128*e1.y + -0.14744243*f1.y + -0.051701613*g1.y + -0.11427176*h1.y + 0.037253726*i1.y;
    o = 0.014052072*a1.z + -0.21043895*b1.z + -0.04493953*c1.z + -0.13491723*d1.z + 0.045351543*e1.z + -0.017205605*f1.z + 0.044354085*g1.z + 0.17428237*h1.z + -0.027252568*i1.z;
    p = -0.05443855*a1.w + -0.19976734*b1.w + 0.08696741*c1.w + -0.058124144*d1.w + 0.17074996*e1.w + 0.016584387*f1.w + 0.061787624*g1.w + -0.095216915*h1.w + -0.09135518*i1.w;
    q = 0.068849*na0.x + -0.006419118*nb0.x + 0.019441683*nc0.x + -0.060357757*nd0.x + 0.039131112*ne0.x + -0.08853136*nf0.x + 0.01760069*ng0.x + 0.09266912*nh0.x + 0.008327355*ni0.x;
    r = 0.22129181*na0.y + 0.06373042*nb0.y + -0.10548629*nc0.y + 0.10325513*nd0.y + -0.30775833*ne0.y + 0.00220113*nf0.y + -0.028867336*ng0.y + -0.09189019*nh0.y + -0.022799294*ni0.y;
    s = 0.060209315*na0.z + 0.031388324*nb0.z + -0.022957543*nc0.z + 0.27422178*nd0.z + 0.06937636*ne0.z + 0.035298806*nf0.z + 0.11368389*ng0.z + 0.12730958*nh0.z + 0.028364537*ni0.z;
    t = 0.014704841*na0.w + -0.20102401*nb0.w + -0.026068306*nc0.w + 0.17699486*nd0.w + 0.0879294*ne0.w + 0.1698334*nf0.w + -0.02981899*ng0.w + -0.033061545*nh0.w + -0.003263149*ni0.w;
    u = 0.10228793*na1.x + -0.12621002*nb1.x + 0.04712082*nc1.x + 0.17671345*nd1.x + -0.011435259*ne1.x + -0.017273735*nf1.x + 0.04336435*ng1.x + 0.041016195*nh1.x + -0.07070804*ni1.x;
    v = -0.0230543*na1.y + -0.07177169*nb1.y + -0.016929608*nc1.y + 0.09176562*nd1.y + 0.007423476*ne1.y + 0.14347216*nf1.y + 0.19021674*ng1.y + 0.24664913*nh1.y + -0.0044546993*ni1.y;
    w = 0.07525268*na1.z + 0.10215633*nb1.z + -0.034674216*nc1.z + 0.11917874*nd1.z + -0.07633382*ne1.z + 0.009491858*nf1.z + -0.019258348*ng1.z + -0.056110546*nh1.z + 0.05242466*ni1.z;
    x = 0.14390227*na1.w + 0.005486874*nb1.w + -0.047775052*nc1.w + 0.083086684*nd1.w + -0.1540571*ne1.w + 0.03332832*nf1.w + -0.039857596*ng1.w + 0.06294105*nh1.w + 0.059931733*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.015004233;
    i = 0.06450652*a0.x + 0.10512942*b0.x + -0.03380897*c0.x + 0.02381926*d0.x + -0.029680518*e0.x + 0.19790445*f0.x + 0.020805994*g0.x + 0.12226736*h0.x + 0.29196885*i0.x;
    j = 0.058254506*a0.y + 0.37349033*b0.y + 0.17782345*c0.y + 0.13237436*d0.y + -0.16366753*e0.y + 0.15040247*f0.y + -0.009766406*g0.y + 0.09334094*h0.y + -0.04319163*i0.y;
    k = 0.032573055*a0.z + 0.0520147*b0.z + -0.109417446*c0.z + -0.083108656*d0.z + -0.03640593*e0.z + -0.035311375*f0.z + -0.059460822*g0.z + -0.23666914*h0.z + -0.08944803*i0.z;
    l = 0.0038108414*a0.w + -0.093942806*b0.w + -0.0002687137*c0.w + 0.050867274*d0.w + 0.19859661*e0.w + -0.022116859*f0.w + 0.06944154*g0.w + -0.1566366*h0.w + -0.030445358*i0.w;
    m = 0.00823481*a1.x + -0.01037292*b1.x + -0.10918299*c1.x + 0.27718702*d1.x + -0.14857076*e1.x + -0.04826351*f1.x + 0.2341413*g1.x + 0.2599253*h1.x + 0.17341693*i1.x;
    n = 0.048965324*a1.y + -0.12670444*b1.y + -0.089070916*c1.y + 0.02564883*d1.y + -0.24245334*e1.y + 0.032899123*f1.y + -0.014363491*g1.y + 0.11135662*h1.y + 0.15778056*i1.y;
    o = -0.16426727*a1.z + 0.11129983*b1.z + 0.06887022*c1.z + 0.007059456*d1.z + -0.17225806*e1.z + -0.19889604*f1.z + -0.12744522*g1.z + -0.12379852*h1.z + -0.16819909*i1.z;
    p = -0.116869636*a1.w + 0.15554382*b1.w + 0.029180527*c1.w + -0.06872862*d1.w + 0.09564698*e1.w + 0.24025366*f1.w + 0.03126127*g1.w + -0.1176598*h1.w + -0.06161121*i1.w;
    q = 0.037802104*na0.x + 0.09350397*nb0.x + -0.0769349*nc0.x + 0.03645998*nd0.x + 0.0069438526*ne0.x + -0.06361921*nf0.x + 0.18469255*ng0.x + 0.24764213*nh0.x + 0.07766792*ni0.x;
    r = 0.18289608*na0.y + -0.12239327*nb0.y + -0.13007359*nc0.y + 0.09451128*nd0.y + 0.1741278*ne0.y + 0.13919578*nf0.y + 0.0027461709*ng0.y + -0.042409852*nh0.y + 0.08961877*ni0.y;
    s = -0.061266363*na0.z + -0.054321136*nb0.z + 0.036159202*nc0.z + 0.030102096*nd0.z + -0.044607766*ne0.z + -0.060411066*nf0.z + -0.13489954*ng0.z + -0.04080531*nh0.z + -0.083873264*ni0.z;
    t = -0.084672436*na0.w + 0.1504545*nb0.w + 0.024027625*nc0.w + -0.13306853*nd0.w + -0.09016413*ne0.w + 0.17414762*nf0.w + -0.06464937*ng0.w + 0.13652956*nh0.w + -0.021525873*ni0.w;
    u = -0.02642025*na1.x + 0.044494845*nb1.x + 0.06366142*nc1.x + 0.1505755*nd1.x + 0.07108563*ne1.x + 0.04716515*nf1.x + 0.08969759*ng1.x + 0.15725368*nh1.x + -0.083613135*ni1.x;
    v = -0.013183983*na1.y + 0.11957996*nb1.y + 0.06981307*nc1.y + 0.0049996213*nd1.y + 0.045766216*ne1.y + -0.2006878*nf1.y + -0.061555803*ng1.y + -0.23608068*nh1.y + -0.20878883*ni1.y;
    w = 0.08936703*na1.z + -0.08374226*nb1.z + -0.22422598*nc1.z + -0.1499266*nd1.z + -0.02415584*ne1.z + -0.03532918*nf1.z + -0.0064545805*ng1.z + 0.11103835*nh1.z + 0.14617345*ni1.z;
    x = -0.059598316*na1.w + 0.0572515*nb1.w + -0.07959839*nc1.w + -0.11761448*nd1.w + 0.04539192*ne1.w + -0.013689615*nf1.w + 0.117332384*ng1.w + 0.06432839*nh1.w + 0.17445782*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.009116664;
    i = 0.029937284*a0.x + 0.012592633*b0.x + 0.0035193404*c0.x + 0.048239913*d0.x + -0.02579887*e0.x + -0.32347405*f0.x + 0.19797476*g0.x + 0.34045488*h0.x + -0.053127605*i0.x;
    j = -0.08552001*a0.y + -0.5091193*b0.y + -0.3674879*c0.y + 0.066710964*d0.y + -0.19032574*e0.y + -0.23930229*f0.y + 0.12251539*g0.y + -0.10437046*h0.y + 0.029123023*i0.y;
    k = -0.01817984*a0.z + -0.035262328*b0.z + 0.05684564*c0.z + -0.05650155*d0.z + 0.10149242*e0.z + 0.16924061*f0.z + -0.06286115*g0.z + -0.07370519*h0.z + -0.0031225765*i0.z;
    l = 0.01222035*a0.w + -0.034015853*b0.w + 0.054374967*c0.w + 0.13628155*d0.w + 0.12960319*e0.w + 0.14776659*f0.w + 0.06023756*g0.w + -0.042914346*h0.w + 0.20594329*i0.w;
    m = -0.0934276*a1.x + -0.07084719*b1.x + 0.05861112*c1.x + 0.043431886*d1.x + 0.39818907*e1.x + -0.13945232*f1.x + 0.09557018*g1.x + 0.24552365*h1.x + -0.12016207*i1.x;
    n = 0.044831783*a1.y + 0.06390137*b1.y + 0.24364634*c1.y + 0.07372187*d1.y + -0.14626445*e1.y + 0.099190116*f1.y + -0.07039345*g1.y + 0.073163874*h1.y + -0.06192338*i1.y;
    o = -0.109891295*a1.z + -0.13347644*b1.z + -0.12954961*c1.z + -0.019614372*d1.z + -0.0029413272*e1.z + -0.031745158*f1.z + -0.1051075*g1.z + -0.03837312*h1.z + 0.0076298364*i1.z;
    p = -0.15461138*a1.w + -0.07552362*b1.w + -0.049930304*c1.w + -0.107533015*d1.w + 0.02491214*e1.w + 0.12966767*f1.w + 0.16751781*g1.w + -0.14322354*h1.w + 0.012731172*i1.w;
    q = 0.0073949546*na0.x + 0.18222675*nb0.x + -0.07683412*nc0.x + 0.083668694*nd0.x + 0.24188446*ne0.x + 0.22409667*nf0.x + 0.111766525*ng0.x + 0.17273599*nh0.x + 0.013803989*ni0.x;
    r = 0.0055611595*na0.y + 0.27571908*nb0.y + 0.2450441*nc0.y + -0.010127715*nd0.y + 0.065464124*ne0.y + 0.13358384*nf0.y + -0.1146484*ng0.y + 0.11939751*nh0.y + 0.05964501*ni0.y;
    s = 0.029037701*na0.z + 0.012928207*nb0.z + 0.002133859*nc0.z + 0.050441336*nd0.z + -0.031983275*ne0.z + -0.13312417*nf0.z + -0.1503905*ng0.z + 0.018946528*nh0.z + 0.037298534*ni0.z;
    t = 0.03960253*na0.w + 0.028732052*nb0.w + -0.06156018*nc0.w + 0.033002503*nd0.w + -0.12726215*ne0.w + -0.16633202*nf0.w + 0.097211786*ng0.w + 0.12051725*nh0.w + -0.09554128*ni0.w;
    u = -0.13823731*na1.x + -0.07852736*nb1.x + -0.09889797*nc1.x + -0.14248206*nd1.x + -0.2923521*ne1.x + 0.11362127*nf1.x + -0.05540227*ng1.x + -0.007822408*nh1.x + 0.031163149*ni1.x;
    v = 0.10624509*na1.y + -0.034037188*nb1.y + -0.15328835*nc1.y + -0.039549757*nd1.y + -0.009303268*ne1.y + -0.020719174*nf1.y + -0.1074841*ng1.y + 0.016232569*nh1.y + 0.11941272*ni1.y;
    w = 0.030069001*na1.z + 0.033361748*nb1.z + 0.07155489*nc1.z + 0.06789422*nd1.z + -0.09628887*ne1.z + -0.0050422805*nf1.z + 0.077183045*ng1.z + -0.052701566*nh1.z + -0.013990619*ni1.z;
    x = 0.06616862*na1.w + 0.23819432*nb1.w + -0.0078013805*nc1.w + 0.34299204*nd1.w + -0.11941012*ne1.w + -0.014988168*nf1.w + -0.049478944*ng1.w + 0.20497164*nh1.w + 0.086817674*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.012121121;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!SAVE LUMAN21

#define L0_tex LUMAN10_tex
#define L1_tex LUMAN11_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.032210905*a0.x + -0.22100762*b0.x + -0.0032703374*c0.x + 0.015506358*d0.x + -0.09312688*e0.x + -0.018092621*f0.x + -0.21721269*g0.x + -0.3773176*h0.x + -0.19184077*i0.x;
    float j = -0.11561234*a0.y + 0.100562856*b0.y + -0.16967262*c0.y + -0.13489078*d0.y + -0.021638734*e0.y + -0.3574349*f0.y + -0.15207161*g0.y + -0.1547973*h0.y + -0.16668291*i0.y;
    float k = 0.02231361*a0.z + 0.13332497*b0.z + 0.035786014*c0.z + -0.0664228*d0.z + 0.16041073*e0.z + -0.084772356*f0.z + 0.07331499*g0.z + -0.028057933*h0.z + 0.03400777*i0.z;
    float l = -0.033291023*a0.w + 0.13411658*b0.w + -0.10777399*c0.w + -0.08803081*d0.w + 0.243463*e0.w + 0.23971614*f0.w + 0.03130143*g0.w + 0.21753372*h0.w + 0.23764528*i0.w;
    float m = 0.02479805*a1.x + 0.024198437*b1.x + 0.067342184*c1.x + -0.09406164*d1.x + -0.061180808*e1.x + 0.017575948*f1.x + -0.06901198*g1.x + -0.6332455*h1.x + -0.26331425*i1.x;
    float n = 0.03550918*a1.y + -0.026056346*b1.y + -0.026818415*c1.y + -0.062047157*d1.y + 0.1374933*e1.y + 0.014597348*f1.y + 0.032155614*g1.y + 0.082036875*h1.y + 0.09928472*i1.y;
    float o = 0.0076694456*a1.z + 0.10039608*b1.z + -0.05555473*c1.z + 0.15538448*d1.z + 0.5122444*e1.z + 0.056242995*f1.z + 0.1033249*g1.z + 0.017088782*h1.z + 0.11182181*i1.z;
    float p = 0.05504122*a1.w + 0.240218*b1.w + 0.09733398*c1.w + 0.013779217*d1.w + 0.24832357*e1.w + -0.111736566*f1.w + -0.12404431*g1.w + 0.22960596*h1.w + 0.011862629*i1.w;
    float q = -0.024519132*na0.x + 0.011293519*nb0.x + -0.10689248*nc0.x + -0.1520136*nd0.x + -0.09288146*ne0.x + -0.07725742*nf0.x + -0.008527781*ng0.x + -0.07596324*nh0.x + 0.24663517*ni0.x;
    float r = 0.111326605*na0.y + 0.06520367*nb0.y + -0.0292947*nc0.y + 0.15157138*nd0.y + -0.002686112*ne0.y + 0.089814834*nf0.y + 0.12950978*ng0.y + 0.098146915*nh0.y + -0.006845888*ni0.y;
    float s = 0.026319193*na0.z + -0.054523807*nb0.z + -0.032969248*nc0.z + 0.06366228*nd0.z + -0.08584336*ne0.z + 0.07897411*nf0.z + -0.0064960774*ng0.z + 0.037283525*nh0.z + -0.04514447*ni0.z;
    float t = 0.032626558*na0.w + -0.10095923*nb0.w + 0.030091932*nc0.w + 0.056223158*nd0.w + -0.13954762*ne0.w + -0.27249533*nf0.w + -0.1874185*ng0.w + -0.06394691*nh0.w + -0.37358424*ni0.w;
    float u = 0.11503907*na1.x + 0.09006182*nb1.x + -0.1666951*nc1.x + -0.004016884*nd1.x + 0.04133192*ne1.x + -0.032742172*nf1.x + 0.07530546*ng1.x + 0.1318198*nh1.x + 0.1558315*ni1.x;
    float v = -0.015699673*na1.y + -0.065667406*nb1.y + 0.13333066*nc1.y + 0.10314816*nd1.y + -0.10498296*ne1.y + 0.035132464*nf1.y + -0.06944383*ng1.y + -0.15983945*nh1.y + -0.10815093*ni1.y;
    float w = -0.023418352*na1.z + 0.1092882*nb1.z + 0.20895064*nc1.z + -0.13675413*nd1.z + 0.051802553*ne1.z + -0.06339106*nf1.z + -0.04526454*ng1.z + 0.02850313*nh1.z + -0.07127658*ni1.z;
    float x = -0.09134431*na1.w + 0.12640393*nb1.w + -0.123052575*nc1.w + 0.009571935*nd1.w + -0.121652395*ne1.w + -0.0987715*nf1.w + -0.08485803*ng1.w + -0.044140875*nh1.w + 0.0198955*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.07467768;
    i = 0.09189898*a0.x + 0.09660522*b0.x + -0.15929192*c0.x + 0.0873315*d0.x + 0.1004297*e0.x + 0.2897138*f0.x + 0.03302687*g0.x + 0.13837586*h0.x + 0.14187333*i0.x;
    j = -0.16785112*a0.y + 0.17407325*b0.y + 0.05927486*c0.y + -0.16061561*d0.y + -0.32080442*e0.y + -0.09874194*f0.y + 0.035980478*g0.y + -0.06288709*h0.y + 0.007237446*i0.y;
    k = -0.028712947*a0.z + 0.034094844*b0.z + -0.075238466*c0.z + 0.029756788*d0.z + -0.08453252*e0.z + 0.01931708*f0.z + -0.021127494*g0.z + 0.037089977*h0.z + 0.05374554*i0.z;
    l = 0.038226794*a0.w + 0.11277784*b0.w + 0.12790442*c0.w + 0.0022405738*d0.w + 0.16055769*e0.w + 0.1097169*f0.w + 0.11203196*g0.w + 0.11603345*h0.w + -0.01059266*i0.w;
    m = 0.04989864*a1.x + -0.03570367*b1.x + -0.07650978*c1.x + 0.114822045*d1.x + -0.043346252*e1.x + -0.054947898*f1.x + -0.010293628*g1.x + -0.11049507*h1.x + -0.12112137*i1.x;
    n = 0.011686617*a1.y + -0.01398271*b1.y + -0.0936927*c1.y + -0.014205747*d1.y + -0.10156042*e1.y + 0.16797067*f1.y + -0.16036573*g1.y + -0.06259835*h1.y + 0.084900655*i1.y;
    o = -0.084346674*a1.z + 0.14484023*b1.z + -0.04795535*c1.z + 0.08690034*d1.z + -0.05300985*e1.z + -0.045254134*f1.z + -0.079851165*g1.z + 0.08901589*h1.z + 0.08979397*i1.z;
    p = -0.08652713*a1.w + -0.0014084558*b1.w + 0.07818926*c1.w + 0.104910046*d1.w + -0.035973582*e1.w + -0.04440243*f1.w + -0.029182553*g1.w + 0.082148395*h1.w + -0.015747363*i1.w;
    q = 0.012732959*na0.x + 0.09247432*nb0.x + 0.060586743*nc0.x + -0.049785435*nd0.x + 0.015232796*ne0.x + 0.12521784*nf0.x + 0.08811162*ng0.x + -0.02245172*nh0.x + -0.077839985*ni0.x;
    r = 0.14234546*na0.y + -0.26840374*nb0.y + -0.030217612*nc0.y + 0.088527516*nd0.y + 0.049622834*ne0.y + 0.05244139*nf0.y + 0.02926647*ng0.y + 0.1130343*nh0.y + -0.022328159*ni0.y;
    s = -0.020194955*na0.z + -0.08410325*nb0.z + 0.068881*nc0.z + -0.052475553*nd0.z + 0.01784649*ne0.z + -0.06723487*nf0.z + -0.055720944*ng0.z + -0.04582561*nh0.z + -0.029673988*ni0.z;
    t = 0.04355432*na0.w + 0.06491023*nb0.w + 0.037113376*nc0.w + 0.12672496*nd0.w + -0.18339087*ne0.w + -0.04234449*nf0.w + 0.09054666*ng0.w + -0.11273007*nh0.w + 0.03041045*ni0.w;
    u = -0.10813339*na1.x + -0.118357934*nb1.x + 0.00058659946*nc1.x + -0.22123726*nd1.x + 0.12603706*ne1.x + 0.0067170076*nf1.x + 0.012743413*ng1.x + 0.02224982*nh1.x + 0.06633709*ni1.x;
    v = 0.09978588*na1.y + 0.007898778*nb1.y + 0.021774517*nc1.y + -0.027918719*nd1.y + 0.24878718*ne1.y + -0.30599263*nf1.y + -0.044740938*ng1.y + 0.16604176*nh1.y + -0.036250304*ni1.y;
    w = -0.058091346*na1.z + -0.2510759*nb1.z + -0.04973879*nc1.z + -0.19907628*nd1.z + -0.09391249*ne1.z + 0.06562282*nf1.z + -0.045825444*ng1.z + -0.20437409*nh1.z + -0.07064104*ni1.z;
    x = -0.26264083*na1.w + 0.015380487*nb1.w + -0.07525977*nc1.w + 0.03977851*nd1.w + 0.04027396*ne1.w + 0.014741459*nf1.w + 0.19858573*ng1.w + 0.010961905*nh1.w + 0.06481673*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.008888977;
    i = -0.02131571*a0.x + -0.053264357*b0.x + 0.17938791*c0.x + 0.08466054*d0.x + 0.08505312*e0.x + -0.08036078*f0.x + 0.17558508*g0.x + 0.17073892*h0.x + -0.07125404*i0.x;
    j = -0.011896931*a0.y + 0.075010955*b0.y + -0.0983643*c0.y + 0.026305754*d0.y + 0.019260254*e0.y + -0.14121646*f0.y + 0.02804857*g0.y + 0.0048786188*h0.y + 0.019504687*i0.y;
    k = -0.019065183*a0.z + -0.013254299*b0.z + 0.07514181*c0.z + 0.11055625*d0.z + -0.044775892*e0.z + 0.11779965*f0.z + -0.0053781765*g0.z + 0.0074138422*h0.z + -0.078374766*i0.z;
    l = 0.11444183*a0.w + 0.115259014*b0.w + 0.031562362*c0.w + 0.012267636*d0.w + 0.10228788*e0.w + -0.06968799*f0.w + 0.072820656*g0.w + -0.036611427*h0.w + 0.13929163*i0.w;
    m = -0.07504076*a1.x + -0.12394642*b1.x + -0.11331061*c1.x + -0.047768917*d1.x + -0.13104713*e1.x + -0.08379716*f1.x + -0.021516422*g1.x + -0.08238858*h1.x + -0.08267121*i1.x;
    n = 0.033980474*a1.y + 0.02657052*b1.y + 0.1067697*c1.y + 0.02900943*d1.y + -0.34566507*e1.y + 0.07115065*f1.y + -0.007658494*g1.y + 0.10935048*h1.y + -0.010512701*i1.y;
    o = 0.004971154*a1.z + 0.092844255*b1.z + -0.05771552*c1.z + -0.11182353*d1.z + -0.110540286*e1.z + -0.023962786*f1.z + 0.03412059*g1.z + -0.08923254*h1.z + 0.018304097*i1.z;
    p = -0.12247698*a1.w + -0.049930353*b1.w + 0.21932095*c1.w + 0.26519108*d1.w + -0.40082026*e1.w + 0.20915353*f1.w + 0.028248992*g1.w + 0.13964863*h1.w + -0.1554689*i1.w;
    q = 0.12723987*na0.x + 0.03822221*nb0.x + -0.047092102*nc0.x + -0.18272042*nd0.x + 0.3959418*ne0.x + 0.107742086*nf0.x + -0.014026635*ng0.x + 0.059987117*nh0.x + 0.16084902*ni0.x;
    r = 0.028825426*na0.y + -0.29448676*nb0.y + -0.13274668*nc0.y + -0.09478098*nd0.y + 0.10420857*ne0.y + -0.10411197*nf0.y + -0.18224506*ng0.y + -0.056122147*nh0.y + -0.01594652*ni0.y;
    s = 0.046311874*na0.z + 0.083920695*nb0.z + -0.011149687*nc0.z + 0.053852662*nd0.z + 0.28573832*ne0.z + -0.101435356*nf0.z + 0.09642878*ng0.z + 0.049260557*nh0.z + 0.09929059*ni0.z;
    t = -0.0035928742*na0.w + -0.09334861*nb0.w + -0.0063303886*nc0.w + 0.14681813*nd0.w + 0.017606229*ne0.w + 0.12432797*nf0.w + 0.089195*ng0.w + 0.2064234*nh0.w + -0.009656533*ni0.w;
    u = -0.07209475*na1.x + 0.09496789*nb1.x + -0.07145837*nc1.x + 0.016493566*nd1.x + 0.22177024*ne1.x + -0.02882561*nf1.x + -0.13864525*ng1.x + -0.050776858*nh1.x + -0.006592587*ni1.x;
    v = 0.08312736*na1.y + -0.031556617*nb1.y + 0.03721191*nc1.y + 0.19816718*nd1.y + 0.2112128*ne1.y + 0.18289135*nf1.y + 0.17975038*ng1.y + 0.022604292*nh1.y + 0.05615719*ni1.y;
    w = 0.02089934*na1.z + -0.11338398*nb1.z + 0.103426956*nc1.z + 0.039416797*nd1.z + 0.015742797*ne1.z + -0.011910452*nf1.z + -0.04195718*ng1.z + 0.028388608*nh1.z + 0.020044504*ni1.z;
    x = -0.01979613*na1.w + 0.18986*nb1.w + -0.14206813*nc1.w + -0.051590487*nd1.w + 0.07681823*ne1.w + -0.051485833*nf1.w + 0.0863466*ng1.w + -0.059099887*nh1.w + 0.20621549*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.02618249;
    i = -0.075821996*a0.x + -0.010909995*b0.x + -0.043415338*c0.x + -0.07588877*d0.x + -0.4095415*e0.x + -0.04469391*f0.x + -0.09701737*g0.x + -0.072898634*h0.x + 0.06407679*i0.x;
    j = -0.023938905*a0.y + 0.19077158*b0.y + 0.04024954*c0.y + 0.24741809*d0.y + 0.112353556*e0.y + 0.0041395114*f0.y + -0.028641861*g0.y + -0.027194615*h0.y + -0.09061678*i0.y;
    k = -0.072798036*a0.z + 0.090112865*b0.z + -0.05632968*c0.z + 0.20347923*d0.z + 0.07701144*e0.z + 0.045918144*f0.z + -0.07585065*g0.z + -0.07914966*h0.z + 0.019974526*i0.z;
    l = -0.16652842*a0.w + 0.034469336*b0.w + 0.12903087*c0.w + -0.076710865*d0.w + -0.37440994*e0.w + -0.025993038*f0.w + -0.004262664*g0.w + 0.001584407*h0.w + 0.033034854*i0.w;
    m = 0.0041383496*a1.x + 0.03408745*b1.x + -0.026236003*c1.x + 0.04234019*d1.x + -0.12546021*e1.x + -0.014587259*f1.x + -0.03398031*g1.x + -0.141356*h1.x + -0.11886382*i1.x;
    n = 0.09139738*a1.y + -0.09554944*b1.y + 0.10334826*c1.y + 0.03734294*d1.y + 0.012692735*e1.y + 0.061069824*f1.y + 0.11895*g1.y + 0.2818085*h1.y + 0.08344411*i1.y;
    o = -0.10986263*a1.z + 0.010196268*b1.z + -0.072981186*c1.z + -0.022945326*d1.z + 0.32752264*e1.z + -0.04935327*f1.z + -0.042955153*g1.z + 0.029840723*h1.z + -0.049479816*i1.z;
    p = -0.118424095*a1.w + -0.15453647*b1.w + -0.08703251*c1.w + -0.1623114*d1.w + 0.08050361*e1.w + 0.084552966*f1.w + 0.045329593*g1.w + 0.101881795*h1.w + -0.005239424*i1.w;
    q = -0.037558466*na0.x + 0.06352173*nb0.x + -0.03436178*nc0.x + -0.06149859*nd0.x + 0.031554375*ne0.x + 0.017566927*nf0.x + 0.047931995*ng0.x + -0.028771691*nh0.x + 0.09664059*ni0.x;
    r = -0.066075586*na0.y + 0.25566104*nb0.y + -0.0008369278*nc0.y + -0.10307065*nd0.y + -0.4120819*ne0.y + -0.13958299*nf0.y + -0.058115225*ng0.y + -0.030533452*nh0.y + 0.019909525*ni0.y;
    s = 0.21524096*na0.z + -0.034712624*nb0.z + 0.026146675*nc0.z + 0.03823109*nd0.z + 0.027243178*ne0.z + -0.06874973*nf0.z + 0.047253083*ng0.z + -0.06430874*nh0.z + 0.040901497*ni0.z;
    t = 0.07901911*na0.w + 0.15762629*nb0.w + 0.011304432*nc0.w + 0.050626148*nd0.w + 0.34474713*ne0.w + 0.07935911*nf0.w + 0.13129725*ng0.w + -0.070588715*nh0.w + 0.049329277*ni0.w;
    u = 0.1404405*na1.x + -0.05290101*nb1.x + -0.18832147*nc1.x + 0.017660763*nd1.x + -0.44914606*ne1.x + -0.093574174*nf1.x + -0.074316286*ng1.x + -0.09848133*nh1.x + 0.10140716*ni1.x;
    v = -0.039871864*na1.y + 0.060526196*nb1.y + 0.06688931*nc1.y + 0.18316075*nd1.y + 0.004202756*ne1.y + 0.32342157*nf1.y + 0.20690823*ng1.y + -0.3151704*nh1.y + 0.21967977*ni1.y;
    w = 0.24020113*na1.z + 0.37890625*nb1.z + 0.20994367*nc1.z + 0.13750695*nd1.z + -0.2828177*ne1.z + -0.18408743*nf1.z + -0.09146642*ng1.z + -0.04093093*nh1.z + -0.01256826*ni1.z;
    x = -0.023923807*na1.w + 0.11991365*nb1.w + 0.04768579*nc1.w + -0.37403065*nd1.w + -0.1640075*ne1.w + -0.095789246*nf1.w + 0.07672462*ng1.w + -0.04442829*nh1.w + -0.050591458*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0054605072;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN20
//!BIND LUMAN21
//!SAVE LUMAN30

#define L0_tex LUMAN20_tex
#define L1_tex LUMAN21_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.10495947*a0.x + -0.03537041*b0.x + -0.10991186*c0.x + 0.25251657*d0.x + 0.013626215*e0.x + -0.058395956*f0.x + -0.0008518597*g0.x + -0.014936195*h0.x + 0.019276572*i0.x;
    float j = -0.02682906*a0.y + -0.21245436*b0.y + -0.0033354003*c0.y + 0.006015402*d0.y + -0.16739099*e0.y + -0.15625198*f0.y + 0.0150447*g0.y + -0.015820103*h0.y + 0.012379691*i0.y;
    float k = -0.0013036287*a0.z + 0.008318171*b0.z + 0.030156238*c0.z + -0.04434512*d0.z + -0.07113499*e0.z + 0.08979989*f0.z + 0.07051442*g0.z + 0.17790104*h0.z + 0.06543697*i0.z;
    float l = 0.05744523*a0.w + 0.046723574*b0.w + -0.05827923*c0.w + 0.053087477*d0.w + 0.13964976*e0.w + 0.03684414*f0.w + -0.06794282*g0.w + -0.016245833*h0.w + -0.059672065*i0.w;
    float m = 0.038995396*a1.x + -0.038216475*b1.x + -0.022593262*c1.x + 0.043936342*d1.x + -0.21404716*e1.x + 0.025221398*f1.x + -0.023893652*g1.x + -0.01713915*h1.x + 0.017736023*i1.x;
    float n = -0.13781334*a1.y + -0.20996156*b1.y + -0.0855945*c1.y + -0.059780546*d1.y + -0.109258644*e1.y + -0.23170298*f1.y + -0.019512651*g1.y + -0.063233405*h1.y + -0.11784715*i1.y;
    float o = -0.049934313*a1.z + 0.110902704*b1.z + 0.01558279*c1.z + -0.049464624*d1.z + -0.071157925*e1.z + -0.01660195*f1.z + 0.03621618*g1.z + -0.17185134*h1.z + -0.03749148*i1.z;
    float p = -0.044992216*a1.w + -0.029741274*b1.w + -0.09576101*c1.w + 0.009392959*d1.w + 0.00061923254*e1.w + -0.049683083*f1.w + 0.09854748*g1.w + 0.11209177*h1.w + 0.015629178*i1.w;
    float q = -0.023147024*na0.x + 0.028076923*nb0.x + -0.05377833*nc0.x + 0.41326755*nd0.x + 0.5016342*ne0.x + 0.102404684*nf0.x + 0.30781993*ng0.x + 0.04892017*nh0.x + -0.095621556*ni0.x;
    float r = -0.02866961*na0.y + 0.13125686*nb0.y + 0.009609672*nc0.y + -0.048800323*nd0.y + -0.24172029*ne0.y + 0.07588628*nf0.y + -0.058860697*ng0.y + -0.20078272*nh0.y + -0.005210194*ni0.y;
    float s = -0.061130345*na0.z + 0.06554706*nb0.z + 0.026878184*nc0.z + 0.09191935*nd0.z + -0.18614642*ne0.z + -0.1272964*nf0.z + -0.051245384*ng0.z + -0.06212816*nh0.z + 0.020784322*ni0.z;
    float t = 0.0021429516*na0.w + -0.0141859185*nb0.w + -0.010014355*nc0.w + 0.0075964513*nd0.w + -0.16495723*ne0.w + -0.12892577*nf0.w + 0.035710387*ng0.w + -0.055349573*nh0.w + 0.018455528*ni0.w;
    float u = -0.1827063*na1.x + -0.087003306*nb1.x + -0.013586943*nc1.x + -0.10099142*nd1.x + -0.04407746*ne1.x + -0.14055519*nf1.x + -0.055341262*ng1.x + -0.22188987*nh1.x + -0.00424361*ni1.x;
    float v = 0.16635212*na1.y + 0.10692179*nb1.y + 0.089410685*nc1.y + 0.038306225*nd1.y + 0.011428505*ne1.y + 0.06011443*nf1.y + -0.16809247*ng1.y + 0.22273114*nh1.y + 0.04767407*ni1.y;
    float w = 0.08062917*na1.z + 0.0023691454*nb1.z + 0.04098239*nc1.z + 0.36116946*nd1.z + 0.010449896*ne1.z + -0.047237948*nf1.z + -0.25944754*ng1.z + 0.2506446*nh1.z + 0.06529679*ni1.z;
    float x = 0.053499896*na1.w + 0.010498035*nb1.w + 0.091785476*nc1.w + 0.04551249*nd1.w + -0.10188583*ne1.w + 0.09607795*nf1.w + 0.063433304*ng1.w + -0.12168427*nh1.w + -0.024411602*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0082672285;
    i = 0.04420035*a0.x + 0.018893836*b0.x + -0.013619452*c0.x + -0.24012345*d0.x + -0.27375877*e0.x + -0.038554166*f0.x + 0.09097225*g0.x + 0.07965527*h0.x + -0.048234686*i0.x;
    j = -0.07595159*a0.y + 0.054129757*b0.y + 0.043301415*c0.y + 0.056345753*d0.y + -0.14225017*e0.y + -0.067605354*f0.y + 0.06621613*g0.y + 0.09139841*h0.y + -0.062457714*i0.y;
    k = -0.016594049*a0.z + -0.030780058*b0.z + -0.098458335*c0.z + -0.24517989*d0.z + 0.04580243*e0.z + -0.03836348*f0.z + -0.02720263*g0.z + -0.010154304*h0.z + -0.06432893*i0.z;
    l = 0.039587986*a0.w + 0.11270057*b0.w + -0.050399054*c0.w + 0.15591136*d0.w + -0.108235896*e0.w + 0.014952577*f0.w + 0.22324464*g0.w + -0.040208988*h0.w + -0.07127248*i0.w;
    m = 0.0336196*a1.x + -0.02421821*b1.x + -0.045471463*c1.x + -0.07179168*d1.x + 0.030665457*e1.x + -0.033806127*f1.x + 0.00729746*g1.x + -0.045769934*h1.x + 0.017483594*i1.x;
    n = -0.033376135*a1.y + 0.08135445*b1.y + 0.018873708*c1.y + 0.11349483*d1.y + -0.027417801*e1.y + -0.09590671*f1.y + -0.17795533*g1.y + 0.17250298*h1.y + -0.14320396*i1.y;
    o = -0.035711*a1.z + 0.029188631*b1.z + 0.0815523*c1.z + -0.16461325*d1.z + 0.18918027*e1.z + 0.0033511773*f1.z + 0.109288804*g1.z + 0.08115647*h1.z + 0.093553044*i1.z;
    p = -0.07392052*a1.w + 0.05746653*b1.w + 0.037391104*c1.w + -0.0058278493*d1.w + 0.10739208*e1.w + -0.009279468*f1.w + -0.07919596*g1.w + 0.012846508*h1.w + -0.006493424*i1.w;
    q = 0.14004427*na0.x + 0.04834755*nb0.x + 0.03813113*nc0.x + 0.18179546*nd0.x + 0.12059466*ne0.x + 0.1562862*nf0.x + 0.117933735*ng0.x + -0.041356713*nh0.x + 0.004850639*ni0.x;
    r = 0.0897286*na0.y + 0.028496258*nb0.y + 0.013498651*nc0.y + -0.12374841*nd0.y + 0.41279215*ne0.y + 0.22727947*nf0.y + 0.061800964*ng0.y + -0.16176465*nh0.y + 0.077431016*ni0.y;
    s = -0.17179112*na0.z + 0.10911651*nb0.z + -0.009969072*nc0.z + 0.06344676*nd0.z + -0.03751725*ne0.z + 0.13070048*nf0.z + -0.1389857*ng0.z + 0.047986243*nh0.z + 0.013180362*ni0.z;
    t = -0.010965876*na0.w + -0.041684385*nb0.w + 0.008301607*nc0.w + -0.167301*nd0.w + 0.08283813*ne0.w + -0.0071550948*nf0.w + -0.06452635*ng0.w + 0.1032137*nh0.w + 0.031217664*ni0.w;
    u = -0.11137781*na1.x + 0.03437329*nb1.x + -0.009390753*nc1.x + -0.10965495*nd1.x + -0.021066867*ne1.x + 0.065845564*nf1.x + -0.03633728*ng1.x + -0.012213326*nh1.x + -0.0014274631*ni1.x;
    v = 0.065072246*na1.y + 0.023515902*nb1.y + 0.040873718*nc1.y + -0.2224784*nd1.y + 0.04724838*ne1.y + 0.07304937*nf1.y + 0.05813173*ng1.y + 0.028858649*nh1.y + 0.12516193*ni1.y;
    w = 0.1324343*na1.z + -0.23523535*nb1.z + -0.038939327*nc1.z + 0.07158796*nd1.z + -0.1191352*ne1.z + -0.018787293*nf1.z + 0.12615351*ng1.z + 0.04812125*nh1.z + -0.13245015*ni1.z;
    x = 0.060072*na1.w + -0.11062477*nb1.w + 0.031622723*nc1.w + -0.029927421*nd1.w + 0.17728531*ne1.w + 0.08034003*nf1.w + 0.007750797*ng1.w + -0.19105726*nh1.w + 0.08233319*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.004496528;
    i = 0.07302485*a0.x + 0.3255973*b0.x + 0.15016317*c0.x + 0.118632555*d0.x + -0.17213899*e0.x + 0.1582742*f0.x + -0.06146779*g0.x + 0.16038014*h0.x + 0.03446602*i0.x;
    j = 0.010767944*a0.y + -0.17074314*b0.y + -0.051532004*c0.y + -0.007004298*d0.y + 0.17263626*e0.y + 0.17654046*f0.y + -0.00854635*g0.y + 0.020359043*h0.y + 0.059243754*i0.y;
    k = 0.012429514*a0.z + 0.137492*b0.z + 0.04819812*c0.z + 0.035178814*d0.z + -0.18009062*e0.z + -0.026474113*f0.z + 0.06052671*g0.z + -0.09139187*h0.z + 0.016754301*i0.z;
    l = -0.020336514*a0.w + 0.12835233*b0.w + 0.05292645*c0.w + 0.027170286*d0.w + 0.21714908*e0.w + 0.20537919*f0.w + 0.06016602*g0.w + 0.08009548*h0.w + 0.054547563*i0.w;
    m = 0.026176583*a1.x + 0.011795747*b1.x + -0.0414424*c1.x + -0.049600832*d1.x + -0.0832306*e1.x + -0.0549573*f1.x + 0.03924075*g1.x + -0.14165045*h1.x + -0.03587528*i1.x;
    n = -0.0942382*a1.y + -0.0554067*b1.y + 0.026133277*c1.y + 0.061629396*d1.y + -0.07488993*e1.y + 0.32595944*f1.y + 0.00076820946*g1.y + 0.12769783*h1.y + 0.09029101*i1.y;
    o = 0.06983503*a1.z + -0.032106537*b1.z + 0.099255025*c1.z + -0.06080937*d1.z + -0.14384937*e1.z + -0.22940788*f1.z + 0.04732333*g1.z + -0.06451785*h1.z + -0.03758684*i1.z;
    p = 0.052208744*a1.w + -0.08988008*b1.w + 0.058199216*c1.w + -0.0020835826*d1.w + 0.06585372*e1.w + 0.053097535*f1.w + -0.058973607*g1.w + 0.03506455*h1.w + -0.04801262*i1.w;
    q = -0.014868468*na0.x + 0.22615212*nb0.x + 0.073948465*nc0.x + -0.06781611*nd0.x + -0.10032018*ne0.x + -0.20862079*nf0.x + 0.06294624*ng0.x + -0.2255593*nh0.x + -0.07084244*ni0.x;
    r = 0.057524882*na0.y + 0.30524227*nb0.y + 0.35815537*nc0.y + -0.0009502602*nd0.y + -0.089151636*ne0.y + -0.14037384*nf0.y + -0.034081057*ng0.y + 0.11372325*nh0.y + 0.10721567*ni0.y;
    s = 0.057963226*na0.z + -0.10614639*nb0.z + 0.04840352*nc0.z + 0.015917875*nd0.z + 0.11659738*ne0.z + 0.11277482*nf0.z + -0.028128905*ng0.z + 0.12908414*nh0.z + -0.105552666*ni0.z;
    t = 0.019451434*na0.w + -0.13708478*nb0.w + -0.049833942*nc0.w + -0.06012834*nd0.w + -0.112836376*ne0.w + -0.24934123*nf0.w + -0.045174573*ng0.w + 0.11306015*nh0.w + -0.05403323*ni0.w;
    u = 0.0472547*na1.x + -0.023629531*nb1.x + 0.08101014*nc1.x + 0.0936124*nd1.x + -0.019263176*ne1.x + -0.018776532*nf1.x + -0.06877347*ng1.x + 0.13923196*nh1.x + 0.03186953*ni1.x;
    v = -0.010185454*na1.y + 0.09941806*nb1.y + 0.0894505*nc1.y + -0.0026836023*nd1.y + 0.12091999*ne1.y + -0.00040105637*nf1.y + -0.012306723*ng1.y + -0.01695834*nh1.y + -0.060723636*ni1.y;
    w = -0.11100347*na1.z + -0.061128043*nb1.z + -0.1416516*nc1.z + 0.07061777*nd1.z + 0.0318233*ne1.z + 0.14762254*nf1.z + 0.011475027*ng1.z + 0.10708941*nh1.z + 0.073588334*ni1.z;
    x = -0.0032446082*na1.w + 0.018291878*nb1.w + -0.09359892*nc1.w + -0.017735833*nd1.w + -0.3877458*ne1.w + -0.27740228*nf1.w + 0.07144769*ng1.w + -0.1594686*nh1.w + -0.042618934*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.016106425;
    i = 0.035688583*a0.x + 0.032622155*b0.x + -0.07878022*c0.x + -0.22056721*d0.x + 0.36388257*e0.x + 0.09935813*f0.x + -0.077380866*g0.x + -0.016323987*h0.x + 0.025766185*i0.x;
    j = 0.032614443*a0.y + 0.0075333*b0.y + -0.08914437*c0.y + -0.11388316*d0.y + -0.32016122*e0.y + -0.049377266*f0.y + 0.051589742*g0.y + 0.053202707*h0.y + -0.028994467*i0.y;
    k = 0.07181132*a0.z + 0.123275116*b0.z + -0.015218611*c0.z + -0.021832455*d0.z + 0.20298561*e0.z + -0.18469056*f0.z + 0.010181586*g0.z + 0.026014574*h0.z + 0.022069149*i0.z;
    l = 0.11116511*a0.w + 0.19239828*b0.w + 0.00020110002*c0.w + 0.3092214*d0.w + 0.25210956*e0.w + 0.029646616*f0.w + 0.13460134*g0.w + 0.22553803*h0.w + 0.2627162*i0.w;
    m = 0.20240203*a1.x + 0.04904199*b1.x + 0.087184764*c1.x + 0.2124653*d1.x + -0.31427193*e1.x + -0.104574054*f1.x + 0.044442028*g1.x + 0.07160614*h1.x + 0.0069251317*i1.x;
    n = -0.15117155*a1.y + -0.24588604*b1.y + -0.16807069*c1.y + -0.11873434*d1.y + -0.6071346*e1.y + 0.11526665*f1.y + -0.30017737*g1.y + 0.061571214*h1.y + 0.0368654*i1.y;
    o = -0.022352027*a1.z + -0.030253926*b1.z + 0.106674075*c1.z + -0.031035127*d1.z + 0.23091488*e1.z + 0.08884981*f1.z + 0.09103071*g1.z + -0.08590288*h1.z + -0.060364954*i1.z;
    p = -0.054246917*a1.w + -0.03801203*b1.w + -0.062851064*c1.w + -0.073276244*d1.w + -0.05854327*e1.w + -0.095565595*f1.w + -0.11843872*g1.w + -0.06481578*h1.w + -0.07193746*i1.w;
    q = 0.07197522*na0.x + 0.18386847*nb0.x + 0.23272155*nc0.x + 0.16188829*nd0.x + -0.025466003*ne0.x + -0.04826338*nf0.x + 0.016412303*ng0.x + 0.072044484*nh0.x + 0.009424055*ni0.x;
    r = -0.014057901*na0.y + -0.0678097*nb0.y + 0.065728344*nc0.y + 0.082456514*nd0.y + 0.24829388*ne0.y + -0.31393299*nf0.y + -0.023987576*ng0.y + -0.08345598*nh0.y + -0.0010536936*ni0.y;
    s = -0.027450949*na0.z + -0.035480395*nb0.z + -0.068690196*nc0.z + 0.02964989*nd0.z + -0.27646825*ne0.z + -0.22154613*nf0.z + 0.028639298*ng0.z + -0.14063624*nh0.z + 0.08924814*ni0.z;
    t = 0.018802406*na0.w + 0.011309935*nb0.w + -0.052953072*nc0.w + -0.07039529*nd0.w + 0.04814527*ne0.w + -0.007535829*nf0.w + 0.064747065*ng0.w + -0.14107801*nh0.w + -0.10131967*ni0.w;
    u = -0.07231724*na1.x + 0.015407522*nb1.x + -0.052383028*nc1.x + -0.17859146*nd1.x + 0.28211778*ne1.x + -0.009197533*nf1.x + -0.045684036*ng1.x + -0.06056637*nh1.x + -0.0035418952*ni1.x;
    v = 0.10038491*na1.y + 0.17251195*nb1.y + 0.09409685*nc1.y + 0.07996458*nd1.y + 0.13919151*ne1.y + 0.110783696*nf1.y + 0.009992888*ng1.y + 0.012707362*nh1.y + 0.1887242*ni1.y;
    w = -0.004788721*na1.z + 0.028190559*nb1.z + -0.08321803*nc1.z + 0.29351994*nd1.z + -0.24649957*ne1.z + -0.25687915*nf1.z + -0.07823761*ng1.z + 0.18122914*nh1.z + 0.016037595*ni1.z;
    x = -0.008824334*na1.w + -0.11209885*nb1.w + -0.032978315*nc1.w + -0.069099665*nd1.w + -0.061004076*ne1.w + -0.2446395*nf1.w + 0.09238701*ng1.w + -0.11517327*nh1.w + -0.07248953*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.01728668;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN20
//!BIND LUMAN21
//!SAVE LUMAN31

#define L0_tex LUMAN20_tex
#define L1_tex LUMAN21_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.07941704*a0.x + -0.050842553*b0.x + 0.01092942*c0.x + -0.07148679*d0.x + -0.06512474*e0.x + -0.22956467*f0.x + -0.024606694*g0.x + -0.09724198*h0.x + -0.09039128*i0.x;
    float j = 0.027611736*a0.y + 0.060809463*b0.y + 0.0667335*c0.y + 0.037682217*d0.y + 0.06852659*e0.y + 0.5153305*f0.y + 0.016338438*g0.y + 0.002601195*h0.y + 0.11281981*i0.y;
    float k = -0.060290866*a0.z + -0.011722135*b0.z + 0.085060075*c0.z + -0.08798*d0.z + -0.021146037*e0.z + 0.17453888*f0.z + 0.0018846161*g0.z + -0.024184274*h0.z + 0.037061296*i0.z;
    float l = 0.023022855*a0.w + -0.06370005*b0.w + 0.043632*c0.w + -0.0031560452*d0.w + -0.4032132*e0.w + -0.08846532*f0.w + 0.10578794*g0.w + 0.065337054*h0.w + -0.09185561*i0.w;
    float m = -0.07253925*a1.x + -0.08851836*b1.x + 0.062056795*c1.x + 0.032718055*d1.x + -0.4019351*e1.x + 0.009619835*f1.x + 0.0015480773*g1.x + -0.06635443*h1.x + -0.114055015*i1.x;
    float n = -0.010111321*a1.y + 0.16795866*b1.y + 0.07786296*c1.y + 0.020181928*d1.y + 0.26352328*e1.y + 0.004966047*f1.y + -0.08452743*g1.y + -0.11825899*h1.y + 0.054564703*i1.y;
    float o = 0.02549486*a1.z + 0.05948747*b1.z + -0.04825873*c1.z + -0.007742992*d1.z + 0.07948027*e1.z + -0.10099402*f1.z + -0.12409299*g1.z + 0.08199375*h1.z + -0.07701278*i1.z;
    float p = -0.0010457158*a1.w + 0.14753313*b1.w + -0.036453757*c1.w + 0.014154197*d1.w + -0.13650024*e1.w + 0.2692273*f1.w + 0.0583396*g1.w + 0.034443617*h1.w + 0.051470105*i1.w;
    float q = -0.01434574*na0.x + -0.07308625*nb0.x + -0.100208566*nc0.x + -0.07297119*nd0.x + -0.62616676*ne0.x + -0.011523209*nf0.x + -0.014466557*ng0.x + -0.085850835*nh0.x + -0.17460416*ni0.x;
    float r = 0.00066524564*na0.y + 0.0482624*nb0.y + 0.1272653*nc0.y + -0.073000126*nd0.y + -0.10093872*ne0.y + -0.090638004*nf0.y + 0.09337763*ng0.y + -0.0027805113*nh0.y + 0.032939613*ni0.y;
    float s = -0.058239613*na0.z + 0.0038146402*nb0.z + 0.17032205*nc0.z + 0.08319828*nd0.z + -0.41412708*ne0.z + 0.47307482*nf0.z + 0.010387847*ng0.z + 0.0633208*nh0.z + -0.0105386665*ni0.z;
    float t = -0.13282509*na0.w + 0.017102268*nb0.w + -0.006839047*nc0.w + -0.043928336*nd0.w + 0.2989465*ne0.w + 0.013503525*nf0.w + -0.011740496*ng0.w + -0.009853105*nh0.w + 0.13738577*ni0.w;
    float u = -0.027205449*na1.x + 0.03722104*nb1.x + -0.065805*nc1.x + -0.0850838*nd1.x + 0.015198619*ne1.x + -0.024742754*nf1.x + -0.061739046*ng1.x + -0.07436123*nh1.x + 0.15313913*ni1.x;
    float v = -0.00018431511*na1.y + -0.03285911*nb1.y + 0.08875587*nc1.y + 0.027293593*nd1.y + -0.21097568*ne1.y + -0.043539245*nf1.y + -0.0657312*ng1.y + 0.13540883*nh1.y + 0.011748581*ni1.y;
    float w = -0.012003101*na1.z + -0.10176224*nb1.z + -0.060972966*nc1.z + 0.047351442*nd1.z + -0.056035142*ne1.z + 0.3156803*nf1.z + 0.17128298*ng1.z + 0.08773884*nh1.z + 0.31448507*ni1.z;
    float x = -0.08746548*na1.w + 0.058036875*nb1.w + 0.07244209*nc1.w + 0.05094744*nd1.w + 0.19715828*ne1.w + 0.052874785*nf1.w + -0.0031921165*ng1.w + -0.09948083*nh1.w + -0.099991955*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.00768615;
    i = -0.2584226*a0.x + 0.049625244*b0.x + 0.085008234*c0.x + -0.25260374*d0.x + -0.20725876*e0.x + -0.052256707*f0.x + -0.24630953*g0.x + 0.020792667*h0.x + -0.12987958*i0.x;
    j = 0.11674078*a0.y + -0.05069138*b0.y + -0.054932218*c0.y + -0.002327029*d0.y + -0.3744174*e0.y + -0.06068667*f0.y + 0.0052237557*g0.y + -0.081293285*h0.y + -0.25822634*i0.y;
    k = 0.22486423*a0.z + 0.13474905*b0.z + 0.17571972*c0.z + 0.23275833*d0.z + -0.14145213*e0.z + 0.17688423*f0.z + 0.09584457*g0.z + 0.13348572*h0.z + -0.037102394*i0.z;
    l = 0.02187451*a0.w + 0.11284924*b0.w + 0.030247845*c0.w + 0.29230177*d0.w + 0.24179323*e0.w + 0.15396708*f0.w + 0.18624204*g0.w + 0.36116585*h0.w + 0.15303242*i0.w;
    m = 0.23878942*a1.x + 0.1077676*b1.x + -0.08214348*c1.x + 0.13583168*d1.x + 0.11975287*e1.x + -0.050753787*f1.x + -0.08751185*g1.x + 0.108354725*h1.x + 0.09259918*i1.x;
    n = -0.16052248*a1.y + 0.043467432*b1.y + 0.11113435*c1.y + -0.23582667*d1.y + 0.31877246*e1.y + 0.04129961*f1.y + -0.09102526*g1.y + 0.060114477*h1.y + 0.07789096*i1.y;
    o = -0.025753384*a1.z + -0.0535386*b1.z + -0.024348794*c1.z + -0.2092495*d1.z + 0.11210719*e1.z + 0.21575865*f1.z + -0.06333121*g1.z + 0.004394454*h1.z + -0.03849619*i1.z;
    p = -0.0936154*a1.w + 0.073645994*b1.w + -0.070233256*c1.w + -0.11690011*d1.w + -0.12087031*e1.w + -0.035496015*f1.w + -0.054435793*g1.w + -0.18953127*h1.w + -0.12531057*i1.w;
    q = 0.18474342*na0.x + 0.049027357*nb0.x + -0.026551004*nc0.x + 0.34006017*nd0.x + -0.06909763*ne0.x + 0.016170332*nf0.x + 0.05132557*ng0.x + 0.04963594*nh0.x + -0.06614966*ni0.x;
    r = 0.015981808*na0.y + 0.11978708*nb0.y + 0.0003225886*nc0.y + 0.13874708*nd0.y + 0.24115108*ne0.y + -0.09863037*nf0.y + 0.17281389*ng0.y + -0.0050876113*nh0.y + -0.013940462*ni0.y;
    s = -0.065658085*na0.z + 0.09520752*nb0.z + 0.059236676*nc0.z + -0.10476223*nd0.z + -0.21604007*ne0.z + 0.16991691*nf0.z + 0.020778336*ng0.z + -0.06487427*nh0.z + 0.04760285*ni0.z;
    t = 0.03405014*na0.w + -0.008665183*nb0.w + -0.08413498*nc0.w + -0.1115953*nd0.w + 0.067205414*ne0.w + -0.1394608*nf0.w + -0.07059417*ng0.w + 0.09220727*nh0.w + -0.05677373*ni0.w;
    u = 0.10527668*na1.x + 0.23578717*nb1.x + 0.13868308*nc1.x + 0.0013714005*nd1.x + -0.17564678*ne1.x + 0.17813891*nf1.x + -0.0557956*ng1.x + -0.088410884*nh1.x + -0.038198613*ni1.x;
    v = 0.07981938*na1.y + -0.14220296*nb1.y + 0.08475657*nc1.y + 0.06395585*nd1.y + -0.03096132*ne1.y + 0.17134686*nf1.y + 0.121079914*ng1.y + 0.002460959*nh1.y + -0.20324089*ni1.y;
    w = 0.036307156*na1.z + -0.018204955*nb1.z + -0.03135114*nc1.z + 0.15029632*nd1.z + 0.04616049*ne1.z + -0.2557983*nf1.z + 0.045661557*ng1.z + -0.07640636*nh1.z + 0.04804881*ni1.z;
    x = 0.07813257*na1.w + -0.023829287*nb1.w + -0.13715439*nc1.w + 0.087288216*nd1.w + -0.17041437*ne1.w + 0.10756241*nf1.w + 0.0173771*ng1.w + -0.113619484*nh1.w + 0.016020184*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.003316083;
    i = -0.028736124*a0.x + -0.08003967*b0.x + 0.09763381*c0.x + -0.00846156*d0.x + -0.18583794*e0.x + -0.049422342*f0.x + -0.07666734*g0.x + -0.02733043*h0.x + 0.040038377*i0.x;
    j = 0.018239625*a0.y + 0.19185518*b0.y + 0.13775997*c0.y + -0.0896574*d0.y + -0.32224402*e0.y + -0.005808667*f0.y + -0.042873193*g0.y + 0.102946535*h0.y + 0.16040611*i0.y;
    k = 0.07604001*a0.z + 0.06753936*b0.z + -0.0062585506*c0.z + -0.077893704*d0.z + 0.021712523*e0.z + -0.0944168*f0.z + 0.0049426183*g0.z + -0.057945896*h0.z + 0.0832966*i0.z;
    l = 0.20802133*a0.w + -0.23534459*b0.w + 0.027663095*c0.w + 0.10619838*d0.w + -0.2881961*e0.w + 0.03611936*f0.w + 0.12809974*g0.w + 0.025251053*h0.w + -0.018410701*i0.w;
    m = -0.026915021*a1.x + 0.11605544*b1.x + 0.0969195*c1.x + -0.05159316*d1.x + -0.29639572*e1.x + 0.060887333*f1.x + -0.077562116*g1.x + -0.023696246*h1.x + -0.07765453*i1.x;
    n = -0.04823381*a1.y + -0.3185404*b1.y + -0.24473429*c1.y + -0.4789328*d1.y + -0.35767055*e1.y + 0.4142013*f1.y + -0.20269759*g1.y + 0.3929618*h1.y + -0.018045327*i1.y;
    o = -0.13663228*a1.z + 0.025303073*b1.z + -0.06823502*c1.z + -0.08741995*d1.z + 0.3769405*e1.z + -0.19950937*f1.z + -0.021235209*g1.z + 0.16786906*h1.z + 0.11909075*i1.z;
    p = -0.13527294*a1.w + -0.06680806*b1.w + -0.15427993*c1.w + 0.036378223*d1.w + -0.3359488*e1.w + -0.059891827*f1.w + 0.017971888*g1.w + -0.053049818*h1.w + -0.072594084*i1.w;
    q = 0.051277246*na0.x + 0.16183147*nb0.x + 0.16584247*nc0.x + -0.09765534*nd0.x + -0.20131728*ne0.x + -0.032204267*nf0.x + -0.20159227*ng0.x + -0.07981351*nh0.x + 0.09944889*ni0.x;
    r = -0.13917594*na0.y + 0.06652356*nb0.y + -0.0883734*nc0.y + -0.024413928*nd0.y + -0.19586924*ne0.y + 0.17564073*nf0.y + 0.027439114*ng0.y + -0.03333901*nh0.y + 0.07641967*ni0.y;
    s = -0.07586603*na0.z + -0.049416613*nb0.z + 0.24173866*nc0.z + 0.1326689*nd0.z + -0.4864198*ne0.z + 0.06878775*nf0.z + 0.04480557*ng0.z + -0.1025121*nh0.z + -0.27702534*ni0.z;
    t = -0.027331017*na0.w + 0.12820075*nb0.w + 0.040788233*nc0.w + 0.061936054*nd0.w + -0.09631744*ne0.w + -0.025646532*nf0.w + 0.19220605*ng0.w + -0.11971887*nh0.w + 0.055378202*ni0.w;
    u = 0.08820415*na1.x + 0.026093876*nb1.x + -0.04180729*nc1.x + -0.19694711*nd1.x + -0.108901724*ne1.x + 0.06905329*nf1.x + -0.103396684*ng1.x + -0.11677139*nh1.x + -0.10525223*ni1.x;
    v = 0.10541181*na1.y + 0.102778554*nb1.y + 0.15439296*nc1.y + 0.051345453*nd1.y + -0.20767345*ne1.y + 0.1831073*nf1.y + -0.041579783*ng1.y + 0.04888303*nh1.y + -0.0063026203*ni1.y;
    w = 0.42541298*na1.z + 0.18639457*nb1.z + -0.18841113*nc1.z + 0.10537636*nd1.z + -0.033187203*ne1.z + 0.1277658*nf1.z + 0.40115508*ng1.z + 0.12769128*nh1.z + 0.106948815*ni1.z;
    x = -0.11754907*na1.w + 0.13961302*nb1.w + 0.043125894*nc1.w + 0.13606437*nd1.w + 0.29668897*ne1.w + -0.15002356*nf1.w + -0.0049111377*ng1.w + 0.09318963*nh1.w + 0.15725283*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0035607726;
    i = -0.0007657082*a0.x + 0.18896873*b0.x + 0.11515918*c0.x + -0.08670543*d0.x + -0.17096084*e0.x + 0.038672194*f0.x + -0.006407333*g0.x + -0.12406157*h0.x + 0.074486144*i0.x;
    j = -0.018961241*a0.y + -0.0661694*b0.y + 0.12120849*c0.y + 0.0499541*d0.y + -0.025950044*e0.y + 0.13302167*f0.y + -0.0045417123*g0.y + 0.091498435*h0.y + 0.25304177*i0.y;
    k = 0.02082855*a0.z + 0.122300126*b0.z + -0.0017944642*c0.z + 0.06828385*d0.z + 0.17769805*e0.z + 0.005459296*f0.z + 3.786597e-05*g0.z + 0.1927736*h0.z + 0.15574773*i0.z;
    l = 0.07262613*a0.w + -0.051484853*b0.w + 0.11589907*c0.w + 0.03128076*d0.w + -0.066505186*e0.w + 0.0819007*f0.w + -0.14619994*g0.w + 0.108773485*h0.w + -0.029004829*i0.w;
    m = -0.0140467575*a1.x + 0.12702075*b1.x + 0.018607724*c1.x + -0.021833913*d1.x + -0.21427749*e1.x + -0.05479105*f1.x + -0.074576564*g1.x + -0.029219097*h1.x + 0.004721507*i1.x;
    n = -0.017141543*a1.y + -0.1510377*b1.y + -0.010902904*c1.y + -0.15604293*d1.y + 0.1410916*e1.y + 0.35071704*f1.y + 0.14407732*g1.y + 0.11913299*h1.y + 0.15659198*i1.y;
    o = -0.031506337*a1.z + 0.0034794312*b1.z + -0.010843625*c1.z + -0.068582706*d1.z + 0.2035301*e1.z + -0.2578952*f1.z + -0.0045797243*g1.z + 0.0510916*h1.z + -0.04096347*i1.z;
    p = 0.0132341655*a1.w + -0.09561104*b1.w + 0.03996762*c1.w + 0.07062096*d1.w + 0.064072214*e1.w + -0.030976873*f1.w + 3.0964125e-05*g1.w + 0.09990824*h1.w + 0.057406235*i1.w;
    q = 0.029551128*na0.x + 0.14557356*nb0.x + 0.08588128*nc0.x + 0.22651055*nd0.x + -0.35015303*ne0.x + -0.014872635*nf0.x + 0.019119492*ng0.x + -0.13659622*nh0.x + -0.029656924*ni0.x;
    r = 0.03831925*na0.y + 0.19166094*nb0.y + -0.14751142*nc0.y + 0.10880705*nd0.y + -0.058297906*ne0.y + -0.33643624*nf0.y + -0.10262261*ng0.y + 0.024292309*nh0.y + -0.061532244*ni0.y;
    s = 0.028195743*na0.z + -0.08969857*nb0.z + 0.020221138*nc0.z + -0.038737748*nd0.z + -0.036892556*ne0.z + -0.12940665*nf0.z + -0.06352916*ng0.z + -0.014914517*nh0.z + -0.13324068*ni0.z;
    t = -0.023716316*na0.w + 0.015531115*nb0.w + -0.08457603*nc0.w + 0.009459709*nd0.w + 0.16085471*ne0.w + -0.061606925*nf0.w + -0.032667276*ng0.w + -0.05158212*nh0.w + -0.03426355*ni0.w;
    u = 0.024232633*na1.x + -0.070986755*nb1.x + -0.0058888225*nc1.x + 0.07083461*nd1.x + 0.13945094*ne1.x + -0.11468432*nf1.x + -0.023783585*ng1.x + -0.08165796*nh1.x + -0.12259042*ni1.x;
    v = 0.0030000864*na1.y + 0.0041845613*nb1.y + 0.00797792*nc1.y + -0.010358695*nd1.y + 0.039620068*ne1.y + 0.003697568*nf1.y + -0.034909796*ng1.y + 0.046191987*nh1.y + 0.043660384*ni1.y;
    w = 0.03257494*na1.z + 0.058587745*nb1.z + -0.04471518*nc1.z + -0.10175396*nd1.z + 0.029540528*ne1.z + 0.12884614*nf1.z + -0.19663431*ng1.z + -0.009101876*nh1.z + 0.14205857*ni1.z;
    x = -0.0063677295*na1.w + 0.064730145*nb1.w + -0.11158172*nc1.w + -0.008992963*nd1.w + 0.06534912*ne1.w + -0.14108323*nf1.w + 0.0464611*ng1.w + 0.02179613*nh1.w + -0.003715472*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.012906831;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN30
//!BIND LUMAN31
//!SAVE LUMAN40

#define L0_tex LUMAN30_tex
#define L1_tex LUMAN31_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.08656171*a0.x + 0.21290569*b0.x + -0.004001642*c0.x + 0.03927889*d0.x + -0.079883896*e0.x + 0.096595794*f0.x + -0.03477963*g0.x + 0.04326191*h0.x + 0.07472603*i0.x;
    float j = -0.026371144*a0.y + -0.10890013*b0.y + -0.074713044*c0.y + -0.03986311*d0.y + -0.06510753*e0.y + -0.046004105*f0.y + -0.0076048975*g0.y + -0.063950986*h0.y + -0.018643167*i0.y;
    float k = 0.03444205*a0.z + -0.052693386*b0.z + 0.0024046462*c0.z + -0.06357705*d0.z + -0.100524455*e0.z + 0.034741692*f0.z + 0.0119595*g0.z + -0.02717993*h0.z + 0.050470024*i0.z;
    float l = -0.022481086*a0.w + -0.074111626*b0.w + -0.06492289*c0.w + 0.0215112*d0.w + -0.2213038*e0.w + 0.0204108*f0.w + -0.0067506693*g0.w + -0.062500216*h0.w + -0.062180262*i0.w;
    float m = 0.03696488*a1.x + 0.04108178*b1.x + -0.011093009*c1.x + 0.2494327*d1.x + -0.031587277*e1.x + 0.02254383*f1.x + 0.04281861*g1.x + 0.019687284*h1.x + -0.063386016*i1.x;
    float n = -0.01412882*a1.y + -0.034890138*b1.y + 0.0143132545*c1.y + 0.049496226*d1.y + -0.10116899*e1.y + -0.03730606*f1.y + -0.007983867*g1.y + -0.05111721*h1.y + 0.012292823*i1.y;
    float o = 0.10091559*a1.z + 0.1054921*b1.z + -0.07666608*c1.z + 0.010558074*d1.z + -0.016222922*e1.z + -0.030339802*f1.z + -0.024651198*g1.z + 0.11539425*h1.z + -0.008982327*i1.z;
    float p = 0.08782505*a1.w + -0.0039771134*b1.w + 0.106606014*c1.w + 0.07876641*d1.w + -0.07574561*e1.w + -0.03822405*f1.w + 0.09565453*g1.w + 0.057285316*h1.w + 0.07650349*i1.w;
    float q = -0.005750001*na0.x + -0.031764384*nb0.x + 0.030848796*nc0.x + 0.032382507*nd0.x + -0.084400214*ne0.x + -0.16719313*nf0.x + -0.003563804*ng0.x + -0.08467185*nh0.x + -0.013666626*ni0.x;
    float r = 0.012016638*na0.y + 0.14458697*nb0.y + 0.006680341*nc0.y + -0.025037276*nd0.y + 0.17308724*ne0.y + -0.018338397*nf0.y + 8.713182e-06*ng0.y + 0.08174603*nh0.y + -0.053476475*ni0.y;
    float s = -0.014294115*na0.z + 0.025022032*nb0.z + -0.018170934*nc0.z + 0.037305776*nd0.z + -0.1749532*ne0.z + -0.0077695046*nf0.z + 0.026932228*ng0.z + -0.08316069*nh0.z + 0.053805698*ni0.z;
    float t = -0.012198974*na0.w + 0.14582784*nb0.w + 0.07482499*nc0.w + -0.051537655*nd0.w + 0.08446009*ne0.w + -0.0373948*nf0.w + -0.023523446*ng0.w + -0.026085692*nh0.w + 0.011028385*ni0.w;
    float u = 0.087766856*na1.x + 0.034175277*nb1.x + 0.03152634*nc1.x + -0.101653695*nd1.x + 0.03928409*ne1.x + -0.06981694*nf1.x + 0.03964823*ng1.x + 0.006642139*nh1.x + 0.017051173*ni1.x;
    float v = 0.08698132*na1.y + 0.0438875*nb1.y + 0.0451187*nc1.y + -0.10329641*nd1.y + 0.02733591*ne1.y + 0.006656351*nf1.y + -0.011088956*ng1.y + -0.0047664074*nh1.y + 0.11088423*ni1.y;
    float w = -0.03557234*na1.z + -0.040018145*nb1.z + 0.031464696*nc1.z + -0.0041148905*nd1.z + -0.07126713*ne1.z + 0.057261378*nf1.z + -0.003973193*ng1.z + -0.016189586*nh1.z + 0.009429872*ni1.z;
    float x = 0.08568026*na1.w + -0.0058499873*nb1.w + -0.044522725*nc1.w + 0.055148397*nd1.w + 0.015802909*ne1.w + 0.04047864*nf1.w + 0.13689119*ng1.w + 0.11317675*nh1.w + -0.045768175*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0064203455;
    i = -0.032505844*a0.x + -0.06661497*b0.x + 0.023512855*c0.x + 0.0038409652*d0.x + -0.23903687*e0.x + -0.16547106*f0.x + 0.07911498*g0.x + 0.03786903*h0.x + 0.17299125*i0.x;
    j = 0.040522475*a0.y + -0.03672423*b0.y + -0.08684519*c0.y + -4.828527e-06*d0.y + -0.0288446*e0.y + -0.11859806*f0.y + 0.022469537*g0.y + -0.10261296*h0.y + -0.081498824*i0.y;
    k = 0.09966686*a0.z + -0.028391572*b0.z + -0.06806597*c0.z + 0.12051737*d0.z + -0.08948898*e0.z + 0.0077337893*f0.z + 0.04264053*g0.z + 0.24295592*h0.z + 0.07553067*i0.z;
    l = -0.014257156*a0.w + -0.08241062*b0.w + 0.044526782*c0.w + -0.013082403*d0.w + 0.13204414*e0.w + -0.27255267*f0.w + -0.11447851*g0.w + -0.097617336*h0.w + 0.011688421*i0.w;
    m = -0.14570348*a1.x + -0.06814128*b1.x + 0.05697731*c1.x + -0.05217858*d1.x + 0.1640323*e1.x + -0.09593827*f1.x + -0.12755282*g1.x + -0.086524084*h1.x + 0.008667198*i1.x;
    n = -0.068069056*a1.y + -0.081919774*b1.y + 0.04359047*c1.y + -0.09954159*d1.y + -0.019505976*e1.y + -0.027422508*f1.y + 0.03656061*g1.y + 0.11309899*h1.y + 0.06715181*i1.y;
    o = -0.11340588*a1.z + -0.051423706*b1.z + -0.19613335*c1.z + -0.13584042*d1.z + -0.023867423*e1.z + -0.2166873*f1.z + -0.12436677*g1.z + -0.3056145*h1.z + -0.07004896*i1.z;
    p = 0.07956318*a1.w + 0.07576396*b1.w + 0.17090248*c1.w + 0.1677179*d1.w + 0.20357732*e1.w + 0.14348814*f1.w + 0.03334289*g1.w + 0.09176273*h1.w + -0.017910657*i1.w;
    q = 0.026086422*na0.x + 0.097765036*nb0.x + 0.10587866*nc0.x + 0.01978553*nd0.x + 0.09502771*ne0.x + -0.012682824*nf0.x + -0.040875986*ng0.x + -0.0034920182*nh0.x + -0.19141385*ni0.x;
    r = 0.04607431*na0.y + -0.009378766*nb0.y + 0.0012423345*nc0.y + -0.13031623*nd0.y + 0.040903624*ne0.y + 0.12283624*nf0.y + -0.09508061*ng0.y + -0.13311584*nh0.y + -0.16675362*ni0.y;
    s = -0.063626915*na0.z + -0.10388871*nb0.z + -0.011007665*nc0.z + -0.027193287*nd0.z + 0.11276182*ne0.z + 0.076111704*nf0.z + -0.08517991*ng0.z + -0.21885648*nh0.z + 0.18072192*ni0.z;
    t = -0.07872067*na0.w + 0.103839375*nb0.w + -0.08590919*nc0.w + 0.12628321*nd0.w + -0.17647605*ne0.w + -0.010150693*nf0.w + 0.1574605*ng0.w + 0.018935064*nh0.w + 0.046108305*ni0.w;
    u = 0.11362486*na1.x + -0.020307075*nb1.x + -0.08245713*nc1.x + 0.091107495*nd1.x + 0.050005887*ne1.x + 0.042820398*nf1.x + 0.1548857*ng1.x + 0.009557177*nh1.x + -0.05151787*ni1.x;
    v = -0.0028884336*na1.y + 0.15852699*nb1.y + -0.061137117*nc1.y + -0.023769902*nd1.y + -0.08125711*ne1.y + -0.14575318*nf1.y + -0.04427445*ng1.y + -0.03595139*nh1.y + -0.09431575*ni1.y;
    w = -0.09712683*na1.z + -0.08819136*nb1.z + 0.08729634*nc1.z + -0.09290895*nd1.z + -0.010472437*ne1.z + 0.04311587*nf1.z + -0.049348596*ng1.z + 0.12841254*nh1.z + -0.013184504*ni1.z;
    x = 0.2775273*na1.w + -0.07508342*nb1.w + -0.13421123*nc1.w + 0.048939656*nd1.w + -0.17091548*ne1.w + -0.097308844*nf1.w + -0.19330767*ng1.w + 0.072174154*nh1.w + 0.119323336*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.010473969;
    i = -0.04255606*a0.x + 0.19455163*b0.x + -0.083725154*c0.x + 0.025356045*d0.x + -0.09469336*e0.x + 0.011819241*f0.x + 0.11374274*g0.x + -0.0053759404*h0.x + 0.21639374*i0.x;
    j = 0.029581068*a0.y + -0.02986516*b0.y + 0.021204757*c0.y + -0.006031846*d0.y + -0.13951546*e0.y + -0.10485541*f0.y + -0.055438254*g0.y + -0.12904681*h0.y + -0.06661593*i0.y;
    k = 0.042120147*a0.z + 0.076120056*b0.z + 0.058799937*c0.z + -0.0085356785*d0.z + -0.37842253*e0.z + 0.15116076*f0.z + -0.072133794*g0.z + 0.25175855*h0.z + 0.07849843*i0.z;
    l = 0.07480219*a0.w + 0.026436467*b0.w + -0.05192802*c0.w + -0.20132145*d0.w + 0.046653923*e0.w + -0.057974514*f0.w + -0.18881139*g0.w + 0.03869617*h0.w + -0.05359312*i0.w;
    m = 0.18609796*a1.x + -0.025107978*b1.x + -0.05485416*c1.x + -0.12506877*d1.x + 0.16311458*e1.x + 0.14975427*f1.x + 0.06121656*g1.x + 0.111572266*h1.x + -0.06902193*i1.x;
    n = -0.09675723*a1.y + 0.03395821*b1.y + -0.10529792*c1.y + 0.08510861*d1.y + 0.001478931*e1.y + -0.019302577*f1.y + 0.11827853*g1.y + 0.01141932*h1.y + 0.058337122*i1.y;
    o = 0.028637297*a1.z + 0.116889395*b1.z + -0.051687524*c1.z + 0.25920773*d1.z + -0.09955058*e1.z + -0.111958966*f1.z + -0.01542771*g1.z + 0.14032897*h1.z + 0.11228361*i1.z;
    p = -0.102572076*a1.w + -0.10000578*b1.w + 0.010802064*c1.w + -0.17006679*d1.w + 0.28425327*e1.w + 0.09406719*f1.w + 0.12390108*g1.w + 0.01619186*h1.w + 0.030436736*i1.w;
    q = -0.05434198*na0.x + -0.044370797*nb0.x + -0.07496158*nc0.x + 0.003799395*nd0.x + -0.01952927*ne0.x + -0.104056075*nf0.x + 0.02114818*ng0.x + 0.08832213*nh0.x + -0.073473066*ni0.x;
    r = 0.117009945*na0.y + 0.053020813*nb0.y + -0.020469973*nc0.y + -0.0071595195*nd0.y + 0.11518942*ne0.y + 0.06417461*nf0.y + -0.10637551*ng0.y + 0.029846275*nh0.y + 0.017103193*ni0.y;
    s = 0.026859421*na0.z + 0.033828203*nb0.z + -0.09990076*nc0.z + -0.18400614*nd0.z + 0.045542575*ne0.z + 0.007697366*nf0.z + -0.14255059*ng0.z + -0.17000173*nh0.z + 0.02396432*ni0.z;
    t = 0.06297595*na0.w + -0.14622249*nb0.w + 0.019562326*nc0.w + -0.026149035*nd0.w + -0.20541689*ne0.w + -0.09325157*nf0.w + -0.015335166*ng0.w + -0.004904096*nh0.w + -0.023256762*ni0.w;
    u = -0.19524229*na1.x + 0.14019871*nb1.x + 0.043756094*nc1.x + 0.05927864*nd1.x + -0.10984285*ne1.x + -0.07402525*nf1.x + 0.0091582425*ng1.x + 0.12954497*nh1.x + 0.035891227*ni1.x;
    v = 0.16249649*na1.y + -0.11102605*nb1.y + 0.09617183*nc1.y + -0.1347269*nd1.y + 0.0038432048*ne1.y + 0.04074855*nf1.y + -0.084884845*ng1.y + -0.032651823*nh1.y + 0.023996437*ni1.y;
    w = 0.09400437*na1.z + 0.05132347*nb1.z + -0.02254565*nc1.z + -0.052191116*nd1.z + -0.006187364*ne1.z + 0.12594841*nf1.z + 0.017266754*ng1.z + -0.05394334*nh1.z + 0.05234719*ni1.z;
    x = -0.07382347*na1.w + 0.2015254*nb1.w + -0.021788929*nc1.w + -0.11237425*nd1.w + -0.06845667*ne1.w + -0.08814462*nf1.w + 0.21006493*ng1.w + -0.030658796*nh1.w + 0.020792674*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013023297;
    i = -0.035656873*a0.x + 0.29043454*b0.x + -0.093485475*c0.x + -0.088546365*d0.x + -0.18280011*e0.x + -0.08531151*f0.x + -0.08396969*g0.x + -0.12895977*h0.x + -0.13381611*i0.x;
    j = 0.08109509*a0.y + 0.061622415*b0.y + 0.09512347*c0.y + 0.09760661*d0.y + 0.23493265*e0.y + -0.15241936*f0.y + 0.08086118*g0.y + 0.0482658*h0.y + 0.005154483*i0.y;
    k = 0.08385953*a0.z + 0.23023549*b0.z + 0.10558045*c0.z + 0.12571234*d0.z + -0.12436785*e0.z + 0.11162487*f0.z + 0.25766334*g0.z + -0.04955883*h0.z + -0.038839206*i0.z;
    l = -0.031077331*a0.w + 0.037581697*b0.w + 0.03739792*c0.w + -0.023134084*d0.w + 0.108166225*e0.w + -0.27240586*f0.w + 0.11235108*g0.w + 0.055221915*h0.w + -0.04974431*i0.w;
    m = 0.050685987*a1.x + -0.0855947*b1.x + 0.114472255*c1.x + 0.21767192*d1.x + 0.06479547*e1.x + -0.111951314*f1.x + -0.20780368*g1.x + -0.24934538*h1.x + -0.018018583*i1.x;
    n = -0.0223691*a1.y + -0.031400625*b1.y + -0.14545901*c1.y + -0.08056975*d1.y + 0.06659198*e1.y + -0.14099553*f1.y + -0.1574511*g1.y + -0.068153*h1.y + 0.03834908*i1.y;
    o = -0.1388241*a1.z + 0.033197176*b1.z + -0.08693326*c1.z + -0.095407344*d1.z + -0.024903448*e1.z + -0.00516698*f1.z + 0.0051005622*g1.z + -0.20142871*h1.z + -0.17023231*i1.z;
    p = -0.0391193*a1.w + -0.19792503*b1.w + -0.09035685*c1.w + -0.079474576*d1.w + 0.23703781*e1.w + 0.02854966*f1.w + 0.0572757*g1.w + -0.15615135*h1.w + 0.09795711*i1.w;
    q = -0.07639385*na0.x + -0.13368028*nb0.x + 0.12966728*nc0.x + 0.0006021519*nd0.x + 0.35783088*ne0.x + 0.036377307*nf0.x + -0.13852029*ng0.x + -0.1278901*nh0.x + 0.07102291*ni0.x;
    r = 0.12950456*na0.y + 0.13638775*nb0.y + 0.089563526*nc0.y + 0.0046526827*nd0.y + 0.22827531*ne0.y + 0.26544076*nf0.y + -0.053933237*ng0.y + -0.05662332*nh0.y + 0.13788679*ni0.y;
    s = 0.05483395*na0.z + -0.10790315*nb0.z + -0.03360025*nc0.z + -0.010222414*nd0.z + -0.029511753*ne0.z + -0.24544497*nf0.z + 0.13202304*ng0.z + -0.33339366*nh0.z + 0.0014636389*ni0.z;
    t = 0.051150147*na0.w + -0.06408108*nb0.w + -0.13684914*nc0.w + 0.17577235*nd0.w + -0.1577332*ne0.w + -0.1533534*nf0.w + -0.104082346*ng0.w + 0.102217875*nh0.w + 0.04462048*ni0.w;
    u = -0.057499893*na1.x + 0.03404051*nb1.x + -0.09530944*nc1.x + -0.0014036942*nd1.x + 0.10787034*ne1.x + 0.12311618*nf1.x + 0.122414425*ng1.x + 0.105717205*nh1.x + 0.05405656*ni1.x;
    v = 0.06136542*na1.y + 0.14106013*nb1.y + 0.15290134*nc1.y + 0.01512413*nd1.y + -0.12528025*ne1.y + -0.011202091*nf1.y + -0.06423187*ng1.y + 0.11118383*nh1.y + -0.09679467*ni1.y;
    w = -0.011665277*na1.z + -0.07377728*nb1.z + 0.066744976*nc1.z + -0.054813497*nd1.z + -0.010954526*ne1.z + -0.01603292*nf1.z + -0.024203874*ng1.z + 0.12063812*nh1.z + -0.07406548*ni1.z;
    x = -0.040362768*na1.w + 0.28191712*nb1.w + 0.1577795*nc1.w + 0.050058506*nd1.w + -0.29588038*ne1.w + 0.09272126*nf1.w + -0.32352138*ng1.w + -0.004645486*nh1.w + 0.10912149*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.005315338;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN30
//!BIND LUMAN31
//!SAVE LUMAN41

#define L0_tex LUMAN30_tex
#define L1_tex LUMAN31_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.05897486*a0.x + 0.27586955*b0.x + -0.056688223*c0.x + 0.07561018*d0.x + -0.10525086*e0.x + -0.24340199*f0.x + 0.06659864*g0.x + 0.06901837*h0.x + -0.013376588*i0.x;
    float j = 0.014839147*a0.y + 0.10390609*b0.y + 0.1116336*c0.y + -0.014721822*d0.y + 0.07653417*e0.y + -0.1429016*f0.y + 0.064306565*g0.y + 0.052361738*h0.y + 0.0657451*i0.y;
    float k = -0.07460744*a0.z + -0.085255824*b0.z + 0.041533597*c0.z + -0.008417165*d0.z + -0.18311697*e0.z + 0.04132524*f0.z + -0.12762608*g0.z + -0.0490694*h0.z + 0.021340536*i0.z;
    float l = -0.1186136*a0.w + -0.22919929*b0.w + -0.013643524*c0.w + -0.20086412*d0.w + 0.013207006*e0.w + 0.11305753*f0.w + -0.12692404*g0.w + -0.0072910134*h0.w + -0.11241811*i0.w;
    float m = -0.21522538*a1.x + -0.14833283*b1.x + -0.022969369*c1.x + -0.27716902*d1.x + 0.03638555*e1.x + -0.057161108*f1.x + -0.15450016*g1.x + -0.050380804*h1.x + 0.003395265*i1.x;
    float n = 0.024632271*a1.y + 0.0382964*b1.y + 0.035003234*c1.y + 0.13437985*d1.y + -0.06140864*e1.y + -0.049475253*f1.y + 0.036768384*g1.y + -0.081538476*h1.y + -0.073716685*i1.y;
    float o = 0.016729493*a1.z + -0.08793989*b1.z + -0.054102853*c1.z + 0.08820071*d1.z + -0.1565456*e1.z + -0.0405766*f1.z + -0.03476591*g1.z + 0.095920935*h1.z + -0.037696473*i1.z;
    float p = 0.09913229*a1.w + 0.04506712*b1.w + 0.12394397*c1.w + -0.049859747*d1.w + 0.42513847*e1.w + -0.10907899*f1.w + 0.18546146*g1.w + -0.019482087*h1.w + -0.022588788*i1.w;
    float q = 0.05428734*na0.x + -0.09825094*nb0.x + 0.07060548*nc0.x + -0.13419129*nd0.x + -0.28279778*ne0.x + 0.13844308*nf0.x + -0.043456554*ng0.x + -0.1443664*nh0.x + 0.06768429*ni0.x;
    float r = 0.0012980829*na0.y + 0.03715222*nb0.y + -0.16464917*nc0.y + 0.1668546*nd0.y + -0.3276691*ne0.y + -0.07289079*nf0.y + 0.022440374*ng0.y + 0.1451005*nh0.y + -0.023447124*ni0.y;
    float s = 0.064184375*na0.z + -0.06619485*nb0.z + -0.021960482*nc0.z + 0.021397583*nd0.z + 0.0736206*ne0.z + -0.090951815*nf0.z + 0.111692496*ng0.z + 0.00050554925*nh0.z + 0.08926067*ni0.z;
    float t = 0.012369069*na0.w + 0.1951646*nb0.w + -0.020873873*nc0.w + 0.116908714*nd0.w + -0.48967528*ne0.w + -0.07455504*nf0.w + 0.15106396*ng0.w + -0.048980996*nh0.w + 0.030512914*ni0.w;
    float u = 0.16899328*na1.x + 0.10447588*nb1.x + -0.009505267*nc1.x + 0.41911155*nd1.x + -0.009806482*ne1.x + -0.0030871788*nf1.x + 0.16966148*ng1.x + 0.037004367*nh1.x + 0.032864075*ni1.x;
    float v = 0.09795996*na1.y + 0.002576914*nb1.y + -0.02554661*nc1.y + -0.15558101*nd1.y + -0.19964558*ne1.y + 0.022412546*nf1.y + -0.094990425*ng1.y + 0.08371083*nh1.y + 0.121753626*ni1.y;
    float w = -0.010198556*na1.z + -0.027575629*nb1.z + 0.048614904*nc1.z + -0.050866783*nd1.z + 0.06520363*ne1.z + 0.07152051*nf1.z + -0.039514203*ng1.z + 0.00061794004*nh1.z + -0.04162527*ni1.z;
    float x = 0.021820385*na1.w + -0.12759149*nb1.w + -0.050192278*nc1.w + 0.3388716*nd1.w + -0.35848868*ne1.w + 0.118803196*nf1.w + 0.007576073*ng1.w + 0.13519461*nh1.w + 0.012417935*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.005134705;
    i = -0.012094228*a0.x + -0.037648804*b0.x + 0.018825721*c0.x + -0.056415178*d0.x + -0.1693265*e0.x + -0.3329496*f0.x + 0.04385037*g0.x + 0.24782597*h0.x + 0.024003597*i0.x;
    j = 0.017770931*a0.y + 0.061245997*b0.y + 0.12247424*c0.y + 0.030261982*d0.y + -0.120891064*e0.y + 0.19610105*f0.y + -0.021305876*g0.y + 0.007743256*h0.y + -0.029186502*i0.y;
    k = 0.011247433*a0.z + 0.26010805*b0.z + 0.005410956*c0.z + 0.1756328*d0.z + 0.52665186*e0.z + 0.019311607*f0.z + -0.22865027*g0.z + 0.018537138*h0.z + 0.28844747*i0.z;
    l = 0.04707084*a0.w + -0.019024597*b0.w + 0.010127482*c0.w + 0.07881962*d0.w + -0.21882728*e0.w + -0.4462807*f0.w + -0.11017183*g0.w + 0.0014828485*h0.w + -0.055836964*i0.w;
    m = -0.15131445*a1.x + -0.03349337*b1.x + 0.056926448*c1.x + 0.123288214*d1.x + -0.30359584*e1.x + -0.13110815*f1.x + -0.02858217*g1.x + -0.04218747*h1.x + -0.007281833*i1.x;
    n = -0.000634909*a1.y + -0.09829987*b1.y + -0.12674282*c1.y + -0.18262619*d1.y + -0.20625703*e1.y + 0.027821977*f1.y + 0.04650851*g1.y + 0.036779493*h1.y + 0.044706035*i1.y;
    o = -0.05769353*a1.z + -0.32191262*b1.z + -0.09332154*c1.z + -0.034158923*d1.z + -0.3178729*e1.z + -0.18241036*f1.z + -0.14834101*g1.z + -0.08815691*h1.z + -0.18666048*i1.z;
    p = -0.034857456*a1.w + 0.13235937*b1.w + -0.00871079*c1.w + 0.09402437*d1.w + 0.22523633*e1.w + 0.18679704*f1.w + 0.14387223*g1.w + -0.061898142*h1.w + -0.017365128*i1.w;
    q = -0.20398696*na0.x + 0.18950963*nb0.x + 0.045875635*nc0.x + -0.05545748*nd0.x + -0.47266406*ne0.x + -0.0478476*nf0.x + -0.0812568*ng0.x + -0.060154606*nh0.x + -0.06312032*ni0.x;
    r = 0.19471812*na0.y + 0.34276626*nb0.y + -0.002011672*nc0.y + 0.08900145*nd0.y + 0.2595511*ne0.y + -0.24681035*nf0.y + -0.024882982*ng0.y + 0.02331316*nh0.y + -0.32200062*ni0.y;
    s = 0.114582*na0.z + -0.19037218*nb0.z + -0.1417176*nc0.z + -0.10363403*nd0.z + -0.11044682*ne0.z + -0.059798382*nf0.z + 0.08371505*ng0.z + 0.44800338*nh0.z + 0.09965122*ni0.z;
    t = -0.01947535*na0.w + -0.17559212*nb0.w + -0.033264827*nc0.w + 0.14829087*nd0.w + -0.19467528*ne0.w + 0.116288066*nf0.w + 0.1205474*ng0.w + 0.044752423*nh0.w + -0.031209234*ni0.w;
    u = -0.004728546*na1.x + -0.13519558*nb1.x + -0.02461425*nc1.x + -0.073864736*nd1.x + 0.48404813*ne1.x + 0.088028006*nf1.x + 0.050297916*ng1.x + -0.008906264*nh1.x + -0.019913306*ni1.x;
    v = 0.10467789*na1.y + 0.11910779*nb1.y + 0.15660498*nc1.y + -0.07719423*nd1.y + -0.1274165*ne1.y + -0.022373257*nf1.y + -0.059113465*ng1.y + 0.045096442*nh1.y + -0.027823227*ni1.y;
    w = 0.06638856*na1.z + -0.032282606*nb1.z + -0.011439734*nc1.z + -0.07844197*nd1.z + 0.053250894*ne1.z + 0.07105429*nf1.z + -0.03597942*ng1.z + 0.101988435*nh1.z + 0.11831101*ni1.z;
    x = 0.25001556*na1.w + -0.046163235*nb1.w + 0.064991914*nc1.w + 0.08997446*nd1.w + 0.022799926*ne1.w + -0.23605661*nf1.w + -0.09163479*ng1.w + -0.0658797*nh1.w + 0.22340213*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.028153285;
    i = -0.05723475*a0.x + -0.25381944*b0.x + 0.17901848*c0.x + -0.014471504*d0.x + 0.35167104*e0.x + 0.08602924*f0.x + -0.11910211*g0.x + -0.17563531*h0.x + 0.04424879*i0.x;
    j = -0.022332152*a0.y + -0.14992887*b0.y + 0.067525476*c0.y + 0.14036782*d0.y + -0.091856144*e0.y + 0.0013875823*f0.y + -0.016366925*g0.y + -0.20222068*h0.y + 0.13036513*i0.y;
    k = 0.04965131*a0.z + 0.03841196*b0.z + 0.10992083*c0.z + 0.3528956*d0.z + 0.24185915*e0.z + -0.23682235*f0.z + 0.25822678*g0.z + 0.26567867*h0.z + 0.040070523*i0.z;
    l = 0.005208211*a0.w + -0.088146344*b0.w + 0.011741281*c0.w + 0.18548676*d0.w + 0.20249239*e0.w + -0.10297989*f0.w + 0.043873258*g0.w + 0.010360001*h0.w + 0.080844186*i0.w;
    m = 0.11925185*a1.x + -0.002130104*b1.x + -0.0017537178*c1.x + -0.119089566*d1.x + 0.09701926*e1.x + 0.02401391*f1.x + -0.21442156*g1.x + 0.030856185*h1.x + -0.024846844*i1.x;
    n = 0.033464372*a1.y + -0.0017296523*b1.y + -0.17002295*c1.y + 0.1224641*d1.y + 0.2461822*e1.y + 0.26922768*f1.y + -0.032281265*g1.y + -0.08174399*h1.y + -0.024631953*i1.y;
    o = -0.010928469*a1.z + 0.040003847*b1.z + -0.009050721*c1.z + -0.18532535*d1.z + 0.117428556*e1.z + -0.054807805*f1.z + 0.3688676*g1.z + -0.20925143*h1.z + -0.12101665*i1.z;
    p = -0.050080348*a1.w + -0.023793569*b1.w + -0.046359524*c1.w + -0.46156624*d1.w + -0.084235124*e1.w + 0.170481*f1.w + -0.34520224*g1.w + 0.08081779*h1.w + 0.046790455*i1.w;
    q = -0.013522426*na0.x + 0.08664619*nb0.x + 0.040773723*nc0.x + -0.29594067*nd0.x + -0.43927056*ne0.x + -0.23970877*nf0.x + -0.071083836*ng0.x + 0.022856604*nh0.x + -0.083344005*ni0.x;
    r = -0.06762164*na0.y + 0.48516664*nb0.y + 0.2361623*nc0.y + -0.2992352*nd0.y + -0.42049935*ne0.y + -0.08378619*nf0.y + -0.18655877*ng0.y + -0.2691026*nh0.y + -0.15376762*ni0.y;
    s = -0.116502166*na0.z + 0.10032056*nb0.z + -0.09566259*nc0.z + -0.18851502*nd0.z + 0.30246553*ne0.z + 0.0009529123*nf0.z + -0.09874099*ng0.z + -0.2364732*nh0.z + 0.11826255*ni0.z;
    t = -0.03493555*na0.w + -0.035773568*nb0.w + -0.12659708*nc0.w + -0.16138509*nd0.w + -0.07105405*ne0.w + 0.09101966*nf0.w + 0.24660683*ng0.w + -0.0061035194*nh0.w + -0.040358752*ni0.w;
    u = 0.057612475*na1.x + -0.015996441*nb1.x + 0.004548848*nc1.x + -0.108426526*nd1.x + -0.10091294*ne1.x + -0.012472666*nf1.x + -0.021699939*ng1.x + 0.07560604*nh1.x + -0.024083558*ni1.x;
    v = -0.14357498*na1.y + 0.15821618*nb1.y + 0.21333988*nc1.y + -0.041154474*nd1.y + -0.07063476*ne1.y + -0.20110704*nf1.y + 0.10822521*ng1.y + 0.11874143*nh1.y + -0.011279268*ni1.y;
    w = -0.018583542*na1.z + -0.11350155*nb1.z + 0.01832477*nc1.z + 0.21990615*nd1.z + 0.022556763*ne1.z + 0.11403346*nf1.z + -0.20918418*ng1.z + 0.12558801*nh1.z + 0.037197538*ni1.z;
    x = 0.06027407*na1.w + 0.15575232*nb1.w + 0.15703124*nc1.w + -0.102149114*nd1.w + 0.3785688*ne1.w + -0.2512173*nf1.w + -0.047505885*ng1.w + 0.11199537*nh1.w + -0.033578023*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.024645254;
    i = -0.11315129*a0.x + -0.13970152*b0.x + -0.0106838625*c0.x + -0.16662036*d0.x + 0.0351158*e0.x + -0.3236344*f0.x + -0.10745606*g0.x + 0.10335738*h0.x + 0.060342573*i0.x;
    j = 0.05034862*a0.y + -0.03773915*b0.y + -0.11317716*c0.y + -0.1319167*d0.y + -0.2557561*e0.y + -0.37108675*f0.y + -0.121097684*g0.y + -0.017232087*h0.y + -0.29864594*i0.y;
    k = -0.17640741*a0.z + -0.05367414*b0.z + -0.1096958*c0.z + -0.15220755*d0.z + -0.39255792*e0.z + -0.042989623*f0.z + -0.08857472*g0.z + -0.07308339*h0.z + 0.12683356*i0.z;
    l = 0.04818234*a0.w + 0.011259093*b0.w + -0.13971567*c0.w + 0.20727336*d0.w + 0.300634*e0.w + 0.15203673*f0.w + 0.045851354*g0.w + -0.021859625*h0.w + 0.14271338*i0.w;
    m = -0.05115792*a1.x + -0.030130638*b1.x + 0.012354536*c1.x + -0.20207289*d1.x + 0.24113736*e1.x + 0.07546829*f1.x + 0.054056752*g1.x + 0.22468947*h1.x + 0.18395297*i1.x;
    n = -0.016631735*a1.y + 0.14029092*b1.y + 0.1094122*c1.y + -0.21489155*d1.y + 0.030756673*e1.y + 0.08403406*f1.y + 0.029142294*g1.y + -0.15179269*h1.y + 0.06422021*i1.y;
    o = 0.060144097*a1.z + -0.05253342*b1.z + -0.08916168*c1.z + 0.11863635*d1.z + -0.13244452*e1.z + -0.20428996*f1.z + -0.02991306*g1.z + -0.11285724*h1.z + 0.23592609*i1.z;
    p = -0.022924347*a1.w + 0.08029266*b1.w + 0.1295117*c1.w + 0.27471703*d1.w + 0.21181649*e1.w + 0.26830688*f1.w + -0.011267695*g1.w + 0.13833974*h1.w + -0.22575748*i1.w;
    q = 0.06332978*na0.x + 0.19778712*nb0.x + -0.14630173*nc0.x + 0.2022106*nd0.x + -0.043443214*ne0.x + 0.013244423*nf0.x + -0.029920608*ng0.x + 0.15498282*nh0.x + -0.008860152*ni0.x;
    r = -0.071186095*na0.y + -0.0046415976*nb0.y + 0.09588473*nc0.y + -0.054782644*nd0.y + -0.30131996*ne0.y + 0.09571458*nf0.y + -0.11756927*ng0.y + -0.25668737*nh0.y + 0.029054785*ni0.y;
    s = 0.010182304*na0.z + -0.17348135*nb0.z + 0.046391185*nc0.z + -0.15667062*nd0.z + -0.16666505*ne0.z + 0.16067432*nf0.z + -0.1326823*ng0.z + 0.21085083*nh0.z + 0.1455272*ni0.z;
    t = 0.058360394*na0.w + 0.053739175*nb0.w + 0.08894498*nc0.w + -0.281138*nd0.w + -0.1887361*ne0.w + 0.12640464*nf0.w + -0.04298481*ng0.w + -0.24676816*nh0.w + 0.05571448*ni0.w;
    u = 0.16053072*na1.x + 0.32601315*nb1.x + 0.095457345*nc1.x + 0.19869359*nd1.x + 0.0041162316*ne1.x + -0.0006917916*nf1.x + 0.28368276*ng1.x + -0.091511145*nh1.x + -0.03113108*ni1.x;
    v = -0.04926926*na1.y + -0.13931896*nb1.y + -0.21816307*nc1.y + 0.112340935*nd1.y + -0.14673282*ne1.y + -0.059623435*nf1.y + 0.070587724*ng1.y + 0.008949842*nh1.y + -0.027426368*ni1.y;
    w = 0.109189294*na1.z + -0.009112803*nb1.z + -0.017429749*nc1.z + -0.06363286*nd1.z + -0.19273286*ne1.z + 0.043292988*nf1.z + -0.034082536*ng1.z + 0.20947897*nh1.z + 0.055061273*ni1.z;
    x = -0.08175211*na1.w + -0.019585626*nb1.w + -0.051631507*nc1.w + -0.39735416*nd1.w + 0.1588689*ne1.w + -0.073861524*nf1.w + 0.18975042*ng1.w + -0.1963924*nh1.w + 0.035963826*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0140123125;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN40
//!BIND LUMAN41
//!SAVE LUMAN50

#define L0_tex LUMAN40_tex
#define L1_tex LUMAN41_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.035612535*a0.x + 0.04017731*b0.x + 0.20536023*c0.x + 0.06875523*d0.x + -0.031420883*e0.x + 0.42573005*f0.x + 0.061643112*g0.x + 0.18023333*h0.x + 0.5605257*i0.x;
    float j = 0.01814264*a0.y + 0.016944267*b0.y + 0.1220235*c0.y + 0.16802199*d0.y + 0.10004153*e0.y + -0.012133044*f0.y + 0.07105161*g0.y + 0.12237441*h0.y + 0.004510387*i0.y;
    float k = 0.004186747*a0.z + -0.12970294*b0.z + 0.0044008605*c0.z + 0.03908641*d0.z + -0.18611148*e0.z + 0.00087365374*f0.z + 0.11857353*g0.z + 0.027568813*h0.z + 0.05604513*i0.z;
    float l = -0.028001549*a0.w + 0.11514266*b0.w + -0.07945613*c0.w + -0.15281484*d0.w + 0.13567261*e0.w + -0.014678198*f0.w + 0.059029147*g0.w + 0.0054495637*h0.w + -0.025024548*i0.w;
    float m = -0.011409999*a1.x + -0.015341942*b1.x + 0.114741184*c1.x + 0.012083291*d1.x + 0.08023752*e1.x + 0.34920374*f1.x + -0.047863945*g1.x + 0.2432634*h1.x + -0.090446465*i1.x;
    float n = -0.08555583*a1.y + -0.0007628947*b1.y + 0.07811802*c1.y + -0.10136344*d1.y + -0.03125326*e1.y + -0.0033468457*f1.y + -0.08859198*g1.y + -0.021236353*h1.y + 0.044894487*i1.y;
    float o = -0.022154905*a1.z + 0.0154149085*b1.z + 0.02057002*c1.z + 0.069081895*d1.z + 0.08480116*e1.z + 0.013921394*f1.z + -0.02094114*g1.z + 0.00068823615*h1.z + -0.12001934*i1.z;
    float p = -0.028961627*a1.w + 0.051715665*b1.w + -0.03176729*c1.w + -0.1386012*d1.w + 0.106838785*e1.w + -0.10906675*f1.w + 0.027086709*g1.w + -0.12217284*h1.w + -0.040965617*i1.w;
    float q = 0.059872124*na0.x + 0.14022045*nb0.x + 0.02607862*nc0.x + -0.21362531*nd0.x + -0.08310274*ne0.x + 0.11169541*nf0.x + -0.12575342*ng0.x + -0.3680999*nh0.x + -0.070986785*ni0.x;
    float r = 0.048685316*na0.y + 0.007329649*nb0.y + -0.16210833*nc0.y + -0.2781075*nd0.y + -0.3511886*ne0.y + -0.029574253*nf0.y + -0.12877542*ng0.y + -0.075404786*nh0.y + -0.0987583*ni0.y;
    float s = -0.018988824*na0.z + 0.2942867*nb0.z + 0.042009376*nc0.z + -0.22772476*nd0.z + 0.0050454373*ne0.z + -0.068424255*nf0.z + -0.04001246*ng0.z + -0.022675836*nh0.z + 0.034189373*ni0.z;
    float t = -0.045849156*na0.w + -0.068379305*nb0.w + 0.16441053*nc0.w + -0.0360953*nd0.w + -0.018031951*ne0.w + 0.089194946*nf0.w + -0.05944052*ng0.w + 0.039005104*nh0.w + 0.0449217*ni0.w;
    float u = -0.08554041*na1.x + -0.10273593*nb1.x + -0.05450196*nc1.x + -0.0049457126*nd1.x + -0.24735165*ne1.x + -0.033856906*nf1.x + -0.04789079*ng1.x + -0.124637336*nh1.x + 0.028094016*ni1.x;
    float v = 0.010685325*na1.y + 0.075002894*nb1.y + -0.07482232*nc1.y + 0.08389421*nd1.y + -0.031178487*ne1.y + -0.000977765*nf1.y + 0.12105572*ng1.y + 0.16234533*nh1.y + 0.109915555*ni1.y;
    float w = 0.009669741*na1.z + -0.01547055*nb1.z + -0.15011303*nc1.z + -0.100489765*nd1.z + -0.12212056*ne1.z + 0.023505995*nf1.z + 0.045761496*ng1.z + 0.0017781933*nh1.z + 0.015155669*ni1.z;
    float x = -0.001148341*na1.w + -0.21386683*nb1.w + -0.013807217*nc1.w + 0.120531775*nd1.w + -0.07378633*ne1.w + 0.10549616*nf1.w + -0.028720537*ng1.w + 0.04982669*nh1.w + -0.09549333*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013112524;
    i = -0.008850011*a0.x + -0.053074952*b0.x + 0.2744104*c0.x + 0.02612702*d0.x + -0.15895297*e0.x + 0.09991879*f0.x + 0.20669703*g0.x + 0.15539402*h0.x + -0.05046773*i0.x;
    j = -0.046442796*a0.y + -0.07005078*b0.y + -0.042570863*c0.y + 0.08206181*d0.y + 0.3786237*e0.y + -0.019612692*f0.y + 0.08563863*g0.y + 0.13863519*h0.y + 0.20874031*i0.y;
    k = 0.039513156*a0.z + -0.21471843*b0.z + 0.03774025*c0.z + -0.07815786*d0.z + 0.008676453*e0.z + -0.017183626*f0.z + -0.09989854*g0.z + -0.12806281*h0.z + 0.03840211*i0.z;
    l = 0.029019121*a0.w + -0.1129284*b0.w + 0.01011583*c0.w + -0.12016837*d0.w + 0.007712074*e0.w + 0.016819015*f0.w + 0.07030448*g0.w + -0.033610865*h0.w + -0.0459375*i0.w;
    m = -0.04275781*a1.x + -0.018200489*b1.x + -0.10315262*c1.x + 0.06556069*d1.x + 0.14088795*e1.x + -0.23484154*f1.x + -0.12515117*g1.x + -0.06998259*h1.x + 0.07224344*i1.x;
    n = 0.017037492*a1.y + 0.06304942*b1.y + -0.016848698*c1.y + -0.06799698*d1.y + -0.3415319*e1.y + 0.02610139*f1.y + -0.1217599*g1.y + -0.053102333*h1.y + 0.011076662*i1.y;
    o = -0.02913676*a1.z + -0.012321229*b1.z + -0.017936712*c1.z + -0.09636114*d1.z + -0.13355324*e1.z + 0.09698391*f1.z + -0.06536401*g1.z + -0.045358505*h1.z + -0.04125653*i1.z;
    p = -0.031567413*a1.w + -0.12853059*b1.w + -0.03921569*c1.w + 0.074788004*d1.w + 0.14571433*e1.w + -0.00066722726*f1.w + -0.016363356*g1.w + -0.01901327*h1.w + -0.1046701*i1.w;
    q = -0.0009567858*na0.x + -0.041390944*nb0.x + 0.010207388*nc0.x + 0.11404937*nd0.x + -0.23463163*ne0.x + -0.023602346*nf0.x + -0.15303922*ng0.x + -0.009046193*nh0.x + 0.08103048*ni0.x;
    r = 0.017589236*na0.y + 0.15609305*nb0.y + 0.045721974*nc0.y + -0.13058934*nd0.y + -0.2679451*ne0.y + 0.011950594*nf0.y + -0.22449987*ng0.y + -0.1917914*nh0.y + -0.11365412*ni0.y;
    s = 0.19348381*na0.z + 0.24570563*nb0.z + 0.019962208*nc0.z + 0.0014589598*nd0.z + 0.07886757*ne0.z + 0.14932665*nf0.z + 0.16708276*ng0.z + 0.18550636*nh0.z + -0.0067473818*ni0.z;
    t = -0.0065101734*na0.w + -0.040736493*nb0.w + -0.041270405*nc0.w + 0.07618738*nd0.w + 0.0218949*ne0.w + -0.04766936*nf0.w + 0.09532495*ng0.w + 0.10562779*nh0.w + 0.07444872*ni0.w;
    u = -0.051368568*na1.x + -0.15848117*nb1.x + -0.18546471*nc1.x + -0.12092587*nd1.x + -0.05082287*ne1.x + -0.08485216*nf1.x + 0.03221051*ng1.x + -0.05053332*nh1.x + -0.09860819*ni1.x;
    v = 0.029384093*na1.y + -0.06750876*nb1.y + 0.018348627*nc1.y + 0.08856726*nd1.y + 0.4350653*ne1.y + 0.06356879*nf1.y + 0.08271615*ng1.y + 0.008104969*nh1.y + -0.018670512*ni1.y;
    w = -0.011343069*na1.z + -0.11651827*nb1.z + -0.08994046*nc1.z + -0.06221274*nd1.z + -0.037247933*ne1.z + -0.14539322*nf1.z + 0.021901105*ng1.z + 0.005052073*nh1.z + 0.10261775*ni1.z;
    x = 0.002017023*na1.w + 0.07701929*nb1.w + -0.06421878*nc1.w + -0.11461471*nd1.w + 0.09813192*ne1.w + -0.09010211*nf1.w + -0.14889443*ng1.w + 0.049384467*nh1.w + 0.12307971*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.042553633;
    i = 0.09314597*a0.x + 0.13171728*b0.x + 0.19819239*c0.x + -0.12970911*d0.x + 0.29927254*e0.x + 0.21767391*f0.x + 0.17249553*g0.x + 0.25350404*h0.x + 0.4911293*i0.x;
    j = 0.118306145*a0.y + -0.0047325366*b0.y + 0.06604017*c0.y + -0.07435545*d0.y + -0.21104847*e0.y + 0.120903485*f0.y + 0.007448092*g0.y + 0.02675702*h0.y + -0.018381957*i0.y;
    k = 0.11446292*a0.z + 0.045590237*b0.z + 0.18081953*c0.z + -0.17427047*d0.z + -0.35203543*e0.z + 0.02689046*f0.z + 0.009454167*g0.z + 0.12534736*h0.z + 0.035864905*i0.z;
    l = -0.13871336*a0.w + 0.000110143475*b0.w + 0.016679386*c0.w + -0.008853473*d0.w + 0.03879449*e0.w + -0.039120965*f0.w + -0.09930874*g0.w + -0.1000116*h0.w + 0.09242047*i0.w;
    m = -0.044360902*a1.x + 0.08391946*b1.x + 0.11027122*c1.x + 0.0073652584*d1.x + 0.09692701*e1.x + 0.2119457*f1.x + 0.036328424*g1.x + -0.019593457*h1.x + -0.107490614*i1.x;
    n = -0.0125782965*a1.y + 0.20825994*b1.y + 0.23127447*c1.y + 0.0072191535*d1.y + 0.1447853*e1.y + 0.15627444*f1.y + -0.07684372*g1.y + 0.19135267*h1.y + -0.06037572*i1.y;
    o = -0.029698756*a1.z + 0.053750448*b1.z + 0.06339778*c1.z + -0.030724516*d1.z + 0.043275952*e1.z + 0.18226287*f1.z + -0.006794373*g1.z + 0.072466105*h1.z + -0.024686977*i1.z;
    p = -0.056785114*a1.w + -0.103406094*b1.w + -0.20727181*c1.w + -0.039523434*d1.w + -0.17240427*e1.w + -0.19204095*f1.w + -0.10694597*g1.w + -0.2649955*h1.w + -0.06132428*i1.w;
    q = 0.0039332574*na0.x + 0.05026292*nb0.x + 0.046305656*nc0.x + 0.18708026*nd0.x + -0.28327677*ne0.x + 0.070439406*nf0.x + -0.18838173*ng0.x + -0.09740024*nh0.x + 0.13081598*ni0.x;
    r = 0.09294847*na0.y + 0.35245818*nb0.y + 0.061874304*nc0.y + -0.13571835*nd0.y + 0.09223242*ne0.y + 0.004823584*nf0.y + -0.048575934*ng0.y + -0.08550897*nh0.y + -0.18647256*ni0.y;
    s = 0.0587695*na0.z + 0.19384533*nb0.z + -0.09999857*nc0.z + 0.050346695*nd0.z + -0.07080002*ne0.z + -0.020419646*nf0.z + -0.08622975*ng0.z + -0.22737212*nh0.z + -0.012951568*ni0.z;
    t = 0.24028173*na0.w + 0.057572372*nb0.w + 0.12549803*nc0.w + 0.010931657*nd0.w + 0.3212349*ne0.w + 0.20082182*nf0.w + 0.054529183*ng0.w + 0.12963445*nh0.w + 0.12043251*ni0.w;
    u = -0.105689935*na1.x + -0.107305124*nb1.x + -0.15378787*nc1.x + 0.04664972*nd1.x + 0.08102327*ne1.x + -0.20562561*nf1.x + -0.041195456*ng1.x + 0.018099809*nh1.x + -0.040376134*ni1.x;
    v = -0.01487915*na1.y + -0.09081166*nb1.y + -0.13099758*nc1.y + -0.12701605*nd1.y + -0.2193587*ne1.y + -0.016810827*nf1.y + 0.055257153*ng1.y + -0.024633544*nh1.y + 0.09994283*ni1.y;
    w = 0.20626432*na1.z + 0.12838879*nb1.z + -0.14225093*nc1.z + -0.028794078*nd1.z + 0.19917117*ne1.z + 0.044698376*nf1.z + 0.082005724*ng1.z + 0.15631491*nh1.z + 0.12103039*ni1.z;
    x = -0.059040707*na1.w + -0.14747858*nb1.w + -0.037346754*nc1.w + -0.11842503*nd1.w + -0.16885588*ne1.w + 0.06594487*nf1.w + 0.089308925*ng1.w + 0.052808817*nh1.w + -0.08821508*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.029102776;
    i = -0.11209577*a0.x + 0.14418902*b0.x + 0.07912491*c0.x + -0.02995134*d0.x + 0.07840223*e0.x + 0.120897666*f0.x + -0.1381869*g0.x + -0.15199783*h0.x + -0.0057939785*i0.x;
    j = 0.038522664*a0.y + -0.04430634*b0.y + 0.014930398*c0.y + -0.078924544*d0.y + 0.032821495*e0.y + -0.15034387*f0.y + 0.09948224*g0.y + 0.046257578*h0.y + 0.03698673*i0.y;
    k = 0.021408146*a0.z + 0.17502472*b0.z + 0.022271572*c0.z + -0.00613615*d0.z + 0.08999399*e0.z + 0.010229765*f0.z + 0.11082286*g0.z + 0.14384252*h0.z + -0.009855277*i0.z;
    l = 0.06253465*a0.w + 0.073090926*b0.w + 0.07494987*c0.w + 0.037831865*d0.w + 0.3061816*e0.w + 0.17264585*f0.w + -0.0014333117*g0.w + 0.07528909*h0.w + -0.071264625*i0.w;
    m = -0.05418183*a1.x + -0.11523262*b1.x + -0.06851412*c1.x + 0.01028219*d1.x + -0.4530031*e1.x + 0.12992333*f1.x + -0.14678968*g1.x + -0.065828115*h1.x + 0.06610601*i1.x;
    n = 0.007039626*a1.y + -0.04067319*b1.y + 0.039445095*c1.y + -0.043049503*d1.y + 0.098197125*e1.y + -0.16465133*f1.y + -0.03092959*g1.y + 0.0021357106*h1.y + 0.062050033*i1.y;
    o = 0.06942289*a1.z + 0.1167464*b1.z + -0.016325492*c1.z + 0.0014870387*d1.z + 0.08062883*e1.z + -0.03982079*f1.z + -0.04291324*g1.z + -0.0065602884*h1.z + -0.10709311*i1.z;
    p = 0.033238105*a1.w + -0.03832345*b1.w + 0.07635184*c1.w + -0.0098485*d1.w + -0.0005796845*e1.w + 0.021684904*f1.w + -0.09704172*g1.w + -0.054971114*h1.w + -0.01928706*i1.w;
    q = -0.12458046*na0.x + 0.06652665*nb0.x + 0.060793605*nc0.x + -0.20750596*nd0.x + -0.07342202*ne0.x + 0.20712708*nf0.x + 0.0987297*ng0.x + -0.11710979*nh0.x + 0.017415684*ni0.x;
    r = 0.055106472*na0.y + 0.27876937*nb0.y + 0.016087595*nc0.y + -0.0055158874*nd0.y + -0.021120023*ne0.y + 0.032101106*nf0.y + 0.094017655*ng0.y + 0.022162251*nh0.y + -0.04368556*ni0.y;
    s = -0.13121118*na0.z + -0.047029372*nb0.z + -0.06184597*nc0.z + -0.09755456*nd0.z + -0.28179955*ne0.z + 0.003410392*nf0.z + -0.10697052*ng0.z + -0.11528157*nh0.z + 0.013775394*ni0.z;
    t = -0.083358206*na0.w + 0.03872297*nb0.w + -0.041483015*nc0.w + -0.13377745*nd0.w + -0.22119187*ne0.w + -0.09595053*nf0.w + -0.006479464*ng0.w + -0.05508277*nh0.w + 0.08092169*ni0.w;
    u = -0.0037866305*na1.x + -0.066144735*nb1.x + 0.1064194*nc1.x + 0.07637622*nd1.x + 0.31042975*ne1.x + 0.29661596*nf1.x + 0.045302957*ng1.x + 0.0042874413*nh1.x + -0.07085192*ni1.x;
    v = -0.04648092*na1.y + 0.035114635*nb1.y + -0.02674536*nc1.y + 0.039049216*nd1.y + -0.14902431*ne1.y + 0.11379347*nf1.y + -0.07022612*ng1.y + 0.11715015*nh1.y + 0.04028414*ni1.y;
    w = -0.015916107*na1.z + 0.051527347*nb1.z + -0.011901495*nc1.z + -0.006465481*nd1.z + 0.06552145*ne1.z + 0.04144042*nf1.z + -0.006796157*ng1.z + 0.025898159*nh1.z + -0.0007850506*ni1.z;
    x = 0.011756395*na1.w + -0.07946773*nb1.w + -0.045221303*nc1.w + 0.0052964273*nd1.w + -0.22804372*ne1.w + -0.1162836*nf1.w + -0.012282788*ng1.w + -0.06438151*nh1.w + -0.057280466*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0026127724;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN40
//!BIND LUMAN41
//!SAVE LUMAN51

#define L0_tex LUMAN40_tex
#define L1_tex LUMAN41_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.058341313*a0.x + -0.21506369*b0.x + 0.01969202*c0.x + -0.0054663033*d0.x + -0.40020138*e0.x + 0.1285723*f0.x + 0.027146779*g0.x + -0.29534942*h0.x + -0.065372*i0.x;
    float j = 0.026859052*a0.y + -0.07099255*b0.y + -0.0399993*c0.y + 0.11942047*d0.y + 0.34605628*e0.y + 0.05976046*f0.y + 0.055970136*g0.y + -0.004091986*h0.y + -0.16493514*i0.y;
    float k = -0.07908727*a0.z + 0.04415421*b0.z + -0.15355754*c0.z + 0.1129772*d0.z + 0.33453822*e0.z + -0.14832681*f0.z + 0.082989015*g0.z + 0.071731575*h0.z + 0.18906988*i0.z;
    float l = -0.09066858*a0.w + -0.11348159*b0.w + -0.0021799193*c0.w + 0.0013052556*d0.w + 0.06459756*e0.w + -0.03326646*f0.w + 0.035330385*g0.w + -0.14535238*h0.w + 0.12517998*i0.w;
    float m = -0.009239749*a1.x + -0.045440555*b1.x + 0.07250618*c1.x + 0.023130517*d1.x + 0.10688969*e1.x + 0.10387453*f1.x + -0.09824478*g1.x + 0.016347708*h1.x + -0.057189398*i1.x;
    float n = -0.055576593*a1.y + 0.054272186*b1.y + 0.004727247*c1.y + -0.06652871*d1.y + -0.16520706*e1.y + -0.16452906*f1.y + -0.09373078*g1.y + 0.11094564*h1.y + 0.049136963*i1.y;
    float o = -0.025956787*a1.z + -0.096835725*b1.z + 0.037478585*c1.z + -0.05188841*d1.z + -0.106625505*e1.z + -0.11583477*f1.z + -0.020436885*g1.z + -0.031691026*h1.z + -0.07146676*i1.z;
    float p = 0.07959005*a1.w + 0.029714286*b1.w + 0.08986918*c1.w + 0.1256378*d1.w + 0.25168374*e1.w + 0.09286637*f1.w + 0.075563334*g1.w + -0.030476464*h1.w + 0.0834733*i1.w;
    float q = 0.08110389*na0.x + -0.0055321003*nb0.x + -0.011466603*nc0.x + -0.076089986*nd0.x + 0.24084151*ne0.x + -0.09002664*nf0.x + -0.07916691*ng0.x + -0.057236582*nh0.x + 0.015564612*ni0.x;
    float r = -0.08872573*na0.y + -0.05498289*nb0.y + 0.031930678*nc0.y + -0.17136955*nd0.y + -0.35136038*ne0.y + -0.2618554*nf0.y + 0.018345961*ng0.y + 0.022003971*nh0.y + 0.042457905*ni0.y;
    float s = 0.028178586*na0.z + 0.060931925*nb0.z + 0.06884443*nc0.z + 0.03218537*nd0.z + -0.258666*ne0.z + 0.1666093*nf0.z + -0.011844073*ng0.z + 0.015975356*nh0.z + -0.087677285*ni0.z;
    float t = 0.08933054*na0.w + 0.16106002*nb0.w + -0.06288805*nc0.w + -0.054834746*nd0.w + -0.18805434*ne0.w + -0.047614172*nf0.w + -0.12941436*ng0.w + 0.03589237*nh0.w + -0.18264498*ni0.w;
    float u = 0.0130687915*na1.x + 0.0151407365*nb1.x + 0.07099842*nc1.x + 0.024692902*nd1.x + -0.15270196*ne1.x + 0.11206766*nf1.x + 0.12255809*ng1.x + 0.060980264*nh1.x + 0.035168886*ni1.x;
    float v = 0.08796369*na1.y + -0.05019335*nb1.y + -0.00079465396*nc1.y + 0.23707964*nd1.y + 0.056615967*ne1.y + 0.13510074*nf1.y + 0.06192575*ng1.y + 0.0559245*nh1.y + -0.02031479*ni1.y;
    float w = -0.07471332*na1.z + 0.061358225*nb1.z + -0.034596812*nc1.z + -0.032788627*nd1.z + -0.08333219*ne1.z + -0.10440432*nf1.z + -0.03931595*ng1.z + -0.049613044*nh1.z + -0.053474206*ni1.z;
    float x = -0.022343067*na1.w + -0.13285586*nb1.w + 0.024529492*nc1.w + -0.17635131*nd1.w + -0.2814951*ne1.w + -0.041839745*nf1.w + -0.036626995*ng1.w + 0.076569855*nh1.w + 0.040817678*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.009945548;
    i = 0.0736856*a0.x + -0.0032100477*b0.x + 0.1492096*c0.x + 0.077228*d0.x + 0.26272488*e0.x + 0.057036564*f0.x + -0.05616672*g0.x + 0.17332815*h0.x + 0.035774574*i0.x;
    j = -0.05845697*a0.y + 0.1549392*b0.y + 0.023617486*c0.y + 0.04493254*d0.y + -0.15356177*e0.y + 0.004977352*f0.y + -0.108943984*g0.y + 0.17687424*h0.y + -0.054177612*i0.y;
    k = 0.0759221*a0.z + 0.15608083*b0.z + 0.12887464*c0.z + -0.018616863*d0.z + -0.23259711*e0.z + 0.06419663*f0.z + -0.005241023*g0.z + -0.051844392*h0.z + 0.10750178*i0.z;
    l = 0.0036690442*a0.w + 0.05987606*b0.w + 0.07125578*c0.w + -0.13141707*d0.w + 0.02256273*e0.w + -0.020214377*f0.w + 0.007948303*g0.w + -0.079753816*h0.w + 0.07354992*i0.w;
    m = 0.051859725*a1.x + -0.034709375*b1.x + -0.029387208*c1.x + -0.026496835*d1.x + -0.07617418*e1.x + 0.1247166*f1.x + -0.022847766*g1.x + -0.022378957*h1.x + 0.0007826007*i1.x;
    n = -0.01812967*a1.y + 0.030523093*b1.y + 0.0023419647*c1.y + 0.15735936*d1.y + 0.0825415*e1.y + 0.07909621*f1.y + 0.13551788*g1.y + 0.010991528*h1.y + 0.029551538*i1.y;
    o = 0.03864655*a1.z + 0.07395166*b1.z + 0.06528245*c1.z + 0.04649426*d1.z + 0.15720278*e1.z + 0.06673369*f1.z + 0.012719491*g1.z + 0.0075968713*h1.z + -0.033163235*i1.z;
    p = -0.06660658*a1.w + -0.09621747*b1.w + -0.053015623*c1.w + -0.10868584*d1.w + -0.03617085*e1.w + -0.11382697*f1.w + -0.025376456*g1.w + -0.1425686*h1.w + -0.08685108*i1.w;
    q = -0.026217438*na0.x + 0.15754505*nb0.x + -0.0091019645*nc0.x + -0.014831991*nd0.x + 0.16862741*ne0.x + 0.051979672*nf0.x + 0.12961973*ng0.x + 0.08616495*nh0.x + 0.08113077*ni0.x;
    r = 0.089784846*na0.y + -0.059764784*nb0.y + 0.0643469*nc0.y + 0.07526015*nd0.y + 0.06560973*ne0.y + 0.031762443*nf0.y + 0.0008978316*ng0.y + -0.07231055*nh0.y + -0.01281584*ni0.y;
    s = -0.08091763*na0.z + -0.054681346*nb0.z + -0.05769879*nc0.z + -0.06746802*nd0.z + 0.10993811*ne0.z + -0.072969966*nf0.z + -0.01040533*ng0.z + -0.03965281*nh0.z + -0.11912891*ni0.z;
    t = 0.014088187*na0.w + -0.019559423*nb0.w + 0.038119223*nc0.w + 0.1502782*nd0.w + 0.16802892*ne0.w + 0.08819164*nf0.w + 0.04723983*ng0.w + 0.06890399*nh0.w + 0.034448624*ni0.w;
    u = -0.0858311*na1.x + -0.058720604*nb1.x + -0.035645936*nc1.x + 0.019476032*nd1.x + 0.05014742*ne1.x + -0.07904676*nf1.x + -0.068997994*ng1.x + -0.026701262*nh1.x + -0.0018194377*ni1.x;
    v = -0.023095097*na1.y + 0.023309603*nb1.y + 0.008035192*nc1.y + -0.14357762*nd1.y + -0.07056337*ne1.y + -0.04978034*nf1.y + -0.011420839*ng1.y + -0.10852049*nh1.y + 0.0003215605*ni1.y;
    w = 0.04865363*na1.z + 0.054601*nb1.z + -0.04116284*nc1.z + 0.027501578*nd1.z + -0.055441584*ne1.z + -0.03507437*nf1.z + 0.001497289*ng1.z + 0.06957507*nh1.z + 0.10106299*ni1.z;
    x = 0.06623774*na1.w + -0.0014704927*nb1.w + -0.013376718*nc1.w + 0.1173909*nd1.w + -0.153007*ne1.w + 0.038331937*nf1.w + 0.0053380616*ng1.w + 0.23239858*nh1.w + -0.035740767*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.026452431;
    i = -0.019092122*a0.x + -0.09086277*b0.x + 0.23840043*c0.x + -0.0072265393*d0.x + 0.028365666*e0.x + 0.04606777*f0.x + 0.28634426*g0.x + 0.13639422*h0.x + 0.15366435*i0.x;
    j = 0.01497688*a0.y + 0.051576726*b0.y + 0.012609459*c0.y + -0.003204774*d0.y + 0.07865389*e0.y + -0.043380044*f0.y + -0.022966493*g0.y + 0.060422853*h0.y + -0.13592103*i0.y;
    k = -0.019054832*a0.z + -0.12396902*b0.z + 0.06679998*c0.z + 0.015159906*d0.z + -0.17882915*e0.z + -0.013451344*f0.z + -0.037844297*g0.z + 0.044634007*h0.z + 0.09841763*i0.z;
    l = 0.1242496*a0.w + 0.14570023*b0.w + -0.0536087*c0.w + 0.0058937743*d0.w + -0.18741275*e0.w + -0.05405417*f0.w + 0.11184961*g0.w + -0.06134286*h0.w + 0.09723279*i0.w;
    m = -0.039362982*a1.x + -0.079569794*b1.x + 0.09229459*c1.x + 0.12174467*d1.x + -0.26060775*e1.x + 0.045963716*f1.x + -0.048531428*g1.x + -0.009784208*h1.x + -0.08540155*i1.x;
    n = -0.042776912*a1.y + 0.05803079*b1.y + 0.0009079167*c1.y + -0.10837513*d1.y + 0.03783227*e1.y + 0.03751572*f1.y + -0.11406614*g1.y + 0.059730146*h1.y + 0.07586286*i1.y;
    o = -0.037720762*a1.z + -0.0010612243*b1.z + 0.10598368*c1.z + -0.054114938*d1.z + -0.31531176*e1.z + 0.008115098*f1.z + 0.014513204*g1.z + -0.020305524*h1.z + -0.0532531*i1.z;
    p = -0.0015348935*a1.w + -0.0136528*b1.w + -0.049160857*c1.w + -0.01870342*d1.w + 0.04801573*e1.w + -0.003977191*f1.w + 0.015746452*g1.w + -0.12886392*h1.w + 0.024754394*i1.w;
    q = 0.007092857*na0.x + -0.08710648*nb0.x + 0.015883893*nc0.x + 0.15110812*nd0.x + -0.5903739*ne0.x + 0.117669456*nf0.x + -0.18934238*ng0.x + -0.21404389*nh0.x + 0.11136142*ni0.x;
    r = -0.25414848*na0.y + -0.17851315*nb0.y + 0.052724008*nc0.y + -0.29529995*nd0.y + -0.0861469*ne0.y + -0.0726801*nf0.y + -0.056918535*ng0.y + -0.09571194*nh0.y + -0.008321754*ni0.y;
    s = -0.054942016*na0.z + 0.056283783*nb0.z + -0.10146946*nc0.z + -0.20149462*nd0.z + 0.2615956*ne0.z + -0.060734283*nf0.z + 0.072493576*ng0.z + 0.013873488*nh0.z + -0.05927832*ni0.z;
    t = -0.02162006*na0.w + -0.13530779*nb0.w + 0.015482059*nc0.w + -0.0032522178*nd0.w + 0.21423261*ne0.w + 0.0285138*nf0.w + -0.13833298*ng0.w + 0.11485339*nh0.w + -0.070087075*ni0.w;
    u = 0.0038275998*na1.x + 0.13350129*nb1.x + -0.112879656*nc1.x + 0.01186888*nd1.x + 0.6276104*ne1.x + -0.12892282*nf1.x + 0.013344215*ng1.x + 0.10528361*nh1.x + 0.13124417*ni1.x;
    v = 0.055806052*na1.y + -0.06348023*nb1.y + 0.02085426*nc1.y + 0.08150835*nd1.y + -0.1556977*ne1.y + 0.029980408*nf1.y + 0.052578572*ng1.y + -0.022157064*nh1.y + -0.002322045*ni1.y;
    w = 0.012891871*na1.z + -0.022318032*nb1.z + -0.13572417*nc1.z + -0.06485001*nd1.z + 0.16181162*ne1.z + -0.06267603*nf1.z + 0.0011934403*ng1.z + 0.070938624*nh1.z + 0.01252789*ni1.z;
    x = 0.026072396*na1.w + -0.010732958*nb1.w + 0.046689223*nc1.w + -0.13713975*nd1.w + 0.1539983*ne1.w + -0.054844245*nf1.w + -0.08702756*ng1.w + 0.05541185*nh1.w + -0.030015115*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.001493891;
    i = -0.2029684*a0.x + -0.5433984*b0.x + -0.3404616*c0.x + 0.052867394*d0.x + -0.3473272*e0.x + -0.15649731*f0.x + -0.23871002*g0.x + -0.1109204*h0.x + -0.22829787*i0.x;
    j = 0.044766348*a0.y + 0.0075613745*b0.y + -0.24642573*c0.y + 0.06352247*d0.y + -0.08041809*e0.y + -0.03975498*f0.y + -0.075066246*g0.y + -0.071659416*h0.y + -0.15419307*i0.y;
    k = 0.13883616*a0.z + 0.38315442*b0.z + -0.07305248*c0.z + 0.11842109*d0.z + -0.12933512*e0.z + -0.06339081*f0.z + -0.061098322*g0.z + -0.011412765*h0.z + 0.021311197*i0.z;
    l = -0.107254796*a0.w + 0.1133037*b0.w + 0.09230633*c0.w + 0.15860972*d0.w + 0.048703972*e0.w + -0.04537395*f0.w + 0.111755155*g0.w + 0.18001053*h0.w + -0.04715647*i0.w;
    m = -0.030681103*a1.x + -0.01730047*b1.x + -0.00261708*c1.x + -0.08639173*d1.x + -0.23224998*e1.x + 0.04507707*f1.x + -0.08558757*g1.x + -0.06275244*h1.x + 0.036656402*i1.x;
    n = -0.037630294*a1.y + -0.14100103*b1.y + -0.20430483*c1.y + 0.033603456*d1.y + 0.16065453*e1.y + -0.0001391955*f1.y + 0.18134886*g1.y + -0.14686634*h1.y + 0.041554898*i1.y;
    o = -0.10045714*a1.z + -0.192881*b1.z + -0.05901973*c1.z + -0.20419008*d1.z + -0.050205123*e1.z + -0.17184749*f1.z + 0.06792742*g1.z + 0.00396447*h1.z + -0.010734883*i1.z;
    p = 0.06347656*a1.w + 0.055015985*b1.w + 0.1896647*c1.w + 0.1223147*d1.w + 0.391878*e1.w + 0.15969121*f1.w + 0.09271096*g1.w + 0.1580006*h1.w + 0.024834886*i1.w;
    q = 0.18948026*na0.x + -0.0008232371*nb0.x + 0.14355972*nc0.x + 0.420433*nd0.x + -0.30479485*ne0.x + 0.11691138*nf0.x + 0.22751662*ng0.x + -0.06334774*nh0.x + -0.10960608*ni0.x;
    r = -0.10958855*na0.y + -0.104264155*nb0.y + 0.030050436*nc0.y + 0.15551548*nd0.y + -0.103276476*ne0.y + -0.09604516*nf0.y + 0.0502458*ng0.y + 0.18014862*nh0.y + 0.08645385*ni0.y;
    s = 0.004778244*na0.z + -0.15352857*nb0.z + 0.076735005*nc0.z + -0.030288707*nd0.z + 0.32527444*ne0.z + -0.021542786*nf0.z + 0.056891233*ng0.z + 0.029728781*nh0.z + 0.073643975*ni0.z;
    t = -0.10808804*na0.w + -0.020803692*nb0.w + -0.080507904*nc0.w + -0.024862716*nd0.w + -0.4074744*ne0.w + -0.0013651325*nf0.w + -0.038106095*ng0.w + -0.33806917*nh0.w + -0.121994264*ni0.w;
    u = 0.09291953*na1.x + 0.08922977*nb1.x + 0.13398977*nc1.x + 0.1743847*nd1.x + 0.36668244*ne1.x + 0.16027638*nf1.x + 0.10165976*ng1.x + 0.16359653*nh1.x + 0.15654418*ni1.x;
    v = 0.15836778*na1.y + 0.07225184*nb1.y + 0.14402899*nc1.y + -0.058226164*nd1.y + -0.08563047*ne1.y + -0.13314581*nf1.y + -0.23650183*ng1.y + -0.13838924*nh1.y + -0.02972749*ni1.y;
    w = -0.11585181*na1.z + -0.036293514*nb1.z + 0.16113761*nc1.z + 0.1201051*nd1.z + -0.15653205*ne1.z + 0.014206818*nf1.z + -0.035099678*ng1.z + -0.09631885*nh1.z + -0.083426096*ni1.z;
    x = -0.002398999*na1.w + 0.04186464*nb1.w + 0.03738504*nc1.w + -0.1793729*nd1.w + 0.022120971*ne1.w + 0.021679237*nf1.w + -0.036145337*ng1.w + -0.0013587712*nh1.w + -0.04066518*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013275004;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN50
//!BIND LUMAN51
//!SAVE LUMAN60

#define L0_tex LUMAN50_tex
#define L1_tex LUMAN51_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.0023328534*a0.x + 0.064793706*b0.x + 0.13137315*c0.x + -0.08144926*d0.x + 0.10695711*e0.x + -0.0755808*f0.x + 0.03415385*g0.x + -0.08380857*h0.x + 0.07275955*i0.x;
    float j = -0.100906454*a0.y + -0.016975228*b0.y + 0.08030283*c0.y + 0.07125107*d0.y + 0.209759*e0.y + 0.1479306*f0.y + 0.06908754*g0.y + -0.076900385*h0.y + 0.03856468*i0.y;
    float k = -0.046562966*a0.z + 0.09214668*b0.z + 0.035977118*c0.z + 0.109999955*d0.z + 0.11875673*e0.z + -0.020831538*f0.z + 0.13520765*g0.z + 0.08756613*h0.z + 0.014693053*i0.z;
    float l = -0.065421455*a0.w + -0.107463524*b0.w + 0.016045967*c0.w + 0.018637523*d0.w + 0.052398868*e0.w + 0.2073138*f0.w + 0.076807156*g0.w + 0.2412724*h0.w + 0.054381493*i0.w;
    float m = -0.021103308*a1.x + 0.024509076*b1.x + -0.042548016*c1.x + -0.13146673*d1.x + -0.022827815*e1.x + -0.066952296*f1.x + 0.10200906*g1.x + -0.091980994*h1.x + -0.06296656*i1.x;
    float n = 0.2139278*a1.y + 0.22893451*b1.y + 0.09091571*c1.y + 0.04707812*d1.y + 0.33085123*e1.y + 0.25524098*f1.y + 0.18050957*g1.y + 0.11280443*h1.y + 0.013663248*i1.y;
    float o = 0.04662038*a1.z + 0.020816704*b1.z + -0.060241304*c1.z + 0.030631166*d1.z + 0.13896711*e1.z + -0.08040418*f1.z + -0.12400517*g1.z + -0.012480961*h1.z + -0.025484385*i1.z;
    float p = -0.099704094*a1.w + -0.06509334*b1.w + -0.018391868*c1.w + 0.0033737472*d1.w + 0.019923119*e1.w + -0.04522104*f1.w + -0.004225413*g1.w + -0.123058476*h1.w + -0.10244464*i1.w;
    float q = -0.007825052*na0.x + -0.027427772*nb0.x + -0.015301882*nc0.x + 0.1567665*nd0.x + -0.06912613*ne0.x + 0.015112322*nf0.x + 0.12380591*ng0.x + 0.041814685*nh0.x + -0.026952421*ni0.x;
    float r = 0.057297777*na0.y + -0.07565621*nb0.y + -0.0783251*nc0.y + -0.08975966*nd0.y + -0.06767529*ne0.y + -0.14912416*nf0.y + -0.1419718*ng0.y + -0.024593588*nh0.y + -0.057069726*ni0.y;
    float s = 0.16402707*na0.z + 0.123968214*nb0.z + 0.055898797*nc0.z + 0.0049678953*nd0.z + 0.116354525*ne0.z + 0.1302255*nf0.z + -0.13494058*ng0.z + 0.22029555*nh0.z + 0.07076266*ni0.z;
    float t = 0.14263879*na0.w + 0.16390547*nb0.w + 0.13133223*nc0.w + -0.025501277*nd0.w + 0.022351695*ne0.w + -0.0669175*nf0.w + -0.011532269*ng0.w + -0.18873638*nh0.w + -0.087589785*ni0.w;
    float u = -0.07297858*na1.x + -0.15550973*nb1.x + 0.0047679497*nc1.x + -0.035416875*nd1.x + -0.08521186*ne1.x + -0.041888446*nf1.x + -0.0717547*ng1.x + -0.04631239*nh1.x + 0.010076916*ni1.x;
    float v = 0.05423491*na1.y + -0.21764006*nb1.y + -0.107588634*nc1.y + -0.12051383*nd1.y + -0.06299794*ne1.y + -0.05008003*nf1.y + -0.0055367723*ng1.y + 0.016887318*nh1.y + 0.13362682*ni1.y;
    float w = -0.1068631*na1.z + 0.034638334*nb1.z + -0.009606332*nc1.z + -0.09290256*nd1.z + -0.16951458*ne1.z + 0.11512481*nf1.z + 0.058622256*ng1.z + -0.093306124*nh1.z + -0.091385804*ni1.z;
    float x = 0.09943962*na1.w + 0.046493366*nb1.w + -0.010393254*nc1.w + 0.021576924*nd1.w + 0.046211373*ne1.w + -0.023459839*nf1.w + -0.029110817*ng1.w + -0.0026221299*nh1.w + 0.045499146*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0044076787;
    i = 0.046037015*a0.x + -0.20014718*b0.x + -0.050648395*c0.x + 0.14622693*d0.x + 0.04686424*e0.x + 0.115389556*f0.x + -0.09658768*g0.x + 0.113019705*h0.x + -0.08457916*i0.x;
    j = 0.04837194*a0.y + 0.017981997*b0.y + -0.057005353*c0.y + 0.11208802*d0.y + -0.27299806*e0.y + 0.253538*f0.y + 0.1579276*g0.y + 0.18482813*h0.y + -0.0030665721*i0.y;
    k = 0.025618808*a0.z + -0.014753779*b0.z + 0.11424065*c0.z + -0.039130658*d0.z + -0.077596694*e0.z + -0.06189349*f0.z + -0.00055544026*g0.z + -0.0030258696*h0.z + -0.03805638*i0.z;
    l = 0.0396419*a0.w + -0.08394604*b0.w + -0.0958592*c0.w + -0.052551508*d0.w + -0.14271393*e0.w + -0.21775384*f0.w + 0.064173386*g0.w + -0.2541221*h0.w + 0.12580013*i0.w;
    m = -0.062242437*a1.x + -0.05984731*b1.x + 0.07177733*c1.x + -0.0010727174*d1.x + -0.2148164*e1.x + 0.17201327*f1.x + -0.08118757*g1.x + -0.02247559*h1.x + 0.10099783*i1.x;
    n = -0.027749883*a1.y + -0.10161952*b1.y + -0.122889414*c1.y + -0.064740315*d1.y + 0.23500724*e1.y + -0.043876413*f1.y + -0.1109669*g1.y + 0.06332242*h1.y + -0.046353713*i1.y;
    o = -0.0050889878*a1.z + 0.028743066*b1.z + 0.14333661*c1.z + -0.0038749718*d1.z + 0.04225466*e1.z + 0.08372675*f1.z + -0.026901118*g1.z + -0.057206213*h1.z + -0.11625423*i1.z;
    p = 0.06871033*a1.w + -0.036982935*b1.w + 0.008396837*c1.w + 0.049070083*d1.w + 0.16440327*e1.w + 0.028823575*f1.w + 0.015017149*g1.w + 0.047464818*h1.w + 0.15167558*i1.w;
    q = 0.058808442*na0.x + 0.07618759*nb0.x + -0.07531338*nc0.x + -0.21605514*nd0.x + -0.23420495*ne0.x + -0.31268212*nf0.x + -0.051698856*ng0.x + -0.11017567*nh0.x + 0.11262677*ni0.x;
    r = -0.03518726*na0.y + 0.06715704*nb0.y + 0.049414575*nc0.y + -0.03147147*nd0.y + 0.10408503*ne0.y + 0.015476035*nf0.y + -0.09080876*ng0.y + -0.1327499*nh0.y + 0.037832085*ni0.y;
    s = -0.0049664024*na0.z + 0.01783228*nb0.z + -0.09306831*nc0.z + 0.02966074*nd0.z + -0.13659412*ne0.z + 0.103386335*nf0.z + 0.0039585214*ng0.z + -0.10475919*nh0.z + -0.07868313*ni0.z;
    t = -0.027448364*na0.w + 0.049910434*nb0.w + 0.04629656*nc0.w + 0.04606205*nd0.w + -0.08058761*ne0.w + 0.19123064*nf0.w + -0.03994525*ng0.w + 0.07180471*nh0.w + -0.11458842*ni0.w;
    u = 0.08074149*na1.x + 0.16658387*nb1.x + 0.08585271*nc1.x + 0.06220538*nd1.x + 0.025161874*ne1.x + 0.002386364*nf1.x + 0.07634237*ng1.x + 0.014812471*nh1.x + -0.03701967*ni1.x;
    v = -0.0418336*na1.y + -0.056149974*nb1.y + -0.091469795*nc1.y + 0.1307059*nd1.y + -0.37983438*ne1.y + -0.5405711*nf1.y + 0.024360469*ng1.y + 0.21794999*nh1.y + -0.20875533*ni1.y;
    w = -0.02660547*na1.z + -0.13768345*nb1.z + -0.0033622494*nc1.z + -0.022334186*nd1.z + -0.03950232*ne1.z + 0.021272644*nf1.z + 0.028884187*ng1.z + 0.13566218*nh1.z + 0.017871113*ni1.z;
    x = -0.07330508*na1.w + 0.026229024*nb1.w + -0.011504151*nc1.w + -0.019414637*nd1.w + -0.14128768*ne1.w + 0.16297776*nf1.w + 0.069985695*ng1.w + 0.061362997*nh1.w + 0.084847815*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0041278936;
    i = -0.05720563*a0.x + 0.057983294*b0.x + 0.0339593*c0.x + 0.064571634*d0.x + -0.20921943*e0.x + -0.013970842*f0.x + 0.026166726*g0.x + -0.041072275*h0.x + 0.01610475*i0.x;
    j = -0.11969899*a0.y + -0.024872895*b0.y + 0.098103285*c0.y + 0.07863271*d0.y + 0.031222403*e0.y + -0.114472054*f0.y + 0.08776073*g0.y + 0.1264496*h0.y + 0.0402211*i0.y;
    k = -0.030170271*a0.z + 0.0018764718*b0.z + -0.027332861*c0.z + 0.062330324*d0.z + 0.10290415*e0.z + 0.14791936*f0.z + 0.045651324*g0.z + 0.117724515*h0.z + 0.21746355*i0.z;
    l = -0.048120335*a0.w + 0.037827358*b0.w + 0.015677916*c0.w + 0.039548885*d0.w + 0.038568195*e0.w + -0.023876693*f0.w + -0.0026781922*g0.w + -0.12731688*h0.w + -0.089386*i0.w;
    m = -0.050546445*a1.x + 0.04402385*b1.x + -0.01841782*c1.x + -0.17501399*d1.x + -0.1780696*e1.x + -0.1347531*f1.x + -0.013775902*g1.x + 0.15184507*h1.x + 0.067993574*i1.x;
    n = 0.06067288*a1.y + 0.020058522*b1.y + 0.0064884624*c1.y + -0.23260388*d1.y + -0.28992143*e1.y + -0.07061862*f1.y + -0.034785822*g1.y + -0.0793457*h1.y + -0.23899145*i1.y;
    o = 0.022000503*a1.z + -0.071197905*b1.z + -0.049395315*c1.z + -0.0069849472*d1.z + 0.28265312*e1.z + 0.0645686*f1.z + -0.075388685*g1.z + -0.3408368*h1.z + -0.046410777*i1.z;
    p = -0.0073897485*a1.w + -0.0030118083*b1.w + -0.055616233*c1.w + 0.075406134*d1.w + 0.023296187*e1.w + 0.22175246*f1.w + -0.039796658*g1.w + 0.08415068*h1.w + 0.11574001*i1.w;
    q = -0.0464031*na0.x + -0.09764388*nb0.x + -0.08282094*nc0.x + -0.117494546*nd0.x + 0.18278615*ne0.x + 0.060395755*nf0.x + 0.016666938*ng0.x + 0.065874204*nh0.x + -0.05239314*ni0.x;
    r = 0.055310417*na0.y + -0.037919335*nb0.y + 0.005939001*nc0.y + -0.034767736*nd0.y + 0.31564963*ne0.y + -0.072183535*nf0.y + -0.17022869*ng0.y + -0.33137664*nh0.y + -0.124336995*ni0.y;
    s = 0.023502233*na0.z + 0.07160557*nb0.z + 0.096604556*nc0.z + -0.024247825*nd0.z + -0.24521804*ne0.z + -0.14877447*nf0.z + -0.050775077*ng0.z + -0.2936305*nh0.z + -0.15759036*ni0.z;
    t = 0.048754975*na0.w + -0.023362307*nb0.w + -0.009928164*nc0.w + -0.026300179*nd0.w + -0.09734495*ne0.w + -0.06623416*nf0.w + -0.07600827*ng0.w + 0.08001888*nh0.w + 0.05388996*ni0.w;
    u = -0.040832303*na1.x + 0.008556898*nb1.x + 0.0011466276*nc1.x + 0.1837227*nd1.x + 0.2568269*ne1.x + 0.050614744*nf1.x + 0.033623144*ng1.x + -0.08975142*nh1.x + -0.072304465*ni1.x;
    v = -0.031529695*na1.y + -0.08658768*nb1.y + -0.062140666*nc1.y + 0.19025032*nd1.y + 0.21660827*ne1.y + 0.050144237*nf1.y + 0.07365049*ng1.y + 0.26017582*nh1.y + 0.2243008*ni1.y;
    w = 0.03566439*na1.z + 0.1348235*nb1.z + 0.019010197*nc1.z + -0.018993806*nd1.z + -0.28596598*ne1.z + 0.0075408868*nf1.z + 0.09171176*ng1.z + 0.2642931*nh1.z + 0.071677156*ni1.z;
    x = 0.019524738*na1.w + -0.025530815*nb1.w + 0.009337825*nc1.w + -0.077851355*nd1.w + -0.06228772*ne1.w + -0.056282073*nf1.w + 0.09834586*ng1.w + 0.022084989*nh1.w + -0.09770484*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.008795879;
    i = 0.011957833*a0.x + 0.24993116*b0.x + -0.002682511*c0.x + 0.09202492*d0.x + -0.058194473*e0.x + 0.20236294*f0.x + -0.045782674*g0.x + 0.18085079*h0.x + -0.0007733444*i0.x;
    j = 0.06615865*a0.y + 0.06730262*b0.y + -0.15511134*c0.y + -0.056761254*d0.y + 0.16833608*e0.y + 0.29652697*f0.y + 0.07208219*g0.y + 0.12632033*h0.y + 0.08936451*i0.y;
    k = -0.035943326*a0.z + -0.010642242*b0.z + 0.086488046*c0.z + 0.012203811*d0.z + 0.31983772*e0.z + -0.024014914*f0.z + 0.018321209*g0.z + 0.100251*h0.z + 0.13954958*i0.z;
    l = -0.0104503175*a0.w + -0.20468268*b0.w + -0.12733395*c0.w + -0.014340496*d0.w + -0.0012792454*e0.w + -0.105142586*f0.w + -0.03303492*g0.w + -0.012410842*h0.w + 0.01961328*i0.w;
    m = 0.00015735891*a1.x + -0.26152962*b1.x + -0.003443904*c1.x + -0.09770607*d1.x + 0.044304006*e1.x + 0.023186417*f1.x + 0.0044261245*g1.x + -0.07075799*h1.x + -0.056546647*i1.x;
    n = -0.026539521*a1.y + 0.29586637*b1.y + 0.31409112*c1.y + -0.14105357*d1.y + 0.18564008*e1.y + 0.21619162*f1.y + 0.19983022*g1.y + 0.01797262*h1.y + -0.028071435*i1.y;
    o = 0.037473988*a1.z + -0.04496412*b1.z + -0.11825187*c1.z + -0.10086509*d1.z + 0.15808839*e1.z + -0.44962603*f1.z + -0.01843067*g1.z + -0.16569562*h1.z + -0.11665053*i1.z;
    p = -0.036413506*a1.w + 0.10740355*b1.w + -0.06874833*c1.w + -0.04672398*d1.w + 0.16801305*e1.w + -0.04901428*f1.w + -0.025827173*g1.w + -0.04907921*h1.w + 0.11648403*i1.w;
    q = 0.014651736*na0.x + 0.09767451*nb0.x + 0.0364797*nc0.x + 0.031390887*nd0.x + 0.2291563*ne0.x + -0.20164289*nf0.x + 0.06956926*ng0.x + -0.027178623*nh0.x + 0.06383271*ni0.x;
    r = 0.002828036*na0.y + -0.09226963*nb0.y + -0.12876321*nc0.y + -0.109815165*nd0.y + 0.033563435*ne0.y + -0.17216623*nf0.y + -0.06648531*ng0.y + -0.18780257*nh0.y + -0.032364648*ni0.y;
    s = -0.006287264*na0.z + 0.00123886*nb0.z + -0.015670354*nc0.z + 0.019913454*nd0.z + -0.06438532*ne0.z + 0.17462069*nf0.z + 0.004444823*ng0.z + -0.061344486*nh0.z + -0.1289914*ni0.z;
    t = -0.032365125*na0.w + 0.13831198*nb0.w + 0.1960693*nc0.w + -0.12155524*nd0.w + 0.0853176*ne0.w + 0.075043015*nf0.w + -0.0654051*ng0.w + 0.05241946*nh0.w + -0.095316775*ni0.w;
    u = -0.023895213*na1.x + 0.053995147*nb1.x + -0.16778684*nc1.x + 0.14444508*nd1.x + 0.5284899*ne1.x + -0.09535227*nf1.x + 0.07941243*ng1.x + -0.04506495*nh1.x + -0.05838371*ni1.x;
    v = -0.116331026*na1.y + 0.25320458*nb1.y + 0.04314606*nc1.y + -0.055427276*nd1.y + 0.41488975*ne1.y + -0.21635123*nf1.y + -0.09031083*ng1.y + -0.012773467*nh1.y + 0.14210652*ni1.y;
    w = -0.073841624*na1.z + -0.025932856*nb1.z + -0.085170485*nc1.z + -0.04061003*nd1.z + -0.5516947*ne1.z + -0.18175714*nf1.z + -0.091636725*ng1.z + 0.06229114*nh1.z + -0.0422904*ni1.z;
    x = 0.048132446*na1.w + -0.13811083*nb1.w + 0.11206705*nc1.w + 0.03338064*nd1.w + -0.30970797*ne1.w + 0.06381431*nf1.w + -0.0042102467*ng1.w + 0.00956657*nh1.w + 0.011325626*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.03872577;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN50
//!BIND LUMAN51
//!SAVE LUMAN61

#define L0_tex LUMAN50_tex
#define L1_tex LUMAN51_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.033646833*a0.x + 0.10032702*b0.x + 0.07672664*c0.x + -0.15228283*d0.x + 0.14604108*e0.x + -0.009682619*f0.x + -0.017508494*g0.x + -0.20209043*h0.x + -0.0009521017*i0.x;
    float j = -0.010476165*a0.y + 0.033324443*b0.y + 0.14461902*c0.y + 0.06183721*d0.y + 0.15421857*e0.y + -0.12802331*f0.y + 0.027586345*g0.y + 0.0124696875*h0.y + 0.0016373133*i0.y;
    float k = -0.08886994*a0.z + -0.073300235*b0.z + -0.005404674*c0.z + -0.05893552*d0.z + -0.014138546*e0.z + -0.061251454*f0.z + -0.036440812*g0.z + 0.08436395*h0.z + 0.13597581*i0.z;
    float l = 0.03857152*a0.w + 0.011185113*b0.w + 0.0418685*c0.w + -0.12713286*d0.w + -0.12497824*e0.w + 0.12187931*f0.w + 0.01143971*g0.w + 0.1531618*h0.w + -0.005094794*i0.w;
    float m = 0.16493323*a1.x + -0.16790906*b1.x + -0.007424873*c1.x + -0.019737665*d1.x + 0.32541034*e1.x + -0.10551009*f1.x + 0.06748345*g1.x + -0.07619556*h1.x + -0.0016914528*i1.x;
    float n = -0.05048458*a1.y + -0.04336667*b1.y + 0.102540255*c1.y + -0.019675344*d1.y + -0.2230414*e1.y + 0.19778657*f1.y + -0.0056847017*g1.y + -0.1403332*h1.y + -0.021340592*i1.y;
    float o = 0.040324245*a1.z + 0.03067326*b1.z + -0.06488181*c1.z + 0.13678902*d1.z + -0.15534002*e1.z + -0.23447587*f1.z + -0.014251697*g1.z + -0.14344667*h1.z + 0.058199186*i1.z;
    float p = -0.07156001*a1.w + 0.03541768*b1.w + -0.08873371*c1.w + -0.15883322*d1.w + -0.22011177*e1.w + -0.06520788*f1.w + -0.054262646*g1.w + -0.050970685*h1.w + -0.031258497*i1.w;
    float q = 0.04146114*na0.x + 0.080761746*nb0.x + 0.019592429*nc0.x + 0.28116655*nd0.x + 0.096100524*ne0.x + 0.10228331*nf0.x + 0.0628159*ng0.x + 0.14551347*nh0.x + 0.082707345*ni0.x;
    float r = 0.047835153*na0.y + -0.04882955*nb0.y + -0.01197105*nc0.y + 0.06759022*nd0.y + -0.122022025*ne0.y + -0.046007633*nf0.y + -0.09565734*ng0.y + -0.036093384*nh0.y + 0.015027891*ni0.y;
    float s = 0.069905534*na0.z + -0.009022554*nb0.z + 0.058666833*nc0.z + 0.024865663*nd0.z + -0.029687501*ne0.z + 0.05235234*nf0.z + 0.05337345*ng0.z + 0.032454923*nh0.z + -0.097156495*ni0.z;
    float t = 0.023648677*na0.w + -0.11085765*nb0.w + 0.12138889*nc0.w + 0.06495529*nd0.w + 0.24705039*ne0.w + 0.0144702485*nf0.w + -0.037593596*ng0.w + -0.07377362*nh0.w + 0.037110664*ni0.w;
    float u = -0.17177041*na1.x + 0.010452884*nb1.x + -0.005489181*nc1.x + 0.036922168*nd1.x + -0.106774*ne1.x + -0.024845233*nf1.x + 0.050368562*ng1.x + -0.0774007*nh1.x + -0.0862494*ni1.x;
    float v = 0.1375543*na1.y + 0.1324469*nb1.y + 0.085171565*nc1.y + -0.16165945*nd1.y + 0.37410375*ne1.y + 0.13893189*nf1.y + 0.01579091*ng1.y + -0.12340413*nh1.y + 0.2030766*ni1.y;
    float w = 0.0025532034*na1.z + 0.108326204*nb1.z + 0.02649299*nc1.z + -0.06487767*nd1.z + 0.2726464*ne1.z + 0.006244928*nf1.z + 0.014532157*ng1.z + 0.04829693*nh1.z + -0.053479*ni1.z;
    float x = 0.108156756*na1.w + 0.019954557*nb1.w + 0.018787293*nc1.w + 0.17868373*nd1.w + 0.12412388*ne1.w + -0.064045176*nf1.w + -0.01769105*ng1.w + -0.040720694*nh1.w + -0.07799191*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.000862047;
    i = -0.039971568*a0.x + -0.13860865*b0.x + 0.059578743*c0.x + 0.054580357*d0.x + 0.07117097*e0.x + 0.0058385846*f0.x + -0.03902884*g0.x + -0.11318809*h0.x + -0.111597575*i0.x;
    j = -0.086450055*a0.y + -0.124518275*b0.y + 0.020062126*c0.y + -0.20558353*d0.y + -0.45414314*e0.y + -0.082487576*f0.y + -0.1515172*g0.y + 0.12671556*h0.y + 0.016241614*i0.y;
    k = -0.016725514*a0.z + -0.08818584*b0.z + 0.022113374*c0.z + -0.117363*d0.z + -0.20525245*e0.z + -0.14181912*f0.z + -0.07290995*g0.z + 0.11147163*h0.z + -0.07578759*i0.z;
    l = -0.03750765*a0.w + 0.052155647*b0.w + -0.021804612*c0.w + 0.09988333*d0.w + -0.27572292*e0.w + -0.09019871*f0.w + -0.07586278*g0.w + 0.019196762*h0.w + 0.010203965*i0.w;
    m = 0.013703555*a1.x + -0.020751877*b1.x + 0.0775093*c1.x + -0.09004651*d1.x + -0.5128223*e1.x + -0.06329901*f1.x + 0.10937858*g1.x + -0.10808922*h1.x + 0.015974486*i1.x;
    n = -0.09324005*a1.y + -0.16807376*b1.y + -0.10526527*c1.y + -0.010830986*d1.y + -0.010137756*e1.y + 0.10139828*f1.y + -0.10427358*g1.y + -0.116689995*h1.y + 0.15831418*i1.y;
    o = 0.02102471*a1.z + 0.036273964*b1.z + 0.074956045*c1.z + -0.091770366*d1.z + 0.08726741*e1.z + -0.035816178*f1.z + 0.16262427*g1.z + 0.14923644*h1.z + 0.09859584*i1.z;
    p = 0.002302369*a1.w + -0.012979977*b1.w + 0.11320999*c1.w + 0.07696163*d1.w + -0.15911424*e1.w + -0.1044688*f1.w + 0.048823304*g1.w + 0.09324655*h1.w + -0.0752723*i1.w;
    q = -0.017380103*na0.x + -0.025678936*nb0.x + 0.037316386*nc0.x + -0.15647902*nd0.x + -0.23790553*ne0.x + 0.07412572*nf0.x + 0.009013182*ng0.x + -0.084161185*nh0.x + 0.042249765*ni0.x;
    r = 0.086646855*na0.y + 0.18134682*nb0.y + 0.022913635*nc0.y + 0.05691889*nd0.y + 0.22342443*ne0.y + 0.14537199*nf0.y + 0.2649698*ng0.y + 0.17448571*nh0.y + 0.11451624*ni0.y;
    s = -0.1269585*na0.z + -0.03242593*nb0.z + -0.12652342*nc0.z + 0.109687544*nd0.z + 0.037887223*ne0.z + 0.07123706*nf0.z + -0.0202993*ng0.z + -0.17222753*nh0.z + 0.014016666*ni0.z;
    t = -0.069507696*na0.w + -0.15265661*nb0.w + -0.012847912*nc0.w + 0.058244247*nd0.w + 0.14982316*ne0.w + 0.17648475*nf0.w + 0.03054064*ng0.w + 0.04018764*nh0.w + -0.007209293*ni0.w;
    u = 0.058386125*na1.x + 0.11898639*nb1.x + -0.031605452*nc1.x + 0.038302805*nd1.x + 0.08826856*ne1.x + 0.15199856*nf1.x + -0.19690076*ng1.x + -0.0035709224*nh1.x + 0.033497263*ni1.x;
    v = -0.023674052*na1.y + 0.025953926*nb1.y + -0.17001212*nc1.y + 0.16752574*nd1.y + -0.4473576*ne1.y + -0.109902255*nf1.y + 0.06646598*ng1.y + 0.10382671*nh1.y + 0.045195088*ni1.y;
    w = 0.054174628*na1.z + -0.004505771*nb1.z + 0.06162703*nc1.z + 0.18366614*nd1.z + 0.16723797*ne1.z + 0.25134555*nf1.z + -0.07620315*ng1.z + -0.11094397*nh1.z + 0.042937014*ni1.z;
    x = 0.027990157*na1.w + 0.017603736*nb1.w + -0.06902197*nc1.w + -0.06853595*nd1.w + 0.107995*ne1.w + -0.043075144*nf1.w + -0.09761985*ng1.w + -0.14420354*nh1.w + -0.04139432*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.026252449;
    i = 0.0787005*a0.x + -0.28859293*b0.x + -0.0067881406*c0.x + 0.29178682*d0.x + -0.100476004*e0.x + -0.08093355*f0.x + -0.031010041*g0.x + 0.14658515*h0.x + -0.090041496*i0.x;
    j = 0.0686159*a0.y + 0.21001844*b0.y + 0.044678725*c0.y + 0.050581932*d0.y + 0.33996314*e0.y + 0.14433432*f0.y + 0.08620218*g0.y + -0.05678144*h0.y + -0.15260054*i0.y;
    k = -0.0137613*a0.z + -0.15726678*b0.z + 0.20399995*c0.z + 0.09453541*d0.z + -0.09012798*e0.z + 0.06390615*f0.z + 0.15053074*g0.z + -0.027891546*h0.z + -0.049362328*i0.z;
    l = 0.05412328*a0.w + 0.20529822*b0.w + -0.15385857*c0.w + -0.11023235*d0.w + -0.07649383*e0.w + -0.09297993*f0.w + 0.03461381*g0.w + -0.025468629*h0.w + 0.0017152915*i0.w;
    m = -0.048222102*a1.x + -0.20325871*b1.x + 0.06318963*c1.x + 0.32389513*d1.x + -0.13079883*e1.x + 0.062312752*f1.x + 0.19552991*g1.x + -0.05771893*h1.x + 0.0034655593*i1.x;
    n = 0.22603649*a1.y + -0.22186667*b1.y + -0.1956643*c1.y + 0.16219154*d1.y + -0.16832736*e1.y + -0.007042763*f1.y + 0.048959658*g1.y + 0.07105372*h1.y + -0.06522516*i1.y;
    o = -0.038349096*a1.z + 0.0027485983*b1.z + 0.10738825*c1.z + 0.082396306*d1.z + -0.083042175*e1.z + 0.30802855*f1.z + -0.05532289*g1.z + 0.12641166*h1.z + 0.05846329*i1.z;
    p = -0.02619867*a1.w + -0.16696903*b1.w + -0.023464037*c1.w + -0.06669631*d1.w + -0.2338882*e1.w + -0.32071564*f1.w + 0.078225054*g1.w + -0.024752416*h1.w + -0.21565229*i1.w;
    q = -0.14719062*na0.x + 0.036166605*nb0.x + 0.03586071*nc0.x + -0.09496501*nd0.x + -0.2571935*ne0.x + -0.059871353*nf0.x + 0.1246005*ng0.x + -0.09816562*nh0.x + -0.094756044*ni0.x;
    r = -0.06635919*na0.y + -0.057532493*nb0.y + 0.096980825*nc0.y + 0.036802392*nd0.y + -0.02427639*ne0.y + 0.1140418*nf0.y + 0.022975886*ng0.y + 0.004847066*nh0.y + 0.15799266*ni0.y;
    s = 0.13028878*na0.z + 0.3263747*nb0.z + -0.23045464*nc0.z + 0.07008324*nd0.z + 0.16577603*ne0.z + 0.024477255*nf0.z + -0.15753885*ng0.z + 0.19609994*nh0.z + 0.10705109*ni0.z;
    t = -0.13850264*na0.w + -0.3382914*nb0.w + 0.046004727*nc0.w + 0.12867244*nd0.w + -0.049569026*ne0.w + -0.008928906*nf0.w + -0.11440658*ng0.w + -0.147463*nh0.w + -0.08606203*ni0.w;
    u = 0.11820253*na1.x + 0.20000514*nb1.x + 0.026139745*nc1.x + -0.19260569*nd1.x + -0.14018841*ne1.x + 0.07235604*nf1.x + -0.03838637*ng1.x + -0.09385468*nh1.x + 0.04758941*ni1.x;
    v = 0.0834724*na1.y + 0.14571273*nb1.y + 0.26493275*nc1.y + -0.18859173*nd1.y + 0.21985587*ne1.y + 0.28283784*nf1.y + -0.056772046*ng1.y + 0.013765349*nh1.y + 0.054531686*ni1.y;
    w = 0.084727615*na1.z + -0.24276324*nb1.z + 0.019877689*nc1.z + -0.1053572*nd1.z + 0.16096932*ne1.z + -0.038733255*nf1.z + -0.04136899*ng1.z + -0.024152098*nh1.z + -0.09792013*ni1.z;
    x = 0.003288853*na1.w + 0.092284575*nb1.w + -0.07442276*nc1.w + 0.025056144*nd1.w + 0.12108035*ne1.w + 0.16446428*nf1.w + -0.036851145*ng1.w + 0.044216324*nh1.w + 0.10186219*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0015176617;
    i = -0.015699264*a0.x + 0.030596672*b0.x + -0.09533272*c0.x + 0.0062539126*d0.x + 0.008770248*e0.x + 0.12371962*f0.x + -0.033431813*g0.x + -0.03436698*h0.x + 0.024540674*i0.x;
    j = 0.17142779*a0.y + -0.011952496*b0.y + -0.07112966*c0.y + 0.23306139*d0.y + 0.09441627*e0.y + -0.11017719*f0.y + 0.12642872*g0.y + 0.063718885*h0.y + 0.1107114*i0.y;
    k = 0.020745154*a0.z + 0.1870523*b0.z + 0.0014909132*c0.z + -0.23451832*d0.z + 0.037374016*e0.z + -0.045705926*f0.z + -0.112359606*g0.z + 0.12749946*h0.z + -0.046014808*i0.z;
    l = 0.08880867*a0.w + 0.0741326*b0.w + -0.1163462*c0.w + -0.1405951*d0.w + 0.122966714*e0.w + -0.15578188*f0.w + -0.035492282*g0.w + -0.060440145*h0.w + 0.037309416*i0.w;
    m = -0.09053849*a1.x + -0.055760566*b1.x + -0.029782353*c1.x + 0.039467704*d1.x + 0.07329281*e1.x + 0.03234974*f1.x + -0.09491558*g1.x + 0.034413684*h1.x + 0.07376969*i1.x;
    n = -0.16104591*a1.y + 0.058542773*b1.y + 0.07579228*c1.y + 0.19043031*d1.y + -0.03681334*e1.y + 0.18739979*f1.y + -0.04505818*g1.y + -0.15832698*h1.y + -0.00827814*i1.y;
    o = -0.023094185*a1.z + -0.025111288*b1.z + -0.02562611*c1.z + -0.041231755*d1.z + -0.04910127*e1.z + -0.1219653*f1.z + -0.006997529*g1.z + -0.15396258*h1.z + 0.102461934*i1.z;
    p = 0.082111925*a1.w + 0.19593202*b1.w + 0.029542198*c1.w + -0.06586002*d1.w + 0.1615917*e1.w + 0.10513043*f1.w + -0.055543568*g1.w + 0.1296069*h1.w + 0.031309575*i1.w;
    q = 0.17381243*na0.x + 0.16467948*nb0.x + -0.02460769*nc0.x + 0.011226765*nd0.x + 0.33458105*ne0.x + 0.014456158*nf0.x + -0.022459537*ng0.x + 0.11703303*nh0.x + 0.041535605*ni0.x;
    r = -0.073164664*na0.y + -0.13298072*nb0.y + 0.053352155*nc0.y + -0.15241776*nd0.y + -0.07620294*ne0.y + 0.023966217*nf0.y + -0.022878652*ng0.y + -0.016190618*nh0.y + 0.034986023*ni0.y;
    s = -0.07340512*na0.z + -0.32154587*nb0.z + -0.029413546*nc0.z + 0.13657314*nd0.z + -0.18318935*ne0.z + -0.010307318*nf0.z + 0.10293112*ng0.z + -0.20230167*nh0.z + 0.024070712*ni0.z;
    t = -0.055169705*na0.w + 0.038908716*nb0.w + 0.06615996*nc0.w + -0.0834325*nd0.w + 0.008771006*ne0.w + 0.18993776*nf0.w + -0.061884392*ng0.w + 0.113585375*nh0.w + 0.07253641*ni0.w;
    u = 0.057251845*na1.x + 0.06289371*nb1.x + -0.030567387*nc1.x + -0.026693162*nd1.x + 0.4123315*ne1.x + -0.055483878*nf1.x + 0.06410658*ng1.x + -0.044549458*nh1.x + -0.09532669*ni1.x;
    v = -0.02968765*na1.y + 0.16411597*nb1.y + 0.0063104588*nc1.y + -0.061117187*nd1.y + -0.18275106*ne1.y + 0.085616715*nf1.y + 0.06604734*ng1.y + -0.111928746*nh1.y + -0.063621275*ni1.y;
    w = 0.022099806*na1.z + -0.06566655*nb1.z + -0.016550316*nc1.z + 0.061879884*nd1.z + -0.3047371*ne1.z + -0.22423275*nf1.z + -0.038111757*ng1.z + -0.02573729*nh1.z + -0.14429528*ni1.z;
    x = -0.056604154*na1.w + -0.1831198*nb1.w + -0.029289784*nc1.w + 0.040536884*nd1.w + -0.08382906*ne1.w + -0.06134529*nf1.w + 0.12357722*ng1.w + -0.041197773*nh1.w + -0.05369438*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.011146248;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN60
//!BIND LUMAN61
//!SAVE LUMAN70

#define L0_tex LUMAN60_tex
#define L1_tex LUMAN61_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.16707185*a0.x + 0.01459159*b0.x + 0.09597878*c0.x + 0.07452457*d0.x + -0.16609426*e0.x + 0.22984987*f0.x + 0.01604279*g0.x + 0.12176588*h0.x + 0.12710643*i0.x;
    float j = 0.075276494*a0.y + -0.14305738*b0.y + -0.10306315*c0.y + 0.0041424287*d0.y + -0.18993132*e0.y + 0.07858037*f0.y + 0.14938961*g0.y + 0.15913264*h0.y + 0.048541065*i0.y;
    float k = 0.07726489*a0.z + 0.061804272*b0.z + -0.016685195*c0.z + 0.024503086*d0.z + 0.010571629*e0.z + 0.14796981*f0.z + -0.014458555*g0.z + -0.066766694*h0.z + 0.087022305*i0.z;
    float l = -0.0741828*a0.w + -0.06127295*b0.w + -0.0831812*c0.w + 0.0020672872*d0.w + -0.11349545*e0.w + -0.06560703*f0.w + -0.031534463*g0.w + 0.064463146*h0.w + -0.070401974*i0.w;
    float m = 0.059070893*a1.x + -0.08030707*b1.x + -0.031248493*c1.x + 0.021566726*d1.x + 0.11074087*e1.x + 0.12531136*f1.x + 0.04273478*g1.x + -0.035572812*h1.x + -0.04251175*i1.x;
    float n = 0.1207556*a1.y + -0.03475322*b1.y + -0.100367405*c1.y + 0.07478472*d1.y + -0.054013055*e1.y + 0.046478465*f1.y + -0.054475054*g1.y + 0.028075173*h1.y + 0.07847578*i1.y;
    float o = -0.127887*a1.z + 0.009045883*b1.z + -0.0413301*c1.z + -0.15486814*d1.z + -0.033196386*e1.z + 0.07920617*f1.z + -0.027982794*g1.z + -0.23330143*h1.z + -0.05289495*i1.z;
    float p = 0.07627091*a1.w + 0.092626214*b1.w + 0.03739464*c1.w + 0.011463141*d1.w + -0.10432715*e1.w + 0.05058091*f1.w + 0.0012654449*g1.w + 0.14053737*h1.w + -0.030011084*i1.w;
    float q = -0.093068324*na0.x + 0.021927057*nb0.x + -0.119940996*nc0.x + -0.12498851*nd0.x + -0.062243253*ne0.x + -0.0657077*nf0.x + -0.07868397*ng0.x + -0.14934455*nh0.x + -0.11498485*ni0.x;
    float r = 0.037383396*na0.y + 0.03412481*nb0.y + 0.080802746*nc0.y + -0.034590624*nd0.y + 0.102682725*ne0.y + -0.06089318*nf0.y + -0.07508375*ng0.y + -0.06557913*nh0.y + 0.025577186*ni0.y;
    float s = 0.011167806*na0.z + -0.08456959*nb0.z + 0.03695445*nc0.z + 0.11569212*nd0.z + 0.023378948*ne0.z + -0.1296879*nf0.z + 0.041656822*ng0.z + 0.043207034*nh0.z + -0.037079945*ni0.z;
    float t = 0.07834874*na0.w + 0.009891263*nb0.w + 0.099839434*nc0.w + -0.13000928*nd0.w + -0.0045935875*ne0.w + 0.019903835*nf0.w + -0.041363545*ng0.w + -0.03854393*nh0.w + 0.053775348*ni0.w;
    float u = 0.042012587*na1.x + 0.14145845*nb1.x + 0.06018162*nc1.x + 0.037801825*nd1.x + -0.23456845*ne1.x + -0.16834131*nf1.x + -0.04549333*ng1.x + -0.07055851*nh1.x + 0.095839985*ni1.x;
    float v = 0.0062642097*na1.y + 0.04875694*nb1.y + 0.04445962*nc1.y + 0.041629676*nd1.y + -0.04451888*ne1.y + 0.036208697*nf1.y + -0.018410044*ng1.y + -0.00222759*nh1.y + 0.019979788*ni1.y;
    float w = 0.05050757*na1.z + -0.059576757*nb1.z + 0.07722044*nc1.z + 0.09021037*nd1.z + 0.0279692*ne1.z + -0.17721412*nf1.z + 0.11889603*ng1.z + 0.17959587*nh1.z + -0.009883711*ni1.z;
    float x = -0.17722*na1.w + -0.1294848*nb1.w + -0.05886288*nc1.w + 0.17996617*nd1.w + -0.37909824*ne1.w + -0.10436786*nf1.w + 0.0857953*ng1.w + 0.035984337*nh1.w + -0.15937395*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.020803524;
    i = 0.18760012*a0.x + -0.05672948*b0.x + -0.04035751*c0.x + 0.051190294*d0.x + -0.4160101*e0.x + -0.015525946*f0.x + 0.06301994*g0.x + 0.1546013*h0.x + 0.03517859*i0.x;
    j = 0.034246188*a0.y + 0.03255839*b0.y + 0.17857063*c0.y + 0.28546038*d0.y + 0.019054411*e0.y + -0.0869243*f0.y + 0.008228919*g0.y + 0.0562388*h0.y + -0.13069227*i0.y;
    k = -0.024451675*a0.z + -0.13683404*b0.z + -0.1010116*c0.z + -0.052205075*d0.z + -0.16257866*e0.z + 0.1305172*f0.z + 0.027445339*g0.z + -0.0118933255*h0.z + 0.098764986*i0.z;
    l = -0.066036776*a0.w + 0.022648929*b0.w + 0.07048763*c0.w + -0.0063484786*d0.w + -0.243269*e0.w + 0.030944303*f0.w + -0.13571839*g0.w + -0.01094549*h0.w + -0.010621858*i0.w;
    m = 0.03762773*a1.x + -0.08693226*b1.x + 0.07314137*c1.x + -0.013404316*d1.x + 0.14760663*e1.x + -0.32283306*f1.x + -0.056603152*g1.x + -0.06067009*h1.x + -0.17135729*i1.x;
    n = 0.19832304*a1.y + -0.069314696*b1.y + 0.06315924*c1.y + -0.1030127*d1.y + -0.43251115*e1.y + -0.06101974*f1.y + -0.11535977*g1.y + -0.013645112*h1.y + -0.002090781*i1.y;
    o = -0.075515576*a1.z + 0.032988884*b1.z + 0.08949724*c1.z + -0.15579495*d1.z + -0.10749708*e1.z + -0.011412682*f1.z + -0.022672031*g1.z + 0.14450091*h1.z + 0.0580288*i1.z;
    p = 0.052963868*a1.w + 0.065941304*b1.w + -0.08848499*c1.w + -0.045445524*d1.w + 0.013262591*e1.w + 0.27520946*f1.w + 0.106307745*g1.w + 0.11091647*h1.w + -0.044759583*i1.w;
    q = -0.13402347*na0.x + -0.06257855*nb0.x + 0.0752903*nc0.x + 0.01813476*nd0.x + 0.15062326*ne0.x + -0.24121898*nf0.x + -0.033599045*ng0.x + -0.22295438*nh0.x + 0.07236984*ni0.x;
    r = -0.03748897*na0.y + -0.14177923*nb0.y + -0.037401408*nc0.y + -0.12516059*nd0.y + -0.01755814*ne0.y + 0.07203849*nf0.y + 0.036626935*ng0.y + -0.05567603*nh0.y + 0.04024097*ni0.y;
    s = 0.057622183*na0.z + -0.006183752*nb0.z + 0.10726049*nc0.z + 0.19952112*nd0.z + 0.18812835*ne0.z + 0.051843926*nf0.z + -0.0002990376*ng0.z + 0.05477127*nh0.z + -0.12951618*ni0.z;
    t = 0.033499256*na0.w + -0.11512289*nb0.w + -0.06745114*nc0.w + -0.12442632*nd0.w + 0.0403085*ne0.w + -0.06879559*nf0.w + 0.1063965*ng0.w + 0.020015359*nh0.w + 0.012631638*ni0.w;
    u = -0.061987985*na1.x + 0.1644526*nb1.x + 0.11696878*nc1.x + 0.046437148*nd1.x + -0.1264651*ne1.x + 0.3210138*nf1.x + 0.17217772*ng1.x + 0.13374034*nh1.x + -0.05727805*ni1.x;
    v = -0.056843136*na1.y + 0.047753133*nb1.y + -0.09544034*nc1.y + 0.04304065*nd1.y + 0.40721974*ne1.y + 0.100129314*nf1.y + 0.07010598*ng1.y + -0.05048358*nh1.y + -0.0026080816*ni1.y;
    w = 0.08819051*na1.z + 0.037071127*nb1.z + -0.070650496*nc1.z + 0.062920175*nd1.z + 0.07917255*ne1.z + 0.12788*nf1.z + -0.017485328*ng1.z + -0.05174912*nh1.z + -0.035436332*ni1.z;
    x = -0.045394093*na1.w + 0.017271686*nb1.w + 0.035120815*nc1.w + 0.25334322*nd1.w + -0.122095615*ne1.w + -0.028557297*nf1.w + -0.06654046*ng1.w + -0.14862229*nh1.w + 0.12124861*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.011939273;
    i = 0.007988823*a0.x + 0.043300614*b0.x + 0.06301894*c0.x + 0.023971288*d0.x + 0.25549185*e0.x + 0.04421958*f0.x + 0.0022470562*g0.x + -0.10538949*h0.x + 0.05210963*i0.x;
    j = -0.16987213*a0.y + -0.31616268*b0.y + -0.058348488*c0.y + 0.047011923*d0.y + -0.24267124*e0.y + -0.029344559*f0.y + -0.12871924*g0.y + -0.14803977*h0.y + 0.16648817*i0.y;
    k = 0.032171052*a0.z + -0.099306546*b0.z + 0.17139974*c0.z + 0.05083007*d0.z + -0.0838175*e0.z + 0.06591208*f0.z + 0.037488688*g0.z + -0.14690341*h0.z + -0.08771937*i0.z;
    l = -0.031773616*a0.w + -0.15480563*b0.w + -0.114856966*c0.w + 0.059143398*d0.w + 0.22674477*e0.w + -0.024911936*f0.w + -0.026028406*g0.w + -0.02581128*h0.w + -0.07086282*i0.w;
    m = -0.010544171*a1.x + -0.121315874*b1.x + -0.021153478*c1.x + 0.09653259*d1.x + 0.23078552*e1.x + 0.09536591*f1.x + 0.097515665*g1.x + 0.27507824*h1.x + 0.30895805*i1.x;
    n = 0.0064135334*a1.y + -0.15648791*b1.y + -0.06604209*c1.y + 0.05537567*d1.y + 0.1712115*e1.y + 0.16483422*f1.y + 0.031414956*g1.y + 0.07765021*h1.y + 0.11804431*i1.y;
    o = 0.040441096*a1.z + 0.029267445*b1.z + -0.0014274184*c1.z + 0.13492791*d1.z + 0.21282202*e1.z + -0.023156036*f1.z + 0.11033489*g1.z + -0.019858988*h1.z + 0.0101667745*i1.z;
    p = -0.05952965*a1.w + 0.12360287*b1.w + 0.15023205*c1.w + 0.13136087*d1.w + 0.09425458*e1.w + -0.15051837*f1.w + 0.11030205*g1.w + 0.055964366*h1.w + -0.04351984*i1.w;
    q = 0.0800978*na0.x + 0.14231174*nb0.x + -0.122729294*nc0.x + -0.2446972*nd0.x + -0.058770172*ne0.x + -0.04128968*nf0.x + -0.16805433*ng0.x + 0.2870106*nh0.x + 0.11663096*ni0.x;
    r = 0.19433951*na0.y + 0.22241181*nb0.y + 0.021812731*nc0.y + -0.07812733*nd0.y + -0.18069054*ne0.y + 0.031146582*nf0.y + -0.058601037*ng0.y + 0.052038964*nh0.y + 0.012479496*ni0.y;
    s = -0.19189489*na0.z + -0.013886786*nb0.z + -0.15179993*nc0.z + -0.1548249*nd0.z + -0.5476674*ne0.z + -0.48016936*nf0.z + -0.089323506*ng0.z + 0.09407296*nh0.z + 0.03633839*ni0.z;
    t = -0.014738748*na0.w + 0.12443845*nb0.w + 0.06398434*nc0.w + 0.031160723*nd0.w + -0.15837196*ne0.w + -0.0151074985*nf0.w + 0.082899936*ng0.w + 0.11998946*nh0.w + 0.11566883*ni0.w;
    u = 0.025826976*na1.x + -0.0010483622*nb1.x + -0.10387264*nc1.x + -0.03628439*nd1.x + -0.15113765*ne1.x + -0.25192127*nf1.x + -0.06575387*ng1.x + -0.18649472*nh1.x + -0.10462416*ni1.x;
    v = -0.01315456*na1.y + 0.10511144*nb1.y + -0.0059079076*nc1.y + -0.15953188*nd1.y + -0.099411644*ne1.y + 0.0130890235*nf1.y + -0.09630611*ng1.y + 0.01270137*nh1.y + -0.06623264*ni1.y;
    w = -0.009895875*na1.z + -0.06556251*nb1.z + 0.020807983*nc1.z + 0.110983044*nd1.z + -0.06224234*ne1.z + -0.0017107179*nf1.z + -0.025325751*ng1.z + -0.08919119*nh1.z + 0.040737003*ni1.z;
    x = 0.038011968*na1.w + -0.16423859*nb1.w + -0.04267014*nc1.w + -0.060422074*nd1.w + -0.02386611*ne1.w + 0.10199278*nf1.w + -0.08109655*ng1.w + 0.05310966*nh1.w + 0.0705772*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.016101146;
    i = 0.08186986*a0.x + -0.27966294*b0.x + 0.07349518*c0.x + -0.02525529*d0.x + 0.08804907*e0.x + -0.23396638*f0.x + -0.095341004*g0.x + 0.12230629*h0.x + -0.088450216*i0.x;
    j = 0.17311937*a0.y + -0.011713199*b0.y + -0.023302078*c0.y + -0.28680474*d0.y + 0.25046813*e0.y + 0.13166201*f0.y + 0.22162731*g0.y + 0.2569277*h0.y + -0.16860108*i0.y;
    k = -0.13823773*a0.z + -0.32229167*b0.z + -0.09600752*c0.z + 0.01688759*d0.z + -0.015036404*e0.z + -0.006144277*f0.z + -0.049893063*g0.z + 0.0070240092*h0.z + -0.012577821*i0.z;
    l = 0.027596693*a0.w + 0.07686742*b0.w + 0.059847716*c0.w + 0.064874366*d0.w + 0.37457395*e0.w + -0.08730197*f0.w + -0.06216056*g0.w + 0.15892714*h0.w + 0.10220284*i0.w;
    m = 0.04762231*a1.x + -0.05717154*b1.x + -0.011567126*c1.x + -0.025255503*d1.x + 0.012369087*e1.x + 0.07555715*f1.x + 0.008033872*g1.x + -0.21224308*h1.x + -0.21989736*i1.x;
    n = 0.06412487*a1.y + 0.04054021*b1.y + 0.06108249*c1.y + -0.008536781*d1.y + 0.102750435*e1.y + -0.00041976082*f1.y + -0.08412207*g1.y + 0.122296356*h1.y + -0.009252118*i1.y;
    o = -0.022489117*a1.z + 0.027151579*b1.z + -0.052604277*c1.z + 0.0904872*d1.z + -0.118856296*e1.z + 0.016594423*f1.z + -0.07095765*g1.z + -0.1356925*h1.z + 0.04555555*i1.z;
    p = -0.0027514708*a1.w + -0.18162079*b1.w + -0.025238771*c1.w + 0.12815496*d1.w + 0.2966293*e1.w + 0.07295546*f1.w + -0.001974208*g1.w + -0.079097986*h1.w + -0.061876595*i1.w;
    q = -0.017452657*na0.x + 0.27534506*nb0.x + -0.059656087*nc0.x + -0.08268512*nd0.x + -0.13075675*ne0.x + 0.143268*nf0.x + -0.037696302*ng0.x + -0.152455*nh0.x + 0.17365775*ni0.x;
    r = -0.13629195*na0.y + -0.09065064*nb0.y + 0.023805516*nc0.y + -0.116249606*nd0.y + -0.10501295*ne0.y + -0.04866309*nf0.y + 0.100499496*ng0.y + -0.15090236*nh0.y + 0.1763309*ni0.y;
    s = 0.07023327*na0.z + -0.023078058*nb0.z + 0.023277761*nc0.z + -0.07977383*nd0.z + -0.109831356*ne0.z + 0.046003412*nf0.z + -0.011881196*ng0.z + -0.10053063*nh0.z + -0.086142026*ni0.z;
    t = -0.011805513*na0.w + -0.07882051*nb0.w + 0.01810326*nc0.w + -0.18755534*nd0.w + -0.105580114*ne0.w + 0.06887994*nf0.w + 0.049635768*ng0.w + -0.07681415*nh0.w + -0.10049961*ni0.w;
    u = -0.07036247*na1.x + 0.049210124*nb1.x + 0.0056824684*nc1.x + -0.00047676652*nd1.x + 0.037586123*ne1.x + -0.019774916*nf1.x + 0.15204369*ng1.x + 0.026581515*nh1.x + -0.009564476*ni1.x;
    v = 0.040534947*na1.y + -0.07229616*nb1.y + -0.04097948*nc1.y + -0.009419609*nd1.y + -0.002633858*ne1.y + -0.0031189565*nf1.y + 0.008676045*ng1.y + -0.2262739*nh1.y + 0.12348922*ni1.y;
    w = 0.048678316*na1.z + -0.078876495*nb1.z + -0.030548131*nc1.z + -0.08987738*nd1.z + 0.04284424*ne1.z + 0.01576385*nf1.z + 0.16307567*ng1.z + 0.21366584*nh1.z + -0.06277811*ni1.z;
    x = 0.015810061*na1.w + 0.1067863*nb1.w + 0.04990775*nc1.w + 0.024920044*nd1.w + -0.42603993*ne1.w + -0.03960076*nf1.w + 0.057762917*ng1.w + -0.03203102*nh1.w + 0.15136312*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.028439088;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN60
//!BIND LUMAN61
//!SAVE LUMAN71

#define L0_tex LUMAN60_tex
#define L1_tex LUMAN61_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.020427955*a0.x + -0.12299448*b0.x + 0.0382103*c0.x + -0.2065043*d0.x + 0.18101963*e0.x + -0.10143672*f0.x + 0.069389276*g0.x + 0.11816535*h0.x + 0.06997783*i0.x;
    float j = 0.21215856*a0.y + -0.04804419*b0.y + 0.008095651*c0.y + -0.293839*d0.y + 0.33101708*e0.y + 0.33218643*f0.y + 0.053283837*g0.y + 0.17308329*h0.y + -0.03772887*i0.y;
    float k = -0.34456056*a0.z + -0.16793236*b0.z + 0.03739383*c0.z + -0.080821194*d0.z + -0.22808352*e0.z + -0.113590464*f0.z + -0.037161198*g0.z + 0.023857055*h0.z + -0.09459421*i0.z;
    float l = -0.08646293*a0.w + 0.107415445*b0.w + 0.044336937*c0.w + 0.069187395*d0.w + -0.062774606*e0.w + -0.108927466*f0.w + -0.04602913*g0.w + -0.07301894*h0.w + 0.10343813*i0.w;
    float m = -0.059688944*a1.x + -0.24532959*b1.x + 0.01622201*c1.x + 0.121369496*d1.x + 0.4220545*e1.x + 0.05799676*f1.x + -0.010943618*g1.x + -0.04879672*h1.x + -0.18129556*i1.x;
    float n = 0.08937881*a1.y + -0.076180376*b1.y + -0.011001821*c1.y + 0.02046611*d1.y + 0.08171395*e1.y + 0.1594122*f1.y + -0.0132004395*g1.y + -0.07992791*h1.y + -0.067408495*i1.y;
    float o = -0.06548962*a1.z + -0.16845347*b1.z + -0.027801726*c1.z + 0.31846458*d1.z + 0.16317068*e1.z + -0.038398925*f1.z + 0.12266141*g1.z + 0.026239803*h1.z + 0.06616569*i1.z;
    float p = -0.09446756*a1.w + -0.28087494*b1.w + -0.07972108*c1.w + 0.24629132*d1.w + 0.119287975*e1.w + 0.24699649*f1.w + 0.13661574*g1.w + -0.07906541*h1.w + -0.0056392225*i1.w;
    float q = 0.03538764*na0.x + 0.2790401*nb0.x + 0.08151654*nc0.x + -0.22784868*nd0.x + -0.36319312*ne0.x + -0.113029726*nf0.x + -0.10720264*ng0.x + 0.043048188*nh0.x + 0.12067008*ni0.x;
    float r = 0.24458425*na0.y + -0.017716056*nb0.y + -0.07277476*nc0.y + -0.34660316*nd0.y + -0.326197*ne0.y + -0.17121781*nf0.y + 0.18105748*ng0.y + 0.054370437*nh0.y + 0.07291747*ni0.y;
    float s = 0.1444308*na0.z + 0.037046615*nb0.z + -0.074410655*nc0.z + -0.0331052*nd0.z + 0.2983961*ne0.z + 0.10592076*nf0.z + -0.04357041*ng0.z + -0.08175989*nh0.z + -0.019775998*ni0.z;
    float t = 0.0012991523*na0.w + -0.041375145*nb0.w + -0.061631728*nc0.w + 0.03254315*nd0.w + 0.18613961*ne0.w + 0.105121955*nf0.w + 0.111895464*ng0.w + 0.047140393*nh0.w + -0.10446484*ni0.w;
    float u = 0.0008599757*na1.x + 0.025347594*nb1.x + -0.08645557*nc1.x + -0.13086848*nd1.x + 0.04430699*ne1.x + -0.04425249*nf1.x + 0.12734428*ng1.x + -0.06775437*nh1.x + -0.02977556*ni1.x;
    float v = 0.042987797*na1.y + 0.22243887*nb1.y + 0.009829554*nc1.y + -0.05559989*nd1.y + 0.22480097*ne1.y + -0.12777573*nf1.y + -0.021276096*ng1.y + -0.073389776*nh1.y + 0.05349569*ni1.y;
    float w = 0.22859068*na1.z + 0.071143694*nb1.z + -0.08075097*nc1.z + -0.086894736*nd1.z + -0.01395731*ne1.z + 0.13063684*nf1.z + 0.03464629*ng1.z + 0.059344422*nh1.z + 0.04601359*ni1.z;
    float x = 0.15328191*na1.w + 0.18964882*nb1.w + 0.09343201*nc1.w + -0.086833306*nd1.w + -0.3459332*ne1.w + -0.23979221*nf1.w + -0.0323085*ng1.w + -0.025463346*nh1.w + 0.29438457*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.00774723;
    i = 0.02540264*a0.x + 0.057967946*b0.x + 0.0756193*c0.x + 0.07650531*d0.x + -0.033239055*e0.x + 0.008858051*f0.x + -0.0009940318*g0.x + -0.037703067*h0.x + 0.26205966*i0.x;
    j = -0.11909197*a0.y + 0.07580306*b0.y + 0.05527881*c0.y + 0.12937492*d0.y + -0.006751253*e0.y + -0.04913538*f0.y + -0.055807915*g0.y + 0.15184923*h0.y + 0.010444979*i0.y;
    k = -9.871652e-05*a0.z + 0.040530793*b0.z + 0.1569917*c0.z + 0.012185376*d0.z + -0.5438175*e0.z + 0.055470947*f0.z + -0.049259298*g0.z + -0.0059514428*h0.z + 0.054824114*i0.z;
    l = -0.08456306*a0.w + -0.019126693*b0.w + -0.021060875*c0.w + -0.03132117*d0.w + -0.033833887*e0.w + 0.012529336*f0.w + -0.00084578665*g0.w + 0.021030087*h0.w + -0.03891261*i0.w;
    m = -0.056309015*a1.x + -0.10297292*b1.x + 0.11251738*c1.x + 0.08159942*d1.x + -0.122514226*e1.x + -0.079847425*f1.x + 0.11716084*g1.x + 0.049454574*h1.x + -0.050938994*i1.x;
    n = 0.04500759*a1.y + -0.02995276*b1.y + -0.0060616354*c1.y + -0.027787723*d1.y + 0.08043579*e1.y + 0.17243683*f1.y + 0.04944646*g1.y + 0.01185244*h1.y + 0.025549565*i1.y;
    o = 0.017759923*a1.z + 0.023875631*b1.z + -0.0016878811*c1.z + 0.085072495*d1.z + -0.04422165*e1.z + 0.025165051*f1.z + -0.044808466*g1.z + -0.2277521*h1.z + -0.046955653*i1.z;
    p = 0.06976003*a1.w + 0.100424804*b1.w + -0.01778747*c1.w + 0.09177266*d1.w + -0.10005814*e1.w + 0.045143608*f1.w + -0.085984215*g1.w + -0.09975948*h1.w + -0.014967957*i1.w;
    q = -0.02396588*na0.x + -0.012424523*nb0.x + -0.026491754*nc0.x + -0.124398455*nd0.x + 0.10213312*ne0.x + -0.1272105*nf0.x + -0.043681663*ng0.x + -0.11994408*nh0.x + -0.1130879*ni0.x;
    r = -0.031082416*na0.y + 0.057595864*nb0.y + -0.0448145*nc0.y + 0.05464614*nd0.y + 0.1381928*ne0.y + 0.06410599*nf0.y + 0.057261996*ng0.y + 0.041460402*nh0.y + 0.052953117*ni0.y;
    s = -0.12601034*na0.z + 0.071309365*nb0.z + -0.16443217*nc0.z + -0.18393376*nd0.z + 0.039121736*ne0.z + -0.25262094*nf0.z + -0.04935926*ng0.z + -0.031141888*nh0.z + -0.10622221*ni0.z;
    t = 0.0707843*na0.w + 0.0298844*nb0.w + 0.013997341*nc0.w + 0.0987847*nd0.w + 0.053505234*ne0.w + 0.016743721*nf0.w + -0.021958148*ng0.w + -0.0065752435*nh0.w + 0.037387595*ni0.w;
    u = 0.010219839*na1.x + 0.013594147*nb1.x + -0.097386606*nc1.x + 0.053305168*nd1.x + 0.10351772*ne1.x + 0.14909032*nf1.x + 0.009329111*ng1.x + 0.00042785183*nh1.x + 0.03540518*ni1.x;
    v = 0.011846549*na1.y + 0.061299648*nb1.y + -0.009049967*nc1.y + 0.051321067*nd1.y + 0.07379161*ne1.y + -0.034670807*nf1.y + -0.037010025*ng1.y + 0.003963174*nh1.y + 0.027588818*ni1.y;
    w = 0.03077586*na1.z + -0.029026378*nb1.z + -0.08913523*nc1.z + 0.07136059*nd1.z + 0.07291538*ne1.z + -0.004745367*nf1.z + 0.03465485*ng1.z + 0.22157489*nh1.z + 0.17830387*ni1.z;
    x = -0.10886378*na1.w + -0.06592867*nb1.w + -0.037860826*nc1.w + 0.00437296*nd1.w + 0.17816012*ne1.w + -0.07993008*nf1.w + 0.1061081*ng1.w + 0.09556956*nh1.w + 0.07920885*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.017806575;
    i = -0.027967636*a0.x + -0.3974226*b0.x + -0.104621045*c0.x + -0.15640318*d0.x + -0.24313703*e0.x + 0.10833983*f0.x + 0.034498516*g0.x + -0.111212805*h0.x + -0.0066484264*i0.x;
    j = 0.34898776*a0.y + 0.08453386*b0.y + -0.14493187*c0.y + -0.062394954*d0.y + 0.017768497*e0.y + 0.016403986*f0.y + 0.008856344*g0.y + -0.049575865*h0.y + 0.07749693*i0.y;
    k = -0.07570748*a0.z + -0.33858824*b0.z + -0.19494228*c0.z + -0.13904461*d0.z + -0.28649932*e0.z + -0.07591364*f0.z + 0.083951026*g0.z + 0.0083411895*h0.z + -0.0806109*i0.z;
    l = 0.084906526*a0.w + 0.043091387*b0.w + 0.06524473*c0.w + 0.11896168*d0.w + 0.4036274*e0.w + -0.099725835*f0.w + -0.09322391*g0.w + 0.06554854*h0.w + -0.07920316*i0.w;
    m = 0.103149265*a1.x + 0.09379966*b1.x + -0.11465655*c1.x + 0.05819121*d1.x + 0.44112626*e1.x + -0.008220044*f1.x + -0.052106164*g1.x + -0.05718799*h1.x + 0.055597268*i1.x;
    n = 0.03208524*a1.y + 0.047358923*b1.y + 0.079363085*c1.y + -0.08852368*d1.y + 0.013399863*e1.y + -0.076518625*f1.y + -0.053747185*g1.y + 0.034843802*h1.y + -0.04375299*i1.y;
    o = 0.0872293*a1.z + -0.109462485*b1.z + -0.070991404*c1.z + -0.0003856647*d1.z + -0.15613072*e1.z + 0.069763996*f1.z + 0.07777321*g1.z + -0.09938978*h1.z + 0.022947747*i1.z;
    p = -0.15075473*a1.w + -0.40277463*b1.w + -0.09087062*c1.w + -0.095137954*d1.w + 0.013284446*e1.w + -0.07939426*f1.w + 0.07534805*g1.w + -0.21933137*h1.w + 0.07597216*i1.w;
    q = 0.05529762*na0.x + 0.5643769*nb0.x + 0.1525933*nc0.x + 0.15038446*nd0.x + 0.23356788*ne0.x + -0.08914753*nf0.x + 0.021691134*ng0.x + 0.3045392*nh0.x + 0.0035494857*ni0.x;
    r = -0.14748119*na0.y + 0.15565526*nb0.y + 0.14430578*nc0.y + -0.26224518*nd0.y + 0.20457776*ne0.y + 0.15587778*nf0.y + 0.113763526*ng0.y + -0.0038962625*nh0.y + 0.0028991853*ni0.y;
    s = 0.095023744*na0.z + -0.20927958*nb0.z + 0.03397999*nc0.z + 0.13496824*nd0.z + 0.26218286*ne0.z + 0.06425366*nf0.z + -0.044739686*ng0.z + -0.07387857*nh0.z + 0.09531976*ni0.z;
    t = -0.08336938*na0.w + -0.058455873*nb0.w + 0.027722135*nc0.w + -0.06443187*nd0.w + -0.119230665*ne0.w + 0.056134336*nf0.w + 0.16522501*ng0.w + -0.016409501*nh0.w + 0.03460061*ni0.w;
    u = -0.19015406*na1.x + -0.13403434*nb1.x + 0.0062869973*nc1.x + -0.10456645*nd1.x + -0.15624808*ne1.x + 0.036319517*nf1.x + 0.13136101*ng1.x + -0.08900796*nh1.x + -0.056879304*ni1.x;
    v = -0.08094239*na1.y + 0.07242798*nb1.y + 0.0057236864*nc1.y + -0.04243141*nd1.y + 0.24958204*ne1.y + 0.13537963*nf1.y + 0.023295095*ng1.y + -0.00995568*nh1.y + 0.1266285*ni1.y;
    w = -0.048188806*na1.z + 0.03503379*nb1.z + 0.043767393*nc1.z + -0.090857185*nd1.z + 0.037315335*ne1.z + 0.13315836*nf1.z + -0.17816217*ng1.z + 0.05826157*nh1.z + -0.03337344*ni1.z;
    x = 0.12771568*na1.w + 0.27837166*nb1.w + 0.034090616*nc1.w + -0.09378682*nd1.w + 0.16186482*ne1.w + -0.27224994*nf1.w + -0.20890142*ng1.w + 0.079806164*nh1.w + -0.053670608*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.014841039;
    i = 0.009409041*a0.x + -0.07351588*b0.x + -0.053960185*c0.x + -0.00039128572*d0.x + -0.20716943*e0.x + -0.055470668*f0.x + 0.1470315*g0.x + -0.0069380105*h0.x + 0.11312721*i0.x;
    j = 0.061510608*a0.y + -0.15638562*b0.y + 0.10619936*c0.y + 0.536396*d0.y + 0.39904788*e0.y + -0.016805295*f0.y + -0.18737078*g0.y + 0.081641555*h0.y + 0.13490897*i0.y;
    k = 0.048978038*a0.z + 0.38890696*b0.z + 0.07112136*c0.z + -0.025988413*d0.z + 0.2416053*e0.z + -0.059832115*f0.z + 0.1512881*g0.z + -0.06985439*h0.z + -0.002822441*i0.z;
    l = -0.15069428*a0.w + -0.029694725*b0.w + -0.034548882*c0.w + 0.17521743*d0.w + -0.14802086*e0.w + 0.03244504*f0.w + -0.028429842*g0.w + -0.072642036*h0.w + -0.1377792*i0.w;
    m = 0.008575682*a1.x + 0.033175733*b1.x + 0.23012964*c1.x + 0.06180262*d1.x + 0.0999609*e1.x + -0.02964116*f1.x + -0.071621336*g1.x + 0.08913871*h1.x + 0.012078745*i1.x;
    n = 0.10756925*a1.y + -0.12054749*b1.y + -0.11993612*c1.y + -0.05570062*d1.y + 0.26974162*e1.y + -0.019340996*f1.y + -0.04401674*g1.y + -0.072913505*h1.y + 0.0020360341*i1.y;
    o = -0.11235567*a1.z + 0.10706251*b1.z + -0.05232752*c1.z + 0.024162654*d1.z + -0.016020348*e1.z + 0.14959016*f1.z + -0.07076375*g1.z + -0.12533532*h1.z + -0.011636851*i1.z;
    p = -0.01996831*a1.w + 0.1160153*b1.w + -0.13922714*c1.w + -0.029968955*d1.w + -0.23581982*e1.w + 0.11195416*f1.w + 0.047328863*g1.w + 0.27882084*h1.w + 0.12671103*i1.w;
    q = -0.009971324*na0.x + -0.10869965*nb0.x + 0.035636835*nc0.x + -0.02722658*nd0.x + -0.25910825*ne0.x + 0.03161085*nf0.x + 0.11639807*ng0.x + -0.010749773*nh0.x + -0.24573305*ni0.x;
    r = 0.050995197*na0.y + -0.10302342*nb0.y + -0.1673679*nc0.y + -0.20349346*nd0.y + -0.55413437*ne0.y + -0.029592037*nf0.y + -0.036228*ng0.y + 0.069125436*nh0.y + -0.18871574*ni0.y;
    s = 0.038417455*na0.z + -0.21142405*nb0.z + -0.034855157*nc0.z + -0.054826926*nd0.z + -0.24405639*ne0.z + 0.11743097*nf0.z + -0.0859903*ng0.z + 0.21720038*nh0.z + 0.08788087*ni0.z;
    t = 0.048770655*na0.w + 0.12233943*nb0.w + -0.03950986*nc0.w + -0.009187269*nd0.w + -0.12946133*ne0.w + -0.07174181*nf0.w + 0.021697959*ng0.w + 0.075961806*nh0.w + 0.061868332*ni0.w;
    u = -0.06566027*na1.x + 0.00080207275*nb1.x + 0.020833474*nc1.x + 0.013340379*nd1.x + -0.2165162*ne1.x + 0.0868738*nf1.x + 0.043138873*ng1.x + 0.22945437*nh1.x + 0.0138047775*ni1.x;
    v = 0.017050784*na1.y + 0.2494357*nb1.y + 0.011488906*nc1.y + -0.068815716*nd1.y + -0.5650941*ne1.y + 0.030278916*nf1.y + 0.055531804*ng1.y + 0.14427291*nh1.y + 0.0024433972*ni1.y;
    w = 0.14314358*na1.z + 0.0028497116*nb1.z + -0.0023248373*nc1.z + -0.06904705*nd1.z + -0.11152599*ne1.z + -0.21558757*nf1.z + -0.05603373*ng1.z + 0.0005346824*nh1.z + 0.13354091*ni1.z;
    x = -0.049296606*na1.w + -0.07173451*nb1.w + 0.2581109*nc1.w + -0.01809698*nd1.w + 0.007841395*ne1.w + -0.22031958*nf1.w + -0.0476805*ng1.w + -0.11961736*nh1.w + -0.08217695*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.009083936;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN80

#define L0_tex LUMAN70_tex
#define L1_tex LUMAN71_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.035619374*a0.x + 0.11422981*b0.x + 0.08590356*c0.x + -0.12612246*d0.x + 0.043873888*e0.x + 0.05914766*f0.x + -0.100714274*g0.x + 0.048455495*h0.x + -0.06725533*i0.x;
    float j = -0.0013158132*a0.y + -0.0027882596*b0.y + -0.10217369*c0.y + 0.31677207*d0.y + 0.036820866*e0.y + -0.05431359*f0.y + 0.14844827*g0.y + -0.10730725*h0.y + -0.063290775*i0.y;
    float k = 0.087911345*a0.z + 0.26342505*b0.z + 0.013027925*c0.z + 0.06752866*d0.z + -0.19719961*e0.z + -0.04780573*f0.z + 0.026932135*g0.z + -0.05800601*h0.z + -0.040505923*i0.z;
    float l = 0.04630579*a0.w + -0.11939466*b0.w + -0.010408778*c0.w + 0.04669857*d0.w + -0.13335805*e0.w + -0.020812513*f0.w + -0.06745056*g0.w + 0.05681251*h0.w + 0.06444111*i0.w;
    float m = 0.053154137*a1.x + 0.060493603*b1.x + 0.08252165*c1.x + 0.020070437*d1.x + -0.08261315*e1.x + 0.018669957*f1.x + -0.041988045*g1.x + -0.036143973*h1.x + -0.08385737*i1.x;
    float n = -0.20525856*a1.y + -0.2934399*b1.y + -0.10462723*c1.y + 0.13134363*d1.y + -0.06662953*e1.y + 0.06028899*f1.y + 0.15253557*g1.y + -0.11593999*h1.y + 0.15354787*i1.y;
    float o = -0.016207945*a1.z + -0.011455923*b1.z + 0.024988474*c1.z + 0.061092008*d1.z + 0.10414427*e1.z + -0.04360575*f1.z + 0.090637736*g1.z + 0.15851928*h1.z + 0.06644112*i1.z;
    float p = -0.0030416374*a1.w + 0.34662476*b1.w + -0.042266436*c1.w + 0.31826603*d1.w + -0.02068287*e1.w + -0.07076953*f1.w + -0.048260685*g1.w + 0.13000193*h1.w + -0.0017414218*i1.w;
    float q = 0.14909811*na0.x + -0.10734144*nb0.x + -0.10109777*nc0.x + 0.111862935*nd0.x + -0.107315935*ne0.x + -0.04478417*nf0.x + -0.0054377364*ng0.x + 0.0148478085*nh0.x + 0.06869275*ni0.x;
    float r = -0.045117185*na0.y + -0.056990396*nb0.y + -0.003557616*nc0.y + -0.24177164*nd0.y + -0.2250938*ne0.y + 0.0349928*nf0.y + -0.07328847*ng0.y + 0.055793595*nh0.y + 0.08246393*ni0.y;
    float s = 0.08810404*na0.z + 0.08207737*nb0.z + -0.03529103*nc0.z + -0.07186509*nd0.z + 0.11098997*ne0.z + -0.0061407485*nf0.z + -0.01619299*ng0.z + 0.016094537*nh0.z + 0.024314752*ni0.z;
    float t = -0.049262095*na0.w + -0.015455753*nb0.w + 0.08398538*nc0.w + -0.06844428*nd0.w + 0.06602493*ne0.w + 0.0039364174*nf0.w + 0.024258781*ng0.w + -0.031155214*nh0.w + -0.02522881*ni0.w;
    float u = -0.09289411*na1.x + -0.014842693*nb1.x + 0.07513892*nc1.x + -0.01653032*nd1.x + 0.01198521*ne1.x + 0.02763562*nf1.x + -0.05833778*ng1.x + 0.18610096*nh1.x + 0.24278776*ni1.x;
    float v = -0.030026099*na1.y + 0.23567812*nb1.y + -0.013640245*nc1.y + -0.21221665*nd1.y + 0.12864627*ne1.y + -0.03775464*nf1.y + -0.06271767*ng1.y + 0.1398742*nh1.y + -0.10901197*ni1.y;
    float w = -0.020543138*na1.z + 0.06967397*nb1.z + 0.046968646*nc1.z + -0.033888735*nd1.z + -0.034942474*ne1.z + 0.040396962*nf1.z + -0.018973283*ng1.z + -0.13343549*nh1.z + -0.040663805*ni1.z;
    float x = -0.033192288*na1.w + 0.044186935*nb1.w + 0.027151039*nc1.w + 0.11160459*nd1.w + -0.10746703*ne1.w + -0.0275698*nf1.w + 0.00025248327*ng1.w + -0.09284146*nh1.w + -4.7326103e-07*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0014252196;
    i = 0.06571178*a0.x + 0.08752779*b0.x + -0.091107346*c0.x + -0.19443138*d0.x + 0.17203617*e0.x + 0.05960761*f0.x + -0.1393299*g0.x + -0.0799575*h0.x + 0.08354188*i0.x;
    j = 0.038831577*a0.y + 0.071457274*b0.y + 0.060086038*c0.y + 0.07407433*d0.y + 0.37381777*e0.y + 0.32434905*f0.y + -0.04149505*g0.y + -0.06551896*h0.y + -0.013210035*i0.y;
    k = -0.109215535*a0.z + 0.21024004*b0.z + -0.019975739*c0.z + -0.13754839*d0.z + -0.061911196*e0.z + -0.032958355*f0.z + -0.0379819*g0.z + 0.10028795*h0.z + 0.06666433*i0.z;
    l = 0.016613448*a0.w + 0.012890488*b0.w + 0.053424753*c0.w + -0.026453787*d0.w + -0.023092046*e0.w + -0.06779156*f0.w + 0.0387629*g0.w + 0.0689873*h0.w + -0.020838996*i0.w;
    m = 0.009282248*a1.x + 0.023164941*b1.x + -0.056021832*c1.x + 0.10002012*d1.x + 0.07492648*e1.x + -0.019302674*f1.x + 0.04560832*g1.x + 0.05301786*h1.x + 0.052765965*i1.x;
    n = 0.12870239*a1.y + 0.029347612*b1.y + 0.08708535*c1.y + -0.05709532*d1.y + 0.045824323*e1.y + 0.17394269*f1.y + -0.008406947*g1.y + 0.010693501*h1.y + 0.06908317*i1.y;
    o = -0.019160919*a1.z + -0.023981726*b1.z + 0.022585778*c1.z + -0.07323051*d1.z + 0.36100793*e1.z + 0.16888963*f1.z + 0.10322411*g1.z + 0.09305132*h1.z + 0.042125456*i1.z;
    p = 0.0046699475*a1.w + 0.040598672*b1.w + -0.039084535*c1.w + -0.105519764*d1.w + -0.014312278*e1.w + 0.39844912*f1.w + 0.17213784*g1.w + 0.26695442*h1.w + 0.05388345*i1.w;
    q = -0.10016962*na0.x + -0.12659925*nb0.x + -0.03206459*nc0.x + 0.054242257*nd0.x + 0.02684625*ne0.x + 0.004823341*nf0.x + -0.017493445*ng0.x + 0.017013837*nh0.x + 0.08707511*ni0.x;
    r = -0.044897594*na0.y + -0.036943387*nb0.y + 0.06422842*nc0.y + -0.14496045*nd0.y + -0.37491864*ne0.y + -0.13676596*nf0.y + 0.002421831*ng0.y + 0.026525924*nh0.y + -0.014468307*ni0.y;
    s = 0.03307358*na0.z + -0.06645562*nb0.z + -0.10887851*nc0.z + 0.060231242*nd0.z + 0.094336696*ne0.z + 0.075766265*nf0.z + 0.0372266*ng0.z + -0.08996786*nh0.z + 0.04349408*ni0.z;
    t = 0.027824618*na0.w + 0.02099561*nb0.w + -0.20901664*nc0.w + 0.008137844*nd0.w + 0.1632197*ne0.w + 0.11545344*nf0.w + -0.02712516*ng0.w + -0.1053238*nh0.w + 0.030839035*ni0.w;
    u = -0.15002786*na1.x + -0.060460884*nb1.x + -0.052398346*nc1.x + -0.21840262*nd1.x + -0.28199655*ne1.x + -0.3273765*nf1.x + 0.0019613882*ng1.x + 0.011343327*nh1.x + -0.025745407*ni1.x;
    v = 0.089596294*na1.y + 0.09888554*nb1.y + -0.08620766*nc1.y + 0.09190667*nd1.y + 0.2761042*ne1.y + 0.06215537*nf1.y + -0.12014056*ng1.y + -0.13912943*nh1.y + -0.01775009*ni1.y;
    w = -0.0119106565*na1.z + 0.14187837*nb1.z + 0.01875191*nc1.z + 0.028395357*nd1.z + -0.23534073*ne1.z + -0.062408306*nf1.z + -0.037198827*ng1.z + -0.09503546*nh1.z + -0.012481542*ni1.z;
    x = 0.041350663*na1.w + 0.08808989*nb1.w + -0.039139986*nc1.w + 0.042839583*nd1.w + -0.14522356*ne1.w + -0.11225413*nf1.w + -0.013681964*ng1.w + -0.14814405*nh1.w + -0.08169235*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0063231788;
    i = 0.199979*a0.x + 0.23061875*b0.x + -0.10920823*c0.x + 0.2127411*d0.x + 0.4562264*e0.x + 0.36791566*f0.x + 0.0061307796*g0.x + -0.03753298*h0.x + 0.20458831*i0.x;
    j = -0.018984666*a0.y + 0.027848508*b0.y + 0.21057007*c0.y + -0.093486205*d0.y + 0.18769784*e0.y + 0.09004035*f0.y + -0.009871945*g0.y + 0.017700918*h0.y + -0.031650737*i0.y;
    k = 0.15855373*a0.z + -0.1765117*b0.z + 0.24707586*c0.z + -0.11049361*d0.z + 0.120230295*e0.z + -0.120945446*f0.z + -0.0063170996*g0.z + -0.09350059*h0.z + 0.02323171*i0.z;
    l = 0.08899516*a0.w + 0.19440293*b0.w + 0.013561043*c0.w + 0.1332691*d0.w + 0.9103674*e0.w + 0.07233763*f0.w + -0.047864635*g0.w + -0.010924825*h0.w + -0.054715794*i0.w;
    m = -0.07388303*a1.x + 0.21895209*b1.x + 0.010642248*c1.x + -0.1206663*d1.x + -0.0017110996*e1.x + 0.24471904*f1.x + -0.090800084*g1.x + 0.16108827*h1.x + 0.23052362*i1.x;
    n = -0.09725227*a1.y + 0.23545225*b1.y + -0.1309613*c1.y + -0.12544434*d1.y + 0.23154052*e1.y + -0.18917055*f1.y + 0.13009694*g1.y + -0.11781752*h1.y + 0.0010935594*i1.y;
    o = 0.0049910066*a1.z + 0.015982643*b1.z + -0.0061242487*c1.z + 0.11340745*d1.z + 0.37257516*e1.z + 0.043045927*f1.z + 0.06434129*g1.z + 0.21555494*h1.z + -0.0042368937*i1.z;
    p = 0.082077265*a1.w + 0.05672133*b1.w + -0.06472555*c1.w + -0.055614956*d1.w + -0.08767573*e1.w + -0.28633016*f1.w + -0.17009583*g1.w + 0.27785555*h1.w + 0.056071628*i1.w;
    q = 0.08759647*na0.x + -0.20314527*nb0.x + 0.15229012*nc0.x + 0.041185692*nd0.x + -0.23530194*ne0.x + -0.14208466*nf0.x + 0.11049026*ng0.x + 0.12073572*nh0.x + -0.0577295*ni0.x;
    r = 0.019904044*na0.y + 0.018032687*nb0.y + -0.13282707*nc0.y + -0.12976085*nd0.y + -0.0851056*ne0.y + -0.24886972*nf0.y + -0.17227782*ng0.y + 0.02357173*nh0.y + 0.082668714*ni0.y;
    s = 0.22471142*na0.z + -0.18081205*nb0.z + -0.08472062*nc0.z + 0.051625133*nd0.z + -0.3786994*ne0.z + 0.19139658*nf0.z + 0.0458613*ng0.z + -0.0066961776*nh0.z + -0.046551377*ni0.z;
    t = -0.1452213*na0.w + 0.09566916*nb0.w + -0.08075796*nc0.w + -0.20701256*nd0.w + -0.38712594*ne0.w + 0.066817015*nf0.w + -0.013330645*ng0.w + 0.004587282*nh0.w + 0.0044981963*ni0.w;
    u = -0.15362954*na1.x + 0.14077385*nb1.x + -0.023733815*nc1.x + 0.32859254*nd1.x + -0.26526156*ne1.x + -0.3064315*nf1.x + 0.03460431*ng1.x + -0.061959833*nh1.x + -0.25696978*ni1.x;
    v = 0.1043488*na1.y + 0.19938381*nb1.y + 0.35066408*nc1.y + 0.052177925*nd1.y + 0.25914505*ne1.y + 0.18082118*nf1.y + -0.13857333*ng1.y + 0.08814344*nh1.y + 0.08745096*ni1.y;
    w = -0.020234669*na1.z + 0.037020292*nb1.z + 0.16186818*nc1.z + -0.031144649*nd1.z + -0.30665946*ne1.z + 0.105531685*nf1.z + -0.04954673*ng1.z + 0.08786373*nh1.z + -0.123731464*ni1.z;
    x = -0.0112807825*na1.w + 0.017921103*nb1.w + 0.07448235*nc1.w + -0.08664955*nd1.w + 0.05499397*ne1.w + 0.014387606*nf1.w + 0.07323461*ng1.w + -0.114632644*nh1.w + -0.11618331*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013133188;
    i = 0.0597138*a0.x + -0.08610238*b0.x + -0.028665632*c0.x + -0.22173823*d0.x + -0.3086256*e0.x + -0.04300896*f0.x + -0.05005118*g0.x + -0.067843765*h0.x + -0.01712894*i0.x;
    j = -0.07549083*a0.y + -0.34679034*b0.y + 0.001367597*c0.y + -0.041651245*d0.y + -0.3563761*e0.y + 0.1272373*f0.y + -0.19311947*g0.y + 0.0062134555*h0.y + -0.03911722*i0.y;
    k = -0.10124364*a0.z + -0.1392256*b0.z + -0.025747765*c0.z + -0.17028576*d0.z + -0.04966502*e0.z + -0.068353444*f0.z + -0.06490578*g0.z + 0.19330779*h0.z + -0.15174128*i0.z;
    l = -0.045293238*a0.w + 0.28092697*b0.w + 0.15129393*c0.w + -0.0899719*d0.w + 0.22142841*e0.w + -0.012547027*f0.w + 0.14377733*g0.w + 0.022239886*h0.w + 0.0706811*i0.w;
    m = 0.004948647*a1.x + -0.07952092*b1.x + -0.005588038*c1.x + 0.080402285*d1.x + -0.1299574*e1.x + 0.102539904*f1.x + -0.00044476325*g1.x + -0.032420598*h1.x + -0.09282016*i1.x;
    n = 0.11100442*a1.y + 0.12993109*b1.y + 0.12758453*c1.y + 0.18054684*d1.y + 0.1392812*e1.y + -0.07014241*f1.y + -0.03861955*g1.y + 0.10125592*h1.y + 0.0038314038*i1.y;
    o = 0.06520557*a1.z + 0.006842835*b1.z + 0.01872246*c1.z + -0.21221244*d1.z + -0.04671243*e1.z + 0.101514*f1.z + -0.024837673*g1.z + 0.19408646*h1.z + 0.062211882*i1.z;
    p = 0.10764124*a1.w + 0.07714488*b1.w + -0.009523819*c1.w + -0.22998925*d1.w + -0.28999612*e1.w + 0.05397179*f1.w + 0.03093759*g1.w + -0.021440584*h1.w + 0.037218977*i1.w;
    q = -0.20570432*na0.x + 0.012709159*nb0.x + 0.09455498*nc0.x + -0.16358799*nd0.x + 0.3280718*ne0.x + 0.002596912*nf0.x + -0.0315085*ng0.x + -0.08436351*nh0.x + -0.00079569634*ni0.x;
    r = 0.09261593*na0.y + 0.19364753*nb0.y + -0.05850349*nc0.y + 0.11032683*nd0.y + 0.31128845*ne0.y + -0.11763885*nf0.y + 0.19743448*ng0.y + -0.01946789*nh0.y + 0.05673635*ni0.y;
    s = 0.033889174*na0.z + 0.107985765*nb0.z + 0.14049667*nc0.z + -0.00057227246*nd0.z + 0.16228116*ne0.z + 0.06535901*nf0.z + 0.08563815*ng0.z + -0.09778197*nh0.z + 0.060218997*ni0.z;
    t = 0.1382207*na0.w + -0.34366918*nb0.w + -0.07159504*nc0.w + 0.20757206*nd0.w + -0.15257928*ne0.w + 0.23665349*nf0.w + -0.0079668155*ng0.w + -0.03774751*nh0.w + 0.025174439*ni0.w;
    u = 0.05979023*na1.x + 0.21410039*nb1.x + 0.0277462*nc1.x + -0.14315857*nd1.x + -0.08927151*ne1.x + -0.023229988*nf1.x + -0.04333517*ng1.x + 0.0071403272*nh1.x + 0.120679095*ni1.x;
    v = 0.01266553*na1.y + -0.24217825*nb1.y + -0.06692956*nc1.y + 0.21709256*nd1.y + -0.2097772*ne1.y + 0.26281872*nf1.y + -0.029375581*ng1.y + -0.085459515*nh1.y + -0.008495006*ni1.y;
    w = -0.06465596*na1.z + 0.07665564*nb1.z + -0.019982971*nc1.z + 0.17086358*nd1.z + 0.023132043*ne1.z + -0.10599891*nf1.z + 0.07691751*ng1.z + -0.23248987*nh1.z + -0.13741273*ni1.z;
    x = -0.0106970705*na1.w + -0.11882599*nb1.w + -0.05005593*nc1.w + 0.028415836*nd1.w + -0.25891018*ne1.w + -0.04042173*nf1.w + -0.103319325*ng1.w + -0.05437728*nh1.w + -0.06257452*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.037121743;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN81

#define L0_tex LUMAN70_tex
#define L1_tex LUMAN71_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.0035594627*a0.x + 0.12038972*b0.x + 0.020664928*c0.x + -0.09564937*d0.x + -0.24571119*e0.x + 0.3238691*f0.x + 0.17325595*g0.x + 0.2563469*h0.x + 0.15742101*i0.x;
    float j = 0.047737293*a0.y + 0.12174407*b0.y + -0.0037528512*c0.y + 0.12503311*d0.y + -0.28859985*e0.y + 0.17565013*f0.y + -0.11089875*g0.y + 0.031075783*h0.y + -0.02618067*i0.y;
    float k = -0.19977969*a0.z + 0.14283116*b0.z + 0.13913913*c0.z + 0.041978117*d0.z + 0.41509438*e0.z + 0.1267442*f0.z + -0.040185302*g0.z + -0.022216653*h0.z + -0.022823509*i0.z;
    float l = -0.060234714*a0.w + -0.14831258*b0.w + 0.019350914*c0.w + 0.003702241*d0.w + 0.39907286*e0.w + 0.022984667*f0.w + 0.05545299*g0.w + -0.0787563*h0.w + -0.12892959*i0.w;
    float m = 0.08037066*a1.x + -0.18128945*b1.x + -0.03249607*c1.x + 0.068933845*d1.x + -0.30093843*e1.x + 0.2657856*f1.x + -0.059506405*g1.x + 0.08838455*h1.x + 0.17838779*i1.x;
    float n = 0.20739813*a1.y + -0.047565427*b1.y + -0.13744627*c1.y + 0.06407209*d1.y + -0.41378132*e1.y + 0.009229263*f1.y + -0.0034402746*g1.y + -0.08209963*h1.y + -0.02662598*i1.y;
    float o = -0.028428562*a1.z + -0.06263071*b1.z + -0.09687462*c1.z + -0.05370017*d1.z + -0.08132385*e1.z + 0.025406176*f1.z + 0.13680756*g1.z + -0.20903514*h1.z + -0.087057374*i1.z;
    float p = -0.059544336*a1.w + 0.17221068*b1.w + 0.019948697*c1.w + -0.021689683*d1.w + 0.35838723*e1.w + -0.02246449*f1.w + 0.009842488*g1.w + -0.08404416*h1.w + -0.14539391*i1.w;
    float q = 0.031368583*na0.x + -0.07873013*nb0.x + -0.048282783*nc0.x + 0.15330768*nd0.x + 0.13624837*ne0.x + 0.003489596*nf0.x + -0.06954451*ng0.x + -0.17785366*nh0.x + -0.21068935*ni0.x;
    float r = -0.10955879*na0.y + -0.07031983*nb0.y + 0.027158145*nc0.y + -0.10907232*nd0.y + -0.18709134*ne0.y + -0.044923406*nf0.y + 0.1491744*ng0.y + 0.22531477*nh0.y + 0.067887*ni0.y;
    float s = 0.007157718*na0.z + 0.047460496*nb0.z + -0.05114494*nc0.z + 0.17035486*nd0.z + -0.19792128*ne0.z + 0.0046278005*nf0.z + 0.000758805*ng0.z + -0.015741793*nh0.z + -0.00054501754*ni0.z;
    float t = 0.040760834*na0.w + 0.005885292*nb0.w + -0.063230574*nc0.w + -0.12301143*nd0.w + -0.36083934*ne0.w + -0.055142406*nf0.w + -0.009169166*ng0.w + 0.03937573*nh0.w + 0.06946885*ni0.w;
    float u = 0.013201956*na1.x + 0.08828739*nb1.x + -0.11232451*nc1.x + -0.19637825*nd1.x + 0.32704473*ne1.x + -0.13675223*nf1.x + 0.16928957*ng1.x + 0.05799959*nh1.x + -0.20515703*ni1.x;
    float v = -0.08137275*na1.y + 0.09916626*nb1.y + -0.03344903*nc1.y + -0.3554004*nd1.y + 0.1933217*ne1.y + -0.08688003*nf1.y + -0.037157822*ng1.y + 0.035184443*nh1.y + 0.04655514*ni1.y;
    float w = -0.010426424*na1.z + 0.06698642*nb1.z + -0.0063963337*nc1.z + -0.011602357*nd1.z + 0.0026813527*ne1.z + 0.16570611*nf1.z + -0.069919996*ng1.z + 0.09920697*nh1.z + 0.06005996*ni1.z;
    float x = 0.12693816*na1.w + 0.06537599*nb1.w + 0.0038803034*nc1.w + 0.101019114*nd1.w + -0.30651957*ne1.w + 0.07803141*nf1.w + -0.0045747124*ng1.w + 0.08764645*nh1.w + 0.046619754*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.021460632;
    i = 0.18408899*a0.x + -0.16826582*b0.x + 0.029110307*c0.x + 0.018517664*d0.x + -0.45409498*e0.x + -0.25322545*f0.x + -0.08358312*g0.x + -1.5571204e-05*h0.x + -0.030115725*i0.x;
    j = -0.095829435*a0.y + 0.0956517*b0.y + 0.030972734*c0.y + 0.07102308*d0.y + 0.2045019*e0.y + -0.025642421*f0.y + 0.023203015*g0.y + -0.054684825*h0.y + -0.07058941*i0.y;
    k = 0.15398344*a0.z + -0.058395036*b0.z + -0.014716754*c0.z + -0.010085025*d0.z + 0.0076141944*e0.z + 0.07213757*f0.z + 0.04619976*g0.z + -0.07169352*h0.z + 0.109850734*i0.z;
    l = -0.10673365*a0.w + -0.19558638*b0.w + -0.13687268*c0.w + 0.06683206*d0.w + 0.18710184*e0.w + -0.038076635*f0.w + 0.021108862*g0.w + 0.055217225*h0.w + 0.045482595*i0.w;
    m = -0.103124246*a1.x + 0.04979288*b1.x + -0.14140393*c1.x + 0.091398045*d1.x + 0.14379893*e1.x + -0.1343946*f1.x + 0.06328437*g1.x + 0.095048964*h1.x + 0.0053989524*i1.x;
    n = -0.28951663*a1.y + 0.04082115*b1.y + -0.041639026*c1.y + -0.08741475*d1.y + -0.4094756*e1.y + -0.046889693*f1.y + -0.048665598*g1.y + -0.016912755*h1.y + -0.065184765*i1.y;
    o = 0.041484993*a1.z + 0.062167954*b1.z + 0.13701159*c1.z + -0.0037448267*d1.z + -0.4012658*e1.z + 0.09107117*f1.z + 0.032375693*g1.z + 0.046596777*h1.z + -0.021694195*i1.z;
    p = -0.0657728*a1.w + -0.15465443*b1.w + 0.28652954*c1.w + 0.276086*d1.w + 0.82882595*e1.w + 0.40777725*f1.w + 0.21335135*g1.w + 0.12063082*h1.w + -0.067809604*i1.w;
    q = -0.07317296*na0.x + 0.12092801*nb0.x + -0.122033745*nc0.x + 0.1218021*nd0.x + 0.3748805*ne0.x + 0.02080968*nf0.x + -0.08659379*ng0.x + 0.06500288*nh0.x + 0.108286195*ni0.x;
    r = 0.18367934*na0.y + 0.0010851121*nb0.y + -0.0587228*nc0.y + -0.25490445*nd0.y + -0.14447315*ne0.y + 0.03789025*nf0.y + 0.04973444*ng0.y + 0.05696792*nh0.y + -0.15240029*ni0.y;
    s = -0.024720518*na0.z + 0.4245658*nb0.z + 0.12234191*nc0.z + 0.30536148*nd0.z + 0.2554897*ne0.z + 0.014799129*nf0.z + -0.015152688*ng0.z + -0.11416671*nh0.z + 0.04041433*ni0.z;
    t = -0.017217876*na0.w + -0.10715295*nb0.w + 0.005794767*nc0.w + -0.052738365*nd0.w + -0.152631*ne0.w + -0.013479686*nf0.w + -0.034019798*ng0.w + -0.05703783*nh0.w + -0.010331549*ni0.w;
    u = 0.098668344*na1.x + -0.25669348*nb1.x + -0.019031374*nc1.x + 0.017597904*nd1.x + 0.39555046*ne1.x + 0.21499567*nf1.x + -0.07296321*ng1.x + -0.26197156*nh1.x + -0.012222828*ni1.x;
    v = -0.039902315*na1.y + -0.41862145*nb1.y + 0.058357593*nc1.y + 0.1586242*nd1.y + 0.18992789*ne1.y + -0.051665388*nf1.y + -0.09742037*ng1.y + 0.06964658*nh1.y + 0.06772205*ni1.y;
    w = -0.06602748*na1.z + -0.097169474*nb1.z + -0.057414*nc1.z + -0.12144658*nd1.z + 0.54734033*ne1.z + -0.028030278*nf1.z + -0.018566564*ng1.z + -0.18564*nh1.z + 0.0925991*ni1.z;
    x = -0.15178564*na1.w + 0.0011031028*nb1.w + -0.015275681*nc1.w + -0.009574547*nd1.w + 0.10352668*ne1.w + 0.017580548*nf1.w + 0.024625003*ng1.w + -0.07591098*nh1.w + 0.014088646*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0060250857;
    i = 0.019011308*a0.x + 0.033444997*b0.x + -0.03581608*c0.x + -0.039397176*d0.x + -0.3690848*e0.x + 0.021864276*f0.x + -0.07867141*g0.x + 0.08434385*h0.x + -0.009090522*i0.x;
    j = 0.020657526*a0.y + 0.006953353*b0.y + -0.022416698*c0.y + 0.035708115*d0.y + 0.05767355*e0.y + -0.013203197*f0.y + 0.14224495*g0.y + 0.030157957*h0.y + -0.03581798*i0.y;
    k = 0.07780682*a0.z + -0.0585135*b0.z + -0.051630992*c0.z + -0.055939876*d0.z + 0.18262525*e0.z + -0.090132564*f0.z + 0.12991647*g0.z + -0.12535602*h0.z + 0.042218972*i0.z;
    l = 0.010307127*a0.w + 0.010460575*b0.w + 0.028567461*c0.w + 0.058343817*d0.w + 0.58971435*e0.w + 0.0068708695*f0.w + -0.00786947*g0.w + -0.09592207*h0.w + 0.029101066*i0.w;
    m = -0.04291295*a1.x + 0.066946365*b1.x + 0.008595295*c1.x + -0.019690137*d1.x + -0.1677645*e1.x + -0.034328867*f1.x + -0.048139174*g1.x + -0.059789807*h1.x + -0.066321395*i1.x;
    n = 0.03389471*a1.y + 0.26502246*b1.y + 0.18302165*c1.y + 0.09491692*d1.y + 0.021241223*e1.y + 0.17256165*f1.y + 0.0404323*g1.y + 0.0579923*h1.y + 0.005492218*i1.y;
    o = 0.0076889577*a1.z + 0.11564411*b1.z + 0.026385188*c1.z + 0.018606775*d1.z + -0.19530635*e1.z + -0.022276096*f1.z + 0.02216031*g1.z + 0.24999204*h1.z + -0.007822727*i1.z;
    p = -0.039314333*a1.w + 0.057142776*b1.w + 0.037845295*c1.w + 0.12005467*d1.w + 0.16426453*e1.w + 0.015574408*f1.w + -0.061150614*g1.w + -0.13893083*h1.w + 0.16615587*i1.w;
    q = -0.014885288*na0.x + -0.040328924*nb0.x + -0.05977982*nc0.x + 0.09812612*nd0.x + 0.19854964*ne0.x + -0.11895066*nf0.x + 0.010794935*ng0.x + -0.006710417*nh0.x + 0.068268105*ni0.x;
    r = 0.024664057*na0.y + 0.027309645*nb0.y + -0.00091027824*nc0.y + -0.08709317*nd0.y + -0.0052896333*ne0.y + 0.014205412*nf0.y + -0.14190152*ng0.y + -0.25411522*nh0.y + -0.0023517665*ni0.y;
    s = 0.02154945*na0.z + 0.12541628*nb0.z + -0.055260804*nc0.z + 0.03945718*nd0.z + -0.32898843*ne0.z + -0.011599959*nf0.z + -0.092199944*ng0.z + 0.15010926*nh0.z + 0.008878597*ni0.z;
    t = -0.049145244*na0.w + 0.08057064*nb0.w + -0.051043004*nc0.w + -0.046488475*nd0.w + -0.42943993*ne0.w + -0.05612305*nf0.w + -0.011810398*ng0.w + 0.086631544*nh0.w + -0.061234765*ni0.w;
    u = -0.19244489*na1.x + -0.11959134*nb1.x + 0.123622924*nc1.x + -0.052711625*nd1.x + -0.15718763*ne1.x + -0.22365978*nf1.x + -0.021615187*ng1.x + -0.08971221*nh1.x + 0.079056434*ni1.x;
    v = 0.04648465*na1.y + -0.2027671*nb1.y + -0.06965296*nc1.y + -0.12387141*nd1.y + 0.22138685*ne1.y + 0.021332582*nf1.y + 0.026996912*ng1.y + -0.103880666*nh1.y + -0.008200975*ni1.y;
    w = 0.03508963*na1.z + -0.08834725*nb1.z + 0.03435375*nc1.z + 0.03863173*nd1.z + 0.08056959*ne1.z + -0.0834241*nf1.z + -0.0147202825*ng1.z + -0.06330953*nh1.z + 0.012078014*ni1.z;
    x = -0.02340783*na1.w + 0.010710042*nb1.w + 0.02718297*nc1.w + -0.019940894*nd1.w + 0.00040069708*ne1.w + -0.10751297*nf1.w + 0.014186145*ng1.w + 0.039040815*nh1.w + -0.049185835*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.008812009;
    i = 0.07841893*a0.x + 0.30597758*b0.x + 0.039592993*c0.x + -0.1392278*d0.x + -0.18927181*e0.x + -0.25712314*f0.x + 0.16298722*g0.x + 0.0978296*h0.x + 0.014630055*i0.x;
    j = 0.017117297*a0.y + -0.17809464*b0.y + -0.18548822*c0.y + 0.2618222*d0.y + 0.1903122*e0.y + -0.10584681*f0.y + 0.12803845*g0.y + 0.12465525*h0.y + 0.0057999417*i0.y;
    k = -0.1265387*a0.z + -0.26912108*b0.z + -0.2629887*c0.z + 0.03371654*d0.z + -0.02986012*e0.z + -0.1738381*f0.z + 0.08100522*g0.z + -0.16834205*h0.z + 0.058091134*i0.z;
    l = -0.008767114*a0.w + 0.14262395*b0.w + 0.099189475*c0.w + -0.20450254*d0.w + 0.4196956*e0.w + 0.008576616*f0.w + -0.097148575*g0.w + -0.015517277*h0.w + -0.06573792*i0.w;
    m = 0.009081048*a1.x + -0.17330879*b1.x + 0.038787026*c1.x + -0.09260983*d1.x + -0.29981878*e1.x + -0.07358133*f1.x + -0.038811002*g1.x + -0.21674985*h1.x + 0.06779695*i1.x;
    n = 0.24578477*a1.y + 0.43307883*b1.y + 0.29414627*c1.y + 0.46770245*d1.y + 0.11255661*e1.y + 0.45453352*f1.y + 0.13660336*g1.y + 0.16075915*h1.y + 0.07823638*i1.y;
    o = 0.010055099*a1.z + 0.1257483*b1.z + 0.020316884*c1.z + -0.073165305*d1.z + -0.05080413*e1.z + -0.00898285*f1.z + 0.027939187*g1.z + 0.34161064*h1.z + 0.11474434*i1.z;
    p = 0.10480826*a1.w + 0.058347534*b1.w + -0.03916004*c1.w + -0.19853686*d1.w + -0.07113309*e1.w + 0.023121873*f1.w + -0.13254455*g1.w + -0.030065117*h1.w + 0.39155975*i1.w;
    q = -0.024030669*na0.x + -0.2835391*nb0.x + -0.2563511*nc0.x + 0.2444749*nd0.x + -0.08338291*ne0.x + -0.02303733*nf0.x + -0.048666645*ng0.x + -0.16980661*nh0.x + 0.14233974*ni0.x;
    r = 0.030986484*na0.y + 0.18971221*nb0.y + 0.019609256*nc0.y + -0.20937881*nd0.y + -0.07083975*ne0.y + 0.20925662*nf0.y + 0.021047208*ng0.y + -0.26694658*nh0.y + 0.021631766*ni0.y;
    s = -0.05092649*na0.z + 0.1003873*nb0.z + 0.0010154173*nc0.z + -0.30542678*nd0.z + -0.050651006*ne0.z + -0.08529883*nf0.z + -0.14873579*ng0.z + 0.28444654*nh0.z + -0.0868977*ni0.z;
    t = -0.07518888*na0.w + -0.08290228*nb0.w + -0.17608197*nc0.w + 0.023637211*nd0.w + -0.29993716*ne0.w + -0.038453452*nf0.w + 0.023888037*ng0.w + 0.060559735*nh0.w + 0.024841927*ni0.w;
    u = 0.036475975*na1.x + 0.26582122*nb1.x + 0.10916547*nc1.x + -0.09054858*nd1.x + 0.009491323*ne1.x + -0.067552604*nf1.x + 0.12836859*ng1.x + 0.002995043*nh1.x + -0.1530478*ni1.x;
    v = 0.11352374*na1.y + -0.039592106*nb1.y + -0.27043325*nc1.y + -0.4161087*nd1.y + -0.121836096*ne1.y + -0.11972322*nf1.y + 0.055229824*ng1.y + -0.16489632*nh1.y + 0.04047813*ni1.y;
    w = -0.039167922*na1.z + -0.06771886*nb1.z + 0.015467069*nc1.z + 0.034550667*nd1.z + 0.05691168*ne1.z + -0.09975041*nf1.z + -0.110027954*ng1.z + -0.22872053*nh1.z + 0.05507539*ni1.z;
    x = 0.007246742*na1.w + -0.09148137*nb1.w + 0.028967854*nc1.w + 0.0964552*nd1.w + -0.29469356*ne1.w + -0.14045818*nf1.w + 0.015332315*ng1.w + -0.04409656*nh1.w + -0.08756743*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0046669585;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!SAVE LUMAN90

#define L0_tex LUMAN80_tex
#define L1_tex LUMAN81_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.014250411*a0.x + -0.04238529*b0.x + -0.021654928*c0.x + -0.061056126*d0.x + 0.12432481*e0.x + -0.11172919*f0.x + 0.025456348*g0.x + 0.17375225*h0.x + -0.05928882*i0.x;
    float j = -0.0069310674*a0.y + -0.17002995*b0.y + 0.014071309*c0.y + -0.08017034*d0.y + -0.15927497*e0.y + -0.13709296*f0.y + 0.03015211*g0.y + -0.10931449*h0.y + -0.07531325*i0.y;
    float k = 0.085528105*a0.z + 0.07321134*b0.z + 0.04415391*c0.z + -0.060957205*d0.z + 0.20358115*e0.z + -0.0310266*f0.z + -0.06125441*g0.z + -0.01778268*h0.z + 0.058718406*i0.z;
    float l = 0.020323409*a0.w + 0.12131576*b0.w + 0.034877058*c0.w + 0.026528962*d0.w + 0.29414418*e0.w + -0.048116814*f0.w + 0.03937826*g0.w + 0.027733173*h0.w + 0.10065619*i0.w;
    float m = 0.084621675*a1.x + 0.08532275*b1.x + 0.015778627*c1.x + 0.097194195*d1.x + 0.4112123*e1.x + 0.27921355*f1.x + 0.10588195*g1.x + 0.053417943*h1.x + 0.09885509*i1.x;
    float n = 0.07387635*a1.y + -0.055011578*b1.y + 0.039572112*c1.y + -0.076339245*d1.y + 0.31344843*e1.y + -0.05918905*f1.y + -0.074291565*g1.y + 0.04840767*h1.y + 0.06758669*i1.y;
    float o = -0.10437262*a1.z + 0.06825754*b1.z + 0.056765143*c1.z + 0.021697484*d1.z + 0.45190138*e1.z + 0.2427271*f1.z + 0.062085584*g1.z + 0.28484273*h1.z + -0.094032384*i1.z;
    float p = 0.04813119*a1.w + 0.007050882*b1.w + -0.052815583*c1.w + -0.09500402*d1.w + 0.14369574*e1.w + 0.019362302*f1.w + -0.13984235*g1.w + 0.02537242*h1.w + 0.05735736*i1.w;
    float q = 0.03274758*na0.x + 0.029267251*nb0.x + 0.053376034*nc0.x + 0.08079781*nd0.x + 0.025893819*ne0.x + 0.26118472*nf0.x + -0.008455075*ng0.x + -0.10138187*nh0.x + 0.13818091*ni0.x;
    float r = 0.012862027*na0.y + 0.0727372*nb0.y + 0.051430516*nc0.y + 0.023545163*nd0.y + 0.15226619*ne0.y + 0.08326266*nf0.y + -0.03657906*ng0.y + 0.098245256*nh0.y + 0.1295563*ni0.y;
    float s = -0.072070636*na0.z + -0.04813981*nb0.z + -0.016097464*nc0.z + -0.08242316*nd0.z + -0.3567517*ne0.z + -0.05599013*nf0.z + -0.028758992*ng0.z + -0.02239777*nh0.z + -0.11760277*ni0.z;
    float t = -0.016802538*na0.w + -0.0019249133*nb0.w + -0.038664613*nc0.w + 0.052025173*nd0.w + -0.35645428*ne0.w + 0.15000045*nf0.w + 0.039396226*ng0.w + -0.036765695*nh0.w + -0.05118801*ni0.w;
    float u = -0.036604054*na1.x + -0.023219982*nb1.x + 0.007530918*nc1.x + 0.04736719*nd1.x + -0.42611703*ne1.x + -0.06174241*nf1.x + -0.03890206*ng1.x + 0.01575828*nh1.x + -0.0248451*ni1.x;
    float v = -0.08923639*na1.y + -0.0043441607*nb1.y + -0.12167136*nc1.y + 0.027899772*nd1.y + -0.40207592*ne1.y + -0.056410473*nf1.y + 0.044626288*ng1.y + -0.12881693*nh1.y + -0.07811622*ni1.y;
    float w = 0.14602704*na1.z + -0.028811814*nb1.z + -0.01618901*nc1.z + -0.012422737*nd1.z + -0.3331145*ne1.z + -0.1610778*nf1.z + -0.08348008*ng1.z + -0.059223644*nh1.z + 0.036051374*ni1.z;
    float x = -0.012505048*na1.w + 0.059638865*nb1.w + -0.015351817*nc1.w + 0.10810725*nd1.w + -0.15226439*ne1.w + 0.006934493*nf1.w + 0.07647251*ng1.w + -0.00703516*nh1.w + -0.04167374*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.021942647;
    i = 0.20880799*a0.x + -0.18952975*b0.x + 0.0410574*c0.x + -0.20322348*d0.x + -0.1942575*e0.x + -0.36810294*f0.x + -0.030349163*g0.x + -0.0241354*h0.x + -0.23881352*i0.x;
    j = -0.15908454*a0.y + 0.023425695*b0.y + -0.05800883*c0.y + -0.22789474*d0.y + 0.13597105*e0.y + 0.12843077*f0.y + -0.2070944*g0.y + -0.09183324*h0.y + 0.1198077*i0.y;
    k = 0.063545085*a0.z + -0.07194285*b0.z + 0.03841072*c0.z + -0.06573369*d0.z + -0.3593671*e0.z + -0.033107173*f0.z + 0.048501916*g0.z + 0.12236352*h0.z + -0.08455477*i0.z;
    l = 0.10424859*a0.w + 0.14661445*b0.w + 0.111417264*c0.w + 0.23561446*d0.w + -0.16151448*e0.w + -0.059149202*f0.w + 0.09560583*g0.w + 0.14111574*h0.w + -0.0135328695*i0.w;
    m = 0.0135551775*a1.x + -0.23273508*b1.x + 0.06987079*c1.x + -0.17985173*d1.x + -0.2573105*e1.x + 0.05890961*f1.x + 0.07531258*g1.x + -0.34863085*h1.x + -0.028425023*i1.x;
    n = 0.13816424*a1.y + -0.16184004*b1.y + 0.0059585655*c1.y + 0.3248018*d1.y + -0.055002954*e1.y + 0.05005296*f1.y + 0.11523584*g1.y + -0.07849374*h1.y + -0.028928319*i1.y;
    o = 0.07822528*a1.z + 0.18937865*b1.z + 0.08215902*c1.z + 0.1685611*d1.z + 0.027695673*e1.z + 0.073200606*f1.z + 0.023770861*g1.z + -0.016103616*h1.z + -0.0063722*i1.z;
    p = -0.09772434*a1.w + -0.27336553*b1.w + -0.09073844*c1.w + 0.1401914*d1.w + -0.115432434*e1.w + -0.03692059*f1.w + -0.13910747*g1.w + -0.105095066*h1.w + -0.07490761*i1.w;
    q = 0.039422616*na0.x + 0.19641484*nb0.x + -0.12821025*nc0.x + 0.24219863*nd0.x + -0.17712165*ne0.x + -0.026652308*nf0.x + -0.0058854646*ng0.x + 0.16638958*nh0.x + 0.17476979*ni0.x;
    r = -0.19964898*na0.y + 0.14522126*nb0.y + 0.017497417*nc0.y + 0.11976333*nd0.y + -0.2522856*ne0.y + -0.1015291*nf0.y + 0.119959936*ng0.y + 0.13133897*nh0.y + -0.070109226*ni0.y;
    s = 0.09179825*na0.z + 0.14095272*nb0.z + -0.040753435*nc0.z + 0.105170004*nd0.z + 0.4636101*ne0.z + -0.017486215*nf0.z + -0.1678732*ng0.z + 0.05558729*nh0.z + 0.064954616*ni0.z;
    t = -0.10586936*na0.w + -0.109147035*nb0.w + -0.08276189*nc0.w + 0.19918762*nd0.w + 0.035725277*ne0.w + 0.007809945*nf0.w + -0.07378703*ng0.w + -0.13827443*nh0.w + 0.023840806*ni0.w;
    u = -0.09291025*na1.x + 0.061407644*nb1.x + -0.0075824033*nc1.x + 0.11242122*nd1.x + 0.22942492*ne1.x + -0.04565064*nf1.x + -0.10208078*ng1.x + 0.2990975*nh1.x + 0.055351995*ni1.x;
    v = -0.08343257*na1.y + 0.076851636*nb1.y + -0.014935781*nc1.y + -0.288692*nd1.y + 0.22209394*ne1.y + 0.022718837*nf1.y + -0.14564*ng1.y + -0.114482984*nh1.y + 0.1302801*ni1.y;
    w = -0.06583774*na1.z + -0.18053466*nb1.z + -0.04791139*nc1.z + -0.17584006*nd1.z + -0.026865056*ne1.z + -0.10923432*nf1.z + 0.018325653*ng1.z + -0.14700639*nh1.z + -0.109260954*ni1.z;
    x = 0.1805816*na1.w + 0.12407404*nb1.w + -0.010269265*nc1.w + -0.27490416*nd1.w + 0.2293687*ne1.w + 0.08178526*nf1.w + -0.099873096*ng1.w + 0.11110855*nh1.w + 0.093538925*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.03860623;
    i = 0.048178677*a0.x + 0.13495404*b0.x + 0.027020844*c0.x + 0.017530996*d0.x + -0.26472944*e0.x + -0.32675788*f0.x + -0.0057494543*g0.x + -0.18215506*h0.x + 0.1866843*i0.x;
    j = -0.04042012*a0.y + -0.12528907*b0.y + -0.13585721*c0.y + -0.09324433*d0.y + -0.16377172*e0.y + -0.19642009*f0.y + 0.015814828*g0.y + -0.13511328*h0.y + 0.061218485*i0.y;
    k = 0.017718524*a0.z + 0.102305256*b0.z + 0.051078156*c0.z + 0.096709035*d0.z + 0.035923813*e0.z + -0.05596279*f0.z + 0.007461312*g0.z + -0.04832589*h0.z + -0.019453974*i0.z;
    l = 0.06610844*a0.w + -0.08446715*b0.w + -0.13854147*c0.w + -0.018506333*d0.w + 0.32768026*e0.w + 0.21792646*f0.w + -0.021454493*g0.w + 0.0113977585*h0.w + -0.0026054222*i0.w;
    m = 0.036436006*a1.x + 0.21372306*b1.x + 0.035791337*c1.x + -0.0029260095*d1.x + 0.21363598*e1.x + 0.11290417*f1.x + 0.06586176*g1.x + 0.1271434*h1.x + -0.059509236*i1.x;
    n = -0.027422298*a1.y + 0.086997196*b1.y + 0.07657817*c1.y + 0.06558545*d1.y + 0.17395905*e1.y + -0.0073790425*f1.y + 0.01611407*g1.y + 0.06993937*h1.y + -0.0010416611*i1.y;
    o = 0.0566174*a1.z + 0.035436492*b1.z + 0.042210266*c1.z + -0.04705494*d1.z + 0.41050985*e1.z + 0.1575727*f1.z + 0.06430424*g1.z + 0.09085263*h1.z + 0.045363627*i1.z;
    p = 0.02746632*a1.w + 0.06629101*b1.w + 0.15184079*c1.w + -0.010816606*d1.w + -0.19920473*e1.w + -0.0012358276*f1.w + 0.11645233*g1.w + 0.15866442*h1.w + 0.041020997*i1.w;
    q = -0.038356394*na0.x + 0.0496738*nb0.x + 0.089799084*nc0.x + -0.078450546*nd0.x + 0.19574346*ne0.x + 0.14296131*nf0.x + 0.02093717*ng0.x + 0.29675344*nh0.x + 0.007171671*ni0.x;
    r = 0.06651706*na0.y + 0.04813143*nb0.y + 0.10353286*nc0.y + 0.21231888*nd0.y + 0.07545394*ne0.y + 0.20412438*nf0.y + 0.0012885222*ng0.y + 0.15668026*nh0.y + 0.029278977*ni0.y;
    s = 0.047485173*na0.z + -0.050391153*nb0.z + -0.011836611*nc0.z + -0.10038617*nd0.z + -0.05150043*ne0.z + 0.10383776*nf0.z + -0.04044264*ng0.z + 0.056759108*nh0.z + 0.01960355*ni0.z;
    t = -0.057880625*na0.w + 0.062443256*nb0.w + 0.1461875*nc0.w + -0.048376605*nd0.w + -0.5428768*ne0.w + -0.22234322*nf0.w + 0.029686691*ng0.w + 0.006077662*nh0.w + -0.016965399*ni0.w;
    u = -0.061339878*na1.x + -0.22763349*nb1.x + -0.023490407*nc1.x + -0.008404945*nd1.x + -0.25364682*ne1.x + -0.059010275*nf1.x + -0.0016836784*ng1.x + -0.14596754*nh1.x + -0.07762156*ni1.x;
    v = 0.038167924*na1.y + 0.03796828*nb1.y + 0.01749249*nc1.y + -0.02317157*nd1.y + -0.17835931*ne1.y + 0.114591315*nf1.y + 0.027806472*ng1.y + -0.12774202*nh1.y + -0.043270994*ni1.y;
    w = 0.009977157*na1.z + 0.046160668*nb1.z + 0.075068384*nc1.z + 0.18530163*nd1.z + -0.42971575*ne1.z + -0.10997692*nf1.z + 0.01309119*ng1.z + 0.103382744*nh1.z + -0.051152173*ni1.z;
    x = 0.008308241*na1.w + 0.112016656*nb1.w + -0.03204292*nc1.w + -0.03667412*nd1.w + 0.05480717*ne1.w + -0.021357488*nf1.w + -0.0192476*ng1.w + -0.041222185*nh1.w + -0.03899985*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.05658022;
    i = 0.030151002*a0.x + 0.1860666*b0.x + -0.0022055737*c0.x + -0.13249823*d0.x + -0.07754814*e0.x + 0.11103858*f0.x + -0.25461784*g0.x + -0.23121211*h0.x + 0.13869268*i0.x;
    j = 0.02170408*a0.y + -0.0014520105*b0.y + -0.0075796046*c0.y + 0.007614655*d0.y + -0.24949898*e0.y + 0.008160589*f0.y + -0.07433261*g0.y + 0.12531595*h0.y + -0.025806854*i0.y;
    k = -0.1143635*a0.z + 0.07558083*b0.z + 0.06544773*c0.z + 0.009476022*d0.z + -0.11959558*e0.z + 0.046458866*f0.z + -0.070280805*g0.z + 0.061093763*h0.z + 0.063683785*i0.z;
    l = -0.022641785*a0.w + -0.29642823*b0.w + -0.18833381*c0.w + -0.14111918*d0.w + 0.10596381*e0.w + -0.018907588*f0.w + -0.054916237*g0.w + -0.18433844*h0.w + 0.017380793*i0.w;
    m = 0.10092058*a1.x + 0.12342665*b1.x + -0.14488818*c1.x + -0.094983876*d1.x + -0.13887641*e1.x + -0.31285325*f1.x + -0.30513728*g1.x + 0.008164597*h1.x + -0.02678668*i1.x;
    n = -0.10522648*a1.y + 0.083025984*b1.y + 0.058566112*c1.y + 0.100287765*d1.y + -0.18487187*e1.y + 0.061653536*f1.y + -0.004182874*g1.y + 0.21625677*h1.y + 0.043687273*i1.y;
    o = 0.1626286*a1.z + -0.0571527*b1.z + -0.13826865*c1.z + 0.057854813*d1.z + -0.08257844*e1.z + 0.0632713*f1.z + -0.052715078*g1.z + -0.2670316*h1.z + -0.12404669*i1.z;
    p = 0.022306629*a1.w + -0.2257537*b1.w + -0.12413365*c1.w + 0.010597138*d1.w + -0.15639839*e1.w + 0.043527965*f1.w + 0.045449335*g1.w + 0.059061706*h1.w + 0.101682454*i1.w;
    q = 0.061564334*na0.x + -0.14031292*nb0.x + -0.014025187*nc0.x + 0.17911491*nd0.x + 0.33740097*ne0.x + 0.20792083*nf0.x + 0.24080946*ng0.x + 0.3538365*nh0.x + 0.05306646*ni0.x;
    r = -0.14772856*na0.y + 0.018438019*nb0.y + -0.036556922*nc0.y + -0.13800567*nd0.y + 0.02649721*ne0.y + -0.022540266*nf0.y + 0.052261878*ng0.y + -0.027467266*nh0.y + 0.03414223*ni0.y;
    s = 0.031204998*na0.z + 0.041114077*nb0.z + 0.007792205*nc0.z + 0.08775103*nd0.z + 0.064216435*ne0.z + 0.068528414*nf0.z + 0.09969219*ng0.z + 0.12135939*nh0.z + -0.094426885*ni0.z;
    t = 0.10184967*na0.w + 0.123821415*nb0.w + 0.13014457*nc0.w + -0.027768346*nd0.w + -0.23585244*ne0.w + -0.05916951*nf0.w + 0.08106088*ng0.w + 0.1933105*nh0.w + 0.049981385*ni0.w;
    u = -0.11509542*na1.x + -0.21260747*nb1.x + 0.10034503*nc1.x + -0.05343281*nd1.x + -0.16148616*ne1.x + 0.06921768*nf1.x + 0.1018865*ng1.x + -0.18180113*nh1.x + -0.0019478599*ni1.x;
    v = 0.12437264*na1.y + 0.08438361*nb1.y + 0.029054416*nc1.y + -0.078915*nd1.y + 0.43418276*ne1.y + 0.088424504*nf1.y + 0.11200839*ng1.y + 0.04359535*nh1.y + -0.060695816*ni1.y;
    w = -0.14184491*na1.z + 0.009048718*nb1.z + -0.0015884426*nc1.z + -0.051001117*nd1.z + 0.12083191*ne1.z + 0.08521108*nf1.z + -0.15348539*ng1.z + 0.2449776*nh1.z + 0.10972097*ni1.z;
    x = 0.022142269*na1.w + 0.064288594*nb1.w + 0.10567636*nc1.w + 0.029814683*nd1.w + 0.3069626*ne1.w + -0.112773694*nf1.w + 0.0067777424*ng1.w + -0.049251463*nh1.w + -0.1269242*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.02718557;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!SAVE LUMAN91

#define L0_tex LUMAN80_tex
#define L1_tex LUMAN81_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.064591184*a0.x + -0.086834244*b0.x + 0.012061734*c0.x + 0.0076904036*d0.x + -0.006779139*e0.x + -0.11930803*f0.x + 0.064743415*g0.x + 0.061578117*h0.x + 0.07282739*i0.x;
    float j = -0.038720116*a0.y + 0.2914675*b0.y + -0.08511401*c0.y + -0.27763*d0.y + -0.2341029*e0.y + -0.14690943*f0.y + 0.11503797*g0.y + 0.11770579*h0.y + -0.0988632*i0.y;
    float k = -0.054292727*a0.z + 0.13346374*b0.z + 0.006554269*c0.z + 0.085298486*d0.z + 0.09256209*e0.z + 0.086568855*f0.z + -0.056956228*g0.z + 0.048038904*h0.z + -0.04360846*i0.z;
    float l = 0.014501069*a0.w + -0.06803215*b0.w + 0.0285929*c0.w + 0.057434857*d0.w + 0.06706903*e0.w + 0.03170341*f0.w + -0.07010804*g0.w + -0.013323503*h0.w + 0.05878082*i0.w;
    float m = -0.117725275*a1.x + -0.115913525*b1.x + 0.030663729*c1.x + 0.014097233*d1.x + -0.0011461431*e1.x + 0.04074681*f1.x + -0.04886523*g1.x + 0.014650436*h1.x + -0.017686432*i1.x;
    float n = -0.034699902*a1.y + 0.04545689*b1.y + -0.0077859196*c1.y + 0.026581103*d1.y + 0.13295728*e1.y + 0.061012458*f1.y + -0.031488042*g1.y + 0.01683447*h1.y + -0.07727207*i1.y;
    float o = 0.1326936*a1.z + -0.19639158*b1.z + 0.0724299*c1.z + -0.16482691*d1.z + 0.02623066*e1.z + -0.18723568*f1.z + -0.07948423*g1.z + -0.08207342*h1.z + -0.014039538*i1.z;
    float p = -0.11302887*a1.w + -0.120441064*b1.w + 0.014967283*c1.w + -0.054630496*d1.w + 0.01606148*e1.w + 0.12035976*f1.w + -0.012942233*g1.w + -0.08405828*h1.w + -0.05511723*i1.w;
    float q = 0.10044998*na0.x + 0.07703357*nb0.x + 0.027168838*nc0.x + -0.0712459*nd0.x + -0.12783852*ne0.x + -0.0038406162*nf0.x + 0.00017533907*ng0.x + -0.17575473*nh0.x + -0.104728825*ni0.x;
    float r = -0.09326989*na0.y + -0.035516493*nb0.y + 0.044787653*nc0.y + 0.07938428*nd0.y + 0.10040959*ne0.y + 0.06931848*nf0.y + -0.12684844*ng0.y + 0.068755575*nh0.y + 0.08830972*ni0.y;
    float s = 0.09743182*na0.z + -0.08618764*nb0.z + -0.09308724*nc0.z + -0.21439748*nd0.z + 0.17929722*ne0.z + -0.13537686*nf0.z + 0.030094212*ng0.z + -0.008233488*nh0.z + 0.026675478*ni0.z;
    float t = -0.05652852*na0.w + 0.023983918*nb0.w + -0.023069844*nc0.w + -0.0070350813*nd0.w + -0.07495373*ne0.w + 0.0109437145*nf0.w + 0.05085677*ng0.w + 0.0018807751*nh0.w + -0.08273237*ni0.w;
    float u = 0.13703896*na1.x + -0.028061252*nb1.x + 0.00063145265*nc1.x + 0.009538742*nd1.x + -0.043253537*ne1.x + 0.008935095*nf1.x + -0.011389033*ng1.x + -0.06325763*nh1.x + 0.059068896*ni1.x;
    float v = 0.007938014*na1.y + -0.13704681*nb1.y + 0.0051192725*nc1.y + -0.06970636*nd1.y + -0.16930172*ne1.y + -0.15330653*nf1.y + 0.016541267*ng1.y + -0.03627275*nh1.y + 0.06254857*ni1.y;
    float w = -0.10841602*na1.z + 0.4269225*nb1.z + -0.060182836*nc1.z + 0.1342713*nd1.z + 0.2973204*ne1.z + 0.22778602*nf1.z + -0.034208667*ng1.z + 0.12098727*nh1.z + 0.109278105*ni1.z;
    float x = 0.1323955*na1.w + 0.041602165*nb1.w + 0.0026513515*nc1.w + 0.064577274*nd1.w + -0.027596513*ne1.w + -0.12952392*nf1.w + -0.044943932*ng1.w + -0.115508705*nh1.w + 0.015716452*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.001778901;
    i = -0.18303195*a0.x + 0.1389399*b0.x + 0.05330645*c0.x + -0.024218678*d0.x + 0.1059723*e0.x + 0.1203514*f0.x + -0.02386567*g0.x + 0.23077035*h0.x + 0.1551605*i0.x;
    j = 0.069662265*a0.y + 0.085549094*b0.y + -0.12123253*c0.y + -0.28440872*d0.y + -0.06886727*e0.y + -0.091464095*f0.y + 0.09047435*g0.y + 0.04713467*h0.y + -0.12803286*i0.y;
    k = 0.090718895*a0.z + 0.16950507*b0.z + -0.17583397*c0.z + 0.06353087*d0.z + 0.19189116*e0.z + -0.177356*f0.z + -0.048778914*g0.z + -0.027957806*h0.z + 0.06524524*i0.z;
    l = -0.15416801*a0.w + 0.2759223*b0.w + 0.1523193*c0.w + 0.144094*d0.w + 0.10375921*e0.w + 0.15397213*f0.w + 0.054405753*g0.w + 0.14805214*h0.w + 0.10322183*i0.w;
    m = -0.0021164522*a1.x + -0.16641104*b1.x + 0.12112933*c1.x + 0.05051385*d1.x + 0.15445024*e1.x + -0.05820697*f1.x + -0.26677763*g1.x + 0.051000446*h1.x + 0.106548235*i1.x;
    n = 0.09640368*a1.y + 0.14900348*b1.y + -0.1645799*c1.y + -0.12446157*d1.y + -0.12338426*e1.y + -0.16234943*f1.y + -0.08553169*g1.y + -0.032980308*h1.y + 0.1385679*i1.y;
    o = -0.27444258*a1.z + -0.20495611*b1.z + 0.087560005*c1.z + -0.17420256*d1.z + 0.4487924*e1.z + 0.16391318*f1.z + -0.21524991*g1.z + 0.08579062*h1.z + 0.11324684*i1.z;
    p = -0.006945982*a1.w + 0.34025064*b1.w + 0.22788335*c1.w + -0.011148917*d1.w + -0.018800734*e1.w + -0.15528628*f1.w + 0.07209469*g1.w + -0.12760407*h1.w + 0.037804488*i1.w;
    q = 0.08400994*na0.x + -0.17910519*nb0.x + 0.109973855*nc0.x + 0.0025310386*nd0.x + 0.056285445*ne0.x + -0.20070016*nf0.x + -0.11361203*ng0.x + -0.31314817*nh0.x + -0.13633983*ni0.x;
    r = 0.16386716*na0.y + -0.14517657*nb0.y + 0.11007822*nc0.y + 0.24017836*nd0.y + 0.35474586*ne0.y + 0.32407668*nf0.y + 0.037026286*ng0.y + -0.14789234*nh0.y + 0.07844272*ni0.y;
    s = -0.16014752*na0.z + -0.2903345*nb0.z + 0.1348327*nc0.z + -0.049009476*nd0.z + 0.025261475*ne0.z + 0.20215334*nf0.z + -0.050232634*ng0.z + -0.13409953*nh0.z + -0.04761971*ni0.z;
    t = 0.057999365*na0.w + -0.31749207*nb0.w + -0.031203046*nc0.w + -0.32174772*nd0.w + 0.081764035*ne0.w + -0.15557414*nf0.w + 0.040715005*ng0.w + -0.11489052*nh0.w + 0.009872706*ni0.w;
    u = 0.073866144*na1.x + 0.08986749*nb1.x + -0.11700794*nc1.x + -0.13253777*nd1.x + -0.06588698*ne1.x + -0.063383356*nf1.x + 0.15730932*ng1.x + -0.07174025*nh1.x + -0.13080357*ni1.x;
    v = -0.15654103*na1.y + -0.061252818*nb1.y + 0.32725814*nc1.y + 0.15096447*nd1.y + 0.40280807*ne1.y + 0.24929035*nf1.y + 0.15287307*ng1.y + 0.13057452*nh1.y + -0.18048123*ni1.y;
    w = 0.33798084*na1.z + 0.02931741*nb1.z + -0.07852497*nc1.z + 0.38193208*nd1.z + -0.06619199*ne1.z + -0.21040082*nf1.z + 0.068854*ng1.z + -0.2469383*nh1.z + -0.08334495*ni1.z;
    x = -0.02454442*na1.w + -0.3080107*nb1.w + -0.03530862*nc1.w + 0.041308373*nd1.w + 0.14073959*ne1.w + 0.20617355*nf1.w + -0.043657694*ng1.w + 0.13304688*nh1.w + 0.03679344*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.015583766;
    i = 0.031398952*a0.x + 0.04189893*b0.x + 0.19730887*c0.x + 0.08555677*d0.x + -0.18717846*e0.x + 0.22618406*f0.x + -0.052923724*g0.x + 0.09675072*h0.x + -0.076768704*i0.x;
    j = 0.11788979*a0.y + -0.15309438*b0.y + -0.04075275*c0.y + -0.110383265*d0.y + -0.48619998*e0.y + 0.07023799*f0.y + 0.10708083*g0.y + 0.26446325*h0.y + -0.048599552*i0.y;
    k = 0.052632306*a0.z + 0.020550659*b0.z + -0.019962313*c0.z + 0.056734044*d0.z + 0.20157674*e0.z + 0.13263007*f0.z + -0.046961598*g0.z + -0.09691325*h0.z + 0.0531848*i0.z;
    l = 0.101675026*a0.w + 0.27784944*b0.w + 0.12324177*c0.w + -0.07068762*d0.w + 0.0818228*e0.w + -0.09321215*f0.w + -0.11643468*g0.w + -0.102201894*h0.w + -0.072663896*i0.w;
    m = -0.071761504*a1.x + 0.029838279*b1.x + -0.11154797*c1.x + 0.07294159*d1.x + 0.4818034*e1.x + -0.5087342*f1.x + -0.112223916*g1.x + -0.28908643*h1.x + -0.08666744*i1.x;
    n = 0.014254376*a1.y + -0.06831736*b1.y + -0.02225946*c1.y + -0.061442286*d1.y + -0.21341231*e1.y + 0.07420914*f1.y + -0.020930115*g1.y + -0.23098978*h1.y + 0.047968682*i1.y;
    o = -0.12318773*a1.z + 0.16779573*b1.z + 0.060841598*c1.z + -0.13125354*d1.z + 0.5366516*e1.z + 0.13552463*f1.z + -0.16648643*g1.z + -0.5225955*h1.z + 0.20588054*i1.z;
    p = 0.021681841*a1.w + 0.0147839105*b1.w + -0.07116525*c1.w + -0.11239224*d1.w + -0.28134072*e1.w + -0.20774683*f1.w + -0.056640606*g1.w + -0.20807342*h1.w + -0.14187394*i1.w;
    q = -0.10805369*na0.x + -0.17083731*nb0.x + -0.122314125*nc0.x + -0.17160355*nd0.x + -0.03651102*ne0.x + -0.3779597*nf0.x + 0.14284317*ng0.x + 0.07732665*nh0.x + -0.05547113*ni0.x;
    r = 0.0049363286*na0.y + 0.063314065*nb0.y + 0.12015747*nc0.y + 0.027678438*nd0.y + 0.40603974*ne0.y + 0.15798166*nf0.y + -0.12128637*ng0.y + -0.34773082*nh0.y + -0.15439473*ni0.y;
    s = -0.104180954*na0.z + -0.06222233*nb0.z + 0.03805832*nc0.z + 0.0090491325*nd0.z + -0.23674521*ne0.z + 0.073091164*nf0.z + 0.092849016*ng0.z + -0.101051524*nh0.z + 0.09585388*ni0.z;
    t = -0.08372517*na0.w + -0.23765321*nb0.w + -0.11047642*nc0.w + -0.09844205*nd0.w + -0.001197135*ne0.w + 0.05874671*nf0.w + 0.04448913*ng0.w + 0.17621781*nh0.w + 0.15660878*ni0.w;
    u = -0.06192374*na1.x + -0.23233692*nb1.x + 0.028859159*nc1.x + -0.21800128*nd1.x + -0.44495392*ne1.x + 0.16226628*nf1.x + 0.059766024*ng1.x + 0.040463783*nh1.x + -0.012325476*ni1.x;
    v = -0.046759803*na1.y + 0.14202406*nb1.y + 0.17334686*nc1.y + 0.095378935*nd1.y + 0.4668013*ne1.y + 0.03654941*nf1.y + 0.049729843*ng1.y + 0.3160583*nh1.y + -0.037990443*ni1.y;
    w = 0.054236986*na1.z + -0.24953325*nb1.z + -0.19295105*nc1.z + 0.110123426*nd1.z + -0.24358514*ne1.z + -0.094099194*nf1.z + -0.0844554*ng1.z + -0.25239566*nh1.z + -0.17206073*ni1.z;
    x = -0.025024686*na1.w + 0.02190405*nb1.w + 0.04221924*nc1.w + 0.058701836*nd1.w + 0.6308858*ne1.w + 0.08038904*nf1.w + 0.009703351*ng1.w + 0.026796142*nh1.w + 0.19788514*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.025371183;
    i = -0.058024336*a0.x + 0.10532148*b0.x + 0.100440994*c0.x + 0.14120099*d0.x + -0.44670558*e0.x + 0.35560834*f0.x + -0.016374707*g0.x + -0.110824086*h0.x + -0.08113989*i0.x;
    j = 0.16398832*a0.y + -0.13447765*b0.y + 0.09828142*c0.y + -0.22374575*d0.y + -0.18894796*e0.y + -0.019239465*f0.y + 0.058094535*g0.y + 0.019594995*h0.y + -0.022476602*i0.y;
    k = -0.04586844*a0.z + -0.041416757*b0.z + 0.007783088*c0.z + 0.159755*d0.z + 0.05849857*e0.z + 0.07732498*f0.z + 0.0147085795*g0.z + -0.055099167*h0.z + 0.002787397*i0.z;
    l = 0.02477698*a0.w + 0.20407157*b0.w + 0.02392268*c0.w + -0.019186161*d0.w + -0.10105682*e0.w + -0.017388765*f0.w + -0.043925446*g0.w + -0.19729522*h0.w + -0.039546635*i0.w;
    m = -0.12748602*a1.x + 0.007744777*b1.x + -0.11417597*c1.x + -0.06718526*d1.x + -0.18276522*e1.x + -0.22255349*f1.x + -0.081417985*g1.x + -0.32245603*h1.x + -0.061777283*i1.x;
    n = -0.022619156*a1.y + -0.07581258*b1.y + 0.015761778*c1.y + 0.08068204*d1.y + -0.121548444*e1.y + -0.00881804*f1.y + 0.079423025*g1.y + -0.18817104*h1.y + 0.03789271*i1.y;
    o = -0.076126486*a1.z + 0.12285975*b1.z + -0.051165633*c1.z + -0.2726493*d1.z + 0.03755115*e1.z + 0.21114524*f1.z + -0.13811706*g1.z + 0.0827258*h1.z + 0.023614317*i1.z;
    p = 0.091591224*a1.w + -0.060717527*b1.w + -0.11393609*c1.w + -0.04921939*d1.w + -0.47288194*e1.w + -0.15777309*f1.w + 0.16799176*g1.w + -0.022680234*h1.w + -0.016104206*i1.w;
    q = -0.037887465*na0.x + -0.15142171*nb0.x + -0.057591256*nc0.x + -0.19010404*nd0.x + -0.043804526*ne0.x + -0.43700722*nf0.x + -0.02484513*ng0.x + 0.36064592*nh0.x + 0.21845186*ni0.x;
    r = -0.059631128*na0.y + -0.16758823*nb0.y + 0.064641714*nc0.y + 0.08638126*nd0.y + 0.22690679*ne0.y + 0.043664902*nf0.y + -0.13494207*ng0.y + 0.05925926*nh0.y + 0.042411618*ni0.y;
    s = 0.12977123*na0.z + 0.029090298*nb0.z + 0.08898829*nc0.z + -0.1127789*nd0.z + -0.17318541*ne0.z + 0.031613287*nf0.z + -0.044531874*ng0.z + 0.08955115*nh0.z + -0.0037841343*ni0.z;
    t = -0.03975416*na0.w + -0.14064074*nb0.w + -0.07762262*nc0.w + -0.3259637*nd0.w + 0.14367038*ne0.w + 0.08904514*nf0.w + 0.039760273*ng0.w + 0.21290119*nh0.w + 0.10287399*ni0.w;
    u = 0.1206366*na1.x + -0.111801684*nb1.x + 0.028606556*nc1.x + -0.100312516*nd1.x + 0.06404543*ne1.x + 0.21569107*nf1.x + 0.0471198*ng1.x + 0.1317695*nh1.x + -0.008076078*ni1.x;
    v = -0.043892793*na1.y + 0.050969392*nb1.y + 0.05223572*nc1.y + -0.015787575*nd1.y + 0.23640944*ne1.y + 0.030180406*nf1.y + 0.052976888*ng1.y + 0.24454458*nh1.y + 0.009542104*ni1.y;
    w = 0.060694832*na1.z + -0.1225385*nb1.z + -0.060287304*nc1.z + 0.27989724*nd1.z + -0.13930206*ne1.z + -0.18856433*nf1.z + 0.12858151*ng1.z + -0.06630377*nh1.z + 0.032981817*ni1.z;
    x = -0.12053484*na1.w + 0.11501946*nb1.w + -0.04619954*nc1.w + 0.04656391*nd1.w + 0.55226207*ne1.w + 0.14339776*nf1.w + -0.07201873*ng1.w + -0.005340205*nh1.w + 0.04245002*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.015942387;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN90
//!BIND LUMAN91
//!SAVE LUMAN100

#define L0_tex LUMAN90_tex
#define L1_tex LUMAN91_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.072347514*a0.x + 0.01950207*b0.x + -0.1554631*c0.x + 0.07643896*d0.x + 0.19518887*e0.x + -0.05865835*f0.x + -0.06931961*g0.x + -0.22170015*h0.x + -0.060511827*i0.x;
    float j = -0.014025003*a0.y + -0.104386844*b0.y + -0.08156085*c0.y + -0.095033586*d0.y + -0.013332267*e0.y + -0.20685793*f0.y + -0.012088011*g0.y + 0.10598454*h0.y + -0.19078864*i0.y;
    float k = -0.03994867*a0.z + -0.09009791*b0.z + 0.07993808*c0.z + -0.074835144*d0.z + 0.31472498*e0.z + 0.03673388*f0.z + 0.067335665*g0.z + -0.03211525*h0.z + -0.035896238*i0.z;
    float l = 0.062431067*a0.w + 0.08663771*b0.w + 0.0069865235*c0.w + 0.07760846*d0.w + -0.25497046*e0.w + -0.2194801*f0.w + -0.14292969*g0.w + -0.030415112*h0.w + -0.02306825*i0.w;
    float m = 0.101905294*a1.x + -0.10230241*b1.x + -0.09905037*c1.x + 0.012886894*d1.x + -0.21476957*e1.x + 0.036221605*f1.x + -0.07952149*g1.x + -0.0008413512*h1.x + 0.08244255*i1.x;
    float n = -0.030719101*a1.y + -0.021777108*b1.y + -0.029602678*c1.y + -0.039401323*d1.y + -0.29197764*e1.y + -0.009044627*f1.y + -0.009216671*g1.y + 0.12832381*h1.y + -0.025247786*i1.y;
    float o = 0.05362967*a1.z + -0.08874077*b1.z + 0.034315668*c1.z + 0.05820452*d1.z + 0.42243248*e1.z + 0.11247401*f1.z + -0.04098587*g1.z + -0.003260546*h1.z + 0.028615315*i1.z;
    float p = 0.071061894*a1.w + 0.07652106*b1.w + -0.033353116*c1.w + 0.024202999*d1.w + 0.14031556*e1.w + -0.05963695*f1.w + 0.0347537*g1.w + -0.108266346*h1.w + 0.07211353*i1.w;
    float q = -0.05338283*na0.x + -0.09228174*nb0.x + 0.013092857*nc0.x + -0.17125084*nd0.x + 0.6550206*ne0.x + -0.09533192*nf0.x + -0.09689084*ng0.x + -0.0041894587*nh0.x + 0.21914695*ni0.x;
    float r = -0.026422335*na0.y + 0.036880214*nb0.y + 0.041254893*nc0.y + 0.0008156015*nd0.y + 0.13534403*ne0.y + 0.047952086*nf0.y + -0.032348964*ng0.y + 0.014010682*nh0.y + 0.0435421*ni0.y;
    float s = -0.082521975*na0.z + 0.037913103*nb0.z + -0.10370344*nc0.z + -0.00462962*nd0.z + 0.45346752*ne0.z + -0.16892655*nf0.z + 0.025737757*ng0.z + -0.111673385*nh0.z + -0.08034411*ni0.z;
    float t = -0.015661575*na0.w + -0.073354624*nb0.w + 0.11910762*nc0.w + -0.043032695*nd0.w + 0.21332191*ne0.w + 0.19106698*nf0.w + 0.032210633*ng0.w + 0.08627176*nh0.w + -0.04056943*ni0.w;
    float u = -0.11458479*na1.x + 0.008572165*nb1.x + 0.08625398*nc1.x + 0.048368633*nd1.x + 0.3868506*ne1.x + -0.19619699*nf1.x + 0.12097667*ng1.x + -0.20041737*nh1.x + -0.1732846*ni1.x;
    float v = -0.055646222*na1.y + 0.1451881*nb1.y + -0.025238834*nc1.y + 0.082327254*nd1.y + -0.4478959*ne1.y + 0.1096028*nf1.y + -0.12073877*ng1.y + -0.008622235*nh1.y + -0.07914616*ni1.y;
    float w = -0.046383664*na1.z + 0.014370623*nb1.z + -0.021135237*nc1.z + -0.06458644*nd1.z + -0.7450077*ne1.z + -0.012579624*nf1.z + 0.02945094*ng1.z + 0.029546322*nh1.z + -0.012804222*ni1.z;
    float x = -0.12739643*na1.w + -0.036583748*nb1.w + -0.046106555*nc1.w + 0.05811886*nd1.w + -0.25411293*ne1.w + 0.018013328*nf1.w + -0.05903975*ng1.w + 0.07108783*nh1.w + 0.019811854*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.053409602;
    i = -0.10668289*a0.x + -0.22589163*b0.x + -0.13987538*c0.x + 0.05335291*d0.x + 0.48375422*e0.x + 0.15344132*f0.x + -0.11009505*g0.x + 0.016672708*h0.x + -0.10074288*i0.x;
    j = 0.0015947276*a0.y + 0.07250249*b0.y + -0.0191254*c0.y + 0.028646745*d0.y + 0.15963951*e0.y + 0.03491725*f0.y + -0.03486035*g0.y + -0.027305596*h0.y + 0.06868714*i0.y;
    k = 0.043614652*a0.z + -0.049251266*b0.z + 0.111902446*c0.z + -0.115563944*d0.z + 0.16635779*e0.z + 0.07196166*f0.z + 0.085996434*g0.z + 0.054356594*h0.z + 0.054694902*i0.z;
    l = 0.063457504*a0.w + -0.16555345*b0.w + -0.1977629*c0.w + -0.06448137*d0.w + -0.06259094*e0.w + 0.06365486*f0.w + -0.06359395*g0.w + -0.1920657*h0.w + 0.12513515*i0.w;
    m = 0.09495681*a1.x + 0.2365361*b1.x + 0.055532113*c1.x + -0.15307817*d1.x + -0.33488598*e1.x + -0.1148399*f1.x + 0.06822197*g1.x + -0.0937158*h1.x + 0.086206466*i1.x;
    n = 0.0045078564*a1.y + -0.06391341*b1.y + -0.08308173*c1.y + -0.19018562*d1.y + 0.30169633*e1.y + -0.054772913*f1.y + -0.13738966*g1.y + 0.062181123*h1.y + 0.054774147*i1.y;
    o = 0.060118355*a1.z + -0.008127762*b1.z + -0.034156173*c1.z + 0.0500277*d1.z + -0.08534194*e1.z + 0.010345815*f1.z + 0.12302839*g1.z + -0.04158649*h1.z + -0.03973762*i1.z;
    p = -0.080815166*a1.w + 0.08477702*b1.w + 0.13679668*c1.w + 0.04734655*d1.w + -0.0024687275*e1.w + -0.06741254*f1.w + 0.0020256601*g1.w + -0.009172918*h1.w + -0.037641473*i1.w;
    q = 0.06965178*na0.x + 0.29032642*nb0.x + 0.17806295*nc0.x + -0.11129186*nd0.x + -0.41759446*ne0.x + 0.0050110994*nf0.x + 0.17578389*ng0.x + -0.11543253*nh0.x + -0.001885809*ni0.x;
    r = 0.005317532*na0.y + 0.095645644*nb0.y + -0.021098567*nc0.y + 0.06591392*nd0.y + -0.116197005*ne0.y + -0.043358993*nf0.y + -0.013009809*ng0.y + -0.15138024*nh0.y + -0.033799697*ni0.y;
    s = -0.057522736*na0.z + -0.082728855*nb0.z + -0.031226154*nc0.z + 0.18959501*nd0.z + -0.20877957*ne0.z + -0.07964734*nf0.z + -0.04476616*ng0.z + 0.009902144*nh0.z + 0.07217108*ni0.z;
    t = -0.024333658*na0.w + 0.047745872*nb0.w + 0.16592872*nc0.w + -0.12421168*nd0.w + -0.11843008*ne0.w + -0.11738284*nf0.w + 0.21761538*ng0.w + 0.049520187*nh0.w + -0.1659902*ni0.w;
    u = 0.14783847*na1.x + 0.17537417*nb1.x + 0.049885694*nc1.x + 0.17277068*nd1.x + 0.2821199*ne1.x + 0.09878132*nf1.x + -0.11981736*ng1.x + 0.118238404*nh1.x + -0.01825559*ni1.x;
    v = 0.06738571*na1.y + -0.1575328*nb1.y + 0.036821637*nc1.y + 0.0392651*nd1.y + 0.20996699*ne1.y + 0.010065104*nf1.y + 0.16928582*ng1.y + -0.18545963*nh1.y + -0.061286196*ni1.y;
    w = -0.018393407*na1.z + -0.13900594*nb1.z + 0.005088923*nc1.z + -0.044956826*nd1.z + 0.29364726*ne1.z + -0.07444642*nf1.z + -0.10428068*ng1.z + 0.014451067*nh1.z + 0.04694493*ni1.z;
    x = 0.16300602*na1.w + 0.18626012*nb1.w + -0.06521978*nc1.w + -0.012457507*nd1.w + 0.36782196*ne1.w + 0.11866779*nf1.w + 0.10910508*ng1.w + 0.032809496*nh1.w + -0.07063725*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.012890339;
    i = -0.09139671*a0.x + 0.35795408*b0.x + 0.038557854*c0.x + -0.52320266*d0.x + 0.26043087*e0.x + -0.0070253634*f0.x + -0.034186177*g0.x + -0.3889957*h0.x + 0.006295736*i0.x;
    j = -0.026434768*a0.y + 0.11207987*b0.y + -0.08482518*c0.y + -0.08554998*d0.y + 0.41271183*e0.y + -0.095349595*f0.y + 0.019489529*g0.y + -0.04493386*h0.y + -0.095000364*i0.y;
    k = -0.07414244*a0.z + -0.030943856*b0.z + -0.25061974*c0.z + -0.15343326*d0.z + 0.05414551*e0.z + 0.32426453*f0.z + 0.16768244*g0.z + -0.014362068*h0.z + 0.060472*i0.z;
    l = -0.083828114*a0.w + 0.13204199*b0.w + -0.04703435*c0.w + -0.035870466*d0.w + -0.44054565*e0.w + -0.09806949*f0.w + -0.1409398*g0.w + 0.0019250079*h0.w + 0.019642184*i0.w;
    m = -0.0012715708*a1.x + 0.049831104*b1.x + -0.063315846*c1.x + -0.067038305*d1.x + -0.0893526*e1.x + 0.0021741989*f1.x + 0.24290745*g1.x + 0.023283675*h1.x + -0.17132534*i1.x;
    n = 0.048266195*a1.y + -0.0011830739*b1.y + 0.18100028*c1.y + -0.25165966*d1.y + 0.2969748*e1.y + -0.3689166*f1.y + -0.060033243*g1.y + -0.004085616*h1.y + 0.08210132*i1.y;
    o = 0.03524951*a1.z + 0.4448059*b1.z + -0.3404398*c1.z + 0.12155771*d1.z + -0.023394607*e1.z + 0.24049339*f1.z + 0.21649478*g1.z + -0.04342076*h1.z + -0.0025506937*i1.z;
    p = -0.06775117*a1.w + -0.2165721*b1.w + 0.2823466*c1.w + -0.15691832*d1.w + 0.08486866*e1.w + -0.18946524*f1.w + -0.14904466*g1.w + 0.035512596*h1.w + -0.013078167*i1.w;
    q = 0.059031803*na0.x + -0.5058904*nb0.x + -0.0038910978*nc0.x + 0.23189625*nd0.x + 0.18667111*ne0.x + 0.03620043*nf0.x + 0.08591163*ng0.x + 0.34300846*nh0.x + 0.037738785*ni0.x;
    r = 0.06437921*na0.y + -0.018446406*nb0.y + -0.053650368*nc0.y + 0.010188758*nd0.y + -0.28385177*ne0.y + 0.27842358*nf0.y + 0.010817179*ng0.y + 0.00707268*nh0.y + 0.022868687*ni0.y;
    s = 0.10183586*na0.z + -0.085717954*nb0.z + 0.2063317*nc0.z + 0.11843876*nd0.z + 0.26863*ne0.z + -0.3623546*nf0.z + -0.13238493*ng0.z + -0.095737286*nh0.z + -0.07417025*ni0.z;
    t = -0.16863932*na0.w + -0.23825082*nb0.w + -0.15660179*nc0.w + 0.04931752*nd0.w + 0.6820201*ne0.w + -0.032462034*nf0.w + 0.078525215*ng0.w + -0.21108823*nh0.w + 0.16687338*ni0.w;
    u = 0.004978578*na1.x + -0.24199933*nb1.x + -0.24022794*nc1.x + 0.13019069*nd1.x + 0.2714972*ne1.x + 0.29668224*nf1.x + -0.08448439*ng1.x + 0.41858274*nh1.x + 0.20609297*ni1.x;
    v = -0.045478754*na1.y + 0.1254586*nb1.y + 0.26045057*nc1.y + 0.36398405*nd1.y + -0.31560805*ne1.y + 0.15722503*nf1.y + 0.17487678*ng1.y + 0.173974*nh1.y + 0.05119602*ni1.y;
    w = 0.03245682*na1.z + -0.10725469*nb1.z + 0.16054815*nc1.z + -0.29050833*nd1.z + -0.046494015*ne1.z + -0.25890747*nf1.z + -0.17802468*ng1.z + 0.04463261*nh1.z + 0.025746295*ni1.z;
    x = -0.005190955*na1.w + 0.5844454*nb1.w + -0.1295932*nc1.w + 0.085063726*nd1.w + 0.5402516*ne1.w + -0.09760206*nf1.w + 0.17631175*ng1.w + -0.029834324*nh1.w + 0.12012502*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.024680963;
    i = 0.22015639*a0.x + -0.17407666*b0.x + -0.017574009*c0.x + 0.021068307*d0.x + -0.03861795*e0.x + -0.053769782*f0.x + 0.0598006*g0.x + 0.13844252*h0.x + -0.071340755*i0.x;
    j = 0.050717417*a0.y + 0.025524106*b0.y + -0.08404415*c0.y + 0.08333174*d0.y + 0.017013293*e0.y + -0.11637262*f0.y + -0.037559748*g0.y + -0.0068465522*h0.y + 0.13893107*i0.y;
    k = 0.043148153*a0.z + 0.3295378*b0.z + 0.0087906*c0.z + 0.11311087*d0.z + 0.04312488*e0.z + 0.04736787*f0.z + -0.22878742*g0.z + 0.09858411*h0.z + 0.0005592605*i0.z;
    l = 0.04284654*a0.w + 0.07436968*b0.w + 0.10052526*c0.w + -0.065019675*d0.w + 0.3465609*e0.w + 0.0008741843*f0.w + 0.2270247*g0.w + -0.03964889*h0.w + 0.071887866*i0.w;
    m = -0.14235982*a1.x + -0.07072083*b1.x + -0.084995635*c1.x + -0.100894645*d1.x + -0.44581255*e1.x + 0.015933136*f1.x + -0.019286517*g1.x + -0.1235309*h1.x + -0.03368268*i1.x;
    n = -0.03326311*a1.y + -0.10073692*b1.y + -0.09853149*c1.y + -0.07900594*d1.y + -0.1953579*e1.y + 0.042089753*f1.y + -0.07855328*g1.y + -0.23200025*h1.y + -0.006610747*i1.y;
    o = -0.08007896*a1.z + -0.2461607*b1.z + 0.14353238*c1.z + -0.04846219*d1.z + -0.1721878*e1.z + -0.09197814*f1.z + -0.06070735*g1.z + 0.18315983*h1.z + -0.034425892*i1.z;
    p = 0.05459684*a1.w + 0.31108928*b1.w + -0.10467039*c1.w + 0.010673246*d1.w + 0.0047224355*e1.w + -0.0058969916*f1.w + 0.056659333*g1.w + -0.106476724*h1.w + 0.104168944*i1.w;
    q = -0.12763675*na0.x + 0.25710836*nb0.x + 0.0072693126*nc0.x + 0.03039457*nd0.x + -0.0044554067*ne0.x + -0.022940034*nf0.x + -0.09403209*ng0.x + 0.015883204*nh0.x + 0.13509955*ni0.x;
    r = -0.0994595*na0.y + -0.13763939*nb0.y + 0.1409501*nc0.y + -0.0032936442*nd0.y + -0.20076504*ne0.y + -0.0654214*nf0.y + 0.06498927*ng0.y + -0.00031625124*nh0.y + -0.22941948*ni0.y;
    s = -0.009283021*na0.z + -0.16832107*nb0.z + -0.13831505*nc0.z + 0.08391695*nd0.z + -0.13806774*ne0.z + 0.03952671*nf0.z + 0.18881537*ng0.z + -0.06885674*nh0.z + -0.0108183455*ni0.z;
    t = -0.054374512*na0.w + -0.012385924*nb0.w + -0.02725351*nc0.w + 0.024616664*nd0.w + -0.2775687*ne0.w + 0.25559253*nf0.w + -0.11180425*ng0.w + 0.019967819*nh0.w + 0.02086255*ni0.w;
    u = 0.057943374*na1.x + 0.1063353*nb1.x + 0.09240854*nc1.x + 0.16697767*nd1.x + 0.1308629*ne1.x + 0.05557683*nf1.x + 0.09398093*ng1.x + -0.1522693*nh1.x + 0.027451862*ni1.x;
    v = 0.14591761*na1.y + -0.040234886*nb1.y + 0.06888115*nc1.y + 0.07083606*nd1.y + 0.13988727*ne1.y + -0.039818123*nf1.y + 0.04681032*ng1.y + 0.17090715*nh1.y + 0.103332356*ni1.y;
    w = -0.008291727*na1.z + 0.18223919*nb1.z + -0.10855884*nc1.z + 0.23896803*nd1.z + 0.044032115*ne1.z + 0.14236271*nf1.z + -0.0023151839*ng1.z + -0.1667703*nh1.z + 0.045290492*ni1.z;
    x = -0.111752234*na1.w + -0.4377266*nb1.w + 0.14324181*nc1.w + -0.076248966*nd1.w + -0.28233582*ne1.w + -0.061120443*nf1.w + -0.17006911*ng1.w + -0.016051235*nh1.w + -0.08499419*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.008792649;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN90
//!BIND LUMAN91
//!SAVE LUMAN101

#define L0_tex LUMAN90_tex
#define L1_tex LUMAN91_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.04138916*a0.x + 0.30197543*b0.x + -0.1704045*c0.x + 0.17965184*d0.x + 0.29003835*e0.x + 0.08370005*f0.x + 0.03190118*g0.x + -0.17518468*h0.x + 0.012955842*i0.x;
    float j = -0.07109726*a0.y + 0.1823734*b0.y + -0.04605392*c0.y + 0.059269615*d0.y + -0.15138285*e0.y + 0.03608101*f0.y + 0.08242375*g0.y + 0.009028954*h0.y + 0.072812274*i0.y;
    float k = -0.12356149*a0.z + -0.086611435*b0.z + -0.04118464*c0.z + -0.31934968*d0.z + 0.101652585*e0.z + 0.26276174*f0.z + 0.021968804*g0.z + 0.017631736*h0.z + 0.10742102*i0.z;
    float l = -0.09023773*a0.w + 0.2707063*b0.w + -0.037710827*c0.w + 0.061088122*d0.w + -0.35330138*e0.w + 0.09019705*f0.w + 0.16161165*g0.w + 0.025295937*h0.w + 0.06373963*i0.w;
    float m = -0.0034698183*a1.x + 0.22036514*b1.x + -0.1092582*c1.x + 0.09482756*d1.x + -0.109374434*e1.x + -0.3238208*f1.x + 0.17918727*g1.x + 0.39547127*h1.x + -0.4623379*i1.x;
    float n = 0.050948843*a1.y + 0.01738471*b1.y + -0.105602264*c1.y + -0.2204674*d1.y + -0.45561066*e1.y + -0.12051163*f1.y + -0.16263375*g1.y + -0.25530714*h1.y + -0.09285533*i1.y;
    float o = 0.07403561*a1.z + 0.1990857*b1.z + -0.11977993*c1.z + 0.13144638*d1.z + 0.2341229*e1.z + -0.00042121703*f1.z + 0.1583226*g1.z + 0.12840292*h1.z + 0.1433887*i1.z;
    float p = -0.1851604*a1.w + 0.17602521*b1.w + 0.1221305*c1.w + -0.03615599*d1.w + -0.07932866*e1.w + -0.2525634*f1.w + 0.002964321*g1.w + 0.11298226*h1.w + -0.13519266*i1.w;
    float q = -0.08234646*na0.x + -0.1414366*nb0.x + 0.15008587*nc0.x + -0.29907978*nd0.x + 0.11506433*ne0.x + -0.22332646*nf0.x + 0.05805965*ng0.x + 0.27810848*nh0.x + 0.070169106*ni0.x;
    float r = 0.03592974*na0.y + -0.16536513*nb0.y + 0.11441198*nc0.y + 0.08435175*nd0.y + 0.08932274*ne0.y + -0.027787168*nf0.y + 0.029256653*ng0.y + -0.040782016*nh0.y + -0.20330355*ni0.y;
    float s = 0.18085478*na0.z + -0.020390073*nb0.z + 0.05839085*nc0.z + 0.22958046*nd0.z + 0.37471008*ne0.z + -0.18636653*nf0.z + -0.11146145*ng0.z + -0.22841236*nh0.z + -0.07214006*ni0.z;
    float t = -0.05589969*na0.w + -0.33850622*nb0.w + -0.13061482*nc0.w + 0.13003778*nd0.w + 0.10737323*ne0.w + 0.10882713*nf0.w + -0.042201*ng0.w + 0.08923628*nh0.w + 0.09584097*ni0.w;
    float u = 0.25411305*na1.x + -0.094354436*nb1.x + 0.10621806*nc1.x + 0.21951157*nd1.x + 0.4614293*ne1.x + 0.31408313*nf1.x + 0.17083499*ng1.x + 0.35976404*nh1.x + 0.59438545*ni1.x;
    float v = 0.19550157*na1.y + 0.069357626*nb1.y + 0.11229597*nc1.y + 0.3491916*nd1.y + 0.014997532*ne1.y + 0.30050907*nf1.y + 0.5238676*ng1.y + 0.49579856*nh1.y + 0.24422513*ni1.y;
    float w = -0.050069377*na1.z + -0.20981462*nb1.z + 0.03546458*nc1.z + -0.11718573*nd1.z + -0.65724605*ne1.z + -0.15975557*nf1.z + -0.23317842*ng1.z + -0.19055666*nh1.z + -0.12475086*ni1.z;
    float x = 0.24616854*na1.w + 0.22712433*nb1.w + 0.003031617*nc1.w + 0.048955284*nd1.w + 0.1591972*ne1.w + 0.28133035*nf1.w + 0.016519194*ng1.w + -0.16729145*nh1.w + 0.18185227*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.047343764;
    i = 0.005074274*a0.x + -0.10939917*b0.x + 0.09337425*c0.x + 0.12879685*d0.x + -0.2513652*e0.x + 0.024987087*f0.x + -0.034622103*g0.x + -0.25332397*h0.x + -0.12031207*i0.x;
    j = -0.06383014*a0.y + -0.13306095*b0.y + 0.05165878*c0.y + -0.06310904*d0.y + -0.37605837*e0.y + 0.0046695503*f0.y + -0.042384528*g0.y + -0.17892925*h0.y + 0.11072541*i0.y;
    k = 0.0863989*a0.z + -0.063399985*b0.z + 0.06119446*c0.z + 0.16250986*d0.z + -0.1728184*e0.z + 0.008604359*f0.z + 0.16334063*g0.z + -0.113537095*h0.z + 0.1009804*i0.z;
    l = 0.047524717*a0.w + -0.16800861*b0.w + -0.10891596*c0.w + 0.03267108*d0.w + 0.06986079*e0.w + -0.008223582*f0.w + 0.060645815*g0.w + -0.02414828*h0.w + -0.122083426*i0.w;
    m = 0.078140706*a1.x + -0.018814396*b1.x + -0.15132849*c1.x + 0.118835375*d1.x + -0.1442321*e1.x + -0.017920561*f1.x + 0.06573718*g1.x + 0.082351625*h1.x + -0.06982771*i1.x;
    n = 0.033628177*a1.y + -0.09716254*b1.y + 0.02115325*c1.y + -0.048093375*d1.y + 0.31762937*e1.y + -0.11595583*f1.y + -0.008387223*g1.y + -0.083197124*h1.y + -0.040556666*i1.y;
    o = 0.14306657*a1.z + -0.022273308*b1.z + -0.077878624*c1.z + 0.22185993*d1.z + -0.31860897*e1.z + 0.053827673*f1.z + 0.1621465*g1.z + -0.03989667*h1.z + 0.05673126*i1.z;
    p = -0.11362184*a1.w + 0.17365338*b1.w + 0.08072115*c1.w + 0.0016683352*d1.w + 0.05453119*e1.w + 0.10592867*f1.w + -0.054010063*g1.w + 0.023749562*h1.w + -0.024204558*i1.w;
    q = 0.002665413*na0.x + -0.003804767*nb0.x + -0.05944676*nc0.x + -0.24341638*nd0.x + 0.41303757*ne0.x + 0.009786497*nf0.x + -0.06763682*ng0.x + 0.05546292*nh0.x + 0.05898785*ni0.x;
    r = 0.1532655*na0.y + 0.046516657*nb0.y + 0.031247063*nc0.y + 0.051957767*nd0.y + 0.14366964*ne0.y + 0.3183212*nf0.y + 0.0112762125*ng0.y + 0.12396964*nh0.y + 0.051013164*ni0.y;
    s = -0.07427598*na0.z + 0.17220956*nb0.z + -0.079463005*nc0.z + -0.07945764*nd0.z + 0.31239212*ne0.z + -0.16328163*nf0.z + -0.19595952*ng0.z + 0.025388455*nh0.z + -0.08269749*ni0.z;
    t = -0.02824691*na0.w + 0.118230626*nb0.w + 0.039104287*nc0.w + 0.054503523*nd0.w + 0.07351955*ne0.w + 0.07331395*nf0.w + -0.029851029*ng0.w + 0.03505141*nh0.w + 0.1424937*ni0.w;
    u = -0.07982493*na1.x + -0.090192325*nb1.x + 0.07434182*nc1.x + -0.23530023*nd1.x + 0.12131227*ne1.x + 0.13164005*nf1.x + -0.052253626*ng1.x + -0.046372693*nh1.x + 0.057849534*ni1.x;
    v = -0.008675165*na1.y + 0.051392596*nb1.y + 0.007813682*nc1.y + 0.13168667*nd1.y + 0.041282393*ne1.y + 0.11799713*nf1.y + 0.0034918478*ng1.y + -0.11258261*nh1.y + 0.028657598*ni1.y;
    w = -0.07173511*na1.z + 0.113963515*nb1.z + 0.06922608*nc1.z + -0.1977448*nd1.z + 0.3254376*ne1.z + -0.03963667*nf1.z + -0.046891466*ng1.z + 0.052214094*nh1.z + -0.035925962*ni1.z;
    x = 0.09945125*na1.w + -0.31153867*nb1.w + -0.0972693*nc1.w + 0.2058437*nd1.w + -0.04664287*ne1.w + -0.15176259*nf1.w + 0.12657925*ng1.w + -0.043328263*nh1.w + 0.014189671*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.014974224;
    i = 0.11425061*a0.x + -0.12480644*b0.x + 0.037956957*c0.x + 0.08022729*d0.x + 0.5309364*e0.x + -0.22583173*f0.x + 0.12067425*g0.x + 0.08682246*h0.x + -0.11000624*i0.x;
    j = 0.0022261222*a0.y + 0.037563387*b0.y + 0.02174831*c0.y + 0.020510169*d0.y + 0.059123535*e0.y + -0.16094902*f0.y + 0.047558483*g0.y + 0.0036549352*h0.y + -0.12194797*i0.y;
    k = -0.058252987*a0.z + 0.39569992*b0.z + -0.085530244*c0.z + -0.40521297*d0.z + 0.42622545*e0.z + -0.04544852*f0.z + 0.05778261*g0.z + -0.0010521769*h0.z + 0.06868768*i0.z;
    l = 0.0702999*a0.w + 0.097584985*b0.w + 0.10488675*c0.w + 0.0103232665*d0.w + 0.39629054*e0.w + -0.048901178*f0.w + -0.07040098*g0.w + 0.25743884*h0.w + -0.001018649*i0.w;
    m = -0.11881993*a1.x + 0.0039667734*b1.x + -0.13178195*c1.x + -0.12039257*d1.x + 0.27637544*e1.x + -0.04874474*f1.x + -0.013058322*g1.x + 0.02230431*h1.x + -0.114142925*i1.x;
    n = 0.058873195*a1.y + 0.035543237*b1.y + 0.02650194*c1.y + -0.072002105*d1.y + 0.035974164*e1.y + -0.13310984*f1.y + 0.035894036*g1.y + -0.22386155*h1.y + -0.014024901*i1.y;
    o = -0.2248448*a1.z + 0.07560031*b1.z + 0.0047171847*c1.z + -0.2494523*d1.z + 0.17671472*e1.z + -0.010878757*f1.z + 0.052058302*g1.z + 0.023165079*h1.z + -0.0075516924*i1.z;
    p = 0.1220613*a1.w + 0.016521322*b1.w + -0.16713895*c1.w + 0.16955481*d1.w + -0.18306993*e1.w + 0.09826972*f1.w + -0.035299685*g1.w + -0.1761684*h1.w + 0.08700361*i1.w;
    q = -0.05393835*na0.x + 0.08020018*nb0.x + -0.09193613*nc0.x + -0.1166321*nd0.x + -0.17528594*ne0.x + 0.09008182*nf0.x + -0.031376988*ng0.x + 0.0130782025*nh0.x + 0.18729372*ni0.x;
    r = 0.0016751966*na0.y + 0.062827334*nb0.y + 0.09153917*nc0.y + 0.0055522337*nd0.y + 0.0056728674*ne0.y + 0.21756102*nf0.y + -0.021842608*ng0.y + 0.1688886*nh0.y + 0.011675954*ni0.y;
    s = 0.022171449*na0.z + -0.21762362*nb0.z + -0.03511273*nc0.z + 0.25843334*nd0.z + -0.07825473*ne0.z + -0.058452897*nf0.z + -0.08572572*ng0.z + -0.05009758*nh0.z + -0.1203646*ni0.z;
    t = 0.02420277*na0.w + -0.047528002*nb0.w + -0.0756805*nc0.w + 0.04303529*nd0.w + -0.1522967*ne0.w + 0.20764968*nf0.w + 0.04693355*ng0.w + -0.18873805*nh0.w + 0.12394661*ni0.w;
    u = 0.20615208*na1.x + -0.23040159*nb1.x + 0.08070546*nc1.x + 0.12708692*nd1.x + -0.55477667*ne1.x + 0.059609883*nf1.x + -0.036457956*ng1.x + -0.14565654*nh1.x + -0.072122045*ni1.x;
    v = 0.07742679*na1.y + -0.08422293*nb1.y + 0.050255436*nc1.y + 0.09550706*nd1.y + 0.09218959*ne1.y + 0.29053694*nf1.y + 0.12561111*ng1.y + 0.21103214*nh1.y + 0.094996154*ni1.y;
    w = 0.07604026*na1.z + 0.10383877*nb1.z + -0.017639672*nc1.z + 0.090248294*nd1.z + -0.36661062*ne1.z + 0.048648287*nf1.z + 0.004087378*ng1.z + -0.07443208*nh1.z + 0.008644338*ni1.z;
    x = -0.10678218*na1.w + -0.08522191*nb1.w + 0.030547328*nc1.w + -0.37972483*nd1.w + 0.22218885*ne1.w + -0.18519177*nf1.w + 0.004827946*ng1.w + 0.010769795*nh1.w + -0.01801208*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0010293183;
    i = -0.014593506*a0.x + 0.023265488*b0.x + 0.061627004*c0.x + 0.09548386*d0.x + -0.30135506*e0.x + 0.011962504*f0.x + -0.13203998*g0.x + 0.21614662*h0.x + 0.05958174*i0.x;
    j = -0.09878384*a0.y + -0.03683659*b0.y + 0.048794214*c0.y + 0.1408684*d0.y + 0.03628337*e0.y + 0.03144382*f0.y + -0.021739298*g0.y + -0.04188862*h0.y + -0.0006002639*i0.y;
    k = 0.03112728*a0.z + -0.06630562*b0.z + -0.02561439*c0.z + 0.05311198*d0.z + -0.27829593*e0.z + -0.022640232*f0.z + 0.03705506*g0.z + -0.24030457*h0.z + 0.03965588*i0.z;
    l = 0.017258069*a0.w + -0.00722733*b0.w + -0.06503884*c0.w + -0.25225252*d0.w + -0.13763164*e0.w + 0.07982453*f0.w + 0.0026299297*g0.w + 0.07207517*h0.w + 0.06790191*i0.w;
    m = -0.019212238*a1.x + 0.12592626*b1.x + -0.021851178*c1.x + 0.15686631*d1.x + 0.22012937*e1.x + -0.20557871*f1.x + 0.09099229*g1.x + -0.10211517*h1.x + -0.034204774*i1.x;
    n = -0.012529692*a1.y + 0.09362853*b1.y + 0.039997622*c1.y + -0.05150152*d1.y + -0.14264928*e1.y + -0.033544317*f1.y + 0.040011894*g1.y + -0.12768707*h1.y + -0.078043096*i1.y;
    o = 0.0074936035*a1.z + 0.22932594*b1.z + -0.057378706*c1.z + 0.28699687*d1.z + -0.21756352*e1.z + -0.062053844*f1.z + -0.00024668174*g1.z + -0.05100476*h1.z + 0.06928418*i1.z;
    p = -0.14546607*a1.w + -0.16651693*b1.w + 0.12857576*c1.w + -0.047539867*d1.w + 0.26343384*e1.w + -0.017469188*f1.w + -0.005115385*g1.w + 0.0012459696*h1.w + -0.09503593*i1.w;
    q = -0.087925985*na0.x + 0.0023024757*nb0.x + -0.095000125*nc0.x + 0.07433898*nd0.x + 0.0041658483*ne0.x + 0.123552985*nf0.x + 0.120837346*ng0.x + -0.1636861*nh0.x + -0.011546859*ni0.x;
    r = 0.038042698*na0.y + 0.13991997*nb0.y + -0.066846035*nc0.y + 0.010655437*nd0.y + -0.068989895*ne0.y + -0.05154676*nf0.y + -0.06894559*ng0.y + 0.038047343*nh0.y + -0.00232077*ni0.y;
    s = -0.0019521024*na0.z + -0.022583103*nb0.z + 0.054494895*nc0.z + -0.08943432*nd0.z + 0.08132613*ne0.z + -0.016627267*nf0.z + -0.024312189*ng0.z + 0.26041818*nh0.z + -0.079761654*ni0.z;
    t = -0.08269844*na0.w + -0.09737923*nb0.w + 0.030635225*nc0.w + 0.15013275*nd0.w + -0.107235596*ne0.w + -0.134351*nf0.w + 0.14893004*ng0.w + -0.040401027*nh0.w + -0.034354553*ni0.w;
    u = 0.035184126*na1.x + -0.2824874*nb1.x + -0.016726991*nc1.x + -0.14177802*nd1.x + -0.06586472*ne1.x + -0.013826119*nf1.x + -0.1320728*ng1.x + 0.035011787*nh1.x + 0.055118065*ni1.x;
    v = -0.024546877*na1.y + 0.12185577*nb1.y + 0.09696174*nc1.y + -0.08592494*nd1.y + 0.27429417*ne1.y + 0.28399673*nf1.y + 0.121077314*ng1.y + 0.012329405*nh1.y + 0.020637203*ni1.y;
    w = -0.031275805*na1.z + -0.15169707*nb1.z + 0.07485881*nc1.z + -0.0634399*nd1.z + 0.4907602*ne1.z + -0.001096378*nf1.z + 0.0051537943*ng1.z + -0.037228644*nh1.z + -0.024804804*ni1.z;
    x = 0.21940029*na1.w + 0.46201172*nb1.w + -0.1741037*nc1.w + 0.11073968*nd1.w + -0.07999448*ne1.w + 0.12612918*nf1.w + 0.041276265*ng1.w + 0.039091896*nh1.w + -0.023500916*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.00620655;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN100
//!BIND LUMAN101
//!SAVE LUMAN110

#define L0_tex LUMAN100_tex
#define L1_tex LUMAN101_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.035900798*a0.x + -0.0032731516*b0.x + 0.08142251*c0.x + -0.03735964*d0.x + -0.5860401*e0.x + 0.18885492*f0.x + -0.052124757*g0.x + 0.0039482615*h0.x + -0.0067603188*i0.x;
    float j = 0.03218352*a0.y + 0.010617722*b0.y + 0.22913666*c0.y + -0.005692161*d0.y + -0.2878274*e0.y + 0.26934555*f0.y + -0.14689828*g0.y + -0.14777917*h0.y + -0.146745*i0.y;
    float k = -0.12349442*a0.z + -0.09644591*b0.z + 0.015029442*c0.z + -0.11548111*d0.z + -0.40823653*e0.z + -0.18077675*f0.z + 0.03544688*g0.z + 0.011662489*h0.z + 0.07574941*i0.z;
    float l = -0.124623254*a0.w + 0.16140111*b0.w + -0.046893556*c0.w + -0.056092393*d0.w + -0.17846477*e0.w + -0.07701739*f0.w + -0.09542691*g0.w + -0.23367326*h0.w + -0.06812856*i0.w;
    float m = -0.06034172*a1.x + -0.13329592*b1.x + -0.045309793*c1.x + 0.17750835*d1.x + -0.0076088295*e1.x + -0.03329555*f1.x + 0.0049533285*g1.x + -0.045710914*h1.x + -0.017280852*i1.x;
    float n = 0.06250742*a1.y + -0.019177811*b1.y + -0.04794798*c1.y + -0.06185518*d1.y + -0.3015897*e1.y + -0.04110791*f1.y + -0.04484891*g1.y + 0.062133104*h1.y + 0.029863592*i1.y;
    float o = 0.1407756*a1.z + 0.03246707*b1.z + 0.055456042*c1.z + 0.08737635*d1.z + 0.29290113*e1.z + 0.22447072*f1.z + -0.0070300275*g1.z + -0.09647503*h1.z + -0.112883285*i1.z;
    float p = 0.11920284*a1.w + 0.22888571*b1.w + -0.03729867*c1.w + -0.04619108*d1.w + 0.265903*e1.w + -0.18725681*f1.w + -0.052515823*g1.w + 0.27257964*h1.w + -0.004936924*i1.w;
    float q = -0.046696868*na0.x + -0.17244326*nb0.x + -0.0006326694*nc0.x + 0.022097602*nd0.x + 0.36674306*ne0.x + -0.17773466*nf0.x + 0.027276874*ng0.x + 0.057075586*nh0.x + 0.08366408*ni0.x;
    float r = -0.0496522*na0.y + -0.05937534*nb0.y + -0.20281217*nc0.y + 0.01603125*nd0.y + 0.3475573*ne0.y + -0.3014151*nf0.y + 0.05755629*ng0.y + 0.19609028*nh0.y + 0.08452658*ni0.y;
    float s = 0.06687699*na0.z + 0.067958415*nb0.z + 0.06647321*nc0.z + 0.1284585*nd0.z + 0.7849594*ne0.z + 0.29734918*nf0.z + 0.027528172*ng0.z + -0.024441805*nh0.z + -0.11729039*ni0.z;
    float t = 0.08647725*na0.w + -0.056248702*nb0.w + 0.07359946*nc0.w + 0.11756446*nd0.w + 0.2627642*ne0.w + -0.018952051*nf0.w + -0.0065718633*ng0.w + 0.039699655*nh0.w + 0.061234728*ni0.w;
    float u = 0.06364634*na1.x + 0.0327214*nb1.x + 0.029039195*nc1.x + -0.0952279*nd1.x + 0.059711777*ne1.x + 0.038400296*nf1.x + -0.07332336*ng1.x + 0.017307714*nh1.x + 0.04607215*ni1.x;
    float v = -0.047831755*na1.y + -0.040664297*nb1.y + 0.06826742*nc1.y + 0.0526502*nd1.y + 0.4831352*ne1.y + 0.11276925*nf1.y + 0.078867294*ng1.y + -0.17317057*nh1.y + -0.09310757*ni1.y;
    float w = -0.07256914*na1.z + -0.065705195*nb1.z + -0.040407173*nc1.z + -0.15516779*nd1.z + -0.43270877*ne1.z + -0.19089858*nf1.z + 0.0144505445*ng1.z + 0.26007774*nh1.z + 0.13456038*ni1.z;
    float x = -0.17530301*na1.w + -0.48442727*nb1.w + -0.03330983*nc1.w + -0.019479422*nd1.w + 0.21953882*ne1.w + 0.1206139*nf1.w + -0.08568933*ng1.w + -0.22107208*nh1.w + -0.05904734*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.024452502;
    i = 0.017014494*a0.x + -0.00054127455*b0.x + 0.007609347*c0.x + 0.11954065*d0.x + 0.0798582*e0.x + 0.017370699*f0.x + 0.11012819*g0.x + -0.11934599*h0.x + -0.12777543*i0.x;
    j = -0.04406953*a0.y + -0.12507345*b0.y + 0.060362745*c0.y + 0.28017431*d0.y + 0.07832064*e0.y + -0.15825081*f0.y + 0.0524985*g0.y + 0.30791417*h0.y + -0.15982261*i0.y;
    k = -0.086442724*a0.z + 0.00012259315*b0.z + 0.007140376*c0.z + -0.2824918*d0.z + -0.25533247*e0.z + 0.033553455*f0.z + 0.1419663*g0.z + -0.334144*h0.z + -0.0784347*i0.z;
    l = 0.039073847*a0.w + -0.10111335*b0.w + 0.1189452*c0.w + -0.112359114*d0.w + 0.01488211*e0.w + 0.036622338*f0.w + 0.1708258*g0.w + -0.47144276*h0.w + -0.19981442*i0.w;
    m = 0.16498776*a1.x + -0.044963352*b1.x + 0.06430563*c1.x + 0.07391399*d1.x + 0.123919465*e1.x + -0.0375703*f1.x + -0.004655664*g1.x + 0.17231892*h1.x + 0.13099734*i1.x;
    n = 0.013878608*a1.y + -0.10779041*b1.y + -0.03252544*c1.y + -0.19509874*d1.y + 0.2426995*e1.y + 0.05905958*f1.y + -0.021916907*g1.y + -0.10760266*h1.y + 0.1330649*i1.y;
    o = -0.093077786*a1.z + 0.028179191*b1.z + 0.057031747*c1.z + -0.009288688*d1.z + -0.23512715*e1.z + -0.18687668*f1.z + 0.020875294*g1.z + -0.0056162253*h1.z + 0.012207328*i1.z;
    p = 0.036275603*a1.w + -0.035214525*b1.w + 0.039897*c1.w + 0.27076656*d1.w + 0.37951374*e1.w + 0.07411483*f1.w + -0.09491011*g1.w + -0.0707116*h1.w + 0.013819694*i1.w;
    q = 0.106207535*na0.x + 0.003672323*nb0.x + -0.005481963*nc0.x + -0.070232905*nd0.x + -0.12546863*ne0.x + -0.012893604*nf0.x + -0.07979441*ng0.x + 0.047225464*nh0.x + 0.22636586*ni0.x;
    r = 0.021130336*na0.y + 0.005865638*nb0.y + 0.0266642*nc0.y + -0.13385898*nd0.y + 0.23195273*ne0.y + 0.2500417*nf0.y + 0.015835918*ng0.y + -0.19905601*nh0.y + 0.24267204*ni0.y;
    s = 0.028915072*na0.z + -0.00034564265*nb0.z + -0.023576412*nc0.z + 0.11490365*nd0.z + 0.07083828*ne0.z + -0.060439333*nf0.z + -0.09797052*ng0.z + -0.07472622*nh0.z + -0.033918925*ni0.z;
    t = 0.061985716*na0.w + 0.1016432*nb0.w + 0.001047103*nc0.w + 0.07245331*nd0.w + 0.014575151*ne0.w + 0.009510986*nf0.w + -0.042668477*ng0.w + 0.46141195*nh0.w + 0.16009891*ni0.w;
    u = -0.19059992*na1.x + 0.12379133*nb1.x + 0.043386538*nc1.x + -0.111131445*nd1.x + -0.25058612*ne1.x + 0.07591241*nf1.x + 0.12921755*ng1.x + -0.1014394*nh1.x + -0.08227909*ni1.x;
    v = 0.1381469*na1.y + 0.30716902*nb1.y + 0.051989574*nc1.y + 0.14254308*nd1.y + -0.31925386*ne1.y + 0.12174008*nf1.y + -0.1391733*ng1.y + 0.39536408*nh1.y + -0.12007279*ni1.y;
    w = 0.017454563*na1.z + -0.023681903*nb1.z + -0.034012295*nc1.z + 0.22002162*nd1.z + 0.19791967*ne1.z + 0.038374756*nf1.z + -0.12353062*ng1.z + 0.2688662*nh1.z + -0.052705806*ni1.z;
    x = -0.086231895*na1.w + 0.07504937*nb1.w + 0.11191391*nc1.w + 0.06921204*nd1.w + -0.23228742*ne1.w + -0.022838876*nf1.w + -0.2323649*ng1.w + 0.44247657*nh1.w + -0.081072874*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.014501337;
    i = 0.106080465*a0.x + 0.024061147*b0.x + -0.14801557*c0.x + 0.07124731*d0.x + 0.752269*e0.x + 0.03204864*f0.x + -0.08820241*g0.x + -0.1569472*h0.x + 0.020805335*i0.x;
    j = -0.04939308*a0.y + -0.10871269*b0.y + -0.16962783*c0.y + -0.23772849*d0.y + -0.3210391*e0.y + 0.24698508*f0.y + -0.18247806*g0.y + 0.020352794*h0.y + 0.107976474*i0.y;
    k = 0.10493802*a0.z + -0.099695146*b0.z + -0.096039765*c0.z + 0.11138637*d0.z + -0.14311491*e0.z + -0.092154056*f0.z + 0.0885071*g0.z + -0.008292385*h0.z + -0.10166108*i0.z;
    l = 0.07040726*a0.w + 0.059195396*b0.w + -0.27681613*c0.w + 0.061552662*d0.w + -0.06913211*e0.w + 0.033301804*f0.w + -0.06473411*g0.w + 0.015914617*h0.w + 0.13665281*i0.w;
    m = 0.012200174*a1.x + 0.06378749*b1.x + 0.17070897*c1.x + 0.06860602*d1.x + 0.28465414*e1.x + 0.005732392*f1.x + -0.005431797*g1.x + 0.06197541*h1.x + -0.0360787*i1.x;
    n = -0.08437426*a1.y + -0.23992026*b1.y + 0.021542493*c1.y + -0.014475824*d1.y + 0.78059006*e1.y + -0.2787933*f1.y + 0.15499842*g1.y + -0.116365656*h1.y + -0.0011092337*i1.y;
    o = -0.012601071*a1.z + -0.02089811*b1.z + 0.025689777*c1.z + -0.04252961*d1.z + -0.008140882*e1.z + 0.1501934*f1.z + -0.045148186*g1.z + 0.117176265*h1.z + 0.0904366*i1.z;
    p = 0.13231343*a1.w + -0.3832506*b1.w + -0.045885302*c1.w + -0.30311546*d1.w + 0.003686093*e1.w + -0.027558096*f1.w + -0.11033935*g1.w + -0.28475946*h1.w + 0.13980927*i1.w;
    q = -0.021204935*na0.x + 0.14605576*nb0.x + 0.22979948*nc0.x + 0.105198905*nd0.x + -0.3683901*ne0.x + -0.12239137*nf0.x + 0.15564677*ng0.x + 0.08345597*nh0.x + -0.06942301*ni0.x;
    r = -0.0054337797*na0.y + 0.25162318*nb0.y + 0.17119436*nc0.y + 0.37783152*nd0.y + 0.17348771*ne0.y + -0.19969839*nf0.y + 0.051427353*ng0.y + 0.073170334*nh0.y + -0.0834832*ni0.y;
    s = 0.052913193*na0.z + 0.0704273*nb0.z + 0.06401822*nc0.z + -0.16483103*nd0.z + 0.37591973*ne0.z + 0.17838006*nf0.z + 0.16003473*ng0.z + -0.020194532*nh0.z + 0.11856533*ni0.z;
    t = -0.043170277*na0.w + -0.0056342282*nb0.w + 0.058708046*nc0.w + -0.2180414*nd0.w + -0.07601848*ne0.w + -0.0582804*nf0.w + -0.019155271*ng0.w + -0.20792755*nh0.w + 0.07733804*ni0.w;
    u = 0.08359859*na1.x + -0.1261298*nb1.x + -0.18549688*nc1.x + 0.103082545*nd1.x + -0.15136153*ne1.x + 0.10837961*nf1.x + -0.106412716*ng1.x + -0.17028126*nh1.x + 0.07988672*ni1.x;
    v = 0.025273234*na1.y + 0.31773803*nb1.y + 0.07038893*nc1.y + -0.06201899*nd1.y + -0.16951224*ne1.y + -0.076122746*nf1.y + -0.024976283*ng1.y + 0.0495814*nh1.y + -0.04523248*ni1.y;
    w = 0.13538857*na1.z + -0.25815603*nb1.z + 0.045387045*nc1.z + -0.20980915*nd1.z + -0.021883305*ne1.z + -0.18981177*nf1.z + 0.026633987*ng1.z + -0.2266295*nh1.z + -0.01770804*ni1.z;
    x = 0.09686322*na1.w + 0.20658696*nb1.w + 0.0340205*nc1.w + -0.03438729*nd1.w + 0.28400266*ne1.w + -0.043422848*nf1.w + 0.13553189*ng1.w + -0.09268944*nh1.w + 0.045445822*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.019928804;
    i = 0.02026901*a0.x + 0.05516772*b0.x + -0.026024757*c0.x + -0.048418608*d0.x + -0.57685983*e0.x + 0.14805983*f0.x + -0.20059115*g0.x + 0.041156944*h0.x + 0.24868847*i0.x;
    j = 0.13019085*a0.y + 0.22550349*b0.y + -0.034964323*c0.y + -0.3774061*d0.y + -0.86875886*e0.y + 0.30600658*f0.y + -0.051866774*g0.y + -0.17874694*h0.y + -0.04145627*i0.y;
    k = -0.09908297*a0.z + -0.08187165*b0.z + -0.048987314*c0.z + 0.06511783*d0.z + 0.179538*e0.z + -0.03037813*f0.z + -0.055894785*g0.z + -0.05759495*h0.z + 0.16294672*i0.z;
    l = -0.13788657*a0.w + 0.12234814*b0.w + -0.119818315*c0.w + -0.14877391*d0.w + -0.3761054*e0.w + 0.039558705*f0.w + -0.16355307*g0.w + 0.046041332*h0.w + 0.06886591*i0.w;
    m = -0.11279483*a1.x + 0.08578038*b1.x + -0.009435322*c1.x + 0.044954628*d1.x + -0.23950733*e1.x + -0.06424558*f1.x + 0.00892558*g1.x + -0.10939133*h1.x + -0.18683302*i1.x;
    n = -0.039577417*a1.y + 0.14972863*b1.y + 0.09612399*c1.y + 0.23229071*d1.y + -0.47360322*e1.y + -0.5715504*f1.y + -0.07163973*g1.y + 0.08016445*h1.y + 0.1636036*i1.y;
    o = 0.14617412*a1.z + -0.039677974*b1.z + -0.08629375*c1.z + 0.030945303*d1.z + -0.07581273*e1.z + 0.3790989*f1.z + 0.08369275*g1.z + 0.14806965*h1.z + -0.12494041*i1.z;
    p = -0.0248347*a1.w + 0.0024292504*b1.w + -0.13744679*c1.w + -0.13728984*d1.w + 0.13243796*e1.w + -0.10922235*f1.w + -0.08380444*g1.w + 0.23688291*h1.w + 0.05691377*i1.w;
    q = -0.10243777*na0.x + -0.06303514*nb0.x + 0.014908672*nc0.x + 0.015049333*nd0.x + 0.21912244*ne0.x + -0.24765025*nf0.x + 0.10551951*ng0.x + 0.03512811*nh0.x + -0.14204796*ni0.x;
    r = -0.0230487*na0.y + -0.017737433*nb0.y + 0.10482681*nc0.y + 0.32697034*nd0.y + 0.8010543*ne0.y + -0.4667189*nf0.y + -0.01745576*ng0.y + 0.17689982*nh0.y + -0.0296182*ni0.y;
    s = 0.09821341*na0.z + 0.18462132*nb0.z + 0.08232512*nc0.z + -0.11346741*nd0.z + -0.1312958*ne0.z + 0.053139947*nf0.z + -0.026102895*ng0.z + 0.09144199*nh0.z + 0.017409507*ni0.z;
    t = 0.045446947*na0.w + -0.06908225*nb0.w + 0.031845864*nc0.w + 0.08811338*nd0.w + 0.22084616*ne0.w + 0.21115226*nf0.w + -0.03346275*ng0.w + -0.07632658*nh0.w + -0.18860243*ni0.w;
    u = 0.20821358*na1.x + -0.18966362*nb1.x + -0.20381361*nc1.x + -0.043492407*nd1.x + 0.39594468*ne1.x + 0.14178486*nf1.x + -0.12194247*ng1.x + 0.08705254*nh1.x + 0.17339234*ni1.x;
    v = -0.00416578*na1.y + -0.20208167*nb1.y + -0.08947272*nc1.y + -0.11110711*nd1.y + 0.411256*ne1.y + 0.30017683*nf1.y + 0.18777676*ng1.y + -0.254137*nh1.y + -0.23275565*ni1.y;
    w = 0.07342336*na1.z + 0.06368492*nb1.z + 0.15138967*nc1.z + -0.13334224*nd1.z + -0.28021207*ne1.z + 0.008063743*nf1.z + -0.034982488*ng1.z + 0.09409084*nh1.z + 0.017170021*ni1.z;
    x = 0.11833364*na1.w + 0.16638613*nb1.w + -0.20996292*nc1.w + -0.36111116*nd1.w + -0.39097127*ne1.w + 0.33818159*nf1.w + 0.115348734*ng1.w + -0.2101661*nh1.w + -0.14634638*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.027489815;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN100
//!BIND LUMAN101
//!SAVE LUMAN111

#define L0_tex LUMAN100_tex
#define L1_tex LUMAN101_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.17373292*a0.x + 0.19284575*b0.x + -0.007641241*c0.x + -0.002358787*d0.x + 0.0006856558*e0.x + -0.09435261*f0.x + 0.11603466*g0.x + -0.06616243*h0.x + -0.09116425*i0.x;
    float j = 0.18124478*a0.y + 0.014529217*b0.y + 0.062769316*c0.y + 0.050279245*d0.y + 0.24485901*e0.y + -0.19550173*f0.y + 0.026898274*g0.y + 0.13799283*h0.y + 0.06315003*i0.y;
    float k = -0.07014451*a0.z + 0.103086434*b0.z + -0.057231173*c0.z + -0.170586*d0.z + 0.11335642*e0.z + -0.041360904*f0.z + 0.11781035*g0.z + -0.12804985*h0.z + 0.069926985*i0.z;
    float l = -0.35962218*a0.w + 0.2529284*b0.w + 0.06229109*c0.w + 0.18245831*d0.w + -0.06891447*e0.w + 0.007133068*f0.w + 0.13578556*g0.w + -0.12890998*h0.w + -0.00014882648*i0.w;
    float m = 0.030674135*a1.x + -0.30949405*b1.x + 0.07962323*c1.x + 0.02222668*d1.x + -0.19568637*e1.x + 0.10337853*f1.x + -0.02281463*g1.x + -0.010381191*h1.x + 0.0018512324*i1.x;
    float n = 0.06213026*a1.y + 0.1910823*b1.y + 0.09133128*c1.y + -0.12947819*d1.y + 0.41381067*e1.y + -0.12905987*f1.y + 0.033483107*g1.y + -0.1069458*h1.y + -0.11556056*i1.y;
    float o = -0.12961154*a1.z + -0.2538289*b1.z + -0.016196288*c1.z + -0.496165*d1.z + -0.5219219*e1.z + 0.054612707*f1.z + -0.21407002*g1.z + -0.08868649*h1.z + 0.12545374*i1.z;
    float p = -0.09922678*a1.w + 0.4261237*b1.w + 0.01694553*c1.w + -0.14221108*d1.w + 0.31437156*e1.w + -0.021854276*f1.w + 0.09888452*g1.w + -0.023707569*h1.w + -0.060339298*i1.w;
    float q = 0.16362682*na0.x + -0.30193806*nb0.x + -0.0650482*nc0.x + -0.11592818*nd0.x + 0.0965682*ne0.x + 0.009416448*nf0.x + -0.08027524*ng0.x + -0.11599481*nh0.x + 0.074850865*ni0.x;
    float r = 0.03761324*na0.y + -0.059135627*nb0.y + -0.06904674*nc0.y + 0.07409784*nd0.y + -0.04979788*ne0.y + 0.1656966*nf0.y + -0.17979243*ng0.y + 0.07024214*nh0.y + 0.101452865*ni0.y;
    float s = 0.07054836*na0.z + -0.16477472*nb0.z + 0.167071*nc0.z + 0.056192264*nd0.z + -0.39817235*ne0.z + 0.05435473*nf0.z + 0.055104688*ng0.z + -0.06418159*nh0.z + -0.07037324*ni0.z;
    float t = 0.059324004*na0.w + -0.22754394*nb0.w + 0.109665334*nc0.w + 0.18387087*nd0.w + -0.27932712*ne0.w + 0.17503552*nf0.w + -0.02897829*ng0.w + -0.0827857*nh0.w + 0.08433404*ni0.w;
    float u = -0.0073763453*na1.x + 0.27729753*nb1.x + -0.060492065*nc1.x + -0.10774929*nd1.x + 0.13199492*ne1.x + -0.1717545*nf1.x + 0.08395833*ng1.x + 0.05505113*nh1.x + 0.012973338*ni1.x;
    float v = -0.10820169*na1.y + -0.21685033*nb1.y + -0.054595478*nc1.y + 0.39797196*nd1.y + 0.1346222*ne1.y + 0.06950724*nf1.y + 0.1052441*ng1.y + 0.031800553*nh1.y + 0.042654164*ni1.y;
    float w = 0.2054293*na1.z + 0.26843888*nb1.z + 0.026876204*nc1.z + 0.499534*nd1.z + 0.12252638*ne1.z + 0.19191867*nf1.z + 0.10434292*ng1.z + -0.15850754*nh1.z + -0.12211063*ni1.z;
    float x = 0.229264*na1.w + -0.3270713*nb1.w + 0.05840381*nc1.w + -0.10087737*nd1.w + -0.47804737*ne1.w + 0.14004838*nf1.w + -0.025040176*ng1.w + 0.05155569*nh1.w + 0.15117253*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.021597303;
    i = -0.057124704*a0.x + -0.08187946*b0.x + -0.117976055*c0.x + 0.08626858*d0.x + -0.30131266*e0.x + -0.20291628*f0.x + -0.057278704*g0.x + 0.03727534*h0.x + -0.23938358*i0.x;
    j = 0.23947622*a0.y + -0.19593138*b0.y + -0.22941902*c0.y + 0.1798668*d0.y + 0.4139132*e0.y + -0.56581444*f0.y + -0.21497047*g0.y + 0.29857048*h0.y + -0.12120347*i0.y;
    k = -0.07644*a0.z + 0.02450798*b0.z + 0.006410234*c0.z + -0.28139332*d0.z + 0.20402806*e0.z + 0.03604816*f0.z + -0.057724282*g0.z + 0.06314197*h0.z + 0.043707125*i0.z;
    l = 0.03345192*a0.w + -0.53812677*b0.w + 0.0031058886*c0.w + -0.13964505*d0.w + 0.14953853*e0.w + 0.01489939*f0.w + -0.12053515*g0.w + -0.5023178*h0.w + 0.011425229*i0.w;
    m = 0.007068252*a1.x + -0.057471108*b1.x + 0.049550753*c1.x + 0.16893393*d1.x + -0.22552177*e1.x + 0.10349585*f1.x + 0.068044126*g1.x + -0.020883517*h1.x + 0.010095199*i1.x;
    n = 0.073507585*a1.y + 0.0479716*b1.y + -0.03338529*c1.y + -0.039165337*d1.y + -0.07156169*e1.y + 0.025127547*f1.y + 0.1630653*g1.y + -0.31465036*h1.y + -0.36398607*i1.y;
    o = -0.23844904*a1.z + 0.0669155*b1.z + -0.09081722*c1.z + -0.48886317*d1.z + -0.39759925*e1.z + -0.18523812*f1.z + -0.18028197*g1.z + -0.33321717*h1.z + 0.20330803*i1.z;
    p = -0.05968692*a1.w + -0.07692183*b1.w + -0.23112586*c1.w + -0.060829017*d1.w + -0.7536542*e1.w + -0.2852317*f1.w + -0.0009859608*g1.w + 0.114123434*h1.w + 0.054023914*i1.w;
    q = 0.040426083*na0.x + 0.11305295*nb0.x + 0.010890308*nc0.x + -0.052732646*nd0.x + 0.42032868*ne0.x + 0.1271945*nf0.x + 0.068493925*ng0.x + -0.09621038*nh0.x + 0.12837166*ni0.x;
    r = -0.14453565*na0.y + -0.057656374*nb0.y + 0.23092808*nc0.y + 0.028112093*nd0.y + -0.20953117*ne0.y + 0.56117964*nf0.y + 0.058659226*ng0.y + -0.004577296*nh0.y + 0.26078725*ni0.y;
    s = -0.040808428*na0.z + -0.013124161*nb0.z + 0.077842854*nc0.z + 0.36161858*nd0.z + -0.38513637*ne0.z + -0.032538336*nf0.z + 0.25315204*ng0.z + -0.28682852*nh0.z + -0.13966155*ni0.z;
    t = 0.11649907*na0.w + 0.07209638*nb0.w + 0.017035281*nc0.w + 0.17239003*nd0.w + -0.48884037*ne0.w + 0.095746554*nf0.w + 0.13106976*ng0.w + 0.007163351*nh0.w + 0.20788017*ni0.w;
    u = -0.053024396*na1.x + 0.03632525*nb1.x + -0.042757507*nc1.x + -0.23104651*nd1.x + 0.37475386*ne1.x + -0.15215069*nf1.x + -0.10153369*ng1.x + -0.038243458*nh1.x + 0.058561992*ni1.x;
    v = 0.009218183*na1.y + -0.099357605*nb1.y + 0.02944266*nc1.y + 0.37779808*nd1.y + -0.11301168*ne1.y + 0.06155464*nf1.y + 0.07765676*ng1.y + 0.15920372*nh1.y + 0.09146244*ni1.y;
    w = 0.038626663*na1.z + 0.080353044*nb1.z + 0.12698452*nc1.z + 0.17569828*nd1.z + 0.2910155*ne1.z + 0.4589925*nf1.z + 0.17338121*ng1.z + 0.13693103*nh1.z + -0.12467287*ni1.z;
    x = -0.06830355*na1.w + 0.10666497*nb1.w + 0.081091985*nc1.w + 0.3429561*nd1.w + -0.06758853*ne1.w + 0.029520744*nf1.w + 0.013867191*ng1.w + -0.20614323*nh1.w + 0.2577004*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.014417592;
    i = -0.13472116*a0.x + 0.1510276*b0.x + 0.12627706*c0.x + -0.15310904*d0.x + 0.41393983*e0.x + 0.09215482*f0.x + 0.0076725073*g0.x + -0.19246124*h0.x + -0.024236755*i0.x;
    j = -0.08050447*a0.y + 0.12934619*b0.y + 0.14942114*c0.y + 0.014540216*d0.y + 0.64530516*e0.y + -0.23357749*f0.y + -0.033744495*g0.y + 0.13452643*h0.y + 0.0065132463*i0.y;
    k = -0.07907217*a0.z + 0.0067584133*b0.z + 0.03253729*c0.z + 0.12400924*d0.z + -0.29547116*e0.z + 0.13962397*f0.z + 0.0817104*g0.z + -0.23031056*h0.z + 0.076910056*i0.z;
    l = -0.17478573*a0.w + -0.09128964*b0.w + 0.2052007*c0.w + -0.045583803*d0.w + -0.46769974*e0.w + -0.036914773*f0.w + 0.020994665*g0.w + -0.5500906*h0.w + -0.055351563*i0.w;
    m = 0.110594265*a1.x + -0.2092864*b1.x + -0.055939224*c1.x + -0.20377842*d1.x + -0.068504*e1.x + -0.036410812*f1.x + 0.017022053*g1.x + 0.016182205*h1.x + 0.0033735395*i1.x;
    n = 0.06604512*a1.y + 0.027024498*b1.y + 0.057466883*c1.y + -0.06337822*d1.y + 0.21015161*e1.y + 0.07654835*f1.y + -0.04182454*g1.y + -0.046728626*h1.y + -0.006260675*i1.y;
    o = 0.09531833*a1.z + -0.10230305*b1.z + -0.0032133479*c1.z + 0.099814266*d1.z + 0.44469547*e1.z + -0.17260297*f1.z + -0.09248535*g1.z + 0.08439349*h1.z + 0.017246507*i1.z;
    p = 0.048469406*a1.w + 0.18700768*b1.w + -0.035001382*c1.w + -0.102538124*d1.w + 0.20207775*e1.w + -0.11878294*f1.w + 0.00067176076*g1.w + -0.087286696*h1.w + 0.054357033*i1.w;
    q = 0.12958841*na0.x + -0.22688657*nb0.x + -0.1667106*nc0.x + 0.005056687*nd0.x + -0.4123986*ne0.x + -0.01335008*nf0.x + -0.014480265*ng0.x + 0.06307529*nh0.x + 0.08594915*ni0.x;
    r = 0.10539398*na0.y + -0.10292841*nb0.y + -0.07814285*nc0.y + 0.22097129*nd0.y + -0.5559523*ne0.y + 0.17694168*nf0.y + 0.004478227*ng0.y + 0.032878358*nh0.y + 0.104629084*ni0.y;
    s = -0.0051326617*na0.z + -0.022072861*nb0.z + 0.051479872*nc0.z + -0.1741023*nd0.z + 0.18857563*ne0.z + -0.124328755*nf0.z + -0.10322579*ng0.z + -0.20327476*nh0.z + -0.14588761*ni0.z;
    t = 0.09643955*na0.w + 0.008044043*nb0.w + 0.036409162*nc0.w + -0.045244064*nd0.w + 0.31953487*ne0.w + -0.088307254*nf0.w + 0.07313137*ng0.w + 0.34979767*nh0.w + 0.102764584*ni0.w;
    u = -0.06440282*na1.x + 0.112250455*nb1.x + 0.08934266*nc1.x + 0.24088423*nd1.x + 0.01121725*ne1.x + 0.028617168*nf1.x + 0.047377482*ng1.x + 0.0073287217*nh1.x + 0.11302375*ni1.x;
    v = -0.077449806*na1.y + -0.14188565*nb1.y + 0.05671433*nc1.y + -0.11553248*nd1.y + -0.33997044*ne1.y + -0.01590329*nf1.y + 0.03729859*ng1.y + 0.120862365*nh1.y + -0.20920378*ni1.y;
    w = 0.08520443*na1.z + 0.21813084*nb1.z + -0.037449516*nc1.z + -0.0026980594*nd1.z + -0.17946021*ne1.z + 0.13623233*nf1.z + -0.006548233*ng1.z + 0.11000115*nh1.z + -0.034891665*ni1.z;
    x = 0.0401964*na1.w + -0.3692854*nb1.w + 0.0011840117*nc1.w + -0.22135302*nd1.w + -0.10666167*ne1.w + -0.14273971*nf1.w + -0.12129986*ng1.w + 0.44047737*nh1.w + -0.045440122*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0061564697;
    i = 0.019909037*a0.x + 0.024903378*b0.x + 0.105348505*c0.x + 0.07623088*d0.x + 0.0034105815*e0.x + -0.113691464*f0.x + 0.009286652*g0.x + -0.08961034*h0.x + -0.015141795*i0.x;
    j = 0.14456645*a0.y + -0.35772327*b0.y + 0.025894739*c0.y + -0.13413931*d0.y + 0.33115333*e0.y + -0.05047772*f0.y + -0.061519265*g0.y + -0.11914387*h0.y + 0.007146077*i0.y;
    k = -0.066375226*a0.z + -0.11391145*b0.z + 0.010581036*c0.z + 0.108877584*d0.z + 0.112751186*e0.z + -0.08083832*f0.z + -0.031274974*g0.z + -0.23846108*h0.z + 0.06903504*i0.z;
    l = 0.08046087*a0.w + -0.2478447*b0.w + -0.04181178*c0.w + 0.12691878*d0.w + -0.3055807*e0.w + 0.03303818*f0.w + 0.045794614*g0.w + -0.17669553*h0.w + 0.029193971*i0.w;
    m = 0.13165465*a1.x + 0.08672863*b1.x + -0.0806005*c1.x + -0.15916064*d1.x + -0.1339171*e1.x + 0.07747311*f1.x + 0.06912866*g1.x + 0.054819133*h1.x + -0.0148107195*i1.x;
    n = -0.1043977*a1.y + -0.13850538*b1.y + -0.15452385*c1.y + 0.119476296*d1.y + 0.078670695*e1.y + 0.15949106*f1.y + -0.08756167*g1.y + 0.0844884*h1.y + -0.08666089*i1.y;
    o = -0.07111824*a1.z + 0.04513279*b1.z + -0.13408236*c1.z + 0.047121324*d1.z + 0.24545099*e1.z + 0.2516734*f1.z + -0.0728289*g1.z + -0.08762582*h1.z + -0.07561154*i1.z;
    p = 0.02130893*a1.w + 0.10249944*b1.w + 0.11049336*c1.w + 0.15264595*d1.w + 0.31183988*e1.w + -0.13138242*f1.w + 0.06398149*g1.w + 0.08104154*h1.w + -0.11865529*i1.w;
    q = 0.015509186*na0.x + 0.039872047*nb0.x + -0.092925705*nc0.x + -0.016107129*nd0.x + 0.2357669*ne0.x + 0.14164859*nf0.x + -0.023252146*ng0.x + 0.01461199*nh0.x + 0.021338074*ni0.x;
    r = -0.01427818*na0.y + 0.098217905*nb0.y + 0.06523357*nc0.y + -0.123181134*nd0.y + -0.15354222*ne0.y + -0.012291639*nf0.y + 0.0817894*ng0.y + 0.11550929*nh0.y + -0.0143228425*ni0.y;
    s = -0.06878877*na0.z + -0.027852716*nb0.z + -0.046084825*nc0.z + -0.0063927933*nd0.z + 0.2056926*ne0.z + 0.08226537*nf0.z + -0.038236506*ng0.z + 0.03715226*nh0.z + -0.18274981*ni0.z;
    t = 0.06485456*na0.w + 0.07982155*nb0.w + 0.07997468*nc0.w + -0.14120714*nd0.w + -0.043111116*ne0.w + -0.018716503*nf0.w + 0.036192097*ng0.w + 0.16639654*nh0.w + 0.02141117*ni0.w;
    u = -0.1266023*na1.x + -0.18926698*nb1.x + 0.12713344*nc1.x + 0.07326873*nd1.x + 0.24805826*ne1.x + -0.20831703*nf1.x + -0.02982*ng1.x + -0.12409885*nh1.x + 0.00971056*ni1.x;
    v = 0.10946473*na1.y + 0.18352063*nb1.y + 0.23140769*nc1.y + -0.08708996*nd1.y + -0.37328652*ne1.y + -0.16821873*nf1.y + 0.05127809*ng1.y + 0.04607067*nh1.y + -0.014240281*ni1.y;
    w = 0.032410678*na1.z + -0.054716043*nb1.z + 0.13916765*nc1.z + -0.24632*nd1.z + -0.3030281*ne1.z + -0.14525734*nf1.z + 0.037081942*ng1.z + 0.14404751*nh1.z + 0.07260845*ni1.z;
    x = -0.020973476*na1.w + -0.33283794*nb1.w + -0.02324839*nc1.w + -0.13249202*nd1.w + -0.31107336*ne1.w + -0.044882078*nf1.w + 0.0023130344*ng1.w + 0.12264239*nh1.w + 0.06401549*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.008576719;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN110
//!BIND LUMAN111
//!SAVE LUMAN120

#define L0_tex LUMAN110_tex
#define L1_tex LUMAN111_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.03419658*a0.x + 0.04234174*b0.x + -0.004263536*c0.x + 0.085486904*d0.x + 0.1347802*e0.x + -0.019748386*f0.x + -0.117732905*g0.x + -0.10726092*h0.x + 0.008796778*i0.x;
    float j = 0.145332*a0.y + -0.118838355*b0.y + -0.1386052*c0.y + -0.01958755*d0.y + 0.17036115*e0.y + 0.18370172*f0.y + 0.03361552*g0.y + 0.07884379*h0.y + 0.045483217*i0.y;
    float k = -0.030767104*a0.z + 0.07757515*b0.z + -0.085805915*c0.z + -0.1185484*d0.z + -0.26337406*e0.z + 0.05961827*f0.z + 0.042409312*g0.z + -0.010232436*h0.z + -5.044214e-05*i0.z;
    float l = -0.17780498*a0.w + -0.04013949*b0.w + -0.037311044*c0.w + 0.15648837*d0.w + 0.5124475*e0.w + 0.014651824*f0.w + 0.088576384*g0.w + -0.06640279*h0.w + -0.049112737*i0.w;
    float m = 0.0079423245*a1.x + 0.04602091*b1.x + -0.051456727*c1.x + 0.024389006*d1.x + -0.07325696*e1.x + 0.11012193*f1.x + -0.045976166*g1.x + -0.090682596*h1.x + -0.07234718*i1.x;
    float n = -0.04302659*a1.y + 0.087995455*b1.y + -0.019285012*c1.y + -0.06172422*d1.y + -0.32629314*e1.y + -0.012027535*f1.y + 0.0835997*g1.y + 0.12310212*h1.y + 0.010239601*i1.y;
    float o = -0.049638838*a1.z + 0.076178625*b1.z + -0.05349241*c1.z + -0.107234344*d1.z + -0.186114*e1.z + 0.024813233*f1.z + 0.0060986993*g1.z + -0.07767666*h1.z + -0.035295106*i1.z;
    float p = -0.056122378*a1.w + 0.107091725*b1.w + 0.04479051*c1.w + 0.105193965*d1.w + -0.0037533492*e1.w + -0.026995312*f1.w + 0.18978113*g1.w + 0.12996297*h1.w + 0.023616683*i1.w;
    float q = -0.032792877*na0.x + -0.3012694*nb0.x + 0.009388108*nc0.x + -0.18869895*nd0.x + -0.06794785*ne0.x + 0.07865117*nf0.x + 0.16489376*ng0.x + 0.2827912*nh0.x + -0.019100828*ni0.x;
    float r = 0.044741493*na0.y + -0.22722921*nb0.y + -0.031233322*nc0.y + -0.1825249*nd0.y + 0.1669076*ne0.y + -0.20256056*nf0.y + -0.005387011*ng0.y + -0.052400213*nh0.y + 0.008328497*ni0.y;
    float s = -0.00326432*na0.z + -0.08053971*nb0.z + 0.06993597*nc0.z + 0.16277675*nd0.z + 0.12830172*ne0.z + -0.031723607*nf0.z + -0.056370232*ng0.z + 0.09434579*nh0.z + 0.01401013*ni0.z;
    float t = -0.00080348144*na0.w + -0.0140173435*nb0.w + 0.053308867*nc0.w + 0.07490176*nd0.w + -0.011815553*ne0.w + -0.06710458*nf0.w + -0.11728107*ng0.w + -0.15691936*nh0.w + -0.013996718*ni0.w;
    float u = -0.051334072*na1.x + 0.10004408*nb1.x + 0.017916761*nc1.x + 0.078460515*nd1.x + -0.24399187*ne1.x + 0.019960076*nf1.x + 0.056844246*ng1.x + 0.124312244*nh1.x + -0.0019768244*ni1.x;
    float v = 0.020052563*na1.y + -0.074652724*nb1.y + 0.0058090677*nc1.y + 0.09016366*nd1.y + 0.2910772*ne1.y + 0.032006025*nf1.y + -0.08302292*ng1.y + -0.12736753*nh1.y + 0.004687992*ni1.y;
    float w = -0.041612104*na1.z + -0.09929229*nb1.z + 0.026467089*nc1.z + 0.10896838*nd1.z + 0.08728067*ne1.z + -0.009002156*nf1.z + -0.0019186987*ng1.z + 0.021415843*nh1.z + 0.014931899*ni1.z;
    float x = -0.016585568*na1.w + -0.019664338*nb1.w + -0.010510242*nc1.w + 0.027096234*nd1.w + -0.27564695*ne1.w + -0.0015411398*nf1.w + -0.057726476*ng1.w + -0.17033243*nh1.w + -0.023435434*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0027177525;
    i = 0.064263724*a0.x + -0.039562706*b0.x + -0.002825356*c0.x + 0.27440286*d0.x + -0.20511444*e0.x + 0.0545985*f0.x + 0.09488737*g0.x + -0.20791619*h0.x + 0.051740464*i0.x;
    j = 0.00017828071*a0.y + 0.08186342*b0.y + -0.084284164*c0.y + -0.02336734*d0.y + -0.09449044*e0.y + -0.004509461*f0.y + -0.030286653*g0.y + 0.017867139*h0.y + 0.004724629*i0.y;
    k = 0.0030007442*a0.z + -0.10181248*b0.z + 0.00993031*c0.z + 0.074616954*d0.z + 0.16503222*e0.z + 0.2771392*f0.z + 0.06308826*g0.z + -0.09798749*h0.z + -0.0025535324*i0.z;
    l = -0.08172359*a0.w + 0.12292478*b0.w + -0.16848561*c0.w + 0.07073111*d0.w + -0.73835886*e0.w + 0.19245274*f0.w + -0.1404062*g0.w + 0.24471237*h0.w + -0.12639032*i0.w;
    m = -0.022862365*a1.x + 0.0023818095*b1.x + 0.05612693*c1.x + 0.03942403*d1.x + -0.16278934*e1.x + 0.15510206*f1.x + 0.14307606*g1.x + -0.0066428985*h1.x + -0.068190604*i1.x;
    n = 0.119453914*a1.y + -0.30648935*b1.y + 0.12936467*c1.y + 0.026358444*d1.y + -0.6192209*e1.y + -0.061524224*f1.y + 0.09192626*g1.y + -0.13491037*h1.y + 0.04403033*i1.y;
    o = 0.16812736*a1.z + 0.11960045*b1.z + 0.028085833*c1.z + 0.25032774*d1.z + 0.08565775*e1.z + 0.30494735*f1.z + -0.055606324*g1.z + 0.16188392*h1.z + -0.0043007014*i1.z;
    p = 0.069242105*a1.w + -0.005010746*b1.w + -0.15581696*c1.w + 0.20451608*d1.w + 0.13370973*e1.w + 0.22138312*f1.w + -0.2966924*g1.w + 0.10758237*h1.w + 0.082805164*i1.w;
    q = -0.14249119*na0.x + 0.13207927*nb0.x + 0.008215849*nc0.x + -0.12373979*nd0.x + 0.34873658*ne0.x + -0.09177493*nf0.x + -0.13032945*ng0.x + 0.062212747*nh0.x + 0.06871929*ni0.x;
    r = -0.021839553*na0.y + -0.4821346*nb0.y + -0.08098096*nc0.y + -0.23721185*nd0.y + -0.36681846*ne0.y + 0.09836048*nf0.y + 0.07406981*ng0.y + -0.07001368*nh0.y + -0.33318177*ni0.y;
    s = -0.030489637*na0.z + 0.1602204*nb0.z + 0.014132801*nc0.z + -0.21801928*nd0.z + -0.14850943*ne0.z + -0.121734664*nf0.z + 0.07872759*ng0.z + 0.084055774*nh0.z + 0.010060022*ni0.z;
    t = -0.013205502*na0.w + 0.076589726*nb0.w + -0.08145456*nc0.w + 0.0529249*nd0.w + 0.4912117*ne0.w + -0.054977912*nf0.w + 0.11069747*ng0.w + -0.09718869*nh0.w + -0.1079657*ni0.w;
    u = -0.0013224155*na1.x + -0.075267605*nb1.x + 0.047625992*nc1.x + 0.103593*nd1.x + 0.0070434245*ne1.x + -0.07256906*nf1.x + 0.020944325*ng1.x + 0.0037556116*nh1.x + -0.083298795*ni1.x;
    v = -0.17848632*na1.y + 0.09253789*nb1.y + 0.028199574*nc1.y + 0.049197208*nd1.y + 0.27007762*ne1.y + 0.003407099*nf1.y + -0.007148225*ng1.y + 0.033093993*nh1.y + -0.01289992*ni1.y;
    w = -0.08962241*na1.z + -0.020183992*nb1.z + -0.118681364*nc1.z + 0.004322101*nd1.z + -0.83673894*ne1.z + -0.026786922*nf1.z + 0.05512487*ng1.z + 0.054306448*nh1.z + 0.07126643*ni1.z;
    x = 0.028476331*na1.w + -0.062953666*nb1.w + -0.023954807*nc1.w + 0.027786924*nd1.w + 0.103380345*ne1.w + 0.16595764*nf1.w + -0.063491225*ng1.w + 0.049585197*nh1.w + -0.0935845*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0041770632;
    i = 0.026532259*a0.x + -0.043151964*b0.x + -0.023539152*c0.x + 0.124449484*d0.x + -0.19282119*e0.x + 0.013472447*f0.x + -0.115176246*g0.x + -0.10243189*h0.x + 0.06320668*i0.x;
    j = -0.0059697866*a0.y + 0.043782752*b0.y + -0.09426866*c0.y + 0.050792914*d0.y + -0.09421752*e0.y + -0.017171869*f0.y + -0.09151457*g0.y + 0.07609253*h0.y + 0.13071252*i0.y;
    k = -0.024361333*a0.z + 0.009874322*b0.z + 0.07454306*c0.z + -0.15447307*d0.z + 0.13888164*e0.z + -0.034940712*f0.z + -0.040980965*g0.z + -0.02682383*h0.z + -0.066917755*i0.z;
    l = -0.06584927*a0.w + 0.0035738812*b0.w + 0.05411536*c0.w + 0.051882975*d0.w + 0.25177068*e0.w + 0.032372046*f0.w + 0.11359933*g0.w + 0.05095093*h0.w + -0.07030653*i0.w;
    m = -0.005564911*a1.x + -0.036399335*b1.x + 0.050246976*c1.x + 0.0984369*d1.x + -0.100392096*e1.x + -0.052057363*f1.x + -0.0034145052*g1.x + -0.10695044*h1.x + 0.022204392*i1.x;
    n = -0.1459085*a1.y + 0.020675056*b1.y + -0.06596223*c1.y + -0.14782459*d1.y + 0.12917906*e1.y + -0.0522965*f1.y + 0.09491187*g1.y + -0.016474292*h1.y + -0.13321705*i1.y;
    o = -0.15219742*a1.z + -0.033107433*b1.z + 0.087146364*c1.z + 0.010368419*d1.z + 0.032200083*e1.z + 0.0459494*f1.z + 0.14232826*g1.z + -0.12944774*h1.z + -0.0754529*i1.z;
    p = -0.15429367*a1.w + -0.02448594*b1.w + 0.043734852*c1.w + -0.15192075*d1.w + -0.087126195*e1.w + -0.165763*f1.w + 0.120236985*g1.w + 0.0045476337*h1.w + -0.1184898*i1.w;
    q = -0.024490256*na0.x + -0.01748134*nb0.x + -0.00063394895*nc0.x + -0.14126152*nd0.x + 0.24202287*ne0.x + 0.059133608*nf0.x + 0.05383861*ng0.x + 0.0967077*nh0.x + -0.007970071*ni0.x;
    r = -0.21873847*na0.y + -0.14622325*nb0.y + 0.047783785*nc0.y + 0.034090877*nd0.y + 0.0025731032*ne0.y + -0.14487019*nf0.y + 0.056929756*ng0.y + -0.23404305*nh0.y + 0.025685174*ni0.y;
    s = 0.056901038*na0.z + -0.035735376*nb0.z + -0.023277406*nc0.z + 0.099037796*nd0.z + -0.086797796*ne0.z + 0.019788722*nf0.z + 0.10133625*ng0.z + -0.12101483*nh0.z + 0.02770466*ni0.z;
    t = 0.058126416*na0.w + -0.057519764*nb0.w + -0.012282111*nc0.w + -0.008142407*nd0.w + -0.111955725*ne0.w + -0.015524334*nf0.w + 0.038397934*ng0.w + -0.15748297*nh0.w + -0.00765482*ni0.w;
    u = -0.097768635*na1.x + 0.029718421*nb1.x + -0.010391541*nc1.x + -0.09858282*nd1.x + -0.02233209*ne1.x + -0.011829104*nf1.x + 0.15196133*ng1.x + -0.05273923*nh1.x + -0.036803413*ni1.x;
    v = 0.075455025*na1.y + 0.04232998*nb1.y + 0.00833761*nc1.y + 0.03109816*nd1.y + -0.15964165*ne1.y + -0.02546395*nf1.y + -0.10285106*ng1.y + -0.0079596415*nh1.y + 0.012193279*ni1.y;
    w = 0.11320614*na1.z + 0.056008387*nb1.z + -0.01812151*nc1.z + -0.09234208*nd1.z + 0.33674252*ne1.z + -0.009951529*nf1.z + 0.037884384*ng1.z + 0.39397368*nh1.z + 0.009155979*ni1.z;
    x = 0.043282937*na1.w + -0.022083275*nb1.w + -0.039594356*nc1.w + 0.07992068*nd1.w + -0.021216467*ne1.w + -0.024652136*nf1.w + -0.034756433*ng1.w + -0.088006526*nh1.w + -0.023057858*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0036904276;
    i = 0.071499825*a0.x + -0.017037481*b0.x + -0.04289817*c0.x + -0.06426044*d0.x + 0.11343753*e0.x + -0.005860346*f0.x + -0.10861172*g0.x + 0.08847832*h0.x + -0.018993571*i0.x;
    j = 0.12151444*a0.y + -0.21413642*b0.y + -0.16236494*c0.y + -0.28620937*d0.y + -0.12364789*e0.y + 0.12073757*f0.y + -0.025671931*g0.y + 0.04384527*h0.y + -0.072729446*i0.y;
    k = 0.013037446*a0.z + -0.031395227*b0.z + -0.050007146*c0.z + -0.21211621*d0.z + -0.5972017*e0.z + 0.15161848*f0.z + 0.022896405*g0.z + 0.10271641*h0.z + 0.024362244*i0.z;
    l = -0.069410875*a0.w + -0.22706726*b0.w + -0.021730786*c0.w + 0.019326342*d0.w + -0.13826303*e0.w + -0.021515118*f0.w + -0.02573992*g0.w + -0.0237696*h0.w + 0.0123208*i0.w;
    m = -0.06127183*a1.x + 0.051088296*b1.x + -0.04584946*c1.x + 0.13170096*d1.x + -0.39505032*e1.x + 0.23969938*f1.x + 0.04389141*g1.x + 0.36893818*h1.x + -0.067366585*i1.x;
    n = -0.08085825*a1.y + 0.060302958*b1.y + -0.09919097*c1.y + 0.043645088*d1.y + -0.3812803*e1.y + -0.050985813*f1.y + 0.037130836*g1.y + 0.023081021*h1.y + -0.0247827*i1.y;
    o = -0.004997695*a1.z + 0.13657212*b1.z + 0.056454506*c1.z + 0.07206652*d1.z + -0.33894852*e1.z + 0.009234833*f1.z + 0.018978443*g1.z + 0.021747049*h1.z + 0.061612368*i1.z;
    p = -0.18404841*a1.w + 0.17344272*b1.w + 0.06089598*c1.w + 0.22305518*d1.w + -0.18228509*e1.w + 0.01824805*f1.w + -0.1392599*g1.w + 0.21900408*h1.w + 0.0381708*i1.w;
    q = -0.061211154*na0.x + -0.11969039*nb0.x + 0.09869126*nc0.x + 0.061141904*nd0.x + -0.06691168*ne0.x + 0.0047452394*nf0.x + -0.038700644*ng0.x + 0.039004963*nh0.x + -0.034600914*ni0.x;
    r = 0.0726151*na0.y + -0.081531286*nb0.y + 0.23779625*nc0.y + 0.21001065*nd0.y + -0.5435231*ne0.y + 0.04386579*nf0.y + 0.058399413*ng0.y + 0.045617856*nh0.y + -0.018235456*ni0.y;
    s = 0.070326924*na0.z + 0.06268818*nb0.z + 0.06302981*nc0.z + 0.05526274*nd0.z + 0.46898443*ne0.z + 0.07957147*nf0.z + 0.06066431*ng0.z + 0.037095413*nh0.z + -0.10619575*ni0.z;
    t = -0.051876582*na0.w + 0.0023649358*nb0.w + 0.046784155*nc0.w + 0.11398935*nd0.w + 0.1253422*ne0.w + -0.049485214*nf0.w + 0.0058373916*ng0.w + 0.016857516*nh0.w + -0.058631293*ni0.w;
    u = -0.04962366*na1.x + 0.148904*nb1.x + 0.021688113*nc1.x + 0.15511441*nd1.x + -0.026461873*ne1.x + -0.07623983*nf1.x + -0.029553525*ng1.x + -0.12179555*nh1.x + -0.054989904*ni1.x;
    v = -0.05631037*na1.y + -0.019439436*nb1.y + -0.04202643*nc1.y + -0.108763225*nd1.y + 0.07601197*ne1.y + 0.04292159*nf1.y + 0.059576076*ng1.y + -0.056885466*nh1.y + 0.022964494*ni1.y;
    w = -0.006342543*na1.z + -0.19573995*nb1.z + -0.061908927*nc1.z + 0.089260034*nd1.z + 0.18138929*ne1.z + 0.061845507*nf1.z + -0.04185466*ng1.z + 0.022229565*nh1.z + -0.013937939*ni1.z;
    x = -0.032656766*na1.w + -0.043430645*nb1.w + -0.030643908*nc1.w + 0.11670875*nd1.w + -0.20435229*ne1.w + 0.1200682*nf1.w + -0.16340503*ng1.w + 0.07442494*nh1.w + -0.107492104*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.01253215;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN110
//!BIND LUMAN111
//!SAVE LUMAN121

#define L0_tex LUMAN110_tex
#define L1_tex LUMAN111_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.01899263*a0.x + -0.077505454*b0.x + 0.011978758*c0.x + -0.18674393*d0.x + 0.1015323*e0.x + -0.050859254*f0.x + -0.023585971*g0.x + -0.08158343*h0.x + 0.06631295*i0.x;
    float j = 0.10729953*a0.y + 0.041689463*b0.y + 0.022505827*c0.y + -0.060440443*d0.y + 0.40716222*e0.y + 0.04071186*f0.y + -0.09625937*g0.y + 0.116327144*h0.y + -0.10830027*i0.y;
    float k = -0.091419406*a0.z + -0.11728323*b0.z + 0.12473227*c0.z + -0.11223453*d0.z + -0.7762529*e0.z + 0.2406721*f0.z + 0.058871992*g0.z + -0.3313148*h0.z + 0.008788311*i0.z;
    float l = 0.05685737*a0.w + 0.033411182*b0.w + -0.020573527*c0.w + 0.27094668*d0.w + -0.27309388*e0.w + 0.20446198*f0.w + 0.10291363*g0.w + -0.067330875*h0.w + -0.052683745*i0.w;
    float m = -0.10309394*a1.x + -0.08645983*b1.x + 0.06905719*c1.x + -0.14534827*d1.x + -0.17194697*e1.x + 0.30640042*f1.x + -0.03007999*g1.x + -0.11420834*h1.x + -0.13784356*i1.x;
    float n = 0.035676494*a1.y + -0.092659704*b1.y + 0.10887644*c1.y + 0.40208092*d1.y + -0.011463568*e1.y + 0.16224518*f1.y + 0.060072776*g1.y + -0.06448121*h1.y + 0.0070494837*i1.y;
    float o = 0.05567742*a1.z + -0.036550913*b1.z + 0.017365746*c1.z + 0.21257657*d1.z + -0.81188375*e1.z + 0.030954812*f1.z + -0.0074971644*g1.z + -0.085213356*h1.z + 0.0605237*i1.z;
    float p = 0.07070759*a1.w + 0.028305933*b1.w + -0.16159725*c1.w + 0.19094543*d1.w + -0.48007774*e1.w + 0.21894419*f1.w + 0.14849436*g1.w + -0.5190051*h1.w + 0.049825452*i1.w;
    float q = 0.048532236*na0.x + 0.10520654*nb0.x + -0.02212896*nc0.x + 0.36066028*nd0.x + -0.40558204*ne0.x + 0.027699763*nf0.x + -0.049928706*ng0.x + 0.07140545*nh0.x + -0.040809184*ni0.x;
    float r = -0.22017251*na0.y + -0.5950039*nb0.y + 0.016011601*nc0.y + 0.1787457*nd0.y + -0.56953317*ne0.y + 0.0016789446*nf0.y + -0.0152591895*ng0.y + -0.14698845*nh0.y + -0.038240127*ni0.y;
    float s = 0.012132073*na0.z + 0.20379305*nb0.z + -0.15244928*nc0.z + 0.013908276*nd0.z + 0.57205755*ne0.z + -0.08137592*nf0.z + -0.0420915*ng0.z + 0.2314901*nh0.z + -0.0030451296*ni0.z;
    float t = -0.16107729*na0.w + 0.08787612*nb0.w + -0.05292994*nc0.w + -0.21465571*nd0.w + -0.124343075*ne0.w + -0.03303205*nf0.w + 0.029135289*ng0.w + -0.0094405655*nh0.w + -0.027233165*ni0.w;
    float u = 0.08539263*na1.x + 0.05341449*nb1.x + 0.051422648*nc1.x + 0.22483036*nd1.x + 0.063043155*ne1.x + -0.23852657*nf1.x + 0.18041016*ng1.x + -0.16212112*nh1.x + 0.046412155*ni1.x;
    float v = -0.021413365*na1.y + 0.09399336*nb1.y + -0.045479856*nc1.y + -0.36818838*nd1.y + 0.0050471546*ne1.y + -0.06243919*nf1.y + -0.035713788*ng1.y + 0.024699768*nh1.y + -0.06425166*ni1.y;
    float w = -0.031438354*na1.z + -0.09332041*nb1.z + -0.14652777*nc1.z + 0.06121613*nd1.z + 0.28410488*ne1.z + 0.20931922*nf1.z + 0.17510334*ng1.z + 0.04678771*nh1.z + -0.11084662*ni1.z;
    float x = -0.03878583*na1.w + 0.11566247*nb1.w + -0.028782109*nc1.w + -0.094483145*nd1.w + 0.18686369*ne1.w + -0.14853023*nf1.w + -0.13913757*ng1.w + 0.40824965*nh1.w + -0.06846965*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.014384879;
    i = 0.081302285*a0.x + -0.01200884*b0.x + 0.0051810266*c0.x + 0.22885948*d0.x + 0.5016418*e0.x + -0.022700071*f0.x + -0.11625609*g0.x + 0.3755614*h0.x + 0.042606056*i0.x;
    j = -0.24225157*a0.y + -0.03035787*b0.y + -0.02878385*c0.y + -0.27371392*d0.y + 0.30426234*e0.y + 0.29937968*f0.y + -0.06833015*g0.y + -0.28164467*h0.y + -0.19420598*i0.y;
    k = 0.13838074*a0.z + -0.0693596*b0.z + -0.0144782495*c0.z + -0.21116641*d0.z + 0.050632227*e0.z + 0.08093468*f0.z + 0.02682863*g0.z + 0.021293785*h0.z + -0.006511923*i0.z;
    l = -0.011891017*a0.w + 0.12183185*b0.w + -0.006066711*c0.w + -0.14056961*d0.w + 0.23668641*e0.w + 0.17993811*f0.w + -0.15009682*g0.w + -0.18186209*h0.w + 0.10996275*i0.w;
    m = -0.114001215*a1.x + 0.08040355*b1.x + -0.050432112*c1.x + 0.056575384*d1.x + -0.19978435*e1.x + 0.06969095*f1.x + -0.03081741*g1.x + -0.029842261*h1.x + 0.004736284*i1.x;
    n = -0.013636102*a1.y + -0.24603765*b1.y + -0.027649323*c1.y + 0.09448466*d1.y + 0.46935272*e1.y + 0.005321074*f1.y + -0.023053408*g1.y + -0.18916315*h1.y + -0.05621936*i1.y;
    o = 0.0020085343*a1.z + -0.11732761*b1.z + -0.02356044*c1.z + 0.12710598*d1.z + 0.10050475*e1.z + -0.042752214*f1.z + -0.012645914*g1.z + -0.015005672*h1.z + -0.028899282*i1.z;
    p = -0.13963965*a1.w + -0.21774001*b1.w + -0.058217425*c1.w + 0.23380725*d1.w + 0.4253219*e1.w + 0.26903352*f1.w + -0.024840405*g1.w + -0.47157192*h1.w + -0.32442856*i1.w;
    q = -0.004313836*na0.x + 0.35438684*nb0.x + -0.02928308*nc0.x + 0.06393032*nd0.x + -0.4129571*ne0.x + 0.16209923*nf0.x + -0.0034282196*ng0.x + -0.51319665*nh0.x + -0.013644353*ni0.x;
    r = 0.05253109*na0.y + 0.20828614*nb0.y + -0.26114675*nc0.y + 0.2565526*nd0.y + -0.03439458*ne0.y + -0.16548492*nf0.y + 0.015113385*ng0.y + 0.06683532*nh0.y + 0.270508*ni0.y;
    s = 0.033214018*na0.z + 0.13922311*nb0.z + 0.026104584*nc0.z + 0.0142909745*nd0.z + -0.27592355*ne0.z + 0.05822074*nf0.z + 0.12518267*ng0.z + -0.0016699395*nh0.z + -0.03275272*ni0.z;
    t = 0.09762718*na0.w + -0.15567127*nb0.w + -0.1329481*nc0.w + 0.15287872*nd0.w + -0.47752786*ne0.w + -0.22881676*nf0.w + 0.037979577*ng0.w + 0.37223414*nh0.w + 0.058603775*ni0.w;
    u = -0.042465784*na1.x + -0.02099335*nb1.x + 0.09778185*nc1.x + 0.15799712*nd1.x + 0.15365987*ne1.x + -0.27508533*nf1.x + 0.039696578*ng1.x + -0.16741951*nh1.x + 0.06984442*ni1.x;
    v = -0.0752755*na1.y + 0.24538422*nb1.y + 0.0077161137*nc1.y + -0.0127162*nd1.y + -0.53776336*ne1.y + 0.008082307*nf1.y + -0.0023270606*ng1.y + 0.17226219*nh1.y + 0.03457291*ni1.y;
    w = -0.08648925*na1.z + 0.12630469*nb1.z + -0.13315432*nc1.z + -0.020660728*nd1.z + -0.21132655*ne1.z + 0.23985873*nf1.z + -0.10585773*ng1.z + 0.23141496*nh1.z + -0.11902503*ni1.z;
    x = -0.06618379*na1.w + -0.2273994*nb1.w + 0.077781565*nc1.w + 0.046340372*nd1.w + -0.15985714*ne1.w + -0.015358807*nf1.w + -0.19775797*ng1.w + 0.12113512*nh1.w + -0.040067535*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.002771056;
    i = 0.021606864*a0.x + -0.08928166*b0.x + -0.08577098*c0.x + 0.116481096*d0.x + 0.028323913*e0.x + -0.036533065*f0.x + -0.075527035*g0.x + 0.012755163*h0.x + 0.020122685*i0.x;
    j = 0.0028853463*a0.y + -0.18811181*b0.y + -0.17382199*c0.y + 0.068786174*d0.y + 0.05918515*e0.y + -0.14406848*f0.y + -0.027476229*g0.y + -0.13845423*h0.y + 0.015846852*i0.y;
    k = 0.06259905*a0.z + 0.040686153*b0.z + -0.09959466*c0.z + -0.044038236*d0.z + 0.32777426*e0.z + 0.032428484*f0.z + -0.11056117*g0.z + 0.17431906*h0.z + -0.02379753*i0.z;
    l = -0.25824967*a0.w + -0.18743302*b0.w + 0.0044342517*c0.w + -0.1706001*d0.w + 0.19157986*e0.w + -0.13212295*f0.w + -0.042633854*g0.w + -0.11158089*h0.w + -0.021044202*i0.w;
    m = 0.047586076*a1.x + -0.035441607*b1.x + -0.12803088*c1.x + 0.20249197*d1.x + 0.13793948*e1.x + 0.29371345*f1.x + 0.077109165*g1.x + 0.3541602*h1.x + -0.048006814*i1.x;
    n = -0.22914135*a1.y + 0.10113166*b1.y + -0.2540913*c1.y + -0.2997133*d1.y + -0.021689592*e1.y + -0.18026315*f1.y + -0.06550943*g1.y + 0.11176253*h1.y + -0.123405196*i1.y;
    o = -0.12822497*a1.z + 0.28259254*b1.z + 0.2307225*c1.z + -0.02333415*d1.z + 0.3453413*e1.z + -0.034818113*f1.z + 0.054801736*g1.z + 0.16259307*h1.z + 0.13333833*i1.z;
    p = -0.39024496*a1.w + 0.021573117*b1.w + 0.08599005*c1.w + -0.42476216*d1.w + -0.7817298*e1.w + -0.2601256*f1.w + 0.021591498*g1.w + 0.309251*h1.w + -0.06791641*i1.w;
    q = -0.14430566*na0.x + -0.11055743*nb0.x + 0.105672106*nc0.x + -0.25145876*nd0.x + 0.1106223*ne0.x + -0.0066601806*nf0.x + 0.008009466*ng0.x + 0.15834406*nh0.x + -0.04079572*ni0.x;
    r = 0.08744367*na0.y + 0.105490685*nb0.y + 0.31114987*nc0.y + 0.07603488*nd0.y + 0.17058893*ne0.y + 0.22760919*nf0.y + 0.006074983*ng0.y + 0.08326886*nh0.y + 0.15943988*ni0.y;
    s = 0.050332133*na0.z + -0.0766741*nb0.z + 0.1285683*nc0.z + 0.055331063*nd0.z + -0.60682815*ne0.z + 0.1371641*nf0.z + 0.18354717*ng0.z + 0.03286175*nh0.z + -0.07859616*ni0.z;
    t = 0.10502813*na0.w + -0.027062168*nb0.w + 0.055231456*nc0.w + 0.14236453*nd0.w + 0.10616334*ne0.w + 0.09435703*nf0.w + 0.07842552*ng0.w + -0.06887093*nh0.w + -0.024590459*ni0.w;
    u = -0.20450965*na1.x + 0.096837066*nb1.x + 0.03443422*nc1.x + -0.25169346*nd1.x + -0.09789607*ne1.x + -0.15015261*nf1.x + -0.015787307*ng1.x + 0.055096075*nh1.x + -0.037342865*ni1.x;
    v = 0.08175798*na1.y + 0.02664857*nb1.y + -0.022075763*nc1.y + 0.12141814*nd1.y + -0.02737079*ne1.y + 0.04700818*nf1.y + 0.04346721*ng1.y + -0.07328907*nh1.y + 0.04347813*ni1.y;
    w = 0.12698099*na1.z + -0.18376732*nb1.z + -0.13291064*nc1.z + -0.1144856*nd1.z + -0.09359536*ne1.z + -0.018985584*nf1.z + -0.039779156*ng1.z + 0.0033084468*nh1.z + -0.09617441*ni1.z;
    x = 0.12593117*na1.w + -0.050418727*nb1.w + -0.037301436*nc1.w + 0.24911767*nd1.w + -0.35904863*ne1.w + 0.2984039*nf1.w + 0.09867465*ng1.w + -0.20010832*nh1.w + 0.05439809*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.00091614726;
    i = -0.06394797*a0.x + -0.10589785*b0.x + 0.071662396*c0.x + 0.23248084*d0.x + -0.69144565*e0.x + 0.20778444*f0.x + 0.08832192*g0.x + -0.114318825*h0.x + -0.046119977*i0.x;
    j = -0.018593391*a0.y + 0.25111246*b0.y + -0.2612264*c0.y + 0.0385463*d0.y + 0.6223591*e0.y + 0.026857028*f0.y + -0.014829569*g0.y + 0.1277322*h0.y + 0.0584881*i0.y;
    k = 0.023849497*a0.z + -0.067284025*b0.z + 0.1418698*c0.z + -0.010982118*d0.z + 0.16797899*e0.z + -0.14820707*f0.z + -0.023809081*g0.z + -0.090138786*h0.z + 0.014505213*i0.z;
    l = 0.12983774*a0.w + -0.029752735*b0.w + -0.07501964*c0.w + -0.07778343*d0.w + 0.18478629*e0.w + -0.27968863*f0.w + -0.041439153*g0.w + 0.1744004*h0.w + 0.015227504*i0.w;
    m = -0.020664224*a1.x + -0.0038989927*b1.x + -0.031596243*c1.x + -0.0101110535*d1.x + -0.06884738*e1.x + -0.1365087*f1.x + 0.014945645*g1.x + -0.030193496*h1.x + 0.0163872*i1.x;
    n = -0.0004287638*a1.y + 0.010622353*b1.y + 0.09724528*c1.y + 0.14886458*d1.y + 0.08720078*e1.y + -0.15509501*f1.y + 0.06435047*g1.y + 0.05138851*h1.y + 0.06877765*i1.y;
    o = 0.033485916*a1.z + 0.2254674*b1.z + 0.13985848*c1.z + 0.1105003*d1.z + -0.25495616*e1.z + -0.0071104667*f1.z + 0.00394771*g1.z + -0.044202417*h1.z + -0.056555733*i1.z;
    p = -0.06150365*a1.w + 0.37854615*b1.w + 0.16227704*c1.w + 0.09953428*d1.w + 0.6951193*e1.w + -0.00896644*f1.w + -0.14055361*g1.w + -0.09406019*h1.w + 0.11679244*i1.w;
    q = 0.044572912*na0.x + 0.16796306*nb0.x + -0.06547087*nc0.x + -0.048156604*nd0.x + 0.5251333*ne0.x + -0.15836562*nf0.x + -0.06462838*ng0.x + 0.09596074*nh0.x + 0.037825905*ni0.x;
    r = -0.23161076*na0.y + -0.65139836*nb0.y + 0.13197362*nc0.y + -0.05546677*nd0.y + -0.97165394*ne0.y + -0.30722955*nf0.y + -0.017831514*ng0.y + -0.03898181*nh0.y + -0.17043829*ni0.y;
    s = 0.057691526*na0.z + 0.0524966*nb0.z + -0.03153983*nc0.z + -0.0503038*nd0.z + 0.08104926*ne0.z + 0.06692566*nf0.z + -0.013073635*ng0.z + -0.008260687*nh0.z + 0.010080927*ni0.z;
    t = -0.05453099*na0.w + -0.18063734*nb0.w + 0.16694653*nc0.w + -0.028910562*nd0.w + -0.42992082*ne0.w + 0.16023055*nf0.w + 0.038325876*ng0.w + -0.14538842*nh0.w + -0.023606323*ni0.w;
    u = -0.07181944*na1.x + 0.14208739*nb1.x + -0.0039082896*nc1.x + 0.00190685*nd1.x + 0.17796423*ne1.x + 0.08351044*nf1.x + -0.044966634*ng1.x + -0.06406277*nh1.x + 0.06725832*ni1.x;
    v = -0.0071947016*na1.y + 0.0006096204*nb1.y + -0.13142252*nc1.y + -0.007630795*nd1.y + 0.028756304*ne1.y + 0.039658252*nf1.y + 0.009520045*ng1.y + -0.03928686*nh1.y + -0.1010825*ni1.y;
    w = -0.049172632*na1.z + -0.35113806*nb1.z + 0.022209*nc1.z + -0.026630908*nd1.z + 0.23890342*ne1.z + -0.06114634*nf1.z + 0.019761385*ng1.z + 0.08615667*nh1.z + 0.0992877*ni1.z;
    x = 0.0073823123*na1.w + -0.110830136*nb1.w + 0.027609926*nc1.w + 0.019419665*nd1.w + -0.24567391*ne1.w + -0.050785057*nf1.w + 0.05211453*ng1.w + -0.022167444*nh1.w + -0.09944939*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.005509867;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN120
//!BIND LUMAN121
//!SAVE LUMAN130

#define L0_tex LUMAN120_tex
#define L1_tex LUMAN121_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.07173966*a0.x + 0.05524066*b0.x + -0.21521214*c0.x + -0.12502593*d0.x + 0.30083555*e0.x + 0.5521808*f0.x + 0.27752915*g0.x + -0.27389202*h0.x + -0.13792084*i0.x;
    float j = -0.018661562*a0.y + 0.12920462*b0.y + -0.050642636*c0.y + -0.05618292*d0.y + -0.2634706*e0.y + 0.08305681*f0.y + 0.07627947*g0.y + -0.03478369*h0.y + 0.008291865*i0.y;
    float k = 0.3203911*a0.z + -0.10194117*b0.z + 0.5750903*c0.z + 0.027564753*d0.z + 0.20415193*e0.z + -0.32818332*f0.z + 0.0064895176*g0.z + 0.11268637*h0.z + -0.07566682*i0.z;
    float l = -0.20254683*a0.w + -0.028722532*b0.w + 0.20982566*c0.w + -0.03934203*d0.w + 1.1664512*e0.w + -0.35541716*f0.w + 0.1317692*g0.w + 0.2791658*h0.w + -0.0008373487*i0.w;
    float m = 0.11692941*a1.x + -0.5743238*b1.x + -0.020805841*c1.x + 0.06912012*d1.x + 0.7215903*e1.x + 0.08506985*f1.x + -0.1770724*g1.x + -0.021816388*h1.x + -0.0012947934*i1.x;
    float n = -0.016384576*a1.y + 0.03555106*b1.y + 0.06288962*c1.y + 0.29152143*d1.y + -0.86737454*e1.y + 0.47646257*f1.y + 0.046224713*g1.y + 0.05431801*h1.y + -0.20437165*i1.y;
    float o = -0.19650295*a1.z + 0.36212683*b1.z + -0.09464794*c1.z + 0.21289517*d1.z + -0.49227223*e1.z + 0.12496616*f1.z + 0.010253889*g1.z + -0.039342172*h1.z + -0.0389005*i1.z;
    float p = 0.10064498*a1.w + 0.037331007*b1.w + -0.20260917*c1.w + -0.018359315*d1.w + -0.3830645*e1.w + 0.18125847*f1.w + -0.052647024*g1.w + 0.088890396*h1.w + -0.029746594*i1.w;
    float q = -0.10467294*na0.x + 0.25880128*nb0.x + -0.041262787*nc0.x + -0.043955367*nd0.x + -0.08661329*ne0.x + 0.050330844*nf0.x + -0.02470256*ng0.x + -0.10187702*nh0.x + -0.026671588*ni0.x;
    float r = -0.005288939*na0.y + 0.07448776*nb0.y + -0.1311754*nc0.y + -0.20314097*nd0.y + -0.41264915*ne0.y + -0.26195058*nf0.y + 0.015994098*ng0.y + 0.17131393*nh0.y + -0.042960033*ni0.y;
    float s = -0.05252907*na0.z + 0.19381894*nb0.z + 0.031247867*nc0.z + 0.059349507*nd0.z + 0.0496565*ne0.z + -0.036475737*nf0.z + 0.061698027*ng0.z + -0.019937498*nh0.z + 0.031974547*ni0.z;
    float t = 0.0596274*na0.w + -0.074480556*nb0.w + -0.04917453*nc0.w + -0.091791056*nd0.w + -0.1944997*ne0.w + -0.15632756*nf0.w + 0.1029948*ng0.w + -0.15851589*nh0.w + -0.040070053*ni0.w;
    float u = -0.19576977*na1.x + 0.090122245*nb1.x + 0.028307155*nc1.x + 0.18360525*nd1.x + 0.021744814*ne1.x + -0.025507484*nf1.x + -0.10279109*ng1.x + 0.12280133*nh1.x + -0.045142133*ni1.x;
    float v = -0.027888902*na1.y + 0.029968994*nb1.y + 0.0361322*nc1.y + 0.022657184*nd1.y + -0.16778767*ne1.y + -0.024502534*nf1.y + -0.022329496*ng1.y + -0.07601257*nh1.y + 0.03833047*ni1.y;
    float w = 0.0653101*na1.z + -0.16791722*nb1.z + -0.0092719225*nc1.z + 0.10876519*nd1.z + 0.6509129*ne1.z + -0.09831674*nf1.z + -0.07682791*ng1.z + 0.08948414*nh1.z + -0.025521843*ni1.z;
    float x = -0.12456352*na1.w + -0.09949522*nb1.w + 0.055695318*nc1.w + 0.07635483*nd1.w + 0.76795757*ne1.w + -0.16395962*nf1.w + -0.116975896*ng1.w + -0.19186862*nh1.w + 0.21049598*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.013636319;
    i = 0.042530164*a0.x + 0.07018646*b0.x + -0.24715914*c0.x + 0.046272676*d0.x + 0.27483156*e0.x + 0.10328371*f0.x + -0.109125644*g0.x + 0.09677094*h0.x + 0.07537059*i0.x;
    j = -0.004949831*a0.y + -0.020548534*b0.y + -0.025159743*c0.y + 0.058468964*d0.y + 0.34713256*e0.y + 0.017708272*f0.y + -0.010207437*g0.y + -0.031564705*h0.y + -0.03981632*i0.y;
    k = -0.21877033*a0.z + -0.043471135*b0.z + -0.019215649*c0.z + -0.022867844*d0.z + 0.21302997*e0.z + -0.3662721*f0.z + 0.03106331*g0.z + 0.07036724*h0.z + -0.24083485*i0.z;
    l = -0.08853993*a0.w + 0.0015703896*b0.w + 0.11063675*c0.w + 0.018928405*d0.w + -0.24625982*e0.w + 0.17761426*f0.w + 0.06680052*g0.w + 0.25644967*h0.w + -0.09996918*i0.w;
    m = 0.045116182*a1.x + -0.4170642*b1.x + 0.24441446*c1.x + 0.2228244*d1.x + -0.7826016*e1.x + 0.053818185*f1.x + 0.23531969*g1.x + -0.5276906*h1.x + -0.017621778*i1.x;
    n = -0.04748159*a1.y + 0.14208545*b1.y + -0.08716088*c1.y + 0.16001788*d1.y + -0.11126903*e1.y + 0.15226895*f1.y + -0.054882083*g1.y + 0.027261125*h1.y + -0.007631973*i1.y;
    o = 0.045499023*a1.z + -0.109854676*b1.z + 0.056851212*c1.z + 0.016088946*d1.z + -0.021904342*e1.z + 0.16645917*f1.z + 0.017442156*g1.z + -0.18457061*h1.z + 0.12634978*i1.z;
    p = -0.12596329*a1.w + 0.2599066*b1.w + -0.106144205*c1.w + 0.22593817*d1.w + 0.16219479*e1.w + 0.16036382*f1.w + -0.04179427*g1.w + -0.098000705*h1.w + 0.13039199*i1.w;
    q = 0.10479193*na0.x + -0.17233655*nb0.x + -0.060700305*nc0.x + 0.06606078*nd0.x + -0.089419335*ne0.x + 0.20349522*nf0.x + -0.02300001*ng0.x + -0.05826102*nh0.x + 0.05089717*ni0.x;
    r = -0.056828115*na0.y + 0.060302604*nb0.y + 0.024080917*nc0.y + -0.082361214*nd0.y + -0.1468351*ne0.y + -0.020615399*nf0.y + 0.022000078*ng0.y + 0.08448483*nh0.y + 0.029490553*ni0.y;
    s = -0.20444779*na0.z + 0.363772*nb0.z + 0.013757455*nc0.z + -0.027767507*nd0.z + 0.086781934*ne0.z + 0.042837158*nf0.z + -0.0028691744*ng0.z + -0.048100833*nh0.z + -0.03654709*ni0.z;
    t = 0.04099425*na0.w + 0.050848916*nb0.w + 0.09634782*nc0.w + 0.16893995*nd0.w + -0.10806615*ne0.w + 0.1542499*nf0.w + -0.1305786*ng0.w + -0.11792504*nh0.w + 0.030942632*ni0.w;
    u = -0.00045687062*na1.x + -0.11489277*nb1.x + -0.04124386*nc1.x + 0.020468015*nd1.x + 0.5372667*ne1.x + 0.059690394*nf1.x + 0.14485446*ng1.x + 0.069309615*nh1.x + -0.02704002*ni1.x;
    v = -0.0934174*na1.y + 0.04013287*nb1.y + -0.01692319*nc1.y + 0.062415145*nd1.y + 0.20963359*ne1.y + -0.10348718*nf1.y + -0.013736046*ng1.y + -0.021258404*nh1.y + -0.047034536*ni1.y;
    w = 0.08916951*na1.z + -0.24287029*nb1.z + -0.056870934*nc1.z + 0.025470622*nd1.z + -0.3036939*ne1.z + -0.15004703*nf1.z + 0.037480198*ng1.z + -0.20328596*nh1.z + 0.124831766*ni1.z;
    x = -0.011442481*na1.w + 0.077219054*nb1.w + -0.013083296*nc1.w + 0.14963494*nd1.w + -0.5541406*ne1.w + -0.053182814*nf1.w + 0.056806713*ng1.w + -0.43407235*nh1.w + 0.21133529*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.020445773;
    i = -0.060422402*a0.x + -0.06825925*b0.x + -0.057646785*c0.x + -0.16212627*d0.x + -0.32644564*e0.x + 0.12910526*f0.x + -0.063041456*g0.x + 0.07560072*h0.x + -0.015426578*i0.x;
    j = -0.006889652*a0.y + -0.17347373*b0.y + 0.016179034*c0.y + 0.058115833*d0.y + 0.31190333*e0.y + -0.078174144*f0.y + -0.07960504*g0.y + 0.12811723*h0.y + 0.0055712913*i0.y;
    k = -0.24560466*a0.z + 0.16410764*b0.z + -0.22483738*c0.z + 0.07343547*d0.z + -0.057290845*e0.z + -0.3933686*f0.z + -0.050107088*g0.z + -0.13618156*h0.z + 0.24685264*i0.z;
    l = 0.106292695*a0.w + -0.12385596*b0.w + 0.15031956*c0.w + -0.019425064*d0.w + 0.20487277*e0.w + -0.4166029*f0.w + 0.049125712*g0.w + -0.18145804*h0.w + 0.22562954*i0.w;
    m = -0.061704915*a1.x + 0.021972679*b1.x + 0.03886212*c1.x + 0.00050829595*d1.x + -0.50772375*e1.x + 0.1848391*f1.x + -0.09643155*g1.x + 0.2006514*h1.x + -0.1370429*i1.x;
    n = -0.12936626*a1.y + 0.21173458*b1.y + -0.002170517*c1.y + -0.016762713*d1.y + -0.56988305*e1.y + -0.35746378*f1.y + -0.03237757*g1.y + -0.061048053*h1.y + 0.15020193*i1.y;
    o = 0.122485116*a1.z + -0.18640561*b1.z + -0.0009304099*c1.z + -0.10620465*d1.z + -0.017849369*e1.z + 0.18167005*f1.z + -0.13736731*g1.z + 0.06757091*h1.z + -0.033063065*i1.z;
    p = -0.08587528*a1.w + 0.14814755*b1.w + 0.10723197*c1.w + 0.25996724*d1.w + -0.27067813*e1.w + 0.023977801*f1.w + -0.11409169*g1.w + 0.08244975*h1.w + -0.07811598*i1.w;
    q = 0.09545891*na0.x + -0.26934135*nb0.x + 0.084429435*nc0.x + -0.027571537*nd0.x + 0.18728629*ne0.x + -0.034010876*nf0.x + 0.11272564*ng0.x + -0.02174526*nh0.x + 0.031401962*ni0.x;
    r = -0.058911406*na0.y + 0.117469706*nb0.y + 0.07483167*nc0.y + 0.25347975*nd0.y + -0.8893511*ne0.y + 0.11577824*nf0.y + -0.019952424*ng0.y + -0.32625362*nh0.y + 0.054697443*ni0.y;
    s = 0.058437176*na0.z + 0.12717098*nb0.z + -0.030477263*nc0.z + 0.025787791*nd0.z + -0.55476403*ne0.z + 0.10344902*nf0.z + -0.049927607*ng0.z + 0.0034100525*nh0.z + -0.014674564*ni0.z;
    t = -0.039341412*na0.w + 0.24266788*nb0.w + -0.13092296*nc0.w + -0.078149125*nd0.w + -0.1825526*ne0.w + 0.39637613*nf0.w + -0.07388616*ng0.w + 0.07066076*nh0.w + -0.068194985*ni0.w;
    u = 0.16596706*na1.x + -0.17953089*nb1.x + 0.05764661*nc1.x + -0.11200913*nd1.x + 0.4304551*ne1.x + -0.20531161*nf1.x + 0.057423525*ng1.x + -0.0616747*nh1.x + 0.09423837*ni1.x;
    v = -0.0030923756*na1.y + -0.005227259*nb1.y + 0.00855408*nc1.y + 0.05933646*nd1.y + 0.1647804*ne1.y + -0.014145093*nf1.y + 0.029180478*ng1.y + 0.015440778*nh1.y + -0.0042728186*ni1.y;
    w = -0.04026973*na1.z + -0.09111073*nb1.z + 0.09226495*nc1.z + 0.029515188*nd1.z + -0.2941943*ne1.z + -0.37025875*nf1.z + -0.0482752*ng1.z + 0.023515888*nh1.z + 0.13930896*ni1.z;
    x = 0.05243473*na1.w + 0.021479629*nb1.w + -0.0098233*nc1.w + 0.13860157*nd1.w + -0.9362658*ne1.w + 0.13477142*nf1.w + -0.0016362248*ng1.w + 0.3428101*nh1.w + -0.06643634*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.00026336784;
    i = 0.13095191*a0.x + 0.071042016*b0.x + 0.15989769*c0.x + -0.4085044*d0.x + -1.1903197*e0.x + -0.8063476*f0.x + 0.1758939*g0.x + 0.29856923*h0.x + 0.018587846*i0.x;
    j = -0.0429038*a0.y + -0.046388038*b0.y + 0.050304305*c0.y + -0.012282529*d0.y + 0.50057316*e0.y + 0.102298446*f0.y + -0.047718488*g0.y + 0.011400605*h0.y + -0.040591896*i0.y;
    k = -0.08647257*a0.z + 0.06590021*b0.z + -0.10776554*c0.z + 0.05844034*d0.z + 0.15784912*e0.z + -0.050049458*f0.z + -0.08851963*g0.z + -0.09389101*h0.z + -0.07156607*i0.z;
    l = -0.020921769*a0.w + 0.13630044*b0.w + 0.04598389*c0.w + -0.022334518*d0.w + -0.3560804*e0.w + 0.66281724*f0.w + 0.08330941*g0.w + -0.050354507*h0.w + 0.0063697495*i0.w;
    m = 0.07382021*a1.x + 0.14582287*b1.x + -0.026436277*c1.x + 0.032368336*d1.x + 0.123083666*e1.x + 0.016335508*f1.x + -0.18557611*g1.x + 0.33704454*h1.x + 0.060447156*i1.x;
    n = -0.24164051*a1.y + -0.17663498*b1.y + 0.017156934*c1.y + 0.11470921*d1.y + -0.2480085*e1.y + 0.03648527*f1.y + 0.01601964*g1.y + -0.17307469*h1.y + -0.25195485*i1.y;
    o = 0.044692397*a1.z + 0.045473315*b1.z + -0.07254721*c1.z + 0.11784992*d1.z + 0.22489645*e1.z + -0.12044718*f1.z + -0.22769438*g1.z + 0.10125708*h1.z + 0.061251607*i1.z;
    p = -0.12371223*a1.w + 0.09359978*b1.w + 0.14695486*c1.w + 0.37523615*d1.w + -0.06767972*e1.w + -0.51172626*f1.w + -0.18365318*g1.w + -0.21067004*h1.w + 0.18633223*i1.w;
    q = -0.06524313*na0.x + -0.009557331*nb0.x + 0.1807241*nc0.x + -0.04307605*nd0.x + 0.645201*ne0.x + 0.13570951*nf0.x + 0.14300692*ng0.x + 0.18481126*nh0.x + -0.148592*ni0.x;
    r = -0.112279296*na0.y + 0.10971034*nb0.y + -0.053928122*nc0.y + 0.1691853*nd0.y + -0.2553969*ne0.y + -0.01336192*nf0.y + -0.010185109*ng0.y + -0.0110892*nh0.y + -0.06696365*ni0.y;
    s = 0.009661347*na0.z + 0.13783365*nb0.z + -0.05469151*nc0.z + 0.060208343*nd0.z + -0.20801783*ne0.z + 0.050860364*nf0.z + 0.018983612*ng0.z + -0.058851782*nh0.z + 0.016830424*ni0.z;
    t = 0.022623703*na0.w + 0.2184282*nb0.w + -0.18573825*nc0.w + -0.12993099*nd0.w + 0.007547321*ne0.w + -0.13938355*nf0.w + 0.0066179796*ng0.w + 0.2032918*nh0.w + 0.01827841*ni0.w;
    u = 0.06574555*na1.x + -0.07890568*nb1.x + 0.006496277*nc1.x + -0.10739301*nd1.x + 0.13940795*ne1.x + 0.1365898*nf1.x + -0.053870827*ng1.x + -0.009612605*nh1.x + -0.018912794*ni1.x;
    v = -0.08696663*na1.y + 0.012059219*nb1.y + -0.005466396*nc1.y + 0.03873791*nd1.y + 0.4502705*ne1.y + 0.080376014*nf1.y + 0.066687986*ng1.y + 0.08928875*nh1.y + 0.017182676*ni1.y;
    w = -0.040589333*na1.z + -0.09646847*nb1.z + -0.018687917*nc1.z + 0.04907547*nd1.z + 0.008554357*ne1.z + 0.1492653*nf1.z + -0.096977495*ng1.z + -0.13979109*nh1.z + -0.00083513476*ni1.z;
    x = -0.04625478*na1.w + 0.0035757115*nb1.w + -0.016119964*nc1.w + 0.26989165*nd1.w + 0.20737746*ne1.w + 0.0034231078*nf1.w + -0.09725438*ng1.w + 0.05070696*nh1.w + 0.17640953*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0135042025;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN120
//!BIND LUMAN121
//!SAVE LUMAN131

#define L0_tex LUMAN120_tex
#define L1_tex LUMAN121_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.0029817503*a0.x + 0.11039597*b0.x + 0.1293379*c0.x + -0.29478145*d0.x + -0.29309556*e0.x + 0.007461504*f0.x + 0.06639911*g0.x + 0.12852067*h0.x + -0.17117287*i0.x;
    float j = 0.014813622*a0.y + -0.0013997258*b0.y + 0.023237767*c0.y + -0.0039130542*d0.y + -0.34994942*e0.y + 0.017671466*f0.y + 0.07529793*g0.y + 0.004599998*h0.y + 0.009330613*i0.y;
    float k = 0.3698393*a0.z + -0.39694417*b0.z + 0.09804228*c0.z + -0.35729608*d0.z + 0.41000205*e0.z + -0.5800405*f0.z + 0.15204465*g0.z + -0.3597829*h0.z + 0.50068516*i0.z;
    float l = -0.1146267*a0.w + 0.2583005*b0.w + -0.31435132*c0.w + 0.03573161*d0.w + -0.04650575*e0.w + 0.20616455*f0.w + 0.044980876*g0.w + -0.10150848*h0.w + 0.13188677*i0.w;
    float m = 0.10420975*a1.x + -0.44770283*b1.x + -0.12038152*c1.x + 0.3392538*d1.x + -0.30249548*e1.x + 0.055619825*f1.x + -0.22301525*g1.x + -0.15613358*h1.x + -0.04950416*i1.x;
    float n = -0.24326678*a1.y + 0.2301849*b1.y + -0.1467583*c1.y + 0.39412203*d1.y + -0.5131136*e1.y + 0.19376983*f1.y + -0.10284846*g1.y + 0.18020068*h1.y + -0.116572164*i1.y;
    float o = -0.09376026*a1.z + -0.112495236*b1.z + 0.012500469*c1.z + 0.091132894*d1.z + -0.10716909*e1.z + -0.05887143*f1.z + -0.25869355*g1.z + 0.28358018*h1.z + 0.015895177*i1.z;
    float p = -0.13750197*a1.w + -0.09933744*b1.w + 0.16747455*c1.w + 0.35556677*d1.w + -0.1980293*e1.w + -0.16308151*f1.w + -0.3437185*g1.w + 0.080174305*h1.w + 0.03273947*i1.w;
    float q = -0.008803652*na0.x + -0.05780074*nb0.x + 0.002868577*nc0.x + 0.17680763*nd0.x + -0.1437393*ne0.x + -0.058113955*nf0.x + 0.1324202*ng0.x + -0.025318727*nh0.x + -0.1327205*ni0.x;
    float r = 0.12045249*na0.y + -0.19771278*nb0.y + 0.0012465563*nc0.y + -0.25569203*nd0.y + 0.20063406*ne0.y + 0.071804866*nf0.y + 0.13519558*ng0.y + -0.3769389*nh0.y + 0.12577529*ni0.y;
    float s = -0.18126842*na0.z + 0.06411489*nb0.z + 0.106862076*nc0.z + 0.15456331*nd0.z + -0.20641422*ne0.z + -0.015733475*nf0.z + 0.04565371*ng0.z + -0.198355*nh0.z + 0.016548535*ni0.z;
    float t = 0.016731832*na0.w + 0.03456397*nb0.w + 0.11793571*nc0.w + 0.009492188*nd0.w + -0.17384322*ne0.w + 0.036433797*nf0.w + -0.011236655*ng0.w + 0.104419*nh0.w + -0.042673107*ni0.w;
    float u = 0.04593755*na1.x + 0.037620712*nb1.x + -0.116470456*nc1.x + 0.010684921*nd1.x + 0.10634034*ne1.x + 0.083671*nf1.x + 0.003784596*ng1.x + -0.030200265*nh1.x + 0.029983213*ni1.x;
    float v = -0.07384754*na1.y + -0.06212857*nb1.y + -0.046269182*nc1.y + 0.035937984*nd1.y + 0.1415643*ne1.y + -0.071681954*nf1.y + -0.14786382*ng1.y + -0.17628422*nh1.y + 0.12059677*ni1.y;
    float w = -0.051521663*na1.z + 0.085905306*nb1.z + -0.28085628*nc1.z + -0.21416552*nd1.z + -0.5439677*ne1.z + 0.25659165*nf1.z + -0.30437124*ng1.z + -0.19582753*nh1.z + -0.094153725*ni1.z;
    float x = -0.013591523*na1.w + 0.09577837*nb1.w + 0.14275217*nc1.w + 0.23535793*nd1.w + 0.62966025*ne1.w + -0.07882985*nf1.w + -0.1697662*ng1.w + 0.33211526*nh1.w + 0.057048142*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0061882124;
    i = 0.1608683*a0.x + 0.12672013*b0.x + -0.13156074*c0.x + 0.20069747*d0.x + -0.57826555*e0.x + -0.1311762*f0.x + 0.05670379*g0.x + -0.13502689*h0.x + -0.017937418*i0.x;
    j = -0.033564825*a0.y + 0.077663735*b0.y + -0.0017946946*c0.y + -0.028062444*d0.y + -0.5258993*e0.y + 0.019605096*f0.y + 0.032106742*g0.y + 0.015103085*h0.y + -0.04403495*i0.y;
    k = -0.2539501*a0.z + 0.25463545*b0.z + 0.21425003*c0.z + 0.112265415*d0.z + 0.16083106*e0.z + 0.1895563*f0.z + -0.0016240401*g0.z + 0.14660679*h0.z + -0.46303564*i0.z;
    l = -0.09206371*a0.w + 0.08054541*b0.w + 0.20218949*c0.w + 0.093106724*d0.w + -0.21643853*e0.w + 0.12654713*f0.w + -0.013795536*g0.w + 0.24343796*h0.w + -0.18503825*i0.w;
    m = 0.13443115*a1.x + 0.024385871*b1.x + 0.06606949*c1.x + -0.0127489045*d1.x + 0.25821966*e1.x + 0.0070504625*f1.x + 0.19849744*g1.x + -0.25665656*h1.x + 0.119276844*i1.x;
    n = 0.0041986876*a1.y + -0.13548018*b1.y + 0.0587734*c1.y + 0.14147758*d1.y + -0.21496426*e1.y + 0.14946987*f1.y + 0.06213324*g1.y + -0.07815703*h1.y + -0.121064246*i1.y;
    o = -0.01119387*a1.z + 0.1281896*b1.z + -0.033581752*c1.z + 0.0795136*d1.z + -0.059567317*e1.z + 0.0051460788*f1.z + 0.2383628*g1.z + -0.30380785*h1.z + 0.051271286*i1.z;
    p = -0.09753218*a1.w + 0.2362304*b1.w + -0.18155637*c1.w + 0.017945759*d1.w + 0.06215586*e1.w + -0.012593655*f1.w + 0.19601065*g1.w + -0.17636631*h1.w + 0.2375158*i1.w;
    q = -0.06538386*na0.x + 0.04938395*nb0.x + 0.07520233*nc0.x + -0.09151315*nd0.x + 0.13100089*ne0.x + -0.020945365*nf0.x + -0.20073208*ng0.x + 0.059561357*nh0.x + 0.081940256*ni0.x;
    r = -0.11219974*na0.y + 0.2536562*nb0.y + -0.09547038*nc0.y + -0.1292043*nd0.y + 0.9015294*ne0.y + -0.12639236*nf0.y + -0.06864811*ng0.y + 0.35557497*nh0.y + -0.14578156*ni0.y;
    s = -0.048530217*na0.z + 0.19374037*nb0.z + -0.1382556*nc0.z + -0.13337164*nd0.z + 0.47139746*ne0.z + -0.0766065*nf0.z + -0.040958144*ng0.z + 0.08004464*nh0.z + -0.061836693*ni0.z;
    t = 0.0035216731*na0.w + 0.0064222408*nb0.w + -0.075095765*nc0.w + 0.046879686*nd0.w + -0.14983718*ne0.w + -0.12718*nf0.w + 0.08732038*ng0.w + -0.121688694*nh0.w + -0.041010316*ni0.w;
    u = -0.07124008*na1.x + -0.04196053*nb1.x + 0.047542192*nc1.x + -0.035899833*nd1.x + -0.41907385*ne1.x + 0.08893381*nf1.x + 0.003947721*ng1.x + 0.06347225*nh1.x + -0.08798214*ni1.x;
    v = -0.0768094*na1.y + -0.0052326927*nb1.y + 0.028601233*nc1.y + 0.005496373*nd1.y + -0.20018737*ne1.y + 0.031576294*nf1.y + 0.018691787*ng1.y + 0.079820536*nh1.y + -0.10286643*ni1.y;
    w = 0.16556709*na1.z + -0.14412585*nb1.z + 0.023056397*nc1.z + 0.23065941*nd1.z + -0.19911864*ne1.z + 0.12787361*nf1.z + 0.09215916*ng1.z + 0.018068027*nh1.z + 0.042100914*ni1.z;
    x = -0.07797658*na1.w + -0.03082342*nb1.w + -0.019065307*nc1.w + 0.12527962*nd1.w + -0.20716375*ne1.w + 0.029431188*nf1.w + 0.1279543*ng1.w + -0.5208783*nh1.w + 0.032281134*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.020498782;
    i = -0.084622964*a0.x + -0.16740607*b0.x + -0.029469222*c0.x + 0.16969982*d0.x + -0.18227486*e0.x + 0.25854433*f0.x + -0.19011459*g0.x + -0.17933366*h0.x + 0.074558094*i0.x;
    j = 0.026003294*a0.y + -0.04915105*b0.y + -0.0013010732*c0.y + 0.04870731*d0.y + 0.28155202*e0.y + -0.06976968*f0.y + -0.0785302*g0.y + 0.025113294*h0.y + 0.05850286*i0.y;
    k = -0.099263944*a0.z + 0.20479305*b0.z + 0.006517434*c0.z + 0.054624297*d0.z + 0.3202717*e0.z + -0.016792087*f0.z + -0.09389022*g0.z + 0.105496354*h0.z + -0.066047944*i0.z;
    l = 0.11956328*a0.w + -0.13723543*b0.w + 0.02056757*c0.w + 0.048940748*d0.w + 0.06777377*e0.w + -0.046082053*f0.w + -0.122295715*g0.w + -0.018395558*h0.w + 0.006211377*i0.w;
    m = -0.15036355*a1.x + 0.13597776*b1.x + 0.2225863*c1.x + 0.13214336*d1.x + 0.37878448*e1.x + 0.13936034*f1.x + 0.29791525*g1.x + 0.14070831*h1.x + -0.0022269697*i1.x;
    n = 0.16937836*a1.y + 0.078364424*b1.y + 0.025481608*c1.y + -0.28841308*d1.y + -0.7480474*e1.y + -0.23245746*f1.y + -0.027374426*g1.y + -0.06545865*h1.y + 0.17867507*i1.y;
    o = 0.09645862*a1.z + 0.09660143*b1.z + -0.10547699*c1.z + -0.15390293*d1.z + 0.18812673*e1.z + 0.055048805*f1.z + 0.021517936*g1.z + -0.03123248*h1.z + -0.06397191*i1.z;
    p = 0.079715334*a1.w + 0.01418331*b1.w + -0.0774716*c1.w + -0.32642365*d1.w + -0.17485769*e1.w + 0.18184866*f1.w + 0.16945517*g1.w + -0.029771687*h1.w + -0.31664798*i1.w;
    q = -0.031399272*na0.x + -0.03206811*nb0.x + -0.07516456*nc0.x + 0.0515123*nd0.x + 0.44152927*ne0.x + 0.19966014*nf0.x + -0.059791274*ng0.x + 0.09954191*nh0.x + 0.101585746*ni0.x;
    r = -0.010062315*na0.y + -0.057479843*nb0.y + -0.018172972*nc0.y + 0.059699446*nd0.y + -0.10326032*ne0.y + -0.06662804*nf0.y + -0.064171165*ng0.y + -0.0761727*nh0.y + -0.038051385*ni0.y;
    s = 0.12910141*na0.z + 0.01146065*nb0.z + -0.03436212*nc0.z + -0.104220964*nd0.z + -0.03813209*ne0.z + -0.0146224275*nf0.z + -0.0226614*ng0.z + 0.040486135*nh0.z + 0.03331776*ni0.z;
    t = 0.00067659107*na0.w + 0.09321861*nb0.w + -0.120426044*nc0.w + -0.012587846*nd0.w + 0.20406908*ne0.w + 0.007672166*nf0.w + -0.035258528*ng0.w + 0.0016402612*nh0.w + 0.058924437*ni0.w;
    u = -0.020544445*na1.x + -0.13000254*nb1.x + 0.12238778*nc1.x + 0.008118038*nd1.x + 0.08118961*ne1.x + -0.14815351*nf1.x + -0.0016237226*ng1.x + -0.034430075*nh1.x + 0.021861486*ni1.x;
    v = 0.11768407*na1.y + 0.060114264*nb1.y + 0.016723705*nc1.y + -0.057645593*nd1.y + 0.27267838*ne1.y + -0.015508981*nf1.y + 0.07961894*ng1.y + 0.13694412*nh1.y + 0.009282088*ni1.y;
    w = 0.0014761469*na1.z + -0.078347*nb1.z + 0.31750104*nc1.z + -0.10870471*nd1.z + -0.6838303*ne1.z + -0.31684813*nf1.z + 0.19105281*ng1.z + 0.21890667*nh1.z + 0.08495596*ni1.z;
    x = 0.13082732*na1.w + 0.0022536176*nb1.w + -0.052774757*nc1.w + -0.13665682*nd1.w + 0.0970184*ne1.w + 0.19598328*nf1.w + 0.11680146*ng1.w + 0.22926913*nh1.w + -0.031428613*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.004580171;
    i = -0.20878509*a0.x + -0.0049028993*b0.x + 0.008758187*c0.x + 0.42891967*d0.x + -0.12513797*e0.x + 0.078094915*f0.x + -0.715149*g0.x + -0.5880513*h0.x + -0.532971*i0.x;
    j = 0.04762167*a0.y + 0.10662991*b0.y + 0.07202485*c0.y + 0.105879575*d0.y + -0.0635549*e0.y + -0.2399356*f0.y + 0.24179313*g0.y + 0.10862184*h0.y + 0.10190414*i0.y;
    k = 0.095115505*a0.z + -0.47274086*b0.z + 0.62832284*c0.z + -1.0036635*d0.z + 0.374167*e0.z + -0.681788*f0.z + 0.45285058*g0.z + -0.6784815*h0.z + 0.32184234*i0.z;
    l = -0.07651871*a0.w + 0.6871501*b0.w + -0.8205136*c0.w + 0.5000293*d0.w + -0.749573*e0.w + 0.5168709*f0.w + -0.28480902*g0.w + -0.009171731*h0.w + 0.06727333*i0.w;
    m = 0.23145379*a1.x + -0.06032752*b1.x + 0.17392537*c1.x + 0.61549795*d1.x + 0.31530488*e1.x + 0.4550739*f1.x + 0.97063684*g1.x + -1.68332*h1.x + 0.11348427*i1.x;
    n = -0.033892903*a1.y + 0.9738131*b1.y + -0.31819594*c1.y + 0.71122944*d1.y + -0.75284725*e1.y + 0.2765665*f1.y + -0.27231637*g1.y + 1.0744721*h1.y + 0.26208746*i1.y;
    o = 0.05900849*a1.z + -0.5339448*b1.z + -0.12394775*c1.z + -0.40140063*d1.z + 0.04213861*e1.z + -0.16040552*f1.z + 0.25848332*g1.z + -0.08338297*h1.z + -0.026495855*i1.z;
    p = -0.3593638*a1.w + -0.1250508*b1.w + 0.004110387*c1.w + -0.14758548*d1.w + -0.2519455*e1.w + 0.047708288*f1.w + 0.130796*g1.w + 0.01886842*h1.w + -0.032272115*i1.w;
    q = -0.05126741*na0.x + -0.16950572*nb0.x + -0.23038149*nc0.x + 0.593978*nd0.x + -0.5536893*ne0.x + -0.32420158*nf0.x + -0.47213337*ng0.x + 0.17723289*nh0.x + 0.17365572*ni0.x;
    r = 0.36904523*na0.y + -0.41965717*nb0.y + -0.14868285*nc0.y + -1.3712142*nd0.y + 0.40537167*ne0.y + -0.0018829257*nf0.y + 0.102555715*ng0.y + -0.5457678*nh0.y + 0.024573814*ni0.y;
    s = -0.33692932*na0.z + -0.28599527*nb0.z + -0.19985573*nc0.z + -0.27231628*nd0.z + -0.044150677*ne0.z + -0.47341737*nf0.z + -0.0870376*ng0.z + -0.33944583*nh0.z + -0.07254269*ni0.z;
    t = -0.009741176*na0.w + -0.31833467*nb0.w + 0.27552912*nc0.w + 0.2986059*nd0.w + 0.029016443*ne0.w + 0.045390986*nf0.w + 0.020379847*ng0.w + -0.12964877*nh0.w + -0.20720415*ni0.w;
    u = 0.09684107*na1.x + -0.00019891714*nb1.x + -0.04728448*nc1.x + -0.12864496*nd1.x + 0.11396464*ne1.x + 0.047860865*nf1.x + 0.1741148*ng1.x + -0.03588619*nh1.x + 0.022001866*ni1.x;
    v = 0.0137323765*na1.y + -0.20688717*nb1.y + -0.032837644*nc1.y + -0.07689021*nd1.y + -0.15632144*ne1.y + -0.19237685*nf1.y + -0.38659793*ng1.y + -0.19939652*nh1.y + 0.017652083*ni1.y;
    w = 0.2849119*na1.z + 0.51690143*nb1.z + -0.12283366*nc1.z + -0.28805944*nd1.z + 0.1986708*ne1.z + 0.6683004*nf1.z + -0.20318586*ng1.z + 0.062077664*nh1.z + -0.10572113*ni1.z;
    x = 0.015433912*na1.w + 0.4059864*nb1.w + 0.2935132*nc1.w + 0.3080238*nd1.w + -0.47443306*ne1.w + 0.5408017*nf1.w + 0.47627777*ng1.w + -0.21175745*nh1.w + -0.4425635*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.3695156;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!WIDTH LUMA.w
//!HEIGHT LUMA.h
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!BIND LUMAN20
//!BIND LUMAN21
//!BIND LUMAN30
//!BIND LUMAN31
//!BIND LUMAN40
//!BIND LUMAN41
//!BIND LUMAN50
//!BIND LUMAN51
//!BIND LUMAN60
//!BIND LUMAN61
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN0

vec4 hook() {
    vec4 a0 = LUMAN10_tex(HOOKED_pos);
    vec4 a1 = LUMAN11_tex(HOOKED_pos);
    vec4 b0 = LUMAN20_tex(HOOKED_pos);
    vec4 b1 = LUMAN21_tex(HOOKED_pos);
    vec4 c0 = LUMAN30_tex(HOOKED_pos);
    vec4 c1 = LUMAN31_tex(HOOKED_pos);
    vec4 d0 = LUMAN40_tex(HOOKED_pos);
    vec4 d1 = LUMAN41_tex(HOOKED_pos);
    vec4 e0 = LUMAN50_tex(HOOKED_pos);
    vec4 e1 = LUMAN51_tex(HOOKED_pos);
    vec4 f0 = LUMAN60_tex(HOOKED_pos);
    vec4 f1 = LUMAN61_tex(HOOKED_pos);
    vec4 g0 = LUMAN70_tex(HOOKED_pos);
    vec4 g1 = LUMAN71_tex(HOOKED_pos);
    vec4 na0 = -min(a0, 0);
    vec4 na1 = -min(a1, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 ng1 = -min(g1, 0);
    a0 = max(a0, 0);
    a1 = max(a1, 0);
    b0 = max(b0, 0);
    b1 = max(b1, 0);
    c0 = max(c0, 0);
    c1 = max(c1, 0);
    d0 = max(d0, 0);
    d1 = max(d1, 0);
    e0 = max(e0, 0);
    e1 = max(e1, 0);
    f0 = max(f0, 0);
    f1 = max(f1, 0);
    g0 = max(g0, 0);
    g1 = max(g1, 0);
    float o = -0.04728476*a0.x + -0.036520608*a0.y + 0.0019385766*a0.z + 0.0068700467*a0.w + -0.0012625896*a1.x + -0.010626795*a1.y + 0.00034366403*a1.z + 0.019933239*a1.w + 0.0030849315*na0.x + 0.0136760855*na0.y + -0.0057450915*na0.z + -0.0104574775*na0.w + -0.0032813277*na1.x + 0.029485198*na1.y + 0.005484502*na1.z + 0.005979312*na1.w + -0.008282406*b0.x + -0.032329977*b0.y + 0.007195994*b0.z + -0.02215956*b0.w + 0.0059099896*b1.x + -0.01843096*b1.y + 0.024378398*b1.z + -0.009847458*b1.w + 0.0021519165*nb0.x + 0.06338734*nb0.y + 0.013530091*nb0.z + 0.018921647*nb0.w + 0.013079997*nb1.x + -0.007416839*nb1.y + -0.03319205*nb1.z + 0.0070940736*nb1.w + 0.0083534485*c0.x + -0.0040059397*c0.y + 0.0010338705*c0.z + 0.023850251*c0.w + 0.019972563*c1.x + -0.013661981*c1.y + -0.002535298*c1.z + 0.00032178697*c1.w + -0.0050726496*nc0.x + 0.014284615*nc0.y + 0.0031937568*nc0.z + -0.012339685*nc0.w + -0.014393241*nc1.x + 0.016286138*nc1.y + 0.0053683654*nc1.z + 0.0267535*nc1.w + -0.009829492*d0.x + 0.017354073*d0.y + 0.002988491*d0.z + 0.0028444938*d0.w + 0.022341609*d1.x + -0.0038211492*d1.y + -0.00046226522*d1.z + -0.00056893734*d1.w + 0.01287184*nd0.x + -0.004260344*nd0.y + -0.011798954*nd0.z + -0.0010778373*nd0.w + -0.025230715*nd1.x + 0.0030024408*nd1.y + -0.0012105505*nd1.z + -0.004203998*nd1.w + -0.02869678*e0.x + 0.028832806*e0.y + -0.0018178951*e0.z + -0.004184944*e0.w + -0.034690376*e1.x + -0.004891646*e1.y + -0.0041404334*e1.z + -0.0053047556*e1.w + 0.01340061*ne0.x + 0.0033740127*ne0.y + -0.0064605293*ne0.z + 0.007029548*ne0.w + -0.012997147*ne1.x + 0.037987478*ne1.y + -0.008045281*ne1.z + 0.003939788*ne1.w + 0.0018597402*f0.x + 0.0020262436*f0.y + 0.00060788146*f0.z + 0.00069211586*f0.w + 0.0015645992*f1.x + 0.005501792*f1.y + 0.014841749*f1.z + 0.016227905*f1.w + -0.006870606*nf0.x + 0.0028365995*nf0.y + 0.000554307*nf0.z + 0.015418915*nf0.w + 0.026047971*nf1.x + 0.0062811137*nf1.y + -0.00049436744*nf1.z + -0.016887395*nf1.w + -0.007700884*g0.x + -0.006125995*g0.y + 0.0026072077*g0.z + 0.0050263735*g0.w + -0.0007808361*g1.x + -0.01214509*g1.y + -0.0124664875*g1.z + -0.0623571*g1.w + 0.0021798706*ng0.x + -0.00454209*ng0.y + -0.0033230642*ng0.z + -0.003633754*ng0.w + -0.028934926*ng1.x + 0.05962686*ng1.y + 0.0128101995*ng1.z + 0.0065336125*ng1.w + 0;
    float p = -0.01706887*a0.x + -0.075055175*a0.y + 0.008531614*a0.z + 0.012812007*a0.w + 0.028967712*a1.x + 0.0006802233*a1.y + -0.023122001*a1.z + 0.004117588*a1.w + 0.0060033975*na0.x + 0.04573654*na0.y + -0.0014532027*na0.z + -0.01553144*na0.w + 0.00085815*na1.x + -0.0025215421*na1.y + 0.037993304*na1.z + 0.0043748533*na1.w + -0.016280308*b0.x + -0.026154146*b0.y + 0.011285019*b0.z + -0.010950448*b0.w + -0.008993951*b1.x + -0.008138363*b1.y + 0.0143283885*b1.z + 0.0032050752*b1.w + 0.019617861*nb0.x + 0.036108296*nb0.y + 0.0031697615*nb0.z + 0.013029574*nb0.w + 0.013052287*nb1.x + 0.010624071*nb1.y + -0.0058424054*nb1.z + -0.011529895*nb1.w + -0.029668175*c0.x + -0.0008865771*c0.y + -0.018089509*c0.z + 0.01629766*c0.w + 0.013346903*c1.x + -0.0066329846*c1.y + 0.00012357974*c1.z + 0.0067070923*c1.w + 0.015234514*nc0.x + 0.010311016*nc0.y + -0.0015783357*nc0.z + -0.004588889*nc0.w + -0.00804179*nc1.x + 0.0019117421*nc1.y + -0.004337227*nc1.z + 0.016801925*nc1.w + -0.029825747*d0.x + 0.0078127505*d0.y + -0.009640577*d0.z + -0.0048246942*d0.w + 0.04105915*d1.x + 0.0028164582*d1.y + 0.0062606526*d1.z + -0.0073074396*d1.w + 0.0031663615*nd0.x + -0.0033067295*nd0.y + 0.0003633346*nd0.z + 0.008120073*nd0.w + -0.013381999*nd1.x + -0.0029448275*nd1.y + 0.0016682927*nd1.z + 0.0017422357*nd1.w + -0.03133399*e0.x + -0.0026351928*e0.y + 0.009347191*e0.z + 0.009692576*e0.w + 0.028132373*e1.x + -0.034198917*e1.y + -0.009121166*e1.z + -0.0042066113*e1.w + 0.0018584005*ne0.x + 0.004562667*ne0.y + 0.0018780766*ne0.z + -0.0011617886*ne0.w + 0.014671292*ne1.x + -0.047582008*ne1.y + -0.011981096*ne1.z + 0.007301599*ne1.w + -0.009782136*f0.x + -0.009850503*f0.y + -0.01764285*f0.z + 0.0057299454*f0.w + -0.006322922*f1.x + -0.0014284349*f1.y + -0.01637028*f1.z + -0.016202927*f1.w + 0.010929147*nf0.x + 0.01483284*nf0.y + -0.005637644*nf0.z + 0.004375778*nf0.w + 0.014877084*nf1.x + -0.0085625835*nf1.y + 0.0009016836*nf1.z + 0.010949607*nf1.w + 0.019945359*g0.x + 0.012776777*g0.y + 9.388056e-05*g0.z + 0.011086543*g0.w + 0.0031442842*g1.x + -0.0007281356*g1.y + 0.014730445*g1.z + 0.023945043*g1.w + -0.010939084*ng0.x + -0.015295178*ng0.y + 0.007891041*ng0.z + 0.026746083*ng0.w + 0.032127682*ng1.x + -0.056322485*ng1.y + 0.0023893197*ng1.z + -0.0041469387*ng1.w + 0;
    float q = 0.0052190213*a0.x + -0.036697973*a0.y + 0.0017909147*a0.z + 0.01471547*a0.w + -0.041808248*a1.x + -0.009302919*a1.y + -0.00012822033*a1.z + 0.02604467*a1.w + -0.0074887155*na0.x + 0.012221476*na0.y + -0.004066934*na0.z + -0.014296432*na0.w + 0.009378086*na1.x + 0.0050812257*na1.y + -0.00066634355*na1.z + -0.010221536*na1.w + 0.039825562*b0.x + -0.015009193*b0.y + -0.008390923*b0.z + -0.026432492*b0.w + -0.025902105*b1.x + 0.013141686*b1.y + 0.011074781*b1.z + -7.850445e-05*b1.w + -0.014900862*nb0.x + 0.0020929938*nb0.y + 0.004025759*nb0.z + 0.022637185*nb0.w + 0.018963696*nb1.x + 0.005365097*nb1.y + -0.021788068*nb1.z + -0.016199213*nb1.w + 0.006605639*c0.x + -0.00037750482*c0.y + -0.014114117*c0.z + 0.016580945*c0.w + 0.011849912*c1.x + -0.0010426794*c1.y + -0.009228553*c1.z + -0.0023927793*c1.w + 0.010821834*nc0.x + 0.0041750884*nc0.y + 0.042591974*nc0.z + -0.00041563442*nc0.w + -0.018251926*nc1.x + 0.004060685*nc1.y + 0.008161771*nc1.z + -0.056150824*nc1.w + -0.005963017*d0.x + -0.004477493*d0.y + 0.0053864145*d0.z + 0.015293112*d0.w + 0.018896958*d1.x + -0.01364045*d1.y + 0.006402596*d1.z + 0.005380181*d1.w + -0.005427749*nd0.x + -0.005545938*nd0.y + -0.010753802*nd0.z + -0.020330966*nd0.w + -0.020064725*nd1.x + 0.017465577*nd1.y + -0.009108494*nd1.z + -0.014758475*nd1.w + 0.008513857*e0.x + 0.0009961041*e0.y + -0.006098016*e0.z + -0.007048123*e0.w + 0.03902215*e1.x + 0.013202531*e1.y + 0.0114761675*e1.z + -0.0012895446*e1.w + 0.0055963704*ne0.x + 0.004024959*ne0.y + -0.013828568*ne0.z + -0.004390752*ne0.w + 0.0034489762*ne1.x + -0.0057895263*ne1.y + -0.0059244502*ne1.z + 0.0014182391*ne1.w + 0.0042083496*f0.x + -0.030192751*f0.y + 0.022458259*f0.z + -0.005110902*f0.w + 0.003181209*f1.x + -0.008455602*f1.y + 0.013294538*f1.z + 0.014039483*f1.w + -0.004838639*nf0.x + -0.017882824*nf0.y + 0.009125966*nf0.z + 0.00087110914*nf0.w + -0.014056271*nf1.x + -0.007067034*nf1.y + -0.0041026683*nf1.z + 0.0013140955*nf1.w + -0.012102768*g0.x + 0.009908834*g0.y + -0.00056007825*g0.z + -0.0019034665*g0.w + 0.0006154995*g1.x + 0.019641206*g1.y + -0.019597912*g1.z + -0.020133134*g1.w + 0.02620538*ng0.x + 0.0027179648*ng0.y + -0.0023573192*ng0.z + 0.015295984*ng0.w + -0.011871862*ng1.x + 0.036589906*ng1.y + -0.010942377*ng1.z + 0.013047896*ng1.w + 0;
    float r = 0.0013240597*a0.x + -0.0525534*a0.y + 0.006428618*a0.z + 0.00910116*a0.w + 0.0010389212*a1.x + 0.004980833*a1.y + -0.0004343639*a1.z + 0.01391637*a1.w + 0.009297071*na0.x + 0.03547774*na0.y + -0.005122102*na0.z + -0.008212074*na0.w + -0.015846107*na1.x + 0.0007511969*na1.y + 0.028269917*na1.z + -0.0013784057*na1.w + 0.041298848*b0.x + -0.01730128*b0.y + 0.0015381973*b0.z + -0.022542015*b0.w + -0.023945393*b1.x + 0.020450871*b1.y + 0.010655135*b1.z + -0.0087027205*b1.w + -0.024145687*nb0.x + 0.0039176657*nb0.y + 0.0006878214*nb0.z + 0.01794849*nb0.w + 0.031762592*nb1.x + 0.0035054574*nb1.y + -0.01594689*nb1.z + 0.0011837251*nb1.w + 0.0010308131*c0.x + 0.008263548*c0.y + -0.0051403726*c0.z + 0.013458736*c0.w + 0.013812601*c1.x + -0.005903642*c1.y + 0.008680253*c1.z + -0.0020812678*c1.w + 0.00114809*nc0.x + 0.0038776158*nc0.y + 0.008751602*nc0.z + -0.007122077*nc0.w + -0.02483335*nc1.x + 0.009145055*nc1.y + 0.0054040407*nc1.z + -0.053735446*nc1.w + -0.005360682*d0.x + -0.011691867*d0.y + 0.01620561*d0.z + 0.012762638*d0.w + -0.011760973*d1.x + -0.004673657*d1.y + -0.0017164994*d1.z + 0.021724444*d1.w + 0.0031776167*nd0.x + -0.006484397*nd0.y + -0.00012294922*nd0.z + -0.009668074*nd0.w + 0.0004887767*nd1.x + -0.0038761701*nd1.y + 1.2165349e-05*nd1.z + 0.01420319*nd1.w + 0.046187103*e0.x + -0.010850962*e0.y + 0.012227887*e0.z + -0.0049160873*e0.w + -0.014404347*e1.x + 0.008824071*e1.y + 0.0033386408*e1.z + 0.0076736757*e1.w + -0.0011479551*ne0.x + -0.00048488253*ne0.y + -0.00629155*ne0.z + -0.0016700291*ne0.w + -0.01197633*ne1.x + 0.017074293*ne1.y + 0.0062331264*ne1.z + -0.007745917*ne1.w + -0.014362735*f0.x + 0.023914995*f0.y + -0.007672635*f0.z + 0.008481796*f0.w + -0.0016631298*f1.x + 0.0013799849*f1.y + -0.002389917*f1.z + -0.01502566*f1.w + 0.011418116*nf0.x + 0.0041276156*nf0.y + -0.01286134*nf0.z + -0.0044272356*nf0.w + -0.018952431*nf1.x + -0.012017917*nf1.y + -0.005450932*nf1.z + 0.024733933*nf1.w + 0.005573501*g0.x + 0.0032204753*g0.y + -0.0041492335*g0.z + -0.024271673*g0.w + -0.0014906545*g1.x + 0.007969394*g1.y + 0.009147742*g1.z + 0.060164053*g1.w + -0.01906351*ng0.x + 0.0139462*ng0.y + 0.01615183*ng0.z + -0.011862902*ng0.w + 0.006158882*ng1.x + -0.09076022*ng1.y + -0.0071068676*ng1.z + -0.0048810467*ng1.w + 0;
    return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!WIDTH LUMA.w
//!HEIGHT LUMA.h
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!BIND LUMAN90
//!BIND LUMAN91
//!BIND LUMAN100
//!BIND LUMAN101
//!BIND LUMAN110
//!BIND LUMAN111
//!BIND LUMAN120
//!BIND LUMAN121
//!BIND LUMAN130
//!BIND LUMAN131
//!BIND LUMAN0
//!SAVE LUMAN0

vec4 hook() {
    vec4 h0 = LUMAN80_tex(HOOKED_pos);
    vec4 h1 = LUMAN81_tex(HOOKED_pos);
    vec4 i0 = LUMAN90_tex(HOOKED_pos);
    vec4 i1 = LUMAN91_tex(HOOKED_pos);
    vec4 j0 = LUMAN100_tex(HOOKED_pos);
    vec4 j1 = LUMAN101_tex(HOOKED_pos);
    vec4 k0 = LUMAN110_tex(HOOKED_pos);
    vec4 k1 = LUMAN111_tex(HOOKED_pos);
    vec4 l0 = LUMAN120_tex(HOOKED_pos);
    vec4 l1 = LUMAN121_tex(HOOKED_pos);
    vec4 m0 = LUMAN130_tex(HOOKED_pos);
    vec4 m1 = LUMAN131_tex(HOOKED_pos);
    vec4 nh0 = -min(h0, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni0 = -min(i0, 0);
    vec4 ni1 = -min(i1, 0);
    vec4 nj0 = -min(j0, 0);
    vec4 nj1 = -min(j1, 0);
    vec4 nk0 = -min(k0, 0);
    vec4 nk1 = -min(k1, 0);
    vec4 nl0 = -min(l0, 0);
    vec4 nl1 = -min(l1, 0);
    vec4 nm0 = -min(m0, 0);
    vec4 nm1 = -min(m1, 0);
    h0 = max(h0, 0);
    h1 = max(h1, 0);
    i0 = max(i0, 0);
    i1 = max(i1, 0);
    j0 = max(j0, 0);
    j1 = max(j1, 0);
    k0 = max(k0, 0);
    k1 = max(k1, 0);
    l0 = max(l0, 0);
    l1 = max(l1, 0);
    m0 = max(m0, 0);
    m1 = max(m1, 0);
    float o = LUMAN0_tex(HOOKED_pos).x + 0.028154768*h0.x + 0.007275039*h0.y + -0.0011438587*h0.z + -0.01108197*h0.w + -0.012890547*h1.x + -0.005964137*h1.y + -0.033666026*h1.z + 0.0054421173*h1.w + 0.0061498084*nh0.x + -0.013902076*nh0.y + 0.0029887478*nh0.z + -0.012798732*nh0.w + 0.0060229595*nh1.x + 0.0096300915*nh1.y + 0.035797298*nh1.z + -0.017965809*nh1.w + 0.013986207*i0.x + 0.029799053*i0.y + -0.015183565*i0.z + -0.0057988837*i0.w + -0.033958167*i1.x + -0.0038495238*i1.y + 0.0013773177*i1.z + 0.005184489*i1.w + 0.004508269*ni0.x + -0.002570269*ni0.y + -0.005609264*ni0.z + -0.0038743338*ni0.w + 0.004259348*ni1.x + 0.025667783*ni1.y + 0.015699951*ni1.z + -0.0020644297*ni1.w + 0.019116893*j0.x + 0.0103256805*j0.y + -0.0028200424*j0.z + -0.017563418*j0.w + 0.00054795604*j1.x + 0.008192331*j1.y + 0.003817345*j1.z + -0.021149283*j1.w + -0.0016317961*nj0.x + -0.007806229*nj0.y + 0.0077856313*nj0.z + 0.009038461*nj0.w + 0.0020147602*nj1.x + -0.04748933*nj1.y + -0.029999552*nj1.z + 0.00014385732*nj1.w + 0.004639102*k0.x + 0.009241958*k0.y + -0.016433537*k0.z + 0.00046911353*k0.w + 0.016455498*k1.x + 0.0110299755*k1.y + -0.019485874*k1.z + 0.07030569*k1.w + -0.011915996*nk0.x + -0.023589713*nk0.y + 0.040155042*nk0.z + -0.0030840805*nk0.w + 0.010477874*nk1.x + -0.0053069443*nk1.y + 0.0077385874*nk1.z + -0.00829554*nk1.w + -0.02349797*l0.x + 0.059402034*l0.y + -0.026031276*l0.z + -0.06829119*l0.w + -0.08079901*l1.x + 0.11198863*l1.y + -0.009373267*l1.z + 0.0047806143*l1.w + -0.0113643855*nl0.x + -0.042793855*nl0.y + -0.037593715*nl0.z + 0.011087656*nl0.w + 0.044267964*nl1.x + -0.010039046*nl1.y + 0.11555328*nl1.z + -0.05401579*nl1.w + 0.014701331*m0.x + -0.010931888*m0.y + 0.0013618327*m0.z + -0.01511776*m0.w + 0.07922733*m1.x + 0.14759564*m1.y + 0.05550517*m1.z + -0.014685158*m1.w + 0.022788275*nm0.x + -0.05691751*nm0.y + -0.037949562*nm0.z + -0.042652573*nm0.w + -0.081433505*nm1.x + -0.080078565*nm1.y + 0.027400292*nm1.z + 0.016504942*nm1.w + -0.008307824;
    float p = LUMAN0_tex(HOOKED_pos).y + -0.012476344*h0.x + 0.00041778514*h0.y + -0.00029403862*h0.z + -0.0077522174*h0.w + -0.0007013094*h1.x + 0.009287548*h1.y + -0.0007466532*h1.z + -0.0008275674*h1.w + -0.00413496*nh0.x + 0.008134882*nh0.y + 0.02905413*nh0.z + 0.00022237566*nh0.w + -0.00015811919*nh1.x + -0.012663603*nh1.y + -0.0025063844*nh1.z + 0.005934334*nh1.w + -0.013793359*i0.x + -0.0030275956*i0.y + 0.002632738*i0.z + 0.00050856353*i0.w + 0.0070112064*i1.x + -0.0011123072*i1.y + 0.0027596478*i1.z + -0.0071405345*i1.w + -0.020791892*ni0.x + -0.012057223*ni0.y + 0.015629247*ni0.z + -0.005353237*ni0.w + 0.025932*ni1.x + -0.017513938*ni1.y + -0.0010464039*ni1.z + -0.0048822653*ni1.w + -0.0022303013*j0.x + 0.000109548884*j0.y + -0.0013899812*j0.z + -0.04997202*j0.w + 0.0039844727*j1.x + -0.012894859*j1.y + 0.019041412*j1.z + 0.008987427*j1.w + 0.002459809*nj0.x + 0.004196275*nj0.y + -0.012779132*nj0.z + 0.017411614*nj0.w + -0.00580461*nj1.x + -0.025579158*nj1.y + -0.017933184*nj1.z + 0.0084173465*nj1.w + 0.006441807*k0.x + -0.032203905*k0.y + -0.003269837*k0.z + -0.001531181*k0.w + 0.0078064846*k1.x + 0.004411259*k1.y + -0.010174944*k1.z + -0.024659745*k1.w + 0.002657509*nk0.x + -0.018960288*nk0.y + -0.002639977*nk0.z + 0.009598693*nk0.w + -0.010886198*nk1.x + -0.0015291816*nk1.y + 0.03410781*nk1.z + 0.008700974*nk1.w + 0.06478203*l0.x + -0.06352816*l0.y + 0.04763686*l0.z + -0.04645173*l0.w + -0.052127838*l1.x + -0.09600151*l1.y + 0.030204717*l1.z + 0.014505796*l1.w + -0.031888958*nl0.x + 0.09702901*nl0.y + 0.052713342*nl0.z + 0.03720871*nl0.w + -0.05015491*nl1.x + -0.012215867*nl1.y + -0.1489265*nl1.z + 0.0023754374*nl1.w + 0.0077991346*m0.x + 0.012234416*m0.y + -0.0009354508*m0.z + 0.0405293*m0.w + -0.049991522*m1.x + -0.011354246*m1.y + -0.033561453*m1.z + 0.023130419*m1.w + -0.03268312*nm0.x + -0.089838445*nm0.y + 0.039729614*nm0.z + 0.020857763*nm0.w + 0.08058377*nm1.x + 0.06261047*nm1.y + -0.044904366*nm1.z + -0.026322749*nm1.w + 0.00936794;
    float q = LUMAN0_tex(HOOKED_pos).z + 0.017680038*h0.x + -0.0034014038*h0.y + 0.01325279*h0.z + 0.0066159996*h0.w + -0.009820397*h1.x + -0.009590288*h1.y + -0.0322843*h1.z + 0.0068037184*h1.w + -0.0025545594*nh0.x + -0.013663908*nh0.y + -0.04636907*nh0.z + -0.0011485704*nh0.w + 0.0030269555*nh1.x + 0.013646466*nh1.y + 0.008233854*nh1.z + -0.011760669*nh1.w + -0.020044338*i0.x + -0.017884787*i0.y + 0.0072006527*i0.z + -0.0116206575*i0.w + -0.0336928*i1.x + 0.005347091*i1.y + -0.001439835*i1.z + 0.007912345*i1.w + -0.005165678*ni0.x + -0.008851315*ni0.y + -0.01672471*ni0.z + 0.013330815*ni0.w + -0.0051708966*ni1.x + 0.010595262*ni1.y + -0.005110261*ni1.z + 0.010210765*ni1.w + 0.011963133*j0.x + 0.0015569422*j0.y + -0.00841955*j0.z + 0.022908317*j0.w + 0.0025614926*j1.x + -0.0052343216*j1.y + -0.0028602132*j1.z + 0.027029965*j1.w + -0.004171911*nj0.x + 0.003010245*nj0.y + 0.017087264*nj0.z + 0.0077778804*nj0.w + 0.0035978484*nj1.x + 0.032972984*nj1.y + 0.03604963*nj1.z + 0.0063191843*nj1.w + 0.0007370549*k0.x + -0.0026937914*k0.y + -0.006648801*k0.z + -0.050264988*k0.w + -0.0061267707*k1.x + -0.012902248*k1.y + 0.0009312556*k1.z + 0.027272638*k1.w + 0.0013918153*nk0.x + 0.0058321236*nk0.y + -0.006040759*nk0.z + 0.008355389*nk0.w + 0.00022524416*nk1.x + 0.0027963892*nk1.y + -0.0030116662*nk1.z + -0.008229986*nk1.w + -0.0019475389*l0.x + 0.004617108*l0.y + -0.007019104*l0.z + 0.050343942*l0.w + 0.07296967*l1.x + -0.011251547*l1.y + -0.0040626405*l1.z + -0.024047323*l1.w + 0.011267885*nl0.x + -0.10441765*nl0.y + -0.0043937173*nl0.z + 0.008439476*nl0.w + 0.0025544306*nl1.x + -0.0032398677*nl1.y + -0.014886633*nl1.z + 0.043766428*nl1.w + -0.06277456*m0.x + -0.0068775853*m0.y + -0.014073247*m0.z + 0.004322255*m0.w + -0.027019642*m1.x + -0.06935587*m1.y + -0.026514858*m1.z + -0.0027431983*m1.w + 0.02159222*nm0.x + 0.073561415*nm0.y + 0.058740135*nm0.z + -0.07203826*nm0.w + 0.008394*nm1.x + 0.007160604*nm1.y + 0.08396549*nm1.z + 0.0017666898*nm1.w + -0.0024531493;
    float r = LUMAN0_tex(HOOKED_pos).w + -0.0012055013*h0.x + -0.003244798*h0.y + -0.004156939*h0.z + 0.0036389115*h0.w + 0.011253503*h1.x + -0.0013670821*h1.y + 0.034176*h1.z + -0.006571377*h1.w + 0.0036972067*nh0.x + 0.0053830254*nh0.y + 0.009262475*nh0.z + 0.005158738*nh0.w + -0.008013784*nh1.x + -0.0076279696*nh1.y + 0.01711645*nh1.z + 0.019142881*nh1.w + 0.013530348*i0.x + 0.0018440787*i0.y + -0.0063714003*i0.z + 0.0054069734*i0.w + 0.021637455*i1.x + 0.009726929*i1.y + 0.0011075968*i1.z + -0.018555546*i1.w + 0.010254738*ni0.x + -0.0006528478*ni0.y + 0.009930713*ni0.z + -0.0083744675*ni0.w + -0.0050841644*ni1.x + -0.010749009*ni1.y + -0.0081318915*ni1.z + -0.0018240416*ni1.w + -0.030332126*j0.x + -0.019219792*j0.y + 0.0039786496*j0.z + 0.009644819*j0.w + 0.0021590926*j1.x + -0.006202845*j1.y + -0.0093941*j1.z + -0.014618773*j1.w + -0.008474345*nj0.x + -0.0011716061*nj0.y + 0.00015310342*nj0.z + 0.00025029443*nj0.w + -0.006576327*nj1.x + 0.014994276*nj1.y + 0.01885804*nj1.z + -0.004539383*nj1.w + -0.011680012*k0.x + -0.0060392558*k0.y + 0.015494828*k0.z + 0.030411074*k0.w + -0.010484663*k1.x + -0.009604161*k1.y + -0.006873529*k1.z + -0.04552321*k1.w + 0.0061431173*nk0.x + 0.013219503*nk0.y + -0.01225356*nk0.z + 0.004476564*nk0.w + -0.0052758437*nk1.x + 0.00041394064*nk1.y + 0.020661544*nk1.z + 0.00819726*nk1.w + -0.004361188*l0.x + 0.046293*l0.y + -0.048474595*l0.z + 0.00014330888*l0.w + 0.068526275*l1.x + 0.025298426*l1.y + 0.033734288*l1.z + 0.014304559*l1.w + 0.02355298*nl0.x + 0.010139359*nl0.y + 0.040561803*nl0.z + 0.004230508*nl0.w + 0.0065057282*nl1.x + 0.020425687*nl1.y + 0.0160124*nl1.z + 0.012846417*nl1.w + 0.03170583*m0.x + -0.02589775*m0.y + 0.042881653*m0.z + -0.046655137*m0.w + 0.01694526*m1.x + -0.0362362*m1.y + -0.0042416737*m1.z + -0.005048726*m1.w + -0.0019929754*nm0.x + 0.0995872*nm0.y + -0.087547004*nm0.z + 0.11017462*nm0.w + -0.021728791*nm1.x + -0.02597225*nm1.y + -0.061021034*nm1.z + 0.0066313753*nm1.w + -0.0059383432;
    return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)
//!HOOK NATIVE
//!BIND HOOKED
//!BIND LUMAN0
//!WIDTH BACKUP.w
//!HEIGHT BACKUP.h
//!COMPONENTS 1
//!SAVE RESID

vec4 hook() {
	vec2 f = fract(LUMAN0_pos * LUMAN0_size);
	ivec2 i = ivec2(f * vec2(2));
	float c = LUMAN0_tex((vec2(0.5) - f) * LUMAN0_pt + LUMAN0_pos)[i.y * 2 + i.x];
	return vec4(c);
}

//!DESC Anime4K-v3.0-RA-CNN(UL)-Resample
//!HOOK NATIVE
//!BIND HOOKED
//!BIND BACKUP
//!BIND RESID
//!WIDTH BACKUP.w
//!HEIGHT BACKUP.h

#define STRENGTH 1 //Strength of artifact reduction, high values might blur some edges.

vec4 hook() {
	float alpha = clamp(abs(RESID_tex(HOOKED_pos).x) * 20 * STRENGTH, 0, 1);
	float u = HOOKED_tex(HOOKED_pos).x + RESID_tex(HOOKED_pos).x;
	float o = BACKUP_tex(HOOKED_pos).x;
	
	return vec4(u * alpha + o * (1 - alpha), HOOKED_tex(HOOKED_pos).yz, 0);
}

