"""Example of program with many options using docopt.

Usage:
  options_example.py [-hvqrf NAME] [--exclude=PATTERNS]
                     [--select=ERRORS | --ignore=ERRORS] [--show-source]
                     [--statistics] [--count] [--benchmark] PATH...
  options_example.py (--doctest | --testsuite=DIR)
  options_example.py --version

Arguments:
  PATH  destination path

Options:
  -h --help            show this help message and exit
  --version            show version and exit
  -v --verbose         print status messages
  -q --quiet           report only file names
  -r --repeat          show all occurrences of the same error
  --exclude=PATTERNS   exclude files or directories which match these comma
                       separated patterns [default: .svn,CVS,.bzr,.hg,.git]
  -f NAME --file=NAME  when parsing directories, only check filenames matching
                       these comma separated patterns [default: *.py] [type: path]
  --select=ERRORS      select errors and warnings [choices: E W6]
  --ignore=ERRORS      skip errors and warnings [choices: E4 W]
  --show-source        show source code for each error
  --statistics         count errors and warnings
  --count              print total number of errors and warnings to standard
                       error and set exit code to 1 if total is not null
  --benchmark          measure processing speed
  --testsuite=DIR      run regression tests from dir [type: path]
  --doctest            run doctest on myself

"""
from type_docopt import docopt
from pathlib import Path


if __name__ == "__main__":
    arguments = docopt(__doc__, version="1.0.0rc2", types={"path": Path})
    print(arguments)
