/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.KSTests;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails$Ranked;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.reports.EnrichmentReports$Ret;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.FeatureAnnotChipImpl;
import java.util.Properties;
import xtools.api.AbstractTool$Helper;
import xtools.api.param.BooleanParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.Param;
import xtools.api.param.ParamFactory;
import xtools.api.param.RankedListReqdParam;
import xtools.gsea.AbstractGseaTool;

public class GseaPreranked
extends AbstractGseaTool {
    private final RankedListReqdParam fRankedListParam = new RankedListReqdParam();
    private final IntegerParam fShowDetailsForTopXSetsParam = new IntegerParam("plot_top_x", "Plot graphs for the top sets of each phenotype", "Plot GSEA mountain and related plots for the top sets of each phenotype", 20, false, Param.ADVANCED);
    private final BooleanParam fMakeZippedReportParam = ParamFactory.createZipReportParam(false);
    private final BooleanParam fMakeGeneSetReportsParam = new BooleanParam("make_sets", "Make detailed gene set report", "Create detailed gene set reports (heat-map, mountain plot etc) for every enriched gene set", true, false, Param.ADVANCED);
    private GeneSet[] fOrigGeneSets;

    public GseaPreranked(Properties properties) {
        super.init(properties);
    }

    public GseaPreranked(String[] stringArray) {
        super.init(stringArray);
    }

    public GseaPreranked() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        ReportIndexState reportIndexState = new ReportIndexState(true, false, false, GseaPreranked.createHeader(this.fRankedListParam));
        this.startExec(reportIndexState);
        RankedList rankedList = this.uniquize(this.fRankedListParam.getRankedList());
        if (rankedList.getSize() == 0) {
            throw new IllegalArgumentException("The chip and the ranked list did not match");
        }
        CollapsedDetails$Ranked collapsedDetails$Ranked = this.getRankedList(rankedList);
        this.fOrigGeneSets = this.fGeneSetMatrixParam.getGeneSetMatrixCombo(true).getGeneSets();
        GeneSet[] geneSetArray = AbstractTool$Helper.getGeneSets((Object)collapsedDetails$Ranked.getRankedList(), this.fOrigGeneSets, this.fGeneSetMinSizeParam, this.fGeneSetMaxSizeParam);
        ParamFactory.checkAndBarfIfZeroSets(geneSetArray);
        HtmlReportIndexPage htmlReportIndexPage = this.fReport.getIndexPage();
        this.execute_one(collapsedDetails$Ranked, geneSetArray, htmlReportIndexPage);
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    private void execute_one(CollapsedDetails collapsedDetails, GeneSet[] geneSetArray, HtmlReportIndexPage htmlReportIndexPage) {
        AbstractObject abstractObject;
        int n = this.fNumPermParam.getIValue();
        int n2 = this.fShowDetailsForTopXSetsParam.getIValue();
        RandomSeedGenerator randomSeedGenerator = this.fRndSeedTypeParam.createSeed();
        GeneSetCohortGenerator geneSetCohortGenerator = this.fGcohGenReqdParam.createGeneSetCohortGenerator(false);
        int n3 = this.fGeneSetMinSizeParam.getIValue();
        int n4 = this.fGeneSetMaxSizeParam.getIValue();
        Chip chip = null;
        RankedList rankedList = ((CollapsedDetails$Ranked)collapsedDetails).getRankedList();
        if (this.fChipParam.isSpecified()) {
            chip = this.fChipParam.getChipCombo();
            abstractObject = new FeatureAnnotChipImpl(chip, (ColorMap$Rows)null);
        } else {
            abstractObject = new FeatureAnnotImpl(rankedList.getName(), rankedList.getRankedNames(), null);
        }
        KSTests kSTests = new KSTests(this.getOutputStream());
        EnrichmentDb enrichmentDb = kSTests.executeGsea(rankedList, geneSetArray, n, randomSeedGenerator, chip, geneSetCohortGenerator);
        EnrichmentReports$Ret enrichmentReports$Ret = EnrichmentReports.createGseaLikeReport(enrichmentDb, this.getOutputStream(), collapsedDetails, htmlReportIndexPage, false, this.fReport, n2, n3, n4, this.fMakeGeneSetReportsParam.isTrue(), this.fMakeZippedReportParam.isTrue(), this.fOrigGeneSets, "PreRanked", this.fNormModeParam.getNormModeName(), abstractObject);
        new EdbFolderParser().export((PersistentObject)enrichmentReports$Ret.edb, enrichmentReports$Ret.savedInDir);
    }

    @Override
    protected final Param[] getAdditionalParams() {
        return new Param[]{this.fRankedListParam, this.fShowDetailsForTopXSetsParam, this.fMakeZippedReportParam, this.fMakeGeneSetReportsParam};
    }

    @Override
    public final String getDesc() {
        return "Run GSEA on a pre-ranked (with external tools) gene list";
    }

    public static final void main(String[] stringArray) {
        GseaPreranked gseaPreranked = new GseaPreranked(stringArray);
        GseaPreranked.tool_main(gseaPreranked);
    }

    private static final String createHeader(RankedListReqdParam rankedListReqdParam) {
        try {
            if (rankedListReqdParam.isSpecified()) {
                RankedList rankedList = rankedListReqdParam.getRankedList();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">GSEA Report for ").append("Dataset ").append(rankedList.getName()).append("</font></h3>\n").append("</div>");
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

