/*
 * Decompiled with CFR 0.152.
 */
package xtools.genesettools;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.DefaultGeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$Classic;
import edu.mit.broad.genome.alg.gsea.KSCore;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateMode;
import java.util.Map;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.MetricParam;
import xtools.api.param.OrderParam;
import xtools.api.param.ParamFactory;
import xtools.api.param.RankedListProcessorParam;
import xtools.api.param.SortParam;
import xtools.api.param.TemplateMultiChooserParam;

public class GeneSetStats
extends AbstractTool {
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final TemplateMultiChooserParam fTemplateParam = new TemplateMultiChooserParam(true, TemplateMode.CATEGORICAL_2_CLASS_ONLY);
    private final GeneSetMatrixMultiChooserParam fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam(true);
    private final OrderParam fOrderParam = new OrderParam(false);
    private final SortParam fSortParam = new SortParam(false);
    private final MetricParam fMetricParam = new MetricParam(false);
    private final BooleanParam fMedianParam = ParamFactory.createMedianParam(false);
    private final RankedListProcessorParam fRankedListProcParam = new RankedListProcessorParam(false);

    public GeneSetStats(Properties properties) {
        super.init(properties);
    }

    public GeneSetStats(String[] stringArray) {
        super.init(stringArray);
    }

    public GeneSetStats() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        String[] stringArray;
        PersistentObject persistentObject;
        int n;
        this.startExec();
        Dataset dataset = this.fDatasetParam.getDataset();
        Template[] templateArray = this.fTemplateParam.getTemplates(dataset);
        SortMode sortMode = this.fSortParam.getMode();
        Order order = this.fOrderParam.getOrder();
        Metric metric = this.fMetricParam.getMetric();
        LabelledVectorProcessor labelledVectorProcessor = this.fRankedListProcParam.getProcessor();
        Map map = this.fMetricParam.getMetricParams(this.fMedianParam);
        GeneSet[] geneSetArray = this.fGeneSetMatrixParam.getGeneSets(dataset, true);
        String[] stringArray2 = new String[]{"ES", "S2N_MEAN", "S2N_MEDIAN", "MEAN_CLASS_A", "MEAN_CLASS_B", "MEDIAN_CLASS_A", "MEDIAN_CLASS_B", "#GENES"};
        String[] stringArray3 = new String[geneSetArray.length];
        KSCore kSCore = new KSCore();
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        Dataframe[] dataframeArray = new Dataframe[templateArray.length];
        for (n = 0; n < templateArray.length; ++n) {
            persistentObject = datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, templateArray[n]);
            stringArray = datasetGenerators.extract(dataset, templateArray[n].getClass(0));
            Dataset dataset2 = datasetGenerators.extract(dataset, templateArray[n].getClass(1));
            Matrix matrix = new Matrix(stringArray3.length, stringArray2.length);
            DefaultGeneSetCohort defaultGeneSetCohort = new DefaultGeneSetCohort(new GeneSetScoringTables$Classic(), (RankedList)persistentObject, geneSetArray, true);
            float[] fArray = kSCore.calculateKSScores(defaultGeneSetCohort);
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                int n2 = 0;
                matrix.setElement(i2, n2++, fArray[i2]);
                float[] fArray2 = persistentObject.getScores(geneSetArray[i2]);
                matrix.setElement(i2, n2++, XMath.mean(fArray2));
                matrix.setElement(i2, n2++, XMath.median(fArray2));
                Vector[] vectorArray = stringArray.getRows(geneSetArray[i2]);
                Vector[] vectorArray2 = dataset2.getRows(geneSetArray[i2]);
                matrix.setElement(i2, n2++, XMath.mean_of_means(vectorArray));
                matrix.setElement(i2, n2++, XMath.mean_of_means(vectorArray2));
                matrix.setElement(i2, n2++, XMath.median_of_medians(vectorArray));
                matrix.setElement(i2, n2++, XMath.median_of_medians(vectorArray2));
                matrix.setElement(i2, n2, geneSetArray[i2].getNumMembers());
                if (n != 0) continue;
                stringArray3[i2] = geneSetArray[i2].getName();
            }
            dataframeArray[n] = new Dataframe("stats_for_" + templateArray[n].getName(), matrix, stringArray3, stringArray2, true);
            this.fReport.savePageDF("Statistics for dataset: " + dataset.getName() + " and phenotype: " + templateArray[n].getName(), dataframeArray[n]);
        }
        for (n = 0; n < geneSetArray.length; ++n) {
            persistentObject = new Matrix(templateArray.length, stringArray2.length);
            stringArray = new String[templateArray.length];
            for (int i3 = 0; i3 < templateArray.length; ++i3) {
                ((Matrix)persistentObject).setRow(i3, dataframeArray[i3].getRow(geneSetArray[n].getName()));
                stringArray[i3] = templateArray[i3].getName();
            }
            this.fReport.savePageDF("Statistics for gene set: " + geneSetArray[n].getName(), new Dataframe("stats_for_" + geneSetArray[n].getName(), (Matrix)persistentObject, stringArray, stringArray2, true));
        }
        this.doneExec();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.GENESET_TOOLS;
    }

    @Override
    public final String getDesc() {
        return "Calculate some useful statistics about the input gene sets";
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParam(this.fTemplateParam);
        this.fParamSet.addParam(this.fSortParam);
        this.fParamSet.addParam(this.fOrderParam);
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
        this.fParamSet.addParam(this.fMetricParam);
        this.fParamSet.addParam(this.fMedianParam);
        this.fParamSet.addParam(this.fRankedListProcParam);
    }

    public static final void main(String[] stringArray) {
        GeneSetStats geneSetStats = new GeneSetStats(stringArray);
        GeneSetStats.tool_main(geneSetStats);
    }
}

