/*
 * Decompiled with CFR 0.152.
 */
package xtools.genesettools;

import edu.mit.broad.genome.alg.InfoCrystalAlg;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.reports.api.ToolReport;
import java.io.File;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ReportBlocks$SimpleBlockListing;
import xtools.api.ToolCategory;
import xtools.api.param.GeneSetMatrixMultiChooserParam;

public class FindOverlaps
extends AbstractTool {
    private final GeneSetMatrixMultiChooserParam fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam(true);

    public FindOverlaps(Properties properties) {
        super.init(properties);
    }

    public FindOverlaps(String[] stringArray) {
        super.init(stringArray);
    }

    public FindOverlaps() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        this.startExec(false);
        GeneSetMatrix geneSetMatrix = this.fGeneSetMatrixParam.getGeneSetMatrixCombo(true);
        FindOverlaps.doOverlaps(geneSetMatrix, this.fReport);
        this.doneExec();
    }

    public static final void doOverlaps(GeneSetMatrix geneSetMatrix, ToolReport toolReport) {
        File file;
        Object object;
        ReportBlocks$SimpleBlockListing reportBlocks$SimpleBlockListing = new ReportBlocks$SimpleBlockListing("Overlaps are listed below", toolReport);
        try {
            object = InfoCrystalAlg.createXWay(geneSetMatrix);
            file = toolReport.savePage("overlap_counts", "Overlap counts between input gene sets", object.getAsString());
            File file2 = toolReport.savePage(object.getGeneSetMatrix());
            reportBlocks$SimpleBlockListing.add("Overlaps", file);
            reportBlocks$SimpleBlockListing.add("Gene sets made from overlaps", file2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        klog.info("Doing the rest for bsd anyway ...");
        object = geneSetMatrix.getGeneSetMembershipBitSetDataset();
        file = toolReport.savePageXls(((BitSetDataset)object).toDataframe(true, true));
        reportBlocks$SimpleBlockListing.add("Association matrix of features", file);
        reportBlocks$SimpleBlockListing.close();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.GENESET_TOOLS;
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
    }

    @Override
    public final String getDesc() {
        return "Find overlaps between gene sets (max allowed is 5)";
    }

    public static final void main(String[] stringArray) {
        FindOverlaps findOverlaps = new FindOverlaps(stringArray);
        FindOverlaps.tool_main(findOverlaps);
    }
}

