/*
 * Decompiled with CFR 0.152.
 */
package xtools.genesettools;

import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.objects.GeneSet;
import java.io.File;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ReportBlocks$SimpleBlockListing;
import xtools.api.ToolCategory;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.ParamFactory;

public class FindManyOverlaps
extends AbstractTool {
    private final GeneSetMatrixMultiChooserParam fDbGeneSetsParam = new GeneSetMatrixMultiChooserParam("db", "Gene Set (find overlaps to this set)", "GeneSet (grp file; only 1 allowed)", true, true, false);
    private final GeneSetMatrixMultiChooserParam fQueryGeneSetsParam = new GeneSetMatrixMultiChooserParam("query", "query gene sets", "query gene sets", true);
    private final IntegerParam fGeneSetMinSizeParam = ParamFactory.createGeneSetMinSizeParam(false);
    private final IntegerParam fGeneSetMaxSizeParam = ParamFactory.createGeneSetMaxSizeParam(false);
    private final IntegerParam fMinOverlapParam = new IntegerParam("min_overlap", "dont show smaller overlaps", 5, false);

    public FindManyOverlaps(Properties properties) {
        super.init(properties);
    }

    public FindManyOverlaps(String[] stringArray) {
        super.init(stringArray);
    }

    public FindManyOverlaps() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        Object object;
        this.startExec(true);
        GeneSet[] geneSetArray = this.fQueryGeneSetsParam.getGeneSets(this.fGeneSetMinSizeParam, this.fGeneSetMaxSizeParam, true);
        GeneSet[] geneSetArray2 = this.fDbGeneSetsParam.getGeneSets(this.fGeneSetMinSizeParam, this.fGeneSetMaxSizeParam, true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QUERY_NAME\tQUERY_SIZE\tDB_NAME\tDB_SIZE\tOVERLAP\tFRACTION\n");
        for (int i2 = 0; i2 < geneSetArray2.length; ++i2) {
            object = geneSetArray2[i2].getName(true);
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                String string = geneSetArray[i3].getName(true);
                GeneSet geneSet = AlgUtils.intersect(string, geneSetArray[i3], geneSetArray2[i2]);
                if (geneSet.getNumMembers() <= this.fMinOverlapParam.getIValue()) continue;
                float f2 = (float)geneSet.getNumMembers() / (float)geneSetArray2[i2].getNumMembers();
                stringBuffer.append((String)object).append('\t').append(geneSetArray2[i2].getNumMembers()).append('\t');
                stringBuffer.append(string).append('\t').append(geneSetArray[i3].getNumMembers()).append('\t');
                stringBuffer.append(geneSet.getNumMembers()).append('\t').append(f2).append('\n');
            }
        }
        File file = this.fReport.savePageTxt("overlaps", "overlaps", stringBuffer.toString());
        object = new ReportBlocks$SimpleBlockListing("Overlaps are listed below", this.fReport);
        ((ReportBlocks$SimpleBlockListing)object).add("Overlaps", file);
        ((ReportBlocks$SimpleBlockListing)object).close();
        this.doneExec();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.GENESET_TOOLS;
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fMinOverlapParam);
        this.fParamSet.addParam(this.fDbGeneSetsParam);
        this.fParamSet.addParam(this.fQueryGeneSetsParam);
        this.fParamSet.addParam(this.fGeneSetMinSizeParam);
        this.fParamSet.addParam(this.fGeneSetMaxSizeParam);
    }

    @Override
    public final String getDesc() {
        return "Find pairwise overlaps between a gene set and a target database";
    }

    public static final void main(String[] stringArray) {
        FindManyOverlaps findManyOverlaps = new FindManyOverlaps(stringArray);
        FindManyOverlaps.tool_main(findManyOverlaps);
    }
}

