/*
 * Decompiled with CFR 0.152.
 */
package xtools.chip2chip;

import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipChooserMultiParam;
import xtools.api.param.GeneSetMatrixFormatParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.ParamFactory;
import xtools.chip2chip.Chip2Chip_orig_restore_later;

public class Chip2Chip
extends AbstractTool {
    private final GeneSetMatrixMultiChooserParam fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam("gmx", "Gene sets database (symbols only)", "Gene sets database (symbols only)", true);
    private final BooleanParam fShowEtiology = ParamFactory.createShowEtiologyParam(true, false);
    private final GeneSetMatrixFormatParam fGmFormatParam = new GeneSetMatrixFormatParam(DataFormat.GMT_FORMAT, false);
    protected final ChipChooserMultiParam fChipsTargetParam = ParamFactory.createChipsTargetParam(true);

    public Chip2Chip(Properties properties) {
        super.init(properties);
    }

    public Chip2Chip(String[] stringArray) {
        super.init(stringArray);
    }

    public Chip2Chip() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        ReportIndexState reportIndexState = new ReportIndexState(true, false, true, Chip2Chip_orig_restore_later.createHeader());
        this.startExec(reportIndexState);
        GeneSetMatrix geneSetMatrix = this.fGeneSetMatrixParam.getGeneSetMatrixCombo(true);
        Chip2ChipMapper[] chip2ChipMapperArray = new Chip2ChipMapper[]{new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), this.fChipsTargetParam.getChipCombo())};
        Chip2Chip_orig_restore_later.doMapping(chip2ChipMapperArray, geneSetMatrix, this.fShowEtiology.isTrue(), this.fGmFormatParam, this.fReport);
        this.doneExec();
    }

    @Override
    public final String getDesc() {
        return "Map probe sets between chip platforms";
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
        this.fParamSet.addParam(this.fGmFormatParam);
        this.fParamSet.addParam(this.fShowEtiology);
        this.fParamSet.addParam(this.fChipsTargetParam);
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.MAPPING_TOOLS;
    }

    public static final void main(String[] stringArray) {
        Chip2Chip chip2Chip = new Chip2Chip(stringArray);
        Chip2Chip.tool_main(chip2Chip);
    }
}

