/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.utils.Strings;
import edu.mit.broad.genome.utils.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.param.GuiParam;
import xtools.api.param.MissingReqdParamException;
import xtools.api.param.Param;
import xtools.api.param.Param$Type;
import xtools.api.param.ParamComparator;
import xtools.api.param.ParamSet;
import xtools.api.param.ParamSet$FoundMissingFile;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;

public class ToolParamSet
implements ParamSet {
    private final List fReqdParams;
    private final List fOptParams;
    private final Logger log = XLogger.getLogger(ToolParamSet.class);

    public ToolParamSet() {
        this.fReqdParams = new ArrayList();
        this.fOptParams = new ArrayList();
    }

    public final Param getParam(String string) {
        Param param;
        int n;
        for (n = 0; n < this.fReqdParams.size(); ++n) {
            param = (Param)this.fReqdParams.get(n);
            if (!param.getName().equals(string)) continue;
            return param;
        }
        for (n = 0; n < this.fOptParams.size(); ++n) {
            param = (Param)this.fOptParams.get(n);
            if (!param.getName().equals(string)) continue;
            return param;
        }
        return null;
    }

    public final void addParam(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("Null param not allowed");
        }
        this.checkUniqueness(param);
        if (param.isReqd()) {
            this.fReqdParams.add(param);
        } else {
            this.fOptParams.add(param);
        }
    }

    public final void addParamAdv(Param param) {
        param.setType(Param.ADVANCED);
        this.addParam(param);
    }

    public final void addParamPseudoReqd(Param param) {
        param.setType(Param.PSEUDO_REQUIRED);
        this.addParam(param);
    }

    public final void addParamBasic(Param param) {
        param.setType(Param.BASIC);
        this.addParam(param);
    }

    @Override
    public final int getNumParams() {
        return this.fReqdParams.size() + this.fOptParams.size();
    }

    @Override
    public final Param getParam(int n) {
        if (n < this.fReqdParams.size()) {
            return (Param)this.fReqdParams.get(n);
        }
        return (Param)this.fOptParams.get(n - this.fReqdParams.size());
    }

    /*
     * WARNING - void declaration
     */
    public final void fill(Properties properties) {
        Object object2;
        Object object3;
        int n;
        for (n = 0; n < this.fReqdParams.size(); ++n) {
            void object4;
            object3 = (Param)this.fReqdParams.get(n);
            object2 = properties.getProperty(object3.getName());
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            if (object2 != null && ((String)object2).equals("")) {
                Object var5_7 = null;
            } else if (object2 != null && ((String)object2).equalsIgnoreCase("null")) {
                Object var5_8 = null;
            } else if (object2 != null) {
                String string = object2;
            } else {
                Object var5_10 = null;
            }
            object3.setValue(object4);
        }
        for (n = 0; n < this.fOptParams.size(); ++n) {
            void var5_16;
            object3 = (Param)this.fOptParams.get(n);
            object2 = properties.getProperty(object3.getName());
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            if (object2 != null && ((String)object2).equals("")) {
                Object var5_12 = null;
            } else if (object2 != null && ((String)object2).equalsIgnoreCase("null")) {
                Object var5_13 = null;
            } else if (object2 != null) {
                String string = object2;
            } else {
                Object var5_15 = null;
            }
            object3.setValue(var5_16);
        }
        HashSet<String> hashSet = new HashSet<String>();
        object3 = properties.keySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next().toString();
            Param param = this.getParam((String)object2);
            if (param != null || ((String)object2).equals("param_file")) continue;
            hashSet.add((String)object2);
        }
        if (!hashSet.isEmpty()) {
            object3 = new StringBuffer("Some specified parameters are UNKNOWN to this usage: ").append(hashSet.size()).append('\n');
            for (Object e2 : hashSet) {
                ((StringBuffer)object3).append(e2).append('\t').append('>').append(properties.getProperty(e2.toString())).append("<\n");
            }
            this.log.warn(((StringBuffer)object3).toString());
        }
    }

    @Override
    public final ParamSet$FoundMissingFile fileCheckingFill(Properties properties) {
        File file;
        String string;
        String string2;
        Param param;
        int n;
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < this.fReqdParams.size(); ++n) {
            param = (Param)this.fReqdParams.get(n);
            string2 = properties.getProperty(param.getName());
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = string2 != null && string2.equals("") ? null : (string2 != null ? string2 : null)) != null && param.isFileBased() && !(param instanceof ReportDirParam) && !NamingConventions.isURL(string)) {
                file = new File(string);
                if (!(file = AuxUtils.getBaseFileFromAuxFile(file)).exists()) {
                    string = null;
                    arrayList2.add(file);
                } else {
                    arrayList3.add(param.getName());
                    arrayList.add(file);
                }
            }
            param.setValue(string);
        }
        for (n = 0; n < this.fOptParams.size(); ++n) {
            param = (Param)this.fOptParams.get(n);
            string2 = properties.getProperty(param.getName());
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = string2 != null && string2.equals("") ? null : (string2 != null ? string2 : null)) != null && param.isFileBased() && !NamingConventions.isURL(string)) {
                file = new File(string);
                if (!file.exists()) {
                    string = null;
                    arrayList2.add(file);
                } else {
                    arrayList3.add(param.getName());
                    arrayList.add(file);
                }
            }
            param.setValue(string);
        }
        ParamSet$FoundMissingFile paramSet$FoundMissingFile = new ParamSet$FoundMissingFile();
        paramSet$FoundMissingFile.foundFiles = arrayList.toArray(new File[arrayList.size()]);
        paramSet$FoundMissingFile.foundFilesParamNames = arrayList3.toArray(new String[arrayList3.size()]);
        paramSet$FoundMissingFile.missingFiles = arrayList2.toArray(new File[arrayList2.size()]);
        return paramSet$FoundMissingFile;
    }

    @Override
    public final Properties toProperties() {
        Properties properties = new Properties();
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            Param param = this.getParam(i2);
            String string = param.getValueStringRepresentation(true);
            if (string == null || (string = string.trim()).length() <= 0) continue;
            properties.setProperty(param.getName(), string);
        }
        return properties;
    }

    public final void check() {
        StringBuffer stringBuffer = new StringBuffer("\n\nError: Missing the following required parameters:\n");
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (int i2 = 0; i2 < this.fReqdParams.size(); ++i2) {
            Param param = (Param)this.fReqdParams.get(i2);
            if (param.isSpecified()) continue;
            stringBuffer.append('\t').append(((Param)this.fReqdParams.get(i2)).formatForCmdLine());
            arrayList.add(param);
        }
        stringBuffer.append("\n-----------------------------------------------------------\n");
        stringBuffer.append(this.getUsage());
        if (!arrayList.isEmpty()) {
            throw new MissingReqdParamException(arrayList.toArray(new Param[arrayList.size()]));
        }
    }

    @Override
    public final boolean isRequiredAllSet() {
        for (int i2 = 0; i2 < this.fReqdParams.size(); ++i2) {
            Param param = (Param)this.fReqdParams.get(i2);
            if (param.isSpecified() || param.getDefault() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Param[] getParams() {
        int n;
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < this.fReqdParams.size(); ++n) {
            arrayList.add(this.fReqdParams.get(n));
        }
        for (n = 0; n < this.fOptParams.size(); ++n) {
            arrayList.add(this.fOptParams.get(n));
        }
        return arrayList.toArray(new Param[arrayList.size()]);
    }

    @Override
    public final Param[] getParams(Param$Type param$Type, boolean bl) {
        Param[] paramArray = this.getParams();
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            if (bl && paramArray[i2] instanceof GuiParam || !paramArray[i2].getType().equals(param$Type)) continue;
            arrayList.add(paramArray[i2]);
        }
        return arrayList.toArray(new Param[arrayList.size()]);
    }

    @Override
    public final ReportDirParam getAnalysisDirParam() {
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            Param param = this.getParam(i2);
            if (!(param instanceof ReportDirParam)) continue;
            return (ReportDirParam)param;
        }
        return null;
    }

    @Override
    public final ReportLabelParam getReportLabelParam() {
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            Param param = this.getParam(i2);
            if (!(param instanceof ReportLabelParam)) continue;
            return (ReportLabelParam)param;
        }
        return null;
    }

    @Override
    public final GuiParam getGuiParam() {
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            Param param = this.getParam(i2);
            if (!(param instanceof GuiParam)) continue;
            return (GuiParam)param;
        }
        return null;
    }

    public final void printf() {
        System.out.println(this.getUsage());
    }

    public final String getSpecifiedParametersAsString() {
        String string;
        Param param;
        int n;
        StringBuffer stringBuffer = new StringBuffer("\nParameters\n");
        for (n = 0; n < this.fReqdParams.size(); ++n) {
            param = (Param)this.fReqdParams.get(n);
            string = param.getValueStringRepresentation(true);
            stringBuffer.append(param.getName()).append('\t').append(string).append('\n');
        }
        for (n = 0; n < this.fOptParams.size(); ++n) {
            param = (Param)this.fOptParams.get(n);
            string = param.getValueStringRepresentation(true);
            stringBuffer.append(param.getName()).append('\t').append(string).append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getAsCommand(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            String string = SystemUtils.getJavaPath();
            object = SystemUtils.getClassPath();
            stringBuffer.append(string).append(" -cp ").append((String)object);
        }
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            String string;
            object = this.getParam(i2);
            if (bl3 && object instanceof GuiParam || (string = object.getValueStringRepresentation(bl2)) == null || (string = string.trim()).length() <= 0) continue;
            stringBuffer.append(" -").append(object.getName()).append(' ').append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getAsCygwinCommand(Tool tool) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java -Xmx256m ");
        stringBuffer.append(tool.getName()).append(" ");
        String string = this.getAsCommand(false, true, false);
        string = Strings.change(string, "\\", "\\\\");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    public final String getAsUnixCommand(Tool tool) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/usr/opt/java141/bin/java ").append("-cp /xchip/software/xtools/lib/xtools.jar -Xmx512m ");
        stringBuffer.append(tool.getName()).append(" ");
        String string = "";
        string = Strings.change(string, "\\", "/");
        string = Strings.change(string, "//", "/");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    public final String getAsLsfJavaCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string + this.getAnalysisDirParam().getAnalysisDir().getName();
        String string3 = string + "data/";
        for (int i2 = 0; i2 < this.getNumParams(); ++i2) {
            Param param = this.getParam(i2);
            String string4 = param.getValueStringRepresentation(false);
            if (string4 == null || (string4 = string4.trim()).length() <= 0) continue;
            stringBuffer.append(" -").append(param.getName()).append(' ');
            if (param instanceof ReportDirParam) {
                stringBuffer.append(string2);
                continue;
            }
            if (param.isFileBased()) {
                File file = new File(string4);
                stringBuffer.append(string3).append(file.getName());
                continue;
            }
            if (param instanceof GuiParam) continue;
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public final String getUsage() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("\n######## USAGE ########\n\n");
        if (this.fReqdParams.size() > 0) {
            stringBuffer.append("Required Parameters:").append('\n');
            for (n = 0; n < this.fReqdParams.size(); ++n) {
                stringBuffer.append(((Param)this.fReqdParams.get(n)).formatForCmdLine()).append('\n');
            }
        } else {
            stringBuffer.append("No required parameters").append('\n');
        }
        stringBuffer.append('\n');
        if (this.fOptParams.size() > 0) {
            stringBuffer.append("Optional Parameters:").append('\n');
            for (n = 0; n < this.fOptParams.size(); ++n) {
                stringBuffer.append(((Param)this.fOptParams.get(n)).formatForCmdLine()).append('\n');
            }
        } else {
            stringBuffer.append("No optional parameters").append('\n');
        }
        return stringBuffer.toString();
    }

    public final void printfUsage() {
        System.out.println(this.getUsage());
    }

    private void checkUniqueness(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        if (this.fOptParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param + " # params: " + this.getNumParams() + " in the opt param list");
        }
        if (this.fReqdParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param.getName() + " # params: " + this.getNumParams() + " in the reqd param list");
        }
    }

    public final void sort() {
        Collections.sort(this.fReqdParams, new ParamComparator());
        Collections.sort(this.fOptParams, new ParamComparator());
    }
}

