/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI$Field;
import edu.mit.broad.xbench.xchoosers.TemplateSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import xtools.api.param.ParamHelper;
import xtools.api.param.StringMultiChooserParam;

abstract class TemplateChooserAbstractParam
extends StringMultiChooserParam
implements ActionListener {
    protected TemplateMode fMode;
    private TemplateChooserUI fTemplateChooser;
    private boolean fIsMultiAllowed;
    private TemplateSelection fCurrBag;
    private Logger log = XLogger.getLogger(TemplateChooserAbstractParam.class);

    protected TemplateChooserAbstractParam(boolean bl, TemplateMode templateMode, boolean bl2) {
        this("cls", "Phenotype labels", "Phenotype labels for the samples in the expression dataset (cls file)", bl, templateMode, bl2);
    }

    protected TemplateChooserAbstractParam(String string, String string2, String string3, boolean bl, TemplateMode templateMode, boolean bl2) {
        super(string, string2, string3, new String[0], new String[0], bl);
        this.fMode = templateMode;
        this.fIsMultiAllowed = bl2;
    }

    @Override
    public String getLongDesc() {
        if (this.fLongDesc == null) {
            this.fLongDesc = new StringBuffer("<html><body>");
            this.fLongDesc.append("Phenotype labels for the samples in the expression dataset (cls file)");
            this.fLongDesc.append("<br>");
            if (!this.fIsMultiAllowed) {
                this.fLongDesc.append(" Only 1 Template allowed<br>");
            } else {
                this.fLongDesc.append(" One or more Templates allowed<br>");
            }
            this.fLongDesc.append(this.fMode.getDesc());
        }
        return this.fLongDesc.toString();
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    protected final GFieldPlusChooser _getSelectionComponent() {
        if (this.fTemplateChooser == null) {
            this.fTemplateChooser = new TemplateChooserUI(this.fIsMultiAllowed, this.fMode);
            this.fChooser = new TemplateChooserUI$Field(this);
            this.fChooser.setValue(this.getValueStringRepresentation(true));
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            TemplateSelection templateSelection = this.fTemplateChooser.showChooser(this.fCurrBag);
            if (templateSelection != null) {
                this.fChooser.setText(templateSelection.formatForUI());
            }
            this.fCurrBag = templateSelection;
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Could not query Phenotypes", throwable);
        }
    }

    private Template[] _getGeneTemplates(String[] stringArray, Dataset dataset) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        try {
            dataset.getRowIndex(stringArray[0]);
            Template[] templateArray = new Template[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                templateArray[i2] = TemplateFactory.createContinuousTemplate(stringArray[i2], dataset);
            }
            return templateArray;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected final Template[] _getTemplates(Dataset dataset) {
        Object[] objectArray = this.getStrings();
        Printf.out(objectArray);
        Template[] templateArray = this._getGeneTemplates((String[])objectArray, dataset);
        if (templateArray != null) {
            return templateArray;
        }
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("No templates specified -- 0 length str array");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object2;
            if (!this._isPath((String)objectArray[i2])) {
                Object object3;
                object = this._getSourceTemplate((String)objectArray[i2], (Template)object);
                object2 = AuxUtils.getAuxNameOnlyNoHash((String)objectArray[i2]);
                this.log.debug("parsing: " + (String)objectArray[i2] + "< and i got auxname>" + (String)object2 + "<" + " currMaintemplate: " + object.getName());
                if (((String)object2).equals("OVA")) {
                    if (!this.fIsMultiAllowed) {
                        throw new IllegalArgumentException("Invalid Template option: " + (String)object2 + " multiple templates not allowed in this usage");
                    }
                    object3 = TemplateFactory.extractAllOvaTemplates((Template)object, false);
                    for (int i3 = 0; i3 < ((Template[])object3).length; ++i3) {
                        arrayList.add(object3[i3]);
                    }
                    continue;
                }
                if (((String)object2).equals("FOVA")) {
                    if (!this.fIsMultiAllowed) {
                        throw new IllegalArgumentException("Invalid Template option: " + (String)object2 + " multiple templates not allowed in this usage");
                    }
                    object3 = TemplateFactory.extractAllOvaTemplates((Template)object, true);
                    for (int i4 = 0; i4 < ((Template[])object3).length; ++i4) {
                        arrayList.add(object3[i4]);
                    }
                    continue;
                }
                if (((String)object2).equals("ALL_PAIRS")) {
                    if (!this.fIsMultiAllowed) {
                        throw new IllegalArgumentException("Invalid Template option: " + (String)object2 + " multiple templates not allowed in this usage");
                    }
                    object3 = TemplateFactory.extractAllPairsTemplates((Template)object);
                    for (int i5 = 0; i5 < ((Template[])object3).length; ++i5) {
                        arrayList.add(object3[i5]);
                    }
                    continue;
                }
                object3 = ParserFactory.getCache().getSourceFile(object);
                object3 = AuxUtils.getBaseFileFromAuxFile((File)object3);
                Template template = ParserFactory.readTemplate(new File(((File)object3).getPath() + "#" + (String)object2), true);
                arrayList.add(template);
                continue;
            }
            object2 = ParserFactory.readTemplate(new File((String)objectArray[i2]), true, false, true);
            arrayList.add(object2);
            object = object2;
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    private boolean _isPath(String string) {
        return string.indexOf(File.separator) != -1;
    }

    private Template _getSourceTemplate(String string, Template template) {
        if (string.indexOf(File.separatorChar) == -1) {
            if (template == null) {
                return ParserFactory.readTemplate(new File(SystemUtils.getPwd(), string));
            }
            return template;
        }
        return ParserFactory.readTemplate(new File(string));
    }

    private Template _getMainTemplate(String string) {
        File file = AuxUtils.getBaseFileFromFullPath(string);
        return ParserFactory.readTemplate(file);
    }
}

