/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import xtools.api.param.DatasetOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.FileParam;

public class SampleAnnotParam
extends FileParam {
    public SampleAnnotParam() {
        super("sin", "Path to the sin file", "Path to a custom generic sample annotation (SIN) file", false);
    }

    public SampleAnnotParam(boolean bl) {
        super("sin", "Path to the sin file", "Path to a custom generic sample annotation (SIN) file", bl);
    }

    public SampleAnnotParam(String string) {
        super(string, "Path to the sin file", "Path to a custom generic sample annotation (SIN) file", false);
    }

    public final SampleAnnot getAnnot() {
        return ParserFactory.readSampleAnnot(this.getFile(), true, true);
    }

    public final SampleAnnot getAnnot(FileParam fileParam) {
        SampleAnnot sampleAnnot = this.getAnnot();
        if (fileParam != null && fileParam.isSpecified() && fileParam.getFile().getName().indexOf(".comp") == -1) {
            String[] stringArray = fileParam.getStringsUnique();
            return sampleAnnot.cloneDeep(stringArray);
        }
        return sampleAnnot;
    }

    public final SampleAnnot getAnnot(DatasetReqdParam datasetReqdParam) {
        SampleAnnot sampleAnnot = this.getAnnot();
        if (datasetReqdParam != null) {
            String[] stringArray = datasetReqdParam.getDataset().getColumnNamesArray();
            return sampleAnnot.cloneDeep(stringArray);
        }
        return sampleAnnot;
    }

    public final SampleAnnot getAnnot(DatasetOptParam datasetOptParam) {
        SampleAnnot sampleAnnot = this.getAnnot();
        if (datasetOptParam != null && datasetOptParam.isSpecified()) {
            String[] stringArray = datasetOptParam.getDataset().getColumnNamesArray();
            return sampleAnnot.cloneDeep(stringArray);
        }
        return sampleAnnot;
    }

    public final SampleAnnot getAnnot(Dataset dataset) {
        SampleAnnot sampleAnnot = this.getAnnot();
        if (dataset != null) {
            String[] stringArray = dataset.getColumnNamesArray();
            return sampleAnnot.cloneDeep(stringArray);
        }
        return sampleAnnot;
    }
}

