/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.markers.PermutationTestImpl;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import xtools.api.param.BadParamException;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipChooserMultiParam;
import xtools.api.param.ChipReqdParam;
import xtools.api.param.DirParam;
import xtools.api.param.FileParam;
import xtools.api.param.FloatParam;
import xtools.api.param.FloatsChooserParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.IntegersChooserParam;
import xtools.api.param.Param;
import xtools.api.param.StringInputParam;
import xtools.api.param.StringMultiInputParam;
import xtools.api.param.StringReqdParam;

public class ParamFactory {
    private static final Logger klog = XLogger.getLogger(ParamFactory.class);
    private static final float[] pvf = new float[]{0.05f, 0.1f, 0.15f, 0.2f, 0.5f, 1.0f, 0.01f, 0.025f, 0.001f, 0.005f};

    private ParamFactory() {
    }

    public static final BooleanParam createForceRefreshParam() {
        return new BooleanParam("force_refresh", "overwrite even if already present in bged_cache", false, false);
    }

    public static final BooleanParam createCollapseParam() {
        return new BooleanParam("collapse", "Collapse probe sets => 1 gene", "Combine all probe set ids for a given gene into a single value", true, false);
    }

    public static final IntegerParam createHeatMapCellSizeParam() {
        return ParamFactory.createHeatMapCellSizeParam(8);
    }

    public static final IntegerParam createHeatMapCellSizeParam(int n) {
        return new IntegerParam("cell_size", "cell size", n, false);
    }

    public static final IntegerParam createNumTrollsParam() {
        return new IntegerParam("num", "num codes", 5, false);
    }

    public static final FloatParam createThreshParam() {
        return new FloatParam("thresh", "threshold for prediction", 0.5f, true);
    }

    public static final FloatParam createPosFoldChangeParam() {
        return new FloatParam("pos", "pos fold change", 1.585f, false);
    }

    public static final FloatParam createNegFoldChangeParam() {
        return new FloatParam("neg", "neg fold change", 1.585f, false);
    }

    public static final IntegerParam createNumNotMidParam() {
        return new IntegerParam("not_mid_thresh", "num not mid threshold", 1, false);
    }

    public static final BooleanParam createMakeResParam(boolean bl, boolean bl2) {
        return new BooleanParam("make_res", "make res files", "make res files with a and p calls", bl, bl2);
    }

    public static final FileParam createCelFileNamesParam(boolean bl) {
        return new FileParam("cel", "Create a dataset using these CEL files", "Create a dataset using these CEL files", new File[0], bl);
    }

    public static final StringInputParam createPlateNameParam(boolean bl) {
        return new StringInputParam("plate", "HTA plate bar code", bl);
    }

    public static final StringMultiInputParam createPlateNamesParam(boolean bl) {
        return new StringMultiInputParam("plate", "HTA plate bar code", bl);
    }

    public static final BooleanParam createZipReportParam(boolean bl) {
        return new BooleanParam("zip_report", "Make a zipped file with all reports", "Create a zipped file with all files made by the report. This can be emailed to share results", false, bl, Param.ADVANCED);
    }

    public static final BooleanParam createLogitParam(boolean bl, boolean bl2) {
        return new BooleanParam("logit", "logit", "take log", bl, bl2);
    }

    public static final IntegerParam createNumBinsParam(int n, boolean bl) {
        return new IntegerParam("nbins", "number of bins", n, bl);
    }

    public static final FloatParam createMaxParam(float f2, boolean bl) {
        return new FloatParam("max", "Maximum value", f2, bl);
    }

    public static final FloatParam createMinParam(float f2, boolean bl) {
        return new FloatParam("min", "Minimum value", f2, bl);
    }

    public static final FloatParam createMaxParam(float[] fArray, boolean bl) {
        return new FloatParam("max", "Maximum value", fArray, bl);
    }

    public static final FloatParam createMinParam(float[] fArray, boolean bl) {
        return new FloatParam("min", "Minimum value", fArray, bl);
    }

    public static final FloatParam createCutoffLowerPValueBoundParam(boolean bl) {
        return new FloatParam("plower", "Lower P-value bound", 0.0f, bl);
    }

    public static final FloatParam createCutoffUpperPValueBoundParam(boolean bl) {
        return new FloatParam("plower", "Lower P-value bound", 0.0f, bl);
    }

    public static final StringReqdParam createRPathParam() {
        return new StringReqdParam("rpath", "path to R", new String[]{"C:\\Program Files\\R\\rw1090\\bin\\R", "/usr/bin/R"});
    }

    public static final BooleanParam createGeneSetUnionParam(boolean bl, boolean bl2) {
        return new BooleanParam("union", "union of all input gene sets", bl, bl2);
    }

    public static final BooleanParam createGeneSetIntersectionParam(boolean bl, boolean bl2) {
        return new BooleanParam("common", "intersection of all input gene sets", bl, bl2);
    }

    public static final BooleanParam createIgnoreUnenrichedParam(boolean bl, boolean bl2) {
        return new BooleanParam("ignore_unenriched", "ignore unenriched", bl, bl2);
    }

    public static final BooleanParam createIgnoreUnenrichedParam() {
        return ParamFactory.createIgnoreUnenrichedParam(true, false);
    }

    public static final BooleanParam createScoreByPhenotypeCorrParam(boolean bl, boolean bl2) {
        return new BooleanParam("pheno_corr", "score by pheno corr", bl, bl2);
    }

    public static final BooleanParam createShowMegDetailsParam(boolean bl, boolean bl2) {
        return new BooleanParam("show_details", "Show detailed info on genes/genesets (might be meory intensive)", bl, bl2);
    }

    public static final BooleanParam createMakeReportSubDirParam(boolean bl, boolean bl2) {
        return new BooleanParam("make_rpt_dir", "make report specific sub directories", bl, bl2);
    }

    public static final BooleanParam createBpogParam(boolean bl) {
        return ParamFactory.createBpogParam(true, bl);
    }

    public static final BooleanParam createBpogParam(boolean bl, boolean bl2) {
        return new BooleanParam("bpog", "Create a blue-pinkogram image (dont for large number of markers", bl, bl2);
    }

    public static final BooleanParam createRandomParam(boolean bl, boolean bl2) {
        return new BooleanParam("rnd", "Do random mode param", bl, bl2);
    }

    public static final IntegersChooserParam createModesParam(int n) {
        return new IntegersChooserParam("mode", "mode", new Integer(n), false);
    }

    public static final DirParam createEdbDirParam(boolean bl) {
        return new DirParam("edb_folder", "folder where the edb files to be collected are", bl);
    }

    public static final DirParam createEdbAltDirParam(boolean bl) {
        return new DirParam("alt_datadir", "folder with the datasets, gsets and templates that go into the edb(used in pref of whats in the edb)", bl);
    }

    public static final StringReqdParam createExecModeParam() {
        return new StringReqdParam("exec", "execution mode", new String[]{"local", "lsf", "lsf_batch"});
    }

    public static final BooleanParam createIncludeEmptyProfiles() {
        return new BooleanParam("include_empty", "Include empty (fully missing) probes as an empty (fully missing) profile in the dataset", false, false);
    }

    public static final BooleanParam createUseGmtFormatParam(boolean bl, boolean bl2) {
        return new BooleanParam("gmt_format", "Use the GeneSetMatrix - Transposed format", bl, bl2);
    }

    public static final BooleanParam createPreviewRunParam(String string) {
        return new BooleanParam("preview", string, true, false);
    }

    public static final StringInputParam createFilterModParam() {
        return new StringInputParam("filt_params", "Filter parameters", false);
    }

    public static final StringMultiInputParam createFilterModsParam() {
        return new StringMultiInputParam("filt_params", "Filter parameters", false);
    }

    public static final BooleanParam createUseMetaGeneDbParam(boolean bl, boolean bl2) {
        return new BooleanParam("use_thesarus", "Use the metagenedb", bl, bl2);
    }

    public static final BooleanParam createUseGenomeThesarusParam(boolean bl, boolean bl2) {
        return new BooleanParam("use_thesarus", "Enhance annotations by using the GenomeThesarus", bl, bl2);
    }

    public static final BooleanParam createUseGenomeThesarusParam(boolean bl) {
        return ParamFactory.createUseGenomeThesarusParam(false, bl);
    }

    public static final BooleanParam createShowEtiologyParam(boolean bl) {
        return ParamFactory.createShowEtiologyParam(false, bl);
    }

    public static final BooleanParam createShowEtiologyParam(boolean bl, boolean bl2) {
        return new BooleanParam("show_etiology", "Output verbose mapping details", "Show the etiology for the features", bl, bl2);
    }

    public static final GeneSetMatrixMultiChooserParam createGeneSetMatrixDbParam(boolean bl) {
        return new GeneSetMatrixMultiChooserParam("gm_db", "GeneSetMatrix db", "GeneSetMatrix db", bl);
    }

    public static final GeneSetMatrixMultiChooserParam createGeneSetMatrixClusterParam(boolean bl) {
        return new GeneSetMatrixMultiChooserParam("gm_cluster", "gm cluster", "GeneSetMatrix Clusters", bl);
    }

    public static final StringMultiInputParam createGeneSetNamesParam(boolean bl) {
        return new StringMultiInputParam("gset_names", "Names of GeneSets, one per row", bl);
    }

    public static final IntegerParam createStartAtRankParam(int n, boolean bl) {
        return new IntegerParam("start_rank", "Start the analysis at this rank in the sorted marker list(inclusive (first 0))", n, bl);
    }

    public static final IntegerParam createStopAtRankParam(int n, boolean bl) {
        return new IntegerParam("stop_rank", "Stop the analysis at this rank in the sorted marker list(inclusive, (last n))", n, bl);
    }

    public static final IntegerParam createWindowSizeParam(int n, boolean bl) {
        return new IntegerParam("win", "window size", n, bl);
    }

    public static final IntegerParam createStepSizeParam(int n, boolean bl) {
        return new IntegerParam("step", "step size - how much to move between windows", n, bl);
    }

    public static final BooleanParam createNormForSizeParam(boolean bl, boolean bl2) {
        return new BooleanParam("norm", "Normalize scores/reports for geneset size (area normalization)", bl, bl2);
    }

    public static final BooleanParam createBalanceParam(boolean bl, boolean bl2) {
        return new BooleanParam("balance", "do balanced template randomizations", bl, bl2);
    }

    public static final BooleanParam createReversePhenotypeParam(boolean bl, boolean bl2) {
        return new BooleanParam("reverse_pheno", "also reverse the phenotype for the analysis", bl, bl2);
    }

    public static final FloatsChooserParam createSigParam(float[] fArray, boolean bl) {
        Float[] floatArray = new Float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return new FloatsChooserParam("sig", "Significance levels", floatArray, floatArray, bl);
    }

    public static final FloatsChooserParam createSigParam(boolean bl) {
        Float[] floatArray = new Float[PermutationTestImpl.DEFAULT_SIG_LEVELS.length];
        for (int i2 = 0; i2 < PermutationTestImpl.DEFAULT_SIG_LEVELS.length; ++i2) {
            floatArray[i2] = new Float(PermutationTestImpl.DEFAULT_SIG_LEVELS[i2]);
        }
        return new FloatsChooserParam("sig", "Significance levels", floatArray, floatArray, bl);
    }

    public static final BooleanParam createDeepParam(String string, boolean bl, boolean bl2) {
        return new BooleanParam("deep", string, bl, bl2);
    }

    public static final BooleanParam createDeepParam(boolean bl, boolean bl2) {
        return ParamFactory.createDeepParam("Generate verbose output for the tool(warning: might be memory intensive)", bl2, bl);
    }

    public static final BooleanParam createDumpParam(String string, boolean bl, boolean bl2) {
        return new BooleanParam("dump", string, bl, bl2);
    }

    public static final BooleanParam createDumpParam(boolean bl, boolean bl2) {
        return ParamFactory.createDumpParam("Generate verbose output for the tool(warning: might be memory intensive)", bl2, bl);
    }

    public static final BooleanParam createTransposeDatasetParam(boolean bl, boolean bl2) {
        return new BooleanParam("transpose", "transpose the dataset (make row cols and cols rows)", bl, bl2);
    }

    public static final BooleanParam createHelpParam(boolean bl) {
        return new BooleanParam("help", "Help on required and optional Tool flags", bl);
    }

    public static final IntegerParam createNumRndGeneSetsParam(boolean bl) {
        return new IntegerParam("num_rnd_genesets", "num_rnd_genesets", "The number of random genesets", new int[]{0, 1, 10, 100, 1000}, bl);
    }

    public static final IntegerParam createNumRndTemplatesParam(boolean bl) {
        return new IntegerParam("num_rnd_templates", "num_rnd_templates", "The number of random templates", new int[]{0, 1, 10, 50, 100, 1000}, bl);
    }

    public static final IntegerParam createNumPermParam(boolean bl) {
        return ParamFactory.createNumPermParam(1000, bl);
    }

    public static final IntegerParam createNumPermParam(int n, boolean bl) {
        return new IntegerParam("nperm", "Number of permutations", "The number of permutations", n, new int[]{0, 1, 10, 100, 1000}, bl);
    }

    public static final IntegerParam createNumSplitsParam(boolean bl) {
        return new IntegerParam("nsplits", "Number of splits", "The number random splits of the dataset", new int[]{0, 1, 10, 100, 1000}, bl);
    }

    public static final IntegerParam createNumLocParam(boolean bl) {
        return new IntegerParam("nloc", "The number of leave one out cross validations to do", -1, bl);
    }

    public static final BooleanParam createShuffleGeneSetParam(boolean bl, boolean bl2) {
        return new BooleanParam("group", "Shuffle the gene group", bl, bl2);
    }

    public static final BooleanParam createBiasedVarParam(boolean bl) {
        return new BooleanParam("biased", "Biased variance for class metrics", "Use biased var(N) instead of UNbiased(N-1)", XPreferencesFactory.kBiasedVar.getBoolean(), bl);
    }

    public static final BooleanParam createMedianParam(boolean bl) {
        return new BooleanParam("median", "Median for class  metrics", "Use the median of each class instead of the mean for the class seperation metrics", XPreferencesFactory.kMedian.getBoolean(), bl);
    }

    public static final BooleanParam createMedianParam(boolean bl, String string) {
        return new BooleanParam("median", "Median for class metrics", string, XPreferencesFactory.kMedian.getBoolean(), bl);
    }

    public static final BooleanParam createTwoSidedParam(boolean bl) {
        return new BooleanParam("two_sided", "Take markers form the top and bottom", bl);
    }

    public static final BooleanParam createTwoSidedParam(boolean bl, boolean bl2) {
        return new BooleanParam("two_sided", "Take markers form the top and bottom", bl, bl2);
    }

    public static final BooleanParam createFixLowVarParam(boolean bl) {
        return new BooleanParam("fixlowvar", "Fix for low variance", XPreferencesFactory.kFixLowVar.getBoolean(), bl);
    }

    public static final IntegerParam createNumMarkersParam(int n, boolean bl) {
        return new IntegerParam("num", "Number of markers", "Number of markers", n, bl);
    }

    public static final IntegerParam createNumMarkersParam(String string, int n, boolean bl) {
        return new IntegerParam(string, "Number of markers", "Number of markers", n, bl);
    }

    public static final IntegersChooserParam createNumFeaturesParam(boolean bl) {
        return new IntegersChooserParam("nfeats", "Number of features", "Number of features", bl);
    }

    public static final BooleanParam createOvaParam(boolean bl, boolean bl2) {
        return new BooleanParam("ova", "Split up specified Template into ONE_versus_ALL pairs and use in the analysis", bl, bl2);
    }

    public static final BooleanParam createAllPairsParam(boolean bl, boolean bl2) {
        return new BooleanParam("allpairs", "Split up specified Template into APP_PAIRS and use in the analysis", bl, bl2);
    }

    public static final IntegerParam createGeneSetMinSizeParam(int n, boolean bl) {
        return new IntegerParam("set_min", "Min size: exclude smaller sets", "Gene sets smaller than this number are EXLCUDED from the analysis", n, bl);
    }

    public static final IntegerParam createGeneSetMinSizeParam(boolean bl) {
        return ParamFactory.createGeneSetMinSizeParam(10, bl);
    }

    public static final IntegerParam createGeneSetMaxSizeParam(int n, boolean bl) {
        return new IntegerParam("set_max", "Max size: exclude larger sets", "Gene sets larger than this number are EXLCUDED from the analysis", n, bl);
    }

    public static final IntegerParam createGeneSetMaxSizeParam(boolean bl) {
        return ParamFactory.createGeneSetMaxSizeParam(1000, bl);
    }

    public static final BooleanParam createAdvancedParam(boolean bl) {
        return new BooleanParam("adv", "Advanced mode", bl);
    }

    public static final BooleanParam createFixedRndGeneSetSizeParam(boolean bl) {
        return new BooleanParam("fix_gset_size", "use the fixed gset size", bl);
    }

    public static final IntegersChooserParam createIntegers(String string, String string2, int[] nArray, boolean bl) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return new IntegersChooserParam(string, string2, integerArray, bl);
    }

    public static final IntegerParam createCutoffNumPermParam(boolean bl) {
        return new IntegerParam("nperm", "number of perms", "The number of permutations", new int[]{1, 10, 100, 1000}, bl);
    }

    public static final FloatParam createMinFoldParam(boolean bl) {
        return ParamFactory.createMinFoldParam(3.0f, bl);
    }

    public static final FloatParam createMinFoldParam(float f2, boolean bl) {
        return new FloatParam("min_fold", "Only include those rows with max/min >= specified value", f2, bl);
    }

    public static final FloatParam createMinDeltaParam(boolean bl) {
        return ParamFactory.createMinDeltaParam(50.0f, bl);
    }

    public static final FloatParam createMinDeltaParam(float f2, boolean bl) {
        return new FloatParam("min_delta", "Only include those rows with max - min >= specified value", f2, bl);
    }

    public static final IntegerParam createMinNumInstancesParam(boolean bl) {
        return new IntegerParam("min_inst", "Only include drugs with mor einsances than these", 3, bl);
    }

    public static final FloatParam createMinDiffParam(boolean bl) {
        return new FloatParam("min_diff", "Only include those rows with max-min >= specified value", 3.0f, bl);
    }

    public static final FloatParam createMinThresholdParam(float f2, boolean bl) {
        return new FloatParam("min_gex", "Change all values < specified to the specified value", f2, bl);
    }

    public static final FloatParam createMinThresholdParam(boolean bl) {
        return ParamFactory.createMinThresholdParam(20.0f, bl);
    }

    public static final FloatParam createMaxThresholdParam(float f2, boolean bl) {
        return new FloatParam("max_gex", "Change all values > specified to the specified value", f2, bl);
    }

    public static final FloatParam createMaxThresholdParam(boolean bl) {
        return ParamFactory.createMaxThresholdParam(16000.0f, bl);
    }

    public static final BooleanParam createNormalizeRowsParam(boolean bl, boolean bl2) {
        return new BooleanParam("normalize_rows", "Normalioze rows to mean 0 and stddev 1", bl, bl2);
    }

    public static final FloatsChooserParam createPercentsParam(boolean bl) {
        return new FloatsChooserParam("percents", "sig levels for the disc mode", new Float(0.05f), bl);
    }

    public static final FloatParam createNominalPValueCutoffParam(boolean bl) {
        return new FloatParam("np", "nominal p-value cutoff", pvf, bl);
    }

    public static final FloatParam createDiscoveryValueCutoffParam(boolean bl) {
        return new FloatParam("dp", "discovery pvalue cutoff", pvf, bl);
    }

    public static final FloatParam createValidationPValueCutoffParam(boolean bl) {
        return new FloatParam("vp", "validation pvalue cutoff", pvf, bl);
    }

    public static final FloatParam createPValueCutoffParam(boolean bl) {
        return new FloatParam("pvalue_cutoff", "pvalue cutoff", pvf, bl);
    }

    public static final ChipReqdParam createChipSourceParam() {
        return new ChipReqdParam("chip_source", "chip_source", "The chip that orthology/homology mappings are taken from");
    }

    public static final ChipReqdParam createChipTargetParam() {
        return new ChipReqdParam("chip_target", "chip_target", "The chip that orthology/homology mappings are converted to");
    }

    public static final ChipChooserMultiParam createChipsSourceParam(boolean bl) {
        return new ChipChooserMultiParam("chip_source", "Source chip(s)", "The starting chip - from which the orthology/homology mappings are taken", bl);
    }

    public static final ChipChooserMultiParam createChipsTargetParam(boolean bl) {
        return new ChipChooserMultiParam("chip_target", "Target chip(s)", "The destination chip - to which orthology/homology mappings are converted to", bl);
    }

    public static final IntegersChooserParam createMarkerSpansParam(int[] nArray, int[] nArray2, boolean bl) {
        Integer[] integerArray = new Integer[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            integerArray[i2] = new Integer(nArray2[i2]);
        }
        Integer[] integerArray2 = new Integer[nArray2.length];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            integerArray2[i3] = new Integer(nArray[i3]);
        }
        return new IntegersChooserParam("top", "lengths of markers lists", integerArray2, integerArray, bl);
    }

    public static final Map getMetricParams(BooleanParam booleanParam) {
        Map map = DatasetMetrics.getDefaultMetricParams();
        map.put("USE_MEDIAN", booleanParam.getValue());
        return Collections.unmodifiableMap(map);
    }

    public static final Map getMetricParams(boolean bl) {
        Map map = DatasetMetrics.getDefaultMetricParams();
        map.put("USE_MEDIAN", bl);
        return Collections.unmodifiableMap(map);
    }

    public static final void checkAndBarfIfZeroSets(GeneSet[] geneSetArray) {
        boolean bl = false;
        if (geneSetArray.length == 0) {
            bl = true;
        } else {
            boolean bl2 = false;
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                if (geneSetArray[i2].getNumMembers() <= 0) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                bl = true;
            }
        }
        if (bl) {
            throw new BadParamException("After pruning, none of the gene sets passed size thresholds.", 1001);
        }
    }

    public static final void checkIfCollapsedIsEmpty(CollapsedDetails collapsedDetails) {
        if (!collapsedDetails.wasCollapsed) {
            return;
        }
        if (collapsedDetails.getNumRow_orig() == 0) {
            return;
        }
        if (collapsedDetails.getNumRow_collapsed() != 0) {
            return;
        }
        throw new BadParamException("The collapsed dataset was empty when used with chip:" + collapsedDetails.getChipName(), 1005);
    }
}

