/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import xtools.api.param.Param;

public class MissingReqdParamException
extends RuntimeException {
    private Param[] missingParams;
    private String msgInHtml;

    public MissingReqdParamException(Param[] paramArray) {
        super("\n\nSome required parameters (" + paramArray.length + ") were not specified. The parameters are:\n" + MissingReqdParamException._str(paramArray));
        this.missingParams = paramArray;
    }

    public MissingReqdParamException(String string) {
        super(string);
        this.msgInHtml = string;
    }

    private static String _str(Param[] paramArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            stringBuffer.append(">").append(paramArray[i2].getName()).append("<").append('\t').append(paramArray[i2].getDesc()).append('\n');
        }
        return stringBuffer.toString();
    }

    public final String getMessageLongInHtml() {
        if (this.msgInHtml != null) {
            return this.msgInHtml;
        }
        StringBuffer stringBuffer = new StringBuffer("<html>\n<body>\n<p>Required parameter(s) were not specified:</p>\n<ul>\n");
        for (int i2 = 0; i2 < this.missingParams.length; ++i2) {
            stringBuffer.append("<li> ").append(this.missingParams[i2].getNameEnglish()).append("</li>\n");
        }
        stringBuffer.append("</ul>\n").append("<br><br>Please set these in the form and try again").append("</body>\n").append("</html>");
        return stringBuffer.toString();
    }
}

