/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.swing.choosers.GFileFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class FileParam
extends AbstractParam {
    private GFileFieldPlusChooser fChooser;

    public FileParam(String string, String string2, String string3, File file, boolean bl) {
        this(string, string2, string3, new File[]{file}, bl);
    }

    public FileParam(String string, String string2, String string3, File[] fileArray, boolean bl) {
        super(string, string2, File.class, string3, (Object[])fileArray, bl);
    }

    public FileParam(boolean bl) {
        this("file", "Path to file", "Path to data file", new File[0], bl);
    }

    public FileParam(String string, boolean bl) {
        this(string, "Path to file", "Path to data file", new File[0], bl);
    }

    public FileParam(String string, String string2, boolean bl) {
        this(string, string2, "Path to data file", new File[0], bl);
    }

    public FileParam(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, new File[0], bl);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            super.setValue(object);
        } else if (object instanceof File) {
            super.setValue(object);
        } else if (object instanceof String) {
            this.setValue(object.toString());
        } else if (object instanceof URL) {
            this.setValue(object.toString());
        } else {
            throw new IllegalArgumentException("Invalid type, only File and String accepted. Specified: " + object + " class: " + object.getClass());
        }
    }

    public final String getFileName_wo_ext() {
        return NamingConventions.removeExtension(this.getFile().getName());
    }

    public final String getContent() {
        return ParseUtils.slurp(this.getFile(), true);
    }

    public final String[] getStrings() {
        return ParseUtils.slurpIntoStrings(this.getFile(), true);
    }

    public final String[] getStringsUnique() {
        String[] stringArray = this.getStrings();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (arrayList.contains(stringArray[i2])) continue;
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final Set getStrings_set() {
        String[] stringArray = this.getStrings();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return hashSet;
    }

    public final Map getMap_2_field(boolean bl) {
        String[] stringArray = this.getStringsUnique();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = ParseUtils.string2strings(stringArray[i2], "\t", false);
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Bad format: " + stringArray[i2]);
            }
            Object v = hashMap.get(stringArray2[0]);
            if (v != null) {
                String string = v.toString();
                if (string.equalsIgnoreCase(stringArray2[1])) continue;
                arrayList.add(stringArray[i2]);
                continue;
            }
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        if (!arrayList.isEmpty()) {
            klog.warn("Some NMs map to > 1 gene symbol: " + arrayList.size() + "\n");
            Printf.outl(arrayList);
            if (bl) {
                throw new IllegalArgumentException("Bad format");
            }
        }
        return hashMap;
    }

    public void setValue(File file) {
        super.setValue(file);
    }

    public void setValue(String string) {
        super.setValue(string);
    }

    public final void setValue_url(String string) {
        super.setValue(string);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    public final BufferedReader getReader() {
        return new BufferedReader(new FileReader(this.getFile()));
    }

    public final File getFile() {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (object instanceof File) {
            return (File)object;
        }
        return new File(object.toString());
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof URL) {
            return object.toString();
        }
        if (object instanceof File) {
            File file = (File)this.getValue();
            if (bl) {
                return file.getAbsolutePath();
            }
            return file.getName();
        }
        if (NamingConventions.isURL(object.toString())) {
            return object.toString();
        }
        return object.toString();
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GFileFieldPlusChooser();
            if (this.getValue() != null) {
                this.fChooser.setValue(this.getValue());
            } else {
                this.fChooser.setValue(this.getDefault());
            }
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }
}

