/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.reports.api.Report;
import java.io.File;
import java.net.URI;
import java.util.Properties;

public class DefaultReport
extends AbstractObject
implements Report {
    private Class fProducerClass;
    private long fTimestamp;
    private File[] fFiles;
    private Properties fParams;
    private File fReportDir;

    public DefaultReport(String string, long l2, Class clazz, File[] fileArray, Properties properties, boolean bl) {
        super(string);
        DefaultReport._runParamChecks(clazz, fileArray, properties);
        if (bl) {
            this.fTimestamp = l2;
            this.fProducerClass = clazz;
            this.fFiles = fileArray;
            this.fParams = properties;
        } else {
            this.fTimestamp = l2;
            this.fProducerClass = Class.forName(clazz.getName());
            this.fParams = (Properties)properties.clone();
            this.fFiles = new File[fileArray.length];
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                this.fFiles[i2] = new File(fileArray[i2].getPath());
            }
        }
        String string2 = this.fParams.getProperty("out");
        File file = new File(string2);
        this.fReportDir = new File(file, NamingConventions.removeExtension(string));
    }

    private static void _runParamChecks(Class clazz, File[] fileArray, Properties properties) {
        if (fileArray == null) {
            throw new IllegalArgumentException("Param files cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Param params cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Param cl cannot be null");
        }
    }

    @Override
    public final Class getProducer() {
        return this.fProducerClass;
    }

    @Override
    public final String getProducerName() {
        return super.getName();
    }

    @Override
    public final long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public final File[] getFilesProduced() {
        File[] fileArray = new File[this.fFiles.length];
        for (int i2 = 0; i2 < this.fFiles.length; ++i2) {
            fileArray[i2] = this.fFiles[i2];
        }
        return fileArray;
    }

    @Override
    public final int getNumPagesMade() {
        return this.fFiles.length;
    }

    @Override
    public final Properties getParametersUsed() {
        return (Properties)this.fParams.clone();
    }

    @Override
    public final void setErroredOut() {
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.fFiles.length).append(" files");
        return stringBuffer.toString();
    }

    @Override
    public final URI getReportIndex() {
        return this.fFiles[0].toURI();
    }

    @Override
    public final File getReportDir() {
        return this.fReportDir;
    }
}

