/*
 * Decompiled with CFR 0.152.
 */
package xtest.api;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartUtils;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.HClustDatasetStanford;
import edu.mit.broad.genome.objects.HClustTree;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.swing.ImageViewerFrame;
import edu.mit.broad.genome.swing.SCLayout;
import edu.mit.broad.genome.viewers.XChartViewer;
import edu.mit.broad.xbench.core.WindowComponent;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import xapps.api.BareBonesApplication;
import xapps.api.MostMain;
import xtest.api.ConfImpl;
import xtest.api.TestConf;

public class Test {
    protected final Logger log = XLogger.getLogger(Test.class);
    private final TestConf fConf;
    private BareBonesApplication bare;

    public Test() {
        this(ConfImpl.DEFAULT);
    }

    public Test(TestConf testConf) {
        this.fConf = testConf;
    }

    public final void registerApp() {
        if (this.bare == null) {
            this.bare = new BareBonesApplication();
            Application.registerHandler(this.bare);
        }
    }

    public final Dataset getDataset() {
        return ParserFactory.readDataset(this.fConf.getFile("RES_URL"), true);
    }

    public final ScoredDataset getDatasetScored() {
        Dataset dataset = this.getDataset();
        Template template = this.getTemplate2Class();
        LabelledVectorProcessors$None labelledVectorProcessors$None = new LabelledVectorProcessors$None();
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        return datasetMetrics.scoreDataset((Metric)new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, new HashMap(), (LabelledVectorProcessor)labelledVectorProcessors$None, dataset, template);
    }

    public final Dataset getDatasetSmall() {
        return ParserFactory.readDataset(this.fConf.getFile("SMALL_RES_URL"), true);
    }

    public final Dataset getDatasetGct() {
        return ParserFactory.readDatasetGct(this.fConf.getFile("GCT_URL"), true);
    }

    public final HClustDatasetStanford getHClustDatasetSmall() {
        return ParserFactory.readHClustDataset(this.fConf.getFile("SMALL_CDT_URL"), true);
    }

    public final HClustTree getHClustTreeGenesSmall() {
        return ParserFactory.readHClustTree(this.fConf.getFile("SMALL_GTR_URL"), true);
    }

    public final HClustTree getHClustTreeSamplesSmall() {
        return ParserFactory.readHClustTree(this.fConf.getFile("SMALL_ATR_URL"), true);
    }

    public final HClustDatasetStanford getHClustDataset() {
        return ParserFactory.readHClustDataset(this.fConf.getFile("CDT_URL"), true);
    }

    public final HClustTree getHClustTreeGenes() {
        return ParserFactory.readHClustTree(this.fConf.getFile("GTR_URL"), true);
    }

    public final HClustTree getHClustTreeSamples() {
        return ParserFactory.readHClustTree(this.fConf.getFile("ATR_URL"), true);
    }

    public final Dataframe getDataframe() {
        return ParserFactory.readDataframe(this.fConf.getFile("DATAFRAME_URL"), true);
    }

    public final StringDataframe getStringDataframe() {
        return ParserFactory.readStringDataframe(this.fConf.getFile("STRINGDATAFRAME_URL"), true);
    }

    public final FeatureAnnot getDatasetAnnotation() {
        Dataset dataset = this.getDataset();
        return dataset.getAnnot().getFeatureAnnot();
    }

    public final Template getTemplate() {
        return ParserFactory.readTemplate(this.fConf.getFile("CLS_URL"));
    }

    public final Template getTemplate2Class() {
        return ParserFactory.readTemplate(this.fConf.getFile("CLS2_URL"));
    }

    public final Template getTemplateNumeric() {
        return ParserFactory.readTemplate(this.fConf.getFile("CLS_NUMERIC_URL"));
    }

    public final GeneSet getGeneSet() {
        return ParserFactory.readGeneSet(this.fConf.getFile("GRP_URL"), true);
    }

    public final GeneSetMatrix getGeneSetMatrix() {
        return ParserFactory.readGeneSetMatrix(this.fConf.getFile("GMX_URL"), true);
    }

    public final GeneSetMatrix getGeneSetMatrixT() {
        return (GeneSetMatrix)ParserFactory.read(this.fConf.getFile("GMT_URL"));
    }

    public final Image getJpegImage() {
        return null;
    }

    public final void displayInApp(WindowComponent windowComponent) {
        this.bare.getWindowManager().openWindow(windowComponent);
    }

    public final void display(Component component) {
        Dimension dimension = component.getPreferredSize();
        if (dimension.height < 200) {
            this.display(500, 500, component);
        } else {
            this.display(dimension.width, dimension.height + 30, component);
        }
    }

    public final void display(Component component, Component component2) {
        this.display(new Component[]{component, component2});
    }

    public final void display(Component component, Component component2, Component component3) {
        this.display(new Component[]{component, component2, component3});
    }

    public final void display(Component[] componentArray) {
        JPanel jPanel = new JPanel(new SCLayout(componentArray.length));
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            jPanel.add(componentArray[i2]);
        }
        this.display(jPanel);
    }

    public final void display(int n, int n2, Component component) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add(component, "Center");
        jFrame.setSize(n, n2);
        jFrame.setTitle("Test Display");
        jFrame.setVisible(true);
    }

    public final void display(JFrame jFrame) {
        jFrame.setSize(500, 500);
        jFrame.setVisible(true);
    }

    public final void display(BufferedImage bufferedImage) {
        this.display(new ImageViewerFrame(bufferedImage, false, "foo"));
    }

    public final void display(JFreeChart jFreeChart) {
        XChartUtils.display(jFreeChart);
    }

    public final void display(XChart xChart) {
        XChartUtils.display(xChart);
    }

    public final void display(XComboChart xComboChart) {
        XChartUtils.display(xComboChart.getCombinedChart());
    }

    public final void display(XChart[] xChartArray) {
        XChartViewer xChartViewer = new XChartViewer("charts _" + xChartArray.length, xChartArray);
        this.display(xChartViewer.getWindowUI());
    }

    public final void display(String string, JFreeChart jFreeChart) {
        ChartFrame chartFrame = new ChartFrame(string, jFreeChart);
        chartFrame.pack();
        chartFrame.setVisible(true);
    }

    public final void display(JTree jTree) {
        this.displayInScrollPane(jTree);
    }

    public final void display(JTable jTable) {
        this.displayInScrollPane(jTable);
    }

    public final void display(Action action) {
        JButton jButton = new JButton(action);
        this.display(jButton);
    }

    public final void displayHtml(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        this.displayInScrollPane(jEditorPane);
        System.out.println(string);
    }

    public final void displayInScrollPane(Component component) {
        this.display(500, 500, (Component)new JScrollPane(component));
    }

    public final void save(Page page) {
        File file = File.createTempFile(page.getName(), "." + page.getExt());
        this.log.info("Writting Page to: " + file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        page.write(fileOutputStream, file.getParentFile());
        fileOutputStream.close();
    }

    static {
        new MostMain().setLnF();
    }
}

