/*
 * Decompiled with CFR 0.152.
 */
package xtest.api;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import xtest.api.TestConf;
import xtest.api.TestException;

public class ConfImpl
implements TestConf {
    public static TestConf DEFAULT = null;
    public static final String RESOURCES_JAR_PATH = "edu/mit/broad/genome/resources/";
    public static final String DEFAULT_TEST_PROPS_NAME = "default_test.prp";
    public static final String DEFAULT_TEST_PROPS_JAR_PATH = "edu/mit/broad/genome/resources/default_test.prp";
    private static final String BASE_URL = "BASE_URL";
    private final String fLoc;
    private URL fConfUrl;
    private final Properties fProp;
    protected static final Logger log;

    public ConfImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter loc cannot be null");
        }
        this.fLoc = string;
        this.fProp = new Properties();
        try {
            this.fConfUrl = JarResources.toURLFromPkgPath(this.fLoc);
            if (this.fConfUrl == null) {
                System.out.println("Could not get url for location: " + this.fLoc);
            }
            InputStream inputStream = this.fConfUrl.openStream();
            this.fProp.load(inputStream);
        }
        catch (Throwable throwable) {
            System.out.println("FATAL: Could not read in test properties");
            throwable.printStackTrace();
        }
    }

    @Override
    public final String getProperty(String string) {
        if (this.fProp.getProperty(string) == null) {
            throw new RuntimeException("No such key specified: " + string);
        }
        return this.fProp.getProperty(string);
    }

    @Override
    public final URL getConfUrl() {
        return this.fConfUrl;
    }

    @Override
    public final URL getDataRoot() {
        String string = this.getProperty(BASE_URL);
        if (string == null) {
            throw new TestException("No value for the key BASE_URL in the test properties file: " + this.fLoc);
        }
        URL uRL = JarResources.toURLFromPkgPath(string);
        if (uRL == null) {
            throw new TestException("Could not load system resource: " + string);
        }
        return uRL;
    }

    @Override
    public final URL getUrl(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            log.info("Could not find resource: " + string);
        }
        URL uRL = new URL(this.getDataRoot() + "/" + string2);
        return uRL;
    }

    @Override
    public final File getFile(String string) {
        try {
            URL uRL = this.getUrl(string);
            if (uRL == null) {
                throw new IOException("Could not find resource for: " + string);
            }
            File file = new File(uRL.getFile());
            if (!file.exists()) {
                throw new IOException("File does not exist: " + file.getAbsolutePath());
            }
            return file;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
    }

    public final String toString() {
        return this.getClass().getName() + " with loc " + this.fLoc;
    }

    static {
        try {
            DEFAULT = new ConfImpl(DEFAULT_TEST_PROPS_JAR_PATH);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        log = XLogger.getLogger(ConfImpl.class);
    }
}

