/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.xbench.core.api.DescriptedFile;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class VdbManagerForGsea
implements VdbManager {
    private String fCacheDate;
    private static final Logger klog = XLogger.getLogger(VdbManagerForGsea.class);

    public VdbManagerForGsea(String string) {
        this.fCacheDate = string;
    }

    @Override
    public final File getRuntimeHomeDir() {
        return XPreferencesFactory.kAppRuntimeHomeDir;
    }

    @Override
    public final DescriptedFile[] getDescriptedFiles() {
        return new DescriptedFile[]{new DescriptedFile(this.getDefaultOutputDir(), "OUTPUT"), new DescriptedFile(this.getRuntimeHomeDir(), "HOME"), new DescriptedFile(this.getExamplesDir(), "EXAMPLES"), new DescriptedFile(this.getTmpDir(), "TMP")};
    }

    @Override
    public final File getTmpDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "tmp"));
    }

    @Override
    public final File getExamplesDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "xexamples"));
    }

    @Override
    public final File getTestDataDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "test"));
    }

    @Override
    public final File getReportsCacheDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "reports_cache_" + this.fCacheDate));
    }

    @Override
    public final File getDatabasesDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "databases"));
    }

    @Override
    public final File getDefaultOutputDir() {
        File file = VdbManagerForGsea._mkdir(XPreferencesFactory.kDefaultReportsOutputDir.getDir(false));
        String string = NamingConventions.createNiceEnglishDate_for_dirs();
        return VdbManagerForGsea._mkdir(new File(file, string));
    }

    private static File _mkdir(File file) {
        if (!file.exists()) {
            boolean bl = file.mkdir();
            if (!bl) {
                if (Conf.isDebugMode()) {
                    TraceUtils.showTrace();
                }
                klog.fatal("Could not make dir: " + file);
            } else {
                klog.info("Made Vdb dir: " + file);
            }
        }
        return file;
    }

    @Override
    public final SampleAnnot getDefaultSampleAnnot() {
        return null;
    }

    @Override
    public final GenesOfInterest getDefaultGenesOfInterest() {
        return null;
    }
}

