/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.looks.HeaderStyle;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import edu.mit.broad.cytoscape.action.EnrichmentMapInputPanelAction;
import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.swing.ImageComponent;
import edu.mit.broad.genome.viewers.SystemConsoleViewerAction;
import edu.mit.broad.xbench.actions.ShowAppRuntimeHomeDirAction;
import edu.mit.broad.xbench.actions.ShowDefaultOutputDirAction;
import edu.mit.broad.xbench.core.StatusBar;
import edu.mit.broad.xbench.core.WindowComponent;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.Application$Handler;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.FileManagerImpl;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.core.api.ToolManagerImpl;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.core.api.WindowManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import xapps.api.AppDataLoaderAction;
import xapps.api.AppToolLauncherAction;
import xapps.api.PastAnalysisAction;
import xapps.api.frameworks.WorkspaceToolBar;
import xapps.api.frameworks.fiji.StatusBarJideImpl;
import xapps.browser.MSigDBViewerAction;
import xapps.gsea.FeedbackAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$1;
import xapps.gsea.GseaFijiTabsApplicationFrame$2;
import xapps.gsea.GseaFijiTabsApplicationFrame$3;
import xapps.gsea.GseaFijiTabsApplicationFrame$4;
import xapps.gsea.GseaFijiTabsApplicationFrame$AboutAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$ClearFileHistoryAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$CreditsAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$DownloadArrayAnnotationsAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$DownloadGseaExamplesAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$GseaPreferencesAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$MyExitAction;
import xapps.gsea.GseaFijiTabsApplicationFrame$MyWindowManagerImplJideTabbedPane;
import xapps.gsea.GseaHelpAction;
import xapps.gsea.GseaWebResources;
import xapps.gsea.LeadingEdgeReportAction;
import xapps.gsea.VdbManagerForGsea;
import xtools.chip2chip.Chip2Chip;
import xtools.gsea.Gsea;
import xtools.gsea.GseaPreranked;
import xtools.munge.CollapseDataset;

public class GseaFijiTabsApplicationFrame
extends DefaultDockableHolder
implements Application$Handler {
    private static final int INITIAL_LHS_WIDTH = 200;
    public static final String RPT_CACHE_BUILD_DATE = "April4_2006_build";
    private static String USER_VISIBLE_FRAME_TITLE;
    private static final Image ICON;
    public static final String PROFILE_NAME = "gsea";
    private StatusBar fStatusBar;
    private GseaFijiTabsApplicationFrame fFrame = this;
    private WindowAdapter fWindowListener;
    private SystemConsoleViewerAction fScva;
    private GseaFijiTabsApplicationFrame$MyWindowManagerImplJideTabbedPane fWindowManager;
    private AppToolLauncherAction fGseaTool_launcher;
    private AppDataLoaderAction fAppDataLoaderAction;
    private Gsea fGseaTool;
    public static final String TITLE = "Exit";
    private static final VdbManager fVdbmanager;
    private ToolManagerImpl fToolManager;
    private FileManager fFileManager;

    public GseaFijiTabsApplicationFrame() {
        super(USER_VISIBLE_FRAME_TITLE);
        this.fFrame.setVisible(false);
        this.fFrame.setDefaultCloseOperation(0);
        this.fFrame.setIconImage(ICON);
        this.fWindowListener = new GseaFijiTabsApplicationFrame$1(this);
        this.fFrame.addWindowListener(this.fWindowListener);
        this.fFrame.getDockingManager().setProfileKey(PROFILE_NAME);
        this.fFrame.getDockingManager().setOutlineMode(0);
        this.fFrame.getDockingManager().beginLoadLayoutData();
        this.fFrame.getDockingManager().setInitSplitPriority(1);
        this.fWindowManager = new GseaFijiTabsApplicationFrame$MyWindowManagerImplJideTabbedPane(this);
        this.fStatusBar = new StatusBarJideImpl();
        Application.registerHandler(this);
        this.fFrame.setJMenuBar(this.createMenuBar());
        this.jbInit();
    }

    public final void makeVisible(boolean bl) {
        this.fFrame.getDockingManager().loadLayoutData();
        this.fFrame.getDockingManager().getWorkspace().setAcceptDockableFrame(false);
        if (bl) {
            this.fFrame.toFront();
        }
    }

    public final void init_bg_while_splashing() {
        try {
            Application.getFileManager().getFileChooser();
            Application.getFileManager().getDirChooser("test");
        }
        catch (Throwable throwable) {
            System.out.println("Error background initing: " + throwable);
        }
        this.fAppDataLoaderAction.getWidget();
        this.fGseaTool_launcher.getWidget();
        System.out.println("Done initing things while splashing");
    }

    private void jbInit() {
        this.fFrame.getContentPane().setLayout(new BorderLayout());
        JideSplitPane jideSplitPane = new JideSplitPane();
        jideSplitPane.add(this.createToolBar());
        jideSplitPane.setShowGripper(true);
        jideSplitPane.setContinuousLayout(false);
        jideSplitPane.add(this.fWindowManager.getTabbedPane());
        this.fWindowManager.openWindow(this.createStartupPanel());
        try {
            this.fWindowManager.getTabbedPane().setTabClosableAt(0, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fFrame.getContentPane().add(jideSplitPane);
        this.fFrame.getContentPane().add((Component)this.fStatusBar.getAsComponent(), "Last");
    }

    private JComponent createToolBar() {
        WorkspaceToolBar workspaceToolBar = new WorkspaceToolBar(1);
        workspaceToolBar.setFloatable(false);
        workspaceToolBar.setBorder(BorderFactory.createTitledBorder("Steps in GSEA analysis"));
        int n = 75;
        int n2 = 60;
        Font font = new Font("Arial", 1, 12);
        int n3 = 15;
        this.fAppDataLoaderAction = new AppDataLoaderAction();
        this.fGseaTool = new Gsea();
        this.fGseaTool_launcher = new AppToolLauncherAction(this.fGseaTool, this.fGseaTool.getParamSet(), "Run Gsea", JarResources.getIcon("Gsea_app16_v2.png"));
        workspaceToolBar.add(JarResources.toURL("LocalFileExplorerWidget32.gif"), "Load data          ", (Action)this.fAppDataLoaderAction, n, n2, font, true);
        workspaceToolBar.add(Box.createVerticalStrut(n3));
        workspaceToolBar.add(JarResources.toURL("GseaApp24.gif"), "Run GSEA           ", (Action)this.fGseaTool_launcher, n, n2, font, true);
        workspaceToolBar.add(Box.createVerticalStrut(n3));
        workspaceToolBar.add(JarResources.toURL("Lev32.gif"), "Leading edge analysis", (Action)new LeadingEdgeReportAction(), n, n2, font, true);
        workspaceToolBar.add(Box.createVerticalStrut(n3));
        workspaceToolBar.add(JarResources.toURL("enrichmentmap_logo.gif"), "Enrichment Map Visualization", (Action)new EnrichmentMapInputPanelAction(), n, n2, font, true);
        workspaceToolBar.add(Box.createVerticalStrut(n3));
        WorkspaceToolBar workspaceToolBar2 = new WorkspaceToolBar(1);
        workspaceToolBar2.setBorder(BorderFactory.createTitledBorder("Gene set tools"));
        workspaceToolBar2.setFloatable(false);
        Chip2Chip chip2Chip = new Chip2Chip();
        workspaceToolBar2.add(JarResources.toURL("Chip2Chip24_b.gif"), "Chip2Chip mapping", (Action)new AppToolLauncherAction(chip2Chip, chip2Chip.getParamSet(), "Chip2Chip", JarResources.getIcon("Chip2Chip16.gif")), n, n2, font, true);
        workspaceToolBar2.add(Box.createVerticalStrut(n3));
        workspaceToolBar2.add(JarResources.toURL("msigdb.png"), "Browse MSigDB", (Action)new MSigDBViewerAction(), n, n2, font, true);
        workspaceToolBar2.add(Box.createVerticalStrut(n3));
        WorkspaceToolBar workspaceToolBar3 = new WorkspaceToolBar(1);
        workspaceToolBar3.setBorder(BorderFactory.createEtchedBorder());
        workspaceToolBar3.setFloatable(false);
        workspaceToolBar3.add(JarResources.toURL("past_analysis32.gif"), "Analysis history", (Action)new PastAnalysisAction(), n, n2, font, true);
        workspaceToolBar3.add(Box.createVerticalStrut(n3));
        workspaceToolBar3.add(Box.createVerticalStrut(50));
        WorkspaceToolBar workspaceToolBar4 = new WorkspaceToolBar(1);
        workspaceToolBar4.setFloatable(false);
        workspaceToolBar4.add(workspaceToolBar);
        workspaceToolBar4.add(workspaceToolBar2);
        workspaceToolBar4.add(workspaceToolBar3);
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        jideSplitPane.setShowGripper(true);
        jideSplitPane.add(workspaceToolBar4);
        jideSplitPane.add(this.createProcessForToolBar());
        return jideSplitPane;
    }

    private WindowComponent createStartupPanel() {
        JPanel jPanel = new JPanel(new JideBorderLayout());
        JScrollPane jScrollPane = new JScrollPane(new ImageComponent(JarResources.getImage("intro_screen.jpg"), false));
        return new GseaFijiTabsApplicationFrame$2(this, jScrollPane);
    }

    private JComponent createProcessForToolBar() {
        TaskManager taskManager = TaskManager.getInstance();
        JTable jTable = taskManager.createTable();
        taskManager.setOnClickShowResultsInBrowserOnly(true);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(200, 350));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html><body>Processes: click 'status' field for results</body></html>"), "North");
        jPanel.setBackground(Color.LIGHT_GRAY);
        jPanel.addMouseListener(new GseaFijiTabsApplicationFrame$3(this, jPanel));
        jTable.addMouseListener(new GseaFijiTabsApplicationFrame$4(this, jTable));
        jPanel.setBorder(BorderFactory.createTitledBorder("GSEA reports"));
        jPanel.add((Component)jScrollPane, "Center");
        JideButton jideButton = new JideButton("Show results folder");
        jideButton.setAction(new ShowDefaultOutputDirAction("Show results folder"));
        jideButton.setRolloverEnabled(true);
        jideButton.setBorderPainted(false);
        jideButton.setButtonStyle(3);
        jPanel.add((Component)jideButton, "South");
        return jPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        jMenuBar.add(this.createJMenu("File", new Object[]{new GseaFijiTabsApplicationFrame$MyExitAction(this)}));
        GseaFijiTabsApplicationFrame$GseaPreferencesAction gseaFijiTabsApplicationFrame$GseaPreferencesAction = new GseaFijiTabsApplicationFrame$GseaPreferencesAction(this);
        jMenuBar.add(this.createJMenu("Options", new Object[]{gseaFijiTabsApplicationFrame$GseaPreferencesAction, null, GseaFijiTabsApplicationFrame$GseaPreferencesAction.access$100(gseaFijiTabsApplicationFrame$GseaPreferencesAction), GseaFijiTabsApplicationFrame$GseaPreferencesAction.access$200(gseaFijiTabsApplicationFrame$GseaPreferencesAction), null, GseaFijiTabsApplicationFrame$GseaPreferencesAction.access$300(gseaFijiTabsApplicationFrame$GseaPreferencesAction), GseaFijiTabsApplicationFrame$GseaPreferencesAction.access$400(gseaFijiTabsApplicationFrame$GseaPreferencesAction), GseaFijiTabsApplicationFrame$GseaPreferencesAction.access$500(gseaFijiTabsApplicationFrame$GseaPreferencesAction), null, new GseaFijiTabsApplicationFrame$ClearFileHistoryAction(this)}));
        jMenuBar.add(this.createJMenu("Downloads", new Object[]{new GseaFijiTabsApplicationFrame$DownloadArrayAnnotationsAction(), new GseaFijiTabsApplicationFrame$DownloadGseaExamplesAction()}));
        GseaPreranked gseaPreranked = new GseaPreranked();
        CollapseDataset collapseDataset = new CollapseDataset();
        jMenuBar.add(this.createJMenu("Tools", new Object[]{new AppToolLauncherAction(gseaPreranked, gseaPreranked.getParamSet(), "Run Gsea on a Pre-Ranked gene list", JarResources.getIcon("Gsea_app16_v2.png")), new AppToolLauncherAction(collapseDataset, collapseDataset.getParamSet(), "Collapse Dataset from Probes to Symbols", JarResources.getIcon("ProjectSpecific16.png"))}));
        jMenuBar.add(this.createJMenu("Help", new Object[]{new GseaHelpAction("GSEA web site", "Open the GSEA website in a web browser", GseaWebResources.getGseaBaseURL()), new GseaHelpAction(), null, new ShowAppRuntimeHomeDirAction("Show GSEA home folder"), new ShowDefaultOutputDirAction("Show GSEA output folder (default location)"), null, new FeedbackAction(), null, new GseaFijiTabsApplicationFrame$CreditsAction(this), new GseaFijiTabsApplicationFrame$AboutAction(this), JarResources.getBuildInfo()}));
        return jMenuBar;
    }

    private JMenu createJMenu(String string, Object[] objectArray) {
        JMenu jMenu = new JMenu(string, true);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) {
                jMenu.addSeparator();
                continue;
            }
            if (objectArray[i2] instanceof JMenuItem) {
                jMenu.add((JMenuItem)objectArray[i2]);
                continue;
            }
            if (objectArray[i2] instanceof String) {
                jMenu.add(objectArray[i2].toString());
                continue;
            }
            jMenu.add(new JMenuItem((Action)objectArray[i2]));
        }
        return jMenu;
    }

    private void exitApplication(WindowEvent windowEvent) {
        boolean bl;
        boolean bl2 = XPreferencesFactory.kAskBeforeAppShutdown.getBoolean();
        if (bl2 && !(bl = this.getWindowManager().showConfirm("Exit the application?"))) {
            return;
        }
        this.fFrame.removeWindowListener(this.fWindowListener);
        this.fWindowListener = null;
        if (this.fFrame.getDockingManager() != null) {
            this.fFrame.getDockingManager().saveLayoutData();
        }
        this.fFrame.dispose();
        this.fFrame = null;
        if (!Conf.isDebugMode()) {
            Conf.exitSystem(false);
        }
    }

    private static JComponent createGseaAppInfoComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        ImageComponent imageComponent = new ImageComponent(JarResources.getImage("gsea_about2.png"), false);
        imageComponent.setPreferredSize(new Dimension(((JComponent)imageComponent).getPreferredSize().width, 400));
        JScrollPane jScrollPane = new JScrollPane(imageComponent);
        jScrollPane.setPreferredSize(new Dimension(((JComponent)imageComponent).getPreferredSize().width, 400));
        jPanel.add((Component)jScrollPane, "Center");
        StringBuffer stringBuffer = new StringBuffer("Gene Set Enrichment Analysis (GSEA)\n\n");
        stringBuffer.append("Debug mode (for development)  : ").append(Conf.isDebugMode()).append('\n');
        stringBuffer.append("\nMemory Available on Machine : ").append(Runtime.getRuntime().maxMemory() / 1000000L).append("Mb\n");
        stringBuffer.append("(At least 256Mb of memory is recommended. More the better!)\n");
        stringBuffer.append("Broad Institute of MIT and Harvard\n");
        stringBuffer.append("Support web site: ").append(GseaWebResources.getGseaBaseURL()).append('\n');
        stringBuffer.append("Support email: ").append(GseaWebResources.getGseaEmail()).append('\n');
        stringBuffer.append('\n');
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jTextArea.setEditable(false);
        jTextArea.setPreferredSize(new Dimension(((JComponent)imageComponent).getPreferredSize().width, 100));
        jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(((JComponent)imageComponent).getPreferredSize().width, 100));
        jPanel.add((Component)jScrollPane, "South");
        return jPanel;
    }

    private static JComponent createMethodologyInfoComponent() {
        StringBuffer stringBuffer = new StringBuffer("Gene Set Enrichment Analysis (GSEA)\n\n");
        stringBuffer.append("This software implements the methodology described in:\n\n");
        stringBuffer.append("Gene Set Enrichment Analysis: A Knowledge-Based Approach for Interpreting\nGenome-wide Expression Profiles\n");
        stringBuffer.append("PNAS 2005\n\n");
        stringBuffer.append("Aravind Subramanian, Pablo Tamayo et al.\n");
        stringBuffer.append("\n");
        stringBuffer.append("The Kolmogorov-Smirnov statistic for mining gene expression data is described in Lamb, J., Ramaswamy, S., Ford, H. L., Contreras, B., Martinez, R. V., Kittrell, F. S., Zahnow, C. A., Patterson, N., Golub, T. R., and Ewen, M. E. (2003). A mechanism of cyclin D1 action encoded in the patterns of gene expression in human cancer. Cell 114, 323-334.\n");
        stringBuffer.append("GSEA was first reported in: Mootha, V. K., Lindgren, C. M., Eriksson, K. F., Subramanian, A., Sihag, S., Lehar, J., Puigserver, P., Carlsson, E., Ridderstrale, M., Laurila, E., et al. (2003).  PGC-1alpha-responsive genes involved in oxidative phosphorylation are coordinately downregulated in human diabetes. Nat Genet 34, 267-273.\n");
        stringBuffer.append("GSEA v2 software is described in TBD\n");
        stringBuffer.append("The MSigDB database is described in TBD\n");
        stringBuffer.append("\nDepending on your work, there are various ways of citing the GSEA methodology and software.\n");
        stringBuffer.append("Please check our website for a full list of contributors to GSEA concepts and publications\n");
        stringBuffer.append("Broad Institute of MIT and Harvard\n\n");
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jTextArea.setEditable(false);
        return new JScrollPane(jTextArea);
    }

    private JComponent createLicenseComponent() {
        String string;
        try {
            string = ParseUtils.slurp(JarResources.toURL("GseaLicense.txt"), false);
        }
        catch (Throwable throwable) {
            string = "Could not read GSEA license .. please consult the GSEA website";
        }
        JTextArea jTextArea = new JTextArea(100, 85);
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        return new JScrollPane(jTextArea);
    }

    private JComponent createSoftwareCreditsComponent() {
        StringBuffer stringBuffer = new StringBuffer("Software credits\n\n");
        stringBuffer.append("GSEA desktop software design & implementation:\n\n");
        stringBuffer.append("Aravind Subramanian (as part of PhD thesis)\n");
        stringBuffer.append("Project Advisors: Jill Mesirov, Pablo Tamayo, Todd Golub & Eric Lander\n");
        stringBuffer.append("\n");
        stringBuffer.append("Important software contributions were made by:\n");
        stringBuffer.append("Joshua Gould (heat map, leading edge & several other utilities)\n");
        stringBuffer.append("\n");
        stringBuffer.append("Heidi Kuehn wrote the documentation and wiki\n");
        stringBuffer.append("\n");
        stringBuffer.append("Additionally, we were helped by:\n");
        stringBuffer.append("Lukas Karlsson, Jesse Ross, and Sebastian Diaz (wiki, systems)\n");
        stringBuffer.append("Charlotte Henson, Jim Lerner, Helga Thorvaldsdottir, and Michael Reich (Cancer Informatics)\n");
        stringBuffer.append("\n");
        stringBuffer.append("Please check our website for a full list of contributors to GSEA concepts and publications\n");
        stringBuffer.append("\nBroad Institute of MIT and Harvard\n");
        stringBuffer.append("\n--------------------------------------------------------------------\n");
        stringBuffer.append("3rd party software acknowledgements:\n");
        stringBuffer.append("Sun Microsystems (http://java.sun.com): for Java!\n");
        stringBuffer.append("JIDE Software (http://www.jidesoft.com): a terrific docking & GUI component library\n");
        stringBuffer.append("Karsten Lentzsch (http://www.jgoodies.com): JGoodies look and feel and Forms library\n");
        stringBuffer.append("Intellij IDEA (http://www.jetbrains.com): Java IDE\n");
        stringBuffer.append("David Gilbert (http://www.jfree.org/jfreechart): GSEA plots use the JFreeChart library\n");
        stringBuffer.append("Log4J (http://logging.apache.org/log4jt): Logging toolkit\n");
        stringBuffer.append("Trove (http://trove4j.sourceforge.net/): High performance collections library\n");
        stringBuffer.append("Erich Gamma & Kent Beck (http://www.junit.org): JUnit testing framework\n");
        stringBuffer.append("Apache Jakarta ECS (http://jakarta.apache.org/ecs/): HTML element construction set API\n");
        stringBuffer.append("\n\n");
        stringBuffer.append("Built on xtools using the FijiTabs framework");
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jTextArea.setEditable(false);
        return new JScrollPane(jTextArea);
    }

    @Override
    public final String getName() {
        return "GSEA";
    }

    @Override
    public final boolean isFirstExecutionOfNewVersion() {
        return false;
    }

    @Override
    public final ToolManager getToolManager() {
        if (this.fToolManager == null) {
            this.fToolManager = new ToolManagerImpl();
        }
        return this.fToolManager;
    }

    @Override
    public final FileManager getFileManager() {
        if (this.fFileManager == null) {
            this.fFileManager = new FileManagerImpl();
        }
        return this.fFileManager;
    }

    @Override
    public final VdbManager getVdbManager() {
        return fVdbmanager;
    }

    @Override
    public final WindowManager getWindowManager() {
        return this.fWindowManager;
    }

    @Override
    public final StatusBar getStatusBar() {
        return this.fStatusBar;
    }

    static final /* synthetic */ void access$000(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame, WindowEvent windowEvent) {
        gseaFijiTabsApplicationFrame.exitApplication(windowEvent);
    }

    static final /* synthetic */ AppDataLoaderAction access$600(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame) {
        return gseaFijiTabsApplicationFrame.fAppDataLoaderAction;
    }

    static final /* synthetic */ GseaFijiTabsApplicationFrame access$700(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame) {
        return gseaFijiTabsApplicationFrame.fFrame;
    }

    static final /* synthetic */ JComponent access$800(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame) {
        return gseaFijiTabsApplicationFrame.createSoftwareCreditsComponent();
    }

    static final /* synthetic */ JComponent access$900() {
        return GseaFijiTabsApplicationFrame.createMethodologyInfoComponent();
    }

    static final /* synthetic */ GseaFijiTabsApplicationFrame$MyWindowManagerImplJideTabbedPane access$1000(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame) {
        return gseaFijiTabsApplicationFrame.fWindowManager;
    }

    static final /* synthetic */ JComponent access$1100() {
        return GseaFijiTabsApplicationFrame.createGseaAppInfoComponent();
    }

    static final /* synthetic */ JComponent access$1200(GseaFijiTabsApplicationFrame gseaFijiTabsApplicationFrame) {
        return gseaFijiTabsApplicationFrame.createLicenseComponent();
    }

    static {
        System.setProperty("GSEA", Boolean.TRUE.toString());
        USER_VISIBLE_FRAME_TITLE = "GSEA v2.2.1 (Gene set enrichment analysis -- Broad Institute)";
        ICON = JarResources.getImage("XBench.gif");
        fVdbmanager = new VdbManagerForGsea(RPT_CACHE_BUILD_DATE);
    }
}

