/*
 * Decompiled with CFR 0.152.
 */
package xapps.api.frameworks;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.actions.FilesAction;
import edu.mit.broad.xbench.actions.ObjectAction;
import edu.mit.broad.xbench.actions.PobActions;
import edu.mit.broad.xbench.actions.ProxyFileAction;
import edu.mit.broad.xbench.actions.ProxyFileObjectAction;
import edu.mit.broad.xbench.actions.ProxyObjectAction;
import edu.mit.broad.xbench.actions.WidgetAction;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.actions.ext.ExcelAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.actions.ext.TextpadAction;
import edu.mit.broad.xbench.dataio.ParserAction;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public abstract class AbstractActionLookup {
    private static final Logger klog = XLogger.getLogger(AbstractActionLookup.class);
    public static final int HACKNUM = 1;
    protected final Map fExtActionsMap = new HashMap();

    protected AbstractActionLookup() {
    }

    protected abstract PobActions lookupActions(Object var1);

    public final JPopupMenu createPopup(File file) {
        String string = NamingConventions.getExtension(file);
        Object v = this.fExtActionsMap.get(string);
        if (v == null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (!file.isDirectory()) {
                jPopupMenu.add(new TextpadAction(file.getPath()));
                jPopupMenu.add(new ExcelAction(file.getPath()));
                jPopupMenu.add(new BrowserAction(file.getPath()));
            }
            jPopupMenu.add(new OsExplorerAction(file.getPath()));
            return jPopupMenu;
        }
        PobActions pobActions = (PobActions)v;
        return this._createPopup(pobActions.allActions, file);
    }

    public final JPopupMenu createPopup(Object object) {
        if (object instanceof File) {
            return this.createPopup((File)object);
        }
        PobActions pobActions = this.lookupActions(object);
        XAction[] xActionArray = pobActions.allActions;
        if (xActionArray != null && xActionArray.length > 0) {
            return this.createPopupForObject(xActionArray, object);
        }
        return new JPopupMenu();
    }

    public final JPopupMenu createPopupForObject(XAction[] xActionArray, Object object) {
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        for (n = 0; n < xActionArray.length; ++n) {
            if (xActionArray[n] == null) {
                arrayList.add(new JSeparator());
                continue;
            }
            if (xActionArray[n] instanceof ParserAction) continue;
            try {
                arrayList.add(new JMenuItem(this.createAction(xActionArray[n], object)));
                continue;
            }
            catch (Throwable throwable) {
                klog.error("Error making popup", throwable);
                arrayList.add(new JMenuItem("Error making popup: " + throwable));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jPopupMenu.add((JComponent)arrayList.get(n));
        }
        return jPopupMenu;
    }

    private JPopupMenu _createPopup(XAction[] xActionArray, File file) {
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (xActionArray == null) {
            return jPopupMenu;
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        for (n = 0; n < xActionArray.length; ++n) {
            if (xActionArray[n] == null) {
                arrayList.add(new JSeparator());
                continue;
            }
            try {
                JMenuItem jMenuItem = new JMenuItem(this.createAction(xActionArray[n], (Object)file));
                arrayList.add(jMenuItem);
                continue;
            }
            catch (Throwable throwable) {
                klog.error(throwable);
                arrayList.add(new JMenuItem("Error making popup: " + throwable));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jPopupMenu.add((JComponent)arrayList.get(n));
        }
        return jPopupMenu;
    }

    public final XAction createAction(XAction xAction, Object object) {
        if (xAction instanceof FileObjectAction) {
            return new ProxyFileObjectAction((FileObjectAction)xAction, object);
        }
        if (xAction instanceof ObjectAction) {
            return new ProxyObjectAction((ObjectAction)xAction, object);
        }
        if (xAction instanceof FileAction && object instanceof File) {
            return new ProxyFileAction((FileAction)xAction, (File)object);
        }
        if (xAction instanceof FileAction && object instanceof PersistentObject && ParserFactory.getCache().isCached((PersistentObject)object)) {
            return new ProxyFileAction((FileAction)xAction, ParserFactory.getCache().getSourceFile(object));
        }
        if (xAction instanceof FilesAction && object instanceof File[]) {
            return new ProxyFileAction((FilesAction)xAction, (File[])object);
        }
        if (xAction instanceof ExtAction && object instanceof File) {
            Class<?> clazz = xAction.getClass();
            ExtAction extAction = (ExtAction)clazz.newInstance();
            extAction.setPath(((File)object).getPath());
            return extAction;
        }
        if (xAction instanceof ExtAction && object instanceof PersistentObject) {
            Class<?> clazz = xAction.getClass();
            ExtAction extAction = (ExtAction)clazz.newInstance();
            extAction.setPath(ParserFactory.getCache().getSourceFile(object).getPath());
            return extAction;
        }
        if (xAction instanceof WidgetAction) {
            Class<?> clazz = xAction.getClass();
            return (WidgetAction)clazz.newInstance();
        }
        throw new Exception("Unknown action type: " + xAction + " and object combo: " + object);
    }

    public final XAction createAction(Class clazz, Object object) {
        try {
            XAction xAction = (XAction)clazz.newInstance();
            return this.createAction(xAction, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

