/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import org.tigr.util.Maths;

public class FloatMatrix
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1000103010001L;
    public float[][] A;
    public int m;
    public int n;

    public FloatMatrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new float[n][n2];
    }

    public FloatMatrix(int n, int n2, float f2) {
        this.m = n;
        this.n = n2;
        this.A = new float[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.A[i2][i3] = f2;
            }
        }
    }

    public FloatMatrix(float[][] fArray) {
        this.m = fArray.length;
        this.n = fArray[0].length;
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (fArray[i2].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = fArray;
    }

    public FloatMatrix(float[][] fArray, int n, int n2) {
        this.A = fArray;
        this.m = n;
        this.n = n2;
    }

    public FloatMatrix(float[] fArray, int n) {
        this.m = n;
        int n2 = this.n = n != 0 ? fArray.length / n : 0;
        if (n * this.n != fArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new float[n][this.n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = fArray[i2 + i3 * n];
            }
        }
    }

    public static FloatMatrix constructWithCopy(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        FloatMatrix floatMatrix = new FloatMatrix(n, n2);
        float[][] fArray2 = floatMatrix.getArray();
        for (int i2 = 0; i2 < n; ++i2) {
            if (fArray[i2].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                fArray2[i2][i3] = fArray[i2][i3];
            }
        }
        return floatMatrix;
    }

    public FloatMatrix copy() {
        FloatMatrix floatMatrix = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3];
            }
        }
        return floatMatrix;
    }

    public Object clone() {
        return this.copy();
    }

    public float[][] getArray() {
        return this.A;
    }

    public float[][] getArrayCopy() {
        float[][] fArray = new float[this.m][this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3];
            }
        }
        return fArray;
    }

    public float[] getColumnPackedCopy() {
        float[] fArray = new float[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2 + i3 * this.m] = this.A[i2][i3];
            }
        }
        return fArray;
    }

    public float[] getRowPackedCopy() {
        float[] fArray = new float[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2 * this.n + i3] = this.A[i2][i3];
            }
        }
        return fArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public float get(int n, int n2) {
        return this.A[n][n2];
    }

    public FloatMatrix getMatrix(int n, int n2, int n3, int n4) {
        FloatMatrix floatMatrix = new FloatMatrix(n2 - n + 1, n4 - n3 + 1);
        float[][] fArray = floatMatrix.getArray();
        try {
            for (int i2 = n; i2 <= n2; ++i2) {
                for (int i3 = n3; i3 <= n4; ++i3) {
                    fArray[i2 - n][i3 - n3] = this.A[i2][i3];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return floatMatrix;
    }

    public FloatMatrix getMatrix(int[] nArray, int[] nArray2) {
        FloatMatrix floatMatrix = new FloatMatrix(nArray.length, nArray2.length);
        float[][] fArray = floatMatrix.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    fArray[i2][i3] = this.A[nArray[i2]][nArray2[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return floatMatrix;
    }

    public FloatMatrix getMatrix(int n, int n2, int[] nArray) {
        FloatMatrix floatMatrix = new FloatMatrix(n2 - n + 1, nArray.length);
        float[][] fArray = floatMatrix.getArray();
        try {
            for (int i2 = n; i2 <= n2; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    fArray[i2 - n][i3] = this.A[i2][nArray[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return floatMatrix;
    }

    public FloatMatrix getMatrix(int[] nArray, int n, int n2) {
        FloatMatrix floatMatrix = new FloatMatrix(nArray.length, n2 - n + 1);
        float[][] fArray = floatMatrix.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = n; i3 <= n2; ++i3) {
                    fArray[i2][i3 - n] = this.A[nArray[i2]][i3];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return floatMatrix;
    }

    public void set(int n, int n2, float f2) {
        this.A[n][n2] = f2;
    }

    public void setMatrix(int n, int n2, int n3, int n4, FloatMatrix floatMatrix) {
        try {
            for (int i2 = n; i2 <= n2; ++i2) {
                for (int i3 = n3; i3 <= n4; ++i3) {
                    this.A[i2][i3] = floatMatrix.get(i2 - n, i3 - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, FloatMatrix floatMatrix) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    this.A[nArray[i2]][nArray2[i3]] = floatMatrix.get(i2, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, FloatMatrix floatMatrix) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = n; i3 <= n2; ++i3) {
                    this.A[nArray[i2]][i3] = floatMatrix.get(i2, i3 - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, FloatMatrix floatMatrix) {
        try {
            for (int i2 = n; i2 <= n2; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.A[i2][nArray[i3]] = floatMatrix.get(i2 - n, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public FloatMatrix transpose() {
        FloatMatrix floatMatrix = new FloatMatrix(this.n, this.m);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i3][i2] = this.A[i2][i3];
            }
        }
        return floatMatrix;
    }

    public float norm1() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.n; ++i2) {
            float f3 = 0.0f;
            for (int i3 = 0; i3 < this.m; ++i3) {
                f3 += Math.abs(this.A[i3][i2]);
            }
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public float normInf() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.m; ++i2) {
            float f3 = 0.0f;
            for (int i3 = 0; i3 < this.n; ++i3) {
                f3 += Math.abs(this.A[i2][i3]);
            }
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public float normF() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                f2 = Maths.hypot(f2, this.A[i2][i3]);
            }
        }
        return f2;
    }

    public FloatMatrix uminus() {
        FloatMatrix floatMatrix = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = -this.A[i2][i3];
            }
        }
        return floatMatrix;
    }

    public FloatMatrix plus(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3] + floatMatrix.A[i2][i3];
            }
        }
        return floatMatrix2;
    }

    public FloatMatrix plusEquals(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] + floatMatrix.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix minus(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3] - floatMatrix.A[i2][i3];
            }
        }
        return floatMatrix2;
    }

    public FloatMatrix minusEquals(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] - floatMatrix.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix arrayTimes(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3] * floatMatrix.A[i2][i3];
            }
        }
        return floatMatrix2;
    }

    public FloatMatrix arrayTimesEquals(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] * floatMatrix.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix arrayRightDivide(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = this.A[i2][i3] / floatMatrix.A[i2][i3];
            }
        }
        return floatMatrix2;
    }

    public FloatMatrix arrayRightDivideEquals(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] / floatMatrix.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix arrayLeftDivide(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = floatMatrix.A[i2][i3] / this.A[i2][i3];
            }
        }
        return floatMatrix2;
    }

    public FloatMatrix arrayLeftDivideEquals(FloatMatrix floatMatrix) {
        this.checkMatrixDimensions(floatMatrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = floatMatrix.A[i2][i3] / this.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix times(float f2) {
        FloatMatrix floatMatrix = new FloatMatrix(this.m, this.n);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                fArray[i2][i3] = f2 * this.A[i2][i3];
            }
        }
        return floatMatrix;
    }

    public FloatMatrix timesEquals(float f2) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = f2 * this.A[i2][i3];
            }
        }
        return this;
    }

    public FloatMatrix times(FloatMatrix floatMatrix) {
        if (floatMatrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(this.m, floatMatrix.n);
        float[][] fArray = floatMatrix2.getArray();
        float[] fArray2 = new float[this.n];
        for (int i2 = 0; i2 < floatMatrix.n; ++i2) {
            int n;
            for (n = 0; n < this.n; ++n) {
                fArray2[n] = floatMatrix.A[n][i2];
            }
            for (n = 0; n < this.m; ++n) {
                float[] fArray3 = this.A[n];
                float f2 = 0.0f;
                for (int i3 = 0; i3 < this.n; ++i3) {
                    f2 += fArray3[i3] * fArray2[i3];
                }
                fArray[n][i2] = f2;
            }
        }
        return floatMatrix2;
    }

    public float trace() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < Math.min(this.m, this.n); ++i2) {
            f2 += this.A[i2][i2];
        }
        return f2;
    }

    public static FloatMatrix random(int n, int n2) {
        FloatMatrix floatMatrix = new FloatMatrix(n, n2);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fArray[i2][i3] = (float)Math.random();
            }
        }
        return floatMatrix;
    }

    public static FloatMatrix identity(int n, int n2) {
        FloatMatrix floatMatrix = new FloatMatrix(n, n2);
        float[][] fArray = floatMatrix.getArray();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                fArray[i2][i3] = (float)(i2 == i3 ? 1.0 : 0.0);
            }
        }
        return floatMatrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                String string = numberFormat.format(this.A[i2][i3]);
                int n2 = Math.max(1, n - string.length());
                for (int i4 = 0; i4 < n2; ++i4) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static FloatMatrix read(BufferedReader bufferedReader) {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Float.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = vector.size();
        float[] fArray = new float[n2];
        for (n = 0; n < n2; ++n) {
            fArray[n] = ((Float)vector.elementAt(n)).floatValue();
        }
        vector.removeAllElements();
        vector.addElement(fArray);
        while (streamTokenizer.nextToken() == -3) {
            fArray = new float[n2];
            vector.addElement(fArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                fArray[n++] = Float.valueOf(streamTokenizer.sval).floatValue();
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n = vector.size();
        float[][] fArrayArray = new float[n][];
        vector.copyInto((Object[])fArrayArray);
        return new FloatMatrix(fArrayArray);
    }

    private void checkMatrixDimensions(FloatMatrix floatMatrix) {
        if (floatMatrix.m != this.m || floatMatrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public FloatMatrix getSubMatrix(int n) {
        if (n <= 0) {
            return this;
        }
        int n2 = this.m / n;
        int n3 = this.n / n;
        FloatMatrix floatMatrix = new FloatMatrix(n2, n3);
        float[][] fArray = floatMatrix.getArray();
        int n4 = 0;
        for (int i2 = 0; n4 < this.m && i2 < n2; n4 += n, ++i2) {
            int n5 = 0;
            for (int i3 = 0; n5 < this.n && i3 < n3; n5 += n, ++i3) {
                fArray[i2][i3] = this.A[n4][n5];
            }
        }
        return floatMatrix;
    }
}

