/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date;

import java.util.Calendar;
import java.util.Date;
import org.jfree.date.SerialDate;

public class SpreadsheetDate
extends SerialDate {
    private static final long serialVersionUID = -2039586705374454461L;
    private final int serial;
    private final int day;
    private final int month;
    private final int year;

    public SpreadsheetDate(int n) {
        int n2;
        if (n < 2 || n > 2958465) {
            throw new IllegalArgumentException("SpreadsheetDate: Serial must be in range 2 to 2958465.");
        }
        this.serial = n;
        int n3 = this.serial - 2;
        int n4 = 1900 + n3 / 365;
        int n5 = SerialDate.leapYearCount(n4);
        int n6 = n3 - n5;
        int n7 = 1900 + n6 / 365;
        if (n7 == n4) {
            this.year = n7;
        } else {
            n2 = this.calcSerial(1, 1, n7);
            while (n2 <= this.serial) {
                n2 = this.calcSerial(1, 1, ++n7);
            }
            this.year = n7 - 1;
        }
        n2 = this.calcSerial(1, 1, this.year);
        int[] nArray = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        if (SerialDate.isLeapYear(this.year)) {
            nArray = SerialDate.LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        }
        int n8 = 1;
        int n9 = n2 + nArray[n8] - 1;
        while (n9 < this.serial) {
            n9 = n2 + nArray[++n8] - 1;
        }
        this.month = n8 - 1;
        this.day = this.serial - n2 - nArray[this.month] + 1;
    }

    public SpreadsheetDate(int n, int n2, int n3) {
        if (n3 < 1900 || n3 > 9999) {
            throw new IllegalArgumentException("The 'year' argument must be in range 1900 to 9999.");
        }
        this.year = n3;
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("The 'month' argument must be in the range 1 to 12.");
        }
        this.month = n2;
        if (n < 1 || n > SerialDate.lastDayOfMonth(n2, n3)) {
            throw new IllegalArgumentException("Invalid 'day' argument.");
        }
        this.day = n;
        this.serial = this.calcSerial(n, n2, n3);
    }

    private int calcSerial(int n, int n2, int n3) {
        int n4 = (n3 - 1900) * 365 + SerialDate.leapYearCount(n3 - 1);
        int n5 = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH[n2];
        if (n2 > 2 && SerialDate.isLeapYear(n3)) {
            ++n5;
        }
        int n6 = n;
        return n4 + n5 + n6 + 1;
    }

    public final int compare(SerialDate serialDate) {
        return this.serial - serialDate.toSerial();
    }

    public final int compareTo(Object object) {
        return this.compare((SerialDate)object);
    }

    public final boolean equals(Object object) {
        if (object instanceof SerialDate) {
            SerialDate serialDate = (SerialDate)object;
            return serialDate.toSerial() == this.toSerial();
        }
        return false;
    }

    public final int getDayOfMonth() {
        return this.day;
    }

    public final int getDayOfWeek() {
        return (this.serial + 6) % 7 + 1;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getYYYY() {
        return this.year;
    }

    public final int hashCode() {
        return this.toSerial();
    }

    public final boolean isAfter(SerialDate serialDate) {
        return this.serial > serialDate.toSerial();
    }

    public final boolean isBefore(SerialDate serialDate) {
        return this.serial < serialDate.toSerial();
    }

    public final boolean isInRange(SerialDate serialDate, SerialDate serialDate2) {
        return this.isInRange(serialDate, serialDate2, 3);
    }

    public final boolean isInRange(SerialDate serialDate, SerialDate serialDate2, int n) {
        int n2 = serialDate.toSerial();
        int n3 = serialDate2.toSerial();
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        int n6 = this.toSerial();
        if (n == 3) {
            return n6 >= n4 && n6 <= n5;
        }
        if (n == 1) {
            return n6 >= n4 && n6 < n5;
        }
        if (n == 2) {
            return n6 > n4 && n6 <= n5;
        }
        return n6 > n4 && n6 < n5;
    }

    public final boolean isOn(SerialDate serialDate) {
        return this.serial == serialDate.toSerial();
    }

    public final boolean isOnOrAfter(SerialDate serialDate) {
        return this.serial >= serialDate.toSerial();
    }

    public final boolean isOnOrBefore(SerialDate serialDate) {
        return this.serial <= serialDate.toSerial();
    }

    public final Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYYYY(), this.getMonth() - 1, this.getDayOfMonth(), 0, 0, 0);
        return calendar.getTime();
    }

    public final int toSerial() {
        return this.serial;
    }
}

