/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer$XYBarRendererState;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 770559577251370036L;
    private double base;
    private boolean useYInterval;
    private double margin;
    private boolean drawBarOutline;
    private GradientPaintTransformer gradientPaintTransformer;
    private transient Shape legendBar;
    private ItemLabelPosition positiveItemLabelPositionFallback;
    private ItemLabelPosition negativeItemLabelPositionFallback;

    public XYBarRenderer() {
        this(0.0);
    }

    public XYBarRenderer(double d2) {
        this.margin = d2;
        this.base = 0.0;
        this.useYInterval = false;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
        this.drawBarOutline = true;
        this.legendBar = new Rectangle2D.Double(-3.0, -5.0, 6.0, 10.0);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d2) {
        this.base = d2;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseYInterval() {
        return this.useYInterval;
    }

    public void setUseYInterval(boolean bl) {
        this.useYInterval = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d2) {
        this.margin = d2;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl) {
        this.drawBarOutline = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Shape getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'bar' argument.");
        }
        this.legendBar = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.positiveItemLabelPositionFallback = itemLabelPosition;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.negativeItemLabelPositionFallback = itemLabelPosition;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYBarRenderer$XYBarRendererState xYBarRenderer$XYBarRendererState = new XYBarRenderer$XYBarRendererState(this, plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxisForDataset(xYPlot.indexOf(xYDataset));
        xYBarRenderer$XYBarRendererState.setG2Base(valueAxis.valueToJava2D(this.base, rectangle2D, xYPlot.getRangeAxisEdge()));
        return xYBarRenderer$XYBarRendererState;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.legendBar;
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        Object object;
        double d2;
        double d3;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.useYInterval) {
            d3 = intervalXYDataset.getStartYValue(n, n2);
            d2 = intervalXYDataset.getEndYValue(n, n2);
        } else {
            d3 = this.base;
            d2 = intervalXYDataset.getYValue(n, n2);
        }
        if (Double.isNaN(d3) || Double.isNaN(d2)) {
            return;
        }
        double d4 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d6 = intervalXYDataset.getStartXValue(n, n2);
        if (Double.isNaN(d6)) {
            return;
        }
        double d7 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
        double d8 = intervalXYDataset.getEndXValue(n, n2);
        if (Double.isNaN(d8)) {
            return;
        }
        double d9 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        double d10 = Math.max(1.0, Math.abs(d9 - d7));
        double d11 = Math.abs(d5 - d4);
        if (this.getMargin() > 0.0) {
            double d12 = d10 * this.getMargin();
            d10 -= d12;
            d7 += d12 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d4, d5), Math.min(d7, d9), d11, d10);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(Math.min(d7, d9), Math.min(d4, d5), d10, d11);
        }
        Paint paint = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            object = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform((GradientPaint)object, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d9 - d7) > 3.0) {
            object = this.getItemOutlineStroke(n, n2);
            Paint paint2 = this.getItemOutlinePaint(n, n2);
            if (object != null && paint2 != null) {
                graphics2D.setStroke((Stroke)object);
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_);
            }
        }
        if (this.isItemLabelVisible(n, n2)) {
            object = this.getItemLabelGenerator(n, n2);
            this.drawItemLabel(graphics2D, xYDataset, n, n2, xYPlot, (XYItemLabelGenerator)object, double_, d2 < 0.0);
        }
        double d13 = (d6 + d8) / 2.0;
        double d14 = xYDataset.getYValue(n, n2);
        double d15 = valueAxis.valueToJava2D(d13, rectangle2D, rectangleEdge);
        double d16 = valueAxis2.valueToJava2D(d14, rectangle2D, xYPlot.getRangeAxisEdge());
        this.updateCrosshairValues(crosshairState, d13, d14, d15, d16, xYPlot.getOrientation());
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, XYDataset xYDataset, int n, int n2, XYPlot xYPlot, XYItemLabelGenerator xYItemLabelGenerator, Rectangle2D rectangle2D, boolean bl) {
        Shape shape;
        String string = xYItemLabelGenerator.generateLabel(xYDataset, n, n2);
        if (string == null) {
            return;
        }
        Font font = this.getItemLabelFont(n, n2);
        graphics2D.setFont(font);
        Paint paint = this.getItemLabelPaint(n, n2);
        graphics2D.setPaint(paint);
        ItemLabelPosition itemLabelPosition = null;
        itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        if (this.isInternalAnchor(itemLabelPosition.getItemLabelAnchor()) && (shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor())) != null && !rectangle2D.contains(shape.getBounds2D()) && (itemLabelPosition = !bl ? this.getPositiveItemLabelPositionFallback() : this.getNegativeItemLabelPositionFallback()) != null) {
            point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        }
        if (itemLabelPosition != null) {
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        double d2 = this.getItemLabelAnchorOffset();
        double d3 = rectangle2D.getX() - d2;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getX() + d2;
        double d6 = rectangle2D.getCenterX();
        double d7 = rectangle2D.getMaxX() - d2;
        double d8 = rectangle2D.getMaxX();
        double d9 = rectangle2D.getMaxX() + d2;
        double d10 = rectangle2D.getMaxY() + d2;
        double d11 = rectangle2D.getMaxY();
        double d12 = rectangle2D.getMaxY() - d2;
        double d13 = rectangle2D.getCenterY();
        double d14 = rectangle2D.getMinY() + d2;
        double d15 = rectangle2D.getMinY();
        double d16 = rectangle2D.getMinY() - d2;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d7, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d7, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d7, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d7, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d7, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d6, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d5, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d5, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d5, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d6, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d8, d16);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d9, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d9, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d9, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d8, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d6, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d4, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d3, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d3, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d3, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d4, d16);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d6, d16);
        }
        return double_;
    }

    private boolean isInternalAnchor(ItemLabelAnchor itemLabelAnchor) {
        return itemLabelAnchor == ItemLabelAnchor.CENTER || itemLabelAnchor == ItemLabelAnchor.INSIDE1 || itemLabelAnchor == ItemLabelAnchor.INSIDE2 || itemLabelAnchor == ItemLabelAnchor.INSIDE3 || itemLabelAnchor == ItemLabelAnchor.INSIDE4 || itemLabelAnchor == ItemLabelAnchor.INSIDE5 || itemLabelAnchor == ItemLabelAnchor.INSIDE6 || itemLabelAnchor == ItemLabelAnchor.INSIDE7 || itemLabelAnchor == ItemLabelAnchor.INSIDE8 || itemLabelAnchor == ItemLabelAnchor.INSIDE9 || itemLabelAnchor == ItemLabelAnchor.INSIDE10 || itemLabelAnchor == ItemLabelAnchor.INSIDE11 || itemLabelAnchor == ItemLabelAnchor.INSIDE12;
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findDomainBounds(xYDataset, true);
        }
        return null;
    }

    public Object clone() {
        XYBarRenderer xYBarRenderer = (XYBarRenderer)super.clone();
        if (this.gradientPaintTransformer != null) {
            xYBarRenderer.gradientPaintTransformer = (GradientPaintTransformer)ObjectUtilities.clone(this.gradientPaintTransformer);
        }
        return xYBarRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBarRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYBarRenderer xYBarRenderer = (XYBarRenderer)object;
        if (this.base != xYBarRenderer.base) {
            return false;
        }
        if (this.drawBarOutline != xYBarRenderer.drawBarOutline) {
            return false;
        }
        if (this.margin != xYBarRenderer.margin) {
            return false;
        }
        if (this.useYInterval != xYBarRenderer.useYInterval) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, xYBarRenderer.gradientPaintTransformer)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendBar, xYBarRenderer.legendBar)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionFallback, xYBarRenderer.positiveItemLabelPositionFallback)) {
            return false;
        }
        return ObjectUtilities.equal(this.negativeItemLabelPositionFallback, xYBarRenderer.negativeItemLabelPositionFallback);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendBar = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendBar, objectOutputStream);
    }
}

