/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;

public class XYAreaRenderer2
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7378069681579984133L;
    private boolean plotLines = false;
    private boolean showOutline = false;
    private transient Shape legendArea;

    public XYAreaRenderer2() {
        this(null, null);
    }

    public XYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -4.0f);
        generalPath.lineTo(3.0f, -2.0f);
        generalPath.lineTo(4.0f, 4.0f);
        generalPath.lineTo(-4.0f, 4.0f);
        generalPath.lineTo(-3.0f, -2.0f);
        generalPath.closePath();
        this.legendArea = generalPath;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public Shape getLegendArea() {
        return this.legendArea;
    }

    public void setLegendArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.legendArea = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.getSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.legendArea, paint);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        double d2 = xYDataset.getXValue(n, n2);
        double d3 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        double d6 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d7 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d7)) {
            d7 = 0.0;
        }
        double d8 = valueAxis.valueToJava2D(d6, rectangle2D, xYPlot.getDomainAxisEdge());
        double d9 = valueAxis2.valueToJava2D(d7, rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        double d10 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d11 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d11)) {
            d11 = 0.0;
        }
        double d12 = valueAxis.valueToJava2D(d10, rectangle2D, xYPlot.getDomainAxisEdge());
        double d13 = valueAxis2.valueToJava2D(d11, rectangle2D, xYPlot.getRangeAxisEdge());
        double d14 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        Polygon polygon = null;
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            polygon = new Polygon();
            polygon.addPoint((int)d14, (int)((d8 + d4) / 2.0));
            polygon.addPoint((int)((d9 + d5) / 2.0), (int)((d8 + d4) / 2.0));
            polygon.addPoint((int)d5, (int)d4);
            polygon.addPoint((int)((d5 + d13) / 2.0), (int)((d4 + d12) / 2.0));
            polygon.addPoint((int)d14, (int)((d4 + d12) / 2.0));
        } else {
            polygon = new Polygon();
            polygon.addPoint((int)((d8 + d4) / 2.0), (int)d14);
            polygon.addPoint((int)((d8 + d4) / 2.0), (int)((d9 + d5) / 2.0));
            polygon.addPoint((int)d4, (int)d5);
            polygon.addPoint((int)((d4 + d12) / 2.0), (int)((d5 + d13) / 2.0));
            polygon.addPoint((int)((d4 + d12) / 2.0), (int)d14);
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (this.getPlotLines() && n2 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYItemRendererState.workingLine.setLine(d8, d9, d4, d5);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYItemRendererState.workingLine.setLine(d9, d8, d5, d4);
            }
            graphics2D.draw(xYItemRendererState.workingLine);
        }
        graphics2D.fill(polygon);
        if (this.isOutline()) {
            graphics2D.setStroke(this.getSeriesOutlineStroke(n));
            graphics2D.setPaint(this.getSeriesOutlinePaint(n));
            graphics2D.draw(polygon);
        }
        this.updateCrosshairValues(crosshairState, d2, d3, d4, d5, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getEntityCollection()) != null && polygon != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(polygon, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    public Object clone() {
        return super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendArea = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendArea, objectOutputStream);
    }
}

