/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedXYAreaRenderer2
extends XYAreaRenderer2
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7752676509764539182L;

    public StackedXYAreaRenderer2() {
        this(null, null);
    }

    public StackedXYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n = tableXYDataset.getItemCount();
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray = this.getStackValues((TableXYDataset)xYDataset, tableXYDataset.getSeriesCount(), i2);
            d2 = Math.min(d2, dArray[0]);
            d3 = Math.max(d3, dArray[1]);
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public int getPassCount() {
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        float f2;
        float f3;
        float f4;
        GeneralPath generalPath = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        double d2 = xYDataset.getXValue(n, n2);
        double d3 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        double[] dArray = this.getStackValues(tableXYDataset, n, n2);
        double d4 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d5 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        double[] dArray2 = this.getStackValues(tableXYDataset, n, Math.max(n2 - 1, 0));
        int n4 = xYDataset.getItemCount(n);
        double d6 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d7 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d7)) {
            d7 = 0.0;
        }
        double[] dArray3 = this.getStackValues(tableXYDataset, n, Math.min(n2 + 1, n4 - 1));
        double d8 = (d4 + d2) / 2.0;
        double d9 = (d2 + d6) / 2.0;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        float f5 = (float)valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        float f6 = (float)valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        float f7 = (float)valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        GeneralPath generalPath2 = new GeneralPath();
        GeneralPath generalPath3 = new GeneralPath();
        if (d3 >= 0.0) {
            f4 = (float)valueAxis2.valueToJava2D(d3 + dArray[1], rectangle2D, rectangleEdge2);
            f3 = (float)valueAxis2.valueToJava2D(dArray[1], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge2);
            if (d5 >= 0.0) {
                double d10 = (d5 + d3) / 2.0 + dArray4[1];
                float f8 = (float)valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                generalPath2.moveTo(f5, f4);
                generalPath2.lineTo(f5, f3);
                generalPath2.lineTo(f6, f2);
                generalPath2.lineTo(f6, f8);
                generalPath2.closePath();
            } else {
                generalPath2.moveTo(f5, f3);
                generalPath2.lineTo(f5, f4);
                generalPath2.lineTo(f6, f2);
                generalPath2.closePath();
            }
            float f9 = (float)valueAxis2.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge2);
            if (d7 >= 0.0) {
                double d11 = (d3 + d7) / 2.0 + dArray5[1];
                float f10 = (float)valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
                generalPath3.moveTo(f5, f3);
                generalPath3.lineTo(f5, f4);
                generalPath3.lineTo(f7, f10);
                generalPath3.lineTo(f7, f9);
                generalPath3.closePath();
            } else {
                generalPath3.moveTo(f5, f3);
                generalPath3.lineTo(f5, f4);
                generalPath3.lineTo(f7, f9);
                generalPath3.closePath();
            }
        } else {
            f4 = (float)valueAxis2.valueToJava2D(d3 + dArray[0], rectangle2D, rectangleEdge2);
            f3 = (float)valueAxis2.valueToJava2D(dArray[0], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge2);
            if (d5 >= 0.0) {
                generalPath2.moveTo(f5, f3);
                generalPath2.lineTo(f5, f4);
                generalPath2.lineTo(f6, f2);
                generalPath2.clone();
            } else {
                double d12 = (d5 + d3) / 2.0 + dArray4[0];
                float f11 = (float)valueAxis2.valueToJava2D(d12, rectangle2D, rectangleEdge2);
                generalPath2.moveTo(f5, f4);
                generalPath2.lineTo(f5, f3);
                generalPath2.lineTo(f6, f2);
                generalPath2.lineTo(f6, f11);
                generalPath2.closePath();
            }
            float f12 = (float)valueAxis2.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge2);
            if (d7 >= 0.0) {
                generalPath3.moveTo(f5, f3);
                generalPath3.lineTo(f5, f4);
                generalPath3.lineTo(f7, f12);
                generalPath3.closePath();
            } else {
                double d13 = (d3 + d7) / 2.0 + dArray5[0];
                float f13 = (float)valueAxis2.valueToJava2D(d13, rectangle2D, rectangleEdge2);
                generalPath3.moveTo(f5, f3);
                generalPath3.lineTo(f5, f4);
                generalPath3.lineTo(f7, f13);
                generalPath3.lineTo(f7, f12);
                generalPath3.closePath();
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        if (n3 == 0) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath2);
            graphics2D.fill(generalPath3);
        }
        if (entityCollection != null) {
            GeneralPath generalPath4 = new GeneralPath(generalPath2);
            generalPath4.append(generalPath3, false);
            generalPath = generalPath4;
            this.addEntity(entityCollection, generalPath, xYDataset, n, n2, f5, f4);
        }
    }

    private double[] getStackValues(TableXYDataset tableXYDataset, int n, int n2) {
        double[] dArray = new double[2];
        for (int i2 = 0; i2 < n; ++i2) {
            double d2 = tableXYDataset.getYValue(i2, n2);
            if (Double.isNaN(d2)) continue;
            if (d2 >= 0.0) {
                dArray[1] = dArray[1] + d2;
                continue;
            }
            dArray[0] = dArray[0] + d2;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    public Object clone() {
        return super.clone();
    }
}

