/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AreaRendererEndType;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class AreaRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4231878281385812757L;
    private AreaRendererEndType endType = AreaRendererEndType.TAPER;

    public AreaRendererEndType getEndType() {
        return this.endType;
    }

    public void setEndType(AreaRendererEndType areaRendererEndType) {
        if (areaRendererEndType == null) {
            throw new IllegalArgumentException("Null 'type' argument.");
        }
        this.endType = areaRendererEndType;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesOutlineStroke(n2);
        return new LegendItem(string, string2, string3, string4, (Shape)double_, paint, stroke, paint2);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            Serializable serializable;
            Number number2;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
            int n4 = categoryDataset.getColumnCount();
            float f2 = (float)categoryAxis.getCategoryStart(n2, n4, rectangle2D, rectangleEdge);
            float f3 = (float)categoryAxis.getCategoryMiddle(n2, n4, rectangle2D, rectangleEdge);
            float f4 = (float)categoryAxis.getCategoryEnd(n2, n4, rectangle2D, rectangleEdge);
            f2 = Math.round(f2);
            f3 = Math.round(f3);
            f4 = Math.round(f4);
            if (this.endType == AreaRendererEndType.TRUNCATE) {
                if (n2 == 0) {
                    f2 = f3;
                } else if (n2 == this.getColumnCount() - 1) {
                    f4 = f3;
                }
            }
            double d2 = number.doubleValue();
            double d3 = 0.0;
            if (n2 > 0 && (number2 = categoryDataset.getValue(n, n2 - 1)) != null) {
                d3 = (number2.doubleValue() + d2) / 2.0;
            }
            double d4 = 0.0;
            if (n2 < categoryDataset.getColumnCount() - 1 && (serializable = categoryDataset.getValue(n, n2 + 1)) != null) {
                d4 = (((Number)serializable).doubleValue() + d2) / 2.0;
            }
            serializable = categoryPlot.getRangeAxisEdge();
            float f5 = (float)valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)serializable);
            float f6 = (float)valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)serializable);
            float f7 = (float)valueAxis.valueToJava2D(d4, rectangle2D, (RectangleEdge)serializable);
            float f8 = (float)valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)serializable);
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            GeneralPath generalPath = new GeneralPath();
            if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath.moveTo(f2, f8);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f3, f6);
                generalPath.lineTo(f4, f7);
                generalPath.lineTo(f4, f8);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath.moveTo(f8, f2);
                generalPath.lineTo(f5, f2);
                generalPath.lineTo(f6, f3);
                generalPath.lineTo(f7, f4);
                generalPath.lineTo(f8, f4);
            }
            generalPath.closePath();
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(generalPath);
            if (this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, f3, f6, number.doubleValue() < 0.0);
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, generalPath);
            }
        }
    }

    public Object clone() {
        return super.clone();
    }
}

