/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.renderer.Outlier;

public class OutlierList {
    private List outliers = new ArrayList();
    private Outlier averagedOutlier;
    private boolean multiple = false;

    public OutlierList(Outlier outlier) {
        this.setAveragedOutlier(outlier);
    }

    public final boolean add(Outlier outlier) {
        return this.outliers.add(outlier);
    }

    public final int getItemCount() {
        return this.outliers.size();
    }

    public final Outlier getAveragedOutlier() {
        return this.averagedOutlier;
    }

    public final void setAveragedOutlier(Outlier outlier) {
        this.averagedOutlier = outlier;
    }

    public final boolean isMultiple() {
        return this.multiple;
    }

    public final void setMultiple(boolean bl) {
        this.multiple = bl;
    }

    public final boolean isOverlapped(Outlier outlier) {
        if (outlier == null) {
            return false;
        }
        boolean bl = outlier.overlaps(this.getAveragedOutlier());
        return bl;
    }

    public final void updateAveragedOutlier() {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.getItemCount();
        Iterator iterator = this.outliers.iterator();
        while (iterator.hasNext()) {
            Outlier outlier = (Outlier)iterator.next();
            d2 += outlier.getX();
            d3 += outlier.getY();
        }
        this.getAveragedOutlier().getPoint().setLocation(new Point2D.Double(d2 / (double)n, d3 / (double)n));
    }
}

