/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.plot.PieLabelRecord;

public class PieLabelDistributor {
    private List labels;
    private double minGap = 4.0;

    public PieLabelDistributor(int n) {
        this.labels = new ArrayList(n);
    }

    public final PieLabelRecord getPieLabelRecord(int n) {
        return (PieLabelRecord)this.labels.get(n);
    }

    public final void addPieLabelRecord(PieLabelRecord pieLabelRecord) {
        this.labels.add(pieLabelRecord);
    }

    public final int getItemCount() {
        return this.labels.size();
    }

    public final void distributeLabels(double d2, double d3) {
        this.sort();
        if (this.isOverlap()) {
            this.adjustInwards();
        }
        if (this.isOverlap()) {
            this.adjustDownwards(d2, d3);
        }
        if (this.isOverlap()) {
            this.adjustUpwards(d2, d3);
        }
        if (this.isOverlap()) {
            this.spreadEvenly(d2, d3);
        }
    }

    private boolean isOverlap() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.labels.size(); ++i2) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i2);
            if (d2 > pieLabelRecord.getLowerY()) {
                return true;
            }
            d2 = pieLabelRecord.getUpperY();
        }
        return false;
    }

    protected final void adjustInwards() {
        int n = 0;
        for (int i2 = this.labels.size() - 1; i2 > n; ++n, --i2) {
            double d2;
            PieLabelRecord pieLabelRecord;
            PieLabelRecord pieLabelRecord2;
            if (n < i2 - 1) {
                pieLabelRecord2 = this.getPieLabelRecord(n);
                pieLabelRecord = this.getPieLabelRecord(n + 1);
                if (pieLabelRecord.getLowerY() < pieLabelRecord2.getUpperY()) {
                    d2 = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
                    pieLabelRecord.setAllocatedY(pieLabelRecord.getAllocatedY() + d2);
                }
            }
            pieLabelRecord2 = this.getPieLabelRecord(i2 - 1);
            pieLabelRecord = this.getPieLabelRecord(i2);
            if (!(pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY())) continue;
            d2 = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
            pieLabelRecord2.setAllocatedY(pieLabelRecord2.getAllocatedY() - d2);
        }
    }

    protected final void adjustDownwards(double d2, double d3) {
        for (int i2 = 0; i2 < this.labels.size() - 1; ++i2) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i2);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(i2 + 1);
            if (!(pieLabelRecord2.getLowerY() < pieLabelRecord.getUpperY())) continue;
            pieLabelRecord2.setAllocatedY(Math.min(d2 + d3, pieLabelRecord.getUpperY() + this.minGap + pieLabelRecord2.getLabelHeight() / 2.0));
        }
    }

    protected final void adjustUpwards(double d2, double d3) {
        for (int i2 = this.labels.size() - 1; i2 > 0; --i2) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i2);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(i2 - 1);
            if (!(pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY())) continue;
            pieLabelRecord2.setAllocatedY(Math.max(d2, pieLabelRecord.getLowerY() - this.minGap - pieLabelRecord2.getLabelHeight() / 2.0));
        }
    }

    protected final void spreadEvenly(double d2, double d3) {
        double d4 = d2;
        double d5 = 0.0;
        for (int i2 = 0; i2 < this.labels.size(); ++i2) {
            d5 += this.getPieLabelRecord(i2).getLabelHeight();
        }
        double d6 = d3 - d5;
        if (this.labels.size() > 1) {
            d6 /= (double)(this.labels.size() - 1);
        }
        for (int i3 = 0; i3 < this.labels.size(); ++i3) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i3);
            pieLabelRecord.setAllocatedY(d4 += pieLabelRecord.getLabelHeight() / 2.0);
            d4 = d4 + pieLabelRecord.getLabelHeight() / 2.0 + d6;
        }
    }

    public final void sort() {
        Collections.sort(this.labels);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.labels.size(); ++i2) {
            stringBuffer.append(this.getPieLabelRecord(i2).toString()).append("\n");
        }
        return stringBuffer.toString();
    }
}

