/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart.ChartColor;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class DefaultDrawingSupplier
implements DrawingSupplier,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7339847061039422538L;
    public static final Paint[] DEFAULT_PAINT_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final Paint[] DEFAULT_OUTLINE_PAINT_SEQUENCE = new Paint[]{Color.lightGray};
    public static final Stroke[] DEFAULT_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Stroke[] DEFAULT_OUTLINE_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    private transient Paint[] paintSequence;
    private int paintIndex;
    private transient Paint[] outlinePaintSequence;
    private int outlinePaintIndex;
    private transient Stroke[] strokeSequence;
    private int strokeIndex;
    private transient Stroke[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private transient Shape[] shapeSequence;
    private int shapeIndex;

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(Paint[] paintArray, Paint[] paintArray2, Stroke[] strokeArray, Stroke[] strokeArray2, Shape[] shapeArray) {
        this.paintSequence = paintArray;
        this.outlinePaintSequence = paintArray2;
        this.strokeSequence = strokeArray;
        this.outlineStrokeSequence = strokeArray2;
        this.shapeSequence = shapeArray;
    }

    public Paint getNextPaint() {
        Paint paint = this.paintSequence[this.paintIndex % this.paintSequence.length];
        ++this.paintIndex;
        return paint;
    }

    public Paint getNextOutlinePaint() {
        Paint paint = this.outlinePaintSequence[this.outlinePaintIndex % this.outlinePaintSequence.length];
        ++this.outlinePaintIndex;
        return paint;
    }

    public Stroke getNextStroke() {
        Stroke stroke = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return stroke;
    }

    public Stroke getNextOutlineStroke() {
        Stroke stroke = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return stroke;
    }

    public Shape getNextShape() {
        Shape shape = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return shape;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] shapeArray = new Shape[10];
        double d2 = 6.0;
        double d3 = d2 / 2.0;
        int[] nArray = null;
        int[] nArray2 = null;
        shapeArray[0] = new Rectangle2D.Double(-d3, -d3, d2, d2);
        shapeArray[1] = new Ellipse2D.Double(-d3, -d3, d2, d2);
        nArray = DefaultDrawingSupplier.intArray(0.0, d3, -d3);
        nArray2 = DefaultDrawingSupplier.intArray(-d3, d3, d3);
        shapeArray[2] = new Polygon(nArray, nArray2, 3);
        nArray = DefaultDrawingSupplier.intArray(0.0, d3, 0.0, -d3);
        nArray2 = DefaultDrawingSupplier.intArray(-d3, 0.0, d3, 0.0);
        shapeArray[3] = new Polygon(nArray, nArray2, 4);
        shapeArray[4] = new Rectangle2D.Double(-d3, -d3 / 2.0, d2, d2 / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d3, d3, 0.0);
        nArray2 = DefaultDrawingSupplier.intArray(-d3, -d3, d3);
        shapeArray[5] = new Polygon(nArray, nArray2, 3);
        shapeArray[6] = new Ellipse2D.Double(-d3, -d3 / 2.0, d2, d2 / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d3, d3, -d3);
        nArray2 = DefaultDrawingSupplier.intArray(-d3, 0.0, d3);
        shapeArray[7] = new Polygon(nArray, nArray2, 3);
        shapeArray[8] = new Rectangle2D.Double(-d3 / 2.0, -d3, d2 / 2.0, d2);
        nArray = DefaultDrawingSupplier.intArray(-d3, d3, d3);
        nArray2 = DefaultDrawingSupplier.intArray(0.0, -d3, d3);
        shapeArray[9] = new Polygon(nArray, nArray2, 3);
        return shapeArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultDrawingSupplier)) {
            return false;
        }
        DefaultDrawingSupplier defaultDrawingSupplier = (DefaultDrawingSupplier)object;
        if (!Arrays.equals(this.paintSequence, defaultDrawingSupplier.paintSequence)) {
            return false;
        }
        if (this.paintIndex != defaultDrawingSupplier.paintIndex) {
            return false;
        }
        if (!Arrays.equals(this.outlinePaintSequence, defaultDrawingSupplier.outlinePaintSequence)) {
            return false;
        }
        if (this.outlinePaintIndex != defaultDrawingSupplier.outlinePaintIndex) {
            return false;
        }
        if (!Arrays.equals(this.strokeSequence, defaultDrawingSupplier.strokeSequence)) {
            return false;
        }
        if (this.strokeIndex != defaultDrawingSupplier.strokeIndex) {
            return false;
        }
        if (!Arrays.equals(this.outlineStrokeSequence, defaultDrawingSupplier.outlineStrokeSequence)) {
            return false;
        }
        if (this.outlineStrokeIndex != defaultDrawingSupplier.outlineStrokeIndex) {
            return false;
        }
        if (!this.equalShapes(this.shapeSequence, defaultDrawingSupplier.shapeSequence)) {
            return false;
        }
        return this.shapeIndex == defaultDrawingSupplier.shapeIndex;
    }

    private boolean equalShapes(Shape[] shapeArray, Shape[] shapeArray2) {
        if (shapeArray == null) {
            return shapeArray2 == null;
        }
        if (shapeArray2 == null) {
            return false;
        }
        if (shapeArray.length != shapeArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < shapeArray.length; ++i2) {
            if (ShapeUtilities.equal(shapeArray[i2], shapeArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        int n;
        int n2;
        int n3;
        int n4;
        objectOutputStream.defaultWriteObject();
        int n5 = this.paintSequence.length;
        objectOutputStream.writeInt(n5);
        for (n4 = 0; n4 < n5; ++n4) {
            SerialUtilities.writePaint(this.paintSequence[n4], objectOutputStream);
        }
        n4 = this.outlinePaintSequence.length;
        objectOutputStream.writeInt(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            SerialUtilities.writePaint(this.outlinePaintSequence[n3], objectOutputStream);
        }
        n3 = this.strokeSequence.length;
        objectOutputStream.writeInt(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            SerialUtilities.writeStroke(this.strokeSequence[n2], objectOutputStream);
        }
        n2 = this.outlineStrokeSequence.length;
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            SerialUtilities.writeStroke(this.outlineStrokeSequence[n], objectOutputStream);
        }
        n = this.shapeSequence.length;
        objectOutputStream.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            SerialUtilities.writeShape(this.shapeSequence[i2], objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        int n;
        int n2;
        int n3;
        int n4;
        objectInputStream.defaultReadObject();
        int n5 = objectInputStream.readInt();
        this.paintSequence = new Paint[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.paintSequence[n4] = SerialUtilities.readPaint(objectInputStream);
        }
        n4 = objectInputStream.readInt();
        this.outlinePaintSequence = new Paint[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.outlinePaintSequence[n3] = SerialUtilities.readPaint(objectInputStream);
        }
        n3 = objectInputStream.readInt();
        this.strokeSequence = new Stroke[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.strokeSequence[n2] = SerialUtilities.readStroke(objectInputStream);
        }
        n2 = objectInputStream.readInt();
        this.outlineStrokeSequence = new Stroke[n2];
        for (n = 0; n < n2; ++n) {
            this.outlineStrokeSequence[n] = SerialUtilities.readStroke(objectInputStream);
        }
        n = objectInputStream.readInt();
        this.shapeSequence = new Shape[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.shapeSequence[i2] = SerialUtilities.readShape(objectInputStream);
        }
    }

    private static int[] intArray(double d2, double d3, double d4) {
        return new int[]{(int)d2, (int)d3, (int)d4};
    }

    private static int[] intArray(double d2, double d3, double d4, double d5) {
        return new int[]{(int)d2, (int)d3, (int)d4, (int)d5};
    }

    public Object clone() {
        DefaultDrawingSupplier defaultDrawingSupplier = (DefaultDrawingSupplier)super.clone();
        return defaultDrawingSupplier;
    }
}

