/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import org.jfree.chart.block.LengthConstraintType;
import org.jfree.data.Range;
import org.jfree.ui.Size2D;

public class RectangleConstraint {
    public static final RectangleConstraint NONE = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 0.0, null, LengthConstraintType.NONE);
    private double width;
    private Range widthRange;
    private LengthConstraintType widthConstraintType;
    private double height;
    private Range heightRange;
    private LengthConstraintType heightConstraintType;

    public RectangleConstraint(double d2, double d3) {
        this(d2, null, LengthConstraintType.FIXED, d3, null, LengthConstraintType.FIXED);
    }

    public RectangleConstraint(Range range, Range range2) {
        this(0.0, range, LengthConstraintType.RANGE, 0.0, range2, LengthConstraintType.RANGE);
    }

    public RectangleConstraint(Range range, double d2) {
        this(0.0, range, LengthConstraintType.RANGE, d2, null, LengthConstraintType.FIXED);
    }

    public RectangleConstraint(double d2, Range range) {
        this(d2, null, LengthConstraintType.FIXED, 0.0, range, LengthConstraintType.RANGE);
    }

    public RectangleConstraint(double d2, Range range, LengthConstraintType lengthConstraintType, double d3, Range range2, LengthConstraintType lengthConstraintType2) {
        if (lengthConstraintType == null) {
            throw new IllegalArgumentException("Null 'widthType' argument.");
        }
        if (lengthConstraintType2 == null) {
            throw new IllegalArgumentException("Null 'heightType' argument.");
        }
        this.width = d2;
        this.widthRange = range;
        this.widthConstraintType = lengthConstraintType;
        this.height = d3;
        this.heightRange = range2;
        this.heightConstraintType = lengthConstraintType2;
    }

    public final double getWidth() {
        return this.width;
    }

    public final Range getWidthRange() {
        return this.widthRange;
    }

    public final LengthConstraintType getWidthConstraintType() {
        return this.widthConstraintType;
    }

    public final double getHeight() {
        return this.height;
    }

    public final Range getHeightRange() {
        return this.heightRange;
    }

    public final LengthConstraintType getHeightConstraintType() {
        return this.heightConstraintType;
    }

    public final RectangleConstraint toUnconstrainedWidth() {
        if (this.widthConstraintType == LengthConstraintType.NONE) {
            return this;
        }
        return new RectangleConstraint(this.width, this.widthRange, LengthConstraintType.NONE, this.height, this.heightRange, this.heightConstraintType);
    }

    public final RectangleConstraint toUnconstrainedHeight() {
        if (this.heightConstraintType == LengthConstraintType.NONE) {
            return this;
        }
        return new RectangleConstraint(this.width, this.widthRange, this.widthConstraintType, 0.0, this.heightRange, LengthConstraintType.NONE);
    }

    public final RectangleConstraint toFixedWidth(double d2) {
        return new RectangleConstraint(d2, this.widthRange, LengthConstraintType.FIXED, this.height, this.heightRange, this.heightConstraintType);
    }

    public final RectangleConstraint toFixedHeight(double d2) {
        return new RectangleConstraint(this.width, this.widthRange, this.widthConstraintType, d2, this.heightRange, LengthConstraintType.FIXED);
    }

    public final RectangleConstraint toRangeWidth(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        return new RectangleConstraint(range.getUpperBound(), range, LengthConstraintType.RANGE, this.height, this.heightRange, this.heightConstraintType);
    }

    public final RectangleConstraint toRangeHeight(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        return new RectangleConstraint(this.width, this.widthRange, this.widthConstraintType, range.getUpperBound(), range, LengthConstraintType.RANGE);
    }

    public final String toString() {
        return "RectangleConstraint[" + this.widthConstraintType.toString() + ": width=" + this.width + ", height=" + this.height + "]";
    }

    public final Size2D calculateConstrainedSize(Size2D size2D) {
        Size2D size2D2 = new Size2D();
        if (this.widthConstraintType == LengthConstraintType.NONE) {
            size2D2.width = size2D.width;
            if (this.heightConstraintType == LengthConstraintType.NONE) {
                size2D2.height = size2D.height;
            } else if (this.heightConstraintType == LengthConstraintType.RANGE) {
                size2D2.height = this.heightRange.constrain(size2D.height);
            } else if (this.heightConstraintType == LengthConstraintType.FIXED) {
                size2D2.height = this.height;
            }
        } else if (this.widthConstraintType == LengthConstraintType.RANGE) {
            size2D2.width = this.widthRange.constrain(size2D.width);
            if (this.heightConstraintType == LengthConstraintType.NONE) {
                size2D2.height = size2D.height;
            } else if (this.heightConstraintType == LengthConstraintType.RANGE) {
                size2D2.height = this.heightRange.constrain(size2D.height);
            } else if (this.heightConstraintType == LengthConstraintType.FIXED) {
                size2D2.height = this.height;
            }
        } else if (this.widthConstraintType == LengthConstraintType.FIXED) {
            size2D2.width = this.width;
            if (this.heightConstraintType == LengthConstraintType.NONE) {
                size2D2.height = size2D.height;
            } else if (this.heightConstraintType == LengthConstraintType.RANGE) {
                size2D2.height = this.heightRange.constrain(size2D.height);
            } else if (this.heightConstraintType == LengthConstraintType.FIXED) {
                size2D2.height = this.height;
            }
        }
        return size2D2;
    }
}

