/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintUtilities;

public class SymbolAxis
extends NumberAxis
implements Serializable {
    private static final long serialVersionUID = 7216330468770619716L;
    public static final Paint DEFAULT_GRID_BAND_PAINT = new Color(232, 234, 232, 128);
    private List symbols;
    private transient Paint gridBandPaint;
    private boolean gridBandsVisible;

    public SymbolAxis(String string, String[] stringArray) {
        super(string);
        this.symbols = Arrays.asList(stringArray);
        this.gridBandsVisible = true;
        this.gridBandPaint = DEFAULT_GRID_BAND_PAINT;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbols() {
        String[] stringArray = new String[this.symbols.size()];
        stringArray = this.symbols.toArray(stringArray);
        return stringArray;
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isGridBandsVisible() {
        return this.gridBandsVisible;
    }

    public void setGridBandsVisible(boolean bl) {
        if (this.gridBandsVisible != bl) {
            this.gridBandsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        throw new UnsupportedOperationException();
    }

    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = new AxisState(d2);
        if (this.isVisible()) {
            axisState = super.draw(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        }
        if (this.gridBandsVisible) {
            this.drawGridBands(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState.getTicks());
        }
        return axisState;
    }

    protected void drawGridBands(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, List list) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.drawGridBandsHorizontal(graphics2D, rectangle2D, rectangle2D2, true, list);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.drawGridBandsVertical(graphics2D, rectangle2D, rectangle2D2, true, list);
        }
        graphics2D.setClip(shape);
    }

    protected void drawGridBandsHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        boolean bl2 = bl;
        double d2 = rectangle2D2.getY();
        double d3 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueTick valueTick = (ValueTick)iterator.next();
            double d4 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            double d5 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            if (bl2) {
                graphics2D.setPaint(this.gridBandPaint);
            } else {
                graphics2D.setPaint(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d2 + d3, d5 - d4, rectangle2D2.getMaxY() - d2 - d3);
            graphics2D.fill(double_);
            bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    protected void drawGridBandsVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        boolean bl2 = bl;
        double d2 = rectangle2D2.getX();
        double d3 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueTick valueTick = (ValueTick)iterator.next();
            double d4 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.LEFT);
            double d5 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.LEFT);
            if (bl2) {
                graphics2D.setPaint(this.gridBandPaint);
            } else {
                graphics2D.setPaint(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 + d3, d4, rectangle2D2.getMaxX() - d2 - d3, d5 - d4);
            graphics2D.fill(double_);
            bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d2;
            double d3;
            double d4 = this.symbols.size() - 1;
            double d5 = d4 - (d3 = 0.0);
            if (d5 < (d2 = this.getAutoRangeMinimumSize())) {
                d4 = (d4 + d3 + d2) / 2.0;
                d3 = (d4 + d3 - d2) / 2.0;
            }
            double d6 = 0.5;
            double d7 = 0.5;
            if (this.getAutoRangeIncludesZero()) {
                if (this.getAutoRangeStickyZero()) {
                    d4 = d4 <= 0.0 ? 0.0 : (d4 += d6);
                    d3 = d3 >= 0.0 ? 0.0 : (d3 -= d7);
                } else {
                    d4 = Math.max(0.0, d4 + d6);
                    d3 = Math.min(0.0, d3 - d7);
                }
            } else if (this.getAutoRangeStickyZero()) {
                d4 = d4 <= 0.0 ? Math.min(0.0, d4 + d6) : (d4 += d6 * d5);
                d3 = d3 >= 0.0 ? Math.max(0.0, d3 - d7) : (d3 -= d7);
            } else {
                d4 += d6;
                d3 -= d7;
            }
            this.setRange(new Range(d3, d4), false, false);
        }
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        double d4 = 0.0;
        double d5 = 0.0;
        if (n <= 500) {
            for (int i2 = 0; i2 < n; ++i2) {
                double d6 = d3 + (double)i2 * d2;
                double d7 = this.valueToJava2D(d6, rectangle2D, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d6) : this.valueToString(d6);
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d8 = this.isVerticalTickLabels() ? rectangle2D2.getHeight() : rectangle2D2.getWidth();
                boolean bl = false;
                if (i2 > 0) {
                    double d9 = (d5 + d8) / 2.0;
                    if (Math.abs(d7 - d4) < d9) {
                        bl = true;
                    }
                }
                if (bl) {
                    string = "";
                } else {
                    d4 = d7;
                    d5 = d8;
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d10 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    d10 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d6), string, textAnchor, textAnchor2, d10);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        double d4 = 0.0;
        double d5 = 0.0;
        if (n <= 500) {
            for (int i2 = 0; i2 < n; ++i2) {
                double d6 = d3 + (double)i2 * d2;
                double d7 = this.valueToJava2D(d6, rectangle2D, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d6) : this.valueToString(d6);
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d8 = this.isVerticalTickLabels() ? rectangle2D2.getWidth() : rectangle2D2.getHeight();
                boolean bl = false;
                if (i2 > 0) {
                    double d9 = (d5 + d8) / 2.0;
                    if (Math.abs(d7 - d4) < d9) {
                        bl = true;
                    }
                    if (bl) {
                        string = "";
                    } else {
                        d4 = d7;
                        d5 = d8;
                    }
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d10 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    d10 = rectangleEdge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d6), string, textAnchor, textAnchor2, d10);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    public String valueToString(double d2) {
        String string;
        try {
            string = (String)this.symbols.get((int)d2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SymbolAxis)) {
            return false;
        }
        SymbolAxis symbolAxis = (SymbolAxis)object;
        if (!((Object)this.symbols).equals(symbolAxis.symbols)) {
            return false;
        }
        if (this.gridBandsVisible != symbolAxis.gridBandsVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.gridBandPaint, symbolAxis.gridBandPaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.gridBandPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.gridBandPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

