/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.ShapeUtilities;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5886554608114265863L;
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private int maximumCategoryLabelLines = 1;
    private float maximumCategoryLabelWidthRatio = 0.0f;
    private int categoryLabelPositionOffset;
    private CategoryLabelPositions categoryLabelPositions;
    private Map tickLabelFontMap;
    private transient Map tickLabelPaintMap;
    private Map categoryLabelToolTips;

    public CategoryAxis() {
        this(null);
    }

    public CategoryAxis(String string) {
        super(string);
        this.setTickMarksVisible(false);
        this.categoryLabelPositionOffset = 4;
        this.categoryLabelPositions = CategoryLabelPositions.STANDARD;
        this.tickLabelFontMap = new HashMap();
        this.tickLabelPaintMap = new HashMap();
        this.categoryLabelToolTips = new HashMap();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d2) {
        this.lowerMargin = d2;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d2) {
        this.upperMargin = d2;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d2) {
        this.categoryMargin = d2;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getMaximumCategoryLabelLines() {
        return this.maximumCategoryLabelLines;
    }

    public void setMaximumCategoryLabelLines(int n) {
        this.maximumCategoryLabelLines = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMaximumCategoryLabelWidthRatio() {
        return this.maximumCategoryLabelWidthRatio;
    }

    public void setMaximumCategoryLabelWidthRatio(float f2) {
        this.maximumCategoryLabelWidthRatio = f2;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int n) {
        this.categoryLabelPositionOffset = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions categoryLabelPositions) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'positions' argument.");
        }
        this.categoryLabelPositions = categoryLabelPositions;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Font getTickLabelFont(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        Font font = (Font)this.tickLabelFontMap.get(comparable);
        if (font == null) {
            font = this.getTickLabelFont();
        }
        return font;
    }

    public void setTickLabelFont(Comparable comparable, Font font) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (font == null) {
            this.tickLabelFontMap.remove(comparable);
        } else {
            this.tickLabelFontMap.put(comparable, font);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getTickLabelPaint(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        Paint paint = (Paint)this.tickLabelPaintMap.get(comparable);
        if (paint == null) {
            paint = this.getTickLabelPaint();
        }
        return paint;
    }

    public void setTickLabelPaint(Comparable comparable, Paint paint) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (paint == null) {
            this.tickLabelPaintMap.remove(comparable);
        } else {
            this.tickLabelPaintMap.put(comparable, paint);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addCategoryLabelToolTip(Comparable comparable, String string) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.put(comparable, string);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public String getCategoryLabelToolTip(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        return (String)this.categoryLabelToolTips.get(comparable);
    }

    public void removeCategoryLabelToolTip(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.remove(comparable);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void clearCategoryLabelToolTips() {
        this.categoryLabelToolTips.clear();
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        if (categoryAnchor == CategoryAnchor.START) {
            d2 = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.MIDDLE) {
            d2 = this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.END) {
            d2 = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        }
        return d2;
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        }
        double d3 = this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
        double d4 = this.calculateCategoryGapSize(n2, rectangle2D, rectangleEdge);
        return d2 += (double)n * (d3 + d4);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
    }

    protected double calculateCategorySize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d3 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d3 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d2 = d3 * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d2 /= (double)n;
        } else {
            d2 = d3 * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d2;
    }

    protected double calculateCategoryGapSize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d3 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d3 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d2 = d3 * this.getCategoryMargin() / (double)(n - 1);
        }
        return d2;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = new AxisState();
            this.refreshTicks(graphics2D, (AxisState)object, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                d2 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d2 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d3 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d3 = ((AxisState)object).getMax();
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = ((RectangularShape)object).getHeight();
            axisSpace.add(d4 + d2 + (double)this.categoryLabelPositionOffset, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = ((RectangularShape)object).getWidth();
            axisSpace.add(d5 + d3 + (double)this.categoryLabelPositionOffset, rectangleEdge);
        }
        return axisSpace;
    }

    public void configure() {
    }

    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            return new AxisState(d2);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d2, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d2);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        return this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D, rectangleEdge, axisState, plotRenderingInfo);
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        if (axisState == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangleEdge);
            axisState.setTicks(list);
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityCollection entityCollection;
                CategoryTick categoryTick = (CategoryTick)iterator.next();
                graphics2D.setFont(this.getTickLabelFont(categoryTick.getCategory()));
                graphics2D.setPaint(this.getTickLabelPaint(categoryTick.getCategory()));
                CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                if (rectangleEdge == RectangleEdge.TOP) {
                    d2 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d5 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d4 = d5 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                    d2 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d5 = d4 + axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    d4 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d5 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d2 = d3 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.RIGHT) {
                    d4 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d5 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d3 = d2 - axisState.getMax();
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
                Point2D point2D = RectangleAnchor.coordinates(double_, categoryLabelPosition.getCategoryAnchor());
                TextBlock textBlock = categoryTick.getLabel();
                textBlock.draw(graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getLabelAnchor(), (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getAngle());
                Shape shape = textBlock.calculateBounds(graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getLabelAnchor(), (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getAngle());
                if (plotRenderingInfo != null && plotRenderingInfo.getOwner() != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                    String string = this.getCategoryLabelToolTip(categoryTick.getCategory());
                    entityCollection.add(new TickLabelEntity(shape, string, null));
                }
                ++n;
            }
            if (rectangleEdge.equals(RectangleEdge.TOP)) {
                double d6 = axisState.getMax();
                axisState.cursorUp(d6);
            } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
                double d7 = axisState.getMax();
                axisState.cursorDown(d7);
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                double d8 = axisState.getMax();
                axisState.cursorLeft(d8);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double d9 = axisState.getMax();
                axisState.cursorRight(d9);
            }
        }
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<CategoryTick> arrayList = new ArrayList<CategoryTick>();
        if (rectangle2D.getHeight() <= 0.0 || rectangle2D.getWidth() < 0.0) {
            return arrayList;
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategories();
        double d2 = 0.0;
        if (list != null) {
            CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
            float f2 = this.maximumCategoryLabelWidthRatio;
            if ((double)f2 <= 0.0) {
                f2 = categoryLabelPosition.getWidthRatio();
            }
            float f3 = 0.0f;
            f3 = categoryLabelPosition.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(list.size(), rectangle2D, rectangleEdge) : (RectangleEdge.isLeftOrRight(rectangleEdge) ? (float)rectangle2D.getWidth() : (float)rectangle2D.getHeight());
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                TextBlock textBlock = this.createLabel(comparable, f3 * f2, rectangleEdge, graphics2D);
                if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                    d2 = Math.max(d2, this.calculateTextBlockHeight(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                    d2 = Math.max(d2, this.calculateTextBlockWidth(textBlock, categoryLabelPosition, graphics2D));
                }
                CategoryTick categoryTick = new CategoryTick(comparable, textBlock, categoryLabelPosition.getLabelAnchor(), categoryLabelPosition.getRotationAnchor(), categoryLabelPosition.getAngle());
                arrayList.add(categoryTick);
                ++n;
            }
        }
        axisState.setMax(d2);
        return arrayList;
    }

    protected TextBlock createLabel(Comparable comparable, float f2, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = TextUtilities.createTextBlock(comparable.toString(), this.getTickLabelFont(comparable), this.getTickLabelPaint(comparable), f2, this.maximumCategoryLabelLines, new G2TextMeasurer(graphics2D));
        return textBlock;
    }

    protected double calculateTextBlockWidth(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtilities.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d2 = shape.getBounds2D().getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        return d2;
    }

    protected double calculateTextBlockHeight(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtilities.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d2 = shape.getBounds2D().getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        return d2;
    }

    public Object clone() {
        CategoryAxis categoryAxis = (CategoryAxis)super.clone();
        categoryAxis.tickLabelFontMap = new HashMap(this.tickLabelFontMap);
        categoryAxis.tickLabelPaintMap = new HashMap(this.tickLabelPaintMap);
        categoryAxis.categoryLabelToolTips = new HashMap(this.categoryLabelToolTips);
        return categoryAxis;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryAxis)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CategoryAxis categoryAxis = (CategoryAxis)object;
        if (categoryAxis.lowerMargin != this.lowerMargin) {
            return false;
        }
        if (categoryAxis.upperMargin != this.upperMargin) {
            return false;
        }
        if (categoryAxis.categoryMargin != this.categoryMargin) {
            return false;
        }
        if (categoryAxis.maximumCategoryLabelWidthRatio != this.maximumCategoryLabelWidthRatio) {
            return false;
        }
        if (categoryAxis.categoryLabelPositionOffset != this.categoryLabelPositionOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(categoryAxis.categoryLabelPositions, this.categoryLabelPositions)) {
            return false;
        }
        if (!ObjectUtilities.equal(categoryAxis.categoryLabelToolTips, this.categoryLabelToolTips)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelFontMap, categoryAxis.tickLabelFontMap)) {
            return false;
        }
        return this.equalPaintMaps(this.tickLabelPaintMap, categoryAxis.tickLabelPaintMap);
    }

    public int hashCode() {
        if (this.getLabel() != null) {
            return this.getLabel().hashCode();
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        this.writePaintMap(this.tickLabelPaintMap, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.tickLabelPaintMap = this.readPaintMap(objectInputStream);
    }

    private Map readPaintMap(ObjectInputStream objectInputStream) {
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            return null;
        }
        HashMap<Comparable, Paint> hashMap = new HashMap<Comparable, Paint>();
        int n = objectInputStream.readInt();
        for (int i2 = 0; i2 < n; ++i2) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Paint paint = SerialUtilities.readPaint(objectInputStream);
            hashMap.put(comparable, paint);
        }
        return hashMap;
    }

    private void writePaintMap(Map map, ObjectOutputStream objectOutputStream) {
        if (map == null) {
            objectOutputStream.writeBoolean(true);
        } else {
            objectOutputStream.writeBoolean(false);
            Set set = map.keySet();
            int n = set.size();
            objectOutputStream.writeInt(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                objectOutputStream.writeObject(comparable);
                SerialUtilities.writePaint((Paint)map.get(comparable), objectOutputStream);
            }
        }
    }

    private boolean equalPaintMaps(Map map, Map map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Paint paint;
            Comparable comparable = (Comparable)iterator.next();
            Paint paint2 = (Paint)map.get(comparable);
            if (PaintUtilities.equal(paint2, paint = (Paint)map2.get(comparable))) continue;
            return false;
        }
        return true;
    }
}

