/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;

public abstract class ChartUtilities {
    public static final void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null);
    }

    public static final void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, boolean bl, int n3) {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null, bl, n3);
    }

    public static final void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream);
    }

    public static final void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, 2, chartRenderingInfo);
        ChartUtilities.writeBufferedImageAsPNG(outputStream, bufferedImage, bl, n3);
    }

    public static final void writeScaledChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        double d2 = n * n3;
        double d3 = n2 * n4;
        double d4 = n;
        double d5 = n2;
        boolean bl = false;
        if (n3 != 1 || n4 != 1) {
            bl = true;
        }
        double d6 = d2 / d4;
        double d7 = d3 / d5;
        BufferedImage bufferedImage = new BufferedImage((int)d2, (int)d3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getScaleInstance(d6, d7));
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d4, d5), null, null);
            graphics2D.setTransform(affineTransform);
            graphics2D.dispose();
        } else {
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d4, d5), null, null);
        }
        outputStream.write(ChartUtilities.encodeAsPNG(bufferedImage));
    }

    public static final void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, null);
    }

    public static final void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static final void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo, bl, n3);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static final void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.writeChartAsJPEG(outputStream, jFreeChart, n, n2, null);
    }

    public static final void writeChartAsJPEG(OutputStream outputStream, float f2, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.writeChartAsJPEG(outputStream, f2, jFreeChart, n, n2, null);
    }

    public static final void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream);
    }

    public static final void writeChartAsJPEG(OutputStream outputStream, float f2, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream, f2);
    }

    public static final void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.saveChartAsJPEG(file, jFreeChart, n, n2, null);
    }

    public static final void saveChartAsJPEG(File file, float f2, JFreeChart jFreeChart, int n, int n2) {
        ChartUtilities.saveChartAsJPEG(file, f2, jFreeChart, n, n2, null);
    }

    public static final void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG((OutputStream)bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static final void saveChartAsJPEG(File file, float f2, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(bufferedOutputStream, f2, jFreeChart, n, n2, chartRenderingInfo);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static final void writeBufferedImageAsJPEG(OutputStream outputStream, BufferedImage bufferedImage) {
        ChartUtilities.writeBufferedImageAsJPEG(outputStream, 0.75f, bufferedImage);
    }

    public static final void writeBufferedImageAsJPEG(OutputStream outputStream, float f2, BufferedImage bufferedImage) {
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream, f2);
    }

    public static final void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage) {
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream);
    }

    public static final void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage, boolean bl, int n) {
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream, n, bl);
    }

    public static final byte[] encodeAsPNG(BufferedImage bufferedImage) {
        return EncoderUtil.encode(bufferedImage, "png");
    }

    public static final byte[] encodeAsPNG(BufferedImage bufferedImage, boolean bl, int n) {
        return EncoderUtil.encode(bufferedImage, "png", n, bl);
    }

    public static final void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, boolean bl) {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = null;
        toolTipTagFragmentGenerator = bl ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static final void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        printWriter.println(ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator));
    }

    public static final String getImageMap(String string, ChartRenderingInfo chartRenderingInfo) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static final String getImageMap(String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator);
    }
}

